MODULE FileBack;

(****************************************************************************
 *
 * PlugIn fr GEMAR
 * Daten in Datei sichern.
 *
 * $Source$
 *
 * $Revision$
 *
 * $Author$
 *
 * $Date$
 *
 * $State$
 *
 *****************************************************************************
 * History:
 *
 * $Log$
 *
 *
 ****************************************************************************)



(* Systemabhngiges *)
(* IMPLEMENTATION FR  >>> Hnisch-Modula-2 <<< *)
(*																							*)
(* Durchgefhrt von Steffen Engel 							*)
(*																							*)
(*$S- 	Stack-Checks														*)
(*$I- 	keine Variablen-Initialisierung 				*)
(*$V- 	keine arithmetischen Kontrollen 				*)
(*$T- 	kein Bereichstest 											*)
(*$Y- 	keine Laufzeittests auf RETURN und CASE *)
(*																							*)
(*----------------------------------------------*)

IMPORT SYSTEM, System;
FROM SYSTEM IMPORT BYTE;

IMPORT CPX;

(* Standard HM2-Libs *)
IMPORT Str, Block, form, fsel, Paths;


(* Magic-Lib *)
FROM MagicSys 	IMPORT
								(* Const *) Nil, Null, Bit0, Bit1, Bit2, Bit3, Bit4, Bit5,
														Bit6, Bit7, Bit8, Bit9, Bit10, Bit11, Bit12,
														Bit13, Bit14, Bit15,
								(* Type  *) LOC, Byte, ByteSet, sWORD, sINTEGER, sCARDINAL,
														sBITSET, lINTEGER, lCARDINAL, lWORD, lBITSET;

(* Magic-Tools *)

(* Eigene Libs *)
IMPORT C_Port;

(* Projektlibs *)

IMPORT MagicStrings, MagicDOS, void;

IMPORT PlugParms;


TYPE
		(* Die Struktur, die von GEMAR geliefert wird *)
		tScsiCmd		= RECORD
										Handle			: SHORTCARD;
										Cmd 				: SYSTEM.ADDRESS;
										CmdLen			: SHORTCARD;
										Buffer			: SYSTEM.ADDRESS;
										Transferlen : LONGCARD;
										ReqBuffer 	: SYSTEM.ADDRESS;
										Timeout 		: LONGCARD;
										Flags 			: sBITSET;
									END;
		tpScsiCmd 	= POINTER TO tScsiCmd;

		tpPlugParms = POINTER TO tPlugParms;
		tPlugParms	= RECORD
										Version 	: SHORTCARD;					(* = 0200H = 2.00 *)
										special 	: SYSTEM.ADDRESS; 		(* Spezielles fr Art des PlugIn *)
										StrHandle : SHORTCARD;
										StrMaxLen : LONGCARD;
										BlockLen	: SHORTCARD;
										ScsiIn		: PROCEDURE ((* ScsiCmd *) tpScsiCmd) : SHORTINT;
										ScsiOut 	: PROCEDURE ((* ScsiCmd *) tpScsiCmd) : SHORTINT;
										SuperOn 	: PROC;
										SuperOff	: PROC;
									END;

			UChar 			= [0..255];
			tpCmdBlock	= POINTER TO tCmdBlock;
			tCmdBlock 	= RECORD
											Command : UChar;
											Lun 		: UChar;
											Adr 		: SHORTCARD;
											Len 		: UChar;
											Flags 	: BYTE;
										END;	

VAR PlugEnv 		: PlugParms.tpPlugEnvironment;
		PlugPrivate : tpPlugParms;
		PlugProcs 	: RECORD
										num  : SHORTINT;
										Proc : ARRAY[0..1] OF PlugParms.tPlugProc;
									END;

VAR BlockSize : LONGCARD;
		handle		: SHORTINT;
		FileIsNew : BOOLEAN;
		FileName	: ARRAY[0..256] OF CHAR;



(* Abfangen von Space *)
CONST SpaceBlock				= 0;
			SpaceMark 				= 1;
			SpaceSerie				= 2;
			SpaceEnd					= 3;
			SpaceSetmarks 		= 4;

PROCEDURE Max(a, b : LONGCARD) : LONGCARD;


	BEGIN

		IF a > b

			THEN

				RETURN a;

			ELSE

				RETURN b;

			END;

	END Max;
PROCEDURE Min(a, b : LONGCARD) : LONGCARD;


	BEGIN

		IF a < b

			THEN

				RETURN a;

			ELSE

				RETURN b;

			END;

	END Min;

PROCEDURE Rewind() : SHORTINT;

VAR ret : SHORTINT;


	BEGIN

		ret := 0;

		IF (handle >= 0) AND FileIsNew

			THEN

				VOID(MagicDOS.Fclose(handle));

				handle := MagicDOS.Fopen(FileName, {MagicDOS.ReadWrite});

				FileIsNew := FALSE;

				IF handle < 0

					THEN

						ret := 2;

					END;

			END;


		IF (handle < 0) OR (MagicDOS.Fseek(0, handle, MagicDOS.SeekStart) # 0)

			THEN

				ret := 2;

			END;


		RETURN ret;


	END Rewind;

PROCEDURE Read(SCmd : tpCmdBlock; pCmd : tpScsiCmd) : SHORTINT;


	BEGIN

		RETURN 2;

	END Read;

PROCEDURE WriteFileMark(SCmd : tpCmdBlock) : SHORTINT;


	BEGIN

		RETURN 2;

	END WriteFileMark;

PROCEDURE Write(SCmd : tpCmdBlock; pCmd : tpScsiCmd) : SHORTINT;


	BEGIN

		RETURN 0;

	END Write;

PROCEDURE Space(SCmd : tpCmdBlock) : SHORTINT;


	BEGIN

		IF handle < 0

			THEN

				RETURN 2;

			ELSE

				RETURN 0;

			END;

	END Space;

PROCEDURE Load(DoLoad : BOOLEAN) : SHORTINT;
VAR path : ARRAY[0..256] OF CHAR;
		name : ARRAY[0..32] OF CHAR;
		ret  : SHORTINT;

	BEGIN
		path := '';
		name := '';
		ret := 0;
		PlugPrivate^.SuperOff;

		IF DoLoad
			THEN
				FileIsNew := FALSE;
		
				IF fsel.exinput(path, name, 'Sicherungsdatei whlen')
					THEN
						Paths.GetPurePath(path, FileName);
						Str.Concat(FileName, name);
						handle := MagicDOS.Fopen(FileName, {MagicDOS.ReadWrite});
						IF handle < 0
							THEN
								FileIsNew := TRUE;
								handle := MagicDOS.Fcreate(FileName, {});
							END;
		
						IF handle < 0
							THEN
								ret := 2;
							END;
					ELSE
						ret := 2;
					END;
			ELSE
				(* Band entladen *)
				IF handle >= 0
					THEN
						VOID(MagicDOS.Fclose(handle));
						ret := 0;
					ELSE
						ret := 2;
					END;
			END;

		PlugPrivate^.SuperOn;

		RETURN ret;
	END Load;

PROCEDURE Inquiry(SCmd : tpCmdBlock; pCmd : tpScsiCmd) : SHORTINT;

VAR tInq	:  RECORD

							 Device 				 : C_Port.UChar;

							 DeviceQualifier : BYTE;

							 VersionFlags 	 : BYTE;

							 FormatFlags		 : BYTE;

							 AdditionalLen	 : C_Port.UChar;

							 Res1 					 : BYTE;

							 Reserved 			 : ARRAY[6..7] OF BYTE;

							 Vendor 				 : ARRAY[0..7] OF CHAR;

							 Product				 : ARRAY[0..15] OF CHAR;

							 RevionsData		 : ARRAY[0..3] OF CHAR;

						 END;


	BEGIN

		WITH tInq DO

			Device := 1;

			DeviceQualifier := BYTE(0);

			VersionFlags := BYTE(0);

			FormatFlags := BYTE(0);

			Res1 := BYTE(0);

			AdditionalLen := VAL(C_Port.UChar, SIZE(tInq)-5);

			Reserved[6] := BYTE(0);

			Reserved[7] := BYTE(0);

			Vendor := 'GEMAR  ';

			Vendor[7] := ' ';

			Product := 'FILEBACKUP     ';

			Product[15] := ' ';

			RevionsData := '000';

			RevionsData[3] := ' ';

		END;

		Block.Move(SYSTEM.ADR(tInq), pCmd^.Buffer, Min(SIZE(tInq), pCmd^.Transferlen));

		RETURN 0;

	END Inquiry;

PROCEDURE RequestSense(SCmd : tpCmdBlock; pCmd : tpScsiCmd) : SHORTINT;


	BEGIN

		RETURN 2;

	END RequestSense;

PROCEDURE ModeSense(SCmd : tpCmdBlock; pCmd : tpScsiCmd):SHORTINT;

VAR mSel : RECORD

						 Reserved 			 : BYTE;

						 MediumType 		 : C_Port.UChar;

						 StreamerFlags	 : C_Port.UChar;

						 BlockDescLen 	 : C_Port.UChar;

						 Blocks 				 : LONGCARD;

						 BlockLen 			 : LONGCARD;

					 END;


	BEGIN

		Block.Clear(SYSTEM.ADR(mSel), SIZE(mSel));

		WITH mSel DO

			Blocks := 0;

			BlockLen := BlockSize;

		END;

		Block.Move(SYSTEM.ADR(mSel), pCmd^.Buffer, Min(SIZE(mSel), pCmd^.Transferlen));

		RETURN 0;

	END ModeSense;

PROCEDURE ModeSelect(SCmd : tpCmdBlock; pCmd : tpScsiCmd):SHORTINT;

VAR pmSel : POINTER TO RECORD

						 Reserved 			 : BYTE;

						 MediumType 		 : C_Port.UChar;

						 StreamerFlags	 : C_Port.UChar;

						 BlockDescLen 	 : C_Port.UChar;

						 Blocks 				 : LONGCARD;

						 BlockLen 			 : LONGCARD;

					 END;


	BEGIN

		pmSel := pCmd^.Buffer;

		BlockSize := pmSel^.BlockLen;

		RETURN 0;

	END ModeSelect;


(*$K+ $E+ *)
PROCEDURE ScsiIn(pCmd : tpScsiCmd) : SHORTINT;
VAR SCmd : tpCmdBlock;

	BEGIN
		(* in dem Slot wird auch deinitialisiert *)
		IF pCmd = SYSTEM.ADDRESS(-1)
			THEN
				RETURN 0;
			END;

		(* Hier kann abgefangen werden *)
		SCmd := tpCmdBlock(pCmd^.Cmd);

		CASE SCmd^.Command OF
			|00H: RETURN 0;  (* Unit Ready *)
			|01H: RETURN Rewind();
			|03H: RETURN RequestSense(SCmd, pCmd);
			|08H: RETURN Read(SCmd, pCmd);
			|10H: RETURN WriteFileMark(SCmd);
			|11H: RETURN Space(SCmd);
			|12H: RETURN Inquiry(SCmd, pCmd);
			|1AH: RETURN ModeSense(SCmd, pCmd);
			|1BH: RETURN Load(Bit0 IN BYTESET(SCmd^.Len));
			|1EH: RETURN 0;  (* Prevent/Allow Media Removal *)
			ELSE
				RETURN 2;
		END;
	END ScsiIn;
(*$K= $E+ *)

(*$K+ $E+ *)
PROCEDURE ScsiOut(pCmd : tpScsiCmd) : SHORTINT;

VAR SCmd : tpCmdBlock;


	BEGIN

		SCmd := tpCmdBlock(pCmd^.Cmd);

		(* Hier kann abgefangen werden *)

		CASE SCmd^.Command OF

			|0AH: RETURN Write(SCmd, pCmd);

			|15H: RETURN ModeSelect(SCmd, pCmd);

			ELSE

				RETURN 2;

		END;

	END ScsiOut;
(*$K= $E+ *)



BEGIN

	PlugEnv := PlugParms.tpPlugEnvironment(CPX.pXCPB);
	IF PlugEnv^.Version # PlugParms.ParmVersion
		THEN
			VOID(form.alert(1, '[3][PlugIn: falsche Parameterversion][Abbruch]'));
			CPX.Return(NIL);
		END;

	PlugPrivate := PlugEnv^.Private;

	IF PlugPrivate^.Version # 0200H
		THEN
			void.I := PlugEnv^.Alert(1, '[3][PlugIn (Space):|falsche Parameterversion][Aha]');
			CPX.Return(NIL);
		ELSE
			WITH PlugProcs DO
				num := 2;
				Proc[0] := PlugParms.tPlugProc(ScsiIn);
				Proc[1] := PlugParms.tPlugProc(ScsiOut);
			END;

			(* Daten initialisieren *)
			BlockSize := 512;
			handle := -1;


			CPX.Return(SYSTEM.ADR(PlugProcs));
		END;

END FileBack.
		
	
	