MODULE Locate;
(****************************************************************************
 *
 *	Beschreibung	: Adaption der QFA-Kommandos an problematische
 *									Streamer.
 *									Dieses ist fr Locate auf TDC 4200 mit SCSI-2-Firm-
 *									ware
 *
 * $Source: /dev/e/hm2/user/gemar/plugin\RCS\LOCATE.M,v $
 *
 * $Revision: 1.2 $
 *
 * $Author: S_Engel $
 *
 * $Date: 1995/01/04 16:20:50 $
 *
 * $State: Exp $
 *
 *****************************************************************************
 * History:
 *
 * $Log: LOCATE.M,v $
 * Revision 1.2  1995/01/04  16:20:50  S_Engel
 * Umbenannt in Locate
 *
 * Revision 1.1  1995/01/01  20:03:08  S_Engel
 * Initial revision
 *
 *
 *
 ****************************************************************************)


IMPORT SYSTEM, CPX;
FROM SYSTEM IMPORT CODE, ADDRESS, BYTE;

IMPORT form;

(* Magic-Lib *)
FROM MagicSys 	IMPORT
								(* Const *) Nil, Null, Bit0, Bit1, Bit2, Bit3, Bit4, Bit5,
														Bit6, Bit7, Bit8, Bit9, Bit10, Bit11, Bit12,
														Bit13, Bit14, Bit15,
								(* Type  *) LOC, Byte, ByteSet, sWORD, sINTEGER, sCARDINAL,
														sBITSET, lINTEGER, lCARDINAL, lWORD, lBITSET;

IMPORT MagicDOS, void;

IMPORT PlugParms, GemarPlugParms;


TYPE
			UChar 			= [0..255];
			tpCmdBlock	= POINTER TO tCmdBlock;
			tCmdBlock 	= RECORD
											Command : UChar;
											Lun 		: UChar;
											Adr 		: LONGCARD;
											Zero		: UChar;
											LenHigh : UChar;
											LenLow	: UChar;
											Flags 	: BYTE; 
										END;

VAR PlugEnv 		: PlugParms.tpPlugEnvironment;
		PlugPrivate : GemarPlugParms.tpPlugParms;
		PlugProcs 	: RECORD
										num  : SHORTINT;
										Proc : ARRAY[0..1] OF PlugParms.tPlugProc;
									END;


(*$K+ $E+ *)
PROCEDURE ScsiIn(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR SCmd : tpCmdBlock;

	BEGIN
		(* Dies ist auch der Deinit-Slot *)
		IF pCmd = SYSTEM.ADDRESS(-1)
			THEN
				RETURN 0;
			END;

		(* Hier kann abgefangen werden *)
		SCmd := tpCmdBlock(pCmd^.Cmd);

		(* Locate? *)
		IF SCmd^.Command = 034H 								(* Read Position? *)
			THEN
				(* Parameter modifizieren *)
				INCL(BYTESET(SCmd^.Lun), Bit0); 		(* TDC 4200 kann nur BT = 1 *)
			END;

		(* und weiterreichen *)
		RETURN PlugPrivate^.ScsiIn(pCmd);
	END ScsiIn;
(*$K= $E+ *)

(*$K+ $E+ *)
PROCEDURE ScsiOut(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;

	BEGIN
		(* Hier kann abgefangen werden *)

		(* und weiterreichen *)
		RETURN PlugPrivate^.ScsiOut(pCmd);
	END ScsiOut;
(*$K= $E+ *)


BEGIN


	PlugEnv := PlugParms.tpPlugEnvironment(CPX.pXCPB);

	IF PlugEnv^.Version # 0100H

		THEN

			VOID(form.alert(1, '[3][PlugIn: falsche Parameterversion][Abbruch]'));

			CPX.Return(NIL);

		END;


	PlugPrivate := PlugEnv^.Private;


	IF PlugPrivate^.Version # 0200H

		THEN

			void.I := PlugEnv^.Alert(1, '[3][PlugIn (QFA):|falsche Parameterversion][Aha]');

			CPX.Return(NIL);

		ELSE

			WITH PlugProcs DO

				num := 2;

				Proc[0] := PlugParms.tPlugProc(ScsiIn);

				Proc[1] := PlugParms.tPlugProc(ScsiOut);

			END;

			CPX.Return(SYSTEM.ADR(PlugProcs));

		END;
END Locate.
		
	
	