DEFINITION MODULE PlugIn;
(****************************************************************************
 *
 * Handler fr Plug-Ins
 *
 *
 *	Beschreibung	:
 *
 *	Um externe Teilprogramme einzubinden, stellt dieses Modul alle
 *	ntigen Routinen zur Verfgung. Als Initialisierungscode kann die
 *	CPX-Initialisierung verwendet werden.
 *
 *	Das installierte PlugIn wird einmal ber den Rumpf aufgerufen
 *	und sollte sich daraufhin initialisieren, wenn dies ntig ist
 *	ist.
 *
 *	Dabei jedoch nicht eine XCPB-Struktur bergeben, sondern einfach NIL
 *
 *	Wenn die Initialisierung geklappt hat, mu die Adresse der Prozedur
 *	zurckgeliefert werden, die das PlugIn zur Verfgung stellt.
 *
 *	Diese Prozedur bekommt als Parameter einen Long auf dem Stack,
 *	und antwortet in D0.
 *
 *	Auf den Parameter ADDRESS(-1) soll das PlugIn sich deinitialisieren,
 *	falls dies ntig ist.
 *
 *
 *
 * $Source: /dev/e/hm2/lib/se\RCS\PLUGIN.D,v $
 *
 * $Revision: 1.3 $
 *
 * $Author: S_Engel $
 *
 * $Date: 1995/01/01 22:39:42 $
 *
 * $State: Exp $
 *
 *****************************************************************************
 * History:
 *
 * $Log: PLUGIN.D,v $
 * Revision 1.3  1995/01/01  22:39:42  S_Engel
 * CountPlugs und LoadSlot hinzugefgt
 *
 * Revision 1.2  1995/01/01  21:57:52  S_Engel
 * ListPlugs bekommt in Path auch die Extension bergeben.
 *
 * Revision 1.1  1995/01/01  19:13:48  S_Engel
 * Initial revision
 *
 *
 *
 ****************************************************************************)
IMPORT Portab;

FROM SYSTEM IMPORT ADDRESS;

(* Magic-Lib *)
FROM MagicSys 	IMPORT
								(* Const *) Nil, Null, Bit0, Bit1, Bit2, Bit3, Bit4, Bit5,
														Bit6, Bit7, Bit8, Bit9, Bit10, Bit11, Bit12,
														Bit13, Bit14, Bit15,
								(* Type  *) LOC, Byte, ByteSet, sWORD, sINTEGER, sCARDINAL,
														sBITSET, lINTEGER, lCARDINAL, lWORD, lBITSET;



TYPE	tPlugIn;	 (* Opaque, geht keinen was an. *)

			tIdent				= ARRAY[0..19] OF CHAR; 	(* Identifikation des Slots *)
			(* Kontroll- und Informationsstruktur als Datei-Kopf eines Plugins *)
			tPlugHead 		= RECORD
												Magic 			: lCARDINAL;							(* 'Plug' *)
												Identify		: tIdent; 								(* Kontrolle fr Programm *)
												SlotIdent 	: tIdent;
												Info				: ARRAY[0..467] OF CHAR;	(* Beschreibung *)
											END;

(*-------------------------------------------------------------------------*)
(*- 																																			-*)
(*- Nachsehen, wieviele PlugIns im Pfad Path (inkl. Wildcard!) liegen.		-*)
(*- Das zu suchende Wildcard mu enthalten sein.													-*)
(*- Identify und dem Slot SlotIdent wird ListProc gerufen.								-*)
(*- Fr Identify = '' wird die Identitt nicht geprft. 									-*)
(*- Fr SlotIdent = '' werden alle PlugIns gemeldet 											-*)
(*- ListProc bekommt immer den kompletten Pfad des PlugIn gemeldet. 			-*)
(*- 																																			-*)
(*-------------------------------------------------------------------------*)
TYPE tListProc = PROCEDURE (VAR (* Identify *) ARRAY OF CHAR,
														VAR (* Slot 		*) ARRAY OF CHAR,
														VAR (* Info 		*) ARRAY OF CHAR,
														VAR (* Name 		*) ARRAY OF CHAR);
PROCEDURE ListPlugs(Identify, Slot, Path : ARRAY OF CHAR; List : tListProc);



(*-------------------------------------------------------------------------*)
(*- 																																			-*)
(*- Nachsehen, wieviele PlugIns im Pfad Path (inkl. Wildcard!) liegen.		-*)
(*- 																																			-*)
(*- Fr Identify = '' wird nicht auf die Identitt eingeschrnkt					-*)
(*- Fr SlotIdent = '' wird nicht auf den Slot eingeschrnkt							-*)
(*- 																																			-*)
(*- 																																			-*)
(*-------------------------------------------------------------------------*)
PROCEDURE CountPlugs(Identify, Slot, Path : ARRAY OF CHAR) : sINTEGER;



(*-------------------------------------------------------------------------*)
(*- 																																			-*)
(*- Laden eines Plug-Ins																									-*)
(*- 																																			-*)
(*- Name ist der Name der zu ladenden Datei.															-*)
(*- Carrier enthlt nach dem erfolgreichen Laden die ntigen Informatio-	-*)
(*- nen ber das Plug-In. 																								-*)
(*- 																																			-*)
(*- Das PlugIn wird ber den Programmrumpf aufgerufen, um sich zu 				-*)
(*- initialisieren. 																											-*)
(*- 																																			-*)
(*- Identify dient zu Kontrolle, ob dieses Plugin berhaupt fr das 			-*)
(*- Programm gedacht ist. 																								-*)
(*- Bei Identify = '' wird nicht darauf kontrolliert. 										-*)
(*- 																																			-*)
(*- Der zurckgegeben Slot-Identifier mu vom Aufrufer kontrolliert 			-*)
(*- werden. 																															-*)
(*- 																																			-*)
(*- RETURN:  0			: alles Ok																						-*)
(*- 				 ENSMEM : nicht gengend Speicher 														-*)
(*- 				 EFILNF : Datei nicht gefunden																-*)
(*- 				 EREADF : Lesefehler																					-*)
(*- 				 EPLFMT : Modul ist kein Programm 														-*)
(*- 						 -1 : Modul will nicht (zB Init-Fehler) 									-*)
(*- 																																			-*)
(*-------------------------------------------------------------------------*)
PROCEDURE Load(Identify, Name : ARRAY OF CHAR; private : ADDRESS; VAR Carrier : tPlugIn; VAR Slot : tIdent) : lINTEGER;
PROCEDURE LoadPath(Identify, Path, Name : ARRAY OF CHAR; private : ADDRESS; VAR Carrier : tPlugIn; VAR Slot : tIdent) : lINTEGER;


(*-------------------------------------------------------------------------*)
(*- 																																			-*)
(*- Das gleiche in der Variation, da das erste in Path (mit Wildcard!) 	-*)
(*- liegende, auf Identify und Slot passende PlugIn geladen wird					-*)
(*- 																																			-*)
(*-------------------------------------------------------------------------*)
PROCEDURE LoadSlot(Identify, Slot, Path : ARRAY OF CHAR; private : ADDRESS; VAR Carrier : tPlugIn) : lINTEGER;


(*-------------------------------------------------------------------------*)
(*- 																																			-*)
(*- PlugIn wird aus dem Speicher entfernt 																-*)
(*- 																																			-*)
(*- Das PlugIn wird mit Prozedur 0 vor dem Entfernen aus dem Speicher 		-*)
(*- einmal mit ADDRESS(-1) aufgerufen, damit es sich deinitialisieren 		-*)
(*- kann. 																																-*)
(*- 																																			-*)
(*-------------------------------------------------------------------------*)
PROCEDURE Free(VAR Carrier : tPlugIn);


(*-------------------------------------------------------------------------*)
(*- 																																			-*)
(*- Aufrufen der PlugIn-Prozedur num																			-*)
(*- 																																			-*)
(*- Als Parameter wird Parm bergeben, der beliebige Daten an das PlugIn	-*)
(*- reichen kann. 																												-*)
(*- 																																			-*)
(*- 																																			-*)
(*- RETURN : MAX(lINTEGER) : PlugIn nicht existent												-*)
(*- 				 sonst				 : Antwort des PlugIn 													-*)
(*- 																																			-*)
(*-------------------------------------------------------------------------*)
PROCEDURE Call(Carrier : tPlugIn; num : sINTEGER; Parm : ADDRESS) : lINTEGER;




END PlugIn.
		
	
	