MODULE Space;
(****************************************************************************
 *
 * Beschreibung  : Adaption des Space-Kommandos auf Streamer mit
 *								 beschrnktem Parameterumfang.
 *								 Dieses ist fr ExaByte-Streamer.
 *
 * $Source: e:\hm2\user\gemar\plugin\RCS\space.m,v $
 *
 * $Revision: 1.1 $
 *
 * $Author: S_Engel $
 *
 * $Date: 1995/01/01 20:03:20 $
 *
 * $State: Exp $
 *
 *****************************************************************************
 * History:
 *
 * $Log: space.m,v $
 * Revision 1.1  1995/01/01  20:03:20  S_Engel
 * Initial revision
 *
 *
 *
 ****************************************************************************)



IMPORT SYSTEM, CPX;
FROM SYSTEM IMPORT CODE, ADDRESS, BYTE;

IMPORT form;

(* Magic-Lib *)
FROM MagicSys 	IMPORT
								(* Const *) Nil, Null, Bit0, Bit1, Bit2, Bit3, Bit4, Bit5,
														Bit6, Bit7, Bit8, Bit9, Bit10, Bit11, Bit12,
														Bit13, Bit14, Bit15,
								(* Type  *) LOC, Byte, ByteSet, sWORD, sINTEGER, sCARDINAL,
														sBITSET, lINTEGER, lCARDINAL, lWORD, lBITSET;

IMPORT MagicDOS, void;

IMPORT PlugParms, GemarPlugParms;


TYPE
			UChar 			= [0..255];
			tpCmdBlock	= POINTER TO tCmdBlock;
			tCmdBlock 	= RECORD
											Command : UChar;
											Lun 		: UChar;
											Adr 		: SHORTCARD;
											Len 		: UChar;
											Flags 	: BYTE;
										END;	

VAR PlugEnv 		: PlugParms.tpPlugEnvironment;
		PlugPrivate : GemarPlugParms.tpPlugParms;
		PlugProcs 	: RECORD
										num  : SHORTINT;
										Proc : ARRAY[0..1] OF PlugParms.tPlugProc;
									END;



(* Abfangen von Space *)
CONST SpaceBlock				= 0;
			SpaceMark 				= 1;
			SpaceSerie				= 2;
			SpaceEnd					= 3;
			SpaceSetmarks 		= 4;

PROCEDURE SpaceCmd(pCmd : GemarPlugParms.tpScsiCmd;
									 Code 			: SHORTCARD;
									 Count			: SHORTCARD;
									 SpTimeout	: LONGCARD) : SHORTINT;

VAR CmdBlock			 : tCmdBlock;
		Cmd 					 : GemarPlugParms.tScsiCmd;
		
BEGIN
	Cmd := pCmd^;
	WITH Cmd DO
		Cmd 		:= SYSTEM.ADR(CmdBlock);
		CmdLen	:= 6;
		Buffer	:= NIL;
		Transferlen := 0;
		Timeout := SpTimeout;
	END;

	WITH CmdBlock DO
		Command := 011H;
		Lun 		:= Code MOD 8;
		Adr 		:= Count DIV 0100H;
		Len 		:= Count MOD 0100H;
		Flags 	:= BYTE(0);
	END;
	RETURN PlugPrivate^.ScsiIn(SYSTEM.ADR(Cmd));
END SpaceCmd;


PROCEDURE CheckforBlankCheck(pCmd : GemarPlugParms.tpScsiCmd) : SHORTCARD;
TYPE tSenseData = RECORD
										HeadBits		 : UChar;
										SegmentNo 	 : UChar;
										SenseKey		 : UChar;
										InfoByte1 	 : UChar;
										InfoByte2 	 : UChar;
										InfoByte3 	 : UChar;
										InfoByte4 	 : UChar;
										AddLength 	 : UChar;
										CmdSpecific  : LONGCARD;
										AddSense		 : SHORTCARD;
									END;
VAR SenseData : tSenseData;
		CmdBlock	: tCmdBlock;
		retCode 	: SHORTINT;
		Cmd 					 : GemarPlugParms.tScsiCmd;

	BEGIN
		Cmd := pCmd^;
		WITH Cmd DO
			Cmd 		:= SYSTEM.ADR(CmdBlock);
			CmdLen	:= 6;
			Buffer	:= SYSTEM.ADR(SenseData);
			Transferlen := 14;
			Timeout := 400;
		END;
		(* Kommando zusammenstellen *)
		WITH CmdBlock DO
			Command := 03H;
			Lun 		:= 0;
			Adr 		:= 0;
			Len 		:= 14;
			Flags 	:= BYTE(0);
		END;
		retCode := PlugPrivate^.ScsiIn(SYSTEM.ADR(Cmd));
		IF retCode = 0
			THEN
			 IF (SenseData.HeadBits DIV 010H MOD 08H # 07H) 	 (* extended Sense? *)
				 OR (SenseData.SenseKey MOD 010H # 08H)  (* Blank Check?		*)
					THEN
						retCode := -100;
					END;
			END;
		RETURN retCode;
	END CheckforBlankCheck;


PROCEDURE SpaceEOM(pCmd : GemarPlugParms.tpScsiCmd) : SHORTCARD;
VAR result : SHORTCARD;

	BEGIN
		LOOP
			(* einen Block berspringen (erster Datenblock)
			 * Wenn es fehlschlgt, wurde vermutlich das Bandende erreicht
			 *)
			result := SpaceCmd(pCmd, SpaceBlock, 1, 1000);
			IF result # 0
				THEN
					(* Hier knnte man checken, wah? *)
					RETURN CheckforBlankCheck(pCmd);
				END;

			(* Dann zum Ende dieses Backup, Fehlschlag bedeutet Fehler
			 * im Bandaufbau *)
			result := SpaceCmd(pCmd, SpaceMark, 6, 120000);
			IF result # 0
				THEN
					(* Fehler melden *)
					RETURN result;
				END;
		END;
	END SpaceEOM;



(*$K+ $E+ *)
PROCEDURE ScsiIn(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;
VAR SCmd : tpCmdBlock;

	BEGIN
		(* in dem Slot wird auch deinitialisiert *)
		IF pCmd = SYSTEM.ADDRESS(-1)
			THEN
				RETURN 0;
			END;

		(* Hier kann abgefangen werden *)
		SCmd := tpCmdBlock(pCmd^.Cmd);

		(* Locate? *)
		IF (SCmd^.Command = 011H) 								(* Space? *)
			 AND (SCmd^.Lun MOD 8 = SpaceEnd)
			THEN
				(* tricksen *)
				RETURN SpaceEOM(pCmd);
			ELSE
				(* und weiterreichen *)
				RETURN PlugPrivate^.ScsiIn(pCmd);
			END;

	END ScsiIn;
(*$K= $E+ *)

(*$K+ $E+ *)
PROCEDURE ScsiOut(pCmd : GemarPlugParms.tpScsiCmd) : SHORTINT;

	BEGIN
		(* Hier kann abgefangen werden *)

		(* und weiterreichen *)
		RETURN PlugPrivate^.ScsiOut(pCmd);
	END ScsiOut;
(*$K= $E+ *)


BEGIN


	PlugEnv := PlugParms.tpPlugEnvironment(CPX.pXCPB);

	IF PlugEnv^.Version # PlugParms.ParmVersion

		THEN

			VOID(form.alert(1, '[3][PlugIn: falsche Parameterversion][Abbruch]'));

			CPX.Return(NIL);

		END;


	PlugPrivate := PlugEnv^.Private;


	IF PlugPrivate^.Version # 0200H

		THEN

			void.I := PlugEnv^.Alert(1, '[3][PlugIn (Space):|falsche Parameterversion][Aha]');

			CPX.Return(NIL);

		ELSE

			WITH PlugProcs DO

				num := 2;

				Proc[0] := PlugParms.tPlugProc(ScsiIn);

				Proc[1] := PlugParms.tPlugProc(ScsiOut);

			END;

			CPX.Return(SYSTEM.ADR(PlugProcs));

		END;
END Space.
		
	
	