/* This is ButtonBar
 * 09-05-1996
 * (C) 1996 Sander RM SToks
 * ++cg[13/6/97]:errors report using Salert() so you get a nice alert box under XaAES
 * ++cg[14/6/97]:small mods to extend the search path for bar.inf
 */

#include <osbind.h>
#include <mintbind.h>
#include <aes.h>
#include <vdi.h>
#include <stdio.h>
#include <string.h>
#include "bar.h"
#include "defines.h"

#ifdef rc_intersect
#undef rc_intersect
#endif

/*extern short rc_intersect (GRECT *a, GRECT *b);*/

short work_in[12], work_out[57], handle, whandle, phys_handle, gl_apid,
	gr_cw, gr_ch, gr_bw, gr_bh, fullx, fully, fullw, fullh,
	b_hor, b_ver, orient;

char button_names[MAXBUTTONS][40];
char file_names[MAXBUTTONS][200];
char cmd_lines[MAXBUTTONS][200];
char kinds[MAXBUTTONS];
short widths[MAXBUTTONS];

GRECT work;

short open_vwork (void)
{
	register short i;
	if ((gl_apid = appl_init()) != -1)
	{
		menu_register(gl_apid,"  ButtonBar");

		for (i=1; i<10; work_in[i++] = 1);
		work_in[10] = 2;
		phys_handle = graf_handle (&gr_cw, &gr_ch, &gr_bw, &gr_bh);
		work_in[0]  = handle = phys_handle;

		v_opnvwk (work_in, &handle, work_out);
		return (0);
	}
	else
		return (1);
}


void close_vwork (void)
{
	v_clsvwk (handle);
	appl_exit ();
}


short do_dialog (OBJECT *tree, int first)
{
	GRECT g;
	short ret;
	wind_update (BEG_UPDATE);
	wind_update (BEG_MCTRL);
	form_center (tree, &g.g_x, &g.g_y, &g.g_w, &g.g_h);
	form_dial (FMD_START, 0, 0, 0, 0, g.g_x, g.g_y, g.g_w, g.g_h);
	form_dial (FMD_GROW, g.g_x+g.g_w/2, g.g_y+g.g_y/2, 0, 0, g.g_x, g.g_y, g.g_w, g.g_h);
	objc_draw (tree, ROOT, MAX_DEPTH, g.g_x, g.g_y, g.g_w, g.g_h);
	ret = form_do (tree, first);
	tree[ret].ob_state &= ~SELECTED;
	form_dial (FMD_SHRINK, g.g_x+g.g_w/2, g.g_y+g.g_h/2, 0, 0, g.g_x, g.g_y, g.g_w, g.g_h);
	form_dial (FMD_FINISH, 0, 0, 0, 0, g.g_x, g.g_y, g.g_w, g.g_h);
	wind_update (END_MCTRL);
	wind_update (END_UPDATE);
	return (ret);
}


void draw_button (short i, short s)
{
	short x, y, p[6],d1,d2;
	GRECT r;

	x = i % b_hor;
	y = i / b_hor;
	wind_get (whandle, WF_WORKXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
	p[0] = x*BUTTONWIDTH + r.g_x;
	p[1] = y*BUTTONHEIGHT + r.g_y;
	p[2] = p[0] + BUTTONWIDTH - 1;
	p[3] = p[1] + BUTTONHEIGHT - 1;
	vsf_color (handle, LWHITE);
	v_bar (handle, p);
	vswr_mode (handle, MD_TRANS);
	vst_alignment(handle,1,1,&d1,&d2);
	vst_color (handle, (kinds[i] == 255) ? LBLACK : BLACK);
	v_gtext (handle, p[0] + BUTTONWIDTH/2 + (s ? 2 : 0), p[1] + BUTTONHEIGHT/2 + (s ? 2 : 0),
		button_names[i]);
	vswr_mode (handle, MD_REPLACE);
	p[0] = (x+1)*BUTTONWIDTH + r.g_x - 2;
	p[1]++;
	p[2] = x*BUTTONWIDTH + r.g_x + 1;
	p[3] = y*BUTTONHEIGHT + r.g_y + 1;
	p[4] = p[2];
	p[5] = p[3] + BUTTONHEIGHT - 2;
	vsl_color (handle, s ? LBLACK : WHITE);
	v_pline (handle, 3, p);
	p[0]++;
	p[1]++;
	p[2] = p[0];
	p[3] = p[5];
	p[4]++;
	vsl_color (handle, s ? WHITE : LBLACK);
	v_pline (handle, 3, p);
}


void redraw (GRECT *dirty, short b)
{
	GRECT r;
	graf_mouse (M_OFF, NULL);
	wind_update (BEG_UPDATE);
	wind_get (whandle, WF_FIRSTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
	while (r.g_w && r.g_h)
	{
		if (rc_intersect (dirty, &r))
		{
			short p[4], i;
			p[0] = r.g_x;
			p[1] = r.g_y;
			p[2] = r.g_x + r.g_w - 1;
			p[3] = r.g_y + r.g_h - 1;
			vs_clip (handle, 1, p);
			for (i = 0; i <= b_hor*b_ver; i++)
				draw_button (i, (i == b));
			vs_clip (handle, 0, p);
		}
		wind_get (whandle, WF_NEXTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
	}
	wind_update (END_UPDATE);
	graf_mouse (M_ON, NULL);	
}


void do_button (short i)
{
	GRECT d;
	d.g_x = work.g_x + (i % b_hor)*BUTTONWIDTH;
	d.g_y = work.g_y + (i / b_hor)*BUTTONHEIGHT;
	d.g_w = BUTTONWIDTH;
	d.g_h = BUTTONHEIGHT;
	redraw (&d, i);
	if (kinds[i] != 255) shel_write (SWM_LAUNCH, kinds[i], 0, file_names[i], cmd_lines[i]);
	else Bconout (2,7);
	redraw (&d, -1);
}


void sstrcpy (char *dest, const char *src)
{
	if (src != NULL)
		strcpy (dest, src);
	else
		strcpy (dest, "");
}


short parse_file (void)
{
	FILE *bar;
	char buf[256],*line,*cp;
	short kind, i;
	short pxy[8];

	b_hor = 2;
	b_ver = 10;
	orient = 1;
	for (i = 0; i < MAXBUTTONS; i++)
	{
		kinds[i] = 255;
		strcpy (button_names[i], "Empty");
	}
	if ((bar = fopen ("BAR.INF", "r")) == NULL)
	{
		if ((bar = fopen ("C:\\BAR.INF", "r")) == NULL)
		{
			if ((bar = fopen ("\\XAAES\\BAR.INF", "r")) == NULL)
			{
				Salert("ButtonBar| Couldn't open BAR.INF file");
				return (-1);
			}
		}
	}
	fgets(buf,100,bar);
	b_hor=0; b_ver=0;
	for(line=buf; *line!=','; line++)
		b_hor=b_hor*10+(*line-'0');
	for(line++; *line!=','; line++)
		b_ver=b_ver*10+(*line-'0');
	line++;
	if(!b_ver)
		b_ver=1;
	if (!strncmp (line, "topleft", 7))
		orient = TOPLEFT;
	else if (!strncmp (line, "topright", 8))
		orient = TOPRIGHT;
	else if (!strncmp (line, "botleft", 7))
		orient = BOTLEFT;
	else if (!strncmp (line, "botright", 8))
		orient = BOTRIGHT;
	else
	{
		Salert("ButtonBar| Parse error in line 1");
		fclose (bar);
		return (-2);
	}
	i = 0;
	while (fgets(buf,100,bar)!=NULL)
	{
		for(line=buf; *line!=','; line++);
		*line='\0';
		kind=atoi(buf);
		kinds[i]=(char)kind;
		for(cp=button_names[i]; *++line!=','; *cp++=*line); *cp='\0';
		vqt_extent(handle,button_names[i],pxy);
		widths[i]=abs(pxy[2]-pxy[0]);
		for(cp=file_names[i]; *++line!=','; *cp++=*line); *cp='\0';
		for(cp=cmd_lines[i]; (*line)&&(*line!='\n')&&(*line!='\r'); *cp++=*line++); *cp='\0';
		i++;
		if(i>b_hor)
			b_hor=i;
	}
	fclose (bar);
	return (0);
}


short main (void)
{
	OBJECT *ad_menu, *ad_about;
	short mx, my, btn, kbd, c, clicks, ev_which, quit = 0;
	short msg[8];

	if (open_vwork ())
	{
		Salert("ButtonBar| Couldn't open Virtual Workstation");
		return (-1);
	}

	if (!rsrc_load ("bar.rsc"))
	{
		if (!rsrc_load ("BAR.RSC"))
		{
			Salert("ButtonBar| Couldn't load resource file");
			return (-2);
		}
	}

	if (parse_file ())
		return (-3);

	wind_get (0, WF_WORKXYWH, &fullx, &fully, &fullw, &fullh);

	if ((whandle = wind_create (0, fullw - b_hor*BUTTONWIDTH,
		 fully, b_hor*BUTTONWIDTH, b_ver*BUTTONHEIGHT + 2)) < 0)
	{
		Salert("ButtonBar| Couldn't create window");
		return (-4);
	}

	rsrc_gaddr (R_TREE, MENU, &ad_menu);
	rsrc_gaddr (R_TREE, DABOUT, &ad_about);
	menu_bar (ad_menu, TRUE);
	switch (orient)
	{
	case TOPLEFT:
		wind_open (whandle, 0, fully,
				b_hor*BUTTONWIDTH, b_ver*BUTTONHEIGHT + 2);
		break;
	case TOPRIGHT:
		wind_open (whandle, fullw - b_hor*BUTTONWIDTH, fully,
				b_hor*BUTTONWIDTH, b_ver*BUTTONHEIGHT + 2);
		break;
	case BOTLEFT:
		wind_open (whandle, 0, fullh + fully - b_ver*BUTTONHEIGHT - 2,
				b_hor*BUTTONWIDTH, b_ver*BUTTONHEIGHT + 2);
		break;
	case BOTRIGHT:
		wind_open (whandle, fullw - b_hor*BUTTONWIDTH, fullh + fully - b_ver*BUTTONHEIGHT - 2,
				b_hor*BUTTONWIDTH, b_ver*BUTTONHEIGHT + 2);
	}
	wind_set (whandle, WF_BEVENT, 1, 0, 0, 0);
	wind_get (whandle, WF_WORKXYWH, &work.g_x, &work.g_y, &work.g_w, &work.g_h);
	redraw (&work, -1);
	graf_mouse (ARROW, 0L);
	while (!quit)
	{
		ev_which = evnt_multi (MU_KEYBD|MU_BUTTON|MU_MESAG, 1, 1, 1,
				   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, msg, 0, 0,
				   &mx, &my, &btn, &kbd, &c, &clicks);
		if (ev_which & MU_MESAG) switch (msg[0])
		{
		case MN_SELECTED:
			switch (msg[4])
			{
			case ABOUT:
				do_dialog (ad_about, 0);
				menu_tnormal (ad_menu, BAR, 1);
				break;
			case RELOAD:
				if (parse_file ()) return (-3);
				switch (orient)
				{
				case TOPLEFT:
					wind_set (whandle, WF_CURRXYWH, 0, fully,
						b_hor*BUTTONWIDTH, b_ver*BUTTONHEIGHT + 2);
					break;
				case TOPRIGHT:
					wind_set (whandle, WF_CURRXYWH, fullw - b_hor*BUTTONWIDTH, fully,
						b_hor*BUTTONWIDTH, b_ver*BUTTONHEIGHT + 2);
					break;
				case BOTLEFT:
					wind_set (whandle, WF_CURRXYWH, 0, fullh + fully - b_ver*BUTTONHEIGHT - 2,
						b_hor*BUTTONWIDTH, b_ver*BUTTONHEIGHT + 2);
					break;
				case BOTRIGHT:
					wind_set (whandle, WF_CURRXYWH, fullw - b_hor*BUTTONWIDTH, fullh + fully - b_ver*BUTTONHEIGHT - 2,
						b_hor*BUTTONWIDTH, b_ver*BUTTONHEIGHT + 2);
				}
				wind_get (whandle, WF_WORKXYWH, &work.g_x, &work.g_y, &work.g_w, &work.g_h);
				redraw (&work, -1);
				menu_tnormal (ad_menu, MFILE, 1);
				break;
			case QUIT:
				quit = TRUE;
				menu_tnormal (ad_menu, MFILE, 1);
				break;
			}
			break;
		case WM_REDRAW:
			redraw ((GRECT *)&msg[4], -1);
			break;
		case WM_TOPPED:
			wind_set (whandle, WF_TOP);
			break;
		}

		if (ev_which & MU_BUTTON)
		{
			if ((mx > work.g_x) && (mx < work.g_x + work.g_w)
			 && (my > work.g_y) && (my < work.g_y + work.g_h))
			{
				short i = b_hor * ((my - work.g_y) / BUTTONHEIGHT)
					  + (mx - work.g_x) / BUTTONWIDTH;
				do_button (i);
			}
			else
				Bconout (2,7);	/* Ping! */
		}

		if (ev_which & MU_KEYBD) switch (c & 0xFF)
		{
		case CNTRL_Q:
			quit = TRUE;
			break;
		}
	}
	wind_new ();
	menu_bar (ad_menu, FALSE);
	rsrc_free ();
	close_vwork ();
	return (0);
}
