/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <STRING.H>
#include <VDI.H>
#include <memory.h>
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "OBJECTS.H"
#include "MENUWIDG.H"
#include "SYSTEM.H"
#include "C_WINDOW.H"
#include "RESOURCE.H"
#include "RECTLIST.H"

/*
	This file provides the interface between XaAES's (somewhat strange) menu
	system and the standard GEM calls. Most GEM apps will only care about the
	menu they install onto the desktop, although XaAES can allow seperate menu's
	for each window.....
*/

/*
	Install a menu bar onto the desktop window
*/
unsigned long XA_menu_bar(short clnt_pid, AESPB *pb)
{
	XA_CLIENT *client=Pid2Client(clnt_pid);
	XA_RECT_LIST *rl;
	XA_WIDGET_TREE *menu_bar=(XA_WIDGET_TREE*)(root_window->widgets[XAW_MENU].stuff);
	OBJECT *mnu=(OBJECT*)pb->addrin[0];

	pb->intout[0]=1;

	DIAGS(("menu_bar(clnt_pid=%d)\n",clnt_pid));
	
	switch(pb->intin[0])
	{
		case MENU_INSTALL:
			DIAGS(("MENU_INSTALL\n"));
			fix_menu(mnu);	/* do a special fix on menu the menu  */
			DIAGS(("fixed menu\n"));

			mnu->ob_width=mnu[mnu->ob_tail].ob_width=mnu[mnu->ob_head].ob_width=display.w;

			client->std_menu=mnu;
			menu_bar->tree=mnu;
			menu_bar->owner=clnt_pid;

			rl=rect_get_system_first(root_window);

			DIAGS(("displaying new menu @%lx\n",menu_bar->tree));

			v_hide_c(V_handle);
			while(rl)
			{
				set_clip(rl->x, rl->y, rl->w, rl->h);
				display_menu_widget(root_window, &root_window->widgets[XAW_MENU]);
				rl=rect_get_system_next(root_window);
				DIAGS(("rl=%lx\n",rl));
			}
			clear_clip();
			v_show_c(V_handle,1);
			
			DIAGS(("done display\n"));
			
			break;
		case MENU_REMOVE:
			DIAGS(("MENU_REMOVE\n"));
			client->std_menu=ResourceTree(system_resources,SYSTEM_MENU);
			menu_bar->owner=AESpid;
			menu_bar->tree=client->std_menu;
		
			rl=rect_get_system_first(root_window);

			v_hide_c(V_handle);
			while(rl)
			{
				set_clip(rl->x, rl->y, rl->w, rl->h);
				display_menu_widget(root_window, &root_window->widgets[XAW_MENU]);
				rl=rect_get_system_next(root_window);
			}
			clear_clip();
			v_show_c(V_handle,1);
			break;
			
		case MENU_INQUIRE:
			DIAGS(("MENU_INQUIRE\n"));
			pb->intout[0]=menu_bar->owner;
			break;
	}
	
	DIAGS(("done menu_bar()\n"));
	
	return XAC_DONE;
}

/*
	Highlight / un-highlight a menu title
	-actually, this isn't really needed as XaAES cancels the highlight itself....
	...it's only here for compatibility. 
*/
unsigned long XA_menu_tnormal(short clnt_pid, AESPB *pb)
{
	XA_WIDGET_TREE *menu_bar=(XA_WIDGET_TREE*)(root_window->widgets[XAW_MENU].stuff);
	OBJECT *tree=(OBJECT*)pb->addrin[0];
	
	if (pb->intin[1])			/* Change the highlight / normal status of a menu title */
		tree[pb->intin[0]].ob_state&=~SELECTED;
	else
		tree[pb->intin[0]].ob_state|=SELECTED;

/* If we just changed the main root window's menu, better redraw it */
	if ((tree==menu_bar->tree)&&(tree[pb->intin[0]].ob_type==G_TITLE))
	{
		XA_RECT_LIST *rl=rect_get_system_first(root_window);

		v_hide_c(V_handle);
		while(rl)
		{
			set_clip(rl->x, rl->y, rl->w, rl->h);
			display_menu_widget(root_window, &root_window->widgets[XAW_MENU]);
			rl=rect_get_system_next(root_window);
		}
		clear_clip();
		v_show_c(V_handle,1);
	}
	
	pb->intout[0]=1;
	
	return XAC_DONE;
}

/*
	Enable/Disable a menu item
*/
unsigned long XA_menu_ienable(short clnt_pid, AESPB *pb)
{
	XA_WIDGET_TREE *menu_bar=(XA_WIDGET_TREE*)(root_window->widgets[XAW_MENU].stuff);
	OBJECT *tree=(OBJECT*)pb->addrin[0];
	
	if (pb->intin[1])			/* Change the disabled status of a menu item */
		tree[pb->intin[0]].ob_state&=~DISABLED;
	else
		tree[pb->intin[0]].ob_state|=DISABLED;
	
/* If we just changed the main root window's menu, better redraw it */
	if ((tree==menu_bar->tree)&&(tree[pb->intin[0]].ob_type==G_TITLE))
	{
		XA_RECT_LIST *rl=rect_get_system_first(root_window);

		v_hide_c(V_handle);
		while(rl)
		{
			set_clip(rl->x, rl->y, rl->w, rl->h);
			display_menu_widget(root_window, &root_window->widgets[XAW_MENU]);
			rl=rect_get_system_next(root_window);
		}
		clear_clip();
		v_show_c(V_handle,1);
	}
	pb->intout[0]=1;

	return XAC_DONE;
}

/*
	Check / un-check a menu item
*/
unsigned long XA_menu_icheck(short clnt_pid, AESPB *pb)
{
	XA_WIDGET_TREE *menu_bar=(XA_WIDGET_TREE*)(root_window->widgets[XAW_MENU].stuff);
	OBJECT *tree=(OBJECT*)pb->addrin[0];
	
	if (pb->intin[1])			/* Change the disabled status of a menu item */
		tree[pb->intin[0]].ob_state|=CHECKED;
	else
		tree[pb->intin[0]].ob_state&=~CHECKED;
	
/* If we just changed the main root window's menu, better redraw it */
	if ((tree==menu_bar->tree)&&(tree[pb->intin[0]].ob_type==G_TITLE))
	{
		XA_RECT_LIST *rl=rect_get_system_first(root_window);

		v_hide_c(V_handle);
		while(rl)
		{
			set_clip(rl->x, rl->y, rl->w, rl->h);
			display_menu_widget(root_window, &root_window->widgets[XAW_MENU]);
			rl=rect_get_system_next(root_window);
		}
		clear_clip();
		v_show_c(V_handle,1);
	}
	
	pb->intout[0]=1;

	return XAC_DONE;
}

/*
	Change a menu item's text
*/
unsigned long XA_menu_text(short clnt_pid, AESPB *pb)
{
	XA_WIDGET_TREE *menu_bar=(XA_WIDGET_TREE*)(root_window->widgets[XAW_MENU].stuff);
	OBJECT *tree=(OBJECT*)pb->addrin[0];
	char *text=(char*)pb->addrin[1];
	
	strcpy((char*)tree[pb->intin[0]].ob_spec,text);
	
/* If we just changed the main root window's menu, better redraw it */
	if ((tree==menu_bar->tree)&&(tree[pb->intin[0]].ob_type==G_TITLE))
	{
		XA_RECT_LIST *rl=rect_get_system_first(root_window);

		v_hide_c(V_handle);
		while(rl)
		{
			set_clip(rl->x, rl->y, rl->w, rl->h);
			display_menu_widget(root_window, &root_window->widgets[XAW_MENU]);
			rl=rect_get_system_next(root_window);
		}
		clear_clip();
		v_show_c(V_handle,1);
	}
	
	pb->intout[0]=1;

	return XAC_DONE;
}

/*
	Register an apps 'pretty' & 'official' names.
*/
unsigned long XA_menu_register(short clnt_pid, AESPB *pb)
{
	XA_CLIENT *client=Pid2Client(clnt_pid);
	short f;
	
	if (pb->intin[0]!=-1)
	{
		strcpy(client->name,(char*)pb->addrin[0]);
	}else{
		strncpy(client->proc_name,(char*)pb->addrin[0],8);
		for(f=strlen(client->proc_name); f<8; f++)
			client->proc_name[f]=' ';
		client->proc_name[8]='\0';
	}
	
	return XAC_DONE;
}
