/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#ifdef LATTICE
#undef abs		/* MiNTlib (PL46) #define is buggy! */
#define abs(i)	__builtin_abs(i)
#endif
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"

/*
	Draw a plain hollow ibox
*/
void d_g_ibox(ODC_PARM *odc_p)
{
	OBJECT *ob=odc_p->tree + odc_p->object;
	short parent_x=odc_p->parent_x, parent_y=odc_p->parent_y;
	OBJC_COLORWORD *colourword;
	unsigned short zap;
	short border_thick=0;

	colourword=(OBJC_COLORWORD*)&zap;
	zap=(unsigned short)ob->ob_spec&0xffff;
	border_thick=(short)((((unsigned long)ob->ob_spec)&0xff0000L)>>16);
	if (border_thick&128)
		border_thick=-(1+(border_thick^0xff));

	shadow_object(ob, parent_x, parent_y, colourword, border_thick);
	set_colours(ob, colourword);

	if (border_thick)			/* Display a border? */
	{
		draw_2d_box(parent_x+ob->ob_x, parent_y+ob->ob_y, 
					ob->ob_width, ob->ob_height, 
					border_thick, colourword->borderc);
	}

}

