/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <OSBIND.H>
#include <MINTBIND.H>
#include <SIGNAL.H>
#include <VDI.H>
#include <stdio.h>
#include "XA_TYPES.H"
#include "XA_CODES.H"
#include "XA_DEFS.H"
#include "XA_GLOBL.H"
#include "OBJECTS.H"
#include "FRM_ALRT.H"
#include "FSELECT.H"
#include "STD_WIDG.H"
#include "C_WINDOW.H"
#include "SYSTEM.H"
#include "RESOURCE.H"
#include "SCRLOBJC.H"
#include "K_DEFS.H"
#include "shellwrt.h"

/*
	General system dialogs
	(Error Log and Task Manager)
*/

void refresh_tasklist(OBJECT *form)
{
	XA_CLIENT *client;
	SCROLL_ENTRY entry;
	short cpid;

/* Empty the task list */
	empty_scroll_list(form, TM_LIST);

/* Add all current tasks to the list */
	for(client=FirstClient(); client; client=NextClient(client) )
	{
		entry.text=client->name;
		if (client->msg)
		{
			entry.icon=form+TM_ICN_MESSAGE;
		}else{
			cpid=Client2Pid(client);
			if ((cpid==mouse_lock)||(cpid==update_lock))
			{
				entry.icon=form+TM_ICN_LOCK;
			}else{
				if (client->client_type==XA_CT_ACC)
				{
					entry.icon=form+TM_ICN_MENU;
				}else{
					entry.icon=form+TM_ICN_XAAES;
				}
			}
		}
		add_scroll_entry(form, TM_LIST, &entry);
	}
}

XA_WINDOW *task_man_win=NULL;

short taskmanager_destructor(XA_WINDOW *wind)
{
	task_man_win=NULL;
	return TRUE;
}

void handle_taskmanager(ODC_PARM *odc_p)
{
	SCROLL_INFO *list;
	SCROLL_ENTRY *this;
	OBJECT *ob=odc_p->tree+TM_LIST;
	XA_CLIENT *client;
	
	list=(SCROLL_INFO*)ob->ob_spec;
	
	switch(odc_p->object)
	{
		case TM_KILL:
			client=FirstClient(); this=list->scrl_start;
			
			while(this!=list->scrl_current)
			{
				this=this->next;
				client=NextClient(client);
			}
			
			Pkill(Client2Pid(client),SIGKILL);

			Fselect(200,NULL,NULL,NULL);

			refresh_tasklist(odc_p->tree);

			v_hide_c(V_handle);
			draw_object_tree(odc_p->tree,TM_LIST,1);
			v_show_c(V_handle,1);
			
			break;
	}
}

void open_taskmanager(void)
{
	XA_WINDOW *dialog_window;
	OBJECT *form=ResourceTree(system_resources,TASK_MANAGER);
	XA_WIDGET_LOCATION dialog_toolbar_loc={LT,3,0};
	short x,y,w,h;

	if (task_man_win)
	{
		pull_wind_to_top(task_man_win);
		return;
	}
	
	dialog_toolbar_loc.y=display.c_max_h+1;
	
	form->ob_x=(display.w-form->ob_width)/2;
	form->ob_y=(display.h-form->ob_height)/2;

	refresh_tasklist(form);

/* Create a temporary window to work out sizing */
	dialog_window=create_window(AESpid, CLOSE|NAME|MOVE, form->ob_x, form->ob_y, form->ob_width, form->ob_height);

	x=2*dialog_window->x - dialog_window->wx;
	y=2*dialog_window->y - dialog_window->wy;
	w=2*dialog_window->w - dialog_window->ww +1;
	h=2*dialog_window->h - dialog_window->wh +1;

/* Dispose of the temporary window we created */
	delete_window(dialog_window);

/* Now create the real window */
	dialog_window=create_window(AESpid, CLOSE|NAME|MOVE|NO_MESSAGES|NO_WORK, x, y, w, h);

	dialog_window->created_by_FMD_START=FALSE;

/* Set the window title */
	dialog_window->widgets[XAW_TITLE].stuff="Task Manager";

	dialog_toolbar_loc.y=display.c_max_h+3;
	set_toolbar_widget(dialog_window, dialog_toolbar_loc, form);
	
	((XA_WIDGET_TREE*)dialog_window->widgets[XAW_TOOLBAR].stuff)->owner=AESpid;
	((XA_WIDGET_TREE*)dialog_window->widgets[XAW_TOOLBAR].stuff)->handler=&handle_taskmanager;

/* Set the window destructor */
	dialog_window->destructor=&taskmanager_destructor;
	
	dialog_window->is_open=TRUE;

	v_hide_c(V_handle);
	pull_wind_to_top(dialog_window);
	display_window(dialog_window);
	v_show_c(V_handle,1);

	task_man_win=dialog_window;
}

void handle_launcher(char *path,char *file)
{
	char parms[200],*t;
	
	sprintf(parms+1,"%s\\%s",path,file);
	parms[0]='\0';
	for(t=parms+1; *t; t++)
	{
		if(*t=='/')
			*t='\\';
	}		

	DIAGS(("launch:%s\n",parms+1));

	shell_write(0,0,0,parms+1,parms);
}

void open_launcher(void)
{
	open_fileselector("u:/*","Launch Program",&handle_launcher,NULL);
}

XA_WINDOW *systemalerts_win=NULL;

void handle_systemalerts(ODC_PARM *odc_p)
{
	OBJECT *form=odc_p->tree;

	switch(odc_p->object)
	{

		case SALERT_CLEAR:		/* Empty the task list */
			empty_scroll_list(form, SYSALERT_LIST);
			v_hide_c(V_handle);
			draw_object_tree(form, SYSALERT_LIST, 1);
			v_show_c(V_handle,1);
			break;
	}
}

short systemalerts_destructor(XA_WINDOW *wind)
{
	systemalerts_win=NULL;
	return TRUE;
}

void open_systemalerts(void)
{
	XA_WINDOW *dialog_window;
	OBJECT *form=ResourceTree(system_resources,SYS_ERROR);
	XA_WIDGET_LOCATION dialog_toolbar_loc={LT,3,0};
	short x,y,w,h;
	
	if(systemalerts_win)
	{
		pull_wind_to_top(systemalerts_win);
		return;
	}
	
	dialog_toolbar_loc.y=display.c_max_h+1;
	
	form->ob_x=(display.w-form->ob_width)/2;
	form->ob_y=(display.h-form->ob_height)/2;

/* Create a temporary window to work out sizing */
	dialog_window=create_window(AESpid, CLOSE|NAME|MOVE, form->ob_x, form->ob_y, form->ob_width, form->ob_height);

	x=2*dialog_window->x - dialog_window->wx;
	y=2*dialog_window->y - dialog_window->wy;
	w=2*dialog_window->w - dialog_window->ww +1;
	h=2*dialog_window->h - dialog_window->wh +1;

/* Dispose of the temporary window we created */
	delete_window(dialog_window);

/* Now create the real window */
	dialog_window=create_window(AESpid, CLOSE|NAME|MOVE|NO_MESSAGES|NO_WORK, x, y, w, h);

	dialog_window->created_by_FMD_START=FALSE;

/* Set the window title */
	dialog_window->widgets[XAW_TITLE].stuff="System Alerts Log";

	dialog_toolbar_loc.y=display.c_max_h+3;
	set_toolbar_widget(dialog_window, dialog_toolbar_loc, form);
	
	((XA_WIDGET_TREE*)dialog_window->widgets[XAW_TOOLBAR].stuff)->owner=AESpid;
	((XA_WIDGET_TREE*)dialog_window->widgets[XAW_TOOLBAR].stuff)->handler=&handle_systemalerts;

/* Set the window destructor */
	dialog_window->destructor=&systemalerts_destructor;
	
	dialog_window->is_open=TRUE;

	v_hide_c(V_handle);
	pull_wind_to_top(dialog_window);
	display_window(dialog_window);
	v_show_c(V_handle,1);

	systemalerts_win=dialog_window;
}
