/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <VDI.H>
#include <MINTBIND.H>
#include <OSBIND.H>
#include <memory.h>
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "C_WINDOW.H"
#include "EVENTS.H"
#include "RECTLIST.H"
#include "SCRLWIDG.H"
#include "INFOWIDG.H"
#include "TITLWIDG.H"
#include "STD_WIDG.H"
#include "graf_mou.h"
#include "messages.h"
#include "desktop.h"
#include "RESOURCE.H"
#include "SYSTEM.H"
#include "OBJECTS.H"

/*
	AES window handling functions
	I've tried to support some of the AES4 extensions here as well as the plain
	single tasking GEM ones.
*/
unsigned long XA_wind_create(short clnt_pid, AESPB *pb)
{
	XA_WINDOW *new_window;
	long tp=0;
	
	tp=pb->intin[0];
	
	new_window=create_window(clnt_pid, tp, pb->intin[1], pb->intin[2], pb->intin[3], pb->intin[4]);

	if (new_window)
		pb->intout[0]=new_window->handle;	/* Return the window handle in intout[0] */
	else
		pb->intout[0]=-1;					/* Fail to create window, return -ve number */

	return XAC_DONE;	/* Allow the kernal to wake up the client - we've done our bit */
}

unsigned long XA_wind_open(short clnt_pid,AESPB *pb)
{
	XA_WINDOW *w,*wl;
	XA_CLIENT *client=Pid2Client(clnt_pid);
	GRECT clip,our_win;

	w=get_wind_by_handle(pb->intin[0]);	/* Get the window */

	if (w==NULL)
	{
		DIAGS(("WARNING:wind_open:Invalid window handle\n"));
		pb->intout[0]=0;			/* Invalid window handle, return error */
		return XAC_DONE;
	}
	
	pb->intout[0]=1;				/* return ok in intout[0] */
	
	if (w->is_open==TRUE)			/* the window is already open, no need to do anything */
	{
		DIAGS(("WARNING: Attempt to open window when it was already open\n"));
		return XAC_DONE;
	}

	/* New top window - change the cursor to this clients choice */
	graf_mouse(client->client_mouse, client->client_mouse_form);

	w->x=pb->intin[1];				/* Change the window coords */
	w->y=pb->intin[2];
	w->w=pb->intin[3];
	w->h=pb->intin[4];
	w->is_open=TRUE;				/* Flag window as open */
	w->window_status=XAWS_OPEN;
	
	wl=window_list;

	pull_wind_to_top(w);			/* Newly opened windows begin on top */

	our_win.g_x=w->x; our_win.g_y=w->y; our_win.g_w=w->w; our_win.g_h=w->h;

	for(wl=window_list; wl!=root_window->next; wl=wl->next)
	{
		clip.g_x=wl->x; clip.g_y=wl->y;
		clip.g_w=wl->w; clip.g_h=wl->h;
				
		if (rc_intersect(&our_win,&clip))
			generate_rect_list(wl);
	}

	v_hide_c(V_handle);

	calc_work_area(w);

	display_non_topped_window(w,NULL);	/* Display the window (use the non-topped method as it sets clipping rectangles) */
	send_app_message(clnt_pid, WM_REDRAW, 0, w->handle, w->x, w->y, w->w, w->h);

	wl=w->next;

	if (wl!=root_window)		/* Refresh the previous top window as being 'non-topped' */
	{
		display_non_topped_window(wl,NULL);
		send_app_message(wl->owner, WM_UNTOPPED, 0, wl->handle, wl->x, wl->y, wl->w, wl->h);
	}

	v_show_c(V_handle,1);

	return XAC_DONE;
}

unsigned long XA_wind_close(short clnt_pid,AESPB *pb)
{
	XA_WINDOW *w;
	
	w=get_wind_by_handle(pb->intin[0]);	/* Get the window */

	if (w==NULL)
	{
		DIAGS(("WARNING:wind_close:Invalid window handle\n"));
		pb->intout[0]=0;			/* Invalid window handle, return error */
		return XAC_DONE;
	}

	if (w->owner!=clnt_pid)		/* Clients can only close their own windows */
	{
		DIAGS(("WARNING: clnt %d cannot close window %d (not owner)\n",clnt_pid,w->handle));
		pb->intout[0]=0;			/* Invalid window handle, return error */
		return XAC_DONE;
	}
	
	pb->intout[0]=close_window(w);
	
	return XAC_DONE;
}

unsigned long XA_wind_find(short clnt_pid,AESPB *pb)
{
	XA_WINDOW *w;
	
	w=wind_find(pb->intin[0], pb->intin[1]);	/* Is there a window under the mouse? */

	if (w==NULL)
	{
		pb->intout[0]=0;
		return XAC_DONE;
	}

	pb->intout[0]=w->handle;	/* Found a window, return the handle */

	return XAC_DONE;
}

void update_vslide(XA_WINDOW *wind)
{
	XA_RECT_LIST *rl;
	short x,y,pnt[4];
	XA_WIDGET *widg=wind->widgets;

	widg+=XAW_VSLIDE;
	
	rp_2_ap(wind, widg, &x, &y);	/* Convert relative coords and window location to absolute screen location */
	pnt[0]=x; pnt[1]=y;
	pnt[2]=x+widg->w; pnt[3]=y+widg->h;
	vsf_color(V_handle,display.dial_colours.bg_col);
	vsf_interior(V_handle,FIS_SOLID);
	
	v_hide_c(V_handle);
	for(rl=rect_get_system_first(wind); rl; rl=rect_get_system_next(wind))				/* Walk the rectangle list */
	{
		set_clip(rl->x, rl->y, rl->w, rl->h);
		v_bar(V_handle,pnt);
		display_vslide(wind, widg);
	}
	v_show_c(V_handle,1);
}

void update_hslide(XA_WINDOW *wind)
{
	XA_RECT_LIST *rl;
	short x,y,pnt[4];
	XA_WIDGET *widg=wind->widgets;
	
	widg+=XAW_HSLIDE;
	
	rp_2_ap(wind, widg, &x, &y);	/* Convert relative coords and window location to absolute screen location */
	pnt[0]=x; pnt[1]=y;
	pnt[2]=x+widg->w; pnt[3]=y+widg->h;
	vsf_color(V_handle,display.dial_colours.bg_col);
	vsf_interior(V_handle,FIS_SOLID);
	vsf_color(V_handle,display.dial_colours.bg_col);
	vsf_interior(V_handle,FIS_SOLID);
	
	v_hide_c(V_handle);
	for(rl=rect_get_system_first(wind); rl; rl=rect_get_system_next(wind))				/* Walk the rectangle list */
	{
		set_clip(rl->x, rl->y, rl->w, rl->h);
		v_bar(V_handle,pnt);
		display_hslide(wind, widg);
	}
	v_show_c(V_handle,1);
}

unsigned long XA_wind_set(short clnt_pid, AESPB *pb)
{
	XA_WINDOW *w,*wl;
	OBJECT *ob;
	GRECT clip,our_win;
	XA_CLIENT *client=Pid2Client(clnt_pid);
	short wind=pb->intin[0],cmd=pb->intin[1],is_top;
	unsigned short *l;
	char *t;
	
	w=get_wind_by_handle(wind);

	if (w==NULL)
	{
		DIAGS(("WARNING:wind_set:Invalid window handle =%d\n",w));
		pb->intout[0]=0;			/* Invalid window handle, return error */
		return XAC_DONE;
	}

	if ((w->owner!=clnt_pid)		/* Clients can only change their own windows */
		&&((w!=root_window)||(cmd!=WF_NEWDESK)))
	{
		DIAGS(("WARNING: clnt %d cannot change window %d (not owner)\n",clnt_pid,w->handle));
		pb->intout[0]=0;			/* Invalid window handle, return error */
		return XAC_DONE;
	}
	
	switch(cmd)
	{
		case WF_HSLIDE:
			if (w->widgets[XAW_HSLIDE].stuff)
			{
				XA_SLIDER_WIDGET *slw=(XA_SLIDER_WIDGET*)(w->widgets[XAW_HSLIDE].stuff);
				short p=pb->intin[2];
				
				if (p<0) p=0;
				if (p>1000) p=1000;
				
				slw->position=p;
				
				update_hslide(w);
			}
			break;
		case WF_VSLIDE:
			if (w->widgets[XAW_VSLIDE].stuff)
			{
				XA_SLIDER_WIDGET *slw=(XA_SLIDER_WIDGET*)(w->widgets[XAW_VSLIDE].stuff);
				short p=pb->intin[2];
				
				if (p<0) p=0;
				if (p>1000) p=1000;
				
				slw->position=p;
				update_vslide(w);
			}
			break;
		case WF_HSLSIZE:
			if (w->widgets[XAW_HSLIDE].stuff)
			{
				XA_SLIDER_WIDGET *slw=(XA_SLIDER_WIDGET*)(w->widgets[XAW_HSLIDE].stuff);
				short p=pb->intin[2];
				
				if (p<0) p=0;
				if (p>1000) p=1000;
				
				slw->length=p;
				update_hslide(w);
			}
			break;
		case WF_VSLSIZE:
			if (w->widgets[XAW_VSLIDE].stuff)
			{
				XA_SLIDER_WIDGET *slw=(XA_SLIDER_WIDGET*)(w->widgets[XAW_VSLIDE].stuff);
				short p=pb->intin[2];
				
				if (p<0) p=0;
				if (p>1000) p=1000;
				
				slw->length=p;
				update_vslide(w);
			}
			break;
		case WF_NAME:
			l=(unsigned short*)(pb->intin);
			t=(char*)(l[2]<<16);
			t+=l[3];
			w->widgets[XAW_TITLE].stuff=(void*)t;

			v_hide_c(V_handle);
			if (w->is_open)
			{
				rp_2_ap(w, w->widgets+XAW_TITLE, &clip.g_x, &clip.g_y);
	
				clip.g_w=w->widgets[XAW_TITLE].w;
				clip.g_h=w->widgets[XAW_TITLE].h;

				display_non_topped_window(w,&clip);
			}
			v_show_c(V_handle,1);
			break;
		case WF_INFO:
			l=(unsigned short*)(pb->intin);
			t=(char*)(l[2]<<16);
			t+=l[3];
			w->widgets[XAW_INFO].stuff=(void*)t;

			v_hide_c(V_handle);
			if ((w->active_widgets&INFO)&&(w->is_open))
			{
				rp_2_ap(w, w->widgets+XAW_INFO, &clip.g_x, &clip.g_y);
	
				clip.g_w=w->widgets[XAW_INFO].w;
				clip.g_h=w->widgets[XAW_INFO].h;

				display_non_topped_window(w,&clip);
			}
			v_show_c(V_handle,1);
			break;

		case WF_CURRXYWH:			/* Move a window */
			move_window(w,pb->intin[2],pb->intin[3],pb->intin[4],pb->intin[5]);
			break;

		case WF_BOTTOM:				/* Extension, send window to the bottom */
			v_hide_c(V_handle);

			wl=w->next;
			is_top=(w==window_list);
			
			send_wind_to_bottom(w);			/* Send it to the back */

			our_win.g_x=w->x; our_win.g_y=w->y;
			our_win.g_w=w->w; our_win.g_h=w->h;
			
			while(wl!=root_window)
			{
				clip.g_x=wl->x; clip.g_y=wl->y;
				clip.g_w=wl->w; clip.g_h=wl->h;
				
				if (rc_intersect(&our_win,&clip))
				{
					display_non_topped_window(window_list,&clip);	/* Re-display any revealed windows */
					if (!(wl->active_widgets&NO_MESSAGES))
					{
						send_app_message(wl->owner, WM_REDRAW, 0, wl->handle, clip.g_x, clip.g_y, clip.g_w, clip.g_h);
					}
				}
				wl=wl->next;
			}
			
			if (is_top)
			{
				display_non_topped_window(window_list, NULL);	/* Re-display new top window */
				if (!(window_list->active_widgets&NO_MESSAGES))
				{
					send_app_message(window_list->owner, WM_ONTOP, 0, window_list->handle, 0, 0, 0, 0);
					send_app_message(window_list->owner, WM_REDRAW, 0, window_list->handle, window_list->wx, window_list->wy, window_list->ww, window_list->wh);
				}
			}

			v_show_c(V_handle,1);
			break;
			
		case WF_TOP:				/* Top the window */
			if (w->is_open)
			{
				Psemaphore(2,WIN_LIST_SEMAPHORE,-1L);

				pull_wind_to_top(w);
								/* New top window - change the cursor to this clients choice */
				graf_mouse(client->client_mouse, client->client_mouse_form);
			
				v_hide_c(V_handle);

				if ((window_list->next)&&(window_list->next->is_open))
					display_non_topped_window(window_list->next,NULL);
			
				Psemaphore(3,WIN_LIST_SEMAPHORE,0L);

				display_non_topped_window(w,NULL);	/* Display the window */

				v_show_c(V_handle,1);
				send_app_message(clnt_pid, WM_REDRAW, 0, w->handle, w->x, w->y, w->w, w->h);
			}
			
			break;
			
		case WF_NEWDESK:	/* Set a new desktop object tree */
			l=(unsigned short*)pb->intin;
			t=(char*)(l[2]<<16);
			t+=l[3];
			ob=(OBJECT*)t;
			
			if (ob)
			{
				client->desktop=ob;
				set_desktop(ob);
				root_window->owner=clnt_pid;
			}else{
				client->desktop=NULL;
				set_desktop((OBJECT*)ResourceTree(system_resources,DEF_DESKTOP));
			}

			v_hide_c(V_handle);
			display_non_topped_window(root_window,NULL);
			v_show_c(V_handle,1);
			
			break;
			
		case WF_AUTOREDRAW:		/* Set an auto-redraw callback function for the window */
			l=(unsigned short*)pb->intin;
			t=(char*)(l[2]<<16);
			t+=l[3];
			w->redraw=(WindowDisplayCallback)t;
			break;
			
		case WF_STOREBACK:		/* Set the window's 'preserve own background' attribute */
			w->background=(void*)malloc(display.planes*((w->w+35)>>2)*(w->h+20));
			w->bgx=-1;
			w->active_widgets|=STORE_BACK|NO_REDRAWS;
			break;
		
		case WF_ICONIFY:		/* Iconify a window */
			Psemaphore(2,WIN_LIST_SEMAPHORE,-1L);
			move_window(w,pb->intin[2],pb->intin[3],pb->intin[4],pb->intin[5]);
			w->window_status=XAWS_ICONIFIED;
			Psemaphore(3,WIN_LIST_SEMAPHORE,0L);
			break;

		case WF_UNICONIFY:		/* Un-Iconify a window */
			Psemaphore(2,WIN_LIST_SEMAPHORE,-1L);
			move_window(w,w->prev_x,w->prev_y,w->prev_w,w->prev_h);
			w->window_status=XAWS_OPEN;
			Psemaphore(3,WIN_LIST_SEMAPHORE,0L);
			break;

	}

	pb->intout[0]=1;
	return XAC_DONE;
}

/* AES wind_get() function. */
/* This includes support for most of the AES4 / AES4.1 extensions, */
/* with the exception of WF_BEVENT (all XaAES windows get button events in the */
/* background at the moment). */
unsigned long XA_wind_get(short clnt_pid, AESPB *pb)
{
	XA_WINDOW *w;
	XA_RECT_LIST *rl;
	XA_SLIDER_WIDGET *slw;
	short wind=pb->intin[0],cmd=pb->intin[1];
	GRECT s,d;
	
	w=get_wind_by_handle(wind);

	if (w==NULL)
	{
		DIAGS(("WARNING:wind_get:Invalid window handle =%d\n",wind));
		pb->intout[0]=0;			/* Invalid window handle, return error */
		return XAC_DONE;
	}

	pb->intout[0]=1;

	switch(cmd)
	{
		case WF_FIRSTXYWH:			/* Generate a rectangle list and return the first entry */
			Psemaphore(2,WIN_LIST_SEMAPHORE,-1L);
			rl=rect_get_user_first(w);
			if (rl)
			{
				s.g_x=rl->x;
				s.g_y=rl->y;
				s.g_w=rl->w;
				s.g_h=rl->h;
				d.g_x=w->wx;
				d.g_y=w->wy;
				d.g_w=w->ww;
				d.g_h=w->wh;
				rc_intersect(&s, &d);
				pb->intout[1]=d.g_x;	/* Return the first rectangle coords */
				pb->intout[2]=d.g_y;
				pb->intout[3]=d.g_w;
				pb->intout[4]=d.g_h;
			}else{
				pb->intout[1]=w->wx;	/* Totally obscured window, return w & h as 0 */
				pb->intout[2]=w->wy;
				pb->intout[3]=0;
				pb->intout[4]=0;
			}			
			Psemaphore(3,WIN_LIST_SEMAPHORE,0L);
			break;
			
		case WF_NEXTXYWH:			/* Get next entry from a rectangle list */
			Psemaphore(2,WIN_LIST_SEMAPHORE,-1L);
			rl=rect_get_user_next(w);
			if (rl)
			{
				s.g_x=rl->x;
				s.g_y=rl->y;
				s.g_w=rl->w;
				s.g_h=rl->h;
				d.g_x=w->wx;
				d.g_y=w->wy;
				d.g_w=w->ww;
				d.g_h=w->wh;
				rc_intersect(&s, &d);
				pb->intout[1]=d.g_x;	/* Return the first rectangle coords */
				pb->intout[2]=d.g_y;
				pb->intout[3]=d.g_w;
				pb->intout[4]=d.g_h;
			}else{
				pb->intout[1]=w->wx;	/* Totally obscured window, return w & h as 0 */
				pb->intout[2]=w->wy;
				pb->intout[3]=0;
				pb->intout[4]=0;
			}			
			Psemaphore(3,WIN_LIST_SEMAPHORE,0L);
			break;
			
		case WF_CURRXYWH:			/* Get the current coords of the window */
			pb->intout[1]=w->x;		/* Return the window coords */
			pb->intout[2]=w->y;
			pb->intout[3]=w->w;
			pb->intout[4]=w->h;
			break;
			
		case WF_WORKXYWH:			/* Get the current coords of the window's user work area */
			if(wind)
			{
				pb->intout[1]=w->wx;	
				pb->intout[3]=w->ww;
			}else{
				pb->intout[1]=w->x;
				pb->intout[3]=w->w;
			}
			pb->intout[4]=w->wh;
			pb->intout[2]=w->wy;
			break;
			
		case WF_PREVXYWH:			/* Get previous window position */
			pb->intout[1]=w->prev_x;
			pb->intout[2]=w->prev_y;
			pb->intout[3]=w->prev_w;
			pb->intout[4]=w->prev_h;
			break;			
			
		case WF_FULLXYWH:			/* Get maximum window dimensions */
			pb->intout[1]=root_window->x; 
			pb->intout[2]=root_window->wy;	/* ensure the windows don't overlay the menu bar */
			pb->intout[3]=root_window->w;
			pb->intout[4]=root_window->wh;
			break;
			
		case WF_BOTTOM:				/* Extension, gets the bottom window */
			Psemaphore(2,WIN_LIST_SEMAPHORE,-1L);
			for(w=window_list; w->next; w=w->next);
			Psemaphore(3,WIN_LIST_SEMAPHORE,0L);
			pb->intout[1]=w->handle;	/* Return the window handle of the bottom window */
			pb->intout[2]=w->owner;		/* Return the owner of the bottom window */
			break;
			
		case WF_TOP:
			Psemaphore(2,WIN_LIST_SEMAPHORE,-1L);
			w=window_list;
			Psemaphore(3,WIN_LIST_SEMAPHORE,0L);
			if (w)
			{
				pb->intout[1]=w->handle;	/* Return the window handle */
				pb->intout[2]=w->owner;		/* AES4 specifies that you return the AESid of the owner here as well */
				if (w->next)				/* Is there a window below?  */
				{							/* if there is, then AES4 says return it's handle here */
					pb->intout[3]=w->next->handle;
					pb->intout[4]=w->next->owner;	/* XaAES extentin - return the AESid of the app that owns the window below */
				}else{
					pb->intout[3]=0;
					pb->intout[4]=0;
				}
			}else{
				pb->intout[1]=0;	/* No windows open - return an error */
				pb->intout[0]=0;
			}
			break;
			
		case WF_OWNER:				/* AES4 compatible stuff */
			pb->intout[1]=w->owner;		/* The window owners AESid (==app_id) */
			pb->intout[2]=w->is_open;	/* Is the window open? */
			if (w->prev)				/* If there is a window above, return it's handle */
			{
				pb->intout[3]=w->prev->handle;
			}else{
				pb->intout[3]=0;
			}
			
			if (w->next)				/* If there is a window below, return it's handle */
			{
				pb->intout[4]=w->next->handle;
			}else{
				pb->intout[4]=0;
			}
			break;
			
		case WF_VSLIDE:
			if (w->active_widgets&VSLIDE)
			{
				slw=(XA_SLIDER_WIDGET*)(w->widgets[XAW_VSLIDE].stuff);
				pb->intout[1]=slw->position;
			}else{
				pb->intout[0]=pb->intout[1]=0;
			}
			break;
			
		case WF_HSLIDE:
			if (w->active_widgets&HSLIDE)
			{
				slw=(XA_SLIDER_WIDGET*)(w->widgets[XAW_HSLIDE].stuff);
				pb->intout[1]=slw->position;
			}else{
				pb->intout[0]=pb->intout[1]=0;
			}
			break;
			
		case WF_HSLSIZE:
			if (w->active_widgets&HSLIDE)
			{
				slw=(XA_SLIDER_WIDGET*)(w->widgets[XAW_HSLIDE].stuff);
				pb->intout[1]=slw->length;
			}else{
				pb->intout[0]=pb->intout[1]=0;
			}
			break;
			
		case WF_VSLSIZE:
			if (w->active_widgets&VSLIDE)
			{
				slw=(XA_SLIDER_WIDGET*)(w->widgets[XAW_VSLIDE].stuff);
				pb->intout[1]=slw->length;
			}else{
				pb->intout[0]=pb->intout[1]=0;
			}
			break;
			
		case WF_NEWDESK:
			Psemaphore(2,ROOT_SEMAPHORE,-1L);
			pb->intout[1]=((unsigned long)desktop&0xffff0000L)>>16;
			pb->intout[2]=(unsigned long)desktop&0x0000ffffL;
			Psemaphore(3,ROOT_SEMAPHORE,0L);
			break;
		
		case WF_ICONIFY:
			if(w->window_status==XAWS_ICONIFIED)
			{
				pb->intout[1]=1;
				pb->intout[2]=iconify_w;
				pb->intout[3]=iconify_h;
			}else{
				pb->intout[1]=0;
			}
			break;

		case WF_UNICONIFY:
			pb->intout[1]=w->prev_x;
			pb->intout[2]=w->prev_y;
			pb->intout[3]=w->prev_w;
			pb->intout[4]=w->prev_h;
			break;
		
	}
	
	return XAC_DONE;
}

short update_lock=FALSE;
short mouse_lock=FALSE;
short update_cnt=0;
short mouse_cnt=0;

#define	EACCESS	36		/* access denied */

/* Wind_update handling */
/* This handles locking for the update and mctrl flags. */
/* !!!!New version - uses semphores to locking... */
unsigned long XA_wind_update(short clnt_pid, AESPB *pb)
{
	short op=pb->intin[0];
	long timeout=(op&0x100)?0L:-1L;	/* test for check-and-set mode */

	pb->intout[0]=1;

	switch(op)
	{
		case BEG_UPDATE:	/* Grab the update lock */
		case BEG_UPDATE|0x100:
			if (update_lock==clnt_pid)   /* Already owning it? */
			{
				update_cnt++ ;
				break ;
			}
			if ( Psemaphore(2,UPDATE_LOCK,timeout)==-EACCESS )
			{
				pb->intout[0]=0;	/* screen locked by different process */
				break ;
			}
			update_lock=clnt_pid;
			update_cnt=1 ;
			break;
		case END_UPDATE:
			if ((update_lock==clnt_pid)&&(--update_cnt==0))
			{
				update_lock=FALSE;
				Psemaphore(3,UPDATE_LOCK,0);
			}
			break;
		case BEG_MCTRL:		/* Grab the mouse lock */
		case BEG_MCTRL|0x100:
			if (mouse_lock==clnt_pid)   /* Already owning it? */
			{
				mouse_cnt++ ;
				break ;
			}
			if ( Psemaphore(2,MOUSE_LOCK,timeout)==-EACCESS )
			{
				pb->intout[0]=0;	/* mouse locked by different process */
				break ;
			}
			mouse_lock=clnt_pid;
			mouse_cnt=1 ;
			break;
		case END_MCTRL:
			if ((mouse_lock==clnt_pid)&&(--mouse_cnt==0))
			{
				mouse_lock=FALSE;
				Psemaphore(3,MOUSE_LOCK,0);
			}
			break;
	}
	return XAC_DONE;
}

unsigned long XA_wind_delete(short clnt_pid, AESPB *pb)
{
	XA_WINDOW *w=get_wind_by_handle(pb->intin[0]);

	if (w)
	{
		delete_window(w);
	}
	
	pb->intout[0]=1;
	
	return XAC_DONE;
}

/* Go through and check that all windows belonging to this client are */
/* closed and deleted  */
unsigned long XA_wind_new(short clnt_pid, AESPB *pb)
{
	XA_WINDOW *wl,*nwl;

	for(wl=window_list; wl; wl=nwl)
	{
		nwl=wl->next;
		
		if ((wl->owner==clnt_pid)&&(wl!=root_window))
		{
			close_window(wl);
			delete_window(wl);
		}
	}
	
	return XAC_DONE;
}

/*
	wind_calc
*/
unsigned long XA_wind_calc(short clnt_pid, AESPB *pb)
{
	XA_WINDOW *w_temp;
	short request=pb->intin[0];
	
/* Create a temporary window with the required widgets */
	w_temp=create_window(clnt_pid, pb->intin[1], pb->intin[2], pb->intin[3], pb->intin[4], pb->intin[5]);

	switch(request)
	{
		case WC_BORDER:					/* We have to work out the border size ourselves here */
			pb->intout[1]=2*w_temp->x - w_temp->wx;	/*if you want to prove the maths here, draw two boxes one inside */
			pb->intout[2]=2*w_temp->y - w_temp->wy;	/* the other, then sit and think about it for a while.... */
			pb->intout[3]=2*w_temp->w - w_temp->ww +1;
			pb->intout[4]=2*w_temp->h - w_temp->wh +1;
			break;
		case WC_WORK:					/* Work area was calculated when the window was created */
			pb->intout[1]=w_temp->wx;
			pb->intout[2]=w_temp->wy;
			pb->intout[3]=w_temp->ww+1;
			pb->intout[4]=w_temp->wh+1;
			break;
	}

	delete_window(w_temp);		/* Dispose of the temporary window we created */

	pb->intout[0]=1;
	
	return XAC_DONE;
}
