# any user can delete the contents of 'drwxrwxrwx' directories!
# So, by default, any directory will have the access rights 'drwxr-wr-w'
# and any file '-rw-r--r--'. But do not forget the top drive!
# type the following commands: "cd U:"  "chmod 755 e" (my drive is E) 
# any user may still try "rm -r e", any unprotected directory will be
# emptied!!!
umask 022

#
# special tcsh alias: a command that gets executed before every prompt
# this makes sure the cursor is on
# (unfortunately, this leaks memory, so it's best not to use it :-(
# alias precmd 'echotc ti'

#
# atariST extension: use ^ instead of \ as an escape character,
# so that  \ can be used more conveniently in file names
#
set escchar=^

#
# atariST extension: use \ in preference to / when completing names,
# doing ls-F, etc. Set this variable only if you have set escchar to
# something other than \
#
# set dosslashes
#

#
# misc. standard csh variables get set here
#
set history=25
set autolist
#set prompt='csh(^!) '
set prompt='>'

#
# with MiNT 0.93+, you can set terminals to send vt52 escape sequences
# when cursor/function keys are pressed. we do that here (it assumes
# that the "stty" program is on your search path) and set some
# bindings
#
# stty vt52 # this really should be done in mint.cnf or login.csh

bindkey "^[A" up-history
bindkey "^[B" down-history
bindkey "^[C" forward-char
bindkey "^[D" backward-char

# these match gulam's use of Insert and Clr/Home

bindkey "^[E" list-choices
bindkey "^[I" complete-word

#
# note: in PATH, use "/dev/c" in place of "c:". If you're using MiNT
# and drive U:, you don't need to worry about this, since all your
# paths can be absolute
#
setenv HOME /usr/users/gl
#setenv PATH :/dev/e/bin:/dev/e/usr/bin:/dev/e/usr/users/gl/bin:/dev/e/usr/gnu/bin
setenv PATH :/bin:/usr/bin:/usr/users/gl/bin:/usr/gnu/bin
rehash

#
# aliases:
#

alias ll ls -l -a
alias unzoo zoo x//
alias unzip zip -x
alias uncompress compress -d
alias cdc "cd $HOME/c"
alias home "cd $HOME"
alias cc gcc
alias ro "rm *.o"
alias mf mfsconf
alias mn "mfsconf e: -l t -s t"
alias mu "mfsconf e: -l n -s n"
alias ms mfsconf e:
alias mc "make clean"
alias strip xstrip

cd U:/
cd $HOME

mfsconf e: -d n

echo 'Unix session Falcon 030'
echo ""

