/******************************************************************************/
/*                                                                            */
/* 	TP : REALISATION D'UN TABLEUR EN C++                                  */
/*                                                                            */
/*	binome : b21                                                          */
/*		JOUIN Christophe                                              */
/*		LAMONOCA Guillaume                                            */
/*                                                                            */
/*	fichier : entier.C                                                    */
/*                                                                            */
/*	role : definir des entiers gerant en interne les erreurs de calculs   */
/*		comme les divisions par zero                                  */
/*                                                                            */
/******************************************************************************/
#include "entier.h"

/*-----------------------------*/
/*	FONCTIONS MEMBRES      */
/*-----------------------------*/

Entier::Entier(long v,int e)
{
	val=v;
	err=e;
}

int Entier::type_erreur(void)
{
	return err;
}

/*-----------------------------*/
/*	FONCTIONS AMIES	       */
/*-----------------------------*/

Entier operator-(const Entier &e1)
{
 	return Entier(-e1.val,e1.err);
}

Entier operator-(const Entier &e1,const Entier &e2)
{
 	return Entier(e1.val-e2.val,e1.err|e2.err);
}

Entier operator+(const Entier &e1,const Entier &e2)
{
 	return Entier(e1.val+e2.val,e1.err|e2.err);
}

Entier operator*(const Entier &e1,const Entier &e2)
{
 	return Entier(e1.val*e2.val,e1.err|e2.err);
}

Entier operator/(const Entier &e1,const Entier &e2)
{
	if (e2.val==0)
 		return Entier(0,ERRDIV0|e1.err|e2.err);
	else
 		return Entier(e1.val/e2.val,e1.err|e2.err);
}

Entier operator%(const Entier &e1,const Entier &e2)
{
	if (e2.val==0)
 		return Entier(0,ERRMOD0|e1.err|e2.err);
	else
 		return Entier(e1.val%e2.val,e1.err|e2.err);
}


ostream &operator<<(ostream &s, const Entier &e)
{
	if (e.err&ERRDIV0) s<<"(Erreur:division par zero)";
	if (e.err&ERRMOD0)  s<<"(Erreur:modulo zero)";
	s<<e.val;
	return s;
}


Entier abs(const Entier &e)
{
   if (e.val>=0) return e;
   return Entier(-e.val,e.err);
}
