/******************************************************************************/
/*                                                                            */
/* 	TP : REALISATION D'UN TABLEUR EN C++                                  */
/*                                                                            */
/*	binome : b21                                                          */
/*		JOUIN Christophe                                              */
/*		LAMONOCA Guillaume                                            */
/*                                                                            */
/*	fichier : entier.h                                                    */
/*                                                                            */
/*	role : definir des entiers gerant en interne les erreurs de calculs   */
/*		comme les divisions par zero                                  */
/*                                                                            */
/******************************************************************************/
#ifndef ENTIER_H
#define ENTIER_H

#include <iostream.h>

/*
 * constantes de numero d'erreurs envoyees par la fonction membre type_erreur 
 *
 */

#define NOERROR	0	// pas d'erreur
#define ERRDIV0	1	// le calcul de ce nombre a demande une division par zero
#define ERRMOD0	2	// le calcul de ce nombre a demande un calcul mod(x;0)


class Entier
{
	long val;	// valeur de l'entier
 	int err;	// erreurs survenues lors du calcul de ce nombre
public :

/*-----------------------------*/
/*	FONCTIONS MEMBRES      */
/*-----------------------------*/

/*
 * ROLE :  constructeur, val est la valeur et err est un numero d'erreur
 *	   permet aussi la conversion automatique d'un int ou long en Entier
 */
	   Entier(long val =0,int err=NOERROR);

/*
 * ROLE :  permet de recuperer l'erreur associe a un Entier 
 */
	int type_erreur(void);


/*-----------------------------*/
/*	FONCTIONS AMIES	       */
/*-----------------------------*/

/*
 * NB : les operateurs sont definis en friend et non en fonctions membres
 * afin de permettre le calcul entre un Entier et un int ou long
 * grace a la conversion automatique d'un int en Entier ...
 */

/*
 * ROLE :  redefini le moins unaire pour Entier (propage les erreurs de
 *		l'operande dans le resultat
 */

	friend Entier operator-(const Entier &);

/*
 * ROLE :  redefini l'operation binaire plus pour Entier (propage les erreurs des
 *		operandes dans le resultat
 */
	friend Entier operator+(const Entier &, const Entier &);

/*
 * ROLE :  redefini l'operation binaire moins pour Entier (propage les erreurs des
 *		operandes dans le resultat
 */
	friend Entier operator-(const Entier &, const Entier &);

/*
 * ROLE :  redefini l'operation binaire multiplication pour Entier 
 * 	(propage les erreurs des operandes dans le resultat )
 */
	friend Entier operator*(const Entier &, const Entier &);

/*
 * ROLE :  redefini l'operation binaire division pour Entier
 *	si une division par zero est demandee le resultat donne
 *	un Entier de valeur 0 et d'erreur ERRDIV0 
 * 	(propage les erreurs des operandes dans le resultat )
 */
	friend Entier operator/(const Entier &, const Entier &);

/*
 * ROLE :  redefini l'operation binaire reste pour Entier
 *	si le reste d'une division par zero est demandee le resultat donne
 *	un Entier de valeur 0 et d'erreur ERRMOD0 
 * 	(propage les erreurs des operandes dans le resultat )
 */
	friend Entier operator%(const Entier &, const Entier &);

/*
 * ROLE :  permet l'affichage d'un Entier 
 */
	friend ostream &operator<<(ostream &, const Entier &);

/*
 * ROLE : defini la fonction ABS pour Entier
 * 	(propage les erreurs des operandes dans le resultat )
 */

	friend	Entier abs(const Entier &);
};

#endif
