/*/////////////////////////////////////////////////////////////////////*/
/*//////////////////////////   EZ_02.C    /////////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
/* Ce module est le source C du programme: EZ_02.PRG                   */
/* Le fichier projet associ est:          EZ_02.PRJ                   */
/* Comment ouvrir et grer un dialogue en fenetre avec une seule       */
/* fonction !!!!                                                       */
/*                                                                     */
/*CHARGER LE PROJET DE CE PROGRAMME:                                   */
/*----------------------------------                                   */
/* selectionner  l'aide de, titre: "Project", option: "Select" du     */
/* du menu de Pure C, le fichier: EZ_02.PRJ.                           */
/* Ce programme tout simple ouvre une fenetre EAZY_GEM contenant un    */
/* dialogue d'un fichier ressource EZ_02.RSC                           */
/* Les nombreux commentaires permettent de s'y retrouver, et servent   */
/* de premire leon de programmation EAZY_GEM.                        */
/* Ne vous effrayez pas devant la taille de ce source, enlevez les     */
/* commentaires et vous verez qu'il est ridiculement petit et facile   */
/* de grer et ouvrir une fenetre sous EAZY_GEM.                       */
/* Le fichier: EZ_02.TXT est ce fichier source pur de tous les trucs */
/*     inutiles et commentaires 72 lignes en tout et pour tout !!!!    */

 
/*/////////////////////////////////////////////////////////////////////*/
/*////////////////////////// I N C L U D E S //////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
/*--------------------- INCLUDES DES AUTRES MODULES DU PROGRAMME -------*/
#include <EAZY_GEM.H>  /* inclure les definitions des fonctions que le  */
                       /* que le module EAZY_GEM.LIB met  votre et     */
                       /* notre disposition                             */ 
                       /* et inclure les definitions des variables      */
                       /* globales  d'EAZY_GEM                          */
                       /* Je rappelle que le fichier EAZY_GEM.H et le   */
                       /* fichier EAZY_GEM.LIB doivent se trouver dans  */
                       /* les repertoires INCLUDE (pour le .H) et LIB   */
                       /* (pour le .LIB) de votre Pure C.               */ 
/* C'est  cause de cette ligne que vous avez le droit d'utiliser les   */
/* fonctions d'EAZY_GEM.                                                */                       
/* La lecture de ce fichier peut vous renseigner sur tout un tas de     */
/* choses. Il est toujours instructif de regarder les fichiers .H       */

/*--------------------- INCLURE LES DEFINITIONS SYMBOLIQUES ------------*/
/*                      que l'diteur de ressource gnre               */
/*                      lors de la cration de la ressource             */
#include "EZ_02.RSC\EZ_02.H"    
                      /* l'inclusion des dfinitions symboliques permet */
                      /* d'utiliser des symboles literaux plus parlants */
                      /* qu'un nombre, pour les numero d'objets.        */
                      /* Il est vident qu'il est impratif de nommer   */
                      /* les objets dans votre editeur de ressources    */
                      /* pour que le fichier.H correspondant soit       */
                      /* interessant.                                   */
/*//////////////////////////////////////////////////////////////////////*/
/*////////////////////////// D E F I N E S  ////////////////////////////*/
/*//////////////////////////////////////////////////////////////////////*/ 
/*                         TYPAGE DES FENETRES                          */ 
/*----------------------------------------------------------------------*/ 
/* Dans EAZY_GEM, chaque fenetre doit avoir un numro unique. Celui-ci  */
/* permet par la suite d'interroger EAZY_GEM pour savoir si la fenetre  */
/* correspondant  ce numero existe, ou est ouverte, ou etc....         */
/* Par exemple j'cris un programme comportant deux dialogues: un pour  */
/* parametrer les couleurs, et un autre affichant un choix de trames    */
/* couleurs. Chacun de ses dialogues tant dans une fenetre diffrente, */
/* lorsque je modifie les couleurs avec le premier dialogue, il faut    */
/* repercuter la modification de couleur, sur tous les autre dialogues  */
/* concerns afin de les mettre  jour. Pour cela il me faut savoir si  */
/* ils existent, et sont ouverts, et auquel cas les mettre  jour, et   */
/* envoyer un message leur demandant de reafficher les lments         */
/* concerns par la modification du premier dialogue.                   */
/* On peut appeler a grer les multi-dpendances inter-dialogue.       */

/* Plutot que de manipuler un nombre abstrait qui ne me dit rien  je    */
/* prfre dfinir un symbole plus parlant, que j'utiliserai par la     */
/* suite dans le programme  la place du nombre, d'ou les lignes:       */
/* #define ci_dessous. (ici qu'une ligne car une seule fenetre)         */      
 
#define W_EZ_02       1     /* (identificateur ou type) de la Fenetre   */
                            /* on peut choisir n'importe quel nombre    */
                            /* entre 1 et 32000 ('est assez non ?)     */
                            /* Il est impratif que deux fenetres n'    */
                            /* aient pas le meme nombre.                */

/*//////////////////////////////////////////////////////////////////////*/
/*////////////// V A R I A B L E S    G L O B A L E S //////////////////*/
/*//////////////////////////////////////////////////////////////////////*/
/* il n' y en a pas pour cet exemple !!                                 */

/*//////////////////////////////////////////////////////////////////////*/
/*/////////////// P R O T O T Y P E S  F O N C T I O N S ///////////////*/
/*//////////////////////////////////////////////////////////////////////*/

/*................ FONCTIONS CALLBACK DE FENETRES ......................*/
/* Dans EAZY_GEM,  chaque fenetre est associe une fonction CALLBACK.  */
/* CALLBACK veut dire mot  mot: appel arrire, en plus clair une       */
/* fonction CALLBACK, veut dire une fonction de rappel.                 */
/* Le principe est que vous DONNEZ  EAZY_GEM l'adresse de la fonction  */
/* de gestion qui va grer la fenetre que vous dsirez ouvrir, et que   */
/* c'est EAZY_GEM, qui RAPELLERA votre fonction selon les diffrentes   */
/* actions et vnements la concernant. L'intrt c'est qu'EAZY_GEM     */
/* traite pour vous tout un tas de choses ennuyeuses et difficiles, et  */
/* qu'il vous fait signe et laisse  votre charge ce qu'il ne peut pas  */
/* traiter ni prvoir, en rappelant votre fonction.                     */
/* Cette faon de faire permet aussi une meilleure structuration des    */
/* programmes car pour chaque fenetre il existe une seule fonction de   */
/* traitement.                                                          */
/* Toute la messagerie et l'vnementiel GEM classique est transmis    */
/* la fonction CALLBACK de Fenetre, plus d'autres messages spcifiques  */
/*  EAZY_GEM, que nous verons petit  petit dans les exemples.         */
/* En rponse aux messages et vnements GEM il est possible de les     */
/* traiter tout  fait classiquement, ou comme je vous le conseille de  */
/* faire appel aux fonctions qu'EAZY_GEM met  votre disposition.       */
/* L'accs aux fonctions tendues de gestion de ressource en fenetre et */
/* autres aspect pointus d'EAZY_GEM ne se fait bien videment qu'au     */
/* travers des fonctions prvues pour cela.                             */
/*                                                                      */
/* Ces principes de programmation peuvent apparaitre difficiles pour    */
/* ceux qui n'y sont pas habitus, mais aprs un effort d'adaptation    */
/* minime, l'on regrette de ne pas l'avoir fait avant, tellement la     */
/* programmation sous GEM semble ensuite facile !!!.                    */ 

/* ICI je dclare le nom et le prototype de la fonction de fenetre qui  */
/* traitera tout ce qui concerne la fenetre que l'on va ouvrir.         */

static CALLBACK WindProcEZ_02(int w_ind, EVNT_O *Evnt);

/*//////////////////////////////////////////////////////////////////////*/
/*                A   C O M M E N C E   I C I   !!!!                   */
/*              Definition des fonctions de ce module                   */
/*//////////////////////////////////////////////////////////////////////*/
 
/*---------------------------- main ------------------------------------*/
void main (void)
{/*.............. LES DEUX VARIABLES SUIVANTES DOIVENT ETRE ............*/
 /*           MODIFIEES AVANT APPEL A LA FONCTION: InitEazyGem()        */ 
 /*       les valeurs par dfaut suffisent dans la majorit des cas     */
 /*          Ici je les modifie pour montrer comment faire              */
 
 MAX_TTIPS = 100; /* nbr maxi de structures TOOL_TIPS permises.         */
                  /* ici ce programme utilise les fonctions de          */
                  /* ressource en fenetre qui utilisent les bulles      */
                  /* d'aide, donc reserver la place des bulles d'aide   */
                  /* 100 est amplement suffisant.                       */
 MAX_WIND  = 2;   /* nbr maxi de fenetres que notre application, permet */
                  /* de crer en meme temps. Ici on en autorise deux.   */
                  /* celle que l'on va ouvrir, et celle des Alert en    */
                  /* fenetre. Par defaut ce nombre est de 7.            */ 

 if (InitEazyGem("EZ_02.PRG") != -1)    /* Cette fonction initialise le */
                                        /* systme d'EAZY_GEM, elle dem-*/
                                        /* ande le nom du programme.    */ 
                                        /* si elle retourne -1 alors il */
                                        /* est impossible de poursuivre */                                    
   
    {/*................... crer et Ouvrir une fenetre ...................*/    
     CreateWindow(             /*........ ATTRIBUTS GEM CLASSIQUES .......*/
                  SMALLER|     /* je veux la case d'iconification         */
                  CLOSER |     /* je veux la case de fermeture            */
                  NAME   |     /* je veux la barre de titre.              */
                  MOVER  |     /* je veux bouger la barre de titre        */
                               /*........ ATTRIBUTS EAZY_GEM .............*/
                  BORDER |     /* Je veux la bordure spciale EAZY_GEM    */             
                  XMOVER       /* je veux la poigne de dplacement       */                  
               /* XSIZER */,   /* La fenetre n'a pas besoin d'etre        */
                               /* redimensionnable car elle affiche une   */
                               /* boite de dialogue simple.               */
                  
                  W_EZ_02,     /* fournir le type de la fenetre           */  
                     
                  0L,          /* Il n'y a pas de parametres special      */                               
                               
                  WindProcEZ_02,    /* fournir l'adresse de la fonction   */
                                    /* CALLBACK qui sera charge de grer */
                                    /* cette fenetre.                     */
                  0,0,0,0,          /* Dimensions externes de la fenetre  */
                                    /* sur zero car elle seront           */
                                    /* automatiquement ajuste sur celles */
                                    /* de la boite de dialogue.           */
                  "FENETRE DIALOGUE"); /* titre de la fenetre             */
     
     /*.................... Passer la main  EAZY_GEM ....................*/
     /* Apres appel de cette fonction l'on a qu'a attendre qu'EAZY_GEM    */
     /* rappelle notre fonction CALLBACK.                                 */
     /* La seule faon de sortir est de mettre la variable: EZGemRun     */
     /* Zero (sortie avec demande de confirmation)  ou                    */
     /* -1.  (sortie sans demande de confirmation)                        */
     BouclePrincipale(0L);  /* on passe 0 comme parametre car ce petit    */
                            /* programme ne comporte ni menu GEM ni       */
                            /* fonction de traitement par dfaut.         */              
    }
 /*........... appel indispensable pour finir un programme ...............*/
 /*                       EZ_GEM proprement                               */ 
 ExitEasyGem();   
}


/*------------------------------ WindProcEZ_02 ---------------------------*/
/* Fonction de gestion de la fenetre de ce programme. Dans EAZY_GEM il    */
/* y a une fonction comme celle-ci, par fenetre, qui va etre appelle par */
/* EAZY_GEM chaque fois qu'un vnement ou message concerne la fenetre   */
/* laquelle elle est associe.                                            */

/* En entree: int w_ind est l'indice EAZY_GEM de cette fenetre.Cet indice */
/* permet daccder  la table de parametres de cette fenetre: Windtab.    */
/* et d'accder  ses lments: par exemple le handle GEM de la fenetre   */
/* est accd comme suit: Windtab[w_ind].w_h                              */

/* En entree: EVNT_O *Evnt est l'adresse (pointe sur) une structure de    */
/* type EVNT_O (voir doc et fichier EAZY_GEM.H) qui contient les donnes  */
/* d'vnements et de messages que la fonction de fenetre est appele    */
/* traiter.                                                               */

CALLBACK WindProcEZ_02(int w_ind, EVNT_O *Evnt)
{
 /*............................Rpondre  l'vnement MU_KEYBD .........*/
 /* L'vnement MU_KEYBD se manifeste chaque fois qu'une touche clavier */
 /* est appuye.                                                        */ 
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec une touche clavier  */
 /* Notamment l'edition et saisie de texte dans les champs editables et */
 /* les raccourcis clavier.                                             */
 /* Pour une ressource en fenetre il est indispensable que l'evenement  */
 /* MU_KEYBD soit traite avant l'evenement  MU_BUTTON afin de permettre */
 /* un fonctionnement correct des raccourcis clavier. En effet le       */
 /* raccourci clavier d'un objet simule un clic souris sur l'objet.     */
 /* en renvoyant un evenement MU_BUTTON                                 */
 /* Nous vrifions avant si la fenetre est au premier plan car si ce    */
 /* n'est pas le cas, elle n'a pas  traiter le clavier.                */
 
 if (Evnt->evnt & MU_KEYBD)
    {int wh_top;                    /* handle fenetre en avant plan     */
     wind_get( 0, WF_TOP, &wh_top); /* recuperer handle fen. avt plan.  */
     if (Windtab[w_ind].w_h == wh_top ) Xform_keybd(w_ind, Evnt);
    }
    
 /*.......................... Rpondre  l'vnement MU_BUTTON .........*/ 
 /* L'vnement MU_BUTTON se manifeste chaque fois qu'un bouton de la   */
 /* souris est appuy.                                                  */ 
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec un appui sur un     */
 /* bouton de souris: Xform_button() .                                  */
 /* Notamment l'appui sur un bouton de la ressource, la selection du    */
 /* texte dans les champs editables, et le placement du curseur de      */
 /* texte dans les champs editables.                                    */
 /* en retour cette fonction donne le numro d'objet cliqu, si bien sur*/
 /* un objet de type TOUCHE_EXIT ou SELECTABLE est cliqu.              */
 
 if (Evnt->evnt & MU_BUTTON)
    {int ob_ret;                /* recevra le numero d'objet cliqu     */
     OBJECT *object;            /* pointeur d'objet pour les ressources */
     ob_ret = Xform_button(w_ind, Evnt);     
     if (ob_ret>-1)            /*<<<<SI UN OBJET EST CLIQUE >>>>>>>>>>>*/
        {/*.... empecher propagation message  MU_BUTTON ...............*/
         /*     de faon  ce qu'il ne soit pas possible de            */
         /*     cliquer sur deux fenetres  la fois.                   */
         Evnt->evnt &= ~MU_BUTTON;  
         
         /*....recuperer l'adresse du premier objet de la ressource....*/ 
         object=Windtab[w_ind].DlgVar.tree;   
         
         /*.......le remettre en non selectionn et le redessiner......*/         
         object[ob_ret].ob_state &= ~SELECTED;  
         /*       
         if (object[ob_ret].ob_type &((G_CICON<<8)|G_USERDEF))           
             SendObjectRedraw( Windtab[w_ind].w_h, object, ob_ret); 
         else
             Xobjc_draw(object, ob_ret, 1, &grect); 
         */     
         /*.............. ICI ACTION SELON BOUTON CLIQUE..............*/
         /* j'ai mis en commentaire comment il est possible de tester */
         /* et lancer une action selon l'objet cliqu. Utilisez les   */
         /* symboles du fichier .H de la ressource (ici EZ_02.H) afin */
         /* de rendre votre programme plus lisible.                   */
                     
         /* switch (ob_ret)            */
         /*   {case TRUC:              */
         /*         FaireTruc();       */   
         /*         break;             */
         /*    case MACHIN:            */
         /*         FaireMachin();     */   
         /*         break;             */
         /*   }                        */     
        }  /* endif objet selectable cliqu  */ 
    } /* endif MU_BUTTON  et fenetre au premier plan */
 
 /*.......................... Rpondre  l'vnement MU_TIMER.............*/
 /* L'vnement MU_TIMER se manifeste approximativement toutes les 200 ms */  
 /* Dans le cadre d'une ressource en fenetre la fonction: Xform_timer     */
 /* s'occupe de tout ce que doit gerer le timer notamment le clignote     */
 /* ment du curseur texte dans les champs editables                       */
 /* Nous vrifions avant si la fenetre est au premier plan car si ce      */
 /* n'est pas le cas, elle n'a pas  faire clignoter le curseur texte.    */
 
 if (Evnt->evnt & MU_TIMER)  
    {int wh_top;                    /* handle fenetre en avant plan     */
     wind_get( 0, WF_TOP, &wh_top); /* recuperer handle fen. avt plan.  */
     if (Windtab[w_ind].w_h == wh_top ) Xform_timer(w_ind);    
    }
   
 /*..........................Rpondre  l'vnement MU_MOVE ..............*/
 /* L'vnement MU_MOVE se manifeste chaque fois que la souris a modifie  */
 /* sa position. L'appel  la fonction: Xform_mu_move() permet de traiter */
 /* tout ce qui concerne un mouvement souris au dessus d'une ressource en */
 /* fenetre et le mouvement de la souris au dessus du bord de la fenetre. */
 
 if (Evnt->evnt & MU_MOVE)   /*  (EZGEM evenement)   */
    {Xform_mu_move(w_ind, Evnt);
    }       
    
 /*..........................Rpondre aux messages MU_MESAG ..............*/
 /* L'vnement MU_MESAG se manifeste chaque fois qu'EAZY_GEM demande    */
 /* la fonction de fenetre de rpondre  un message. ci_dessous nous      */
 /* allons rpondre aux messages concernant notre fenetre.                */
   
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {case WM_CONSTRUCT:
             /***********************************************************/
             /*.................... WM_CONSTRUCT (EZGEM message)........*/
             /* Ce message est transmis avant la creation et ouverture  */
             /* de la fenetre associee  notre procedure de fenetre.    */
             /* c'est  cet endroit que vous devez initialiser tout ce  */
             /* qui concerne votre fenetre: Memoire, chargement d'un    */
             /* fichier ressource, modification des dimensions fenetre  */
             /* avant ouverture, declaration des Bulles d'aide associees*/
             /*  cette fenetre, titre de la fenetre.....etc            */
             /* eventuellement si pas deja fait avant: ouverture d'une  */
             /* Station de travail VDI autre que celle d'EAZY_GEM.      */  
             /* EAZY_GEM vous laisse toute liberte pour faire ce que    */
             /* vous voulez:                                            */
             /* Vous pouvez tres bien charger votre fichier ressource  */    
             /* cet endroit ou avant dans l'application..               */
             /* Lors de ce message il est donn dans:                   */
             /*                  Evnt->pipe[X_B]                        */
             /*                  Evnt->pipe[Y_B]                        */
             /*                  Evnt->pipe[W_B]                        */
             /*                  Evnt->pipe[H_B]                        */
             /*                               les dim exterieures  maxi */
             /* possibles d'ouverture de la fenetre sur l'ecran.        */ 
             /* c'est par defaut ces dimensions qui sont choisies pour  */
             /* ouvrir une fenetre.Si on veut d'autres dimensions c'est */
             /* ces valeurs qu'il faudra modifier.                      */
             /*                                                         */
             /* REPONDRE AU MESSAGE WM_CONTRUCT:                        */
             /* Il est possible de repondre au message WM_CONSTRUCT     */
             /* de deux manieres equivalentes au point de vue resultat: */
             /* Soit en faisant  Evnt->evnt = WM_ABORT; (ou WM_STANDBY) */
             /* Soit en faisant  return WM_ABORT;       (ou WM_STANDBY) */                
             /*                                                         */
             /* Vous pouvez interrompre le processus de creation de la  */
             /* fenetre en retournant le message: WM_ABORT par exemple  */
             /* vous n'avez pas pu reserver toute la memoire souhaitable*/
             /* ou vous n'avez pas trouve un fichier indispensable      */
             /* ou pour toute autre raison liee a votre application.etc.*/
             /*                                                         */
             /* Vous pouvez empecher l'ouverture de la fenetre et donc  */
             /* permettre juste sa creation en retournant le message:   */   
             /* WM_STANDBY. Pour ouvrir et afficher la fenetre ulterieu-*/
             /* ment il faudra utiliser la fonction: OpenWindow         */
             /* Si vous ne retournez pas ce message la fenetre s'ouvre  */
             /* dans la foulee (cas le plus utile).                     */                           
             /*                                                         */
             
             
             /*........... ICI nous allons charger un fichier ..........*/
             /*           de ressource en memoire et integrer           */
             /*           un dialogue (ici le premier et seul arbre) de */
             /*           cette ressource,  notre fenetre              */
             
             /*...... Chargement et relogement du fichier ressource ....*/
             /*       l'adresse de chargement doit obligatoirement      */
             /*       etre stocke dans la structure DLG_VAR:           */
             /*       Windtab[wind].DlgVar.AdrRsc de la fenetre         */  
             
             Windtab[w_ind].DlgVar.AdrRsc = LoadAppliRsc( "EZ_02.RSC", SCALE); 
             
             /*...... Si russite du chargement de la ressource ........*/
             /*       il faut integrer un des arbres de cette           */
             /*       ressource  la fenetre                            */            
             if (Windtab[w_ind].DlgVar.AdrRsc)  
                {
                 /*     indiquer le type d'integration desir           */
                 /*     ici type dialogue simple en fenetre             */
                 Windtab[w_ind].DlgVar.type    = RSC_DIAL;
                
                 /*      indiquer le numero de l'arbre  integrer       */
                 Windtab[w_ind].DlgVar.NumTree = 0; 
                 
                 /*      integrer la ressource  la fenetre             */
                 Xform_construct(w_ind, Evnt);
                }                     
             else
                {/*      si echec du chargement annuler la              */
                 /*      creation de la fenetre                         */
                 return WM_ABORT;         
                }
                  
             /*........... placer le tout sous la souris ..................*/
             /* EAZY_GEM met  votre disposition une fonction qui centre   */
             /* le rectangle donn en entre, sur la position de la souris */
             /* tout en restant dans les limites de l'ecran.               */
             /* J'en profite ici pour recentrer la fenetre sur la souris   */
             /* avant son ouverture.                                       */ 
              AdjustWindCoordToScreen (w_ind, Evnt, (GRECT*)&Evnt->pipe[X_B]);              
             break;
             
        case WM_DESTRUCT:       /*  (EZGEM message)   */
             /**************************************************************/              
             /*........................ WM_DESTRUCT (EZGEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre avant   */
             /* que le systeme ne la detruise. c'est  cet endroit qu'il   */
             /* convient de desinitialiser tout ce que l'on avait fait     */
             /* auparavant memoire, bulles d'aide, ressources....          */                          
             
             /*            desintegrer l'arbre de la fenetre               */
             /*         (enfin un mot qui prend tout son sens)             */
             Xform_Destruct(w_ind, Evnt);    
             
             /*            decharger la ressource de la memoire            */
             /*                  et liberer la memoire                     */
             RscFicUnLoad(Windtab[w_ind].DlgVar.AdrRsc);                
             break;   
             
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             /**************************************************************/
             /*...................... WM_TT_ON_OFF (EZGEM message).........*/
             /* Ce message est envoy  notre fenetre chaque fois qu'il est*/
             /* demand d'activer ou de desactiver l'affichage des bulles  */
             /* d'aide. Il suffit simplement d'appeler la fonction qui suit*/
             /* pour mettre  jour l'objet representant l'etat actif ou    */
             /* inactif de notre ressource (si il existe)                  */
             /* Cet Objet est un objet type BOXTEXT extended type 25 que   */ 
             /* vous pouvez placer sur tout formulaire.                    */ 
             /* c'est le petit truc jaune affich en haut  droite de la   */
             /* boite de dialogue.                                         */                                
             /* Si un objet de ce type est plac dans votre formulaire Il  */
             /* refletera automatiquement l'etat actif ou inactif du       */
             /* systeme de bulle d'aide. L'appel de la fonction:           */ 
             /* SetBulleState()  recherche tous les objets du type decrit  */
             /* ci-dessus et les met  jour dans votre formulaire.         */
             
             SetBulleState(Windtab[w_ind].w_h, Windtab[w_ind].DlgVar.tree);
             break;
                       
        case WM_REDRAW: 
             /**************************************************************/              
             /*........................ WM_REDRAW (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut redessiner une partie de la fenetre (par exemple un*/
             /* accessoire qui la recouvrait vient de se fermer, il faut   */
             /* alors retracer la partie de notre fenetre que l'accessoire */
             /* recouvrait. Avant c'etait un veritable enfer, maintenant   */
             /* il vous faut juste appeler la routine: Lister_rectangles   */
             /* qui vous renvoie le message WM_PAINT                       */
             /* et vous n'avez plus  vous occuper de savoir comment faire */
             /* notamment pour traiter la liste des rectangles et leur     */
             /* intersection avec notre fenetre.                           */                  
             /* Dans cet exemple, tout etant sous forme de ressource,      */
             /* EAZY_GEM ne gnre pas de message WM_PAINT, car il n'y a   */
             /* pas de surface client  retracer.                          */
             /* Il faut tout de meme appeler la fonction:                  */
             /*         Lister_rectangles() , afin que la ressource soit   */
             /*         retrace.                                          */
             
             Lister_rectangles(Windtab[w_ind].w_h,(GRECT*)&Evnt->pipe[X_G]);                          
             break;     
                                       
        case WM_PAINT:
             /**************************************************************/              
             /*........................ WM_PAINT (EZGEM message)...........*/
             /* Ce nouveau message est envoy a notre procedure de fenetre */
             /* lorsqu'il faut retracer quelque chose  l'ecran.           */
             /*                                                            */
             /* En: Evnt->pipe[X_G], Evnt->pipe[Y_G], Evnt->pipe[W_G], et  */
             /*     Evnt->pipe[H_G], se trouve le rectangle de clipping    */              
             /*                      qui est dej clipp par EAZY_GEM,     */
             /* En: Evnt->pipe[X_B], Evnt->pipe[Y_B], Evnt->pipe[W_B], et  */
             /*     Evnt->pipe[H_B], se trouve le rectangle de la surface  */    
             /*                      client qu'il est   votre charge de   */
             /*                      redessiner                            */
             /* cette fenetre contient un dialogue simple en fenetre donc  */
             /* pas de surface client, donc pas de message WM_PAINT qui    */
             /* peut donc etre ignore  ce niveau.                         */          
             break;  
                                         
        case WM_BOTTOM: 
             /**************************************************************/              
             /*........................ WM_BOTTOM (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre au dernier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_BOTTOM );   */      
             wind_set(Windtab[w_ind].w_h, WF_BOTTOM ); 
             break;          
                                  
        case WM_TOPPED:      
             /**************************************************************/              
             /*........................ WM_TOPPED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre en premier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_TOP );      */
             wind_set(Windtab[w_ind].w_h, WF_TOP ); /* voila c'est fait !! */      
             break;
             
        case WM_CLOSED: 
             /*........................ WM_CLOSED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre         */
             /* lorsqu'une demande de fermeture de la fenetre est demandee */
             /* si vous voulez detruire completement cette fenetre il faut */
             /* appeler imperativement la fonction: DestroyWindow          */
             /* pour la reouvrir ensuite il vous faudra appeler la         */
             /* fonction:                           CreateWindow           */
             /* sinon il vous faut faire un simple: CloseWindow  et la     */
             /* reouvrir par:                       OpenWindow             */
             /* sans etre oblige de tout reinitialiser                     */
             /* CloseWindow(w_ind);                                        */
             
             /* Ici je mets la variable: EZGemRun  zero, de faon  ce    */
             /* que le programme s'arrte avec une demande de confirmation.*/     
             EZGemRun = 0;                             
             break;
             
        case WM_ALLICONIFY:  
             /**************************************************************/              
             /*........................ WM_ALLICONIFY (GEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier toutes les fenetres. EAZY_GEM met  votre*/
             /* disposition une fonction s'occupant de tout: AllIconify()  */
             /* vous pouvez lui donner en entree l'adresse d'une structure */
             /* GRECT, contenant des coordonnes d'iconification. Si vous  */
             /* placez zero alors EAZY_GEM les calcule pour vous.          */             
             AllIconify(0L);                           
             break;    
              
        case WM_ICONIFY:     
             /**************************************************************/              
             /*........................ WM_ICONIFY (GEM message)...........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier une fenetre.EAZY_GEM met  votre service */
             /* une fonction s'occupant de tout: IconifyWindow()           */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             /* vous pouvez aussi lui donner en entree l'adresse d'une     */
             /* structure GRECT, contenant des coordonnes d'iconification.*/
             /* Si vous placez zero alors EAZY_GEM les calcule pour vous.  */ 
             IconifyWindow(w_ind, 0L);                 
             break;    
                                                        
        case WM_UNICONIFY:   
             /**************************************************************/              
             /*........................ WM_UNICONIFY (GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut desiconifier une fenetre.EAZY_GEM met  votre      */
             /* service une fonction s'occupant de tout: UnconifyWindow()  */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             UnconifyWindow(w_ind);                    
             break;
             
        case WM_SIZED:
             /**************************************************************/              
             /*........................ WM_SIZED (GEM message).............*/   
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* dimensionnement, ou lors d'une demande logicielle.         */
             /* ou apres une modification des coordonnes de la fenetre     */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */ 
             /* EAZY_GEM met  votre service une fonction s'occupant de    */
             /* tout: OnWm_sized()                                         */       
             /* ce dialogue en ressource n'a pas a etre redimensionne donc */
             /* ce message est ignor.                                     */                
             break;   
             
        case WM_MOVED: 
             /**************************************************************/              
             /*........................ WM_MOVED (GEM message).............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de place de la fenetre. En gnral aprs     */
             /* dplacement de la barre de titre ou d'une poignee de       */
             /* dplacement.                                               */
             /* Les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */
             /* EAZY_GEM met  votre service une fonction s'occupant de    */
             /* tout: OnWm_moved()                                         */                   
             OnWm_moved(w_ind, Evnt);                  
             break;   
             
        case WM_FULLED: 
             /**************************************************************/              
             /*........................ WM_FULLED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* plein ecran (FULLER), ou lors d'une demande logicielle.    */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */
             /* EAZY_GEM met  votre service une fonction s'occupant de    */
             /* tout: OnWm_fulled()                                        */     
             /* ce dialogue en ressource n'a pas a etre redimensionne donc */
             /* ce message est ignor.                                     */              
             break;  
             
        case AP_TERM:  
             /**************************************************************/              
             /*........................ AP_TERM (GEM message)..............*/
             /* Ce message est envoy  l'application lorsqu'il lui est    */
             /* demande de s'arreter (exemple lorsque il y a changement   */
             /* rsolution). Il est d'usage de quitter sans demande de     */
             /* comfirmation. Faites les sauvegardes ncessaires avant de  */
             /* quitter. Et quittez.                                       */
             /* Ici je mets la variable: EZGemRun  -1, de faon  ce      */
             /* que le programme s'arrete sans demande de confirmation.    */   
             EZGemRun=-1;                              
             break;      
               
       } /* end switch message     */
    } /* end if Evnt & MU_MESSAG  */      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}


