/*/////////////////////////////////////////////////////////////////////*/
/*//////////////////////////   EZ_03.C    /////////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
/* Le fichier projet associ est:      EZ_03.PRJ                       */
/* dans lequel nous pouvons voir que ce Programme comporte deux        */
/* modules:                                                            */
/*                                     EZ_03.C  gerant la fenetre      */
/*    principale. La compilation de ce module donne EZ_03.O            */
/*                                                                     */
/*                                     EZ_INFO.C gerant la fenetre     */
/*    d'information.  La compilation de ce module donne EZ_INFO.O      */
/*                                                                     */
/* Lors de la phase de linkage ces deux modules seront lis pour       */
/* former le programme final CHARVIEW.APP                              */
/* Le source C ci dessous est celui du module: EZ_03.O                 */
/*                                                                     */
/* Dans cet exemple nous allons gerer un dialogue affichant les        */
/* caractres d'une police, et permettant de selectionner une serie de */
/* caracteres afin de pouvoir les copier dans un texte.                */
/* seront decrits: LES LISTBOX                                         */
/*                 LES PAINTBOX                                        */
/*                 LES EDITABLES                                       */
/*                                                                     */
/* Nous allons aussi voir comment creer un programme qui se lance      */
/* aussi bien en ACC que APP ou PRG. (Ultra simple avec EAZY_GEM!!!)   */
/*                                                                     */
/*CHARGER LE PROJET DE CE PROGRAMME:                                   */
/*----------------------------------                                   */
/* selectionner  l'aide de, titre: "Project", option: "Select" du     */
/* du menu de Pure C, le fichier: EZ_03.PRJ.                           */
/* Ce programme tout simple ouvre une fenetre EAZY_GEM contenant un    */
/* dialogue d'un fichier ressource CHARVIEW.RSC                        */
/* Les nombreux commentaires permettent de s'y retrouver, et servent   */
/* de troisieme leon de programmation EAZY_GEM.                       */
/* Ne vous effrayez pas devant la taille de ce source, enlevez les     */
/* commentaires et vous verez qu'il est ridiculement petit et facile   */
/* de grer et ouvrir une fenetre sous EAZY_GEM.                       */
/* Le fichier: EZ_03.TXT est ce fichier source pur de tous les trucs */
/*     inutiles et commentaires 413 lignes                             */

 
/*/////////////////////////////////////////////////////////////////////*/
/*////////////////////////// I N C L U D E S //////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
/*--------------------- INCLUDES DES AUTRES MODULES DU PROGRAMME -------*/
#include <EAZY_GEM.H>  /* inclure les definitions des fonctions que le  */
                       /* que le module EAZY_GEM.LIB met  votre et     */
                       /* notre disposition                             */ 
                       /* et inclure les definitions des variables      */
                       /* globales  d'EAZY_GEM                          */
                       /* Je rappelle que le fichier EAZY_GEM.H et le   */
                       /* fichier EAZY_GEM.LIB doivent se trouver dans  */
                       /* les repertoires INCLUDE (pour le .H) et LIB   */
                       /* (pour le .LIB) de votre Pure C.               */ 
/* C'est  cause de cette ligne que vous avez le droit d'utiliser les   */
/* fonctions d'EAZY_GEM.                                                */                       
/* La lecture de ce fichier peut vous renseigner sur tout un tas de     */
/* choses. Il est toujours instructif de regarder les fichiers .H       */

/*--------------------- INCLURE LES DEFINITIONS SYMBOLIQUES ------------*/
/*                      que l'diteur de ressource gnre               */
/*                      lors de la cration de la ressource             */
#include "CHARVIEW.RSC\CHARVIEW.H"
                      /* l'inclusion des dfinitions symboliques permet */
                      /* d'utiliser des symboles literaux plus parlants */
                      /* qu'un nombre, pour les numero d'objets.        */
                      /* Il est vident qu'il est impratif de nommer   */
                      /* les objets dans votre editeur de ressources    */
                      /* pour que le fichier.H correspondant soit       */
                      /* interessant.                                   */
/*//////////////////////////////////////////////////////////////////////*/
/*////////////////////////// D E F I N E S  ////////////////////////////*/
/*//////////////////////////////////////////////////////////////////////*/ 
/*                         TYPAGE DES FENETRES                          */ 
/*----------------------------------------------------------------------*/ 
/* Dans EAZY_GEM, chaque fenetre doit avoir un numro unique. Celui-ci  */
/* permet par la suite d'interroger EAZY_GEM pour savoir si la fenetre  */
/* correspondant  ce numero existe, ou est ouverte, ou etc....         */
/* Par exemple j'cris un programme comportant deux dialogues: un pour  */
/* parametrer les couleurs, et un autre affichant un choix de trames    */
/* couleurs. Chacun de ses dialogues tant dans une fenetre diffrente, */
/* lorsque je modifie les couleurs avec le premier dialogue, il faut    */
/* repercuter la modification de couleur, sur tous les autre dialogues  */
/* concerns afin de les mettre  jour. Pour cela il me faut savoir si  */
/* ils existent, et sont ouverts, et auquel cas les mettre  jour, et   */
/* envoyer un message leur demandant de reafficher les lments         */
/* concerns par la modification du premier dialogue.                   */
/* On peut appeler a grer les multi-dpendances inter-dialogue.       */

/* Plutot que de manipuler un nombre abstrait qui ne me dit rien  je    */
/* prfre dfinir un symbole plus parlant, que j'utiliserai par la     */
/* suite dans le programme  la place du nombre, d'ou les lignes:       */
/* #define ci_dessous. (ici deux lignes car deux fenetres)              */      
 
#define W_EZ_03       1     /* (identificateur ou type) de la Fenetre   */
                            /* on peut choisir n'importe quel nombre    */
                            /* entre 1 et 32000 ('est assez non ?)     */
                            /* Il est impratif que deux fenetres n'    */
                            /* aient pas le meme nombre.                */
#define W_RINFO       2     /* ID Fenetre information traitee dans le   */
                            /* module EZ_INFO.C                         */
/*//////////////////////////////////////////////////////////////////////*/
/*////////////// V A R I A B L E S    G L O B A L E S //////////////////*/
/*//////////////////////////////////////////////////////////////////////*/
int *ZoomCarBack;      /* contiendra l'adresse memoire du fond ecran    */
                       /* lors du zoom d'un caractre                   */
int ZoomCarBackX;      /* contiendra coordonnee X du fond ecran sauv.  */
int ZoomCarBackY;      /* contiendra coordonnee Y du fond ecran sauv.  */  
int AccMenID;  /* entree de menu octroyee lors demarrage en accessoire  */
                
/*//////////////////////////////////////////////////////////////////////*/
/*/////////////// P R O T O T Y P E S  F O N C T I O N S ///////////////*/
/*//////////////////////////////////////////////////////////////////////*/

/*................ FONCTIONS CALLBACK DE FENETRES ......................*/
/* Dans EAZY_GEM,  chaque fenetre est associe une fonction CALLBACK.  */
/* CALLBACK veut dire mot  mot: appel arrire, en plus clair une       */
/* fonction CALLBACK, veut dire une fonction de rappel.                 */
/* Le principe est que vous DONNEZ  EAZY_GEM l'adresse de la fonction  */
/* de gestion qui va grer la fenetre que vous dsirez ouvrir, et que   */
/* c'est EAZY_GEM, qui RAPELLERA votre fonction selon les diffrentes   */
/* actions et vnements la concernant. L'intrt c'est qu'EAZY_GEM     */
/* traite pour vous tout un tas de choses ennuyeuses et difficiles, et  */
/* qu'il vous fait signe et laisse  votre charge ce qu'il ne peut pas  */
/* traiter ni prvoir, en rappelant votre fonction.                     */
/* Cette faon de faire permet aussi une meilleure structuration des    */
/* programmes car pour chaque fenetre il existe une seule fonction de   */
/* traitement.                                                          */
/* Toute la messagerie et l'vnementiel GEM classique est transmis    */
/* la fonction CALLBACK de Fenetre, plus d'autres messages spcifiques  */
/*  EAZY_GEM, que nous verons petit  petit dans les exemples.         */
/* En rponse aux messages et vnements GEM il est possible de les     */
/* traiter tout  fait classiquement, ou comme je vous le conseille de  */
/* faire appel aux fonctions qu'EAZY_GEM met  votre disposition.       */
/* L'accs aux fonctions tendues de gestion de ressource en fenetre et */
/* autres aspect pointus d'EAZY_GEM ne se fait bien videment qu'au     */
/* travers des fonctions prvues pour cela.                             */
/*                                                                      */
/* Ces principes de programmation peuvent apparaitre difficiles pour    */
/* ceux qui n'y sont pas habitus, mais aprs un effort d'adaptation    */
/* minime, l'on regrette de ne pas l'avoir fait avant, tellement la     */
/* programmation sous GEM semble ensuite facile !!!.                    */ 

/*.......... definies dans le module EZ_03.C (ici)......................*/
/* ICI je dclare le nom et le prototype de la fonction par defaut qui  */
/* traitera tout les messages avant qu'une fenetre soit ouverte.        */

static CALLBACK DefautCallbackProc(int w_ind, EVNT_O *Evnt);

/* ICI je dclare le nom et le prototype de la fonction de fenetre qui  */
/* traitera tout ce qui concerne la fenetre que l'on va ouvrir.         */

static CALLBACK WindProcEZ_03(int w_ind, EVNT_O *Evnt);

/*.......... definie dans le module EZ_INFO.C ..........................*/
extern CALLBACK WindProcInfo(int w_ind, EVNT_O *Evnt);

/*................ FONCTIONS GENERALES ET DIVERSES .....................*/
int OnGrilleCarClick(OBJECT *object, int ob_ret, EVNT_O *Evnt);
int *OpenZoomCar(char *str, int x, int y, int fntid, GRECT *limit_grect, int *rx, int *ry);
int *CloseZommCar(int *back,int x, int y);
void ActiveWindow(int ident, long attr, char *title, CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt));
/*//////////////////////////////////////////////////////////////////////*/
/*                A   C O M M E N C E   I C I   !!!!                   */
/*              Definition des fonctions de ce module                   */
/*//////////////////////////////////////////////////////////////////////*/
 
/*---------------------------- main ------------------------------------*/
void main (void)
{/*.............. LES DEUX VARIABLES SUIVANTES DOIVENT ETRE ............*/
 /*           MODIFIEES AVANT APPEL A LA FONCTION: InitEazyGem()        */ 
 /*       les valeurs par dfaut suffisent dans la majorit des cas     */
 /*          Ici je les modifie pour montrer comment faire              */
 
 MAX_TTIPS = 100; /* nbr maxi de structures TOOL_TIPS permises.         */
                  /* ici ce programme utilise les fonctions de          */
                  /* ressource en fenetre qui utilisent les bulles      */
                  /* d'aide, donc reserver la place des bulles d'aide   */
                  /* 100 est amplement suffisant.                       */
 MAX_WIND  = 2;   /* nbr maxi de fenetres que notre application, permet */
                  /* de crer en meme temps. Ici on en autorise deux.   */
                  /* celle que l'on va ouvrir, et celle des Alert en    */
                  /* fenetre. Par defaut ce nombre est de 7.            */ 

 if (InitEazyGem("CHARVIEW.ACC") != -1) /* Cette fonction initialise le */
                                        /* systme d'EAZY_GEM, elle dem-*/
                                        /* ande le nom du programme.    */ 
                                        /* si elle retourne -1 alors il */
                                        /* est impossible de poursuivre */                                    
   
    {/*............... RUSE nous allons considerer que ce ................*/
     /*          programme tourne toujours comme un accessoire.           */
     /*        si il est lance du bureau alors un faux message AC_OPEN    */
     /*          est imediatement envoy de faon  ce que l'accessoire   */
     /*            s'ouvre, si il est en accessoire on attendra le        */
     /*             message AC_OPEN provenant du menu accessoire          */  
     /* Au fait:  _app est allez disons pour simplifier une variable      */
     /*                systme qui si egal  zero signifie que le         */
     /*                programme a demarr en ACCESSOIRE, et sinon que le */
     /*                programme a demarr du BUREAU.                     */
     if (!_app)  
        {/*....... si demarre en accessoire installer le titre ds menu......*/
         /*               et attendre le message AC_OPEN                    */
         /*               pour ouvrir la fenetre.                           */
         AccMenID = menu_register( Appl_id, "  Table caracteres ");         
        }
     else
        {/*....... si demarre du bureau.....................................*/
         /*               on va envoyer un faux message AC_OPEN             */
         /*               afin d'ouvrir d'emble la fenetre                 */
         int msgbuf[8];   
         AccMenID = 12345;        /*   creer une entree de menu fantaisie   */
         msgbuf[MESG]=AC_OPEN;    /*   nature du message                    */
         msgbuf[APPL]=Appl_id;    /*   iddentificateur de l'appelant (moi)  */
         msgbuf[SUPL]=0;          /*   message sans surplus                 */
         msgbuf[4]=AccMenID;      /*   placer entree de menu declenchante   */
         appl_write(Appl_id, 16, msgbuf ); 
        }   
     /*.................... Passer la main  EAZY_GEM ......................*/
     /* Ici j'appelle le Noyau d'EAZY_GEM avec en parametre le nom de la    */
     /* fonction qui va grer l'evenementiel GEM en l'absence de fenetre.   */
     /* En effet dans le cas d'un accessoire, la fenetre doit etre ouverte  */
     /* apres un click sur l'option du menu accessoire. Donc il faut bien   */
     /* une fonction gerant l'evenementiel GEM (notamment celui du message  */
     /* AC_OPEN pouvant se manifester avant toute ouverture de fenetre      */
     /* puisque c'est lors de ce message que nous ouvrons la fenetre        */
     /* principale).                                                        */
     
     if (AccMenID != -1)  /* si demarrage sans probleme.                    */
        {BouclePrincipale(DefautCallbackProc);  
        }
    }
 /*........... appel indispensable pour finir un programme .................*/
 /*                       EZ_GEM proprement                                 */ 
 ExitEasyGem();   
}

/*----------------------------- DefautCallbackProc --------------------------*/
/* Fonction de gestion des evenements GEM en l'absence de fenetre.           */
/* Dans cete exemple je m'en sert pour intercepter les messages AC_OPEN,     */
/* AC_CLOSE afin d'ouvrir la fenetre principale ou de fermer l'application   */

/* En entree: int w_ind est l'indice EAZY_GEM d'une fenetre. Cet indice      */
/* permet daccder  la table de parametres de cette fenetre: Windtab.       */
/* et d'accder  ses lments: par exemple le handle GEM de la fenetre      */
/* est accd comme suit: Windtab[w_ind].w_h                                 */
/* Dans le cas d'une fonction CALLBACK par defaut, w_ind ne sert  rien !    */
/* car la fonction peut etre appele en l'absence de fenetre.                */ 
/* c'est pourquoi je l'incremente pour que le compilateur ne rale pas.       */

/* En entree: EVNT_O *Evnt est l'adresse (pointe sur) une structure de       */
/* type EVNT_O (voir doc et fichier EAZY_GEM.H) qui contient les donnes     */
/* d'vnements et de messages que la fonction de fenetre est appele       */
/* traiter.                                                                  */

CALLBACK DefautCallbackProc(int w_ind, EVNT_O *Evnt)
{w_ind++;
 /*..........................Rpondre aux messages MU_MESAG .................*/
 /* L'vnement MU_MESAG se manifeste chaque fois qu'EAZY_GEM demande       */
 /* la fonction de CALLBACK de rpondre  un message. ci_dessous nous allons */
 /* rpondre aux messages d'ouverture et de fermeture de l'accessoire.       */
   
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {/*****************************************************************************/
        /*......................... AC_OPEN (GEM message)............................*/
        /* Cet evenement est reu lorsque qu'une entree ou item ou ligne             */
        /* ou option ou un peu ce que vous voulez  du menu accessoire est clique.   */
        /* Ici on ouvre le fenetre principale.                                       */
        
        case AC_OPEN:
             if (Evnt->pipe[4] == AccMenID) /* verifier que c'est notre ligne de menu  */
                { 
                 ActiveWindow(W_EZ_03, 
                              SMALLER|      /* je veux la case d'iconification         */
                              CLOSER |      /* je veux la case de fermeture            */
                              NAME   |      /* je veux la barre de titre.              */
                              MOVER  |      /* je veux bouger la barre de titre        */
                                            /*........ ATTRIBUTS EAZY_GEM .............*/
                              BORDER |      /* Je veux la bordure spciale EAZY_GEM    */             
                              XMOVER ,      /* je veux la poigne de dplacement       */         
                              "Table de Caractres  ", 
                              WindProcEZ_03);                  
                 }
             break;
        /*****************************************************************************/
        /*......................... AC_CLOSE (GEM message)...........................*/
        /* Je vous laisse deviner ce  quoi peut servir ce message !!!               */         
        case AC_CLOSE:                    /* verifier que c'est notre ligne de menu  */
             if (Evnt->pipe[4] == AccMenID)
                {EZGemRun = -1;
                }
             break; 
       } /* end switch (Evnt->pipe[MESG]) */
    }  /* end if (Evnt->evnt & MU_MESAG) */        
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}


/*------------------------------ WindProcEZ_03 ---------------------------*/
/* Fonction de gestion de la fenetre de ce programme. Dans EAZY_GEM il    */
/* y a une fonction comme celle-ci, par fenetre, qui va etre appelle par */
/* EAZY_GEM chaque fois qu'un vnement ou message concerne la fenetre   */
/* laquelle elle est associe.                                            */

/* En entree: int w_ind est l'indice EAZY_GEM de cette fenetre.Cet indice */
/* permet daccder  la table de parametres de cette fenetre: Windtab.    */
/* et d'accder  ses lments: par exemple le handle GEM de la fenetre   */
/* est accd comme suit: Windtab[w_ind].w_h                              */

/* En entree: EVNT_O *Evnt est l'adresse (pointe sur) une structure de    */
/* type EVNT_O (voir doc et fichier EAZY_GEM.H) qui contient les donnes  */
/* d'vnements et de messages que la fonction de fenetre est appele    */
/* traiter.                                                               */

CALLBACK WindProcEZ_03(int w_ind, EVNT_O *Evnt)
{
 /*............................Rpondre  l'vnement MU_KEYBD .........*/
 /* L'vnement MU_KEYBD se manifeste chaque fois qu'une touche clavier */
 /* est appuye.                                                        */ 
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec une touche clavier  */
 /* Notamment l'edition et saisie de texte dans les champs editables et */
 /* les raccourcis clavier.                                             */
 /* Pour une ressource en fenetre il est indispensable que l'evenement  */
 /* MU_KEYBD soit traite avant l'evenement  MU_BUTTON afin de permettre */
 /* un fonctionnement correct des raccourcis clavier. En effet le       */
 /* raccourci clavier d'un objet simule un clic souris sur l'objet.     */
 /* en renvoyant un evenement MU_BUTTON                                 */
 /* Nous vrifions avant si la fenetre est au premier plan car si ce    */
 /* n'est pas le cas, elle n'a pas  traiter le clavier.                */
 
 if (Evnt->evnt & MU_KEYBD)
    {int wh_top;                    /* handle fenetre en avant plan     */
     if (ZoomCarBack) ZoomCarBack = CloseZommCar(ZoomCarBack, ZoomCarBackX, ZoomCarBackY);
     wind_get( 0, WF_TOP, &wh_top); /* recuperer handle fen. avt plan.  */
     if (Windtab[w_ind].w_h == wh_top ) Xform_keybd(w_ind, Evnt);
    }
    
 /*.......................... Rpondre  l'vnement MU_BUTTON .........*/ 
 /* L'vnement MU_BUTTON se manifeste chaque fois qu'un bouton de la   */
 /* souris est appuy.                                                  */ 
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec un appui sur un     */
 /* bouton de souris: Xform_button() .                                  */
 /* Notamment l'appui sur un bouton de la ressource, la selection du    */
 /* texte dans les champs editables, et le placement du curseur de      */
 /* texte dans les champs editables.                                    */
 /* en retour cette fonction donne le numro d'objet cliqu, si bien sur*/
 /* un objet de type TOUCHE_EXIT ou SELECTABLE est cliqu.              */
 
 if (Evnt->evnt & MU_BUTTON)
    {int ob_ret;                /* recevra le numero d'objet cliqu     */
     OBJECT *object;            /* pointeur d'objet pour les ressources */
     DLG_VAR *dlg;              /* pointeur sur variable ressource      */
     TEDINFO  *tedinfo;         /* pointera sur TEDINFO zone de saisie  */
     XUSERBLK *xuserblk;        /* pointera sur XUSERBLK zone de saisie */
     char buft[256];            /* buffer de manipulation de texte      */
     int txtlen;                /* longueur texte zone de saisie        */
     /*..... initialiser pointeur sur variable ressource ....*/
     dlg = &Windtab[w_ind].DlgVar;
     /*....recuperer l'adresse du premier objet de la ressource....*/ 
     object=Windtab[w_ind].DlgVar.tree;  
     /*........ relever longueur max de la zone de saisie .........*/
     xuserblk = (XUSERBLK*) object[AS_SAISIE_CAR].ob_spec.userblk->ub_parm; 
     tedinfo   = xuserblk->tedinfo;
     txtlen    = tedinfo->te_txtlen - 1;
     ob_ret = Xform_button(w_ind, Evnt);          
     if (ob_ret>0)            /*<<<<SI UN OBJET EST CLIQUE >>>>>>>>>>>*/
        {/*.... empecher propagation message  MU_BUTTON ...............*/
         /*     de faon  ce qu'il ne soit pas possible de            */
         /*     cliquer sur deux fenetres  la fois.                   */
         Evnt->evnt &= ~MU_BUTTON;  
         if (ob_ret == AS_PAINT_BOX1 && Evnt->k != 2)
            {
             /*........ effacer curseur ancien editable .......*/
             SetCursObEditOff(dlg);    
             
             /*......... recopier le texte de l'editable ............*/
             strcpy(buft, ObjcGetTxt (object, AS_SAISIE_CAR));
             if (Evnt->click == 2)
                {buft[1] = 0;
                 xuserblk->BlkEnd = xuserblk->BlkDeb = 0;
                 dlg->PosCursX = 0;
                }
             else
                {/*......... deplacer ce qui est apres le curseur .......*/
                 /*          1 caractere plus loin (faire la place)      */
                 memcpy(buft + dlg->PosCursX+1, 
                        buft + dlg->PosCursX,
                        txtlen - dlg->PosCursX +1 );
                }        
             buft[dlg->PosCursX] =  OnGrilleCarClick(object,ob_ret,Evnt);      
                
             /*........ mettre  jour le bloc .......................*/
             if (xuserblk->BlkEnd == xuserblk->BlkDeb)
                {xuserblk->BlkDeb = dlg->PosCursX;
                }
                
             /*........ incrementer le curseur ......................*/
             dlg->PosCursX = Min(txtlen, dlg->PosCursX +1);
             xuserblk->BlkEnd = Min((int)strlen(buft), dlg->PosCursX);
             /*...... replacer le texte dans l'editable .............*/
             ObjcSetTxt (object, AS_SAISIE_CAR,buft);
             SendObjectRedraw( Windtab[w_ind].w_h, object, AS_SAISIE_CAR); 
            }
         else if (ob_ret == AS_PAINT_BOX1 && Evnt->k == 2)
            {char car[2]={0,0};
             car[0] = OnGrilleCarClick(object,ob_ret,Evnt);
             if (ZoomCarBack==0) 
                {SetCursObEditOff(dlg);
                 ZoomCarBack = OpenZoomCar(car,
                                           Evnt->x,
                                           Evnt->y,
                                           (int)FontID[GetSelectedListBoxItem(object, AS_FONT_LIST)],
                                           &Windtab[w_ind].ExtGrectUse,
                                           &ZoomCarBackX,
                                           &ZoomCarBackY
                                          );
                }
            }   
         else
            {/*.......le remettre en non selectionn et le redessiner......*/         
             object[ob_ret].ob_state &= ~SELECTED;                
             SendObjectRedraw( Windtab[w_ind].w_h, object, ob_ret); 
         
             
             /*.............. ICI ACTION SELON BOUTON CLIQUE..............*/
             /* Ici vous pouvez voir comment  il est  possible de  tester */
             /* et lancer une action selon l'objet cliqu. Utilisez les   */
             /* symboles du fichier .H de la ressource (ici CHARVIEW.H)   */
             /* afin de rendre votre programme plus lisible.              */
             switch (ob_ret)             
                 {case AS_ICONE:               
                       ActiveWindow(W_RINFO, XMOVER|BORDER, "A propos de ChrTable", WindProcInfo);                                
                       break;    
                  case AS_EFFACER:
                       buft[0]=0;
                       ObjcSetTxt (object, AS_SAISIE_CAR,buft);
                       xuserblk->BlkEnd = xuserblk->BlkDeb =0;
                       SendObjectRedraw( Windtab[w_ind].w_h, object, AS_SAISIE_CAR);
                       break;      
                  case AS_COPIER:  
                       if (xuserblk->BlkEnd | xuserblk->BlkDeb )
                          {/*......... recopier le texte de l'editable ............*/
                           memcpy (buft, ObjcGetTxt (object, AS_SAISIE_CAR),txtlen);      
                           memcpy (buft,&buft[xuserblk->BlkDeb],txtlen);
                           buft[(int)(xuserblk->BlkEnd - xuserblk->BlkDeb)] = 0;       
                           ClipboardSave(buft,O_WRONLY|O_CREAT|O_TRUNC);       
                          }  
                       break;   
                 }  /* end switch ob_ret  */                         
            }  /* endif if ob_ret ==  AS_PAINT_BOX1    */
        }  /* endif objet selectable cliqu  */ 
    } /* endif MU_BUTTON  et fenetre au premier plan */
 
 /*.......................... Rpondre  l'vnement MU_TIMER.............*/
 /* L'vnement MU_TIMER se manifeste approximativement toutes les 200 ms */  
 /* Dans le cadre d'une ressource en fenetre la fonction: Xform_timer     */
 /* s'occupe de tout ce que doit gerer le timer notamment le clignote     */
 /* ment du curseur texte dans les champs editables                       */
 /* Nous vrifions avant si la fenetre est au premier plan car si ce      */
 /* n'est pas le cas, elle n'a pas  faire clignoter le curseur texte.    */
 
 if (Evnt->evnt & MU_TIMER)  
    {int wh_top;                    /* handle fenetre en avant plan     */
     wind_get( 0, WF_TOP, &wh_top); /* recuperer handle fen. avt plan.  */
     if (Windtab[w_ind].w_h == wh_top && !ZoomCarBack) Xform_timer(w_ind);    
     if (ZoomCarBack && Mousek() !=2) 
        {ZoomCarBack = CloseZommCar(ZoomCarBack, ZoomCarBackX, ZoomCarBackY);
        }
    }
   
 /*..........................Rpondre  l'vnement MU_MOVE ..............*/
 /* L'vnement MU_MOVE se manifeste chaque fois que la souris a modifie  */
 /* sa position. L'appel  la fonction: Xform_mu_move() permet de traiter */
 /* tout ce qui concerne un mouvement souris au dessus d'une ressource en */
 /* fenetre et le mouvement de la souris au dessus du bord de la fenetre. */
 
 if (Evnt->evnt & MU_MOVE)   /*  (EZGEM evenement)   */
    {if (ZoomCarBack) ZoomCarBack = CloseZommCar(ZoomCarBack, ZoomCarBackX, ZoomCarBackY);
     Xform_mu_move(w_ind, Evnt);
    }       
    
 /*..........................Rpondre aux messages MU_MESAG ..............*/
 /* L'vnement MU_MESAG se manifeste chaque fois qu'EAZY_GEM demande    */
 /* la fonction de fenetre de rpondre  un message. ci_dessous nous      */
 /* allons rpondre aux messages concernant notre fenetre.                */
   
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {case WM_CONSTRUCT:
             /***********************************************************/
             /*.................... WM_CONSTRUCT (EZGEM message)........*/
             /* Ce message est transmis avant la creation et ouverture  */
             /* de la fenetre associee  notre procedure de fenetre.    */
             /* c'est  cet endroit que vous devez initialiser tout ce  */
             /* qui concerne votre fenetre: Memoire, chargement d'un    */
             /* fichier ressource, modification des dimensions fenetre  */
             /* avant ouverture, declaration des Bulles d'aide associees*/
             /*  cette fenetre, titre de la fenetre.....etc            */
             /* eventuellement si pas deja fait avant: ouverture d'une  */
             /* Station de travail VDI autre que celle d'EAZY_GEM.      */  
             /* EAZY_GEM vous laisse toute liberte pour faire ce que    */
             /* vous voulez:                                            */
             /* Vous pouvez tres bien charger votre fichier ressource  */    
             /* cet endroit ou avant dans l'application..               */
             /* Lors de ce message il est donn dans:                   */
             /*                  Evnt->pipe[X_B]                        */
             /*                  Evnt->pipe[Y_B]                        */
             /*                  Evnt->pipe[W_B]                        */
             /*                  Evnt->pipe[H_B]                        */
             /*                               les dim exterieures  maxi */
             /* possibles d'ouverture de la fenetre sur l'ecran.        */ 
             /* c'est par defaut ces dimensions qui sont choisies pour  */
             /* ouvrir une fenetre.Si on veut d'autres dimensions c'est */
             /* ces valeurs qu'il faudra modifier.                      */
             /*                                                         */
             /* REPONDRE AU MESSAGE WM_CONTRUCT:                        */
             /* Il est possible de repondre au message WM_CONSTRUCT     */
             /* de deux manieres equivalentes au point de vue resultat: */
             /* Soit en faisant  Evnt->evnt = WM_ABORT; (ou WM_STANDBY) */
             /* Soit en faisant  return WM_ABORT;       (ou WM_STANDBY) */                
             /*                                                         */
             /* Vous pouvez interrompre le processus de creation de la  */
             /* fenetre en retournant le message: WM_ABORT par exemple  */
             /* vous n'avez pas pu reserver toute la memoire souhaitable*/
             /* ou vous n'avez pas trouve un fichier indispensable      */
             /* ou pour toute autre raison liee a votre application.etc.*/
             /*                                                         */
             /* Vous pouvez empecher l'ouverture de la fenetre et donc  */
             /* permettre juste sa creation en retournant le message:   */   
             /* WM_STANDBY. Pour ouvrir et afficher la fenetre ulterieu-*/
             /* ment il faudra utiliser la fonction: OpenWindow         */
             /* Si vous ne retournez pas ce message la fenetre s'ouvre  */
             /* dans la foulee (cas le plus utile).                     */                           
             /*                                                         */
             
             
             /*........... ICI nous allons charger un fichier ..........*/
             /*           de ressource en memoire et integrer           */
             /*           un dialogue (ici le premier et seul arbre) de */
             /*           cette ressource,  notre fenetre              */
             
             /*...... Chargement et relogement du fichier ressource ....*/
             /*       l'adresse de chargement doit obligatoirement      */
             /*       etre stocke dans la structure DLG_VAR:           */
             /*       Windtab[wind].DlgVar.AdrRsc de la fenetre         */  
             
             Windtab[w_ind].DlgVar.AdrRsc = LoadAppliRsc( "CHARVIEW.RSC", NO_SCALE); 
             
             /*...... Si russite du chargement de la ressource ........*/
             /*       il faut integrer un des arbres de cette           */
             /*       ressource  la fenetre                            */            
             if (Windtab[w_ind].DlgVar.AdrRsc)  
                {
                 /*     indiquer le type d'integration desir           */
                 /*     ici type dialogue simple en fenetre             */
                 Windtab[w_ind].DlgVar.type    = RSC_DIAL;
                
                 /*      indiquer le numero de l'arbre  integrer       */
                 Windtab[w_ind].DlgVar.NumTree = 0; 
                 
                 /*      integrer la ressource  la fenetre             */
                 Xform_construct(w_ind, Evnt);
                }                     
             else
                {/*      si echec du chargement annuler la              */
                 /*      creation de la fenetre                         */
                 return WM_ABORT;         
                }
                  
             /*........... placer le tout sous la souris ..................*/
             /* EAZY_GEM met  votre disposition une fonction qui centre   */
             /* le rectangle donn en entre, sur la position de la souris */
             /* tout en restant dans les limites de l'ecran.               */
             /* J'en profite ici pour recentrer la fenetre sur la souris   */
             /* avant son ouverture.                                       */ 
              AdjustWindCoordToScreen (w_ind, Evnt, (GRECT*)&Evnt->pipe[X_B]);              
             break;
             
        case WM_DESTRUCT:       /*  (EZGEM message)   */
             /**************************************************************/              
             /*........................ WM_DESTRUCT (EZGEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre avant   */
             /* que le systeme ne la detruise. c'est  cet endroit qu'il   */
             /* convient de desinitialiser tout ce que l'on avait fait     */
             /* auparavant memoire, bulles d'aide, ressources....          */                          
             
             /*            desintegrer l'arbre de la fenetre               */
             /*         (enfin un mot qui prend tout son sens)             */
             Xform_Destruct(w_ind, Evnt);    
             
             /*            decharger la ressource de la memoire            */
             /*                  et liberer la memoire                     */
             RscFicUnLoad(Windtab[w_ind].DlgVar.AdrRsc);                
             break;   
             
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             /**************************************************************/
             /*...................... WM_TT_ON_OFF (EZGEM message).........*/
             /* Ce message est envoy  notre fenetre chaque fois qu'il est*/
             /* demand d'activer ou de desactiver l'affichage des bulles  */
             /* d'aide. Il suffit simplement d'appeler la fonction qui suit*/
             /* pour mettre  jour l'objet representant l'etat actif ou    */
             /* inactif de notre ressource (si il existe)                  */
             /* Cet Objet est un objet type BOXTEXT extended type 25 que   */ 
             /* vous pouvez placer sur tout formulaire.                    */ 
             /* c'est le petit truc jaune affich en haut  droite de la   */
             /* boite de dialogue.                                         */                                
             /* Si un objet de ce type est plac dans votre formulaire Il  */
             /* refletera automatiquement l'etat actif ou inactif du       */
             /* systeme de bulle d'aide. L'appel de la fonction:           */ 
             /* SetBulleState()  recherche tous les objets du type decrit  */
             /* ci-dessus et les met  jour dans votre formulaire.         */
             
             SetBulleState(Windtab[w_ind].w_h, Windtab[w_ind].DlgVar.tree);
             break;
                       
        case WM_REDRAW: 
             /**************************************************************/              
             /*........................ WM_REDRAW (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut redessiner une partie de la fenetre (par exemple un*/
             /* accessoire qui la recouvrait vient de se fermer, il faut   */
             /* alors retracer la partie de notre fenetre que l'accessoire */
             /* recouvrait. Avant c'etait un veritable enfer, maintenant   */
             /* il vous faut juste appeler la routine: Lister_rectangles   */
             /* qui vous renvoie le message WM_PAINT                       */
             /* et vous n'avez plus  vous occuper de savoir comment faire */
             /* notamment pour traiter la liste des rectangles et leur     */
             /* intersection avec notre fenetre.                           */                  
             /* Dans cet exemple, tout etant sous forme de ressource,      */
             /* EAZY_GEM ne gnre pas de message WM_PAINT, car il n'y a   */
             /* pas de surface client  retracer.                          */
             /* Il faut tout de meme appeler la fonction:                  */
             /*         Lister_rectangles() , afin que la ressource soit   */
             /*         retrace.                                          */
             {int redraw_flag = 0;
              char car[2]={0,0};
              OBJECT *object;            /* pointeur d'objet pour les ressources */
              DLG_VAR *dlg;              /* pointeur sur variable ressource      */
              /*..... initialiser pointeur sur variable ressource ....*/
              dlg = &Windtab[w_ind].DlgVar;
              /*....recuperer l'adresse du premier objet de la ressource....*/ 
              object=Windtab[w_ind].DlgVar.tree; 
              if (ZoomCarBack) 
                 {redraw_flag = 1;
                  ZoomCarBack = CloseZommCar(ZoomCarBack, ZoomCarBackX, ZoomCarBackY);           
                 }
              Lister_rectangles(Windtab[w_ind].w_h,(GRECT*)&Evnt->pipe[X_G]);
              if ( redraw_flag )
                 {car[0] = OnGrilleCarClick(object,AS_PAINT_BOX1,Evnt);
                  SetCursObEditOff(dlg);
                  ZoomCarBack = OpenZoomCar(car,
                                            Evnt->x,
                                            Evnt->y,
                                            (int)FontID[GetSelectedListBoxItem(object, AS_FONT_LIST)],
                                             &Windtab[w_ind].ExtGrectUse,
                                             &ZoomCarBackX,
                                             &ZoomCarBackY
                                            );  
                 }
             }                                                     
             break;     
                                       
        case WM_PAINT:
             /**************************************************************/              
             /*........................ WM_PAINT (EZGEM message)...........*/
             /* Ce nouveau message est envoy a notre procedure de fenetre */
             /* lorsqu'il faut retracer quelque chose  l'ecran.           */
             /*                                                            */
             /* En: Evnt->pipe[X_G], Evnt->pipe[Y_G], Evnt->pipe[W_G], et  */
             /*     Evnt->pipe[H_G], se trouve le rectangle de clipping    */              
             /*                      qui est dej clipp par EAZY_GEM,     */
             /* En: Evnt->pipe[X_B], Evnt->pipe[Y_B], Evnt->pipe[W_B], et  */
             /*     Evnt->pipe[H_B], se trouve le rectangle de la surface  */    
             /*                      client qu'il est   votre charge de   */
             /*                      redessiner                            */
             /* cette fenetre contient un dialogue simple en fenetre donc  */
             /* pas de surface client, donc pas de message WM_PAINT qui    */
             /* peut donc etre ignore  ce niveau.                         */          
             break;  
             
        case WM_PAINTBOX:
             /**************************************************************/              
             /*........................ WM_PAINTBOX (EZGEM message)........*/
             /* Ce nouveau message est envoy a notre procedure de fenetre */
             /* lorsqu'il faut retracer la surface d'une boite de type     */
             /* PAINT_BOX (ob-type etendu PAINT_BOX (215).                 */             
             /*                                                            */
             /* En: Evnt->pipe[X_G], Evnt->pipe[Y_G], Evnt->pipe[W_G], et  */
             /*     Evnt->pipe[W_G], se trouve le rectangle de clipping    */              
             /*                      qui est dej clipp par EAZY_GEM,     */
             /* En: Evnt->pipe[X_B], Evnt->pipe[Y_B], Evnt->pipe[W_B], et  */
             /*     Evnt->pipe[W_B], se trouve le rectangle de la surface  */    
             /*                      client qu'il est   votre charge de   */
             /*                      redessiner                            */
             /* En: Evnt->pipe[12]   se trouve le numero de l'objet dont   */
             /*                      il faut retracer la surface.          */
             {GRECT pgrect;        /* rectangle de la PAINTBOX             */
              int w_car_rect, h_car_rect, x_o, y_o;
              int i, u, x, y ,x1 ,y1;
              char car[2]={0,0};
              
              /*............ recuperer dimensions PAINTBOX ................*/
              pgrect = *(GRECT*) &Evnt->pipe[X_B];
              
              pgrect.g_w -= 1;
              pgrect.g_h -= 1;
              
              w_car_rect = pgrect.g_w>>5;   /* divise par 32  */
              h_car_rect = pgrect.g_h>>3;   /* divise par 8   */
              x_o        = (pgrect.g_w - (w_car_rect<<5))>>1;
              y_o        = (pgrect.g_h - (h_car_rect<<3))>>1;
              
              /*............ tracer les rectangles ........................*/
              Graphmode(1);
              Defline(1,1,0,0,8);
              
              x  = pgrect.g_x + x_o;
              y  = pgrect.g_y + pgrect.g_h - y_o - 1;
              y1 = pgrect.g_y + y_o;
              
              for (i=0; i<33; i++)
                  {Line_p(x, y1, x, y);
                   x += w_car_rect;
                  }
              x  = pgrect.g_x + pgrect.g_w - x_o - 1;
              y  = pgrect.g_y + y_o;
              x1 = pgrect.g_x + x_o;
              for (i=0; i<9; i++)
                  {Line_p(x1, y, x, y);
                   y += h_car_rect;
                  }   
              /*...... rcuperer la police affiche par la LISTBOX ........*/
              i = GetSelectedListBoxItem(Windtab[w_ind].DlgVar.tree, AS_FONT_LIST);
              /*........... afficher les caracteres .......................*/  
              Graphmode(2);   
              Deftext(1,0,0,9,(int)FontID[i]);
              vst_point( VDIhandle, 10,&i, &i, &i, &u );
              vst_alignment( VDIhandle, 1, 5, &x, &y );
              y  = pgrect.g_y + y_o + ((h_car_rect-u)>1) +1;
              x  = pgrect.g_x + x_o + (w_car_rect>>1) + 1;
              u   = 0;              
              for (i=0; i<255; i++)
                  {VdiText(x,y,car);
                   u++;
                   car[0]++;
                   if (u == 32 ) 
                      {u  = 0;
                       x  = pgrect.g_x + x_o + (w_car_rect>>1);
                       y += h_car_rect;
                      }
                   else
                      {x += w_car_rect;
                      }
                  }
             }
             break; 
             
        case WM_EXEFUNC:        /*  (EZGEM message)   */
             /**************************************************************/              
             /*...................... WM_EXEFUNC .(EZGEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois qu'il est demand d'executer une fonction referencee  */
             /* par un numero de fonction.                                 */
             /* Le message est compose comme suit:                         */
             /* SI  Evnt->pipe[WHND]= RSC_DIAL; le message provient d'une  */
             /*                             ressource.  ET ALORS           */                     
             /*     Evnt->pipe[X_G] = indice objet declenchant le message  */
             /*     Evnt->pipe[Y_G] = numero de la fonction referencee     */
             /*     *(long*)&Evnt->pipe[W_G] =  adr arbre ou est l'objet   */            
             if (Evnt->pipe[Y_G]  == 226 )
                {SendObjectRedraw(Windtab[w_ind].w_h,
                                  Windtab[w_ind].DlgVar.tree,
                                  AS_PAINT_BOX1);
                }                        
             break;                                       
        case WM_BOTTOM: 
             /**************************************************************/              
             /*........................ WM_BOTTOM (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre au dernier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_BOTTOM );   */      
             wind_set(Windtab[w_ind].w_h, WF_BOTTOM ); 
             break;          
                                  
        case WM_TOPPED:      
             /**************************************************************/              
             /*........................ WM_TOPPED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre en premier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_TOP );      */
             wind_set(Windtab[w_ind].w_h, WF_TOP ); /* voila c'est fait !! */      
             break;
             
        case AP_TERM:  
             /**************************************************************/              
             /*........................ AP_TERM (GEM message)..............*/
             /* Ce message est envoy  l'application lorsqu'il lui est    */
             /* demande de s'arreter (exemple lorsque il y a changement   */
             /* rsolution). Il est d'usage de quitter sans demande de     */
             /* comfirmation. Faites les sauvegardes ncessaires avant de  */
             /* quitter. Et quittez.                                       */
             /* Ici je mets la variable: EZGemRun  -1, de faon  ce      */
             /* que le programme s'arrete sans demande de confirmation.    */  
             EZGemRun = -1; 
             break;                                                                            
        case WM_CLOSED: 
             /*........................ WM_CLOSED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre         */
             /* lorsqu'une demande de fermeture de la fenetre est demandee */
             /* si vous voulez detruire completement cette fenetre il faut */
             /* appeler imperativement la fonction: DestroyWindow          */
             /* pour la reouvrir ensuite il vous faudra appeler la         */
             /* fonction:                           CreateWindow           */
             /* sinon il vous faut faire un simple: CloseWindow  et la     */
             /* reouvrir par:                       OpenWindow             */
             /* sans etre oblige de tout reinitialiser                     */
             /* CloseWindow(w_ind);                                        */
             
             /* Ici je mets la variable: EZGemRun  -1, de faon  ce      */
             /* que le programme s'arrte sans demande de confirmation.    */  
             if (!_app)  /* si demarr en accessoire                       */
                {DestroyWindow(Windtab[w_ind].w_h);
                }
             else        /* si demarr en programme                        */
                {EZGemRun = -1;                             
                }
             break;
             
        case WM_ALLICONIFY:  
             /**************************************************************/              
             /*........................ WM_ALLICONIFY (GEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier toutes les fenetres. EAZY_GEM met  votre*/
             /* disposition une fonction s'occupant de tout: AllIconify()  */
             /* vous pouvez lui donner en entree l'adresse d'une structure */
             /* GRECT, contenant des coordonnes d'iconification. Si vous  */
             /* placez zero alors EAZY_GEM les calcule pour vous.          */             
             AllIconify(0L);                           
             break;    
              
        case WM_ICONIFY:     
             /**************************************************************/              
             /*........................ WM_ICONIFY (GEM message)...........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier une fenetre.EAZY_GEM met  votre service */
             /* une fonction s'occupant de tout: IconifyWindow()           */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             /* vous pouvez aussi lui donner en entree l'adresse d'une     */
             /* structure GRECT, contenant des coordonnes d'iconification.*/
             /* Si vous placez zero alors EAZY_GEM les calcule pour vous.  */ 
             IconifyWindow(w_ind, 0L);                 
             break;    
                                                        
        case WM_UNICONIFY:   
             /**************************************************************/              
             /*........................ WM_UNICONIFY (GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut desiconifier une fenetre.EAZY_GEM met  votre      */
             /* service une fonction s'occupant de tout: UnconifyWindow()  */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             UnconifyWindow(w_ind);                    
             break;
             
        case WM_SIZED:
             /**************************************************************/              
             /*........................ WM_SIZED (GEM message).............*/   
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* dimensionnement, ou lors d'une demande logicielle.         */
             /* ou apres une modification des coordonnes de la fenetre     */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */ 
             /* EAZY_GEM met  votre service une fonction s'occupant de    */
             /* tout: OnWm_sized()                                         */       
             /* ce dialogue en ressource n'a pas a etre redimensionne donc */
             /* ce message est ignor.                                     */                
             break;   
             
        case WM_MOVED: 
             /**************************************************************/              
             /*........................ WM_MOVED (GEM message).............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de place de la fenetre. En gnral aprs     */
             /* dplacement de la barre de titre ou d'une poignee de       */
             /* dplacement.                                               */
             /* Les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */
             /* EAZY_GEM met  votre service une fonction s'occupant de    */
             /* tout: OnWm_moved()                                         */                   
             OnWm_moved(w_ind, Evnt);                  
             break;   
             
        case WM_FULLED: 
             /**************************************************************/              
             /*........................ WM_FULLED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* plein ecran (FULLER), ou lors d'une demande logicielle.    */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */
             /* EAZY_GEM met  votre service une fonction s'occupant de    */
             /* tout: OnWm_fulled()                                        */     
             /* ce dialogue en ressource n'a pas a etre redimensionne donc */
             /* ce message est ignor.                                     */              
             break;                                         
       } /* end switch message     */
    } /* end if Evnt & MU_MESSAG  */      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}



/*-------------------------- ActiveWindow -------------------------------*/
/* ACTION: Cette fonction active une fenetre specifiee. Soit elle        */
/*         existe deja et alors elle est activee par mise au premier     */
/*         plan,desiconification, ouverture eventuelle. Soit elle        */
/*         n'existe pas et alors elle est creee.                         */
/* ENTREE:                                                               */
/*  long w_attr: attributs GEM classique d'une fenetre                   */
/*               trois attributs de plus:                                */
/*                         BORDER permet d'avoir un cadre epais en       */
/*                                  relief autour de la fenetre.         */
/*                         XMOVER permet d'avoir une poigne de deplace- */
/*                                ment sur le bord sup du cadre epais    */
/*                         XSIZER permet l'agrandissement de la fenetre  */
/*                                en cliquant sur le cadre epais         */
/*  int Ident:  nbr arbitraire(jamais nul) que vous devez donner. Cela   */
/*              peut servir  reperer tel ou tel type de fenetre dans    */
/*              votre programme. Exemple votre application comporte      */
/*              plusieurs fenetres dont une de menu  laquelle vous      */
/*              donnez int ident=2 lors de sa cration. Il est           */
/*              alors facile pour le programme de savoir si la fenetre   */
/*              menu est ouverte en faisant appel  la fonction          */
/*              int IdentToIndice(2); qui vous retourne l'indice de la   */
/*              fenetre (si elle n'existe pas l'indice est >= MAX_WIND ) */
/*              pensez  utiliser des type symboliques declars avec:    */
/*              #define FENETRE_TRUC 2  plutot qu'un nombre sans sens.   */
/*                                                                       */
/* char *title: titre de la fenetre                                      */
/*              de meme le titre de la fenetre peut etre modifie au sein */
/*              de la procedure de fenetre lors du traitement du message */
/*              WM_CONTRUCT.                                             */
/*                                                                       */
/*  CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt): L vous donnez le nom   */
/*              fonction qui sera charge de gerer tous les evenements   */
/*              de cette fenetre. Cette fonction sera appelee par la     */
/*              sur couche EAZY_GEM.                                     */

void ActiveWindow(int ident, long attr, char *title, CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt))
{int w_ind;
 w_ind = IsWindExist(ident);
 if (w_ind==-1)                 /* << SI existe pas la creer         */
    {CreateWindow(attr, ident,0L,w_proc, 0,20+((Ecran_h-20)>>1),Ecran_l,(Ecran_h-20)>>1, title);
    }
 else                           /* << SI elle existe                  */
    {if (Windtab[w_ind].w_flag & W_IS_ICON || 
				 Windtab[w_ind].w_flag & W_IS_ALLICON
			  )
			  {UnconifyWindow(w_ind); 
			  }
     else if (IsWindOpen(w_ind))     /*        SI ouverte la mettre au top */
        {wind_set(Windtab[w_ind].w_h,WF_TOP);
        }
     else                       /*        SI pas ouverte l'ouvrir     */
        {OpenWindow(w_ind, &Windtab[w_ind].ExtGrectUse);
        } 
    } 
}

/*---------------------------- OnGrilleCarClick --------------------------*/
/* ACTION: cette fonction est appellee pour connaitre la case de          */
/*         caractere au dessus de laquelle la souris se trouve.           */
/* ENTREE:                                                                */
/*         OBJECT *object l'on  place l'adresse de l'arbre (1er objet)    */
/*                        ou se situe l'objet grille PAINTBOX             */
/*         int ind_ob l'on doit placer l'indice de l'objet grille.        */
/*         EVNT_O *Evnt structure de flux evenementiel (on en tire la     */
/*                      position de la souris en Evnt->x et Evnt->y )     */
/* RETOUR: numero de la case cliquee (ici 0  255)                        */ 
                                                             

int OnGrilleCarClick(OBJECT *object, int ind_ob, EVNT_O *Evnt)
{GRECT pgrect; 
 VRECT vrect;
 int w_car_rect, h_car_rect, x_o, y_o;
 int i, u, x, y ;
 
 /*............ recuperer dimensions PAINTBOX ........................*/ 
 pgrect = *(GRECT*) &object[ind_ob].ob_x;
 objc_offset(object, ind_ob, &pgrect.g_x, &pgrect.g_y);

 /*............. calcul du rectangle des cases de lettres ............*/  
 pgrect.g_w -= 1;
 pgrect.g_h -= 1;              
 w_car_rect = pgrect.g_w>>5;   /* divise par 32  */
 h_car_rect = pgrect.g_h>>3;   /* divise par 8   */
 x_o        = (pgrect.g_w - (w_car_rect<<5))>>1;
 y_o        = (pgrect.g_h - (h_car_rect<<3))>>1;            
 vrect.left   = pgrect.g_x + x_o;
 vrect.top    = pgrect.g_y + y_o;
 vrect.right  = pgrect.g_x + pgrect.g_w - x_o - 1;
 vrect.bottom = pgrect.g_y + pgrect.g_h - y_o - 1;
 /*............ tester la case survole ..............................*/
 if (IsMouseXYInVrect(Evnt->x, Evnt->y, &vrect))
    {VRECT_to_GRECT(&vrect,&pgrect);
     /*............. tester en X .....................*/     
     x = Evnt->x - vrect.left;        /* relativiser au rectangle */
     i =  x / w_car_rect;
     /*............. tester en Y .....................*/     
     y = Evnt->y - vrect.top;         /* relativiser au rectangle */
     u =  y / h_car_rect;
    }
 return u*32 + i ;
}

/*------------------------------ OpenZoomCar -----------------------------*/
/* ACTION: cette fonction est appellee pour afficher le zoom d'un         */
/*         caractere au dessus duquel la souris se trouve.                */
/*         Cet affichage se fait par l'intermediare d'une boite rectangu- */
/*         laire dans lequel le caractere agrandi s'affiche.              */
/* ENTREE:                                                                */
/*         char *str: pointe sur une chaine d'un caractere (celui        */
/*                   afficher).                                           */
/*         int x, int y: coordonnees du centre de la boite de zoom.       */
/*         int fntid:  indice VDI de la fonte a afficher.                 */
/*         GRECT *limit_grect: pointeur sur une structure de rectangle    */
/*                donnant les coordonnes du rectangle que la boite de    */
/*                zoom ne doit pas depasser.                              */
/* SORTIE:                                                                */
/*         int *x: adresse d'un int (pointeur sur un int) dans lequel la  */
/*                 fonction placera la coordonnee X de langle sup gauche  */
/*                 du rectangle ecran sauvegard.                         */
/*         int *y: adresse d'un int (pointeur sur un int) dans lequel la  */
/*                 fonction placera la coordonnee Y de langle sup gauche  */
/*                 du rectangle ecran sauvegard.                         */
/* RETOUR: int *: adresse de stockage du fond de la boite. Cette adresse  */    
/*                est reservee par la fonction et doit etre liberee       */
/*                apres usage de la boite. Utilisez CloseZoomCar().       */

int *OpenZoomCar(char *str, int x, int y, int fntid, GRECT *limit_grect, int *rx, int *ry)
{VRECT vrect;
 GRECT grectzommback;
 GRECT client_grect; 
 int *back, xt ,yt;
 grectzommback.g_w = 80;
 grectzommback.g_h = 80;
 grectzommback.g_x = x - (grectzommback.g_w>>1);
 grectzommback.g_y = y - (grectzommback.g_h>>1);
 AdjustGrectToGrect(limit_grect, &grectzommback);                       
 Mouse_off();
 back = GetGRECT(&grectzommback);
 if (back)
    {ClipGrect(&grectzommback);
     /*.......... Tracer une boite ombree ...................*/
     DrawEnjolivedGrectBox(&grectzommback, &client_grect,5);
     /*......... Tracer le caractere principal .............*/     
     Graphmode(2);   
     Deftext(1,0,0,30,fntid); 
     vst_alignment( VDIhandle, 1, 5, &x, &y );
     xt  = client_grect.g_x + (client_grect.g_w>>1);
     yt  = client_grect.g_y +2;
     VdiText(xt,yt,str);     
     Deftext(1,0,0,10,1);
     /*......... Tracer le petit rectangle .............*/   
     GRECT_to_VRECT(&client_grect, &vrect);
     Graphmode(1);
     vrect.left    = vrect.right  - 20;
     vrect.top     = vrect.bottom - 20;
     Deffill(0,0,0);     
     Pbox((int*)&vrect);  
     Box((int*)&vrect);
     /*.......... Tracer caractere en bas a droite .....*/
     Graphmode(2);
     VdiText(vrect.left + 10 , vrect.top+2, str);         
    }
 *rx = grectzommback.g_x;
 *ry = grectzommback.g_y;   
 return back;   
}


/*------------------------------ CloseZommCar ----------------------------*/ 
/* ACTION: cette fonction est appellee pour afficher le zoom d'un         */
/*         caractere au dessus duquel la souris se trouve.                */
/*         Cet affichage se fait par l'intermediare d'une boite rectangu- */
/*         laire dans lequel le caractere agrandi s'affiche.              */
/* ENTREE:                                                                */
/*         char *back: pointe sur zone de sauvegarde ecran de la boite    */
/*                     de zoom.                                           */
/*         int x, int y: coordonnees de l'angle sup gauche de la zone de  */
/*                       sauvegarde de la boite de zoom.                  */
/* RETOUR: int *: adresse de stockage du fond de la boite. Cette adresse  */    
/*                est reservee par la fonction OpenZommCar(): et est      */
/*                liberee  par cette fonction  CloseZoomCar():  qui       */
/*                retourne zero.                                          */   
                                      
int *CloseZommCar(int *back, int x, int y)
{if (back)
    {Mouse_off();
     Put(x, y, back, 3);        
     free(back); 
     Mouse_on();
    }
 return 0;
}