/*/////////////////////////////////////////////////////////////////////*/
/*////////////////////////// I N C L U D E S //////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
/*--------------------- INCLUDES DES AUTRES MODULES DU PROGRAMME ------*/
#include "EAZY_GEM.H"  /* inclure les definitions des fonctions que le */
                       /* que le module EAZY_GEM.C met  notre         */
                       /* notre disposition                            */ 
                       /* et inclure les definitions des variables     */
                       /* globales  EAZY_GEM                           */

/*................ inclure les definitions generees par ...............*/
/*                 l'editeur de ressources afin d'utiliser             */
/*                 les symboles plutot que des nombres                 */                       
#include "LISEZMOI.SYS\LISEZMOI.H"
#include "LISEZMOI.SYS\LIS_INFO.H"

/*/////////////////////////////////////////////////////////////////////*/
/*////////////////////////// D E F I N E S  ///////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/ 
/*                         TYPAGE DES FENETRES                         */  
#define W_LISEZ       1     /* ID Fenetre lisez moi                    */
#define W_RINFO       2     /* ID Fenetre information                  */
/*/////////////////////////////////////////////////////////////////////*/
/*////////////// V A R I A B L E S    G L O B A L E S /////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
char PathVABuff[512];
char PathTxt[512];
char NomTxt[256];
/*/////////////////////////////////////////////////////////////////////*/
/*/////////////// P R O T O T Y P E S  F O N C T I O N S //////////////*/
/*/////////////////////////////////////////////////////////////////////*/
/*................ fonctions de fenetres ..............................*/
static CALLBACK WindProcLisezmoi(int w_ind, EVNT_O *Evnt);
static CALLBACK WindProcInfo(int w_ind, EVNT_O *Evnt);

/*.............. petites fonctions pour faciliter la vie !! ............*/
char *ChangeScrollTexte(OBJECT *object, int ind, char *PathTxt, char *NomTxt);
void AdaptListBoxToWindHeight(int w_ind,int ob_list, int mincases, GRECT *ext_grect);
void ActiveWindow(int ident, long attr, char *title, CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt));

/*//////////////////////////////////////////////////////////////////////*/
/*                A   C O M M E N C E   I C I   !!!!                   */
/*              Definition des fonctions de ce module                   */
/*//////////////////////////////////////////////////////////////////////*/
 
/*---------------------------- main ------------------------------------*/
void main (void)
{if (InitEazyGem("LISEZMOI.PRG") != -1)   
    {/*......... crer et Ouvrir les fenetres ................*/    
     CreateWindow(SMALLER|CLOSER|NAME|MOVER|XMOVER|BORDER|XSIZER|FULLER, 
                  W_LISEZ, 0L, WindProcLisezmoi, 0,0,0,0, "LISEZMOI");
     /*........Noter chemin d'ou a ete lance le programme .....*/
     /*        et envoyer un message VA_START si le            */
     /*     programme est demarre avec un nom de fichier       */
     /*         de faon  demarrer avec ce fichier            */
     if (GetPathAppli(PathVABuff, NomAppli, PathVABuff))
        {Send_VA_START(Appl_id, PathVABuff);            
        }
     /*.......... Passer la main  EAZY_GEM ..................*/
     BouclePrincipale(0L); 
              
    }
 /*........ appel indispensable pour finir un programme ......*/
 /*             EZ_GEM proprement                             */ 
 ExitEasyGem();   
}


/*------------------------------ WindProcLisezmoi -----------------------*/
CALLBACK WindProcLisezmoi(int w_ind, EVNT_O *Evnt)
{/*.............. les variables locales suivantes sont souvent ..........*/
 /*           utiles pour toutes les fonctions de fenetre EZGEM pour:    */
 GRECT grect;          /* rectangle surface de travail                   */
 int w_h;              /* handle de la fenetre de cette Wind_proc_xxx    */
 int wh_top;           /* handle de la fenetre en avant plan             */
 /*.............. variables locales specifiques  notre .................*/
 /*                  exemple de Ressource en fenetre                     */
 OBJECT *object;     /* pointeur d'objet pour les ressources             */ 
 char *sztt_txt;     /* pointera sur adresse copie texte bulle d'aide    */
 int ob_ret;         /* retournera l'objet ressource selectionne         */
 DLG_VAR *dlg;       /* structure attachee  chaque ressource en fenetre */
 /*.................. INITIALISER LES VARIABLES .........................*/
 dlg = &Windtab[w_ind].DlgVar;
  
 /*.................... recuperer handles ..............................*/    
 wind_get( 0, WF_TOP, &wh_top); /* celui de fenetre avant plan          */
 w_h = Windtab[w_ind].w_h;      /* celui de notre fenetre               */
 grect = Windtab[w_ind].GemWorkGrect; /* recuperer espace de travail    */
 
 /*...................TOUCHE CLAVIER APPUYEE (MU_KEYBD).................*/
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec une touche clavier  */
 /* Notamment l'edition et saisie de texte dans les champs editables et */
 /* les raccourcis clavier.                                             */
 /* Pour une ressource en fenetre il est indispensable que l'evenement  */
 /* MU_KEYBD soit traite avant l'evenement  MU_BUTTON afin de permettre */
 /* un fonctionnement correct des raccourcis clavier. En effet le       */
 /* raccourci clavier d'un objet simule un clic souris sur l'objet.     */
 /* en renvoyant un evenement MU_BUTTON                                 */

 if (Evnt->evnt & MU_KEYBD && w_h==wh_top)
    {int i;
     char scan,car;
     char buft[32];
     
     object=dlg->tree;
     scan=(char)(Evnt->key>>8); 
     switch(scan)
       {case  80:     /* down */
        case  72:     /* up   */ 
          if (Evnt->ksp & K_CTRL && 
              dlg->ObjEdit == WND_INFO_INT_TXT && 
              dlg->LstAdr  ==0
             )  
             {i=Max (8,Min(atoi(ObjcGetTxt (object, WND_INFO_INT_TXT)),64));
              if (scan==80) i=Min(64,i+1);
              else          i=Max(8,i-1);
              ObjcSetTxt (object, WND_INFO_INT_TXT,itoa(i,buft,10));
              SetCursObEditOff(dlg);
              Xobjc_draw(object, WND_INFO_INT_TXT, 1, &grect); 
              SetScrollBoxParam(object,WND_INFO_SCROLL,i,-2,-2,-2,-2,-2,-2,-2,(void*)-2L,-2);
              VascHeightAdjust(object, WND_INFO_SCROLL, WND_INFO_BAR);   
              Xobjc_draw(object, WND_INFO_BAR, 1, &grect);    
              Xobjc_draw(object, WND_INFO_SCROLL, 1, &grect);              
             }
          else if (Evnt->ksp & (K_RSHIFT|K_LSHIFT) && dlg->LstAdr  == 0)  
             {GetScrollBoxParam(object,WND_INFO_SCROLL,0L,0L,0L,0L,0L,0L,0L,0L,0L,&i);
              if (scan!=80) i=-i;
              DoScrollBoxSlide (object, WND_INFO_SCROLL,i,0,&grect);
              object[WND_INFO_ASC].ob_y = VascPosAdjust(object, WND_INFO_SCROLL, WND_INFO_BAR); 
              Xobjc_draw(object, WND_INFO_BAR, 1, &grect);                                     
             }
          else if (dlg->LstAdr  == 0)
             {if (scan==80) i= 1;
              else          i=-1;
              DoScrollBoxSlide (object, WND_INFO_SCROLL,i,0,&grect);
              object[WND_INFO_ASC].ob_y = VascPosAdjust(object, WND_INFO_SCROLL, WND_INFO_BAR); 
              Xobjc_draw(object, WND_INFO_BAR, 1, &grect);                                     
             }                   
          break;
        case 71:     /* clr home  */
          if (Evnt->ksp & (K_RSHIFT|K_LSHIFT))
             {int nblt,    /* nbr de lignes total document                 */
                  nb_l;    /* nbr de lignes affichables par la scroll box  */
              GetScrollBoxParam (object, WND_INFO_SCROLL,0L,0L,&nblt,0L,0L,0L,0L,0L,0L,&nb_l); 
              SetScrollBoxParam (object, WND_INFO_SCROLL,-2,-2,-2,-2,nblt-nb_l,-2,-2,-2,(void*)-2L,-2);  
             }
          else
             {SetScrollBoxParam (object, WND_INFO_SCROLL,-2,-2,-2,-2,0,-2,-2,-2,(void*)-2L,-2); 
             }
          object[WND_INFO_ASC].ob_y = VascPosAdjust(object, WND_INFO_SCROLL, WND_INFO_BAR); 
          Xobjc_draw(object, WND_INFO_BAR, 1, &grect);  
          Xobjc_draw(object, WND_INFO_SCROLL, 1, &grect);    
          break;      
          
        default: 
             car = (char)ScanToAscii(Evnt->key, Evnt->ksp);             
             switch (car|' ')
               {case 'q':
                   EZGemRun=-1;
                   break;
                default:                     
                  Xform_keybd(w_ind, Evnt);
                  i   =  Max (8,Min(atoi(ObjcGetTxt (object, WND_INFO_INT_TXT)),64));
                  SetScrollBoxParam(object,WND_INFO_SCROLL,i,-2,-2,-2,-2,-2,-2,-2,(void*)-2L,-2);
                  VascHeightAdjust(object, WND_INFO_SCROLL, WND_INFO_BAR);   
                  Xobjc_draw(object, WND_INFO_BAR, 1, &grect);    
                  Xobjc_draw(object, WND_INFO_SCROLL, 1, &grect);                              
               }   /* end switch car  */
       } /*end switch scan  */                        
    }
    
 /*.......................... BOUTONS SOURIS ...........................*/ 
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec un appui sur un     */
 /* bouton de souris.                                                   */
 /* Notamment l'appui sur un bouton de la ressource, la selection du    */
 /* texte dans les champs editables, et le placement du curseur de      */
 /* texte dans les champs editables.                                    */
    
 if (Evnt->evnt & MU_BUTTON )
    {ob_ret = Xform_button(w_ind, Evnt);     
     if (ob_ret>-1)
        {char buft[512];
         int i;       
         Evnt->evnt &= ~MU_BUTTON;   /* empecher propagation message  MU_BUTTON */
         object=dlg->tree;
         /*............. si objet exit selectionne ...................*/
         ob_ret &=0x7FFF;
         object[ob_ret].ob_state &= ~SELECTED;         
         if (object[ob_ret].ob_type &((G_CICON<<8)|G_USERDEF))           
             SendObjectRedraw( Windtab[w_ind].w_h, object, ob_ret); 
         else
             Xobjc_draw(object, ob_ret, 1, &grect);  
         /*.............. ICI ACTION SELON BOUTON CLIQUE..............*/  
                   
         switch (ob_ret)            
            {case WND_INFO_LOAD_IC: /* Icone load               */
                  if (Fic_select (PathTxt,NomTxt,".*","Charger un texte")>0)                       
                     {strcpy(PathVABuff,PathTxt);
                      strcat(PathVABuff,NomTxt);
                      Send_VA_START(Appl_id, PathVABuff);                           
                     }
                  break;
             case WND_INFO_PRNT_IC:
                  strcpy(buft,"[1][Un jour il sera peut tre possible|d'imprimer sous SpeedoGDOS en|cliquant sur cette magnifique icone.");
                  strcat(buft,"|Si vous en avez le courage, faites la|routine d'impression, cela m'avancera !!|et je vous en serai reconnaissant.]");
                  strcat(buft,"[Allez ok je le fais|Et puis quoi encore !!]");
                  form_alert(1,buft);
                  break;
             case WND_INFO_WICONE:  /* Icone en haut  gauche  */
               {/*
                int x,y,retpop;
                objc_offset(object,WND_INFO_WICONE,&x,&y);
                retpop = PopupDo(object, WND_INFO_POPMENU, WND_INFOPOP_INFO, 
                                 x + (object[WND_INFO_POPMENU].ob_width>>1),
                                 Evnt->y);
                */
                ActiveWindow(W_RINFO, XMOVER|BORDER, "A propos de LISEZMOI", WindProcInfo);                       
                break;
               }  
                     
             case WND_INFO_INT_UP:  /* fleche haute interligne  */
             case WND_INFO_INT_DW:  /* fleche basse interligne  */
                  do
                    {i=Max (8,Min(atoi(ObjcGetTxt (object, WND_INFO_INT_TXT)),64));
                     if (ob_ret == WND_INFO_INT_UP) i=Max(8,i-1); 
                     else                           i=Min(64,i+1);  
                     ObjcSetTxt (object, WND_INFO_INT_TXT,itoa(i,buft,10));
                     SetCursObEditOff(dlg);
                     Xobjc_draw(object, WND_INFO_INT_TXT, 1, &grect);                      
                     Pause_EZ(1);
                    } while(Mousek());
                  SetScrollBoxParam(object,WND_INFO_SCROLL,i,-2,-2,-2,-2,-2,-2,-2,(void*)-2L,-2);  
                  VascHeightAdjust(object, WND_INFO_SCROLL, WND_INFO_BAR);      
                  Xobjc_draw(object, WND_INFO_BAR, 1, &grect);                   
                  Xobjc_draw(object, WND_INFO_SCROLL, 1, &grect);                       
                  break;                      
            } /* end switch ob_ret  */                       
        }  /* endif objet selectable cliqu  */ 
    } /* endif MU_BUTTON  et fenetre au premier plan */
    
 /*.......................... TIMER ..................................*/  
 /* Dans le cadre d'une ressource en fenetre la fonction: Xform_timer */
 /* s'occupe de tout ce que doit gerer le timer notamment le clignote */
 /* ment du curseur texte dans les champs editables                   */ 
 if (Evnt->evnt & MU_TIMER && w_h==wh_top)  
    {Xform_timer(w_ind);    
    }
    
 /*.......................... MU_MOVE ....................................*/   
 /* L'vnement MU_MOVE se manifeste chaque fois que la souris a modifie  */
 /* sa position. L'appel  la fonction: Xform_mu_move() permet de traiter */
 /* tout ce qui concerne un mouvement souris au dessus d'une ressource en */
 /* fenetre et le mouvement de la souris au dessus des bords de la        */
 /* fenetre                                                               */     
 if (Evnt->evnt & MU_MOVE)   /*  (EZGEM evenement)   */
    {Xform_mu_move(w_ind, Evnt);
    }      
    
 /*..........................Rpondre aux messages MU_MESAG ..............*/
 /* L'vnement MU_MESAG se manifeste chaque fois qu'EAZY_GEM demande    */
 /* la fonction de fenetre de rpondre  un message. ci_dessous nous      */
 /* allons rpondre aux messages concernant notre fenetre.                */    
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {case WM_CONSTRUCT: 
             /***********************************************************/
             /*.................... WM_CONSTRUCT (EZGEM message)........*/
             /* Ce message est transmis avant la creation et ouverture  */
             /* de la fenetre associee  notre procedure de fenetre.    */
             /* c'est  cet endroit que vous devez initialiser tout ce  */
             /* qui concerne votre fenetre: Memoire, chargement d'un    */
             /* fichier ressource, modification des dimensions fenetre  */
             /* avant ouverture, declaration des Bulles d'aide associees*/
             /*  cette fenetre, titre de la fenetre.....etc            */
             /* eventuellement si pas deja fait avant: ouverture d'une  */
             /* Station de travail VDI autre que celle d'EAZY_GEM.      */  
             /* EAZY_GEM vous laisse toute liberte pour faire ce que    */
             /* vous voulez:                                            */
             /* Vous pouvez tres bien charger votre fichier ressource  */    
             /* cet endroit ou avant dans l'application..               */
             /* Lors de ce message il est donn dans:                   */
             /*                  Evnt->pipe[X_B]                        */
             /*                  Evnt->pipe[Y_B]                        */
             /*                  Evnt->pipe[W_B]                        */
             /*                  Evnt->pipe[H_B]                        */
             /*                               les dim exterieures  maxi */
             /* possibles d'ouverture de la fenetre sur l'ecran.        */ 
             /* c'est par defaut ces dimensions qui sont choisies pour  */
             /* ouvrir une fenetre.Si on veut d'autres dimensions c'est */
             /* ces valeurs qu'il faudra modifier.                      */
             /*                                                         */
             /* REPONDRE AU MESSAGE WM_CONTRUCT:                        */
             /* Il est possible de repondre au message WM_CONSTRUCT     */
             /* de deux manieres equivalentes au point de vue resultat: */
             /* Soit en faisant  Evnt->evnt = WM_ABORT; (ou WM_STANDBY) */
             /* Soit en faisant  return WM_ABORT;       (ou WM_STANDBY) */                
             /*                                                         */
             /* Vous pouvez interrompre le processus de creation de la  */
             /* fenetre en retournant le message: WM_ABORT par exemple  */
             /* vous n'avez pas pu reserver toute la memoire souhaitable*/
             /* ou vous n'avez pas trouve un fichier indispensable      */
             /* ou pour toute autre raison liee a votre application.etc.*/
             /*                                                         */
             /* Vous pouvez empecher l'ouverture de la fenetre et donc  */
             /* permettre juste sa creation en retournant le message:   */   
             /* WM_STANDBY. Pour ouvrir et afficher la fenetre ulterieu-*/
             /* ment il faudra utiliser la fonction: OpenWindow         */
             /* Si vous ne retournez pas ce message la fenetre s'ouvre  */
             /* dans la foulee (cas le plus utile).                     */                           
             /*                                                         */
             /* Pour les ressources en fenetre j'ai cree une fonction   */
             /* s'occupe de tout ce qu'il y a a faire  ce sujet        */
             /* la voici:  Xform_construct(w_ind, Evnt);                */             
             dlg->AdrRsc = LoadAppliRsc( "LISEZMOI.RSC", NO_SCALE);              
             if (dlg->AdrRsc)                                        
                {int clr,pts,fnt,itl,i;
                 char buft[32];
                 dlg->type     = RSC_DIAL;   /* type de structure passee en entree */ 
                 dlg->NumTree  = LISEZMOI;
                 Xform_construct(w_ind, Evnt);
                 /*........... placer le tout sous la souris ..............*/
                 AdjustWindCoordToScreen (w_ind, Evnt, (GRECT*)&Evnt->pipe[X_B]); 
                 /*.............. Adapter hauteur des LISTBOX ..............................*/                
                 AdaptListBoxToWindHeight(w_ind,WND_INFO_CAR_PTS , 20, (GRECT*)&Evnt->pipe[X_B]);
                 AdaptListBoxToWindHeight(w_ind,WND_INFO_COLOR, (int)Nb_color, (GRECT*)&Evnt->pipe[X_B]);
                 AdaptListBoxToWindHeight(w_ind,WND_INFO_FNTSEL, NbFont, (GRECT*)&Evnt->pipe[X_B]);
                 /*........... Initialiser les elements de la ressource ........*/
                 /*                   sur les bonnes valeurs                    */
                 /*        Recuperer parametres affichage texte                 */
                 GetScrollTxtParam(dlg->tree,WND_INFO_SCROLL, &clr, &pts, &fnt);
                 /*.......... positionner listbox de fonte sur fonte            */
                 i = Max(0,FntID_VDI_to_TabInd(fnt));
                 SetListBoxParam(dlg->tree,WND_INFO_FNTSEL,i,i,-2,-2,-2,(void*)-2L);
                 /*.......... positionner listbox de couleur sur couleur        */
                 SetListBoxParam(dlg->tree,WND_INFO_COLOR,clr,clr,-2,-2,-2,(void*)-2L);
                 /*.......... positionner nbr de pts                            */
                 SetListBoxParam(dlg->tree,WND_INFO_CAR_PTS,pts,pts,-2,-2,-2,(void*)-2L);
                 /*.......... positionner l'interligne                          */
                 GetScrollBoxParam(dlg->tree,WND_INFO_SCROLL,&itl,0L,0L,0L,0L,0L,0L,0L,0L,0L);
                 ObjcSetTxt (dlg->tree, WND_INFO_INT_TXT,itoa(itl,buft,10));
                }                  
             else
                {return WM_ABORT;
                }                  
             break;
             
        case WM_DESTRUCT:       /*  (EZGEM message)   */
             /**************************************************************/              
             /*........................ WM_DESTRUCT (EZGEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre avant   */
             /* que le systeme ne la detruise. c'est  cet endroit qu'il   */
             /* convient de desinitialiser tout ce que l'on avait fait     */
             /* auparavant memoire, bulles d'aide, ressources....          */             
             Xform_Destruct(w_ind, Evnt);    
             RscFicUnLoad(dlg->AdrRsc);                         
             break;           
                       				     
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             /**************************************************************/
             /*...................... WM_TT_ON_OFF (EZGEM message).........*/
             /* Ce message est envoy  notre fenetre chaque fois qu'il est*/
             /* demand d'activer ou de desactiver l'affichage des bulles  */
             /* d'aide. Il suffit simplement d'appeler la fonction qui suit*/
             /* pour mettre  jour l'objet representant l'etat actif ou    */
             /* inactif de notre ressource (si il existe)                  */
             /* Cet Objet est un objet type BOXTEXT extended type 25 que   */ 
             /* vous devez placer sur votre formulaire. Il refletera l'etat*/
             /* actif ou inactif du systeme de bulle d'aide.               */             
             SetBulleState(w_h, dlg->tree);
             break; 
               
        case WM_EXEFUNC:        /*  (EZGEM message)   */
             /**************************************************************/              
             /*...................... WM_EXEFUNC .(EZGEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois qu'il est demand d'executer une fonction referencee  */
             /* par un numero de fonction.                                 */
             /* Le message est compose comme suit:                         */
             /* SI  Evnt->pipe[WHND]= RSC_DIAL; le message provient d'une  */
             /*                             ressource.  ET ALORS           */                     
             /*     Evnt->pipe[X_G] = indice objet declenchant le message  */
             /*     Evnt->pipe[Y_G] = numero de la fonction referencee     */
             /*     *(long*)&Evnt->pipe[W_G] =  adr arbre ou est l'objet   */            
             if (Evnt->pipe[Y_G]>=1000 &&    /* SI fonctions de mise  jour de  */
                 Evnt->pipe[Y_G]<=1002 &&    /*    couleur et police            */
                 Evnt->pipe[WHND] == RSC_DIAL
                )
                {int i;
                 char *pt_txt;
                 long val;
                 OBJECT *objc;
                 objc = (OBJECT*) *(long*)(&Evnt->pipe[W_G]);
                 i   = Evnt->pipe[X_G];
                 if (objc[i].ob_type == (G_USERDEF|(LISTBOX<<8)))
                    {pt_txt = ObjcGetTxt(objc,i);
                     if (pt_txt>0)
                        {memcpy(&val,pt_txt,sizeof(long));
                         i = GetSelectedListBoxItem(objc, i);
                         if (val == LST_COLOR)
                            {SetScrollTxtParam(dlg->tree,WND_INFO_SCROLL,i,-2,-2);
                             SendObjectRedraw(w_h, dlg->tree, WND_INFO_SCROLL);                              
                            }
                         else if (val == LST_FNTSEL)
                            {SetScrollTxtParam(dlg->tree,WND_INFO_SCROLL,-2,-2,(int)FontID[i]);
                             SendObjectRedraw(w_h, dlg->tree, WND_INFO_SCROLL);
                            }
                         else if (val == LST_FNTPTS)
                            {SetScrollTxtParam(dlg->tree,WND_INFO_SCROLL,-2,i,-2);
                             SendObjectRedraw(w_h, dlg->tree, WND_INFO_SCROLL);
                            }                               
                        }  /* endif if pt_txt>0               */
                    }     /* endif if G_USERDEF|(LISTBOX<<8) */
                }        /* endif if RSC_DIAL               */                 
             break;         
             
        case WM_TT_GET_TXT:     /*  (EZGEM message)   */
             /**************************************************************/              
             /*...................... WM_TT_GET_TXT .(EZGEM message).......*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois que le systeme d'affichage d'une bulle d'aide desire  */
             /* qu'on lui fournisse un texte  afficher.                   */
             /* Ce texte peut etre affiche sur plusieurs lignes en mettant */
             /* comme separateur le signe | .                              */
             /* Exemple:                                                   */
             /* strcpy(sztt_txt,"Premiere ligne|deuxieme ligne|troisieme");*/
             /* Si vous placez une chaine vide "", la bulle d'aide ne sera */
             /* pas affichee.                                              */
             /*  Exemple: strcpy(sztt_txt,"");                             */
             /*                                                            */             
             sztt_txt  = (char*) *(long*)(&Evnt->pipe[W_G]); 
             if (Evnt->pipe[X_G]==TT_UPSTOOL)
                {switch ( Evnt->pipe[Y_G])                            
                   {case WND_INFO_FIRST:  
                    case WND_INFO_SCROLL:                         
                         strcpy(sztt_txt,"LISEZMOI Visualisateur|  de fichiers ASCII.|    Version Alpha.| Ecrit Avec EAZY-GEM|  NITROSOFT CORP (c)"); 
                         break;                                    
                    case WND_INFO_UP:                           
                         strcpy(sztt_txt,"Voir une ligne vers le HAUT|Si SHIFT Appuy, deux lignes |Si CONTROL, quatre lignes.");   
                         break;                                    
                    case WND_INFO_DOWN:                              
                         strcpy(sztt_txt,"Voir une ligne vers le BAS|Si SHIFT Appuy, deux lignes |Si CONTROL, quatre lignes.");   
                         break; 
                    case WND_INFO_BAR:                           
                         strcpy(sztt_txt,"Cliquez ici pour faire|defiler le texte,|d'une page vers le haut ou le bas");   
                         break;                                    
                    case WND_INFO_ASC:                              
                         strcpy(sztt_txt,"Cliquez ici, et maintenez|le bouton gauche appuy|tout en dplaant la souris");   
                         break; 
                    case WND_INFO_FNTSEL:                              
                         strcpy(sztt_txt,"Permet de choisir la police|de caractres du texte");
                         break;
                    case WND_INFO_COLOR:                              
                         strcpy(sztt_txt,"Permet de choisir la couleur|des caractres du texte");
                         break; 
                    case WND_INFO_CAR_PTS:                              
                         strcpy(sztt_txt,"Permet de choisir la taille|des caractres du texte");
                         break; 
                    case WND_INFO_INT_UP:                              
                         strcpy(sztt_txt," Diminuer l'interligne de 1 pixel| idem avec CONTROL et touche| clavier flche BASSE");
                         break; 
                    case WND_INFO_INT_DW:                              
                         strcpy(sztt_txt," Augmenter l'interligne de 1 pixel| idem avec CONTROL et touche| clavier flche HAUTE");
                         break;      
                    case WND_INFO_INT_TXT:                              
                         strcpy(sztt_txt,"Saisie de l'interligne");
                         break;
                    case WND_INFO_LOAD_IC:                              
                         strcpy(sztt_txt,"Cliquez ici pour charger| et visualiser un nouveau|texte");
                         break;   
                    case WND_INFO_PRNT_IC:                              
                         strcpy(sztt_txt,"Permettra d'imprimer sous|GDOS et Speedo");
                         break;   
                    case WND_INFO_WICONE:                              
                         strcpy(sztt_txt,"Pour en savoir plus|   sur LISEZMOI");
                         break;   
                    default:                                       
                         strcpy(sztt_txt,"");                       
                   }                                                                            
                }
             break;        
                      
        case WM_REDRAW:               
             /**************************************************************/              
             /*........................ WM_REDRAW (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut redessiner une partie de la fenetre (par exemple un*/
             /* accessoire qui la recouvrait vient de se fermer, il faut   */
             /* alors retracer la partie de notre fenetre que l'accessoire */
             /* recouvrait. Avant c'etait un veritable enfer, maintenant   */
             /* il vous faut juste appeler la routine: Lister_rectangles   */
             /* qui vous renvoie le message WM_PAINT (voir doc)            */
             /* et vous n'avez plus  vous occuper de savoir comment faire */
             /* notamment pour traiter la liste des rectangles et leur     */
             /* intersection avec notre fenetre.                           */                  
             /* Dans cet exemple, tout etant sous forme de ressource,      */
             /* EAZY_GEM ne gnre pas de message WM_PAINT, car il n'y a   */
             /* pas de surface client  retracer.                          */
             /* Il faut tout de meme appeler la fonction:                  */
             /*         Lister_rectangles() , afin que la ressource soit   */
             /*         retrace.                                          */
             Lister_rectangles(w_h,(GRECT*)&Evnt->pipe[X_G]);                          
             break;    
             
        case WM_BOTTOM:
             /**************************************************************/              
             /*........................ WM_BOTTOM (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre au dernier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_BOTTOM );   */      
             wind_set(w_h, WF_BOTTOM );             
             break;                  
                          
        case WM_TOPPED:
             /**************************************************************/              
             /*........................ WM_TOPPED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre en premier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_TOP );      */
             wind_set(w_h, WF_TOP );             
             break;
             
        case AP_TERM:  
             /**************************************************************/              
             /*........................ AP_TERM (GEM message)..............*/
             /* Ce message est envoy  l'application lorsqu'il lui est    */
             /* demande de s'arreter (exemple lorsque il y a changement   */
             /* rsolution). Il est d'usage de quitter sans demande de     */
             /* comfirmation. Faites les sauvegardes ncessaires avant de  */
             /* quitter. Et quittez.                                       */
             /* Ici je mets la variable: EZGemRun  -1, de faon  ce      */
             /* que le programme s'arrete sans demande de confirmation.    */   
             /* donc je le traite avec le message WM_CLOSED                */   
        case WM_CLOSED:
             /*........................ WM_CLOSED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre         */
             /* lorsqu'une demande de fermeture de la fenetre est demandee */
             /* si vous voulez detruire completement cette fenetre il faut */
             /* appeler imperativement la fonction: DestroyWindow          */
             /* pour la reouvrir ensuite il vous faudra appeler la         */
             /* fonction:                           CreateWindow           */
             /* sinon il vous faut faire un simple: CloseWindow  et la     */
             /* reouvrir par:                       OpenWindow             */
             /* sans etre oblige de tout reinitialiser                     */
             /* CloseWindow(w_ind);                                        */
             
             /* Ici je mets la variable: EZGemRun  zero, de faon  ce    */
             /* que le programme s'arrte sans demande de confirmation.    */     
             EZGemRun = -1;             
             break;
             
        case WM_ALLICONIFY:    
             /**************************************************************/              
             /*........................ WM_ALLICONIFY (GEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier toutes les fenetres. EAZY_GEM met  votre*/
             /* disposition une fonction s'occupant de tout: AllIconify()  */
             /* vous pouvez lui donner en entree l'adresse d'une structure */
             /* GRECT, contenant des coordonnes d'iconification. Si vous  */
             /* placez zero alors EAZY_GEM les calcule pour vous.          */             
             AllIconify(0L);
             break;  
                
        case WM_ICONIFY:
             /**************************************************************/              
             /*........................ WM_ICONIFY (GEM message)...........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier une fenetre.EAZY_GEM met  votre service */
             /* une fonction s'occupant de tout: IconifyWindow()           */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             /* vous pouvez aussi lui donner en entree l'adresse d'une     */
             /* structure GRECT, contenant des coordonnes d'iconification.*/
             /* Si vous placez zero alors EAZY_GEM les calcule pour vous.  */ 
             IconifyWindow(w_ind, 0L);
             break;                   
                                         
        case WM_UNICONIFY:
             /**************************************************************/              
             /*........................ WM_UNICONIFY (GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut desiconifier une fenetre.EAZY_GEM met  votre      */
             /* service une fonction s'occupant de tout: UnconifyWindow()  */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             UnconifyWindow(w_ind);            
             break;
             
        case AP_DRAGDROP:
             /**************************************************************/              
             /*........................ AP_DRAGDROP (GEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* un truc a t drag (tir) sur sa fenetre.                 */
             /* Ici je verifie si c'est une liste de fichiers, et si c'est */
             /* le cas je lance un message VA_START pour le charger.       */
				     if (GetDragDropList(Evnt,PathVABuff,sizeof(PathVABuff)))
				        {
				         Send_VA_START(Appl_id, PathVABuff);
				        }
				     break;    
				                             
        case WM_SIZED:
             /**************************************************************/              
             /*........................ WM_SIZED (GEM message).............*/   
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* dimensionnement, ou lors d'une demande logicielle.         */
             /* ou apres une modification des coordonnes de la fenetre     */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */ 
             /* EAZY_GEM met  votre service une fonction s'occupant de    */
             /* tout: OnWm_sized()                                         */       
             {GRECT wgrect, old_wgrect,deltgrect;              
              int deltx,delty;
              object=dlg->tree;
              GetGemWindExtGRECT(Windtab[w_ind].w_h, &wgrect); 
              WindGemBorderToEZWork(Windtab[w_ind].w_attr, &wgrect, &old_wgrect);
              WindGemBorderToEZWork(Windtab[w_ind].w_attr,(GRECT*)& Evnt->pipe[X_G], &wgrect);
              CloseListBox (w_ind);
              
              AdaptListBoxToWindHeight(w_ind,WND_INFO_CAR_PTS , 20, (GRECT*)&Evnt->pipe[X_G]);
              AdaptListBoxToWindHeight(w_ind,WND_INFO_COLOR, (int)Nb_color, (GRECT*)&Evnt->pipe[X_G]);
              AdaptListBoxToWindHeight(w_ind,WND_INFO_FNTSEL, NbFont, (GRECT*)&Evnt->pipe[X_G]);
              
              deltx = wgrect.g_w -  old_wgrect.g_w; 
              delty = wgrect.g_h -  old_wgrect.g_h;    
              object[WND_INFO_BAR].ob_x         += deltx;
              object[WND_INFO_UP].ob_x          += deltx;
              object[WND_INFO_DOWN].ob_x        += deltx;  
              object[WND_BULLE_ON_OFF].ob_x     += deltx;
              object[WND_INFO_SCROLL].ob_width  += deltx;  
              object[WND_INFO_DOWN].ob_y        += delty;  
              object[WND_INFO_BAR].ob_height    += delty;  
              object[WND_INFO_SCROLL].ob_height += delty;                 
              VascHeightAdjust(object, WND_INFO_SCROLL, WND_INFO_BAR);                            
              SetScrollBoxParam(object,WND_INFO_SCROLL,-2,-2,-2,-2,-2,-2,-2,-2,(void*)-2L,LST_NODRAW);          
              OnWm_sized(w_ind, Evnt);  
              SetScrollBoxParam(object,WND_INFO_SCROLL,-2,-2,-2,-2,-2,-2,-2,-2,(void*)-2L,LST_DRAW);
              SendObjectRedraw(w_h, object, WND_INFO_SCROLL);
              /*................. TRACER LES RELIQUATS ............*/
              objc_offset(object,WND_INFO_SCROLL,&deltx,&delty);
              if (wgrect.g_w<old_wgrect.g_w)
                 {deltgrect.g_x = deltx + object[WND_INFO_SCROLL].ob_width;
                  deltgrect.g_y = wgrect.g_y;
                  deltgrect.g_w = wgrect.g_x + wgrect.g_w - deltgrect.g_x;
                  deltgrect.g_h = wgrect.g_h;
                  SendGrectRedrawMessage( Windtab[w_ind].w_h, &deltgrect);
                  ExeAllMessage();                  
                 }                
                 
              if (wgrect.g_h<old_wgrect.g_h)
                 {deltgrect.g_x = wgrect.g_x;
                  deltgrect.g_y = delty + object[WND_INFO_SCROLL].ob_height;
                  deltgrect.g_w = wgrect.g_w;
                  deltgrect.g_h = wgrect.g_y + wgrect.g_h - deltgrect.g_y; 
                  SendGrectRedrawMessage( Windtab[w_ind].w_h, &deltgrect);
                  ExeAllMessage(); 
                 }                 
             }
             break;   
             
        case WM_MOVED:
             /**************************************************************/              
             /*........................ WM_MOVED (GEM message).............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de place de la fenetre. En gnral aprs     */
             /* dplacement de la barre de titre ou d'une poignee de       */
             /* dplacement.                                               */
             /* Les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */
             /* EAZY_GEM met  votre service une fonction s'occupant de    */
             /* tout: OnWm_moved()                                         */                   
             OnWm_moved(w_ind, Evnt);
             break;   
             
        case WM_FULLED: 
             /**************************************************************/              
             /*........................ WM_FULLED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* plein ecran (FULLER), ou lors d'une demande logicielle.    */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */
             /* EAZY_GEM met  votre service une fonction s'occupant de    */
             /* tout: OnWm_fulled()                                        */     
             OnWm_fulled( w_ind, Evnt);  
             break;  
        
        case VA_START:          /*  (XGEM message)   */          
             /**************************************************************/              
             /*........................ VA_START (GEM message).............*/                    
             /* Le message VA_START est envoy par une autre application   */           
             /* pour demander  la notre de s'activer (il faut bien sur    */
             /* qu'elle ait ete auparavant ete chargee en memoire)         */
             /* exemple dans un systeme multitache notre application est   */
             /* en sommeil, avec toutes ses fenetres en arriere plan et    */
             /* il lui est demandee de s'activer (en general pour charger  */
             /* un fichier ou toute autre chose)                           */
             /* Exemple on a double clique sur un fichier lie  notre appli*/
             /* a partir du bureau, ou on a pose un fichier sur notre appli*/
             /* ou tout simplement double clique sur l'icone de notre appli*/
             /* sans fichier ou ...                                        */             
             {char *va_txt; 
             int msgbuf[4];
             int i;
             
             object=dlg->tree;
             va_txt = (char*) (*(long*)&Evnt->pipe[3]);
             strcpy(PathTxt,va_txt); /* noter le path et nom que VA_START  envoie  */   
             /*............ renvoyer accus de reception VA_START...................*/
             msgbuf[MESG]=VA_AKCNW;           /*   accuse de reception  VA_START    */
             msgbuf[APPL]=Appl_id;            /*   iddentificateur de l'appelant    */
             msgbuf[SUPL]=0;                  /*   message sans surplus             */
             msgbuf[3]=Evnt->pipe[3];         /*   il faut retourner l'adresse de   */
             msgbuf[4]=Evnt->pipe[4];         /*   la chaine c'est comme a !!      */
             appl_write(Evnt->pipe[APPL], 16, msgbuf );  /* on envoie le paquet     */
             /*........... exploiter le message VA_START ...........................*/                                             
             PathNomToNomFic(PathTxt,NomTxt); 
             if (*NomTxt)              /* >> SI un nom est fourni charger fichier   */
                {/*........ SI path non fourni (que le nom du fichier) .............*/
                 /*          c'est que le path est celui de l'application !!        */
                 /*          alors prendre celui de l'application                   */
                 /*          SINON utiliser celui fourni                            */
                 if (*PathTxt==0) GetPathAppli(PathTxt, NomAppli, 0L);                   
                 strcpy(Windtab[w_ind].titre,PathTxt);
                 strcat(Windtab[w_ind].titre,NomTxt);
                 if (Windtab[w_ind].w_attr & NAME) wind_set( w_h, WF_NAME, Windtab[w_ind].titre);  
                 /*............ charger la ressource ...............................*/
                 
                 ActiveWindow(W_LISEZ, SMALLER|CLOSER|NAME|MOVER|XMOVER|BORDER|XSIZER|FULLER, 
                              "LISEZMOI",
                              WindProcLisezmoi); 
                              
                 ChangeScrollTexte(object, WND_INFO_SCROLL, PathTxt, NomTxt);    
                  
                 
                 VascHeightAdjust(object, WND_INFO_SCROLL, WND_INFO_BAR);      
                 object[WND_INFO_ASC].ob_y = VascPosAdjust(object, WND_INFO_SCROLL, WND_INFO_BAR);          
                 SendObjectRedraw(w_h, object, WND_INFO_BAR);   
                 SendObjectRedraw(w_h, object, WND_INFO_SCROLL);
                }  
                /*............ SI chaine VA_START vide c'est que l'on ................*/
                /*          a double clique sur l'icone du programme                  */
                /*          sans fichier donc activer notre programme                 */
                /*          en mettant par exemple nos fenetres au TOP (premier plan) */
                /*          et en activant notre menu                                 */ 
             else                             
                {for (i=0; i<MAX_WIND; i++) /* activer nos fenetres si elles existent */
                     {if (Windtab[i].w_flag & W_IS_ICON || 
				                  Windtab[i].w_flag & W_IS_ALLICON
			                   )
			                   {UnconifyWindow(i); 
			                   }			                   
                      else if (Windtab[i].w_h>-1) wind_set(Windtab[i].w_h,WF_TOP);
                     }                                      
               }
             }      /* end case VA START   */     
             break;                                                                                                    
       } /* end switch message     */
    } /* end if Evnt & MU_MESSAG  */      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}


/*----------------------- ChangeScrollTexte --------------------------------------*/
char *ChangeScrollTexte(OBJECT *object, int ind, char *PathTxt, char *NomTxt)

{SCROLL_TXT_PRM *scrlprm, scrltxtprm;
 XSCROLLBLK *scrollboxblk;
 int f_h;
 char *adr_txt;
 int nb_lgn;
 long len_fic;
 
len_fic = Fic_exist(PathTxt, NomTxt);
if (len_fic>0)  
   {scrollboxblk = (XSCROLLBLK*) object[ind].ob_spec.userblk->ub_parm;   
    scrlprm = scrollboxblk->ScrollBoxParam;
    scrltxtprm = *scrlprm;  /* sauver les parametres */
    /*............ effacer de la memoire l'ancien texte ...........*/
    if (scrlprm)
       {switch (scrlprm->Type)
          {case SCROLL_TXT:
             free(scrlprm->PtLgnTab);
             free(scrlprm);
             scrollboxblk->ScrollBoxParam = 0L;
             break;
          } /* endswitch  */ 
       }     
    /*............ charger le nouveau texte ......................*/ 
    adr_txt = malloc(len_fic + sizeof(SCROLL_TXT_PRM) + 2 );
    if (adr_txt)
       {char path[512];
        strcpy(path,PathTxt);
        strcat(path,NomTxt);
        f_h = open(path ,O_RDONLY); /* ouvrir fichier  */
        if (f_h>-1)
           {read(f_h, adr_txt + sizeof(SCROLL_TXT_PRM), len_fic);
            scrlprm = (SCROLL_TXT_PRM*)adr_txt;
            scrlprm->txt   = adr_txt + sizeof(SCROLL_TXT_PRM);
            scrlprm->txt[len_fic] = 0;
            nb_lgn = GetTxtNbLigne(scrlprm->txt);
            scrlprm->PtLgnTab = malloc( (nb_lgn+2) * sizeof(char*));
            if (scrlprm->PtLgnTab) 
               {InitTxtLgnPtr(scrlprm->txt,scrlprm->PtLgnTab);                                 
                scrollboxblk->ScrollBoxParam = scrlprm; 
                scrollboxblk->NbLgn = nb_lgn;
                   
                scrlprm->Color  = scrltxtprm.Color;
                scrlprm->Type   = SCROLL_TXT;
                scrlprm->FontId = scrltxtprm.FontId;
                scrlprm->Pts    = scrltxtprm.Pts;
               }
            else 
               {free(adr_txt);
                adr_txt = 0;                               
               }   
            close(f_h);    
           } /* endif if (f_h)   */
        else
           {free(adr_txt);
            adr_txt = 0;
           }    
       } /* endif if (adr_txt)  */  
    } /* endif if len_fic   */  
 return adr_txt;         
}

/*------------------------------ WindProcInfo ---------------------------*/
/* Affiche la boite d'information du programme                           */        
CALLBACK WindProcInfo(int w_ind, EVNT_O *Evnt)
{int w_h;              /* handle de la fenetre de cette Wind_proc_xxx    */
 int wh_top;           /* handle de la fenetre en avant plan             */
 DLG_VAR *dlg;       /* structure attachee  chaque ressource en fenetre */
 
 /*.................. INITIALISER LES VARIABLES ....................*/
 dlg = &Windtab[w_ind].DlgVar;
  
 /*.................... recuperer handles ..........................*/    
 wind_get( 0, WF_TOP, &wh_top); /* celui de fenetre avant plan      */
 w_h = Windtab[w_ind].w_h;      /* celui de notre fenetre           */
 
 if (Evnt->evnt & MU_KEYBD && w_h==wh_top)
    {int i;
     char scan;  
     OBJECT *object; 
     GRECT grect;          /* rectangle surface de travail                   */
 
     grect = Windtab[w_ind].GemWorkGrect;  
     object=dlg->tree;
     scan=(char)(Evnt->key>>8); 
     switch(scan)
       {case  80:     /* down */
        case  72:     /* up   */          
          if (Evnt->ksp & (K_RSHIFT|K_LSHIFT))  
             {GetScrollBoxParam(object,LIS_INFO_SCROLL,0L,0L,0L,0L,0L,0L,0L,0L,0L,&i);
              if (scan!=80) i=-i;
              DoScrollBoxSlide (object, LIS_INFO_SCROLL,i,0,&grect);
              object[LIS_INFO_ASC].ob_y = VascPosAdjust(object, LIS_INFO_SCROLL, LIS_INFO_BAR); 
              Xobjc_draw(object, LIS_INFO_BAR, 1, &grect);                                     
             }
          else if (dlg->LstAdr  == 0)
             {if (scan==80) i= 1;
              else          i=-1;
              DoScrollBoxSlide (object, WND_INFO_SCROLL,i,0,&grect);
              object[LIS_INFO_ASC].ob_y = VascPosAdjust(object, LIS_INFO_SCROLL, LIS_INFO_BAR); 
              Xobjc_draw(object, LIS_INFO_BAR, 1, &grect);                                     
             }   
          break;
        case 71:     /* clr home  */
          if (Evnt->ksp & (K_RSHIFT|K_LSHIFT))
             {int nblt,    /* nbr de lignes total document                 */
                  nb_l;    /* nbr de lignes affichables par la scroll box  */
              GetScrollBoxParam (object, LIS_INFO_SCROLL,0L,0L,&nblt,0L,0L,0L,0L,0L,0L,&nb_l); 
              SetScrollBoxParam (object, LIS_INFO_SCROLL,-2,-2,-2,-2,nblt-nb_l,-2,-2,-2,(void*)-2L,-2);  
             }
          else
             {SetScrollBoxParam (object, WND_INFO_SCROLL,-2,-2,-2,-2,0,-2,-2,-2,(void*)-2L,-2); 
             }
          object[LIS_INFO_ASC].ob_y = VascPosAdjust(object, LIS_INFO_SCROLL, WND_INFO_BAR); 
          Xobjc_draw(object, LIS_INFO_BAR, 1, &grect);  
          Xobjc_draw(object, LIS_INFO_SCROLL, 1, &grect);
          break;             
       } /*end switch scan  */                        
    }
    
 if (Evnt->evnt & MU_BUTTON )
    {int ob_ret;
     ob_ret = Xform_button(w_ind, Evnt);  
     if (ob_ret == LIS_INFO_SCROLL)
        {Evnt->evnt &= ~MU_BUTTON;   /* empecher propagation message  MU_BUTTON */
         /*............. si objet exit selectionne ...................*/
         dlg->tree[ob_ret&0x7FFF].ob_state &= ~SELECTED; 
         SendWindMessage(w_h, WM_CLOSED, 0L);        
        }     
    } /* endif MU_BUTTON  et fenetre au premier plan */

 if (Evnt->evnt & MU_TIMER && w_h==wh_top)  
    {Xform_timer(w_ind);    
    }
 if (Evnt->evnt & MU_MOVE)   
    {Xform_mu_move(w_ind, Evnt);
    }      
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {case WM_CONSTRUCT:
             dlg->AdrRsc = LoadAppliRsc( "LIS_INFO.RSC", NO_SCALE);  
             if ( dlg->AdrRsc )                                                              
                {dlg->type     = RSC_DIAL;   /* type de structure passee en entree */ 
                 dlg->NumTree  = 0;
                 Xform_construct(w_ind, Evnt);                    
                 /*........... placer le tout sous la souris ..............*/
                 AdjustWindCoordToScreen (w_ind, Evnt, (GRECT*)&Evnt->pipe[X_B]); 
                }                  
             else
                {return WM_ABORT;
                }                
             break;
                                         
        case WM_DESTRUCT:       /*  (EZGEM message)   */
             Xform_Destruct(w_ind, Evnt);    
             RscFicUnLoad(dlg->AdrRsc);                
             break;            
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             SetBulleState(w_h, dlg->tree);
             break;                                   
        case WM_REDRAW:               
             Lister_rectangles(w_h,(GRECT*)&Evnt->pipe[X_G]);                          
             break;    
        case WM_BOTTOM:
             wind_set(w_h, WF_BOTTOM );             
             break;                               
        case WM_TOPPED:
             wind_set(w_h, WF_TOP );             
             break;
        case WM_CLOSED:
             DestroyWindow(w_h);
             break;
        case WM_ALLICONIFY:    
             AllIconify(0L);
             break;     
        case WM_ICONIFY:
             IconifyWindow(w_ind, 0L);
             break;                                                    
        case WM_UNICONIFY:
             UnconifyWindow(w_ind);            
             break;                                        
        case WM_SIZED:    
        case WM_MOVED:
             Xform_moved(w_ind, Evnt);                                     
             break;                                                                                     
       }
    }      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}


/*---------------------- AdaptListBoxToWindHeight -----------------------*/
void AdaptListBoxToWindHeight(int w_ind,int ob_list, int mincases, GRECT *ext_grect)
{GRECT wgrect;
 DLG_VAR *dlg;
 int i,oby0,oby,h_lign,nbcases,nbitem,first;
 dlg = &Windtab[w_ind].DlgVar;
/*.............. Adapter hauteur des LISTBOX ..............................*/
 WindGemBorderToEZWork(Windtab[w_ind].w_attr, ext_grect, &wgrect);
 objc_offset(dlg->tree,ob_list,&i,&oby);   /* recuperer position y de la list box   */
 objc_offset(dlg->tree,0,&i,&oby0);        /* recuperer position y de l'objet zero  */
 oby -= oby0;                              /* ofset par rapport espace de travail   */
 
 GetListBoxParam(dlg->tree,ob_list,0,&first,0,&nbitem,&h_lign,0);
 mincases=Min(mincases,nbitem+1);
 oby = wgrect.g_h - oby - 5;  
 nbcases = oby / h_lign;
 nbcases = Max(2,Min(nbcases,mincases));
 first = Min(nbitem-nbcases,first);
 SetListBoxParam(dlg->tree, ob_list,-2,first,nbcases,-2,-2,(void*)-2);
}


/*-------------------------- ActiveWindow -------------------------------*/
void ActiveWindow(int ident, long attr, char *title, CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt))
{int w_ind;
 w_ind = IsWindExist(ident);
 if (w_ind==-1)                 /* << SI existe pas la creer         */
    {CreateWindow(attr, ident,0L,w_proc, 0,20+((Ecran_h-20)>>1),Ecran_l,(Ecran_h-20)>>1, title);
    }
 else                           /* << SI elle existe                  */
    {if (Windtab[w_ind].w_flag & W_IS_ICON || 
				 Windtab[w_ind].w_flag & W_IS_ALLICON
			  )
			  {UnconifyWindow(w_ind); 
			  }
     else if (IsWindOpen(w_ind))     /*        SI ouverte la mettre au top */
        {wind_set(Windtab[w_ind].w_h,WF_TOP);
        }
     else                       /*        SI pas ouverte l'ouvrir     */
        {OpenWindow(w_ind, &Windtab[w_ind].ExtGrectUse);
        } 
    } 
}
