/*/////////////////////////////////////////////////////////////////////*/
/* EXEMPLE d'utilisation et de creation d'un programme utilisant les   */
/*                         fonctions EZ_GEM                            */
/* Ce module est celui comportant la fonction main et donc c'est le    */
/* point d'entree du programme                                         */
/* Dans cet exemple je charge une ressource type EZ_GEM (ou autre)     */
/*                  ou j'ai mis toutes les nouveautes de gestion       */
/*                  etendues de ressources                             */
/*                  j'installe un menu GEM                             */
/*                  j'ouvre une fenetre bidon affichant les evenements */
/* Vous pourrez voir qu'il est possible de gerer plusieurs fichiers de */
/* ressources en meme temps, de les charger et liberer dynamiquement!! */
/*/////////////////////////////////////////////////////////////////////*/
/*////////////////////////// I N C L U D E S //////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
/*--------------------- INCLUDES DES AUTRES MODULES DU PROGRAMME ------*/
#include "EAZY_GEM.H"  /* inclure les definitions des fonctions que le */
                       /* que le module EAZY_GEM.C met  notre         */
                       /* notre disposition                            */ 
                       /* et inclure les definitions des variables     */
                       /* globales  EAZY_GEM                           */
/*.............. inclure les definitions qu'interface .................*/
/*                   cree pour les objets ressource                    */                       
#include "WND_PROC.RSC\WND_MENU.H"
#include "WND_PROC.RSC\WND_PRM.H"
#include "WND_PROC.RSC\TOOL_BAR.H" 
#include "WND_PROC.RSC\FREDE.H"
#include "WND_PROC.RSC\WND_INFO.H"
#include "ALERTICN.H"
/*/////////////////////////////////////////////////////////////////////*/
/*////////////////////////// D E F I N E S  ///////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/   
/* ici je mets tous les defines concernant ce module                   */
#define W_BIDON      1      /* ID Fenetre bidon                        */
#define RESSOURCE    2      /* ID Fenetre ressource                    */
#define W_PARAM      3      /* ID Fenetre parametrage                  */
#define W_ONGLET     4      /* ID Fenetre d'onglets                    */
#define W_INFO       5      /* ID fenetre information                  */
/*/////////////////////////////////////////////////////////////////////*/
/*////////////// V A R I A B L E S    G L O B A L E S /////////////////*/
/*/////////////////////////////////////////////////////////////////////*/

/* declarer ici les variables globales du programme                    */
  
void *AdrRscMenu=0;        /* adr. ou je chargerai le Menu             */
void *AdrRscDial=0;        /* adr. ou je chargerai la rsc dialogue     */
char PathVABuff[256];      /* buffer pour nom path AV_START            */
char PathAppli[256];       /* stockera le path de demarrage            */
char PathDial[256];
char NomDial[14]="DIAL_EXP.RSC";

char InfoClick       = 0;  /* informer si click sur objet              */   
static MemTimer      = 0;
/*............. Declarer le nom de notre programme ....................*/

/*/////////////////////////////////////////////////////////////////////*/
/*/////////////// P R O T O T Y P E S  F O N C T I O N S //////////////*/
/*/////////////////////////////////////////////////////////////////////*/

/* declarer ici les fonctions du programme                             */
/*......... procedures specifiques  un programme EZ_GEM ..............*/

void main (int argc, const char *argv[], const char *envp[]);
static CALLBACK MessageProcedure(int w_ind, EVNT_O *Evnt);
static int MenuProcedure(int w_ind, EVNT_O *Evnt);
static CALLBACK WindProcDialogue(int w_ind, EVNT_O *Evnt);
static CALLBACK WindProcBidon(int w_ind, EVNT_O *Evnt);
static CALLBACK WindProcParam(int w_ind, EVNT_O *Evnt);
static CALLBACK WindProcOnglet(int w_ind, EVNT_O *Evnt);
static CALLBACK WindProcInfo(int w_ind, EVNT_O *Evnt);
/*...... procedures non specifiques  un programme EZ_GEM .............*/
static int MaFonctionColorList (LIST_GET_TXT *ptLISTGETTXT);
static void AdaptListBoxToWindHeight(int w_ind,int ob_list, int mincases, GRECT *ext_grect);
static char *MakeStrInfoOb(void* adr_rsc, int num_tree, int num_ob, char *sztt_txt);
int NumFuncToIndObject(OBJECT* object, int num_func);
int FindTitlePopup(OBJECT *object);
int FindSousMenu(void *AdrRscTool, char *name);
int IsThisObjectExecutive(OBJECT *object, int ind);
void ActiveWindow(int ident, long attr, char *title, CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt));
/*//////////////////////////////////////////////////////////////////////*/
/*                A   C O M M E N C E   I C I   !!!!                   */
/*              Definition des fonctions de ce module                   */
/*//////////////////////////////////////////////////////////////////////*/

/*---------------------------- main ------------------------------------*/
/* premiere fonction appelee, c'est le point d'entree du programme      */ 
void main (int argc, const char *argv[], const char *envp[])
{char path[256];
 OBJECT *object;
 int i;
 /*..... utiliser variables d'entree pour calmer le compil ....*/
 argc++; 
 i=*envp[0];
 i=*argv[0];
 i++;
 /*........ Appeler la fonction: InitEazyGem avant toute utilisation......*/
 /*         des fabuleuses possibilites offertes par EZ_GEM               */
 /* Elle declare notre programme  EZ_GEM,                                */
 /* Initialise l'application et son identificateur GEM: Appl_id,          */
 /* Ouvre une station de travail VDI dont le handle est: VDIhandle,       */
 /* initialise tout un tas de variables globales ncessaires  EAZY_GEM   */  
 MAX_WIND = 5;      
 if (InitEazyGem("WND_PROC.PRG") != -1)   
    {/*........Noter chemin d'ou a ete lance le programme .....*/
     /*        et envoyer un message VA_START si le            */
     /*     programme est demarre avec un nom de fichier       */
     /*         de faon  demarrer avec ce fichier            */
     if (GetPathAppli(PathAppli, NomAppli, PathVABuff))
        {Send_VA_START(Appl_id, PathVABuff);            
        }
     /*................. Charger le Menu GEM .................*/          
     /*       les autres ressources  seront charges          */
     /*         ulterieurement selon les besoins              */
     /*        cette faon de faire n'tant pas obligatoire.  */ 
     if (FindFicSys(path, NomAppli,"WND_MENU.RSC")>0)
        {AdrRscMenu = RscFicLoad(path, "WND_MENU.RSC", SCALE);
         if (AdrRscMenu)  
            {xrsrc_gaddr (R_TREE, 0, &object, AdrRscMenu);
             menu_bar(object,1);      /* installer le menu GEM*/
             strcpy(PathDial, path);  /* initialiser sur path */
            }                         /* le menu est trouve   */
        }  
                     
        
         
     /*........... Executer la boucle programme ..............*/     
     /* en parametre je donne le nom de la fonction qui va    */
     /* traiter les messages par defaut. Cela permet de faire */
     /* fonctionner le programme meme si aucune fenetre n'est */
     /* ouverte, et de traiter tous les messages communs au   */
     /* programme au meme endroit.                            */
     /* Si l'on ne veut pas utiliser cette possibilit il faut*/
     /* mettre 0L en parametre d'entree et ouvrir une fenetre */
     /* (avec la procedure de fenetre allant avec) qui gerera */
     /* les messages. Dans ce cas le programme s'arrete lors  */
     /* de la destruction de la derniere fenetre.(faute de    */
     /* fonction de traitement des messages !!)               */
     /* Lorsque cette fonction existe et que des fenetres sont*/
     /* ouvertes, les messages sont d'abord envoys  la      */
     /* fonction, puis ensuite aux fenetres. La fonction peut */
     /* empecher cette transmission aux fenetres en retournant*/
     /* zero. (Les fonctions de fenetres peuvent aussi faire  */
     /* de meme). Cette possibilit permet d'eviter qu'un     */
     /* message inutile aux autres fonctions de fenetre soit  */
     /* transmis.                                             */
     
     BouclePrincipale(MessageProcedure); 
     
     /*.............. liberer les ressources .................*/   
     RscFicUnLoad(AdrRscDial); /* de la boite de dialogue     */ 
     if (AdrRscMenu)           /* du menu GEM                 */
        {xrsrc_gaddr (R_TREE, 0, &object, AdrRscMenu);
         menu_bar(object,0);          
         RscFicUnLoad(AdrRscMenu); 
        }      
    }
 /*........ indispensable appel pour finir un programme ......*/
 /*             EZ_GEM proprement                             */ 
 ExitEasyGem();   
}

/*------------------------ MessageProcedure ------------------------------*/
/* ACTION: cette procedure est chargee de gerer les evenements message.   */
/*         Cette gestion peut se faire aussi au niveau de chaque fenetre  */
/*         auquelles sont transmises les evenements message.              */
/*         Cette procedure reoit les messages en premier avant les       */
/*         procedures de fenetre.                                         */
/*         il est possible d'empecher la transmission du message aux      */
/*         procedures de fenetre, en retournant zero.                     */
/*         Cette procedure est utile pour traiter les messages communs   */
/*         toute l'application meme si aucune fenetre n'est ouverte       */
/*         c'est en quelque sorte une procedure de traitement par defaut  */

static CALLBACK MessageProcedure(int w_ind, EVNT_O *Evnt)
{
 /*.............. les variables locales suivantes sont souvent ..........*/
 /*           utiles pour toutes les fonctions de fenetre EZGEM pour:    */
 /* GRECT grect; */          /* rectangle surface de travail                   */
 /* int w_h;     */          /* handle de la fenetre de cette Wind_proc_xxx    */
 /* int wh_top;  */          /* handle de la fenetre en avant plan             */
 /* VRECT clip;  */          /* rectangle de traage (type VDI) pas ici!!      */
 /*.............. les variables locales suivantes sont  .................*/
 /*                  specifiques  notre application                     */ 
 int msgbuf[8];
 char *va_txt;
 int ind;
 int i; 
 DLG_VAR dlg;
 OBJECT *object;
 char alert_str[256];
 char buft[32];
 /*.................. INITIALISER LES VARIABLES ....................*/
 /*.................... recuperer handles ..........................*/    
 /* wind_get( 0, WF_TOP, &wh_top); */ /* celui de fenetre avant plan      */
 /* w_h = Windtab[w_ind].w_h;      */ /* celui de notre fenetre           */
 /* GetWindWorkGRECT(w_h, &grect); */ /* recuperer espace de travail      */      
 w_ind++;   /* utiliser cette variable pour calmer le compil              */
 
 if (Evnt->evnt & MU_KEYBD)
    {char car;
     car = (char) ScanToAscii(Evnt->key, Evnt->ksp);
     if (Evnt->ksp & K_CTRL)
        {car|=' ';
         switch (car|' ')
           {case 'i':  msgbuf[4]=INFORMATION ;  
                       msgbuf[3]=TITLE_BUREAU;   
                       car = 0; 
                       break;
            case 'q':  msgbuf[4]=QUITTER ;  
                       msgbuf[3]=TITLE_FICHIER;   
                       car = 0; 
                       break; 
            case 'l':  msgbuf[4]=OUVRIR_DIALOGUE; 
                       msgbuf[3]=TITLE_FICHIER;
                       car = 0;
                       break;              
            case '+':  msgbuf[4]=SUIVANT ;  
                       msgbuf[3]=TITLE_FENETRE; 
                       car = 0;    
                       break;              
            case '-':  msgbuf[4]=PRECEDENT ; 
                       msgbuf[3]=TITLE_FENETRE;
                       car = 0;        
                       break;  
             
           }
         if (car==0)                 
            {xrsrc_gaddr (R_TREE, 0, &object, AdrRscMenu);
             msgbuf[MESG]=MN_SELECTED;         /*   accuse de reception  MENU CLIQUE */
             msgbuf[APPL]=Appl_id;             /*   iddentificateur de l'appelant    */
             msgbuf[SUPL]=0;                   /*   message sans surplus             */
             menu_tnormal( object, msgbuf[3],0);    
             appl_write(Appl_id, 16, msgbuf );  /* on envoie le paquet     */
             Evnt->evnt &= ~MU_KEYBD;   /*  annuler evenement clavier */
            } 
        } /* end switch */                                      
    } 
 if (Evnt->evnt & MU_TIMER)            
    {
      MemTimer++;
      /*
      if (MemTimer>10) 
         {char buft[32]; 
          Clip_p(1,1,Ecran_l,20);        
          vst_font(VDIhandle,1);
          vst_color(VDIhandle,1);
          vst_point(VDIhandle,13, &i, &i, &i, &i);
          vst_effects(VDIhandle,0);
          vswr_mode(VDIhandle,MD_REPLACE);
          vst_alignment (VDIhandle,0,ALI_TOP, &i, &i ); 
          v_gtext(VDIhandle,Ecran_l - 100,2,ltoa((long)Malloc(-1),buft,10));
          MemTimer=0;
         }
     */    
    }     
 if (Evnt->evnt & MU_MESAG) 
    {switch (Evnt->pipe[MESG])
       {case WM_TOPPED: 
             /**************************************************************/              
             /*........................ WM_TOPPED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre en premier plan. Il convient   */
             /* Je traite ce message ici pour mettre le menu GEM au        */
             /* premier plan chaque fois, qu'une fenetre de l'application  */
             /* est topee.                                                 */
             if (AdrRscMenu)            /* si menu charge l'activer        */
                {xrsrc_gaddr (R_TREE, 0, &object, AdrRscMenu);
                 menu_bar(object,1);                       
                }
             break;  
             
        case AP_DRAGDROP:
             /**************************************************************/              
             /*........................ AP_DRAGDROP (GEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* un truc a t drag (tir) sur sa fenetre.                 */
             /* Ici je verifie si c'est une liste de fichiers, et si c'est */
             /* le cas je lance un message VA_START pour le charger.       */
             if (GetDragDropList(Evnt,PathVABuff+1,sizeof(PathVABuff)))
				        {*PathVABuff='';
				         Send_VA_START(Appl_id, PathVABuff);
				        }
				     break;   
				       
        case MN_SELECTED:
             /**************************************************************/              
             /*...................... MN_SELECTED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* une entree du menu deroulant est clique.                  */  
             /*......... recuperer adresse premier objet du menu ..........*/ 
             /* xrsrc_gaddr (R_TREE, 0, &object, AdrRscMenu);              */
             /* menu_tnormal( object, Evnt->pipe[3],1);                    */
             /* en Evnt->pipe[4] se trouve le numero de l'item selectionn */
             /*........... j'ai prefere traiter tous les messages .........*/
             /*            du menu GEM a part, mais il est possible        */
             /*            de les traiter ici                              */
             MenuProcedure(w_ind, Evnt);             
             break;
             
        case AP_TERM:
             /**************************************************************/              
             /*........................ AP_TERM (GEM message)..............*/
             /* Ce message est envoy  l'application lorsqu'il lui est    */
             /* demande de s'arreter (exemple lorsque il y a changement   */
             /* rsolution). Il est d'usage de quitter sans demande de     */
             /* comfirmation. Faites les sauvegardes ncessaires avant de  */
             /* quitter. Et quittez.                                       */
             /* Ici je mets la variable: EZGemRun  -1, de faon  ce      */
             /* que le programme s'arrete sans demande de confirmation.    */
             EZGemRun=-1;           /* sortir sans demande de confirmation */
             break;
             
        case VA_START:          /*  (XGEM message)   */  
             {char first_car;   
             /**************************************************************/              
             /*........................ VA_START (GEM message).............*/                    
             /* Le message VA_START est envoy par une autre application   */           
             /* pour demander  la notre de s'activer (il faut bien sur    */
             /* qu'elle ait ete auparavant ete chargee en memoire)         */
             /* exemple dans un systeme multitache notre application est   */
             /* en sommeil, avec toutes ses fenetres en arriere plan et    */
             /* il lui est demandee de s'activer (en general pour charger  */
             /* un fichier ou toute autre chose)                           */
             /* Exemple on a double clique sur un fichier lie  notre appli*/
             /* a partir du bureau, ou on a pose un fichier sur notre appli*/
             /* ou tout simplement double clique sur l'icone de notre appli*/
             /* sans fichier ou ...                                        */
             /*.............. recuperer adresse de la chaine ..............*/
             /*           de caracteres que le message VA_START            */
             /*                        nous envoie                         */ 
             first_car = *(char*) (*(long*)&Evnt->pipe[3]);
                
             /*............ renvoyer accus de reception VA_START...................*/
             /*             au message (il faut le faire c'est plus poli)           */
             msgbuf[MESG]=VA_AKCNW;           /*   accuse de reception  VA_START    */
             msgbuf[APPL]=Appl_id;            /*   iddentificateur de l'appelant    */
             msgbuf[SUPL]=0;                  /*   message sans surplus             */
             msgbuf[3]=Evnt->pipe[3];         /*   il faut retourner l'adresse de   */
             msgbuf[4]=Evnt->pipe[4];         /*   la chaine c'est comme a !!      */
             appl_write(Evnt->pipe[APPL], 16, msgbuf );  /* on envoie le paquet     */
             /*............... corriger path selon premier car .....................*/
             if (first_car == '')  /* si VA_START provient de Drag&Drop            */          
                 va_txt = 1 + (char*) (*(long*)&Evnt->pipe[3]); 
             else                   /* si VA_START provient d'ailleurs              */
                 va_txt = (char*) (*(long*)&Evnt->pipe[3]);  
             /*........... exploiter le message VA_START ...........................*/
             /*            ici notre programme etant un mini viewer                 */
             /*            de ressources EAZY_GEM on suppose que c'est le           */
             /*            nom du fichier ressource devant etre affiche             */
             /*            qui nous est envoye dans la chaine de VA_START           */
             strcpy(PathDial,va_txt); /* noter le path et nom que VA_START  envoie  */                                  
             /*.......... separer nom du fichier et path ...........................*/
             PathNomToNomFic(PathDial,NomDial); 
             if (*NomDial)              /* >> SI un nom est fourni charger fichier  */
                {/*........ SI path non fourni (que le nom du fichier) .............*/
                /*          c'est que le path est celui de l'application !!         */
                /*          alors prendre celui de l'application                    */
                /*          SINON utiliser celui fourni                             
                 if (*PathDial==0) strcpy(PathDial,PathAppli);   
                /*........... La boite d'alerte suivante permet ....................*/
                /*  de choisir l'echelle avec laquelle doit etre chargee  notre     */
                /*  notre ressource. En effet EZ_GEM permet de charger une          */
                /*  ressource sous la forme classique (SCALE) ou sous la forme mini */     
                /*  (NO_SCALE) qui affiche la ressource de la meme faon qu'en      */
                /*  basse resolution. INTERET la ressource est idem pour toutes les */
                /*  resolutions (qu'un seul fichier  grer) et occupe moins de     */
                /*  place  l'ecran en haute resolution. CONTRAINTE: il faut la     */
                /*  definir avec le mode grille caractere active dans l'editeur de  */
                /*  ressource. On s'y fait c'est une question d'habitudes           */
                
                 strcpy(alert_str,"[2][Afficher la ressource:|");
                 strcat(alert_str,PathDial);
                 strcat(alert_str,"|");
                 strcat(alert_str,NomDial); 
                 strcat(alert_str,"| l'echelle Standard du GEM ?][Oui|Non|Annuler]"); 
                 if (first_car == '')  /* si VA_START provient de Drag&Drop            */
                    i=1;                /* alors afficher echelle GEM standard          */
                 else                   /* Sinon demander choix de l'echelle            */
                    i = form_alert( 2,alert_str);
                 /*............ charger la ressource ...............................*/
                 if (i<3 && Fic_exist(PathDial, NomDial)>0)          /* annuler = 3 */
                    {long attr;
                     ind = IdentToIndice(RESSOURCE); /* Si fenetre ressource  deja  */
                     if (ind<MAX_WIND)               /* ouverte la fermer avant     */
                        {DestroyWindow(Windtab[ind].w_h);
                        }
                     /*....... avant chargement effacer ressource (on sait jamais).. */   
                     RscFicUnLoad(AdrRscDial);         
                     if (i==1)               /* mettre  l'echelle standard du GEM   */
                        AdrRscDial = RscFicLoad(PathDial, NomDial, SCALE); 
                     else                    /* mettre  l'echelle mini EZ_GEM       */
                        AdrRscDial = RscFicLoad(PathDial, NomDial, NO_SCALE); 
                     /*......... La fonction CreateWindow doit etre appelee .........*/
                     /*            avec l'adresse d'une structure  DLG_VAR           */
                     /*            initialisee de la faon suivante pour que la      */
                     /*            la fenetre puisse afficher  et gerer correctement */
                     /*            une ressource en fenetre.                         */          
                     dlg.type    = RSC_DIAL;   /* type de structure passee en entree */ 
                     dlg.AdrRsc  = AdrRscDial; /* adresse de chargement  ressource   */
                     dlg.NumTree = 0;          /* numero de l'arbre de la ressource  */
                     /*........... construire le titre de la fenetre ................*/
                     /*                   et ouvrir la fenetre                       */
                     strcpy(alert_str,NomDial);    /* alert_str est utilise comme    */  
                     strcat(alert_str," Arbre:");  /* buffer provisoire pour le nom  */
                     strcat(alert_str,itoa(dlg.NumTree,buft,10)); /* numero arbre    */ 
                     /*...........attributs d'ouverture GEM + EZGEM ................ */
                     /* l'attribut BORDER dans le cas d'une fenetre ressource ajoute */                     
                     /* le dessin d'un cadre en relief autour de la fenetre          */
                     /* l'attribut XMOVER dans le cas d'une fenetre ressource ajoute */
                     /* une poigne de dplacement sur le bord sup de la fenetre     */
                     /* attr=NAME|CLOSER|FULLER|MOVER|BORDER; */
                     attr=BORDER|NAME|XMOVER|MOVER|SMALLER;
                     CreateWindow( attr, RESSOURCE, &dlg, WindProcDialogue, 0,0,0,0, alert_str);
                    } 
                }  
                /*............ SI chaine VA_START vide c'est que l'on ................*/
                /*          a double clique sur l'icone du programme                  */
                /*          sans fichier donc activer notre programme                 */
                /*          en mettant par exemple nos fenetres au TOP (premier plan) */
                /*          et en activant notre menu                                 */ 
             else                             
                {for (i=0; i<MAX_WIND; i++) /* activer nos fenetres si elles existent */
                     {
                      if (Windtab[i].w_h>-1) wind_set(Windtab[i].w_h,WF_TOP);
                     }                     
                 if (AdrRscMenu)            /* si menu charge l'activer               */
                    {xrsrc_gaddr (R_TREE, 0, &object, AdrRscMenu);
                     menu_bar(object,1);                       
                    }
               }
             }      
             break;                                                  
       }                                              
    }
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */         
 /* return 0;  */          /* empecher transmission message menu      */
}

/*------------------------ MenuProcedure ------------------------------*/
/* ACTION: cette procedure est chargee de gerer les evenements du menu */
/*         droulant. Cette gestion peut se faire aussi au niveau de   */
/*         chaque fenetre auquelles sont transmises les evenements menu*/
/*         On peut aussi la faire au niveau de la procedure:           */
/*         MessageProcedure. Faites un peu comme vous voulez !!        */
/*         il est possible d'empecher la transmission du message de    */
/*         menu, aux procedures de fenetre, en retournant zero         */
int MenuProcedure(int w_ind, EVNT_O *Evnt)
{
 /*.............. les variables locales suivantes sont souvent ..........*/
 /*           utiles pour toutes les fonctions de fenetre EZGEM pour:    */
 /* GRECT grect; */          /* rectangle surface de travail                   */
 /* int w_h;     */          /* handle de la fenetre de cette Wind_proc_xxx    */
 /* int wh_top;  */          /* handle de la fenetre en avant plan             */
 /* VRECT clip;  */          /* rectangle de traage (type VDI) pas ici!!      */
 /*.............. variables locales specifiques  notre .................*/
 /*               exemple:                                               */
 OBJECT *object;     /* pointeur d'objet pour les ressources             */ 
 int ind;
 DLG_VAR dlg;
 DLG_VAR *dlg_w;
 RSXHDR *rsx_hdr;
 char path[256];
 char buft[32];
 /*.................. INITIALISER LES VARIABLES ....................*/
 /*.................... recuperer handles ..........................*/    
 /* wind_get( 0, WF_TOP, &wh_top); */ /* celui de fenetre avant plan      */
 /* w_h = Windtab[w_ind].w_h;      */ /* celui de notre fenetre           */
 /* GetWindWorkGRECT(w_h, &grect); */ /* recuperer espace de travail      */      
 w_ind++;   /* utiliser cette variable pour calmer le compil   */   
 /*............... recuperer adresse du menu ..................*/         
 xrsrc_gaddr (R_TREE, 0, &object, AdrRscMenu);   
 /* en Evnt->pipe[4] se trouve le numero de l'item selectionn */
 /* il faut donc orienter l'action en fonction de cet item     */
 /* Lors de la creation de notre ressource menu avec INTERFACE */
 /* un fichier WND_MENU.H a ete cree et comporte tous les      */
 /* #define permettant d'utiliser un nom symbolique plutot que */
 /*         qu'un nombre abstrait                              */
 
 switch (Evnt->pipe[4])                                     
   {/*.......... chargement d'une ressource et affichage ...........*/
    case OUVRIR_DIALOGUE:     
         if (Fic_select (PathDial,NomDial,".RSC","Tester une boite de dialogue")
             >0L
            )
            {/* Une application comprenant le message VA_START doit pouvoir    */
             /* s'activer et charger un document. Je m'envoie donc un message  */
             /* VA_START avec le nom du fichier choisi afin de ne pas avoir   */
             /* m'occuper ici du chargement, et de laisser le soin  la partie */
             /* de programme qui s'en occupe de le faire (celle de VA_START).  */             
             strcpy(PathVABuff,PathDial);
             strcat(PathVABuff,NomDial);
             Send_VA_START(Appl_id, PathVABuff);                           
            }                                                
         break;                                                           
    
    /*................ choisir d'afficher un arbre de menu different ..........*/
    case SUIVANT: 
    case PRECEDENT:
         ind = IdentToIndice(RESSOURCE);         
         if (AdrRscDial && ind < MAX_WIND)  /* si fenetre ressource existe   */
            {long attr;
             dlg_w = &Windtab[ind].DlgVar;
             rsx_hdr   = (RSXHDR*)( (char*)AdrRscDial + sizeof(int)*16 );
             if (Evnt->pipe[4] == SUIVANT)
                 dlg.NumTree = Min( (int) rsx_hdr->rsh_ntree - 1, dlg_w->NumTree + 1); 
             else
                 dlg.NumTree = Max( 0, dlg_w->NumTree - 1); 
             /*........ ouvrir fenetre ...............*/                
             DestroyWindow(Windtab[ind].w_h);             
             dlg.type    = RSC_DIAL;
             dlg.AdrRsc  = AdrRscDial;
             /* attr=NAME|CLOSER|MOVER|BORDER; */
             attr=BORDER|NAME|XMOVER|MOVER|SMALLER;
             strcpy(path,NomDial);
             strcat(path," Arbre:");
             strcat(path,itoa(dlg.NumTree,buft,10));
             CreateWindow( attr, RESSOURCE, &dlg, WindProcDialogue, 0,0,0,0, path);     
            } 
         break; 
               
   case INFO_CLICK:      
        strcpy(path,"[1][Avertir lors click sur objet ?][Non|Oui|Annuler]");
        ind = form_alert(1,path);
        if (ind<3)          /* annuler = 3 */  
           {InfoClick = ind-1;
           }
        break;       
   /*.............. si demande d'ouverture de la fenetre parametrage ...........*/     
   case PRM_FENETRE:
         ActiveWindow(W_PARAM, 
                      BORDER|XMOVER, "Parametrage Fenetre", WindProcParam);      
         break;
    /*.............. si demande d'ouverture de la fenetre bidon .................*/     
    case BIDON: 
         ind = IdentToIndice(W_BIDON);
         if (ind>=MAX_WIND)            /* << SI existe pas la creer           */
            {long attr;
             /* attr = SIZER|SMALLER|CLOSER|NAME|MOVER|XMOVER|BORDER|FULLER; */             
             attr = BORDER|XMOVER|XSIZER;
             CreateWindow(attr, W_BIDON, 0L, WindProcBidon, 10,20,450,340, "Fenetre BIDON");
            }
         else                           /* << SI elle existe                  */
            {if (IsWindOpen(ind))       /*        SI ouverte la mettre au top */
                {wind_set(Windtab[ind].w_h,WF_TOP);
                }
             else                       /*        SI pas ouverte l'ouvrir     */
                {OpenWindow(ind, &Windtab[ind].ExtGrectUse);
                } 
            }     
         break;
    case INFORMATION:
         ActiveWindow(W_INFO, 
                      BORDER|SMALLER|CLOSER|NAME|MOVER|XMOVER, "Information", WindProcInfo);    
         break;     
    case FEN_FREDE:
         ActiveWindow(W_ONGLET, 
                      BORDER|SMALLER|CLOSER|NAME|MOVER|XMOVER, "Fenetre Onglets", WindProcOnglet);
         break;
    /*.............. activer desactiver les bulles d'aide .......................*/     
    case BULLES_ON_OFF:       
         SendMessage(WM_TT_ON_OFF);                                             
         break;

    /*.... trouvez tout seul le commentaire adquat .............................*/     
    case QUITTER:  
         EZGemRun=0;  /* mettre  zero cette variable globale */
                      /* c'est terminer le programme          */                                               
         break;                                                  
   }
 menu_tnormal( object, Evnt->pipe[3],1);        
 return Evnt->pipe[MESG];  /* transmettre message aux autres fenetres */ 
 /* return 0;  */          /* empecher transmission message menu      */
}



/*----------------------- WindProcDialogue ------------------------------*/
/* ''''''CI DESSOUS EXEMPLE D'UNE PROCEDURE DE GESTION DE FENETRE''''''''*/
/*                 ici gestion d'une ressource en fenetre                */
/* ACTION : Procedure de gestion attache  une fenetre.                 */
/* ENTREE : EVNT_O *Evnt pointe sur une structure du type EVNT_O         */
/*              cette structure represente le flux evenementiel.         */
/*          w_ind indice pointant sur la structure rattache  cette     */
/*                fenetre:  Windtab[w_ind]                               */
/*                                                                       */
/* RETOURNE: un int retransmettant l'evenement Evnt->evnt                */
/*           En effet le flux evenementiel doit etre retransmis aux      */
/*           autres fenetres afin qu'elles puissent elles aussi reagir   */
/*           aux evenements.  L'evenement est  transmis en premier       */
/*           toujours   la fenetre du dessus puis  aux autres ensuite.  */
/*           Il est parfois utile d'empecher la transmission du flux     */
/*           aux autres fenetres. Exemple je clique sur la fenetre       */
/*           principale et je ne veux pas que le menu dessous reoive    */
/*           le click, il faut alors faire Evnt->evnt &= ~MU_BUTTON      */  
/*           afin d'enlever l'evenement MU_BUTTON du flux evementiel.    */
/*                                                                       */
/* DIX COMMANDEMENTS CONCERNANT L'UTILISATION D'EAZY GEM:                */
/*          Pour faciliter la gestion du GEM j'ai rajout une sur couche */
/*          analysant toute la messagerie et evenements GEM et dirigeant */
/*          les messages sur chaque procedure de fenetre. En effet je me */
/*          suis inspir d'un truc pas mal dans window, qui est que tout */
/*          ce qui concerne une fenetre est gr par une seule et meme   */
/*          procedure. Cela apparait au debut comme idiot et limitatif   */
/*          mais  l'usage cette faon de faire est hyper efficace.      */
/*          Pour pouvoir  beneficier des facilites offertes par le       */ 
/*          systeme EZ_GEM il convient de suivre quelques regles:        */
/*                                                                       */
/*          1)  Dmarrer par la fonction: InitEazyGem                    */
/*          2)  Utilizez Imperativement la fonction: BouclePrincipale    */
/*              qui est le moteur et noyau principal d'EAZY_GEM.         */
/*              C'est cette fonction qui est chargee de redistribuer     */
/*              sur les procedures de fenetre adequates tout le flux     */
/*              evenementiel, qui gere les bulles d'aide et autres       */           
/*              bricoles.                                                */
/*          3)  Finir par la fonction:    ExitEazyGem                    */
/*          4)  Charger vos ressources avec la fonction: RscFicLoad      */
/*          5)  Utilisez la fonction: xrsrc_gaddr pour acceder aux       */
/*              elements de votre ressource.                             */
/*          7)  Liberer vos ressources avec la fonction: RscFicUnLoad    */
/*          8)  Creez vos fenetres avec la fonction: CreateWindow        */
/*          9)  Detruisez vos fenetres avec la fonction: DestroyWindow   */
/*         10)  Acceder et modifier les textes des objets ressource en   */
/*              utilisant les fonctions: ObjcGetTxt et ObjcSetTxt        */
/*         11)  Ouvrir et Fermer les fenetres avec OpenWindow et         */
/*              CloseWindow                                              */
/*         12)  Redimensionner   les fenetres avec: SetWindowSize        */
/*                                                                       */
/* RAPPEL:                                                               */
/*          Lors de l'ouverture d'une fenetre il faut faire appel  la   */
/*          fonction suivante, qui cree et met en place une fenetre:     */
/*                                                                       */
/*  int  CreateWindow ( long w_attr,                                     */
/*                      int ident,                                       */
/*                      void *adr,                                       */               
/*                      CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt),     */
/*                      int x, int y, int w, int h,                      */
/*                      char *nom                                        */
/*                  )                                                    */
/*  long w_attr: attributs GEM classique d'une fenetre                   */
/*               trois attributs de plus:                                */
/*                         BORDER permet d'avoir un cadre epais en       */
/*                                  relief autour de la fenetre.         */
/*                         XMOVER permet d'avoir une poigne de deplace- */
/*                                ment sur le bord sup du cadre epais    */
/*                         XSIZER permet l'agrandissement de la fenetre  */
/*                                en cliquant sur le cadre epais         */
/*  int Ident:  nbr arbitraire(jamais nul) que vous devez donner. Cela   */
/*              peut servir  reperer tel ou tel type de fenetre dans    */
/*              votre programme. Exemple votre application comporte      */
/*              plusieurs fenetres dont une de menu  laquelle vous      */
/*              donnez int ident=2 chaque fois que vous l'ouvrez.Il est  */
/*              alors facile pour le programme de savoir si la fenetre   */
/*              menu est ouverte en faisant appel  la fonction          */
/*              int IdentToIndice(2); qui vous retourne l'indice de la   */
/*              fenetre (si elle n'existe pas l'indice est >= MAX_WIND ) */
/*  void *adr:  adresse pointant sur diverses choses dependant du type de*/
/*              gestion de la fenetre.                                   */
/*              Le premier mot point par cette adresse doit renseigner  */
/*              sur le type de structure passee dans adr.                */
/*              .............. RESSOURCE EN FENETRE......................*/
/*              Si ce premier mot est: RSC_DIAL                          */
/*                                ou   TOOL_BAR cela signifie que  adr   */
/*              pointe sur une structure de type DLG_VAR, et que la      */
/*              fenetre gerera une ressource. Avant l'appel de           */ 
/*              CreateWindow DLG_VAR.type    doit etre egal a RSC_DIAL.  */
/*                                           ou TOOL_BAR                 */
/*                           DLG_VAR.AdrRsc  doit pointer l'adresse de   */
/*                                           chargement de la ressource. */
/*                           DLG_VAR.NumTree doit etre egal au numero de */
/*                                           l'arbre devant etre gere.   */       
/*                         le reste des donnes de la structure n'est    */
/*                         pas a initialiser (le seront automatiquement) */ 
/*  CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt): L vous donnez le nom   */
/*              fonction qui sera charge de gerer tous les evenements   */
/*              de cette fenetre. Cette fonction sera appelee par la     */
/*              sur couche EAZY_GEM.                                     */
/* int x, int y, int w, int h,: coordonnees en pixels de la fenetre      */
/*              ces coordonnees doivent etre celles du contour exterieur */
/*              de la fenetre et non de la surface de travail            */
/*              si zero en entree alors les dimensions maxi possibles    */
/*              seront choisies.                                         */
/*              Ces dimensions peuvent etre modifiees avant ouverture de */
/*              la fenetre lors du traitement du message WM_CONSTRUCT    */
/*              au sein de la procedure de fenetre.                      */
/* char *nom:   titre de la fenetre                                      */
/*              de meme le titre de la fenetre peut etre modifie au sein */
/*              de la procedure de fenetre lors du traitement du message */
/*              WM_CONTRUCT.                                             */
/*                                                                       */
/*                                                                       */
/*................... description de la structure EVNT_O.................*/
/*  typedef struct                                                       */
/*      {int evnt;        */ /* type d'evenement                         */
/*       int pipe[16];    */ /* table de parametres lors MU_MESAG        */
/*       int x;           */ /* coordonnee souris X                      */
/*       int y;           */ /* coordonnee souris Y                      */
/*       int k;           */ /* etat des boutons souris                  */
/*       int ksp;         */ /* etat des touches CONTRL,ALT,SHIFT,CAPS   */
/*       int key;         */ /* etat du clavier                          */
/*       int click;       */ /* nombre de click                          */
/*      }EVNT_O;                                                         */
/*                                                                       */
/* NOUVEAUX MESSAGES:   La surcouche cree de nouveaux messages et de     */
/*         nouveaux evenements afin de faciliter la programmation. Nous  */
/*         le verrons plus loin dans l'exemple.  cote j'ai marque en    */
/*         commentaire (EZGEM)                                           */


CALLBACK WindProcDialogue(int w_ind, EVNT_O *Evnt)
{/*.............. les variables locales suivantes sont souvent ..........*/
 /*           utiles pour toutes les fonctions de fenetre EZGEM pour:    */
 GRECT grect;          /* rectangle surface de travail                   */
 int w_h;              /* handle de la fenetre de cette Wind_proc_xxx    */
 int wh_top;           /* handle de la fenetre en avant plan             */
 /* VRECT clip;  */    /* rectangle de traage (type VDI) pas ici!!      */
 /*.............. variables locales specifiques  notre .................*/
 /*                  exemple de Ressource en fenetre                     */
 OBJECT *object;     /* pointeur d'objet pour les ressources             */ 
 char *sztt_txt;     /* pointera sur adresse copie texte bulle d'aide    */
 int ob_ret;         /* retournera l'objet ressource selectionne         */
 DLG_VAR *dlg;       /* structure attachee  chaque ressource en fenetre */
 char stralert[256]; /* pour affichage alerte item menu cliqu           */
 char bufnum[128];   
 /*.................. INITIALISER LES VARIABLES ....................*/
 /*........recuperer dans la memoire buffer suplementaire ..........*/
 /*        attachee  la fenetre, les donnees DLG_VAR               */
 /*        permettant la gestion des ressources en fenetre          */
 dlg = &Windtab[w_ind].DlgVar;
  
 /*.................... recuperer handles ..........................*/    
 wind_get( 0, WF_TOP, &wh_top); /* celui de fenetre avant plan      */
 w_h = Windtab[w_ind].w_h;      /* celui de notre fenetre           */
 grect = Windtab[w_ind].GemWorkGrect; /* recuperer espace de travail      */
           
       
 /*...........................TOUCHE CLAVIER APPUYEE ...................*/
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec une touche clavier  */
 /* Notamment l'edition et saisie de texte dans les champs editables et */
 /* les raccourcis clavier.                                             */
 /* Pour une ressource en fenetre il est indispensable que l'evenement  */
 /* MU_KEYBD soit traite avant l'evenement  MU_BUTTON afin de permettre */
 /* un fonctionnement correct des raccourcis clavier. En effet le       */
 /* raccourci clavier d'un objet simule un clic souris sur l'objet.     */
 /* en renvoyant un evenement MU_BUTTON                                 */
 
 if (Evnt->evnt & MU_KEYBD && w_h==wh_top)
    {Xform_keybd(w_ind, Evnt);
    }
    
 /*.......................... BOUTONS SOURIS ...........................*/ 
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec un appui sur un     */
 /* bouton de souris.                                                   */
 /* Notamment l'appui sur un bouton de la ressource, la selection du    */
 /* texte dans les champs editables, et le placement du curseur de      */
 /* texte dans les champs editables.                                    */
  
 if (Evnt->evnt & MU_BUTTON)
    {ob_ret = Xform_button(w_ind, Evnt);     
     if (ob_ret>-1)
        {Evnt->evnt &= ~MU_BUTTON;   /* empecher propagation message  MU_BUTTON */
         object=dlg->tree;
         /*............. si objet exit selectionne ...................*/
         object[ob_ret].ob_state &= ~SELECTED;         
         if (object[ob_ret].ob_type &((G_CICON<<8)|G_USERDEF))           
             SendObjectRedraw( Windtab[w_ind].w_h, object, ob_ret); 
         else
             Xobjc_draw(object, ob_ret, 1, &grect);  
         /*.............. ICI ACTION SELON BOUTON CLIQUE..............*/            
         /* switch (ob_ret)            */
         /*   {case TRUC:              */
         /*         FaireTruc();       */   
         /*         break;             */
         /*    case MACHIN:            */
         /*         FaireMachin();     */   
         /*         break;             */
         /*   }                        */     
        }  /* endif objet selectable cliqu  */ 
    } /* endif MU_BUTTON  et fenetre au premier plan */

 /*....... non traites ..............*/
 /*
 if (Evnt->evnt & MU_M1)
    {
    }
 if (Evnt->evnt & MU_M2)
    {
    }
 */   
 
 /*.......................... TIMER ..................................*/  
 /* Dans le cadre d'une ressource en fenetre la fonction: Xform_timer */
 /* s'occupe de tout ce que doit gerer le timer notamment le clignote */
 /* ment du curseur texte dans les champs editables                   */
 if (Evnt->evnt & MU_TIMER && w_h==wh_top)  
    {Xform_timer(w_ind);    
    }
    
 /*.......................... MOUVEMENTS SOURIS ......................*/   
 /* Pour une ressource en fenetre la fonction: Xform_mu_move          */
 /* s'occupe de tout ce qui doit etre ger par un mouvement souris.   */      
 /* Notamment les formes de la souris lors du survol des differentes  */
 /* zones de la ressource.                                            */ 
 if (Evnt->evnt & MU_MOVE)   /*  (EZGEM evenement)   */
    {Xform_mu_move(w_ind, Evnt);
    }      
 /*.......................... MESSAGES GEM et AUTRES .................*/     
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {
        
        case WM_CONSTRUCT:
             /***********************************************************/
             /*.................... WM_CONSTRUCT (EZGEM message)........*/
             /* Ce message est transmis avant la creation et ouverture  */
             /* de la fenetre associee  notre procedure de fenetre.    */
             /* c'est  cet endroit que vous devez initialiser tout ce  */
             /* qui concerne votre fenetre: Memoire, chargement d'un    */
             /* fichier ressource, modification des dimensions fenetre  */
             /* avant ouverture, declaration des Bulles d'aide associees*/
             /*  cette fenetre, titre de la fenetre.....etc            */
             /* eventuellement si pas deja fait avant: ouverture d'une  */
             /* Station de travail VDI autre que celle d'EAZY_GEM.      */  
             /* EAZY_GEM vous laisse toute liberte pour faire ce que    */
             /* vous voulez:                                            */
             /* Vous pouvez tres bien charger votre fichier ressource  */    
             /* cet endroit ou avant dans l'application..               */
             /* Lors de ce message il est donn dans:                   */
             /*                  Evnt->pipe[X_B]                        */
             /*                  Evnt->pipe[Y_B]                        */
             /*                  Evnt->pipe[W_B]                        */
             /*                  Evnt->pipe[H_B]                        */
             /*                               les dim exterieures  maxi */
             /* possibles d'ouverture de la fenetre sur l'ecran.        */ 
             /* c'est par defaut ces dimensions qui sont choisies pour  */
             /* ouvrir une fenetre.Si on veut d'autres dimensions c'est */
             /* ces valeurs qu'il faudra modifier.                      */
             /*                                                         */
             /* REPONDRE AU MESSAGE WM_CONTRUCT:                        */
             /* Il est possible de repondre au message WM_CONSTRUCT     */
             /* de deux manieres equivalentes au point de vue resultat: */
             /* Soit en faisant  Evnt->evnt = WM_ABORT; (ou WM_STANDBY) */
             /* Soit en faisant  return WM_ABORT;       (ou WM_STANDBY) */                
             /*                                                         */
             /* Vous pouvez interrompre le processus de creation de la  */
             /* fenetre en retournant le message: WM_ABORT par exemple  */
             /* vous n'avez pas pu reserver toute la memoire souhaitable*/
             /* ou vous n'avez pas trouve un fichier indispensable      */
             /* ou pour toute autre raison liee a votre application.etc.*/
             /*                                                         */
             /* Vous pouvez empecher l'ouverture de la fenetre et donc  */
             /* permettre juste sa creation en retournant le message:   */   
             /* WM_STANDBY. Pour ouvrir et afficher la fenetre ulterieu-*/
             /* ment il faudra utiliser la fonction: OpenWindow         */
             /* Si vous ne retournez pas ce message la fenetre s'ouvre  */
             /* dans la foulee (cas le plus utile).                     */                           
             /*                                                         */
             /* Pour les ressources en fenetre j'ai cree une fonction   */
             /* s'occupe de tout ce qu'il y a a faire  ce sujet        */
             /* la voici:                                               */
             Xform_construct(w_ind, Evnt);         
             /*........... placer le tout sous la souris ..............*/
             AdjustWindCoordToScreen (w_ind, Evnt, (GRECT*)&Evnt->pipe[X_B]);                    
             break;
              
              
             
        case WM_DESTRUCT:       /*  (EZGEM message)   */
             /**************************************************************/              
             /*........................ WM_DESTRUCT (EZGEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre avant   */
             /* que le systeme ne la detruise. c'est  cet endroit qu'il   */
             /* convient de desinitialiser tout ce que l'on avait fait     */
             /* auparavant memoire, bulles d'aide, ressources....          */
             Xform_Destruct(w_ind, Evnt);   
             /*.......... La je ne detruit pas la ressource car............*/
             /*           Adresse en variable globale et detruite          */
             /*                 la fin du programme                       */   
             /*
             RscFicUnLoad(dlg->AdrRsc);                
             AdrRscDial = 0;    
             */
             break;
             
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             /**************************************************************/
             /*...................... WM_TT_ON_OFF (EZGEM message).........*/
             /* Ce message est envoy  notre fenetre chaque fois qu'il est*/
             /* demand d'activer ou de desactiver l'affichage des bulles  */
             /* d'aide. Il suffit simplement d'appeler la fonction qui suit*/
             /* pour mettre  jour l'objet representant l'etat actif ou    */
             /* inactif de notre ressource (si il existe)                  */
             /* Cet Objet est un objet type BOXTEXT extended type 25 que   */ 
             /* vous devez placer sur votre formulaire. Il refletera l'etat*/
             /* actif ou inactif du systeme de bulle d'aide.               */
             SetBulleState(w_h, dlg->tree);
             break;   
                 
        case WM_TT_GET_TXT:     /*  (EZGEM message)   */
             /**************************************************************/              
             /*...................... WM_TT_GET_TXT .(EZGEM message).......*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois que le systeme d'affichage d'une bulle d'aide desire  */
             /* qu'on lui fournisse un texte  afficher.                   */
             /* Ce texte peut etre affiche sur plusieurs lignes en mettant */
             /* comme separateur le signe | .                              */
             /* Exemple:                                                   */
             /* strcpy(sztt_txt,"Premiere ligne|deuxieme ligne|troisieme");*/
             /* Si vous placez une chaine vide "", la bulle d'aide ne sera */
             /* pas affichee.                                              */
             /*  Exemple: strcpy(sztt_txt,"");                             */
             /*                                                            */
             sztt_txt  = (char*)     *(long*)(&Evnt->pipe[W_G]);
             if (Evnt->pipe[X_G]==TT_UPSTOOL)
                {MakeStrInfoOb(dlg->AdrRsc, dlg->NumTree, Evnt->pipe[Y_G], sztt_txt);                 
                }   
                        
             /* Dans le cadre d'une ressource fixe et connue il est bien sur*/
             /* tout a fait possible de copier directement un texte         */
             /* specifique  chaque objet, dans la chaine sztt_txt, avec un */
             /* switch case sur le numero d'objet ou ce que vous voulez..   */               
             /* Exemple:                                                    */
                      /* switch ( Evnt->pipe[Y_B])                          */
                      /*    {case BUTTON_CONFIRMEZ:                         */
                      /*          strcpy(sztt_txt,"Confirmer les options"); */
                      /*          break;                                    */
                      /*     case BUTTON_ANNULER:                           */
                      /*          strcpy(sztt_txt,"Annuler les options");   */
                      /*          break;                                    */
                      /*     case BUTTON_UNDO:                              */
                      /*          strcpy(sztt_txt,"Restaurer les options"); */
                      /*          break;                                    */
                      /*     default:                                       */
                      /*          strcpy(sztt_txt,"");                      */ 
                      /*    }                                               */          
             break;
        
        case WM_ONGLET_CHG:     /*  (EZGEM message)   */
             /**************************************************************/              
             /*................... WM_ONGLET_CHG .(EZGEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois qu'il y a eu changement d'onglet, au niveau d'une     */
             /* ressource geree par notre fenetre. C'est lors de ce messa- */
             /* ge, qu'il convient d'initialiser le nouveau dialogue et de */
             /* recuperer les donnes de l'ancien. Ce message est envoy    */
             /* avant le dessin du nouveau dialogue.                       */
             /* Le message est compose comme suit:                         */
             /*  Evnt->pipe[MESG] = WM_ONGLET_CHG (message envoy)         */             
             /*  Evnt->pipe[APPL] = identificateur de l'application        */
             /*  Evnt->pipe[SUPL] = 0 (pas de surplus)                     */
             /*  Evnt->pipe[WHND] = handle fenetre contenant ressource     */  
             /*  Evnt->pipe[X_G]  = indice du dialogue qui va etre activ  */
             /*  Evnt->pipe[Y_G]  = indice du dialogue qui sera desactive  */    
             /*  *(long*)&Evnt->pipe[W_G] =  adr arbre ou sont les objets  */
             if (InfoClick)
                {/*......... recuperer adresse arbre ressource ................*/
                 object = (OBJECT*)*(long*)&Evnt->pipe[W_G];
             
                 /*........ recuperer nom ancien dialogue .....................*/
                 strcpy(stralert,"[2][L'onglet: ");
                 strcpy (bufnum, 
                         ObjcGetTxt(object, Evnt->pipe[Y_G])
                         +1);  /* +1 car il faut sauter le premier caractere   */
                 sztt_txt = strchr(bufnum,'|');   /* chercher barre separation */                    
                 if (sztt_txt!=0L) *sztt_txt = 0; /* y planter un zero de fin  */                          
                 strcat(stralert,bufnum);             
                 strcat(stralert," va etre dsactiv");
                 /*........ recuperer nom nouveau dialogue ....................*/
                 strcat(stralert,"|L'onglet: ");
                 strcpy (bufnum, 
                         ObjcGetTxt(object, Evnt->pipe[X_G])
                        +1);  /* +1 car il faut sauter le premier caractere   */
                 sztt_txt = strchr(bufnum,'|');   /* chercher barre separation */                    
                 if (sztt_txt!=0L) *sztt_txt = 0; /* y planter un zero de fin  */                          
                 strcat(stralert,bufnum);             
                 strcat(stralert," va etre activ][ok]");                        
                 form_alert( 2,stralert);    
                }                                                 
             break; 
                
        case WM_WND_MENU:
             /**************************************************************/              
             /*...................... WM_WND_MENU (EZ_GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* une entree de menu deroulant en fenetre est clique.       */  
             /* en Evnt->pipe[X_G] se trouve  numero de l'item selectionn */       
             /* comme dans les menu GEM classiques.                        */   
             /* en Evnt->pipe[Y_G] se trouve  numero de l'arbre de menu    */                                                         
             /* en *(long*)Evnt->pipe[W_G] adresse arbre menu, cela permet */
             /* de distinguer le menu en fenetre dans le cas de plusieurs  */
             /* menu dans la meme fenetre (c'est possible !!!!)            */ 
             /* ici j'affiche une alerte indiquant le menu cliqu et       */
             /* l'item cliqu.                                             */
             if (InfoClick)
                {strcpy(stralert,"[3][L'option: ");
                 strcat(stralert,itoa( Evnt->pipe[X_G], bufnum, 10 ));
                 strcat(stralert,"|du menu numro: ");
                 strcat(stralert,itoa( Evnt->pipe[Y_G], bufnum, 10 )); 
                 strcat(stralert,"|a t clique][ok]");             
                 form_alert( 3,stralert);                    
                } 
             break;
                  
        case MN_SELECTED:
             /**************************************************************/              
             /*...................... MN_SELECTED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* une entree du menu deroulant est clique.                  */  
             /*......... recuperer adresse premier objet du menu ..........*/ 
             /* xrsrc_gaddr (R_TREE, 0, &object, AdrRscMenu);              */
             /* menu_tnormal( object, Evnt->pipe[3],1);                    */
             /* en Evnt->pipe[4] se trouve le numero de l'item selectionn */                                                              
             /* dans notre exemple il est traite ailleurs donc on peut     */
             /* l'ignorer  ce niveau                                      */
             break;
             
             
        case WM_REDRAW:  
             /**************************************************************/              
             /*........................ WM_REDRAW (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut redessiner une partie de la fenetre (par exemple un*/
             /* accessoire qui la recouvrait vient de se fermer, il faut   */
             /* alors retracer la partie de notre fenetre que l'accessoire */
             /* recouvrait. Avant c'etait un veritable enfer, maintenant   */
             /* il vous faut juste appeler la routine: Lister_rectangles   */
             /* qui vous renvoie le message WM_PAINT                       */
             /* et vous n'avez plus  vous occuper de savoir comment faire */
             /* notamment pour traiter la liste des rectangles et leur     */
             /* intersection avec notre fenetre.                           */    
             Lister_rectangles(w_h,(GRECT*)&Evnt->pipe[X_G]);             
             break;
             
        case WM_PAINTBOX:
             /**************************************************************/              
             /*........................ WM_PAINTBOX (EZGEM message)........*/
             /* Ce nouveau message est envoy a notre procedure de fenetre */
             /* lorsqu'il faut retracer la surface d'une boite de type     */
             /* PAINT_BOX (ob-type etendu PAINT_BOX (215).                 */             
             /*                                                            */
             /* En: Evnt->pipe[X_G], Evnt->pipe[Y_G], Evnt->pipe[W_G], et  */
             /*     Evnt->pipe[W_G], se trouve le rectangle de clipping    */              
             /*                      qui est dej clipp par EAZY_GEM,     */
             /* En: Evnt->pipe[X_B], Evnt->pipe[Y_B], Evnt->pipe[W_B], et  */
             /*     Evnt->pipe[W_B], se trouve le rectangle de la surface  */    
             /*                      client qu'il est   votre charge de   */
             /*                      redessiner                            */
             /* En: Evnt->pipe[12]   se trouve le numero de l'objet dont   */
             /*                      il faut retracer la surface.          */
             {/*....... effacer espace de travail ..........................*/   
              /* ICI JE TRACE LE RECTANGLE ESPACE DE TRAVAIL INTERIEUR AU   */
              /*             BORD EPAIS ET  LA RESSOURCE                   */
              int x,y;
              char buft[64];
              
              vswr_mode(VDIhandle,MD_REPLACE);
              vsf_color( VDIhandle, 0 );           /* modifi par objc_draw         */
              vsf_interior(VDIhandle,0);                      
              GrectPbox((GRECT*)&Evnt->pipe[X_G]);    
              Defline(1,1,0,0,1);
              GrectBox((GRECT*)&Evnt->pipe[X_B]);    
                  
              Deftext(1,0,0,6,1);
              vst_alignment (VDIhandle,0,3, &x, &x );  /* bottom line */
              x=Evnt->pipe[X_B]+3;
              y=Evnt->pipe[Y_B]+8;
              vswr_mode(VDIhandle,MD_TRANS);
              VdiText(x,y,"PAINT_BOX");
              VdiText(x,y+8,"n: ");
              itoa(Evnt->pipe[12],buft,10);
              VdiText(x+32,y+8,buft);                                                                                                                                                                                                    
             }
             break;   
                      
        case WM_PAINT:
             /**************************************************************/              
             /*........................ WM_PAINT (EZGEM message)...........*/
             /* Ce nouveau message est envoy a notre procedure de fenetre */
             /* lorsqu'il faut retracer quelque chose  l'ecran.           */
             /*                                                            */
             /* En: Evnt->pipe[X_G], Evnt->pipe[Y_G], Evnt->pipe[W_G], et  */
             /*     Evnt->pipe[W_G], se trouve le rectangle de clipping    */              
             /*                      qui est dej clipp par EAZY_GEM,     */
             /* En: Evnt->pipe[X_B], Evnt->pipe[Y_B], Evnt->pipe[W_B], et  */
             /*     Evnt->pipe[W_B], se trouve le rectangle de la surface  */    
             /*                      client qu'il est   votre charge de   */
             /*                      redessiner                            */
             {/*....... effacer espace de travail ..........................*/   
              /* ICI JE TRACE LE RECTANGLE ESPACE DE TRAVAIL INTERIEUR AU   */
              /*             BORD EPAIS ET  LA RESSOURCE                   */
              vswr_mode(VDIhandle,MD_REPLACE);
              vsf_color( VDIhandle, 0 );           /* modifi par objc_draw         */
              vsf_interior(VDIhandle,0);                      
              GrectPbox((GRECT*)&Evnt->pipe[X_G]);    
              Defline(1,1,0,0,1);
              GrectBox((GRECT*)&Evnt->pipe[X_B]);                                                                                                                                                                                               
             }
             break;    
                                
       case WM_BOTTOM:
             /**************************************************************/              
             /*........................ WM_BOTTOM (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre au dernier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_BOTTOM );   */        
             wind_set(w_h, WF_BOTTOM );             
             break;
                               
       case WM_TOPPED:
             /**************************************************************/              
             /*........................ WM_TOPPED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre en premier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_TOP );      */        
             wind_set(w_h, WF_TOP );             
             break;

        case WM_CLOSED:
             /*........................ WM_CLOSED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre         */
             /* lorsqu'une demande de fermeture de la fenetre est demandee */
             /* si vous voulez detruire completement cette fenetre il faut */
             /* appeler imperativement la fonction: DestroyWindow          */
             /* pour la reouvrir ensuite il vous faudra appeler la         */
             /* fonction:                           CreateWindow           */
             /* sinon il vous faut faire un simple: CloseWindow  et la     */
             /* reouvrir par:                       OpenWindow             */
             /* sans etre oblige de tout reinitialiser                     */
             /* CloseWindow(w_ind);                                        */
             DestroyWindow(w_h);
             break;
        case WM_ALLICONIFY:    
             /**************************************************************/              
             /*........................ WM_ALLICONIFY (GEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier toutes les fenetres. EAZY_GEM met  votre*/
             /* disposition une fonction s'occupant de tout: AllIconify()  */
             /* vous pouvez lui donner en entree l'adresse d'une structure */
             /* GRECT, contenant des coordonnes d'iconification. Si vous  */
             /* placez zero alors EAZY_GEM les calcule pour vous.          */             
             AllIconify(0L);
             break;     
        case WM_ICONIFY:
             /**************************************************************/              
             /*........................ WM_ICONIFY (GEM message)...........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier une fenetre.EAZY_GEM met  votre service */
             /* une fonction s'occupant de tout: IconifyWindow()           */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             /* vous pouvez aussi lui donner en entree l'adresse d'une     */
             /* structure GRECT, contenant des coordonnes d'iconification.*/
             /* Si vous placez zero alors EAZY_GEM les calcule pour vous.  */ 
             IconifyWindow(w_ind, 0L);
             break;                                                    
        case WM_UNICONIFY:
             /**************************************************************/              
             /*........................ WM_UNICONIFY (GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut desiconifier une fenetre.EAZY_GEM met  votre      */
             /* service une fonction s'occupant de tout: UnconifyWindow()  */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             UnconifyWindow(w_ind);            
             break;
        /*                  
        case WM_FULLED:
             break;
        case WM_ARROWED:
             break;
        case WM_HSLID:
             break;
        case WM_VSLID:
             break;
        */     
        case WM_SIZED:    
             /**************************************************************/              
             /*........................ WM_SIZED (GEM message).............*/   
             /* dans cet exemple je traite ce message avec le suivant      */      
        case WM_MOVED:
             /**************************************************************/              
             /*........................ WM_MOVED (GEM message).............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* dimensionnement, ou lors d'une demande logicielle.         */
             /* ou apres une modification des coordonnes de la fenetre     */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */ 
             Xform_moved(w_ind, Evnt);                                     
             break;
        /*     
        case WM_NEWTOP:
             break;
        case AC_OPEN:
             break;
        case AC_CLOSE:
             break;                                                                   
        */
       }
    }      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}


/*----------------------- WindProcParam ---------------------------------*/
/* '''''CI DESSOUS SQUELETTE D'UNE PROCEDURE DE GESTION DE FENETRE'''''''*/
/*                 ici gestion d'une ressource en fenetre                */
/* ACTION : Procedure de gestion attache  une fenetre.                 */
/*          Ici gestion d'un formulaire en fenetre permettant de         */
/*          parametrer l'aspect de la fenetre bidon.                     */
/* ENTREE : EVNT_O *Evnt pointe sur une structure du type EVNT_O         */
/*                 (decrite dessous) cette structure represente le flux  */
/*                 evenementiel.                                         */
/*          w_ind indice pointant sur la structure rattache  cette     */
/*                fenetre:  Windtab[w_ind]                               */
/*                                                                       */
/* RETOURNE: un int retransmettant l'evenement Evnt->evnt                */
/*           En effet le flux evenementiel doit etre retransmis aux      */
/*           autres fenetres afin qu'elles puissent elles aussi reagir   */
/*           aux evenements.  L'evenement est  transmis en premier       */
/*           toujours   la fenetre du dessus puis  aux autres ensuite.  */
/*           Il est parfois utile d'empecher la transmission du flux     */
/*           aux autres fenetres. Exemple je clique sur la fenetre       */
/*           principale et je ne veux pas que le menu dessous reoive    */
/*           le click, il faut alors faire Evnt->evnt &= ~MU_BUTTON      */  
/*           afin d'enlever l'evenement MU_BUTTON du flux evementiel.    */
/*                                                                       */
/* DIX COMMANDEMENTS CONCERNANT L'UTILISATION D'EAZY GEM:                */
/*          Pour faciliter la gestion du GEM j'ai rajout une sur couche */
/*          analysant toute la messagerie et evenements GEM et dirigeant */
/*          les messages sur chaque procedure de fenetre. En effet je me */
/*          suis inspir d'un truc pas mal dans window, qui est que tout */
/*          ce qui concerne une fenetre est gr par une seule et meme   */
/*          procedure. Cela apparait au debut comme idiot et limitatif   */
/*          mais  l'usage cette faon de faire est hyper efficace.      */
/*          Pour pouvoir  beneficier des facilites offertes par le       */ 
/*          systeme EZ_GEM il convient de suivre quelques regles:        */
/*                                                                       */
/*          1)  Dmarrer par la fonction: InitEazyGem                    */
/*          2)  Utilizez Imperativement la fonction: BouclePrincipale    */
/*              qui est le moteur et noyau principal d'EAZY_GEM.         */
/*              C'est cette fonction qui est chargee de redistribuer     */
/*              sur les procedures de fenetre adequates tout le flux     */
/*              evenementiel, qui gere les bulles d'aide et autres       */           
/*              bricoles.                                                */
/*          3)  Finir par la fonction:    ExitEazyGem                    */
/*          4)  Charger vos ressources avec la fonction: RscFicLoad      */
/*          5)  Utilisez la fonction: xrsrc_gaddr pour acceder aux       */
/*              elements de votre ressource.                             */
/*          7)  Liberer vos ressources avec la fonction: RscFicUnLoad    */
/*          8)  Creez vos fenetres avec la fonction: CreateWindow        */
/*          9)  Detruisez vos fenetres avec la fonction: DestroyWindow   */
/*         10)  Acceder et modifier les textes des objets ressource en   */
/*              utilisant les fonctions: ObjcGetTxt et ObjcSetTxt        */
/*         11)  Ouvrir et Fermer les fenetres avec OpenWindow et         */
/*              CloseWindow                                              */
/*         12)  Redimensionner   les fenetres avec: SetWindowSize        */
/*                                                                       */
/* RAPPEL:                                                               */
/*          Lors de l'ouverture d'une fenetre il faut faire appel  la   */
/*          fonction suivante, qui cree et met en place une fenetre:     */
/*                                                                       */
/*  int  CreateWindow ( long w_attr,                                     */
/*                      int ident,                                       */
/*                      void *adr,                                       */               
/*                      CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt),     */
/*                      int x, int y, int w, int h,                      */
/*                      char *nom                                        */
/*                  )                                                    */
/*  long w_attr: attributs GEM classique d'une fenetre                   */
/*               trois attributs de plus:                                */
/*                         BORDER permet d'avoir un cadre epais en       */
/*                                  relief autour de la fenetre.         */
/*                         XMOVER permet d'avoir une poigne de deplace- */
/*                                ment sur le bord sup du cadre epais    */
/*                         XSIZER permet l'agrandissement de la fenetre  */
/*                                en cliquant sur le cadre epais         */
/*  int Ident:  nbr arbitraire(jamais nul) que vous devez donner. Cela   */
/*              peut servir  reperer tel ou tel type de fenetre dans    */
/*              votre programme. Exemple votre application comporte      */
/*              plusieurs fenetres dont une de menu  laquelle vous      */
/*              donnez int ident=2 chaque fois que vous l'ouvrez.Il est  */
/*              alors facile pour le programme de savoir si la fenetre   */
/*              menu est ouverte en faisant appel  la fonction          */
/*              int IdentToIndice(2); qui vous retourne l'indice de la   */
/*              fenetre (si elle n'existe pas l'indice est >= MAX_WIND ) */
/*  void *adr:  adresse pointant sur diverses choses dependant du type de*/
/*              gestion de la fenetre.                                   */
/*              Le premier mot point par cette adresse doit renseigner  */
/*              sur le type de structure passee dans adr.                */
/*              .............. RESSOURCE EN FENETRE......................*/
/*              Si ce premier mot est: RSC_DIAL                          */
/*                                ou   TOOL_BAR cela signifie que  adr   */
/*              pointe sur une structure de type DLG_VAR, et que la      */
/*              fenetre gerera une ressource. Avant l'appel de           */ 
/*              CreateWindow DLG_VAR.type    doit etre egal a RSC_DIAL.  */
/*                                           ou TOOL_BAR                 */
/*                           DLG_VAR.AdrRsc  doit pointer l'adresse de   */
/*                                           chargement de la ressource. */
/*                           DLG_VAR.NumTree doit etre egal au numero de */
/*                                           l'arbre devant etre gere.   */       
/*                         le reste des donnes de la structure n'est    */
/*                         pas a initialiser (le seront automatiquement) */ 
/*  CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt): L vous donnez le nom   */
/*              fonction qui sera charge de gerer tous les evenements   */
/*              de cette fenetre. Cette fonction sera appelee par la     */
/*              sur couche EAZY_GEM.                                     */
/* int x, int y, int w, int h,: coordonnees en pixels de la fenetre      */
/*              ces coordonnees doivent etre celles du contour exterieur */
/*              de la fenetre et non de la surface de travail            */
/*              si zero en entree alors les dimensions maxi possibles    */
/*              seront choisies.                                         */
/*              Ces dimensions peuvent etre modifiees avant ouverture de */
/*              la fenetre lors du traitement du message WM_CONSTRUCT    */
/*              au sein de la procedure de fenetre.                      */
/* char *nom:   titre de la fenetre                                      */
/*              de meme le titre de la fenetre peut etre modifie au sein */
/*              de la procedure de fenetre lors du traitement du message */
/*              WM_CONTRUCT.                                             */
/*                                                                       */
/*                                                                       */
/*................... description de la structure EVNT_O.................*/
/*  typedef struct                                                       */
/*      {int evnt;        */ /* type d'evenement                         */
/*       int pipe[16];    */ /* table de parametres lors MU_MESAG        */
/*       int x;           */ /* coordonnee souris X                      */
/*       int y;           */ /* coordonnee souris Y                      */
/*       int k;           */ /* etat des boutons souris                  */
/*       int ksp;         */ /* etat des touches CONTRL,ALT,SHIFT,CAPS   */
/*       int key;         */ /* etat du clavier                          */
/*       int click;       */ /* nombre de click                          */
/*      }EVNT_O;                                                         */
/*                                                                       */
/* NOUVEAUX MESSAGES:   La surcouche cree de nouveaux messages et de     */
/*         nouveaux evenements afin de faciliter la programmation. Nous  */
/*         le verrons plus loin dans l'exemple.  cote j'ai marque en    */
/*         commentaire (EZGEM)                                           */


CALLBACK WindProcParam(int w_ind, EVNT_O *Evnt)
{/*.............. les variables locales suivantes sont souvent ..........*/
 /*           utiles pour toutes les fonctions de fenetre EZGEM pour:    */
 GRECT grect;          /* rectangle surface de travail                   */
 int w_h;              /* handle de la fenetre de cette Wind_proc_xxx    */
 int wh_top;           /* handle de la fenetre en avant plan             */
 /* VRECT clip;  */    /* rectangle de traage (type VDI) pas ici!!      */
 /*.............. variables locales specifiques  notre .................*/
 /*                  exemple de Ressource en fenetre                     */
 OBJECT *object;     /* pointeur d'objet pour les ressources             */ 
 char *sztt_txt;     /* pointera sur adresse copie texte bulle d'aide    */
 int ob_ret;         /* retournera l'objet ressource selectionne         */
 DLG_VAR *dlg;       /* structure attachee  chaque ressource en fenetre */
 /*.................. INITIALISER LES VARIABLES ....................*/
 /*........recuperer l'adresse de la structure DLG_VAR .............*/
 /*        permettant la gestion des ressources en fenetre          */
 dlg = &Windtab[w_ind].DlgVar;
  
 /*.................... recuperer handles ..........................*/    
 wind_get( 0, WF_TOP, &wh_top); /* celui de fenetre avant plan      */
 w_h = Windtab[w_ind].w_h;      /* celui de notre fenetre           */
 grect = Windtab[w_ind].GemWorkGrect; /* recuperer espace de travail    */
           
       
 /*...........................TOUCHE CLAVIER APPUYEE ...................*/
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec une touche clavier  */
 /* Notamment l'edition et saisie de texte dans les champs editables et */
 /* les raccourcis clavier.                                             */
 /* Pour une ressource en fenetre il est indispensable que l'evenement  */
 /* MU_KEYBD soit traite avant l'evenement  MU_BUTTON afin de permettre */
 /* un fonctionnement correct des raccourcis clavier. En effet le       */
 /* raccourci clavier d'un objet simule un clic souris sur l'objet.     */
 /* en renvoyant un evenement MU_BUTTON                                 */
 
 if (Evnt->evnt & MU_KEYBD && w_h==wh_top)
    {Xform_keybd(w_ind, Evnt);
    }
    
 /*.......................... BOUTONS SOURIS ...........................*/ 
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec un appui sur un     */
 /* bouton de souris.                                                   */
 /* Notamment l'appui sur un bouton de la ressource, la selection du    */
 /* texte dans les champs editables, et le placement du curseur de      */
 /* texte dans les champs editables.                                    */
  
 if (Evnt->evnt & MU_BUTTON)
    {ob_ret = Xform_button(w_ind, Evnt);     
     if (ob_ret>-1)
        {int wind;
         int lst_box_sel;       
         int wh;       
         long w_attr;
         GRECT wgrect;
         
         Evnt->evnt &= ~MU_BUTTON;   /* empecher propagation message  MU_BUTTON */
         object=dlg->tree;
         /*............. si objet exit selectionne ...................*/
         object[ob_ret].ob_state &= ~SELECTED;
         Xobjc_draw(object, ob_ret, 1, &grect);  
         /* SendObjectRedraw( Windtab[w_ind].w_h, object, ob_ret);  */
         
         /*.............. ICI ACTION SELON BOUTON CLIQUE..............*/            
         switch (ob_ret)            
            {case PRM_ANNULER:            
                  SendWindMessage(w_h, WM_CLOSED, 0L);         
                  break;  
             case PRM_CONFIRMEZ:     
             case PRM_APPLIQUER:                                      
                  wind = IsWindExist(W_BIDON);         /* recuperer indice fenetre bidon */
                  if (wind>-1 && IsWindOpen(wind))     /* si fenetre bidon existe        */           
                     {
                                                                                  
                      /*........... annuler les parametres  tester ...............*/
                      w_attr = Windtab[wind].w_attr & ~(NAME|MOVER|SIZER|SMALLER|FULLER|CLOSER); 
                      
                      /*........... replacer les flags selon etat ressource .......*/
                      if (object[PRM_TITLE].ob_state & SELECTED)    w_attr |= NAME|MOVER;
                      if (object[PRM_SIZER].ob_state & SELECTED)    w_attr |= SIZER;
                      if (object[PRM_ICONIFY].ob_state & SELECTED)  w_attr |= SMALLER;
                      if (object[PRM_FULLER].ob_state & SELECTED)   w_attr |= FULLER;
                      if (object[PRM_CLOSER].ob_state & SELECTED)   w_attr |= CLOSER;
                      
                      /* je n'ai pas trouv d'autres moyens que de detruire la     */
                      /* fenetre et de la recreer pour que les nouveaux attributs  */
                      /* de fenetre soient pris en compte. En effet la fonction:   */
                       wh = Windtab[wind].w_h;
                       wind_set(wh, WF_KIND, (int) w_attr); /*ne marche pas !!!   */
                       
                      /* peut etre que vous detenez le secret...                   */
                      /*.............. detruire fenetre bidon .....................*/   
                                                               
                      GetGemWindExtGRECT(wh, &wgrect);
                      DestroyWindow(wh);
                      wh=CreateWindow(w_attr, 
                                      W_BIDON, 
                                      0L, 
                                      WindProcBidon, 
                                      wgrect.g_x, wgrect.g_y, wgrect.g_w, wgrect.g_h, 
                                      "Fenetre BIDON");         
                      SendWindMessage(w_h, WM_TOPPED, 0L); 
                                                  
                      if (wh)                       
                         {/*...... recuperer N item selectionne de la list box couleur .......*/
                          lst_box_sel = GetSelectedListBoxItem(object, PRM_COLOR_LIST);
                          /*........ le placer en memoire sup de la fenetre bidon .............*/
                          *(int*)(Windtab[WindHandToIndice(wh)].MemSup )  = lst_box_sel; 
                          /*...... recuperer N item selectionne de la list box trames ........*/
                          lst_box_sel = GetSelectedListBoxItem(object, PRM_TRAME_LIST);
                          /*........ le placer en memoire sup de la fenetre bidon .............*/
                          *(int*)(Windtab[WindHandToIndice(wh)].MemSup+2) = lst_box_sel;                 
                         }  
                     }
                  if (ob_ret == PRM_CONFIRMEZ) SendWindMessage(w_h, WM_CLOSED, 0L);   
                  break;                   
            }                             
        }  /* endif objet selectable cliqu  */ 
    } /* endif MU_BUTTON  et fenetre au premier plan */
 
 if (Evnt->evnt & MU_M1)
    {
    }
 if (Evnt->evnt & MU_M2)
    {
    }
    
 /*.......................... TIMER ..................................*/  
 /* Dans le cadre d'une ressource en fenetre la fonction: Xform_timer */
 /* s'occupe de tout ce que doit gerer le timer notamment le clignote */
 /* ment du curseur texte dans les champs editables                   */
 if (Evnt->evnt & MU_TIMER && w_h==wh_top)  
    {Xform_timer(w_ind);    
    }
    
 /*.......................... MOUVEMENTS SOURIS ......................*/   
 /* Pour une ressource en fenetre la fonction: Xform_mu_move          */
 /* s'occupe de tout ce qui doit etre ger par un mouvement souris.   */      
 /* Notamment les formes de la souris lors du survol des differentes  */
 /* zones de la ressource.                                            */ 
 if (Evnt->evnt & MU_MOVE)   /*  (EZGEM evenement)   */
    {Xform_mu_move(w_ind, Evnt);
    }      
 /*.......................... MESSAGES GEM et AUTRES .................*/     
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {
        
        case WM_CONSTRUCT:
             /***********************************************************/
             /*.................... WM_CONSTRUCT (EZGEM message)........*/
             /* Ce message est transmis avant la creation et ouverture  */
             /* de la fenetre associee  notre procedure de fenetre.    */
             /* c'est  cet endroit que vous devez initialiser tout ce  */
             /* qui concerne votre fenetre: Memoire, chargement d'un    */
             /* fichier ressource, modification des dimensions fenetre  */
             /* avant ouverture, declaration des Bulles d'aide associees*/
             /*  cette fenetre, titre de la fenetre.....etc            */
             /* eventuellement si pas deja fait avant: ouverture d'une  */
             /* Station de travail VDI autre que celle d'EAZY_GEM.      */  
             /* EAZY_GEM vous laisse toute liberte pour faire ce que    */
             /* vous voulez:                                            */
             /* Vous pouvez tres bien charger votre fichier ressource  */    
             /* cet endroit ou avant dans l'application..               */
             /* Lors de ce message il est donn dans:                   */
             /*                  Evnt->pipe[X_B]                        */
             /*                  Evnt->pipe[Y_B]                        */
             /*                  Evnt->pipe[W_B]                        */
             /*                  Evnt->pipe[H_B]                        */
             /*                               les dim exterieures  maxi */
             /* possibles d'ouverture de la fenetre sur l'ecran.        */ 
             /* c'est par defaut ces dimensions qui sont choisies pour  */
             /* ouvrir une fenetre.Si on veut d'autres dimensions c'est */
             /* ces valeurs qu'il faudra modifier.                      */
             /*                                                         */
             /* REPONDRE AU MESSAGE WM_CONTRUCT:                        */
             /* Il est possible de repondre au message WM_CONSTRUCT     */
             /* de deux manieres equivalentes au point de vue resultat: */
             /* Soit en faisant  Evnt->evnt = WM_ABORT; (ou WM_STANDBY) */
             /* Soit en faisant  return WM_ABORT;       (ou WM_STANDBY) */                
             /*                                                         */
             /* Vous pouvez interrompre le processus de creation de la  */
             /* fenetre en retournant le message: WM_ABORT par exemple  */
             /* vous n'avez pas pu reserver toute la memoire souhaitable*/
             /* ou vous n'avez pas trouve un fichier indispensable      */
             /* ou pour toute autre raison liee a votre application.etc.*/
             /*                                                         */
             /* Vous pouvez empecher l'ouverture de la fenetre et donc  */
             /* permettre juste sa creation en retournant le message:   */   
             /* WM_STANDBY. Pour ouvrir et afficher la fenetre ulterieu-*/
             /* ment il faudra utiliser la fonction: OpenWindow         */
             /* Si vous ne retournez pas ce message la fenetre s'ouvre  */
             /* dans la foulee (cas le plus utile).                     */                           
             /*                                                         */
             /* Pour les ressources en fenetre j'ai cree une fonction   */
             /* s'occupe de tout ce qu'il y a a faire  ce sujet        */
             /* c'est: Xform_construct(w_ind, Evnt);                    */
             /*                                                         */
             /* Ici on charge la ressource lors du message WM_CONSTRUCT */ 
             /* et non lors de la creation de la fenetre. Cette varian- */
             /* te vous est prsente pour vous montrer qu'il est possi-*/
             /* ble de faire un peut comme on veut !!                   */
             
             dlg->AdrRsc = LoadAppliRsc( "WND_PRM.RSC", NO_SCALE);              
             if (dlg->AdrRsc)                                            
                {dlg->type     = RSC_DIAL;   /* type de structure passee en entree */ 
                 dlg->NumTree  = 0;
                 Xform_construct(w_ind, Evnt);       
                 /*........... placer le tout sous la souris ..............*/
                 AdjustWindCoordToScreen (w_ind, Evnt, (GRECT*)&Evnt->pipe[X_B]); 
                }                  
             /*...... si  erreur dans ouverture, envoyer .................*/
             /*       au systeme le message de non reussite               */
             /*       afin qu'il n'ouvre pas notre fenetre                */
             else
                {return WM_ABORT;
                } 
             break;
              
              
             
        case WM_DESTRUCT:       /*  (EZGEM message)   */
             /**************************************************************/              
             /*........................ WM_DESTRUCT (EZGEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre avant   */
             /* que le systeme ne la detruise. c'est  cet endroit qu'il   */
             /* convient de desinitialiser tout ce que l'on avait fait     */
             /* auparavant memoire, bulles d'aide, ressources....          */
             /*                                                            */
             Xform_Destruct(w_ind, Evnt);   /* desinitialiser l'arbre      */
             RscFicUnLoad(dlg->AdrRsc);  
             break;
             
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             /**************************************************************/
             /*...................... WM_TT_ON_OFF (EZGEM message).........*/
             /* Ce message est envoy  notre fenetre chaque fois qu'il est*/
             /* demand d'activer ou de desactiver l'affichage des bulles  */
             /* d'aide. Il suffit simplement d'appeler la fonction qui suit*/
             /* pour mettre  jour l'objet representant l'etat actif ou    */
             /* inactif de notre ressource (si il existe)                  */
             /* Cet Objet est un objet type BOXTEXT extended type 25 que   */ 
             /* vous devez placer sur votre formulaire. Il refletera l'etat*/
             /* actif ou inactif du systeme de bulle d'aide.               */
             SetBulleState(w_h, dlg->tree);
             break;   
                 
        case WM_TT_GET_TXT:     /*  (EZGEM message)   */
             /**************************************************************/              
             /*...................... WM_TT_GET_TXT .(EZGEM message).......*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois que le systeme d'affichage d'une bulle d'aide desire  */
             /* qu'on lui fournisse un texte  afficher.                   */
             /* Ce texte peut etre affiche sur plusieurs lignes en mettant */
             /* comme separateur le signe | .                              */
             /* Exemple:                                                   */
             /* strcpy(sztt_txt,"Premiere ligne|deuxieme ligne|troisieme");*/
             /* Si vous placez une chaine vide "", la bulle d'aide ne sera */
             /* pas affichee.                                              */
             /*  Exemple: strcpy(sztt_txt,"");                             */
             /*                                                            */
             /* Dans le cadre d'une ressource en fenetre ce message est    */
             /* envoye chaque fois que la bulle d'aide reste un certain    */
             /* temps au dessus d'un objet de la ressource                 */
             /* Il est structur comme suit:                               */
    
             sztt_txt  = (char*)     *(long*)(&Evnt->pipe[W_G]);
             if (Evnt->pipe[X_G]==TT_UPSTOOL)
                {switch ( Evnt->pipe[Y_G])                          
                    {case PRM_CONFIRMEZ:                         
                          strcpy(sztt_txt,"Confirmer les options|de cette boite de dialogue|et fermer cette fenetre"); 
                          break;                                                                    
                     case PRM_ANNULER:                           
                          strcpy(sztt_txt,"Annuler les options|et fermer cette boite");   
                          break;                                    
                     case PRM_APPLIQUER:                              
                          strcpy(sztt_txt,"Appliquer les options|pour voir les effets|sans quitter la boite"); 
                          break;    
                     case PRM_COLOR_LIST:                              
                          strcpy(sztt_txt,"Cliquez sur la couleur|de fond de la fenetre"); 
                          break;                                        
                     default:                                       
                          strcpy(sztt_txt,"");                       
                    }                                         
                }    
             break;
             
        case WM_WND_MENU:
             /**************************************************************/              
             /*...................... WM_WND_MENU (EZ_GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* une entree de menu deroulant en fenetre est clique.       */  
             /* en Evnt->pipe[X_G] se trouve  numero de l'item selectionn */       
             /* comme dans les menu GEM classiques.                        */   
             /* en Evnt->pipe[Y_G] se trouve  numero de l'arbre de menu    */                                                         
             /* en *(long*)Evnt->pipe[W_G] adresse arbre menu, cela permet */
             /* de distinguer le menu en fenetre dans le cas de plusieurs  */
             /* menu dans la meme fenetre (c'est possible !!!!)            */              
             /* l'ignorer  ce niveau car je n'ai pas de menu ici          */             
             break;
             
        case WM_ONGLET_CHG:     /*  (EZGEM message)   */
             /**************************************************************/              
             /*................... WM_ONGLET_CHG .(EZGEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois qu'il y a eu changement d'onglet, au niveau d'une     */
             /* ressource geree par notre fenetre. C'est lors de ce messa- */
             /* ge, qu'il convient d'initialiser le nouveau dialogue et de */
             /* recuperer les donnes de l'ancien. Ce message est envoy    */
             /* avant le dessin du nouveau dialogue.                       */
             /* Le message est compose comme suit:                         */
             /* en  Evnt->pipe[WHND]= RSC_DIAL; le message provient d'une  */
             /*                             ressource.  ET ALORS           */                     
             /*  Evnt->pipe[MESG] = WM_ONGLET_CHG (message envoy)         */             
             /*  Evnt->pipe[APPL] = identificateur de l'application        */
             /*  Evnt->pipe[SUPL] = 0 (pas de surplus)                     */
             /*  Evnt->pipe[WHND] = handle fenetre contenant ressource     */  
             /*  Evnt->pipe[X_G]  = indice du dialogue qui va etre activ  */
             /*  Evnt->pipe[Y_G]  = indice du dialogue qui sera desactive  */    
             /*  *(long*)&Evnt->pipe[W_G] =  adr arbre ou sont les objets  */   
             /*  on l'ignore dans cette boite car n'a pas d'onglets        */                                    
             break; 
                          
        case MN_SELECTED:
             /**************************************************************/              
             /*...................... MN_SELECTED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* une entree du menu deroulant est clique.                  */  
             /*......... recuperer adresse premier objet du menu ..........*/ 
             /* xrsrc_gaddr (R_TREE, 0, &object, AdrRscMenu);              */
             /* menu_tnormal( object, Evnt->pipe[3],1);                    */
             /* en Evnt->pipe[4] se trouve le numero de l'item selectionn */                                                              
             /* dans notre exemple il est traite ailleurs donc on peut     */
             /* l'ignorer  ce niveau                                      */
             break;
             
             
        case WM_REDRAW:  
             /**************************************************************/              
             /*........................ WM_REDRAW (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut redessiner une partie de la fenetre (par exemple un*/
             /* accessoire qui la recouvrait vient de se fermer, il faut   */
             /* alors retracer la partie de notre fenetre que l'accessoire */
             /* recouvrait. Avant c'etait un veritable enfer, maintenant   */
             /* il vous faut juste appeler la routine: Lister_rectangles   */
             /* qui vous renvoie le message WM_PAINT                       */
             /* et vous n'avez plus  vous occuper de savoir comment faire */
             /* notamment pour traiter la liste des rectangles et leur     */
             /* intersection avec notre fenetre.                           */    
             Lister_rectangles(w_h,(GRECT*)&Evnt->pipe[X_G]);             
             break;
                 
        case WM_PAINT:
             /**************************************************************/              
             /*........................ WM_PAINT (EZGEM message)...........*/
             /* Ce nouveau message est envoy a notre procedure de fenetre */
             /* lorsqu'il faut retracer quelque chose  l'ecran.           */
             /*                                                            */
             /* En: Evnt->pipe[X_G], Evnt->pipe[Y_G], Evnt->pipe[W_G], et  */
             /*     Evnt->pipe[W_G], se trouve le rectangle de clipping    */              
             /*                      qui est dej clipp par EAZY_GEM,     */
             /* En: Evnt->pipe[X_B], Evnt->pipe[Y_B], Evnt->pipe[W_B], et  */
             /*     Evnt->pipe[W_B], se trouve le rectangle de la surface  */    
             /*                      client qu'il est   votre charge de   */
             /*                      redessiner                            */             
             break;                       
       
       case WM_BOTTOM:
             /**************************************************************/              
             /*........................ WM_BOTTOM (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre au dernier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_BOTTOM );   */        
             wind_set(w_h, WF_BOTTOM );             
             break;
                               
       case WM_TOPPED:
             /**************************************************************/              
             /*........................ WM_TOPPED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre en premier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_TOP );      */        
             wind_set(w_h, WF_TOP );             
             break;

        case WM_CLOSED:
             /*........................ WM_CLOSED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre         */
             /* lorsqu'une demande de fermeture de la fenetre est demandee */
             /* si vous voulez detruire completement cette fenetre il faut */
             /* appeler imperativement la fonction: DestroyWindow          */
             /* pour la reouvrir ensuite il vous faudra appeler la         */
             /* fonction:                           CreateWindow           */
             /* sinon il vous faut faire un simple: CloseWindow  et la     */
             /* reouvrir par:                       OpenWindow             */
             /* sans etre oblige de tout reinitialiser                     */
             /* CloseWindow(w_ind);                                        */
             DestroyWindow(w_h);
             break;
        /*     
        case WM_FULLED:
             break;
        case WM_ARROWED:
             break;
        case WM_HSLID:
             break;
        case WM_VSLID:
             break;
        */     
        case WM_SIZED:    
             /**************************************************************/              
             /*........................ WM_SIZED (GEM message).............*/   
             /* dans cet exemple je traite ce message avec le suivant      */      
        case WM_MOVED:
             /**************************************************************/              
             /*........................ WM_MOVED (GEM message).............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* dimensionnement, ou lors d'une demande logicielle.         */
             /* ou apres une modification des coordonnes de la fenetre     */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */ 
             Xform_moved(w_ind, Evnt);                                     
             break;
        case WM_ALLICONIFY:    
             /**************************************************************/              
             /*........................ WM_ALLICONIFY (GEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier toutes les fenetres. EAZY_GEM met  votre*/
             /* disposition une fonction s'occupant de tout: AllIconify()  */
             /* vous pouvez lui donner en entree l'adresse d'une structure */
             /* GRECT, contenant des coordonnes d'iconification. Si vous  */
             /* placez zero alors EAZY_GEM les calcule pour vous.          */             
             AllIconify(0L);
             break;     
        case WM_ICONIFY:
             /**************************************************************/              
             /*........................ WM_ICONIFY (GEM message)...........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier une fenetre.EAZY_GEM met  votre service */
             /* une fonction s'occupant de tout: IconifyWindow()           */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             /* vous pouvez aussi lui donner en entree l'adresse d'une     */
             /* structure GRECT, contenant des coordonnes d'iconification.*/
             /* Si vous placez zero alors EAZY_GEM les calcule pour vous.  */ 
             IconifyWindow(w_ind, 0L);                 
             IconifyWindow(w_ind, 0L);
             break;          
                                                       
        case WM_UNICONIFY:
             /**************************************************************/              
             /*........................ WM_UNICONIFY (GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut desiconifier une fenetre.EAZY_GEM met  votre      */
             /* service une fonction s'occupant de tout: UnconifyWindow()  */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             UnconifyWindow(w_ind);            
             break; 
        /*          
        case WM_NEWTOP:
             break;
        case AC_OPEN:
             break;
        case AC_CLOSE:
             break;                                                                   
       */      
       }
    }      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}



/*-------------------------- WindProcBidon ------------------------------*/
/* '''''CI DESSOUS SQUELETTE D'UNE PROCEDURE DE GESTION DE FENETRE'''''''*/
/*                 ici gestion d'une ressource barre d'outils            */
/*                 plus animation bidon de triangles                     */
/*      Cet exemple de fenetre charge et initialise sa ressource lors du */
/*      traitement du message WM_CONSTRUCT                               */
/* ACTION : Procedure de gestion attache  une fenetre.                 */
/* ENTREE : EVNT_O *Evnt pointe sur une structure du type EVNT_O         */
/*                      (decrite dessous) cette structure represente le  */
/*                      flux evenementiel.                               */
/*          w_ind indice pointant sur la structure rattache  cette     */
/*                fenetre:  Windtab[w_ind]                               */
/*                                                                       */
/* RETOURNE: un int retransmettant l'evenement Evnt->evnt                */
/*           En effet le flux evenementiel doit etre retransmis aux      */
/*           autres fenetres afin qu'elles puissent elles aussi reagir   */
/*           aux evenements.  L'evenement est  transmis en premier       */
/*           toujours   la fenetre du dessus puis  aux autres ensuite.  */
/*           Il est parfois utile d'empecher la transmission du flux     */
/*           aux autres fenetres. Exemple je clique sur la fenetre       */
/*           principale et je ne veux pas que le menu dessous reoive    */
/*           le click, il faut alors faire Evnt->evnt &= ~MU_BUTTON      */  
/*           afin d'enlever l'evenement MU_BUTTON du flux evementiel.    */
/*                                                                       */
/* DIX COMMANDEMENTS CONCERNANT L'UTILISATION D'EAZY GEM:                */
/*          Pour faciliter la gestion du GEM j'ai rajout une sur couche */
/*          analysant toute la messagerie et evenements GEM et dirigeant */
/*          les messages sur chaque procedure de fenetre. En effet je me */
/*          suis inspir d'un truc pas mal dans window, qui est que tout */
/*          ce qui concerne une fenetre est gr par une seule et meme   */
/*          procedure. Cela apparait au debut comme idiot et limitatif   */
/*          mais  l'usage cette faon de faire est hyper efficace.      */
/*          Pour pouvoir  beneficier des facilites offertes par le       */ 
/*          systeme EZ_GEM il convient de suivre quelques regles:        */
/*                                                                       */
/*          1)  Dmarrer par la fonction: InitEazyGem                    */
/*          2)  Utilizez Imperativement la fonction: BouclePrincipale    */
/*              qui est le moteur et noyau principal d'EAZY_GEM.         */
/*              C'est cette fonction qui est chargee de redistribuer     */
/*              sur les procedures de fenetre adequates tout le flux     */
/*              evenementiel, qui gere les bulles d'aide et autres       */           
/*              bricoles.                                                */
/*          3)  Finir par la fonction:    ExitEazyGem                    */
/*          4)  Charger vos ressources avec la fonction: RscFicLoad      */
/*          5)  Utilisez la fonction: xrsrc_gaddr pour acceder aux       */
/*              elements de votre ressource.                             */
/*          7)  Liberer vos ressources avec la fonction: RscFicUnLoad    */
/*          8)  Creez vos fenetres avec la fonction: CreateWindow        */
/*          9)  Detruisez vos fenetres avec la fonction: DestroyWindow   */
/*         10)  Acceder et modifier les textes des objets ressource en   */
/*              utilisant les fonctions: ObjcGetTxt et ObjcSetTxt        */
/*         11)  Ouvrir et Fermer les fenetres avec OpenWindow et         */
/*              CloseWindow                                              */
/*         12)  Redimensionner   les fenetres avec: SetWindowSize        */
/*                                                                       */
/* RAPPEL:                                                               */
/*          Lors de l'ouverture d'une fenetre il faut faire appel  la   */
/*          fonction suivante, qui cree et met en place une fenetre:     */
/*                                                                       */
/*  int  CreateWindow ( int w_attr,                                      */
/*                      int ident,                                       */
/*                      void *adr,                                       */               
/*                      CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt),     */
/*                      int x, int y, int w, int h,                      */
/*                      char *nom                                        */
/*                  )                                                    */
/*  long w_attr: attributs GEM classique d'une fenetre                   */
/*               trois attributs de plus:                                */
/*                         BORDER permet d'avoir un cadre epais en       */
/*                                  relief autour de la fenetre.         */
/*                         XMOVER permet d'avoir une poigne de deplace- */
/*                                ment sur le bord sup du cadre epais    */
/*                         XSIZER permet l'agrandissement de la fenetre  */
/*                                en cliquant sur le cadre epais         */
/*  int Ident:  nbr arbitraire(jamais nul) que vous devez donner. Cela   */
/*              peut servir  reperer tel ou tel type de fenetre dans    */
/*              votre programme. Exemple votre application comporte      */
/*              plusieurs fenetres dont une de menu  laquelle vous      */
/*              donnez int ident=2 chaque fois que vous l'ouvrez.Il est  */
/*              alors facile pour le programme de savoir si la fenetre   */
/*              menu est ouverte en faisant appel  la fonction          */
/*              int IdentToIndice(2); qui vous retourne l'indice de la   */
/*              fenetre (si elle n'existe pas l'indice est >= MAX_WIND ) */
/*  void *adr:  adresse pointant sur diverses choses dependant du type de*/
/*              gestion de la fenetre.                                   */
/*              Le premier mot point par cette adresse doit renseigner  */
/*              sur le type de structure passee dans adr.                */
/*              .............. RESSOURCE EN FENETRE......................*/
/*              Si ce premier mot est: RSC_DIAL                          */
/*                                ou   TOOL_BAR cela signifie que  adr   */
/*              pointe sur une structure de type DLG_VAR, et que la      */
/*              fenetre gerera une ressource. Avant l'appel de           */ 
/*              CreateWindow DLG_VAR.type    doit etre egal a RSC_DIAL.  */
/*                                           ou TOOL_BAR                 */           
/*                           DLG_VAR.AdrRsc  doit pointer l'adresse de   */
/*                                           chargement de la ressource. */
/*                           DLG_VAR.NumTree doit etre egal au numero de */
/*                                           l'arbre devant etre gere.   */       
/*                         le reste des donnes de la structure n'est    */
/*                         pas a initialiser (le seront automatiquement) */ 
/*  CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt): L vous donnez le nom   */
/*              fonction qui sera charge de gerer tous les evenements   */
/*              de cette fenetre. Cette fonction sera appelee par la     */
/*              sur couche EAZY_GEM.                                     */
/* int x, int y, int w, int h,: coordonnees en pixels de la fenetre      */
/*              ces coordonnees doivent etre celles du contour exterieur */
/*              de la fenetre et non de la surface de travail            */
/*              si zero en entree alors les dimensions maxi possibles    */
/*              seront choisies.                                         */
/*              Ces dimensions peuvent etre modifiees avant ouverture de */
/*              la fenetre lors du traitement du message WM_CONSTRUCT    */
/*              au sein de la procedure de fenetre.                      */
/* char *nom:   titre de la fenetre                                      */
/*              de meme le titre de la fenetre peut etre modifie au sein */
/*              de la procedure de fenetre lors du traitement du message */
/*              WM_CONTRUCT.                                             */
/*                                                                       */
/*                                                                       */
/*................... description de la structure EVNT_O.................*/
/*  typedef struct                                                       */
/*      {int evnt;        */ /* type d'evenement                         */
/*       int pipe[16];    */ /* table de parametres lors MU_MESAG        */
/*       int x;           */ /* coordonnee souris X                      */
/*       int y;           */ /* coordonnee souris Y                      */
/*       int k;           */ /* etat des boutons souris                  */
/*       int ksp;         */ /* etat des touches CONTRL,ALT,SHIFT,CAPS   */
/*       int key;         */ /* etat du clavier                          */
/*       int click;       */ /* nombre de click                          */
/*      }EVNT_O;                                                         */
/*                                                                       */
/* NOUVEAUX MESSAGES:   La surcouche cree de nouveaux messages et de     */
/*         nouveaux evenements afin de faciliter la programmation. Nous  */
/*         le verrons plus loin dans l'exemple.  cote j'ai marque en    */
/*         commentaire (EZGEM)                                           */


CALLBACK WindProcBidon(int w_ind, EVNT_O *Evnt)
{/*.............. les variables locales suivantes sont souvent ..........*/
 /*           utiles pour toutes les fonctions de fenetre EZGEM pour:    */
 GRECT grect;          /* rectangle surface de travail                   */
 int w_h;              /* handle de la fenetre de cette Wind_proc_xxx    */
 int wh_top;           /* handle de la fenetre en avant plan             */
 /*.............. variables locales specifiques  notre .................*/
 /*                  exemple de Ressource en fenetre                     */
 OBJECT *object;     /* pointeur d'objet pour les ressources             */ 
 char *sztt_txt;     /* pointera sur adresse copie texte bulle d'aide    */
 DLG_VAR *dlg;       /* structure attachee  chaque ressource en fenetre */
 int i;              /* on a toujours besoin d'un i et u chez soi        */
 char *pt_txt;       /* pointeur sur caractere                           */
 GRECT wgrect;
 long val;
 /*.................. INITIALISER LES VARIABLES ....................*/
 /*........recuperer dans la memoire buffer suplementaire ..........*/
 /*        attachee  la fenetre, les donnees DLG_VAR               */
 /*        permettant la gestion des ressources en fenetre          */
 dlg = &Windtab[w_ind].DlgVar;
 /*.................... recuperer handles ..........................*/    
 wind_get( 0, WF_TOP, &wh_top); /* celui de fenetre avant plan      */
 w_h = Windtab[w_ind].w_h;      /* celui de notre fenetre           */
 grect = Windtab[w_ind].GemWorkGrect; /* recuperer espace de travail    */
           
       
 /*...........................TOUCHE CLAVIER APPUYEE ...................*/
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec une touche clavier  */
 /* Notamment l'edition et saisie de texte dans les champs editables et */
 /* les raccourcis clavier.                                             */
 /* Pour une ressource en fenetre il est indispensable que l'evenement  */
 /* MU_KEYBD soit traite avant l'evenement  MU_BUTTON afin de permettre */
 /* un fonctionnement correct des raccourcis clavier. En effet le       */
 /* raccourci clavier d'un objet simule un clic souris sur l'objet.     */
 /* en renvoyant un evenement MU_BUTTON                                 */
 
 if (Evnt->evnt & MU_KEYBD && w_h==wh_top)
    {Xform_keybd(w_ind, Evnt);
    } /* endif MU_KEYBD  et fenetre au premier plan */
    
 /*.......................... BOUTONS SOURIS ...........................*/ 
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec un appui sur un     */
 /* bouton de souris.                                                   */
 /* Notamment l'appui sur un bouton de la ressource, la selection du    */
 /* texte dans les champs editables, et le placement du curseur de      */
 /* texte dans les champs editables.                                    */
  
 if (Evnt->evnt & MU_BUTTON)
    {int ob_ret;    
     ob_ret = Xform_button(w_ind, Evnt);       
     if (ob_ret>-1)
        {Evnt->evnt &= ~MU_BUTTON;   /* empecher propagation message  MU_BUTTON */   
         object=dlg->tree;
         /*............. si objet exit selectionne ...................*/
         object[ob_ret].ob_state &= ~SELECTED;
         Xobjc_draw(object, ob_ret, 1, &grect);         
         i=IsThisObjectExecutive(object, ob_ret);
         if (i)
            {switch (i)            
               {case 350:
                     SendMessage(WM_TT_ON_OFF);                 
                     break;
               }            
            }
        else
            {/*.............. ICI ACTION SELON BOUTON CLIQUE..............*/            
             switch (ob_ret)            
               {               
               }
            }                                
        }  /* endif objet selectable cliqu  */            
    } /* endif MU_BUTTON  et fenetre au premier plan */
 
 if (Evnt->evnt & MU_M1)
    {
    }
 if (Evnt->evnt & MU_M2)
    {
    }
    
 /*.......................... TIMER ..................................*/  
 /* Dans le cadre d'une ressource en fenetre la fonction: Xform_timer */
 /* s'occupe de tout ce que doit gerer le timer notamment le clignote */
 /* ment du curseur texte dans les champs editables                   */
 if (Evnt->evnt & MU_TIMER && w_h==wh_top)  
    {Xform_timer(w_ind);  
    }
    
 /*.......................... MOUVEMENTS SOURIS ......................*/   
 /* Pour une ressource en fenetre la fonction: Xform_mu_move          */
 /* s'occupe de tout ce qui doit etre ger par un mouvement souris.   */      
 /* Notamment les formes de la souris lors du survol des differentes  */
 /* zones de la ressource.                                            */ 
 if (Evnt->evnt & MU_MOVE)   /*  (EZGEM evenement)   */
    {Xform_mu_move(w_ind, Evnt);
    }      
 /*.......................... MESSAGES GEM et AUTRES .................*/     
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {
        
        case WM_CONSTRUCT:      /*  (EZGEM message)   */
             /***********************************************************/
             /*.................... WM_CONSTRUCT (EZGEM message)........*/
             /* Ce message est transmis avant la creation et ouverture  */
             /* de la fenetre associee  notre procedure de fenetre.    */
             /* c'est  cet endroit que vous devez initialiser tout ce  */
             /* qui concerne votre fenetre: Memoire, chargement d'un    */
             /* fichier ressource, modification des dimensions fenetre  */
             /* avant ouverture, declaration des Bulles d'aide associees*/
             /*  cette fenetre, titre de la fenetre.....etc            */
             /* eventuellement si pas deja fait avant: ouverture d'une  */
             /* Station de travail VDI autre que celle d'EAZY_GEM.      */  
             /* EAZY_GEM vous laisse toute liberte pour faire ce que    */
             /* vous voulez:                                            */
             /* Vous pouvez tres bien charger votre fichier ressource  */    
             /* cet endroit ou avant dans l'application..               */
             /* Lors de ce message il est donn dans:                   */
             /*                  Evnt->pipe[X_B]                        */
             /*                  Evnt->pipe[Y_B]                        */
             /*                  Evnt->pipe[W_B]                        */
             /*                  Evnt->pipe[H_B]                        */
             /*                               les dim exterieures  maxi */
             /* possibles d'ouverture de la fenetre sur l'ecran.        */ 
             /* c'est par defaut ces dimensions qui sont choisies pour  */
             /* ouvrir une fenetre.Si on veut d'autres dimensions c'est */
             /* ces valeurs qu'il faudra modifier.                      */
             /*                                                         */
             /* REPONDRE AU MESSAGE WM_CONTRUCT:                        */
             /* Il est possible de repondre au message WM_CONSTRUCT     */
             /* de deux manieres equivalentes au point de vue resultat: */
             /* Soit en faisant  Evnt->evnt = WM_ABORT; (ou WM_STANDBY) */
             /* Soit en faisant  return WM_ABORT;       (ou WM_STANDBY) */                
             /*                                                         */
             /* Vous pouvez interrompre le processus de creation de la  */
             /* fenetre en retournant le message: WM_ABORT par exemple  */
             /* vous n'avez pas pu reserver toute la memoire souhaitable*/
             /* ou vous n'avez pas trouve un fichier indispensable      */
             /* ou pour toute autre raison liee a votre application.etc.*/
             /*                                                         */
             /* Vous pouvez empecher l'ouverture de la fenetre et donc  */
             /* permettre juste sa creation en retournant le message:   */   
             /* WM_STANDBY. Pour ouvrir et afficher la fenetre ulterieu-*/
             /* ment il faudra utiliser la fonction: OpenWindow         */
             /* Si vous ne retournez pas ce message la fenetre s'ouvre  */
             /* dans la foulee (cas le plus utile).                     */                           
             /*                                                         */                                       
             /*............. Chargement et mise en place ................*/
             /*                   d'une barre d'outils                   */                 
             /* UNE BARRE D'OUTILS est une ressource normale dont        */
             /* certains objets ont la possibilit d'automatiser leur    */
             /* fonctionnement.                                          */
             dlg->AdrRsc = LoadAppliRsc( "TOOL_BAR.RSC", NO_SCALE);              
             if (dlg->AdrRsc)                                            
                {/*....... adresse premier arbre (y en a qu'un!!)......*/
                 dlg->type = TOOL_BAR;
                 dlg->NumTree  = 0;
                 Xform_construct(w_ind, Evnt); 
                                  
                /*............. Initialiser les valeurs du fond ...........................*/                                          
                *(int*)(Windtab[w_ind].MemSup)   = 0;  /* index couleur  */    
                *(int*)(Windtab[w_ind].MemSup+2) = 1;  /* index trame     */
                
                /*.............. Adapter hauteur des LISTBOX ..............................*/
                AdaptListBoxToWindHeight(w_ind,TOOL_TRAME_LIST, 40, (GRECT*)&Evnt->pipe[X_B]);
                AdaptListBoxToWindHeight(w_ind,TOOL_COLOR_LIST, (int)Nb_color, (GRECT*)&Evnt->pipe[X_B]);
                AdaptListBoxToWindHeight(w_ind,TOOL_FONT_LIST, NbFont, (GRECT*)&Evnt->pipe[X_B]);
                
                /*.............. positionner options menu disabled ........................*/
                xrsrc_gaddr (R_TREE, WIND_MENU, &object, dlg->AdrRsc);
                object[TLB_MEN_CHARGER].ob_state |= DISABLED ;
                object[TLB_MEN_AJOUTER].ob_state |= DISABLED ;
                object[TLB_MEN_SAUVER].ob_state |= DISABLED ;
                object[TLB_MEN_SAUV_SOU].ob_state |= DISABLED ;
                object[TLB_MEN_ANNULER].ob_state |= DISABLED ;
                object[TLB_MEN_REDO].ob_state |= DISABLED ; 
                object[TLB_MEN_COLLER].ob_state |= CHECKED ;
                object[TLB_MEN_INFO].ob_state |= CHECKED ;                                
                }                  
            
                
             /*...... si  erreur dans ouverture, envoyer .................*/
             /*       au systeme le message de non reussite               */
             /*       afin qu'il n'ouvre pas notre fenetre                */
             else
                {return WM_ABORT;
                }             
             break;
              
              
             
        case WM_DESTRUCT:       /*  (EZGEM message)   */
             /**************************************************************/              
             /*........................ WM_DESTRUCT (EZGEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre avant   */
             /* que le systeme ne la detruise. c'est  cet endroit qu'il   */
             /* convient de desinitialiser tout ce que l'on avait fait     */
             /* auparavant memoire, bulles d'aide, ressources....          */
             /*                                                            */
             Xform_Destruct(w_ind, Evnt);
             RscFicUnLoad(dlg->AdrRsc);                                                                                                  
             break;
             
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             /**************************************************************/
             /*...................... WM_TT_ON_OFF (EZGEM message).........*/
             /* Ce message est envoy  notre fenetre chaque fois qu'il est*/
             /* demand d'activer ou de desactiver l'affichage des bulles  */
             /* d'aide. Il suffit simplement d'appeler la fonction qui suit*/
             /* pour mettre  jour l'objet representant l'etat actif ou    */
             /* inactif de notre ressource (si il existe)                  */
             object = dlg->tree;
             object->ob_x      = grect.g_x; /* placer origine ressource */
             object->ob_y      = grect.g_y; /*  l'origine fenetre      */
             if (Windtab[w_ind].w_attr & BORDER)
                {object->ob_x     += 6;
                 object->ob_y     += 6;
                }     
             i = NumFuncToIndObject(object,350);
             if (i>=0)
                {if (TTswitch) object[i].ob_state &= ~DISABLED;
                 else          object[i].ob_state |=  DISABLED;
                 SendObjectRedraw(w_h, object, i);    
                }   
             break;   
                 
        case WM_TT_GET_TXT:     /*  (EZGEM message)   */
             /**************************************************************/              
             /*...................... WM_TT_GET_TXT .(EZGEM message).......*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois que le systeme d'affichage d'une bulle d'aide desire  */
             /* qu'on lui fournisse un texte  afficher.                   */
             /* Ce texte peut etre affiche sur plusieurs lignes en mettant */
             /* comme separateur le signe | .                              */
             /* Exemple:                                                   */
             /* strcpy(sztt_txt,"Premiere ligne|deuxieme ligne|troisieme");*/
             /* Si vous placez une chaine vide "", la bulle d'aide ne sera */
             /* pas affichee.                                              */
             /*  Exemple: strcpy(sztt_txt,"");                             */                
             sztt_txt  = (char*)     *(long*)(&Evnt->pipe[W_G]);             
             if (Evnt->pipe[X_G]==TT_UPSTOOL)
                {MakeStrInfoOb(dlg->AdrRsc, TOOL_BARRE, Evnt->pipe[Y_G], sztt_txt);                           
                }    
             break;
             
        case WM_WND_MENU:       /*  (EZGEM message)   */            
             /**************************************************************/              
             /*...................... WM_WND_MENU (EZ_GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* une entree de menu deroulant en fenetre est clique.       */  
             /* en Evnt->pipe[X_G] se trouve  numero de l'item selectionn */       
             /* comme dans les menu GEM classiques.                        */   
             /* en Evnt->pipe[Y_G] se trouve  numero de l'arbre de menu    */                                                         
             /* en *(long*)Evnt->pipe[W_G] adresse arbre menu, cela permet */
             /* de distinguer le menu en fenetre dans le cas de plusieurs  */
             /* menu dans la meme fenetre (c'est possible !!!!)            */ 
             switch(Evnt->pipe[X_G])
                {case TLB_MEN_CLOSE: 
                      DestroyWindow(w_h);
                      break;
                 case TLB_MEN_QUIT:
                      EZGemRun=0;  /* mettre  zero cette variable globale */
                                   /* c'est terminer le programme          */  
                      break;
                 case TLB_MEN_OPT_FEN:
                      break;
                }  
             break;
             
        case WM_ONGLET_CHG:     /*  (EZGEM message)   */
             /**************************************************************/              
             /*................... WM_ONGLET_CHG .(EZGEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois qu'il y a eu changement d'onglet, au niveau d'une     */
             /* ressource geree par notre fenetre. C'est lors de ce messa- */
             /* ge, qu'il convient d'initialiser le nouveau dialogue et de */
             /* recuperer les donnes de l'ancien. Ce message est envoy    */
             /* avant le dessin du nouveau dialogue.                       */
             /* Le message est compose comme suit:                         */
             /*  Evnt->pipe[MESG] = WM_ONGLET_CHG (message envoy)         */             
             /*  Evnt->pipe[APPL] = identificateur de l'application        */
             /*  Evnt->pipe[SUPL] = 0 (pas de surplus)                     */
             /*  Evnt->pipe[WHND] = handle fenetre contenant ressource     */  
             /*  Evnt->pipe[X_G]  = indice du dialogue qui va etre activ  */
             /*  Evnt->pipe[Y_G]  = indice du dialogue qui sera desactive  */    
             /*  *(long*)&Evnt->pipe[W_G] =  adr arbre ou sont les objets  */                                       
             break; 
                 
        case WM_EXEFUNC:        /*  (EZGEM message)   */
             /**************************************************************/              
             /*...................... WM_EXEFUNC .(EZGEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois qu'il est demand d'executer une fonction referencee  */
             /* par un numero de fonction.                                 */
             /* Le message est compose comme suit:                         */
             /* SI  Evnt->pipe[WHND]= RSC_DIAL; le message provient d'une  */
             /*                             ressource.  ET ALORS           */                     
             /*     Evnt->pipe[X_G] = indice objet declenchant le message  */
             /*     Evnt->pipe[Y_G] = numero de la fonction referencee     */
             /*     *(long*)&Evnt->pipe[W_G] =  adr arbre ou est l'objet   */            
             if (Evnt->pipe[Y_G]>=121 &&    /* SI fonctions de mise  jour du  */
                 Evnt->pipe[Y_G]<=123 &&    /*    fond de la fenetre bidon     */
                 Evnt->pipe[WHND] == RSC_DIAL
                )
                {object = (OBJECT*) *(long*)(&Evnt->pipe[W_G]);
                 i      = Evnt->pipe[X_G];
                 if (object[i].ob_type == (G_USERDEF|(LISTBOX<<8)))
                    {pt_txt = ObjcGetTxt(object,i);
                     if (pt_txt>0)
                        {memcpy(&val,pt_txt,sizeof(long));
                         i = GetSelectedListBoxItem(object, i);
                         if (val == 'Colo')
                            {*(int*)(Windtab[w_ind].MemSup)   =i;
                             /*............. envoyer redraw sur fenetre bidon ....................*/
                             GetClientGrect(w_ind, &wgrect);
                             SendGrectRedrawMessage(w_h, &wgrect);
                            }
                         else if (val == 'Pate')
                            {*(int*)(Windtab[w_ind].MemSup + 2) = i;
                             /*............. envoyer redraw sur fenetre bidon ....................*/
                             GetClientGrect(w_ind, &wgrect);
                             SendGrectRedrawMessage(w_h, &wgrect);
                            }                            
                        }  /* endif if pt_txt>0               */
                    }     /* endif if G_USERDEF|(LISTBOX<<8) */
                }        /* endif if RSC_DIAL               */                 
             break;                  
                                                    
        case MN_SELECTED:
             /**************************************************************/              
             /*...................... MN_SELECTED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* une entree du menu deroulant est clique.                  */  
             /*......... recuperer adresse premier objet du menu ..........*/ 
             /* xrsrc_gaddr (R_TREE, 0, &object, AdrRscMenu);              */
             /* menu_tnormal( object, Evnt->pipe[3],1);                    */
             /* en Evnt->pipe[4] se trouve le numero de l'item selectionn */                                                              
             /* dans notre exemple il est traite ailleurs donc on peut     */
             /* l'ignorer  ce niveau                                      */
             break;
             
             
        case WM_REDRAW:  
             /**************************************************************/              
             /*........................ WM_REDRAW (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut redessiner une partie de la fenetre (par exemple un*/
             /* accessoire qui la recouvrait vient de se fermer, il faut   */
             /* alors retracer la partie de notre fenetre que l'accessoire */
             /* recouvrait. Avant c'etait un veritable enfer, maintenant   */
             /* il vous faut juste appeler la routine: Lister_rectangles   */
             /* qui vous renvoie le message WM_PAINT                       */
             /* et vous n'avez plus  vous occuper de savoir comment faire */
             /* notamment pour traiter la liste des rectangles et leur     */
             /* intersection avec notre fenetre.                           */    
             Lister_rectangles(w_h,(GRECT*)&Evnt->pipe[X_G]);             
             break;
                 
        case WM_PAINT:
             /**************************************************************/              
             /*........................ WM_PAINT (EZGEM message)...........*/
             /* Ce nouveau message est envoy a notre procedure de fenetre */
             /* lorsqu'il faut retracer quelque chose  l'ecran.           */
             /*                                                            */
             /* En: Evnt->pipe[X_G], Evnt->pipe[Y_G], Evnt->pipe[W_G], et  */
             /*     Evnt->pipe[W_G], se trouve le rectangle de clipping    */              
             /*                      qui est dej clipp par EAZY_GEM,     */
             /* En: Evnt->pipe[X_B], Evnt->pipe[Y_B], Evnt->pipe[W_B], et  */
             /*     Evnt->pipe[W_B], se trouve le rectangle de la surface  */    
             /*                      client qu'il est   votre charge de   */
             /*                      redessiner                            */
             {int type, trame;   
              VRECT vrect;    

              /*....... tracer rectangle de la surface client ..........*/  
              vswr_mode(VDIhandle,MD_REPLACE);     
              vsf_color( VDIhandle, *(int*)(Windtab[w_ind].MemSup) );   
              i= *(int*)(Windtab[w_ind].MemSup + 2);
              NumSelToTrame(i, &type, &trame); 
              vsf_interior(VDIhandle,type);   
              vsf_style(VDIhandle,trame);                                    
              if (i==0)  vsf_interior(VDIhandle,0);
              GrectPbox((GRECT*) &Evnt->pipe[X_B]); /* tracer rectangle client */ 
              GRECT_to_VRECT((GRECT*) &Evnt->pipe[X_B],&vrect);
              DrawCustomCadre(&vrect, 0); 
             }                                                                        
             break; 
                                   
       case WM_BOTTOM:
             /**************************************************************/              
             /*........................ WM_BOTTOM (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre au dernier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_BOTTOM );   */        
             wind_set(w_h, WF_BOTTOM );             
             break;
                               
       case WM_TOPPED:
             /**************************************************************/              
             /*........................ WM_TOPPED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre en premier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_TOP );      */        
             wind_set(w_h, WF_TOP );             
             break;

        case WM_CLOSED:
             /*........................ WM_CLOSED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre         */
             /* lorsqu'une demande de fermeture de la fenetre est demandee */
             /* si vous voulez detruire completement cette fenetre il faut */
             /* appeler imperativement la fonction: DestroyWindow          */
             /* pour la reouvrir ensuite il vous faudra appeler la         */
             /* fonction:                           CreateWindow           */
             /* sinon il vous faut faire un simple: CloseWindow  et la     */
             /* reouvrir par:                       OpenWindow             */
             /* sans etre oblige de tout reinitialiser                     */
             CloseWindow(w_ind);                                        
             /* DestroyWindow(w_h); */
             break;
        case WM_ALLICONIFY:    
             /**************************************************************/              
             /*........................ WM_ALLICONIFY (GEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier toutes les fenetres. EAZY_GEM met  votre*/
             /* disposition une fonction s'occupant de tout: AllIconify()  */
             /* vous pouvez lui donner en entree l'adresse d'une structure */
             /* GRECT, contenant des coordonnes d'iconification. Si vous  */
             /* placez zero alors EAZY_GEM les calcule pour vous.          */             
             AllIconify(0L);
             break;
        case WM_ICONIFY:
             /**************************************************************/              
             /*........................ WM_ICONIFY (GEM message)...........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier une fenetre.EAZY_GEM met  votre service */
             /* une fonction s'occupant de tout: IconifyWindow()           */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             /* vous pouvez aussi lui donner en entree l'adresse d'une     */
             /* structure GRECT, contenant des coordonnes d'iconification.*/
             /* Si vous placez zero alors EAZY_GEM les calcule pour vous.  */ 
             IconifyWindow(w_ind, 0L);
             break;                                                    
        case WM_UNICONIFY:
             /**************************************************************/              
             /*........................ WM_UNICONIFY (GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut desiconifier une fenetre.EAZY_GEM met  votre      */
             /* service une fonction s'occupant de tout: UnconifyWindow()  */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             UnconifyWindow(w_ind);            
             break; 
        /*                               
        case WM_ARROWED:
             break;
        case WM_HSLID:
             break;
        case WM_VSLID:
             break;
        */     
        case WM_FULLED: 
             /**************************************************************/              
             /*........................ WM_FULLED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* plein ecran (FULLER), ou lors d'une demande logicielle.    */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */
             /* EAZY_GEM met  votre service une fonction s'occupant de    */
             /* tout: OnWm_fulled()                                        */     
             OnWm_fulled( w_ind, Evnt);  
             break;     
             
        case WM_SIZED:    
             /**************************************************************/              
             /*........................ WM_SIZED (GEM message).............*/   
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* dimensionnement, ou lors d'une demande logicielle.         */
             /* ou apres une modification des coordonnes de la fenetre     */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */ 
             CloseListBox (w_ind);
             AdaptListBoxToWindHeight(w_ind,TOOL_TRAME_LIST, 40, (GRECT*)&Evnt->pipe[X_G]);
             AdaptListBoxToWindHeight(w_ind,TOOL_COLOR_LIST, (int)Nb_color, (GRECT*)&Evnt->pipe[X_G]);
             AdaptListBoxToWindHeight(w_ind,TOOL_FONT_LIST, NbFont, (GRECT*)&Evnt->pipe[X_G]);
                                
             OnWm_sized(w_ind, Evnt);  
             break;
             
        case WM_MOVED:
             /**************************************************************/              
             /*........................ WM_MOVED (GEM message).............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* dimensionnement, ou lors d'une demande logicielle.         */
             /* ou apres une modification des coordonnes de la fenetre     */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */ 
             OnWm_moved(w_ind, Evnt);
             break;
        /*     
        case WM_NEWTOP:
             break;
        case AC_OPEN:
             break;
        case AC_CLOSE:
             break;                                                                   
       */      
       }
    }      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}

/*---------------------- AdaptListBoxToWindHeight -----------------------*/
void AdaptListBoxToWindHeight(int w_ind,int ob_list, int mincases, GRECT *ext_grect)
{GRECT wgrect;
 DLG_VAR *dlg;
 int i,oby0,oby,h_lign,nbcases,nbitem,first;
 dlg = &Windtab[w_ind].DlgVar;
/*.............. Adapter hauteur des LISTBOX ..............................*/
 WindGemBorderToEZWork(Windtab[w_ind].w_attr, ext_grect, &wgrect);
 objc_offset(dlg->tree,ob_list,&i,&oby);   /* recuperer position y de la list box   */
 objc_offset(dlg->tree,0,&i,&oby0);        /* recuperer position y de l'objet zero  */
 oby -= oby0;                              /* ofset par rapport espace de travail   */
 
 GetListBoxParam(dlg->tree,ob_list,0,&first,0,&nbitem,&h_lign,0);
 mincases=Min(mincases,nbitem+1);
 oby = wgrect.g_h - oby - 5;  
 nbcases = oby / h_lign;
 nbcases = Max(2,Min(nbcases,mincases));
 first = Min(nbitem-nbcases,first);
 SetListBoxParam(dlg->tree, ob_list,-2,first,nbcases,-2,-2,(void*)-2);
}

/*------------------------------ WindProcInfo ---------------------------*/
CALLBACK WindProcInfo(int w_ind, EVNT_O *Evnt)
{/*.............. les variables locales suivantes sont souvent ..........*/
 /*           utiles pour toutes les fonctions de fenetre EZGEM pour:    */
 GRECT grect;          /* rectangle surface de travail                   */
 int w_h;              /* handle de la fenetre de cette Wind_proc_xxx    */
 int wh_top;           /* handle de la fenetre en avant plan             */
 /*.............. variables locales specifiques  notre .................*/
 /*                  exemple de Ressource en fenetre                     */
 OBJECT *object;     /* pointeur d'objet pour les ressources             */ 
 char *sztt_txt;     /* pointera sur adresse copie texte bulle d'aide    */
 int ob_ret;         /* retournera l'objet ressource selectionne         */
 DLG_VAR *dlg;       /* structure attachee  chaque ressource en fenetre */
 /*.................. INITIALISER LES VARIABLES ....................*/
 dlg = &Windtab[w_ind].DlgVar;
  
 /*.................... recuperer handles ..........................*/    
 wind_get( 0, WF_TOP, &wh_top); /* celui de fenetre avant plan      */
 w_h = Windtab[w_ind].w_h;      /* celui de notre fenetre           */
 grect = Windtab[w_ind].GemWorkGrect; /* recuperer espace de travail     */

 if (Evnt->evnt & MU_KEYBD && w_h==wh_top)
    {int i;
     char scan;
     char buft[32];
     object=dlg->tree;
     Xform_keybd(w_ind, Evnt);
     /*......... controle en temps reel du texte de la ressource ....*/
     if (dlg->ObjEdit==WND_INFO_INT_TXT && dlg->LstAdr==0)
        {i=Max (8,Min(atoi(ObjcGetTxt (object, WND_INFO_INT_TXT)),64));
         scan=(char)(Evnt->key>>8);
         switch(scan)
           {case  80:     /* down */
               i=Min(64,i+1);
               ObjcSetTxt (object, WND_INFO_INT_TXT,itoa(i,buft,10));
               SetCursObEditOff(dlg);
               Xobjc_draw(object, WND_INFO_INT_TXT, 1, &grect);
               break;
            case  72:     /* up   */
               i=Max(8,i-1);
               ObjcSetTxt (object, WND_INFO_INT_TXT,itoa(i,buft,10));
               SetCursObEditOff(dlg);
               Xobjc_draw(object, WND_INFO_INT_TXT, 1, &grect);
               break;
            default:
               if (i<8)  i=8;
               if (i>64) i=64;              
           }         
         SetScrollBoxParam(object,WND_INFO_SCROLL,i,-2,-2,-2,-2,-2,-2,-2,(void*)-2L,-2);
         Xobjc_draw(object, WND_INFO_SCROLL, 1, &grect);    
        }
    }
    
 if (Evnt->evnt & MU_BUTTON )
    {ob_ret = Xform_button(w_ind, Evnt);     
     if (ob_ret>-1)
        {char buft[32];
         int i;
         
         Evnt->evnt &= ~MU_BUTTON;   /* empecher propagation message  MU_BUTTON */
         object=dlg->tree;
         /*............. si objet exit selectionne ...................*/
         ob_ret &=0x7FFF;
         object[ob_ret].ob_state &= ~SELECTED;         
         if (object[ob_ret].ob_type &((G_CICON<<8)|G_USERDEF))           
             SendObjectRedraw( Windtab[w_ind].w_h, object, ob_ret); 
         else
             Xobjc_draw(object, ob_ret, 1, &grect);  
         /*.............. ICI ACTION SELON BOUTON CLIQUE..............*/  
                   
         switch (ob_ret)            
            {case WND_INFO_INT_UP:  /* fleche haute interligne  */
             case WND_INFO_INT_DW:  /* fleche basse interligne  */
                  do
                    {i=Max (8,Min(atoi(ObjcGetTxt (object, WND_INFO_INT_TXT)),64));
                     if (ob_ret == WND_INFO_INT_UP) i=Max(8,i-1); 
                     else                           i=Min(64,i+1);  
                     ObjcSetTxt (object, WND_INFO_INT_TXT,itoa(i,buft,10));
                     SetCursObEditOff(dlg);
                     Xobjc_draw(object, WND_INFO_INT_TXT, 1, &grect);  
                     Pause_EZ(1);
                    } while(Mousek());
                  SetScrollBoxParam(object,WND_INFO_SCROLL,i,-2,-2,-2,-2,-2,-2,-2,(void*)-2L,-2);
                  Xobjc_draw(object, WND_INFO_SCROLL, 1, &grect);     
                  break;             
         
            }                        
        }  /* endif objet selectable cliqu  */ 
    } /* endif MU_BUTTON  et fenetre au premier plan */

 if (Evnt->evnt & MU_TIMER && w_h==wh_top)  
    {Xform_timer(w_ind);    
    }
 if (Evnt->evnt & MU_MOVE)   /*  (EZGEM evenement)   */
    {Xform_mu_move(w_ind, Evnt);
    }      
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {case WM_CONSTRUCT:
             dlg->AdrRsc = LoadAppliRsc( "WND_INFO.RSC", NO_SCALE);              
             if (dlg->AdrRsc)                                            
                {int clr,pts,fnt,itl,i;
                 char buft[32];
                 dlg->type     = RSC_DIAL;   /* type de structure passee en entree */ 
                 dlg->NumTree  = 0;
                 Xform_construct(w_ind, Evnt);  
                 /*........... placer le tout sous la souris ..............*/
                 AdjustWindCoordToScreen (w_ind, Evnt, (GRECT*)&Evnt->pipe[X_B]); 
                 /*<<<<< EXEMPLE DE DETOURNEMENT DE LA FONCTION LISTBOX >>>>>>*/      
                 /*........... Placer notre fonction d'affichage ...............*/
                 /*            personnelle de la LISTBOX couleur                */
                 SetListCallBackFunc ( dlg->tree, WND_INFO_COLOR, MaFonctionColorList);
                 /*........... Initialiser les elements de la ressource ........*/
                 /*                   sur les bonnes valeurs                    */
                 /*        Recuperer parametres affichage texte                 */
                 GetScrollTxtParam(dlg->tree,WND_INFO_SCROLL, &clr, &pts, &fnt);
                 /*.......... positionner listbox de fonte sur fonte            */
                 i = Max(0,FntID_VDI_to_TabInd(fnt));
                 SetListBoxParam(dlg->tree,WND_INFO_FNTSEL,i,i,-2,-2,-2,(void*)-2L);
                 /*.......... positionner listbox de couleur sur couleur        */
                 SetListBoxParam(dlg->tree,WND_INFO_COLOR,clr,clr,-2,-2,-2,(void*)-2L);
                 /*.......... positionner nbr de pts                            */
                 SetListBoxParam(dlg->tree,WND_INFO_CAR_PTS,pts,pts,-2,-2,-2,(void*)-2L);
                 /*.......... positionner l'interligne                          */
                 GetScrollBoxParam(dlg->tree,WND_INFO_SCROLL,&itl,0L,0L,0L,0L,0L,0L,0L,0L,0L);
                 ObjcSetTxt (dlg->tree, WND_INFO_INT_TXT,itoa(itl,buft,10));                 
                }                  
             else
                {return WM_ABORT;
                }                
             break;
                                         
        case WM_DESTRUCT:       /*  (EZGEM message)   */
             Xform_Destruct(w_ind, Evnt);    
             RscFicUnLoad(dlg->AdrRsc);                
             break;
             
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             SetBulleState(w_h, dlg->tree);
             break;   
        case WM_EXEFUNC:        /*  (EZGEM message)   */
             /**************************************************************/              
             /*...................... WM_EXEFUNC .(EZGEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois qu'il est demand d'executer une fonction referencee  */
             /* par un numero de fonction.                                 */
             /* Le message est compose comme suit:                         */
             /* SI  Evnt->pipe[WHND]= RSC_DIAL; le message provient d'une  */
             /*                             ressource.  ET ALORS           */                     
             /*     Evnt->pipe[X_G] = indice objet declenchant le message  */
             /*     Evnt->pipe[Y_G] = numero de la fonction referencee     */
             /*     *(long*)&Evnt->pipe[W_G] =  adr arbre ou est l'objet   */            
             if (Evnt->pipe[Y_G]>=1000 &&    /* SI fonctions de mise  jour de  */
                 Evnt->pipe[Y_G]<=1002 &&    /*    couleur et police            */
                 Evnt->pipe[WHND] == RSC_DIAL
                )
                {int i;
                 char *pt_txt;
                 long val;
                 OBJECT *objc;
                 objc = (OBJECT*) *(long*)(&Evnt->pipe[W_G]);
                 i   = Evnt->pipe[X_G];
                 if (objc[i].ob_type == (G_USERDEF|(LISTBOX<<8)))
                    {pt_txt = ObjcGetTxt(objc,i);
                     if (pt_txt>0)
                        {memcpy(&val,pt_txt,sizeof(long));
                         i = GetSelectedListBoxItem(objc, i);
                         if (val == LST_COLOR)
                            {SetScrollTxtParam(dlg->tree,WND_INFO_SCROLL,i,-2,-2);
                             SendObjectRedraw(w_h, dlg->tree, WND_INFO_SCROLL);                              
                            }
                         else if (val == LST_FNTSEL)
                            {SetScrollTxtParam(dlg->tree,WND_INFO_SCROLL,-2,-2,(int)FontID[i]);
                             SendObjectRedraw(w_h, dlg->tree, WND_INFO_SCROLL);
                            }
                         else if (val == LST_FNTPTS)
                            {SetScrollTxtParam(dlg->tree,WND_INFO_SCROLL,-2,i,-2);
                             SendObjectRedraw(w_h, dlg->tree, WND_INFO_SCROLL);
                            }                               
                        }  /* endif if pt_txt>0               */
                    }     /* endif if G_USERDEF|(LISTBOX<<8) */
                }        /* endif if RSC_DIAL               */                 
             break;         
             
        case WM_TT_GET_TXT:     /*  (EZGEM message)   */
             sztt_txt  = (char*) *(long*)(&Evnt->pipe[W_G]); 
             if (Evnt->pipe[X_G]==TT_UPSTOOL)
                {switch ( Evnt->pipe[Y_G])                            
                   {case WND_INFO_FIRST:                         
                         strcpy(sztt_txt,"Boite de dialogue|comportant une structure|de defilement autom-|atique de texte"); 
                         break;                                    
                    case WND_INFO_UP:                           
                         strcpy(sztt_txt,"Objet type ascenseur|vertical haut.|L'ob_type etendu doit|etre 207");   
                         break;                                    
                    case WND_INFO_DOWN:                              
                         strcpy(sztt_txt,"Objet type ascenseur|vertical bas.|L'ob_type etendu doit|etre 208");   
                         break; 
                    case WND_INFO_BAR:                           
                         strcpy(sztt_txt,"Objet type barre de|defilement verticale.|L'ob_type etendu doit|etre 210");   
                         break;                                    
                    case WND_INFO_ASC:                              
                         strcpy(sztt_txt,"Objet type ascenseur vertical.|L'ob_type etendu doit etre 209.|Cet objet doit|etre le fils d'une barre|de defilement verticale");   
                         break; 
                    case WND_INFO_SCROLL:                              
                         strcpy(sztt_txt,"Objet type boite de defilement.|L'ob_type est une G_BOXTEXT,|L'ob_type etendu est 111");
                         break;
                    case WND_INFO_FNTSEL:                              
                         strcpy(sztt_txt,"Permet de choisir la police|de caractres du texte");
                         break;
                    case WND_INFO_COLOR:                              
                         strcpy(sztt_txt,"Permet de choisir la couleur|des caractres du texte");
                         break; 
                    case WND_INFO_CAR_PTS:                              
                         strcpy(sztt_txt,"Permet de choisir la taille|des caractres du texte");
                         break; 
                    case WND_INFO_INT_UP:                              
                         strcpy(sztt_txt,"Diminuer l'interligne");
                         break; 
                    case WND_INFO_INT_DW:                              
                         strcpy(sztt_txt,"Augmenter l'interligne");
                         break;      
                    case WND_INFO_INT_TXT:                              
                         strcpy(sztt_txt,"Saisie de l'interligne|(Les flches haut et bas du clavier|permettent d'augmenter ou de|diminuer la valeur)");
                         break;                                                                       
                    default:                                       
                         strcpy(sztt_txt,"");                       
                   }                                                                            
                }
             break;
        
        case WM_REDRAW:               
             Lister_rectangles(w_h,(GRECT*)&Evnt->pipe[X_G]);                          
             break;    
        case WM_BOTTOM:
             wind_set(w_h, WF_BOTTOM );             
             break;                               
        case WM_TOPPED:
             wind_set(w_h, WF_TOP );             
             break;
        case WM_CLOSED:
             DestroyWindow(w_h);
             break;
        case WM_ALLICONIFY:    
             AllIconify(0L);
             break;     
        case WM_ICONIFY:
             IconifyWindow(w_ind, 0L);
             break;                                                    
        case WM_UNICONIFY:
             UnconifyWindow(w_ind);            
             break;                                        
        case WM_SIZED:    
        case WM_MOVED:
             Xform_moved(w_ind, Evnt);                                     
             break;                                                                                     
       }
    }      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}

/*------------------------- MaFonctionColorList ---------------------------*/
/* ACTION: routine d'affichage des elements d'une LISTBOX choix couleurs   */
/*         chaque fois que la listbox de couleur a besoin d'afficher une   */
/*         case elle fait appel  notre routine avec en entree la struct-  */
/*         re LIST_GET_TXT *ptLISTGETTXT permettant de savoir quelle       */
/*         partie de la list box il faut afficher.                         */
/*         Cette fonction un peu delirante affiche les couleurs dans des   */
/*         ellipses.                                                       */
/* les coordonnes de l'element  afficher peuvent etre calculees en       */
/* faisant:                                                                */
/*          coord.left    = ptLISTGETTXT->grect.g_x;                       */
/*          coord.top     = ptLISTGETTXT->grect.g_y  +                     */
/*                          ptLISTGETTXT->h_lign     *                     */
/*                         (ptLISTGETTXT->lign + 1)                        */
/*          coord.right   = ptLISTGETTXT->grect.g_x  +                     */
/*                          ptLISTGETTXT->grect.g_w  - 1                   */
/*          coord.bottom  = coord.top  + ptLISTGETTXT->h_lign -1           */
/*                                                                         */
/* ENTREE:  *ptLISTGETTXT  (pointeur sur structure  LIST_GET_TXT )         */
/*                                                                         */
/* Rappel sur la structure d'entree LIST_GET_TXT:                          */
/* Distinguons deux types d'elements:                                      */
/*            a) ceux de notre liste  afficher : element liste            */
/*                        exemple liste des polices caractere              */
/*                        exemple liste des couleurs etc..                 */
/*            b) ceux de la boite listbox :       element listbox          */
/*                        element de la boite de selection                 */
/*                        premier element de la listbox                    */
/*                        dernier element de la list box                   */             
/* typedef struct                                                          */
/*      {int lign;     N de l'element listbox  afficher                  */
/*                        que l'on nous demande d'afficher                 */
/*                        si -1 c'est celui de la boite de selection       */
/*                        si zero c'est celui sous la boite de selection   */
/*                        si un c'est le suivant                           */
/*                        si deux le suivant etc...                        */
/*                                                                         */
/*       int preml;   N de l'element liste  afficher en zero listbox     */
/*       int pointl;  N de l'element liste selectionn  afficher en -1   */
/*       int h_lign;  hauteur en pixel d'un element listbox                */
/*       GRECT grect; coordonnes de la liste en absolu pix. ecran         */
/*       GRECT clipgrect; coordonnes de clipping en absolu pix. ecran     */
/*       void *LstBoxParam; parametre optionnel de transmission            */
/*                          par lequel l'on reoit des info specifiques    */
/*                          au type de list box                            */
/*                          (adresse d'une table, adresse d'un texte...)   */    
/*                          ici inutilise                                  */
/*     }LIST_GET_TXT;                                                      */

int MaFonctionColorList (LIST_GET_TXT *ptLISTGETTXT)
{int vectxy[4];
 char buft[32];
 int i,xr,yr;    
 int indice_color;  
 RECT coord;
 
 /*.............. determiner et calculer coordonnees ................*/
 /*               de la case (ou ligne) qu'il nous                   */
 /*                    est demande d'afficher                       */
 coord.left    = ptLISTGETTXT->grect.g_x;                       
 coord.top     = ptLISTGETTXT->grect.g_y  +                     
                 ptLISTGETTXT->h_lign     *                     
                (ptLISTGETTXT->lign + 1);                        
 coord.right   = ptLISTGETTXT->grect.g_x  +                     
                 ptLISTGETTXT->grect.g_w  - 1;                   
 coord.bottom  = coord.top  + ptLISTGETTXT->h_lign -1;     
 
 /*.......... determiner l'element de la liste, qu'il convient .......*/ 
 /*           d'afficher, en fonction de la ligne qu'il est demand   */
 /*                           d'afficher.                             */
 /*                                                                   */ 
 /*                    SI il est demande d'afficher la premiere case  */
 /*                       de la LISTBOX, (ptLISTGETTXT->lign == -1)   */
 /*                       il faut afficher l'element selectionn      */                                 
 /*                       (ptLISTGETTXT->pointl) dans notre liste.    */
 /*                                                                   */                          
 if   (ptLISTGETTXT->lign == -1) indice_color = ptLISTGETTXT->pointl;
 
 /*                    SI il est demande d'afficher une autre case    */
 /*                       de la LISTBOX, il faut afficher la liste   */         
 /*                       partir du premier devant etre affiche en    */ 
 /*                       deuxieme ligne.                             */
 /*                                                                   */
 else  indice_color = ptLISTGETTXT->preml + ptLISTGETTXT->lign;
 
 /*.......... tracer le rectangle de couleur .................*/    
 Deffill(indice_color,1,0);                                          
 vswr_mode(VDIhandle,MD_REPLACE);
 vectxy[0] = coord.left   + 30;
 vectxy[1] = coord.top    + 2;
 vectxy[2] = coord.right  - 1;
 vectxy[3] = coord.bottom - 1;  
 
 xr=(vectxy[2]-vectxy[0])>>1;
 yr=(vectxy[3]-vectxy[1])>>1;
 v_ellipse( VDIhandle, vectxy[0] + xr, vectxy[1] + yr, yr, yr );   
 Defline(1,1,0,0,1);     
 Box(vectxy); 
 
 Deffill(0,1,0);
 vectxy[0] = coord.left+3;
 vectxy[1] = coord.top    + 3;
 vectxy[2] = coord.left+26;
 vectxy[3] = coord.bottom - 2;  
 vr_recfl(VDIhandle,vectxy);     
 Box(vectxy); 
 
 /*............ afficher le numero couleur........*/   
 vswr_mode(VDIhandle,MD_TRANS);      
 vst_font(VDIhandle,1);    
 vst_color (VDIhandle,1);
 vst_point(VDIhandle,  4, &i, &i, &i, &i);  
 vst_alignment (VDIhandle,0,ALI_TOP, &i, &i ); 
 v_gtext(VDIhandle,coord.left + 5, coord.top + 6 , itoa(indice_color,buft,10));               
   
 
 /*......... tracer le sillon de separation entre deux elements .........*/        
 /*          que si on affiche un element different de celui de          */
 /*                        la premiere ligne                             */
 if (ptLISTGETTXT->lign != -1)
    {vectxy[0]=coord.left;
     vectxy[1]=coord.top;     
     vectxy[2]=coord.right;
     vectxy[3]=vectxy[1];
     Defline(1,1,0,0,1);
     Line_p (vectxy[0],vectxy[1],vectxy[2],vectxy[3]);
     vsl_color(VDIhandle,0);
     Line_p (vectxy[0],vectxy[1]+1,vectxy[2],vectxy[3]+1);            
    } 
 return 1;       
}  

/*-------------------------- WindProcOnglet -----------------------------*/
CALLBACK WindProcOnglet(int w_ind, EVNT_O *Evnt)
{/*.............. les variables locales suivantes sont souvent ..........*/
 /*           utiles pour toutes les fonctions de fenetre EZGEM pour:    */
 int w_h;              /* handle de la fenetre de cette Wind_proc_xxx    */
 int wh_top;           /* handle de la fenetre en avant plan             */
 /*.............. variables locales specifiques  notre .................*/
 /*                  exemple de Ressource en fenetre                     */
 DLG_VAR *dlg;       /* structure attachee  chaque ressource en fenetre */
 
 /*.................. INITIALISER LES VARIABLES ....................*/
 dlg = &Windtab[w_ind].DlgVar;
 /*.................... recuperer handles ..........................*/    
 wind_get( 0, WF_TOP, &wh_top); /* celui de fenetre avant plan      */
 w_h = Windtab[w_ind].w_h;      /* celui de notre fenetre           */
                  
 /*...........................TOUCHE CLAVIER APPUYEE ...................*/
 if (Evnt->evnt & MU_KEYBD && w_h==wh_top)
    {Xform_keybd(w_ind, Evnt);
    } /* endif MU_KEYBD  et fenetre au premier plan */
    
 /*.......................... BOUTONS SOURIS ...........................*/  
 if (Evnt->evnt & MU_BUTTON)
    {Xform_button(w_ind, Evnt);                  
    } 

 /*.......................... TIMER ..................................*/  
 if (Evnt->evnt & MU_TIMER && w_h==wh_top)  
    {Xform_timer(w_ind);  
    }
    
 /*.......................... MOUVEMENTS SOURIS ......................*/   
 if (Evnt->evnt & MU_MOVE)   /*  (EZGEM evenement)   */
    {Xform_mu_move(w_ind, Evnt);
    }      
 /*.......................... MESSAGES GEM et EZGEM ..................*/     
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {case WM_CONSTRUCT:      /*  (EZGEM message)   */ 
             dlg->AdrRsc = LoadAppliRsc( "DIAL_EXP.RSC", NO_SCALE);  
             if ( dlg->AdrRsc )                                                               
                {dlg->type     = RSC_DIAL;
                 dlg->NumTree  = 0;      
                 Xform_construct(w_ind, Evnt);           
                }               
             else
                {return WM_ABORT;
                }             
             break;
                            
             
        case WM_DESTRUCT: 
             Xform_Destruct(w_ind, Evnt); 
             RscFicUnLoad(dlg->AdrRsc);    
             break;
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             SetBulleState(w_h, dlg->tree);
             break;               
        case WM_WND_MENU:       /*  (EZGEM message)   */        
             /*    
             switch(Evnt->pipe[X_G])
                {case TRANSM_MEN_QUIT:
                      EZGemRun=0;  
                      break;                       
                }  
             break;
             */             
        case WM_REDRAW:  
             Lister_rectangles(w_h,(GRECT*)&Evnt->pipe[X_G]);             
             break;
                 
        case WM_PAINT:             
             {/*....... effacer espace de travail ..........................*/   
              /* ICI JE TRACE LE RECTANGLE ESPACE DE TRAVAIL INTERIEUR AU   */
              /*             BORD EPAIS ET  LA RESSOURCE                   */
              vswr_mode(VDIhandle,MD_REPLACE);
              vsf_color( VDIhandle, 0 );           /* modifi par objc_draw         */
              vsf_interior(VDIhandle,0);                      
              GrectPbox((GRECT*)&Evnt->pipe[X_G]);                                                                                                                                                                                                    
             }               
             break;                                   
       case WM_BOTTOM:
             wind_set(w_h, WF_BOTTOM );             
             break;                              
       case WM_TOPPED:
             wind_set(w_h, WF_TOP );             
             break;
        case WM_CLOSED:
             CloseWindow(w_ind);                                        
             break;
        case WM_ALLICONIFY:    
             AllIconify(0L);
             break;
        case WM_ICONIFY:
             IconifyWindow(w_ind, 0L);
             break;                                                    
        case WM_UNICONIFY:
             UnconifyWindow(w_ind);            
             break; 
        case WM_FULLED: 
             OnWm_fulled( w_ind, Evnt);  
             break;     
        case WM_SIZED:    
             OnWm_sized(w_ind, Evnt);  
             break;            
        case WM_MOVED:
             OnWm_moved(w_ind, Evnt);
             break;            
       }
    }      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}

/*---------------------------- MakeStrInfoOb --------------------------------*/
/* ACTION: cette fonction sert  creer le texte de la bulle d'aide affichant */
/*         le numero de l'objet et ceux de sa descendance                    */

char *MakeStrInfoOb(void* adr_rsc, int num_tree, int num_ob, char *sztt_txt)
{char strnum[32];
 OBJECT *object;
 
 xrsrc_gaddr (R_TREE, num_tree, &object, adr_rsc); 
 strcpy(sztt_txt, "Objet:         ");
 strcat(sztt_txt,itoa(num_ob,strnum,10) ); 
 strcat(sztt_txt,"|Ob_Frere:      "); 
 strcat(sztt_txt, itoa(object[num_ob].ob_next,strnum,10) ); 
 strcat(sztt_txt,"|Ob_First fils: "); 
 strcat(sztt_txt, itoa(object[num_ob].ob_head,strnum,10) ); 
 strcat(sztt_txt,"|Ob_Last  fils: "); 
 strcat(sztt_txt, itoa(object[num_ob].ob_tail,strnum,10) );
 return 0; 
}

/*------------------------- NumFuncToIndObject -------------------------------*/
/* ACTION: retourne le numero d'objet correspondant  la fonction passee en   */
/*         entree                                                             */
int NumFuncToIndObject(OBJECT* object, int num_func)
{int i=-1;
 int fils;
 char buft[32];
 char *sztt_txt;
 char *pt_txt;
 do{i++;
    if (object[i].ob_tail != -1 )
       {fils = object[i].ob_tail;
        if (object[fils].ob_type == G_STRING &&     /* Si G_STRING    */
            object[fils].ob_state & 0x8000          /* Si chaine Help */
           )
           {sztt_txt = ObjcGetTxt(object,fils);
            pt_txt = strchr(sztt_txt,'|');
            if (pt_txt)
               {*pt_txt=0;
                strcpy(buft,sztt_txt);
                *pt_txt='|';
                StrTrimEnd(buft);        /* enlever espaces de fin   */
                pt_txt=StrTrimDeb(buft); /* enlever espaces de debut */
                if (*pt_txt>='0' && *pt_txt<='9')
                   {if (num_func==atoi(pt_txt)) return i;
                   }
               }    
           }
       }
   }while ( ! (object[i].ob_flags & LASTOB));
 return -1;
}   

/*----------------------- FindTitlePopup ---------------------------*/
int FindTitlePopup(OBJECT *object)
{int i;
 i=-1;
 do{i++;
    if (object[i].ob_state&0x4000    && /* si bit 14 ob_state */
        object[i].ob_type & G_STRING
       )
       {return i;    
       } 
   } while ( ! (object[i].ob_flags & LASTOB) );
 return i;   
}

/*-------------------------- FindSousMenu --------------------------*/
int FindSousMenu(void *AdrRscTool, char *name)
{RSXHDR *rsxhd;
 OBJECT *object;
 int i,ind_tree, nb_tree;
 int tree_find=-1;
 char *pt_txt;
 char buft[256]; 
 rsxhd=(RSXHDR*)((char*)AdrRscTool+sizeof(int)*16);
  
 nb_tree = (int)rsxhd->rsh_ntree;
 for (ind_tree = 0; ind_tree < nb_tree; ind_tree++)
     {xrsrc_gaddr (R_TREE, ind_tree, &object, AdrRscTool);
      i=-1;
      do{i++;
         if (object[i].ob_state&0x4000    && /* si bit 14 ob_state */
             object[i].ob_type & G_STRING
            )
            {strcpy(buft,ObjcGetTxt(object,i));
             StrTrimEnd(buft);        /* enlever espaces de fin   */
             pt_txt=StrTrimDeb(buft); /* enlever espaces de debut */
             if (strcmp(name,pt_txt)==0) tree_find = ind_tree;      
            } 
        } while ( ! (object[i].ob_flags & LASTOB) );
     }
 return tree_find;
}
 
/*--------------------- IsThisObjectExecutive ----------------------------*/
int IsThisObjectExecutive(OBJECT *object, int ind)
{int i,u;
 char *sztt_txt, *pt_txt, buft[32];
 if (object[ind].ob_tail != -1 )   /* si objet   a un fils       */
    {u=object[ind].ob_tail;                 /* de type G_STRING help      */             
     /*........ si objet type numero option ....................*/
     if (object[u].ob_type == G_STRING &&     /* Si G_STRING    */
         object[u].ob_state & 0x8000          /* Si chaine Help */
        )
        {sztt_txt = ObjcGetTxt(object,u);
         pt_txt = strchr(sztt_txt,'|');
         if (pt_txt)
            {*pt_txt=0;
             strcpy(buft,sztt_txt);
             *pt_txt='|';
             StrTrimEnd(buft);        /* enlever espaces de fin   */
             pt_txt=StrTrimDeb(buft); /* enlever espaces de debut */
             if (*pt_txt>='0' && *pt_txt<='9')
                { i=atoi(pt_txt);
                  if (i>0) return i;
                } /* end if *pt_txt>='0' && *pt_txt<='9' */
            } /* endif pt_txt == "|"  */  
        }  /* endif G_TRING && 0x8000 */
    }  /* endif object[ind].ob_tail != -1 */
 return 0;
}    

/*-------------------------- ActiveWindow -------------------------------*/
void ActiveWindow(int ident, long attr, char *title, CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt))
{int w_ind;
 w_ind = IsWindExist(ident);
 if (w_ind==-1)                 /* << SI existe pas la creer         */
    {CreateWindow(attr, ident,0L,w_proc, 0,20+((Ecran_h-20)>>1),Ecran_l,(Ecran_h-20)>>1, title);
    }
 else                           /* << SI elle existe                  */
    {if (IsWindOpen(w_ind))     /*        SI ouverte la mettre au top */
        {wind_set(Windtab[w_ind].w_h,WF_TOP);
        }
     else                       /*        SI pas ouverte l'ouvrir     */
        {OpenWindow(w_ind, &Windtab[w_ind].ExtGrectUse);
        } 
    } 
}