/*/////////////////////////////////////////////////////////////////////*/
/*//////////////////////////   RSC_POPU.C    //////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
/* Ce module est le source C du MODULE: RSC_POPU.O                     */
/*                                                                     */
/* Le fichier projet associ est:          RSC_VIEW.PRJ                */
/* dans lequel nous pouvons voir que ce Programme comporte deux        */
/* modules:                                                            */
/*                                   RSC_VIEW.C  gerant la fenetre     */
/*    principale. La compilation de ce module donne RSC_VIEW.O         */
/*                                                                     */
/*                                   RSC_INFO.C gerant la fenetre      */
/*    d'information.  La compilation de ce module donne RSC_INFO.O     */
/*                                                                     */
/*                                   RSC_POPU.C gerant la fenetre      */
/*    d'information.  La compilation de ce module donne RSC_POPU.O     */
/*                                                                     */
/* Lors de la phase de linkage ces deux modules seront lis pour       */
/* former le programme final RSC_VIEW.APP                              */ 
/*                                                                     */
/* le source C ci-dessous est est celui du module: RSC_POPU.O          */
/* Gestion d'une boite d'information (SCROLLBOX) affichant un petit    */
/* texte d'information sur le mode d'emploi du programme.              */

/*/////////////////////////////////////////////////////////////////////*/
/*////////////////////////// I N C L U D E S //////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
/*--------------------- INCLUDES DES AUTRES MODULES DU PROGRAMME -------*/
#include <EAZY_GEM.H>  /* inclure les definitions des fonctions que le  */
                       /* que le module EAZY_GEM.LIB met  votre et     */
                       /* notre disposition                             */ 
                       /* et inclure les definitions des variables      */
                       /* globales  d'EAZY_GEM                          */
                       /* Je rappelle que le fichier EAZY_GEM.H et le   */
                       /* fichier EAZY_GEM.LIB doivent se trouver dans  */
                       /* les repertoires INCLUDE (pour le .H) et LIB   */
                       /* (pour le .LIB) de votre Pure C.               */ 
/* C'est  cause de cette ligne que vous avez le droit d'utiliser les   */
/* fonctions d'EAZY_GEM.                                                */                       
/* La lecture de ce fichier peut vous renseigner sur tout un tas de     */
/* choses. Il est toujours instructif de regarder les fichiers .H       */

/*--------------------- INCLURE LES DEFINITIONS SYMBOLIQUES ------------*/
/*                      que l'diteur de ressource gnre               */
/*                      lors de la cration de la ressource             */
#include "RSC_VIEW.SYS\FR_STR.H"    
#include "RSC_VIEW.SYS\RSC_MENU.H"
                      /* l'inclusion des dfinitions symboliques permet */
                      /* d'utiliser des symboles literaux plus parlants */
                      /* qu'un nombre, pour les numero d'objets.        */
                      /* Il est vident qu'il est impratif de nommer   */
                      /* les objets dans votre editeur de ressources    */
                      /* pour que le fichier.H correspondant soit       */
                      /* interessant.                                   */
/*//////////////////////////////////////////////////////////////////////*/
/*////////////////////////// D E F I N E S  ////////////////////////////*/
/*//////////////////////////////////////////////////////////////////////*/ 
/*                         TYPAGE DES FENETRES                          */ 
/*----------------------------------------------------------------------*/ 
/* Dans EAZY_GEM, chaque fenetre doit avoir un numro unique. Celui-ci  */
/* permet par la suite d'interroger EAZY_GEM pour savoir si la fenetre  */
/* correspondant  ce numero existe, ou est ouverte, ou etc....         */
/* Par exemple j'cris un programme comportant deux dialogues: un pour  */
/* parametrer les couleurs, et un autre affichant un choix de trames    */
/* couleurs. Chacun de ses dialogues tant dans une fenetre diffrente, */
/* lorsque je modifie les couleurs avec le premier dialogue, il faut    */
/* repercuter la modification de couleur, sur tous les autre dialogues  */
/* concerns afin de les mettre  jour. Pour cela il me faut savoir si  */
/* ils existent, et sont ouverts, et auquel cas les mettre  jour, et   */
/* envoyer un message leur demandant de reafficher les lments         */
/* concerns par la modification du premier dialogue.                   */
/* On peut appeler a grer les multi-dpendances inter-dialogue.       */

/* Plutot que de manipuler un nombre abstrait qui ne me dit rien  je    */
/* prfre dfinir un symbole plus parlant, que j'utiliserai par la     */
/* suite dans le programme  la place du nombre, d'ou les lignes:       */
/* #define ci_dessous. (ici deux lignes car deux fenetres)              */      
 
#define W_RESSOURCE   1     /* (identificateur ou type) de la Fenetre   */
                            /* on peut choisir n'importe quel nombre    */
                            /* entre 1 et 32000 ('est assez non ?)     */
                            /* Il est impratif que deux fenetres n'    */
                            /* aient pas le meme nombre.                */
#define W_RINFO       2     /* ID Fenetre information traitee dans le   */
                            /* module RSC_INFO.C                        */
#define W_POPUP       3     /* ID Fenetre menu popup                    */  

#define EXE_QUIT       0
#define EXE_NEXT_TREE  1
#define EXE_PREV_TREE  2
#define EXE_OPEN       3
#define EXE_INFO       4
#define EXE_BULONOFF   5
#define EXE_POPUP      6
                          
/*//////////////////////////////////////////////////////////////////////*/
/*////////////// V A R I A B L E S    G L O B A L E S //////////////////*/
/*//////////////////////////////////////////////////////////////////////*/
int static TimFlash = 0;
int static ObPopupSel = -1;  /* element popup selectionn               */
extern char  **PtStrMess;    /* tableau des messages de FR_STR.RSC      */
extern void *AdrStdMenu;     /* adresse rsc menu GEM et POPUP           */
/*//////////////////////////////////////////////////////////////////////*/
/*/////////////// P R O T O T Y P E S  F O N C T I O N S ///////////////*/
/*//////////////////////////////////////////////////////////////////////*/

/*................ FONCTIONS CALLBACK DE FENETRES ......................*/
/* Dans EAZY_GEM,  chaque fenetre est associe une fonction CALLBACK.  */
/* CALLBACK veut dire mot  mot: appel arrire, en plus clair une       */
/* fonction CALLBACK, veut dire une fonction de rappel.                 */
/* Le principe est que vous DONNEZ  EAZY_GEM l'adresse de la fonction  */
/* de gestion qui va grer la fenetre que vous dsirez ouvrir, et que   */
/* c'est EAZY_GEM, qui RAPELLERA votre fonction selon les diffrentes   */
/* actions et vnements la concernant. L'intrt c'est qu'EAZY_GEM     */
/* traite pour vous tout un tas de choses ennuyeuses et difficiles, et  */
/* qu'il vous fait signe et laisse  votre charge ce qu'il ne peut pas  */
/* traiter ni prvoir, en rappelant votre fonction.                     */
/* Cette faon de faire permet aussi une meilleure structuration des    */
/* programmes car pour chaque fenetre il existe une seule fonction de   */
/* traitement.                                                          */
/* Toute la messagerie et l'vnementiel GEM classique est transmis    */
/* la fonction CALLBACK de Fenetre, plus d'autres messages spcifiques  */
/*  EAZY_GEM, que nous verons petit  petit dans les exemples.         */
/* En rponse aux messages et vnements GEM il est possible de les     */
/* traiter tout  fait classiquement, ou comme je vous le conseille de  */
/* faire appel aux fonctions qu'EAZY_GEM met  votre disposition.       */
/* L'accs aux fonctions tendues de gestion de ressource en fenetre et */
/* autres aspect pointus d'EAZY_GEM ne se fait bien videment qu'au     */
/* travers des fonctions prvues pour cela.                             */
/*                                                                      */
/* Ces principes de programmation peuvent apparaitre difficiles pour    */
/* ceux qui n'y sont pas habitus, mais aprs un effort d'adaptation    */
/* minime, l'on regrette de ne pas l'avoir fait avant, tellement la     */
/* programmation sous GEM semble ensuite facile !!!.                    */ 

/* ICI je dclare le nom et le prototype de la fonction de fenetre qui  */
/* traitera tout ce qui concerne la fenetre que l'on va ouvrir.         */

CALLBACK WindProcPopup(int w_ind, EVNT_O *Evnt);

/*//////////////////////////////////////////////////////////////////////*/
/*                A   C O M M E N C E   I C I   !!!!                   */
/*              Definition des fonctions de ce module                   */
/*//////////////////////////////////////////////////////////////////////*/

/*------------------------------ WindProcPopup --------------------------*/
/* Affiche la boite d'information du programme                           */        
CALLBACK WindProcPopup(int w_ind, EVNT_O *Evnt)
{int w_h;              /* handle de la fenetre de cette Wind_proc_xxx    */
 int wh_top;           /* handle de la fenetre en avant plan             */
 DLG_VAR *dlg;       /* structure attachee  chaque ressource en fenetre */
 OBJECT *object;
 /*.................. INITIALISER LES VARIABLES ....................*/
 dlg = &Windtab[w_ind].DlgVar;
 object = GETWINDTREE(w_ind);
   
 /*.................... recuperer handles ..........................*/    
 wind_get( 0, WF_TOP, &wh_top); /* celui de fenetre avant plan      */
 w_h = Windtab[w_ind].w_h;      /* celui de notre fenetre           */
 
 if (Evnt->evnt & MU_KEYBD && w_h==wh_top)
    {Xform_keybd(w_ind, Evnt);        
     Evnt->evnt &= ~MU_KEYBD;                   
    }
    
 if (Evnt->evnt & MU_BUTTON )
    {int ob_ret,i;     
     ob_ret = Xform_button(w_ind, Evnt);
     i = -1;  
     switch (ob_ret)
        {case POPUP_LOAD:    i = EXE_OPEN;        break;
         case POPUP_NEXT:    i = EXE_NEXT_TREE;   break;
         case POPUP_PREV:    i = EXE_PREV_TREE;   break;
         case POPUP_INFO:    i = EXE_INFO;        break;
         case POPUP_QUIT:    i = EXE_QUIT;        break;
         case POPUP_BULLE:   i = EXE_BULONOFF;    break; 
         case POPUP_CLOSER:  SendWindMessage(w_h, WM_MODAL_END, 0L);  break;                
        } 
     if (i>-1)
        {/*
         object[ob_ret].ob_state |= SELECTED; 
         Wobjc_draw(w_ind,object, ob_ret, 3, 0); 
         */
         if (Evnt->k==2) SendWindMessage(w_h, WM_MODAL_END, 0L);
         SendExeFunc(Appl_id, i);
         Evnt->evnt &= ~MU_BUTTON;   /* empecher propagation message  MU_BUTTON */
        }               
    } /* endif MU_BUTTON  et fenetre au premier plan */

 if (Evnt->evnt & MU_TIMER && w_h==wh_top)  
    {Xform_timer(w_ind);  
     TimFlash ++;
     if (TimFlash>=15)
        {TimFlash = 0;
         if (!MenTTBack) /* si bulle d'aide non active  */
            {object[POPUP_CLOSER].ob_state ^= SELECTED;  
             Wobjc_draw(w_ind,object, POPUP_CLOSER, 3, 0); 
            }
        }  
    }
 if (Evnt->evnt & MU_MOVE)   
    {int ob_ret;
     Xform_mu_move(w_ind, Evnt);
     if ( (ob_ret = objc_find(object,0,10,Evnt->x,Evnt->y)) != -1)
        {if (ob_ret > 0                       &&
             ob_ret != ObPopupSel             &&
             GET_XOBTYPE(object,ob_ret) != 105
            )
            {object[ObPopupSel].ob_state &= ~SELECTED; 
             Wobjc_draw(w_ind, object, ObPopupSel, 3, 0); 
             ObPopupSel = ob_ret;
             object[ObPopupSel].ob_state |= SELECTED; 
             Wobjc_draw(w_ind, object, ObPopupSel, 3, 0); 
            }
        }
    }      
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {case WM_CONSTRUCT:
             if (WindDialogConstruct(w_ind, AdrStdMenu, RSC_POPUP, RSC_DIAL, Evnt 
                                    ) == WM_ABORT
                ) return WM_ABORT;
             ObPopupSel    = POPUP_LOAD;
             AdjustWindCoordToScreen (w_ind, Evnt, (GRECT*)&Evnt->pipe[X_B]); 
             break;
                                         
        case WM_DESTRUCT:       /*  (EZGEM message)   */
             object[ObPopupSel].ob_state &= ~SELECTED; 
             Xform_Destruct(w_ind, Evnt);                           
             break;            
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             SetBulleState(w_h, dlg->tree);
             break;    
        case WM_REDRAW:               
             Lister_rectangles(w_h,(GRECT*)&Evnt->pipe[X_G]);                          
             break;    
        case WM_BOTTOM:
             wind_set(w_h, WF_BOTTOM );             
             break;                               
        case WM_TOPPED:
             wind_set(w_h, WF_TOP );             
             break;
        case WM_MODAL_END:
             DestroyWindow(Windtab[w_ind].w_h); /* destruction fenetre     */
             break;     
        case WM_CLOSED:
             SendWindMessage(w_h, WM_MODAL_END,0);
             break;
        case WM_ALLICONIFY:    
             AllIconify(0L);
             break;     
        case WM_ICONIFY:
             IconifyWindow(w_ind, 0L);
             break;                                                    
        case WM_UNICONIFY:
             UnconifyWindow(w_ind);            
             break;                                        
        case WM_SIZED:    
        case WM_MOVED:
             Xform_moved(w_ind, Evnt);                                     
             break;                                                                                     
       }
    }      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}

