/*///////////////////////////// RSC_VIEW //////////////////////////////*/
/* EXEMPLE d'utilisation et de creation d'un programme utilisant les   */
/*                         fonctions EZ_GEM                            */
/* Ce module est celui comportant la fonction main et donc c'est le    */
/* point d'entree du programme                                         */
/* Ce programme d'exemple est un mini VIEWER de Ressource, permet      */
/* de visualiser toutes les ressources NORMALES (certaines plantent de */
/* par certains conflits pour les objets etendus...) et les ressources */
/* EAZY_GEM representes telles qu'elles se presentent sous EAZY_GEM   */
/* Ce programme peut etre lanc soit comme programme soit comme        */
/* accessoire.                                                         */
/*/////////////////////////////////////////////////////////////////////*/
/*////////////////////////// I N C L U D E S //////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
/*--------------------- INCLUDES DES AUTRES MODULES DU PROGRAMME ------*/
#include "EAZY_GEM.H"  /* inclure les definitions des fonctions que le */
                       /* que le module EAZY_GEM.C met  notre         */
                       /* notre disposition                            */ 
                       /* et inclure les definitions des variables     */
                       /* globales  EAZY_GEM                           */
/*.............. inclure les definitions qu'interface .................*/
/*                   cree pour les objets ressource                    */                       
#include "RSC_VIEW.SYS\RSC_MENU.H"
#include "RSC_VIEW.SYS\FR_STR.H"
/*/////////////////////////////////////////////////////////////////////*/
/*////////////////////////// D E F I N E S  ///////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/   
/* ici je mets tous les defines concernant ce module                   */
#define W_RESSOURCE    1      /* ID Fenetre ressource                  */
#define W_RINFO        2      /* ID Fenetre information traitee dans   */
                              /* le module RSC_INFO.C                  */
#define W_POPUP       3       /* ID Fenetre menu popup                 */ 
                              
#define EXE_QUIT       0
#define EXE_NEXT_TREE  1
#define EXE_PREV_TREE  2
#define EXE_OPEN       3
#define EXE_INFO       4
#define EXE_BULONOFF   5
#define EXE_POPUP      6
/*/////////////////////////////////////////////////////////////////////*/
/*////////////// V A R I A B L E S    G L O B A L E S /////////////////*/
/*/////////////////////////////////////////////////////////////////////*/

/* declarer ici les variables globales du programme                    */
  
void *AdrStdMenu=0;        /* adr. ou je chargerai la Ress. Menu       */
void *AdrRscDial=0;        /* adr. ou je chargerai la rsc dialogue     */

static char PathVABuff[256];      /* buffer pour nom path AV_START     */
char PathAppli[256];       /* stockera le path de demarrage            */
char PathDial[256];
char NomDial[14]="RSC_DIAL.RSC";
char  **PtStrMess = 0;         /* pointera sur tableau de message      */

static OBJECT *TreeMenu  = 0;  /* adresse arbre du menu   GEM          */
static char InfoClick    = 0;  /* informer si click sur objet          */   
static int AccMenID;           /* entree de menu octroyee lors demarrage en accessoire  */
static void      *StrMes = 0;  /* pointera sur l'adresse du ressource messages          */
static long MemTimer     = 0;
static DOSTIME Dos_time;
DID_HELP VIEWHLP;      /* structure d'aide que l'on doir remplir avant  */
                       /* d'appeler l'accessoire DIDEROT                */            

/*............. Declarer le nom de notre programme ....................*/

/*/////////////////////////////////////////////////////////////////////*/
/*/////////////// P R O T O T Y P E S  F O N C T I O N S //////////////*/
/*/////////////////////////////////////////////////////////////////////*/

/* declarer ici les fonctions du programme                             */
/*......... procedures specifiques  un programme EZ_GEM ..............*/

void main (void);
static CALLBACK MessageProcedure(int w_ind, EVNT_O *Evnt);
static int MenuProcedure(int w_ind, EVNT_O *Evnt);
static CALLBACK WindProcDialogue(int w_ind, EVNT_O *Evnt);
void ActiveWindow(int ident, long attr, char *title, 
                         CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt));

/*...... procedures non specifiques  un programme EZ_GEM .............*/
static char *MakeStrInfoOb(void* adr_rsc, int num_tree, int num_ob, char *sztt_txt);

/*.............. declarer fonction du module RSC_INFO.C ...............*/
extern CALLBACK WindProcInfo(int w_ind, EVNT_O *Evnt);
/*.............. declarer fonction du module RSC_POPU.C ...............*/
extern CALLBACK WindProcPopup(int w_ind, EVNT_O *Evnt);                      
/*//////////////////////////////////////////////////////////////////////*/
/*                A   C O M M E N C E   I C I   !!!!                   */
/*              Definition des fonctions de ce module                   */
/*//////////////////////////////////////////////////////////////////////*/

/*---------------------------- main ------------------------------------*/
/* premiere fonction appelee, c'est le point d'entree du programme      */ 
void main (void)
{char path[256];
 /*........ Appeler la fonction: InitEazyGem avant toute utilisation......*/
 /*         des fabuleuses possibilites offertes par EZ_GEM               */
 /* Elle declare notre programme  EZ_GEM,                                */
 /* Initialise l'application et son identificateur GEM: Appl_id,          */
 /* Ouvre une station de travail VDI dont le handle est: VDIhandle,       */
 /* initialise tout un tas de variables globales ncessaires  EAZY_GEM   */  
 MAX_WIND = 4;      
 if (InitEazyGem("RSC_VIEW.???") != -1)   
    {*PathVABuff = 0;
     /*.............. voir si on a demarre avec un fichier ..............*/  
     GetPathAppli(PathAppli, NomAppli, PathVABuff);
     
     /*............. si pas de fichier au demarrage .....................*/
     /*            demarrer avec le fichier .RSC par defaut              */          
     if (!(*PathVABuff))
        {strcpy(path, PathAppli);
         if (FindFicSys(path, NomAppli, NomDial)>0)
            {strcpy(PathVABuff, path);
             strcat(PathVABuff,NomDial);
            }
        }
            
     /*............. charger le ressource message .......................*/
     /* en effet tous les textes et messages de ce programme sont dans   */
     /* fichier de ressource ne contenant que des STRING                 */    
     StrMes    = LoadAppliRsc( "FR_STR.RSC", SCALE);              
     PtStrMess = GetFreeStringTab(StrMes);   
     /*............. charger le menu GEM et popup .......................*/
     AdrStdMenu = LoadAppliRsc( "RSC_MENU.RSC", SCALE); 
     
     /*.................... Demarrer selon ACC ou PRG ...................*/
     if (!_app)  
        {/*....... si demarre en accessoire installer le titre ds menu...*/
         /*               et attendre le message AC_OPEN                 */
         AccMenID = menu_register( Appl_id, PtStrMess[RSC_PRG_NAME]);                 
        }
     else
        {/*......... Si demarre en programme ............................*/
         /*    on installe un menu minimum pour acceder aux accessoires  */         
         int msgbuf[8];   
                      
         if (AdrStdMenu) 
            {/*............ recuperer adresse menu GEM .....................*/
             /*           que si demarr en application                     */    
             xrsrc_gaddr (R_TREE, MENU_GEM, &TreeMenu, AdrStdMenu);
             menu_text( TreeMenu, TITLE_BUREAU, PtStrMess[RSC_PRG_NAME] );
             menu_bar ( TreeMenu,1);   /* installer le menu GEM minimum     */             
            }    
         /*......... on va envoyer un faux message AC_OPEN .................*/
         /*            afin d'ouvrir d'emble la fenetre                    */
         AccMenID = 12345;        /*   creer une entree de menu fantaisie   */
         msgbuf[MESG]=AC_OPEN;    /*   nature du message                    */
         msgbuf[APPL]=Appl_id;    /*   iddentificateur de l'appelant (moi)  */
         msgbuf[SUPL]=0;          /*   message sans surplus                 */
         msgbuf[4]=AccMenID;      /*   placer entree de menu declenchante   */
         appl_write(Appl_id, 16, msgbuf ); 
        }        
     /*.................... Passer la main  EAZY_GEM ....................*/
     /*................. en Executant la boucle programme ................*/     
     /* en parametre je donne le nom de la fonction qui va    */
     /* traiter les messages par defaut. Cela permet de faire */
     /* fonctionner le programme meme si aucune fenetre n'est */
     /* ouverte, et de traiter tous les messages communs au   */
     /* programme au meme endroit.                            */
     /* Si l'on ne veut pas utiliser cette possibilit il faut*/
     /* mettre 0L en parametre d'entree et ouvrir une fenetre */
     /* (avec la procedure de fenetre allant avec) qui gerera */
     /* les messages. Dans ce cas le programme s'arrete lors  */
     /* de la destruction de la derniere fenetre.(faute de    */
     /* fonction de traitement des messages !!)               */
     /* Lorsque cette fonction existe et que des fenetres sont*/
     /* ouvertes, les messages sont d'abord envoys  la      */
     /* fonction, puis ensuite aux fenetres. La fonction peut */
     /* empecher cette transmission aux fenetres en retournant*/
     /* zero. (Les fonctions de fenetres peuvent aussi faire  */
     /* de meme). Cette possibilit permet d'eviter qu'un     */
     /* message inutile aux autres fonctions de fenetre soit  */
     /* transmis.                                             */
     if (AccMenID != -1)  BouclePrincipale(MessageProcedure);  
     
     /*.............. liberer les ressources .................*/   
     RscFicUnLoad(AdrRscDial); /* de la boite de dialogue     */ 
     if (AdrStdMenu)           /* du menu GEM                 */
        {if (TreeMenu) menu_bar(TreeMenu,0);          
         RscFicUnLoad(AdrStdMenu); 
        }      
    }
 /*........ indispensable appel pour finir un programme ......*/
 /*             EZ_GEM proprement                             */ 
 ExitEasyGem();   
}

/*------------------------ MessageProcedure ------------------------------*/
/* ACTION: cette procedure est chargee de gerer les evenements message.   */
/*         Cette gestion peut se faire aussi au niveau de chaque fenetre  */
/*         auquelles sont transmises les evenements message.              */
/*         Cette procedure reoit les messages en premier avant les       */
/*         procedures de fenetre.                                         */
/*         il est possible d'empecher la transmission du message aux      */
/*         procedures de fenetre, en retournant zero.                     */
/*         Cette procedure est utile pour traiter les messages communs   */
/*         toute l'application meme si aucune fenetre n'est ouverte       */
/*         c'est en quelque sorte une procedure de traitement par defaut  */

static CALLBACK MessageProcedure(int w_ind, EVNT_O *Evnt)
{w_ind++;   /* utiliser cette variable pour calmer le compil              */
 
 if (Evnt->evnt & MU_TIMER)            
    {
      MemTimer++;
      if (MemTimer>50) 
         {DOSTIME dos_time;
         char path[256];
         int fh;
         /*.............. relever la date ...............*/ 
         strcpy(path, PathDial);
         strcat(path, NomDial);
         fh = (int)Fopen( path, FO_RW );
         if (fh)
            {Fdatime( &dos_time, fh, 0);            
             Fclose(fh); 
            }          
          MemTimer=0;
          if (fh && *(long*)&dos_time > *(long*)&Dos_time)
             {/* strcpy(PathVABuff,path); */
              /* Send_VA_START(Appl_id, PathVABuff); */
              int ind;                         
              /*...............si fenetre ouverte ...........................*/
              ind = IsWindExist(W_RESSOURCE);
              if (ind != -1 && IsWindOpen(ind))       
                 {DLG_VAR dlg;
                  Dos_time = dos_time;    
                  dlg = Windtab[ind].DlgVar;   
                  Xform_Destruct(ind, Evnt);  /* desintegrer l'arbre de ress.*/
                  RscFicUnLoad(AdrRscDial);        
                  AdrRscDial = RscFicLoad(PathDial, NomDial, SCALE);
                  if (WindDialogConstruct(ind, 
                                          AdrRscDial, 
                                          dlg.NumTree, 
                                          RSC_DIAL, 
                                          Evnt 
                                          ) != WM_ABORT
                     )
                     {SetWindowSize(ind, (GRECT*)&Evnt->pipe[X_B]);
                      SendWindRedraw(Windtab[ind].w_h); 
                     }                                
                 } /* endif (ind != -1)                                */                                             
             } /* endif (fh && *(long*)&dos_time > *(long*)&Dos_time) */              
         } /* endif (MemTimer>50)                                    */
    }    /* endif (Evnt->evnt & MU_TIMER)                           */ 
 
 if (Evnt->evnt & MU_KEYBD)
    {char car, scan;
     int i;
     scan = (char) (Evnt->key>>8); 
     car  = (char) ScanToAscii(Evnt->key, Evnt->ksp);
     if (scan == 0x62)   /*.......... si HELP appuyee .............*/
        {SendWindMessage(Windtab[w_ind].w_h, AID_REQUEST, 0L);       
        }                /*.......... si CONTROL appuyee ..........*/
     else if (Evnt->ksp & K_CTRL)
        {car|=' ';
         switch (car|' ')
           {case 'i':  i   = EXE_INFO;
                       car = 0; 
                       break;
            case 'q':  car = 0; 
                       i   = EXE_QUIT;
                       break; 
            case 'o':           
            case 'l':  car = 0;
                       i   = EXE_OPEN;
                       break; 
            case 'w':                        
            case '+':  car = 0;  
                       i   = EXE_NEXT_TREE;  
                       break; 
            case '<':                        
            case '-':  car = 0;    
                       i   = EXE_PREV_TREE;    
                       break;   
            case 'b':                        
            case 't':  car = 0;    
                       i   = EXE_BULONOFF;    
                       break;                          
           }
         if (car==0)                 
            {SendExeFunc(Appl_id, i);                    
             Evnt->evnt &= ~MU_KEYBD;   /*  annuler evenement clavier */
            } 
        } /* end switch */                                      
    } 
 
 if (Evnt->evnt & MU_MESAG) 
    {switch (Evnt->pipe[MESG])
       {case AC_OPEN:
             if (Evnt->pipe[4] == AccMenID)
                {Send_VA_START(Appl_id, PathVABuff); 
                }
             break;
             
        case AC_CLOSE:
             if (!_app)
                {if (Evnt->pipe[3] == AccMenID)
                    {w_ind = IsWindExist(W_POPUP); 
                     if (w_ind>-1) SendWindMessage(Windtab[w_ind].w_h, WM_MODAL_END, 0);
                     ExeAllMessage(); 
                     w_ind = IsWindExist(W_RINFO); 
                     if (w_ind>-1) SendWindMessage(Windtab[w_ind].w_h, WM_CLOSED, 0);
                     ExeAllMessage();   
                     w_ind = IsWindExist(W_RESSOURCE); 
                     if (w_ind>-1) 
                        {DestroyWindow(Windtab[w_ind].w_h); 
                         RscFicUnLoad(AdrRscDial);                
                         AdrRscDial = 0;             
                                    
                        }                    
                    }
                }                        
             break;     
         /*****************************************************************************/
        /*......................... AID_REQUEST (EZGEM message)......................*/
        /* DIDEROT nous demande une aide et une reference pour la fenetre au dessus  */
        /* de laquelle la souris se trouve.                                          */
        /* Ce message est structure comme suit:                                      */
        /*                                                                           */ 
        /* En: Evnt->pipe[MESG] on trouve le message AID_REQUEST (1502)              */
        /*     Evnt->pipe[APPL] on trouve l'ID de l'appli demandeuse(DIDEROT ou nous)*/              
        /*     Evnt->pipe[SUPL] on trouve  0                                         */
        /*     Evnt->pipe[WHND] se trouve le handle de la fenetre pour laquelle      */
        /*                      DIDEROT aimerait qu'on lui renvoie un fichier d'aide */
        /*                                                                           */   
        /* La reponse consiste a renvoyer a DIDEROT l'adresse d'une structure:       */
        /* DID_HELP remplie avec les parametres permettant a DIDEROT d'afficher      */
        /* l'aide demandee.                                                          */
        /* La fonction EAZY_GEM: DiderotHelpReply() fait tout ce travail a notre     */
        /* place                                                                     */
        case AID_REQUEST: 
             {int ref;
              ref   = 0;	
              w_ind = IdentToIndice(W_RESSOURCE);
              DiderotHelpReply(w_ind,         /* indice de la fenetre pour laquelle  */
                                              /* je fourni l'aide "RSC_VIEW.AID"     */ 
                               Evnt,           /* transmettre les evenements.         */
                               &VIEWHLP,       /* placer adresse variable d'aide.     */   
                               "RSC_VIEW.AID", /* nom du fichier d'aide.              */
                               ref,            /* placer la reference.                */
                               400,            /* largeur de la fenetre.              */ 
                               500);			        /* hauteur de la fenetre.              */ 
             }                
			         	break;
			         	
         case WM_EXEFUNC:        /*  (EZGEM message)   */
             /**************************************************************/              
             /*...................... WM_EXEFUNC .(EZGEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois qu'il est demand d'executer une fonction referencee  */
             /* par un numero de fonction.                                 */
             /* Le message est compose comme suit:                         */
             /* SI  Evnt->pipe[WHND]= RSC_DIAL; le message provient d'une  */
             /*                             ressource.  ET ALORS           */                     
             /*     Evnt->pipe[X_G] = indice objet declenchant le message  */
             /*     Evnt->pipe[Y_G] = numero de la fonction referencee     */
             /*     *(long*)&Evnt->pipe[W_G] =  adr arbre ou est l'objet   */      
             /* SI  Evnt->pipe[WHND]= 0; le message ne provient pas d'une  */
             /*                             ressource.  ET ALORS           */
             /*     Evnt->pipe[Y_G] = numero de la fonction referencee     */ 
             if (Evnt->pipe[WHND] == 0)
                {switch (Evnt->pipe[Y_G])
                   {case EXE_POPUP:
                         break;
                    case EXE_BULONOFF:
                         SendMessage(WM_TT_ON_OFF);          
                         break;
                    case EXE_INFO:
                         ActiveWindow(W_RINFO, XMOVER|BORDER, PtStrMess[RSC_WINF_TITLE],WindProcInfo);   
                         break;
                    case EXE_QUIT:
                         if (!_app)
                            {int ind;
                             ind = IsWindExist(W_POPUP); 
                             if (ind>-1) SendWindMessage(Windtab[ind].w_h, WM_MODAL_END, 0);
                             ExeAllMessage();                      
                             ind = IsWindExist(W_RINFO); 
                             if (ind>-1) SendWindMessage(Windtab[ind].w_h, WM_CLOSED, 0);
                             ExeAllMessage();   
                             ind = IsWindExist(W_RESSOURCE); 
                             if (ind>-1) SendWindMessage(Windtab[ind].w_h, WM_CLOSED, 0);                      
                            }
                         else 
                            {EZGemRun=-1;           /* sortir sans demande de confirmation */
                            }
                         break; 
                    case EXE_OPEN:
                         if (Fic_select (PathDial, NomDial, ".RSC", PtStrMess[RSC_LOAD])
                             >0L
                            )
                            {/* Une application comprenant le message VA_START doit pouvoir    */
                             /* s'activer et charger un document. Je m'envoie donc un message  */
                             /* VA_START avec le nom du fichier choisi afin de ne pas avoir   */
                             /* m'occuper ici du chargement, et de laisser le soin  la partie */
                             /* de programme qui s'en occupe de le faire (celle de VA_START).  */             
                             strcpy(PathVABuff, PathDial);
                             strcat(PathVABuff, NomDial);
                             Send_VA_START(Appl_id, PathVABuff);                           
                             }   
                         break;              
                    case EXE_NEXT_TREE:                                      
                    case EXE_PREV_TREE:  
                         {int ind;
                          DLG_VAR dlg;
                          RSXHDR *rsx_hdr;
                          ind = IsWindExist(W_RESSOURCE);     
                          if (AdrRscDial && ind != -1)  /* si fenetre ressource existe   */
                             {GRECT grect;
                              GetGemWindExtGRECT(Windtab[ind].w_h,&grect);
                                 
                              dlg = Windtab[ind].DlgVar;   
                              Xform_Destruct(ind, Evnt);  /* desintegrer l'arbre de ress.*/  
                              rsx_hdr   = (RSXHDR*)( (char*)AdrRscDial + sizeof(int)*16 );
                              if (Evnt->pipe[Y_G] == EXE_NEXT_TREE)
                                  dlg.NumTree = Min( (int) rsx_hdr->rsh_ntree - 1, dlg.NumTree + 1); 
                              else
                                  dlg.NumTree = Max( 0, dlg.NumTree - 1);                 
                              if (WindDialogConstruct(ind, 
                                          AdrRscDial, 
                                          dlg.NumTree, 
                                          RSC_DIAL, 
                                          Evnt 
                                          ) != WM_ABORT
                                 )
                                 {Evnt->x = grect.g_x + (Evnt->pipe[W_B]>>1);
                                  Evnt->y = grect.g_y + (Evnt->pipe[H_B]>>1); 
                                  
                                  AdjustWindCoordToScreen (ind, Evnt, (GRECT*)&Evnt->pipe[X_B]); 
                                  strcpy(Windtab[ind].titre, NomDial);
                                  wind_set( Windtab[ind].w_h, WF_NAME, Windtab[ind].titre);
                                  SetWindowSize(ind, (GRECT*)&Evnt->pipe[X_B]);
                                  SendWindRedraw(Windtab[ind].w_h); 
                                 }                                                      
                             }  
                         }  
                    
                   } /* end switch           */
                }   /* endif if EXE_FUNC    */                 
             break; 
                   
        case WM_TOPPED: 
             /**************************************************************/              
             /*........................ WM_TOPPED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre en premier plan. Il convient   */
             /* Je traite ce message ici pour mettre le menu GEM au        */
             /* premier plan chaque fois, qu'une fenetre de l'application  */
             /* est topee.                                                 */
             if (TreeMenu)            /* si menu charge l'activer          */
                {
                 menu_bar(TreeMenu,1);                       
                }
             break;  
             
        case AP_DRAGDROP:
             /**************************************************************/              
             /*........................ AP_DRAGDROP (GEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* un truc a t drag (tir) sur sa fenetre.                 */
             /* Ici je verifie si c'est une liste de fichiers, et si c'est */
             /* le cas je lance un message VA_START pour le charger.       */
             if (GetDragDropList(Evnt,PathVABuff,sizeof(PathVABuff)))
				            {Send_VA_START(Appl_id, PathVABuff);
				            }
				         break;   
				       
        case MN_SELECTED:
             /**************************************************************/              
             /*...................... MN_SELECTED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* une entree du menu deroulant est clique.                  */  
             /* en Evnt->pipe[4] se trouve le numero de l'item selectionn */
             /*........... j'ai prefere traiter tous les messages .........*/
             /*            du menu GEM a part, mais il est possible        */
             /*            de les traiter ici                              */
             MenuProcedure(w_ind, Evnt);             
             break;
             
        case AP_TERM:
             /**************************************************************/              
             /*........................ AP_TERM (GEM message)..............*/
             /* Ce message est envoy  l'application lorsqu'il lui est    */
             /* demande de s'arreter (exemple lorsque il y a changement   */
             /* rsolution). Il est d'usage de quitter sans demande de     */
             /* comfirmation. Faites les sauvegardes ncessaires avant de  */
             /* quitter. Et quittez.                                       */
             /* Ici je mets la variable: EZGemRun  -1, de faon  ce      */
             /* que le programme s'arrete sans demande de confirmation.    */
             EZGemRun=-1;           /* sortir sans demande de confirmation */
             break;
             
        case VA_START:          /*  (XGEM message)   */  
             {char *va_txt; 
              int msgbuf[8];  
             /**************************************************************/              
             /*........................ VA_START (GEM message).............*/                    
             /* Le message VA_START est envoy par une autre application   */           
             /* pour demander  la notre de s'activer (il faut bien sur    */
             /* qu'elle ait ete auparavant ete chargee en memoire)         */
             /* exemple dans un systeme multitache notre application est   */
             /* en sommeil, avec toutes ses fenetres en arriere plan et    */
             /* il lui est demandee de s'activer (en general pour charger  */
             /* un fichier ou toute autre chose)                           */
             /* Exemple on a double clique sur un fichier lie  notre appli*/
             /* a partir du bureau, ou on a pose un fichier sur notre appli*/
             /* ou tout simplement double clique sur l'icone de notre appli*/
             /* sans fichier ou ...                                        */
                
             /*............ renvoyer accus de reception VA_START...................*/
             /*             au message (il faut le faire c'est plus poli)           */
             msgbuf[MESG]=VA_AKCNW;           /*   accuse de reception  VA_START    */
             msgbuf[APPL]=Appl_id;            /*   iddentificateur de l'appelant    */
             msgbuf[SUPL]=0;                  /*   message sans surplus             */
             msgbuf[3]=Evnt->pipe[3];         /*   il faut retourner l'adresse de   */
             msgbuf[4]=Evnt->pipe[4];         /*   la chaine c'est comme a !!      */
             appl_write(Evnt->pipe[APPL], 16, msgbuf );  /* on envoie le paquet     */
             
               
             /*........... exploiter le message VA_START ...........................*/
             /*            ici notre programme etant un mini viewer                 */
             /*            de ressources EAZY_GEM on suppose que c'est le           */
             /*            nom du fichier ressource devant etre affiche             */
             /*            qui nous est envoye dans la chaine de VA_START           */
             va_txt = (char*) (*(long*)&Evnt->pipe[3]);
             strcpy(PathDial,va_txt); /* noter le path et nom que VA_START  envoie  */                                  
             
             /*.......... separer nom du fichier et path ...........................*/
             PathNomToNomFic(PathDial, NomDial); 
             if (*NomDial)              /* >> SI un nom est fourni charger fichier  */
                {/*........ SI path non fourni (que le nom du fichier) .............*/
                /*          c'est que le path est celui de l'application !!         */
                /*          alors prendre celui de l'application                    */
                /*          SINON utiliser celui fourni                             
                 if (*PathDial==0) strcpy(PathDial,PathAppli);   
                /*............ charger la ressource ...............................*/
                 if (Fic_exist(PathDial, NomDial)>0)          /* annuler = 3 */
                    {int ind;
                     int fh;
                     char path[256];
                     
                     ind = IsWindExist(W_RESSOURCE);
                     if (ind != -1)       
                        {Xform_Destruct(ind, Evnt);               /* desintegrer l'arbre de ress.*/
                        }
                        
                     /*....... avant chargement effacer ressource (on sait jamais).. */                      
                     RscFicUnLoad(AdrRscDial);         
                     AdrRscDial = RscFicLoad(PathDial, NomDial, SCALE);
                     /*.............. relever la date .............................*/ 
                     strcpy(path, PathDial);
                     strcat(path, NomDial);
                     fh = (int)Fopen( path, FO_RW );
                     if (fh)
                        {Fdatime( &Dos_time, fh, 0);
                         Fclose(fh);
                        }
                     /*...............si fenetre existe ...........................*/                    
                     if (ind != -1)       
                        {int x,y;
                         x =Windtab[ind].ExtGrectUse.g_x;
                         y =Windtab[ind].ExtGrectUse.g_y;
                         if (Windtab[ind].w_flag & W_IS_ICON || 
				                         Windtab[ind].w_flag & W_IS_ALLICON
			                         )
			                         {UnconifyWindow(ind); 
			                         }
                         if (WindDialogConstruct(ind, 
                                          AdrRscDial, 
                                          0, 
                                          RSC_DIAL, 
                                          Evnt 
                                          ) != WM_ABORT
                                 )
                                 {Evnt->pipe[X_B] = x;
                                  Evnt->pipe[Y_B] = y;
                                  AdjustWindCoordToScreen (ind, Evnt, (GRECT*)&Evnt->pipe[X_B]); 
                                  strcpy(Windtab[ind].titre, NomDial);
                                  wind_set( Windtab[ind].w_h, WF_NAME, Windtab[ind].titre);
                                  SetWindowSize(ind, (GRECT*)&Evnt->pipe[X_B]);
                                  SendWindRedraw(Windtab[ind].w_h); 
                                 }
                        }
                     /*......... La fonction CreateWindow doit etre appelee .........*/   
                     else
                        {DLG_VAR dlg;
                         dlg.AdrRsc  = AdrRscDial;
                         dlg.NumTree = 0;
                         dlg.type    = RSC_DIAL;
                         CreateWindow(BORDER|NAME|XMOVER|MOVER|SMALLER|CLOSER, 
                                      W_RESSOURCE, &dlg, WindProcDialogue, 
                                      0, 
                                      0, 
                                      0, 
                                      0, NomDial);
                        }                                                                                                                                            
                    } 
                }  
                /*............ SI chaine VA_START vide c'est que l'on ................*/
                /*          a double clique sur l'icone du programme                  */
                /*          sans fichier donc activer notre programme                 */
                /*          en mettant par exemple nos fenetres au TOP (premier plan) */
                /*          et en activant notre menu                                 */ 
             else                             
                {int i;
                 for (i=0; i<MAX_WIND; i++) /* activer nos fenetres si elles existent */
                     {
                      if (Windtab[i].w_h>-1) wind_set(Windtab[i].w_h,WF_TOP);
                     }                     
                 if (TreeMenu)            /* si menu charge l'activer               */
                    {menu_bar(TreeMenu,1);                       
                    }
               }
             }      
             break;                                                  
       }                                              
    }
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */         
 /* return 0;  */          /* empecher transmission message menu      */
}

/*------------------------ MenuProcedure ------------------------------*/
/* ACTION: cette procedure est chargee de gerer les evenements du menu */
/*         droulant. Cette gestion peut se faire aussi au niveau de   */
/*         chaque fenetre auquelles sont transmises les evenements menu*/
/*         On peut aussi la faire au niveau de la procedure:           */
/*         MessageProcedure. Faites un peu comme vous voulez !!        */
/*         il est possible d'empecher la transmission du message de    */
/*         menu, aux procedures de fenetre, en retournant zero         */
int MenuProcedure(int w_ind, EVNT_O *Evnt)
{w_ind++;   /* utiliser cette variable pour calmer le compil   */   
 /* en Evnt->pipe[4] se trouve le numero de l'item selectionn */
 /* il faut donc orienter l'action en fonction de cet item     */
 /* Lors de la creation de notre ressource menu avec INTERFACE */
 /* un fichier WND_MENU.H a ete cree et comporte tous les      */
 /* #define permettant d'utiliser un nom symbolique plutot que */
 /*         qu'un nombre abstrait                              */
 
 switch (Evnt->pipe[4])                                     
   {/*.......... chargement d'une ressource et affichage ...........*/
    case INFORMATION: 
         SendExeFunc(Appl_id, EXE_INFO);                                      
         break;                                                   
   }
 if (TreeMenu)  
    {menu_tnormal( TreeMenu, Evnt->pipe[3],1);             
    } 
 return Evnt->pipe[MESG];  /* transmettre message aux autres fenetres */ 
 /* return 0;  */          /* empecher transmission message menu      */
}



/*----------------------- WindProcDialogue ------------------------------*/
/* ''''''CI DESSOUS EXEMPLE D'UNE PROCEDURE DE GESTION DE FENETRE''''''''*/
/*                 ici gestion d'une ressource en fenetre                */
/* ACTION : Procedure de gestion attache  une fenetre.                 */
/* ENTREE : EVNT_O *Evnt pointe sur une structure du type EVNT_O         */
/*              cette structure represente le flux evenementiel.         */
/*          w_ind indice pointant sur la structure rattache  cette     */
/*                fenetre:  Windtab[w_ind]                               */
/*                                                                       */
/* RETOURNE: un int retransmettant l'evenement Evnt->evnt                */
/*           En effet le flux evenementiel doit etre retransmis aux      */
/*           autres fenetres afin qu'elles puissent elles aussi reagir   */
/*           aux evenements.  L'evenement est  transmis en premier       */
/*           toujours   la fenetre du dessus puis  aux autres ensuite.  */
/*           Il est parfois utile d'empecher la transmission du flux     */
/*           aux autres fenetres. Exemple je clique sur la fenetre       */
/*           principale et je ne veux pas que le menu dessous reoive    */
/*           le click, il faut alors faire Evnt->evnt &= ~MU_BUTTON      */  
/*           afin d'enlever l'evenement MU_BUTTON du flux evementiel.    */
/*                                                                       */
/* DIX COMMANDEMENTS CONCERNANT L'UTILISATION D'EAZY GEM:                */
/*          Pour faciliter la gestion du GEM j'ai rajout une sur couche */
/*          analysant toute la messagerie et evenements GEM et dirigeant */
/*          les messages sur chaque procedure de fenetre. En effet je me */
/*          suis inspir d'un truc pas mal dans window, qui est que tout */
/*          ce qui concerne une fenetre est gr par une seule et meme   */
/*          procedure. Cela apparait au debut comme idiot et limitatif   */
/*          mais  l'usage cette faon de faire est hyper efficace.      */
/*          Pour pouvoir  beneficier des facilites offertes par le       */ 
/*          systeme EZ_GEM il convient de suivre quelques regles:        */
/*                                                                       */
/*          1)  Dmarrer par la fonction: InitEazyGem                    */
/*          2)  Utilizez Imperativement la fonction: BouclePrincipale    */
/*              qui est le moteur et noyau principal d'EAZY_GEM.         */
/*              C'est cette fonction qui est chargee de redistribuer     */
/*              sur les procedures de fenetre adequates tout le flux     */
/*              evenementiel, qui gere les bulles d'aide et autres       */           
/*              bricoles.                                                */
/*          3)  Finir par la fonction:    ExitEazyGem                    */
/*          4)  Charger vos ressources avec la fonction: RscFicLoad      */
/*          5)  Utilisez la fonction: xrsrc_gaddr pour acceder aux       */
/*              elements de votre ressource.                             */
/*          7)  Liberer vos ressources avec la fonction: RscFicUnLoad    */
/*          8)  Creez vos fenetres avec la fonction: CreateWindow        */
/*          9)  Detruisez vos fenetres avec la fonction: DestroyWindow   */
/*         10)  Acceder et modifier les textes des objets ressource en   */
/*              utilisant les fonctions: ObjcGetTxt et ObjcSetTxt        */
/*         11)  Ouvrir et Fermer les fenetres avec OpenWindow et         */
/*              CloseWindow                                              */
/*         12)  Redimensionner   les fenetres avec: SetWindowSize        */
/*                                                                       */
/* RAPPEL:                                                               */
/*          Lors de l'ouverture d'une fenetre il faut faire appel  la   */
/*          fonction suivante, qui cree et met en place une fenetre:     */
/*                                                                       */
/*  int  CreateWindow ( long w_attr,                                     */
/*                      int ident,                                       */
/*                      void *adr,                                       */               
/*                      CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt),     */
/*                      int x, int y, int w, int h,                      */
/*                      char *nom                                        */
/*                  )                                                    */
/*  long w_attr: attributs GEM classique d'une fenetre                   */
/*               trois attributs de plus:                                */
/*                         BORDER permet d'avoir un cadre epais en       */
/*                                  relief autour de la fenetre.         */
/*                         XMOVER permet d'avoir une poigne de deplace- */
/*                                ment sur le bord sup du cadre epais    */
/*                         XSIZER permet l'agrandissement de la fenetre  */
/*                                en cliquant sur le cadre epais         */
/*  int Ident:  nbr arbitraire(jamais nul) que vous devez donner. Cela   */
/*              peut servir  reperer tel ou tel type de fenetre dans    */
/*              votre programme. Exemple votre application comporte      */
/*              plusieurs fenetres dont une de menu  laquelle vous      */
/*              donnez int ident=2 chaque fois que vous l'ouvrez.Il est  */
/*              alors facile pour le programme de savoir si la fenetre   */
/*              menu est ouverte en faisant appel  la fonction          */
/*              int IdentToIndice(2); qui vous retourne l'indice de la   */
/*              fenetre (si elle n'existe pas l'indice est >= MAX_WIND ) */
/*  void *adr:  adresse pointant sur diverses choses dependant du type   */
/*              gestion que l'on prevoit pour la fenetre. Cette adresse  */
/*              permet par exemple de passer un pointeur sur une struct- */
/*              ture, avec laquelle elle doit travailler. Ce parametre   */
/*              est donc facultatif. La fonction: CreateWindow() place   */
/*              ce parametre dans Wintab[w_ind].UserPtr de la fenetre.   */
/*                                                                       */                              
/*  CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt): L vous donnez le nom   */
/*              fonction qui sera charge de gerer tous les evenements   */
/*              de cette fenetre. Cette fonction sera appelee par la     */
/*              sur couche EAZY_GEM.                                     */
/* int x, int y, int w, int h,: coordonnees en pixels de la fenetre      */
/*              ces coordonnees doivent etre celles du contour exterieur */
/*              de la fenetre et non de la surface de travail            */
/*              si zero en entree alors les dimensions maxi possibles    */
/*              seront choisies.                                         */
/*              Ces dimensions peuvent etre modifiees avant ouverture de */
/*              la fenetre lors du traitement du message WM_CONSTRUCT    */
/*              au sein de la procedure de fenetre.                      */
/* char *nom:   titre de la fenetre                                      */
/*              de meme le titre de la fenetre peut etre modifie au sein */
/*              de la procedure de fenetre lors du traitement du message */
/*              WM_CONTRUCT.                                             */
/*                                                                       */
/*                                                                       */
/*................... description de la structure EVNT_O.................*/
/*  typedef struct                                                       */
/*      {int evnt;        */ /* type d'evenement                         */
/*       int pipe[16];    */ /* table de parametres lors MU_MESAG        */
/*       int x;           */ /* coordonnee souris X                      */
/*       int y;           */ /* coordonnee souris Y                      */
/*       int k;           */ /* etat des boutons souris                  */
/*       int ksp;         */ /* etat des touches CONTRL,ALT,SHIFT,CAPS   */
/*       int key;         */ /* etat du clavier                          */
/*       int click;       */ /* nombre de click                          */
/*      }EVNT_O;                                                         */
/*                                                                       */
/* NOUVEAUX MESSAGES:   La surcouche cree de nouveaux messages et de     */
/*         nouveaux evenements afin de faciliter la programmation. Nous  */
/*         le verrons plus loin dans l'exemple.  cote j'ai marque en    */
/*         commentaire (EZGEM)                                           */


CALLBACK WindProcDialogue(int w_ind, EVNT_O *Evnt)
{/*.............. les variables locales suivantes sont souvent ..........*/
 /*           utiles pour toutes les fonctions de fenetre EZGEM pour:    */
 GRECT grect;          /* rectangle surface de travail                   */
 int w_h;              /* handle de la fenetre de cette Wind_proc_xxx    */
 int wh_top;           /* handle de la fenetre en avant plan             */
 /* VRECT clip;  */    /* rectangle de traage (type VDI) pas ici!!      */
 /*.............. variables locales specifiques  notre .................*/
 /*                  exemple de Ressource en fenetre                     */
 OBJECT *object;     /* pointeur d'objet pour les ressources             */ 
 char *sztt_txt;     /* pointera sur adresse copie texte bulle d'aide    */
 int ob_ret;         /* retournera l'objet ressource selectionne         */
 DLG_VAR *dlg;       /* structure attachee  chaque ressource en fenetre */
 char stralert[256]; /* pour affichage alerte item menu cliqu           */
 char bufnum[128];   
 /*.................. INITIALISER LES VARIABLES ....................*/
 /*........recuperer dans la memoire buffer suplementaire ..........*/
 /*        attachee  la fenetre, les donnees DLG_VAR               */
 /*        permettant la gestion des ressources en fenetre          */
 dlg = &Windtab[w_ind].DlgVar;
  
 /*.................... recuperer handles ..........................*/    
 wind_get( 0, WF_TOP, &wh_top); /* celui de fenetre avant plan      */
 w_h = Windtab[w_ind].w_h;      /* celui de notre fenetre           */
 grect = Windtab[w_ind].GemWorkGrect; /* recuperer espace de travail      */
           
       
 /*...........................TOUCHE CLAVIER APPUYEE ...................*/
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec une touche clavier  */
 /* Notamment l'edition et saisie de texte dans les champs editables et */
 /* les raccourcis clavier.                                             */
 /* Pour une ressource en fenetre il est indispensable que l'evenement  */
 /* MU_KEYBD soit traite avant l'evenement  MU_BUTTON afin de permettre */
 /* un fonctionnement correct des raccourcis clavier. En effet le       */
 /* raccourci clavier d'un objet simule un clic souris sur l'objet.     */
 /* en renvoyant un evenement MU_BUTTON                                 */
 
 if (Evnt->evnt & MU_KEYBD && w_h==wh_top)
    {Xform_keybd(w_ind, Evnt);
    }
    
 /*.......................... BOUTONS SOURIS ...........................*/ 
 /* Dans le cadre d'une ressource en fenetre j'ai cree une fonction qui */
 /* s'occupe de gerer tout ce qui a un rapport avec un appui sur un     */
 /* bouton de souris.                                                   */
 /* Notamment l'appui sur un bouton de la ressource, la selection du    */
 /* texte dans les champs editables, et le placement du curseur de      */
 /* texte dans les champs editables.                                    */
  
 if (Evnt->evnt & MU_BUTTON)
    {if (Evnt->k == 2)
        {ActiveWindow(W_POPUP, XMOVER|BORDER, "MENU",WindProcPopup);
         ExeAllMessage();
         while(Mousek());
         Evnt->evnt &= ~MU_BUTTON;   /* empecher propagation message  MU_BUTTON */
        } 
     if (Evnt->click==2) 
        {if (Fic_select (PathDial, NomDial,".RSC",PtStrMess[RSC_LOAD])
             >0L
            )
            {/* Une application comprenant le message VA_START doit pouvoir    */
             /* s'activer et charger un document. Je m'envoie donc un message  */
             /* VA_START avec le nom du fichier choisi afin de ne pas avoir   */
             /* m'occuper ici du chargement, et de laisser le soin  la partie */
             /* de programme qui s'en occupe de le faire (celle de VA_START).  */             
             strcpy(PathVABuff, PathDial);
             strcat(PathVABuff, NomDial);
             Send_VA_START(Appl_id, PathVABuff);
            } 
        }     
     ob_ret = Xform_button(w_ind, Evnt);     
     if (ob_ret>-1)
        {Evnt->evnt &= ~MU_BUTTON;   /* empecher propagation message  MU_BUTTON */
         object=dlg->tree;
         /*............. si objet exit selectionne ...................*/
         object[ob_ret].ob_state &= ~SELECTED;         
         if (object[ob_ret].ob_type &((G_CICON<<8)|G_USERDEF))           
             SendObjectRedraw( Windtab[w_ind].w_h, object, ob_ret); 
         else
             Xobjc_draw(object, ob_ret, 1, &grect);  
         /*.............. ICI ACTION SELON BOUTON CLIQUE..............*/            
         /* switch (ob_ret)            */
         /*   {case TRUC:              */
         /*         FaireTruc();       */   
         /*         break;             */
         /*    case MACHIN:            */
         /*         FaireMachin();     */   
         /*         break;             */
         /*   }                        */     
        }  /* endif objet selectable cliqu  */ 
    } /* endif MU_BUTTON  et fenetre au premier plan */

 /*....... non traites ..............*/
 /*
 if (Evnt->evnt & MU_M1)
    {
    }
 if (Evnt->evnt & MU_M2)
    {
    }
 */   
 
 /*.......................... TIMER ..................................*/  
 /* Dans le cadre d'une ressource en fenetre la fonction: Xform_timer */
 /* s'occupe de tout ce que doit gerer le timer notamment le clignote */
 /* ment du curseur texte dans les champs editables                   */
 if (Evnt->evnt & MU_TIMER && w_h==wh_top)  
    {Xform_timer(w_ind);    
    }
    
 /*.......................... MOUVEMENTS SOURIS ......................*/   
 /* Pour une ressource en fenetre la fonction: Xform_mu_move          */
 /* s'occupe de tout ce qui doit etre ger par un mouvement souris.   */      
 /* Notamment les formes de la souris lors du survol des differentes  */
 /* zones de la ressource.                                            */ 
 if (Evnt->evnt & MU_MOVE)   /*  (EZGEM evenement)   */
    {Xform_mu_move(w_ind, Evnt);
    }      
 /*.......................... MESSAGES GEM et AUTRES .................*/     
 if (Evnt->evnt & MU_MESAG)
    {switch (Evnt->pipe[MESG])
       {
        
        case WM_CONSTRUCT:
             /***********************************************************/
             /*.................... WM_CONSTRUCT (EZGEM message)........*/
             /* Ce message est transmis avant la creation et ouverture  */
             /* de la fenetre associee  notre procedure de fenetre.    */
             /* c'est  cet endroit que vous devez initialiser tout ce  */
             /* qui concerne votre fenetre: Memoire, chargement d'un    */
             /* fichier ressource, modification des dimensions fenetre  */
             /* avant ouverture, declaration des Bulles d'aide associees*/
             /*  cette fenetre, titre de la fenetre.....etc            */
             /* eventuellement si pas deja fait avant: ouverture d'une  */
             /* Station de travail VDI autre que celle d'EAZY_GEM.      */  
             /* EAZY_GEM vous laisse toute liberte pour faire ce que    */
             /* vous voulez:                                            */
             /* Vous pouvez tres bien charger votre fichier ressource  */    
             /* cet endroit ou avant dans l'application..               */
             /* Lors de ce message il est donn dans:                   */
             /*                  Evnt->pipe[X_B]                        */
             /*                  Evnt->pipe[Y_B]                        */
             /*                  Evnt->pipe[W_B]                        */
             /*                  Evnt->pipe[H_B]                        */
             /*                               les dim exterieures  maxi */
             /* possibles d'ouverture de la fenetre sur l'ecran.        */ 
             /* c'est par defaut ces dimensions qui sont choisies pour  */
             /* ouvrir une fenetre.Si on veut d'autres dimensions c'est */
             /* ces valeurs qu'il faudra modifier.                      */
             /*                                                         */
             /* REPONDRE AU MESSAGE WM_CONTRUCT:                        */
             /* Il est possible de repondre au message WM_CONSTRUCT     */
             /* de deux manieres equivalentes au point de vue resultat: */
             /* Soit en faisant  Evnt->evnt = WM_ABORT; (ou WM_STANDBY) */
             /* Soit en faisant  return WM_ABORT;       (ou WM_STANDBY) */                
             /*                                                         */
             /* Vous pouvez interrompre le processus de creation de la  */
             /* fenetre en retournant le message: WM_ABORT par exemple  */
             /* vous n'avez pas pu reserver toute la memoire souhaitable*/
             /* ou vous n'avez pas trouve un fichier indispensable      */
             /* ou pour toute autre raison liee a votre application.etc.*/
             /*                                                         */
             /* Vous pouvez empecher l'ouverture de la fenetre et donc  */
             /* permettre juste sa creation en retournant le message:   */   
             /* WM_STANDBY. Pour ouvrir et afficher la fenetre ulterieu-*/
             /* ment il faudra utiliser la fonction: OpenWindow         */
             /* Si vous ne retournez pas ce message la fenetre s'ouvre  */
             /* dans la foulee (cas le plus utile).                     */                           
             /*                                                         */
             /* Pour les ressources en fenetre j'ai cree une fonction   */
             /* s'occupe de tout ce qu'il y a a faire  ce sujet        */
             /* la voici:                                               */
             Windtab[w_ind].DlgVar = *(DLG_VAR*)Windtab[w_ind].UserPtr;
             Xform_construct(w_ind, Evnt);         
             /*........... placer le tout sous la souris ..............*/
             AdjustWindCoordToScreen (w_ind, Evnt, (GRECT*)&Evnt->pipe[X_B]);
             break;
              
              
             
        case WM_DESTRUCT:       /*  (EZGEM message)   */
             /**************************************************************/              
             /*........................ WM_DESTRUCT (EZGEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre avant   */
             /* que le systeme ne la detruise. c'est  cet endroit qu'il   */
             /* convient de desinitialiser tout ce que l'on avait fait     */
             /* auparavant memoire, bulles d'aide, ressources....          */
             Xform_Destruct(w_ind, Evnt);   
             /*.......... La je ne detruit pas la ressource car............*/
             /*           Adresse en variable globale et detruite          */
             /*                 la fin du programme                       */   
             /*
             RscFicUnLoad(dlg->AdrRsc);                
             AdrRscDial = 0;    
             */
             break;
             
        case WM_TT_ON_OFF:      /*  (EZGEM message)   */
             /**************************************************************/
             /*...................... WM_TT_ON_OFF (EZGEM message).........*/
             /* Ce message est envoy  notre fenetre chaque fois qu'il est*/
             /* demand d'activer ou de desactiver l'affichage des bulles  */
             /* d'aide. Il suffit simplement d'appeler la fonction qui suit*/
             /* pour mettre  jour l'objet representant l'etat actif ou    */
             /* inactif de notre ressource (si il existe)                  */
             /* Cet Objet est un objet type BOXTEXT extended type 25 que   */ 
             /* vous devez placer sur votre formulaire. Il refletera l'etat*/
             /* actif ou inactif du systeme de bulle d'aide.               */
             SetBulleState(w_h, dlg->tree);
             break;   
                 
        case WM_TT_GET_TXT:     /*  (EZGEM message)   */
             /**************************************************************/              
             /*...................... WM_TT_GET_TXT .(EZGEM message).......*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois que le systeme d'affichage d'une bulle d'aide desire  */
             /* qu'on lui fournisse un texte  afficher.                   */
             /* Ce texte peut etre affiche sur plusieurs lignes en mettant */
             /* comme separateur le signe | .                              */
             /* Exemple:                                                   */
             /* strcpy(sztt_txt,"Premiere ligne|deuxieme ligne|troisieme");*/
             /* Si vous placez une chaine vide "", la bulle d'aide ne sera */
             /* pas affichee.                                              */
             /*  Exemple: strcpy(sztt_txt,"");                             */
             /*                                                            */
             sztt_txt  = (char*)     *(long*)(&Evnt->pipe[W_G]);
             if (Evnt->pipe[X_G]==TT_UPSTOOL)
                {MakeStrInfoOb(dlg->AdrRsc, dlg->NumTree, Evnt->pipe[Y_G], sztt_txt);                 
                }   
                        
             /* Dans le cadre d'une ressource fixe et connue il est bien sur*/
             /* tout a fait possible de copier directement un texte         */
             /* specifique  chaque objet, dans la chaine sztt_txt, avec un */
             /* switch case sur le numero d'objet ou ce que vous voulez..   */               
             /* Exemple:                                                    */
                      /* switch ( Evnt->pipe[Y_B])                          */
                      /*    {case BUTTON_CONFIRMEZ:                         */
                      /*          strcpy(sztt_txt,"Confirmer les options"); */
                      /*          break;                                    */
                      /*     case BUTTON_ANNULER:                           */
                      /*          strcpy(sztt_txt,"Annuler les options");   */
                      /*          break;                                    */
                      /*     case BUTTON_UNDO:                              */
                      /*          strcpy(sztt_txt,"Restaurer les options"); */
                      /*          break;                                    */
                      /*     default:                                       */
                      /*          strcpy(sztt_txt,"");                      */ 
                      /*    }                                               */          
             break;
        
        case WM_ONGLET_CHG:     /*  (EZGEM message)   */
             /**************************************************************/              
             /*................... WM_ONGLET_CHG .(EZGEM message)..........*/
             /* Ce message est envoy a notre procedure de fenetre chaque  */
             /* fois qu'il y a eu changement d'onglet, au niveau d'une     */
             /* ressource geree par notre fenetre. C'est lors de ce messa- */
             /* ge, qu'il convient d'initialiser le nouveau dialogue et de */
             /* recuperer les donnes de l'ancien. Ce message est envoy    */
             /* avant le dessin du nouveau dialogue.                       */
             /* Le message est compose comme suit:                         */
             /*  Evnt->pipe[MESG] = WM_ONGLET_CHG (message envoy)         */             
             /*  Evnt->pipe[APPL] = identificateur de l'application        */
             /*  Evnt->pipe[SUPL] = 0 (pas de surplus)                     */
             /*  Evnt->pipe[WHND] = handle fenetre contenant ressource     */  
             /*  Evnt->pipe[X_G]  = indice du dialogue qui va etre activ  */
             /*  Evnt->pipe[Y_G]  = indice du dialogue qui sera desactive  */    
             /*  *(long*)&Evnt->pipe[W_G] =  adr arbre ou sont les objets  */
             if (InfoClick)
                {/*......... recuperer adresse arbre ressource ................*/
                 object = (OBJECT*)*(long*)&Evnt->pipe[W_G];
             
                 /*........ recuperer nom ancien dialogue .....................*/
                 strcpy(stralert,PtStrMess[RSC_ONGL0]);
                 strcpy (bufnum, 
                         ObjcGetTxt(object, Evnt->pipe[Y_G])
                         +1);  /* +1 car il faut sauter le premier caractere   */
                 sztt_txt = strchr(bufnum,'|');   /* chercher barre separation */                    
                 if (sztt_txt!=0L) *sztt_txt = 0; /* y planter un zero de fin  */                          
                 strcat(stralert,bufnum);             
                 strcat(stralert,PtStrMess[RSC_ONGL1]);
                 /*........ recuperer nom nouveau dialogue ....................*/
                 strcat(stralert,PtStrMess[RSC_ONGL2]);
                 strcpy (bufnum, 
                         ObjcGetTxt(object, Evnt->pipe[X_G])
                        +1);  /* +1 car il faut sauter le premier caractere   */
                 sztt_txt = strchr(bufnum,'|');   /* chercher barre separation */                    
                 if (sztt_txt!=0L) *sztt_txt = 0; /* y planter un zero de fin  */                          
                 strcat(stralert,bufnum);             
                 strcat(stralert,PtStrMess[RSC_ONGL3]);                        
                 form_alert( 2,stralert);    
                }                                                 
             break; 
                
        case WM_WND_MENU:
             /**************************************************************/              
             /*...................... WM_WND_MENU (EZ_GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* une entree de menu deroulant en fenetre est clique.       */  
             /* en Evnt->pipe[X_G] se trouve  numero de l'item selectionn */       
             /* comme dans les menu GEM classiques.                        */   
             /* en Evnt->pipe[Y_G] se trouve  numero de l'arbre de menu    */                                                         
             /* en *(long*)Evnt->pipe[W_G] adresse arbre menu, cela permet */
             /* de distinguer le menu en fenetre dans le cas de plusieurs  */
             /* menu dans la meme fenetre (c'est possible !!!!)            */ 
             /* ici j'affiche une alerte indiquant le menu cliqu et       */
             /* l'item cliqu.                                             */
             if (InfoClick)
                {strcpy(stralert,"[3][L'option: ");
                 strcat(stralert,itoa( Evnt->pipe[X_G], bufnum, 10 ));
                 strcat(stralert,"|du menu numro: ");
                 strcat(stralert,itoa( Evnt->pipe[Y_G], bufnum, 10 )); 
                 strcat(stralert,"|a t clique][ok]");             
                 form_alert( 3,stralert);                    
                } 
             break;
                  
        case MN_SELECTED:
             /**************************************************************/              
             /*...................... MN_SELECTED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* une entree du menu deroulant est clique.                  */  
             /* en Evnt->pipe[4] se trouve le numero de l'item selectionn */                                                              
             /* dans notre exemple il est traite ailleurs donc on peut     */
             /* l'ignorer  ce niveau                                      */
             break;
             
             
        case WM_REDRAW:  
             /**************************************************************/              
             /*........................ WM_REDRAW (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut redessiner une partie de la fenetre (par exemple un*/
             /* accessoire qui la recouvrait vient de se fermer, il faut   */
             /* alors retracer la partie de notre fenetre que l'accessoire */
             /* recouvrait. Avant c'etait un veritable enfer, maintenant   */
             /* il vous faut juste appeler la routine: Lister_rectangles   */
             /* qui vous renvoie le message WM_PAINT                       */
             /* et vous n'avez plus  vous occuper de savoir comment faire */
             /* notamment pour traiter la liste des rectangles et leur     */
             /* intersection avec notre fenetre.                           */    
             Lister_rectangles(w_h,(GRECT*)&Evnt->pipe[X_G]);             
             break;
             
        case WM_PAINTBOX:
             /**************************************************************/              
             /*........................ WM_PAINTBOX (EZGEM message)........*/
             /* Ce nouveau message est envoy a notre procedure de fenetre */
             /* lorsqu'il faut retracer la surface d'une boite de type     */
             /* PAINT_BOX (ob-type etendu PAINT_BOX (215).                 */             
             /*                                                            */
             /* En: Evnt->pipe[X_G], Evnt->pipe[Y_G], Evnt->pipe[W_G], et  */
             /*     Evnt->pipe[W_G], se trouve le rectangle de clipping    */              
             /*                      qui est dej clipp par EAZY_GEM,     */
             /* En: Evnt->pipe[X_B], Evnt->pipe[Y_B], Evnt->pipe[W_B], et  */
             /*     Evnt->pipe[W_B], se trouve le rectangle de la surface  */    
             /*                      client qu'il est   votre charge de   */
             /*                      redessiner                            */
             /* En: Evnt->pipe[12]   se trouve le numero de l'objet dont   */
             /*                      il faut retracer la surface.          */
             {/*....... effacer espace de travail ..........................*/   
              /* ICI JE TRACE LE RECTANGLE ESPACE DE TRAVAIL INTERIEUR AU   */
              /*             BORD EPAIS ET  LA RESSOURCE                   */
              int x,y;
              char buft[64];
              
              vswr_mode(VDIhandle,MD_REPLACE);
              vsf_color( VDIhandle, 0 );           /* modifi par objc_draw         */
              vsf_interior(VDIhandle,0);                      
              GrectPbox((GRECT*)&Evnt->pipe[X_G]);    
              Defline(1,1,0,0,1);
              GrectBox((GRECT*)&Evnt->pipe[X_B]);    
                  
              Deftext(1,0,0,6,1);
              vst_alignment (VDIhandle,0,3, &x, &x );  /* bottom line */
              x=Evnt->pipe[X_B]+3;
              y=Evnt->pipe[Y_B]+8;
              vswr_mode(VDIhandle,MD_TRANS);
              VdiText(x,y,"PAINT_BOX");
              VdiText(x,y+8,"n: ");
              itoa(Evnt->pipe[12],buft,10);
              VdiText(x+32,y+8,buft);                                                                                                                                                                                                    
             }
             break;   
                      
        case WM_PAINT:
             /**************************************************************/              
             /*........................ WM_PAINT (EZGEM message)...........*/
             /* Ce nouveau message est envoy a notre procedure de fenetre */
             /* lorsqu'il faut retracer quelque chose  l'ecran.           */
             /*                                                            */
             /* En: Evnt->pipe[X_G], Evnt->pipe[Y_G], Evnt->pipe[W_G], et  */
             /*     Evnt->pipe[W_G], se trouve le rectangle de clipping    */              
             /*                      qui est dej clipp par EAZY_GEM,     */
             /* En: Evnt->pipe[X_B], Evnt->pipe[Y_B], Evnt->pipe[W_B], et  */
             /*     Evnt->pipe[W_B], se trouve le rectangle de la surface  */    
             /*                      client qu'il est   votre charge de   */
             /*                      redessiner                            */
             {/*....... effacer espace de travail ..........................*/   
              /* ICI JE TRACE LE RECTANGLE ESPACE DE TRAVAIL INTERIEUR AU   */
              /*             BORD EPAIS ET  LA RESSOURCE                   */
              vswr_mode(VDIhandle,MD_REPLACE);
              vsf_color( VDIhandle, 0 );           /* modifi par objc_draw         */
              vsf_interior(VDIhandle,0);                      
              GrectPbox((GRECT*)&Evnt->pipe[X_G]);    
              Defline(1,1,0,0,1);
              GrectBox((GRECT*)&Evnt->pipe[X_B]);                                                                                                                                                                                               
             }
             break;    
                                
       case WM_BOTTOM:
             /**************************************************************/              
             /*........................ WM_BOTTOM (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre au dernier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_BOTTOM );   */        
             wind_set(w_h, WF_BOTTOM );             
             break;
                               
       case WM_TOPPED:
             /**************************************************************/              
             /*........................ WM_TOPPED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de se mettre en premier plan. Il convient   */
             /* de le faire avec la fonction: wind_set(w_h, WF_TOP );      */        
             wind_set(w_h, WF_TOP );             
             break;

        case WM_CLOSED:
             /*........................ WM_CLOSED (GEM message)............*/
             /* Ce message est envoy a notre procedure de fenetre         */
             /* lorsqu'une demande de fermeture de la fenetre est demandee */
             /* si vous voulez detruire completement cette fenetre il faut */
             /* appeler imperativement la fonction: DestroyWindow          */
             /* pour la reouvrir ensuite il vous faudra appeler la         */
             /* fonction:                           CreateWindow           */
             /* sinon il vous faut faire un simple: CloseWindow  et la     */
             /* reouvrir par:                       OpenWindow             */
             /* sans etre oblige de tout reinitialiser                     */
             /* CloseWindow(w_ind);                                        */
             if (!_app) 
                {int ind;
                 ind = IsWindExist(W_POPUP); 
                 if (ind>-1) SendWindMessage(Windtab[ind].w_h, WM_MODAL_END, 0);
                 ExeAllMessage();                      
                 ind = IsWindExist(W_RINFO); 
                 if (ind>-1) SendWindMessage(Windtab[ind].w_h, WM_CLOSED, 0);
                 ExeAllMessage();   
                 DestroyWindow(w_h); 
                }
             else 
                {EZGemRun = -1;    
                }                                 
             break;
             
        case WM_ALLICONIFY:    
             /**************************************************************/              
             /*........................ WM_ALLICONIFY (GEM message)........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier toutes les fenetres. EAZY_GEM met  votre*/
             /* disposition une fonction s'occupant de tout: AllIconify()  */
             /* vous pouvez lui donner en entree l'adresse d'une structure */
             /* GRECT, contenant des coordonnes d'iconification. Si vous  */
             /* placez zero alors EAZY_GEM les calcule pour vous.          */             
             AllIconify(0L);
             break;     
        case WM_ICONIFY:
             /**************************************************************/              
             /*........................ WM_ICONIFY (GEM message)...........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut iconifier une fenetre.EAZY_GEM met  votre service */
             /* une fonction s'occupant de tout: IconifyWindow()           */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             /* vous pouvez aussi lui donner en entree l'adresse d'une     */
             /* structure GRECT, contenant des coordonnes d'iconification.*/
             /* Si vous placez zero alors EAZY_GEM les calcule pour vous.  */ 
             IconifyWindow(w_ind, 0L);
             break;                                                    
        case WM_UNICONIFY:
             /**************************************************************/              
             /*........................ WM_UNICONIFY (GEM message).........*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* il faut desiconifier une fenetre.EAZY_GEM met  votre      */
             /* service une fonction s'occupant de tout: UnconifyWindow()  */
             /* Elle demande en entree l'indice EAZY_GEM de la fenetre    */
             /* iconifier.                                                 */
             UnconifyWindow(w_ind);            
             break;
        /*                  
        case WM_FULLED:
             break;
        case WM_ARROWED:
             break;
        case WM_HSLID:
             break;
        case WM_VSLID:
             break;
        */     
        case WM_SIZED:    
             /**************************************************************/              
             /*........................ WM_SIZED (GEM message).............*/   
             /* dans cet exemple je traite ce message avec le suivant      */      
        case WM_MOVED:
             /**************************************************************/              
             /*........................ WM_MOVED (GEM message).............*/
             /* Ce message est envoy a notre procedure de fenetre lorsque */
             /* on lui demande de a jour ses dimensions apres une demande  */
             /* de changement de taille lors de l'appui sur une case de    */
             /* dimensionnement, ou lors d'une demande logicielle.         */
             /* ou apres une modification des coordonnes de la fenetre     */
             /* les dimmensions externes de la fenetre sont recuperables   */
             /* la ou classiquement le GEM les place  dans:                */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]   ce qui n'est pas l'endroit logique  */ 
             /*      ou elles doivent etre selon EZ_GEM.                   */   
             /* Donc il vaut mieux les recopier en:                        */              
             /*      Evnt->pipe[X_B],Evnt->pipe[Y_B],Evnt->pipe[W_B], et   */
             /*      Evnt->pipe[H_B]  et placer les dimensions interieures */ 
             /*      apres calcul avec: WindGemBorderToEZWork, en          */
             /*      Evnt->pipe[X_G],Evnt->pipe[Y_G],Evnt->pipe[W_G], et   */
             /*      Evnt->pipe[H_G]                                       */ 
             Xform_moved(w_ind, Evnt);                                     
             break;
        /*     
        case WM_NEWTOP:
             break;
        case AC_OPEN:
             break;
        case AC_CLOSE:
             break;                                                                   
        */
       }
    }      
 return Evnt->evnt;    /* retourner le flux evenementiel (modifie ou pas)    */
}



/*---------------------------- MakeStrInfoOb --------------------------------*/
/* ACTION: cette fonction sert  creer le texte de la bulle d'aide affichant */
/*         le numero de l'objet et ceux de sa descendance                    */

char *MakeStrInfoOb(void* adr_rsc, int num_tree, int num_ob, char *sztt_txt)
{char strnum[32];
 OBJECT *object;
 
 xrsrc_gaddr (R_TREE, num_tree, &object, adr_rsc);
 strcpy(sztt_txt, PtStrMess[RSC_AID]); 
 strcat(sztt_txt, "|Objet:         ");
 strcat(sztt_txt,itoa(num_ob,strnum,10) ); 
 strcat(sztt_txt,"|Ob_Frere:      "); 
 strcat(sztt_txt, itoa(object[num_ob].ob_next,strnum,10) ); 
 strcat(sztt_txt,"|Ob_First fils: "); 
 strcat(sztt_txt, itoa(object[num_ob].ob_head,strnum,10) ); 
 strcat(sztt_txt,"|Ob_Last  fils: "); 
 strcat(sztt_txt, itoa(object[num_ob].ob_tail,strnum,10) );
 return 0; 
}

/*-------------------------- ActiveWindow -------------------------------*/
/* ACTION: Cette fonction active une fenetre specifiee. Soit elle        */
/*         existe deja et alors elle est activee par mise au premier     */
/*         plan,desiconification, ouverture eventuelle. Soit elle        */
/*         n'existe pas et alors elle est creee.                         */
/* ENTREE:                                                               */
/*  long w_attr: attributs GEM classique d'une fenetre                   */
/*               trois attributs de plus:                                */
/*                         BORDER permet d'avoir un cadre epais en       */
/*                                  relief autour de la fenetre.         */
/*                         XMOVER permet d'avoir une poigne de deplace- */
/*                                ment sur le bord sup du cadre epais    */
/*                         XSIZER permet l'agrandissement de la fenetre  */
/*                                en cliquant sur le cadre epais         */
/*  int Ident:  nbr arbitraire(jamais nul) que vous devez donner. Cela   */
/*              peut servir  reperer tel ou tel type de fenetre dans    */
/*              votre programme. Exemple votre application comporte      */
/*              plusieurs fenetres dont une de menu  laquelle vous      */
/*              donnez int ident=2 lors de sa cration. Il est           */
/*              alors facile pour le programme de savoir si la fenetre   */
/*              menu est ouverte en faisant appel  la fonction          */
/*              int IdentToIndice(2); qui vous retourne l'indice de la   */
/*              fenetre (si elle n'existe pas l'indice est >= MAX_WIND ) */
/*              pensez  utiliser des type symboliques declars avec:    */
/*              #define FENETRE_TRUC 2  plutot qu'un nombre sans sens.   */
/*                                                                       */
/* char *title: titre de la fenetre                                      */
/*              de meme le titre de la fenetre peut etre modifie au sein */
/*              de la procedure de fenetre lors du traitement du message */
/*              WM_CONTRUCT.                                             */
/*                                                                       */
/*  CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt): L vous donnez le nom   */
/*              fonction qui sera charge de gerer tous les evenements   */
/*              de cette fenetre. Cette fonction sera appelee par la     */
/*              sur couche EAZY_GEM.                                     */

void ActiveWindow(int ident, long attr, char *title, CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt))
{int w_ind;
 w_ind = IsWindExist(ident);
 if (w_ind==-1)                 /* << SI existe pas la creer         */
    {CreateWindow(attr, ident,0L,w_proc, 0,20+((Ecran_h-20)>>1),Ecran_l,(Ecran_h-20)>>1, title);
    }
 else                           /* << SI elle existe                  */
    {if (Windtab[w_ind].w_flag & W_IS_ICON || 
				 Windtab[w_ind].w_flag & W_IS_ALLICON
			  )
			  {UnconifyWindow(w_ind); 
			  }
     else if (IsWindOpen(w_ind))     /*        SI ouverte la mettre au top */
        {wind_set(Windtab[w_ind].w_h,WF_TOP);
        }
     else                       /*        SI pas ouverte l'ouvrir     */
        {OpenWindow(w_ind, &Windtab[w_ind].ExtGrectUse);
        } 
    } 
}
