/* DEF_RSD.C V1.0                  Septembre 1993 - Juin 1996

   --------------

  Ces procedures peuvent etre copies librement,  la condition que l'entete

ne soit pas efface.

  J'espere qu'elles en aideront certains.

  Toute erreur lie a l'utilisation de ces procdures, ne saurait en aucun 

cas tre de la responsabilit de son auteur.

  Aucune documentation n'a t utilise pour comprendre ces fichiers,

seule l'observation l'a permis donc prudence. Si vous avez des renseignements

plus precis sur le sujet, n'hesitez pas  me contacter.





Olivier LANDEMARRE

------------------



  On peut me contacter par mail: Olivier.landemarre@UTBM.FR

                                 --------------------------

*/

/* definitions des noms des objets pour differents editeurs de resource*/



/* pour RCP.prg livre avec Megamax LASER C :*.DEF */

/* pour RESOURCE.prg livre avec Marc Williams C : *.RSD */

/* nota: Les .DEF et RSD sont identiques tant que les objets sont du 

type menu, boite de dialogue, free. les autres entites quoi peuvent

etre crees par l'diteur ressource.prg ne sont pas reconnus et peuvent

peut etre entrainer un plantage des procedures????*/







typedef struct    /* structure du fichier .DEF (laser C) ou .RSD (MW)*/

{

	short nb_noms;	/* seul le deuxieme octet est sur */

					/* indique sur le premier objet du fichier le nombre 

					de noms enregistres dans le fichier .DEF pour les autres

					objets toujours a 0 */

	short inconnu;    /* pas de signification trouvee toujours a 0 apparement*/

	char arbre;		/* numero d'arbre auquel appartient l'objet (si arbre

						tj=0 */

	char numero;	/* Numero de l'objet ou de l'arbre et si il y a plus de 256 objets ????*/

	char what_is;	/* 0 si c'est un arbre 1 si c'est un objet */

	char type_tree; /* si c'est un arbre donne le type reconnu par RCP 

						(0: Unknown 1: Free 2: Menu 3: dialogue )

						pour RESOURCE (0,1,3 => Form, 2: Menu autres valeurs 

						non recherchees)

						sinon pour les objets la valeur = 0 */

	char nom[8];	/* le nom de l'objet ou de l'arbre en 8 caracteres maxi*/	

} DEF_RCP;





int ref_obj(name_obj,add,num_tree,num_obj)  /* recherche le numero de l'arbre 

                                 et de l'objet par son nom */

char *name_obj;

DEF_RCP *add; /* adresse debut du fichier .DEF ou .RSD*/

unsigned short *num_tree,*num_obj;

{ int i=0;

	DEF_RCP *pt;

	pt=add;

	while(i<add[0].nb_noms)

	{

		if(!strcmp(pt->nom,name_obj))

		{

			if((int)pt->what_is) /* si c'est un objet */

			{

				  *num_tree=(unsigned short)pt->arbre;

				  *num_obj=(unsigned short)pt->numero;

			}

			else  /* si c'est un arbre */

			{

				  *num_tree=(unsigned short)pt->numero;

			}

			return(1);

		}

		i++;

		pt++;

	}

	return(0);  /* on n'a rien trouv */

}



long obj_name(num_arbre,num_objet,add) /* renvoie le pt sur le nom de l'objet */

char num_arbre,num_objet;

DEF_RCP *add; /* adresse debut du fichier .DEF */

{

	int i=0;

	DEF_RCP *pt;

	pt=add;

	while(i<add[0].nb_noms)

	{

		if((int)pt->numero==(int)num_objet)

		{

			if((int)pt->what_is)

			{

				if((int)pt->arbre==(int)num_arbre)

				{

					return((long)pt->nom);		

				}

			}

		}

		pt++;

		i++;

	}

	return (NULL);

}



long ret_struct(num_arbre,num_objet,add) /* renvoie le pt sur la structure DEF de l'objet designe */

char num_arbre,num_objet;

DEF_RCP *add; /* adresse debut du fichier .DEF */

{

	int i=0;

	DEF_RCP *pt;

	pt=add;

	while(i<add[0].nb_noms)

	{

		if((int)pt->numero==(int)num_objet)

		{

			if((int)pt->what_is)

			{

				if((int)pt->arbre==(int)num_arbre)

				{

					return((long)pt);		

				}

			}

		}

		pt++;

		i++;

	}

	return (NULL);

}



long tree_name(num_arbre,add) /* renvoie le pt sur le nom de l'arbre */

char num_arbre;

DEF_RCP *add; /* adresse debut du fichier .DEF */

{

	int i=0;

	DEF_RCP *pt;

	pt=add;

	while(i<add[0].nb_noms)

	{

		if(!(int)pt->what_is)

		{	

			if((int)pt->numero==(int)num_arbre)

			{	

					return((long)pt->nom);		

			}

		}

		pt++;

		i++;

	}

	return (NULL);

}





int is_exist(_nom,add) /* renvoie le numero d'arbre et d'objet si le nom existe*/

						/* sinon -1 */

char *_nom;

DEF_RCP *add; /* adresse debut du fichier .DEF */

{

	int i=0,*pt2;

	DEF_RCP *pt;

	pt=add;

	while(i<add[0].nb_noms)

	{

		if(!strcmp(_nom,pt->nom))

		{

			pt2=(int *)&add->arbre;

			return(*pt2);

		}

		pt++;

		i++;

	}

	return (-1);

}



	



short liste_arbres_menu(add_def,txt)  /* liste le nom des MENUS, retourne le nombre d'objets de ce type */

DEF_RCP *add_def; /* adresse debut du fichier .DEF ou .RSD */

char *txt;  /* pointeur sur le buffer o l'on met les noms des arbres de type MENU*/

{ short nb_arbres=0,i=0;

  DEF_RCP *pt;

	pt=add_def;

	*txt=0;

	while(i<add_def[0].nb_noms)

	{

		if(!(int)pt->what_is)

		{

			if((int)pt->type_tree==2)   /* type MENU */

			{

				strcat(txt,pt->nom);

				strcat(txt,"\015\012");

				nb_arbres++;		

			}

		}

		pt++;

		i++;

	}

	return(nb_arbres);

}



short liste_arbres_dialog(add_def,txt)  /* liste le nom des DIALOGS, retourne le nombre d'objets de ce type */

DEF_RCP *add_def; /* adresse debut du fichier .DEF ou .RSD */

char *txt;  /* pointeur sur le buffer o l'on met les noms des arbres de type MENU*/

{ short nb_arbres=0,i=0;

  DEF_RCP *pt;

	pt=add_def;

	*txt=0;

	while(i<add_def[0].nb_noms)

	{

		if(!(int)pt->what_is)

		{

			if((int)pt->type_tree!=2)   /* type diffrent de MENU */

			{

				strcat(txt,pt->nom);

				strcat(txt,"\015\012");

				nb_arbres++;		

			}

		}

		pt++;

		i++;

	}

	return(nb_arbres);

}



short liste_tous_arbres(add_def,txt)  /* liste le nom des arbres, retourne le nombre d'arbres */

DEF_RCP *add_def; /* adresse debut du fichier .DEF ou .RSD */

char *txt;  /* pointeur sur le buffer o l'on met les noms des arbres de type MENU*/

{ short nb_arbres=0,i=0;

  DEF_RCP *pt;

	pt=add_def;

	*txt=0;

	while(i<add_def[0].nb_noms)

	{

		if(!(int)pt->what_is)

		{

			strcat(txt,pt->nom);

			strcat(txt,"\015\012");

			nb_arbres++;		

		}

		pt++;

		i++;

	}

	return(nb_arbres);

}





char *liste_les_objets(num_root,add) /* copie tous les noms des objets de l'arbre num_root*/

short num_root; /* numro de l'arbre concern */

DEF_RCP *add; /* adresse debut du fichier .DEF */

{ char *txt=NULL;

	int i=0,flag=0;

	DEF_RCP *pt;

	pt=add;

	txt=calloc(1,10000);

	if(txt!=NULL)

	{

		while(i<add[0].nb_noms)

		{

			if((int)pt->what_is)

			{

				if((int)pt->arbre==(int)num_root)

				{

					strcat(txt,pt->nom);

					strcat(txt,"\015\012");

					flag++;		

				}

			}

			pt++;

			i++;

		}

	}

	else form_alert(1,"[2][Pb d'allocation mmoire pour|la liste d'lments][Ok]");

	if(flag==0)

	{

		free(txt);

		txt=NULL;

	}

	return(txt);

}



char *liste_des_noms(add_def,nb)

DEF_RCP *add_def;

unsigned int *nb; /* nb de lignes */

{ static char *buf=NULL;

	short i=0,j=0;

  DEF_RCP *pt,*pt2;

  *nb=0;

	if(buf==NULL)

	{

		buf=calloc(10000);

		if(buf==NULL) return(NULL);

	}

	else

	{

		efface_bloc(buf,10000);

	}

	

	pt=add_def;

	*buf=0;

	while(i<add_def[0].nb_noms)

	{

		if(!(int)pt->what_is)

		{

			strcat(buf,pt->nom);

			strcat(buf,"\015\012");

			*nb+=1;

			j=0;

			pt2=add_def;

			while(j<add_def[0].nb_noms)

			{

				if((int)pt2->what_is)

				{

					if((int)pt2->arbre==(int)pt->numero)

					{

						strcat(buf,"   ");

						strcat(buf,pt2->nom);

						strcat(buf,"\015\012");

						*nb+=1;				

					}

				}

				j++;

				pt2++;

			}

				

		}

		pt++;

		i++;

	}

	return(buf);

}

