/*************************************************************************
 *  GemForm.C : Fonctions de gestion des formulaires en fenetre.         *
 *************************************************************************/

#include "WindGem.h"
#include "winproto.h"
#include <unistd.h>

/* Fonctions privees, internes a gemform */
static void WindFormDo(Wind *wind, int evnt);
static int do_keybd(OBJECT *tree, int objc);
static void gere_boutons(void);
static void gere_clavier(void);
static void EvntSpe (int *evnt);
/*-----------------------------------------------------------------------*
 * Initialisation des fenetres formulaires.                              *
 *                                                                       *
 * numObj     : index de l'objet a mettre en fenetre                     *
 * inf_x      : position X de la fenetre au depart                       *
 * inf_y      : position Y de la fenetre au depart                       *
 * title      : titre du formulaire                                      *
 * edit       : numero du 1er champ editable                             *
 * fonct      : fonction de gestion du formulaire                        *
 *                                                                       *
 * Derniere modification : 22/06/1996                                    *
 *-----------------------------------------------------------------------*/
void WindFormInit(int numObj, int mode, int inf_x, int inf_y, char *title, int edit, void (*fonct)(int evnt))
{
	int wx, wy, ww, wh;
	int offset = 0, inf_flag = 0;
	OBJECT *adrForm;
	GRECT pos;
	WindForm *ptr_dial = (WindForm *)malloc(sizeof(WindForm));

	rsrc_gaddr(R_TREE, numObj, &adrForm);
	ptr_dial->adr_form = adrForm;
	if (adrForm->ob_state & OUTLINED)	/* Ce decalage est invariable !!! */
		ptr_dial->offset = offset = 3;
	else
	{
		if (global[1] > 1) /* Si Multitache */
			ptr_dial->offset = 1; /* surtout pour Magic 4 */
		else
			ptr_dial->offset = 0;
	}		

	form_center(adrForm, &wx, &wy, &ww, &wh);
	wind_calc(WC_BORDER, FW_ATTRIB, wx, wy, ww, wh, &wx, &wy, &ww, &wh);
	if (inf_x != 0 || inf_y != 0)
	{	/* si valeurs lues dans fichier .INF ... */
		wx = inf_x; wy = inf_y;
		inf_flag = TRUE;
	}
	pos.g_x = wx;
	pos.g_y = wy;
	pos.g_w = ww;
	pos.g_h = wh;
	ptr_dial->edit			= edit;
	ptr_dial->edit_objc = edit;
	ptr_dial->edit_pos 	= 0;
	/* Gestion de l'aide en ligne */
	ptr_dial->aide			= (AIDE *)NULL;
	ptr_dial->popup			= (POPUP *)NULL;
	ptr_dial->fonct			= fonct;
	
	if (inf_flag)
	{	/* ... alors recaler le formulaire sur la fenetre. */
		wind_calc(WC_WORK, FW_ATTRIB, wx, wy, ww, wh, &wx, &wy, &ww, &wh);
		adrForm->ob_x = wx + offset;
		adrForm->ob_y = wy + offset;
	}
	set_user(adrForm);							/* Etablissement des boutons USERDEFS. */
	
	AjouteListe (WTYPFORM, mode == WNORM ? FW_ATTRIB : NAME, numObj, mode, title, pos, (void *)ptr_dial);
}

/*-----------------------------------------------------------------------*
 * Ouverture d'une fenetre.                                              *
 *                                                                       *
 * numObj			: numero de l'objet a afficher.                            *
 *                                                                       *
 * Derniere modification : 26/04/1996                                    *
 *-----------------------------------------------------------------------*/
void WindOpen(int numObj)
{
	int attrib;
	Wind *wind;
	OBJECT *ptr_objc;
	WindForm *ptr_dial;
	WindUser *ptr_user;

	wind = ObjListe(numObj);

	attrib = wind->attrib;

	if (wind->handle != BLANK)
		wind_set(wind->handle, WF_TOP);
	else
	{
		if ((wind->handle = wind_create(attrib, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos)) != 0)
		{
			wind_set(wind->handle, WF_NAME, wind->w_title);
			graf_growbox(0, 0, 0, 0, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
			wind_open(wind->handle, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);

			switch(wind->type)
			{
				case WTYPFORM :
					ptr_dial = wind->cont.dialog;
					ptr_dial->edit_objc = ptr_dial->edit;
					ptr_objc = &(ptr_dial->adr_form[ptr_dial->edit]);
					if ((ptr_objc->ob_flags & EDITABLE) != 0)
						ptr_dial->edit_pos = (int)strlen((ptr_objc->ob_spec.tedinfo)->te_ptext);
					/* Envoi de l'evenement OPEN a la fenetre */
					(*ptr_dial->fonct)(EV_OPEN);
					break;
				case WTYPTEXT :
					WindTextSliders (wind);
					break;
				case WTYPUSER :
					ptr_user = wind->cont.user;
					if (ptr_user->init)
						(*ptr_user->init)();
					break;
			}
			/* Si fenetre modale, on bloque les evenements MU_MESSAG */
			if (wind->mode == WMODAL)
			{
				Sys->lastMode = WMODAL;
				wind_update(3);
			}
		}
		else
		{
			form_alert(1, "[3][   Il n'y a plus de| fentres disponibles !"
										"| Fermez une fentre que|  vous n'utilisez pas.][Confirmer]");
		}
	}
}

/*-----------------------------------------------------------------------*
 * Fermeture d'une fenetre.                                              *
 *                                                                       *
 * numObj  : Numero de la fenetre                                        *
 *                                                                       *
 * Derniere modification : 25/04/1996                                    *
 *-----------------------------------------------------------------------*/
void WindClose(int numObj)
{
	Wind *wind;

	wind = ObjListe(numObj);

	/* Si fenetre modale, on reautorise les evenements MU_MESSAG */
	if (wind->mode == WMODAL)
	{
		Sys->lastMode = WNORM;
		wind_update(2);
	}
	wind_close(wind->handle);
	wind_delete(wind->handle);
	graf_shrinkbox(0, 0, 0, 0, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
	wind->handle 	= BLANK;
}

/*-----------------------------------------------------------------------*
 * Destruction d'une fenetre.                                            *
 *                                                                       *
 * numObj  : Numero de la fenetre                                        *
 *                                                                       *
 * Derniere modification : 25/04/1996                                    *
 *-----------------------------------------------------------------------*/
void WindDelete(int numObj)
{
	Wind *wind;

	wind = ObjListe(numObj);

	/* Si fenetre ouverte, on la ferme */
	if (wind->handle > 0)	/* CORRECTION */
	{
		wind_close(wind->handle);
		wind_delete(wind->handle);
		graf_shrinkbox(0, 0, 0, 0, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
	}

	/* Si menu en fentre, librer mmoire utilise par le menu */
	if (wind->adr_wmenu != (OBJECT *)NULL)
		free(wind->adr_wmenu);

	if (wind->type == WTYPFORM)
	{
		WindForm *ptr_dial = wind->cont.dialog;
		AIDE *aide = ptr_dial->aide, *tmp;
		POPUP *popup = ptr_dial->popup, *tmp1;

		while (aide != (AIDE *)NULL)		
		{
			tmp = aide;
			aide = aide->suiv;
			free (tmp->txt);
			free (tmp);
		}
		while (popup != (POPUP *)NULL)
		{
			tmp1 = popup;
			popup = popup->suiv;
			free (tmp1);
		}
		free (wind->cont.dialog);
	}
	else if (wind->type == WTYPTEXT)
	{
		WindText *ptr_txt = wind->cont.text;
		if (ptr_txt->type == TYP_TEXT_AUTO)	/* Si texte venant d'un fichier  */
			free (ptr_txt->lignes);						/* uniquement !!                 */
		free (wind->cont.text);
	}
	else
		free(wind->cont.user);

	wind->handle 	= BLANK;
	wind->numObj	= BLANK;
	wind->attrib	= ZERO;
	wind->mode		= WNORM;
	wind->type 		= WTYPNONE;
	free (wind->w_title);
}

/*************************************************************************
 * fonctions de gestion des evenements                                   *
 *************************************************************************/

/*-----------------------------------------------------------------------*
 * Fonction de redessin d'un objet d'un formulaire en fentre.           *
 *                                                                       *
 * arbre 	: numro de l'arbre d'objets                                   *
 * objet  : objet  redessinner                                          *
 *                                                                       *
 * Auteur : G oubli...argh ! (mais c pas moi)                           *
 *-----------------------------------------------------------------------*/
void WindDraw(int arbre, int objet)
{
	GRECT r;
	int dummy, top;
	Wind *wind;
	WindForm *ptr_form;
  
  wind = ObjListe(arbre);
  ptr_form = wind->cont.dialog;
  
  if ( wind->handle > 0)  /* la fenetre existe ? */
  {
    wind_update(BEG_UPDATE);
    wind_get(0, WF_TOP, &top, &dummy, &dummy, &dummy);
    if ( wind->handle == top) /* si topped, on optimise... */        
      objc_draw(ptr_form->adr_form, objet, MAX_DEPTH, wind->Xpos,
        wind->Ypos, wind->Wpos,wind->Hpos);
        
    else
    {
	    wind_get(wind->handle, WF_FIRSTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
      while (r.g_w && r.g_h)
      {
        objc_draw(ptr_form->adr_form, objet, MAX_DEPTH, r.g_x, r.g_y,
                              r.g_w, r.g_h);
  		  wind_get(wind->handle, WF_NEXTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
      }
    }
    wind_update(END_UPDATE);
  }
}

/*-----------------------------------------------------------------------*
 * Fonction de gestion des formulaires en fenetre                        *
 *                                                                       *
 * wind 	: objet Wind a traiter                                         *
 * event  : evenement a traiter                                          *
 *                                                                       *
 * Derniere modification : 21/04/1996                                    *
 *-----------------------------------------------------------------------*/
static void WindFormDo(Wind *wind, int evnt)
{
	GRECT r, rd;
	int wx, wy, ww, wh;
	int dialog = TRUE, object, init_field = FALSE;
	WindForm *ptr_dial = wind->cont.dialog;
	
	if ((evnt > 0) && (evnt & MU_MESAG))
	{
		switch(buff[0])
		{
			case WM_REDRAW :
				rd.g_x = buff[4]; rd.g_y = buff[5];
				rd.g_w = buff[6]; rd.g_h = buff[7];
				if (wind->iconified == TRUE)
				{
					DrawIcone (wind->handle, &rd);
				}
				else
				{
					if (ptr_dial->edit_objc)
					{	/* si champ editable et ....*/
						wind_get(0, WF_TOP, &wx, &wy, &ww, &wh);
						if (wind->handle == wx)
						{ /*...si fenetre au 1 plan -> redessin total */
							wind_get(wind->handle, WF_WORKXYWH, &rd.g_x, &rd.g_y, &rd.g_w, &rd.g_h);
							init_field = EDEND;
						}
					}
					wind_update(BEG_UPDATE);
					wind_get(wind->handle, WF_FIRSTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
					while (r.g_w && r.g_h)
					{
    	    	/* On commence par afficher la barre de menu s'il y en a une */
						if (wind->adr_wmenu != (OBJECT *)NULL)
	      		  objc_draw (wind->adr_wmenu, BARMENU, MAX_DEPTH, r.g_x, r.g_y, r.g_w, r.g_h);
						if (wind->adr_wtoolbar != (OBJECT *)NULL)
	      		  objc_draw (wind->adr_wtoolbar, ROOT, MAX_DEPTH, r.g_x, r.g_y, r.g_w, r.g_h);

						if (rc_intersect(&rd, &r))
							objc_draw(ptr_dial->adr_form, 0, 8, r.g_x, r.g_y, r.g_w, r.g_h);
						wind_get(wind->handle, WF_NEXTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
					}
					wind_update(END_UPDATE);
					if (ptr_dial->edit_objc && init_field)
						objc_edit(ptr_dial->adr_form, ptr_dial->edit_objc, 0, ptr_dial->edit_pos, init_field, &(ptr_dial->edit_pos));
				}
				break;

			case WM_TOPPED :
				wind_set(wind->handle, WF_TOP);
				if (ptr_dial->edit_objc && global[1] > 1)
				{
					wind_get(buff[3], WF_WORKXYWH, &wx, &wy, &ww, &wh);
					form_dial(FMD_FINISH, 0,0,0,0, wx, wy, ww, wh);				
				}
				break;

			case WM_CLOSED : 
				/* Envoi de l'evenement fermeture a l'utilisateur pour trtmt */
				(*ptr_dial->fonct)(EV_CLOSE);
				WindClose(wind->numObj);
				break;

			case WM_MOVED :
				wind_set(wind->handle, WF_CURRXYWH, buff[4], buff[5], buff[6], buff[7]);
				if (wind->iconified == FALSE)
				{
					wind->Xpos = buff[4];
					wind->Ypos = buff[5];
					wind_get(wind->handle, WF_WORKXYWH, &wx, &wy, &ww, &wh);
					ptr_dial->adr_form->ob_x = wx + ptr_dial->offset;
					if (wind->adr_wmenu != (OBJECT *)NULL || wind->adr_wtoolbar != (OBJECT *)NULL)
					{
						ptr_dial->adr_form->ob_y = wy + ptr_dial->offset;
						if (wind->adr_wmenu != (OBJECT *)NULL)
						{
							ptr_dial->adr_form->ob_y += wind->adr_wmenu[BARTITLE].ob_height;
							wind->adr_wmenu->ob_x = wx;
							wind->adr_wmenu->ob_y = wy + ptr_dial->offset;
						}
						if (wind->adr_wtoolbar != (OBJECT *)NULL)
						{
							ptr_dial->adr_form->ob_y += wind->adr_wtoolbar->ob_height + 2;
							wind->adr_wtoolbar->ob_x = wx;
							wind->adr_wtoolbar->ob_y = wy;
							if (wind->adr_wmenu != (OBJECT *)NULL)
								wind->adr_wtoolbar->ob_y += wind->adr_wmenu[BARTITLE].ob_height + 2;
						}
					}
					else
						ptr_dial->adr_form->ob_y = wy + ptr_dial->offset;
				}
				break;
				
			case WM_ICONIFY :
				graf_shrinkbox(buff[4], buff[5], buff[6], buff[7], wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
				wind_set(wind->handle, WF_ICONIFY, buff[4], buff[5], buff[6], buff[7]);
				wind->iconified = TRUE;
				break;
				
			case WM_UNICONIFY :
				graf_growbox( wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos, buff[4], buff[5], buff[6], buff[7]);
				wind_set(wind->handle, WF_UNICONIFY, buff[4], buff[5], buff[6], buff[7]);
				wind->iconified = FALSE;
				break;
		}
	}
	else if (evnt == EV_HELP)
	{
/* Gestion du bouton HELP, enfin pas encore... */		
	}
}

/*-----------------------------------------------------------------------*
 * Gestion du clavier.                                                   *
 *                                                                       *
 * tree : arbre d'objet a gerer                                          *
 * objc : numero d'objet dans l'arbre                                    *
 *                                                                       *
 * Derniere modification : 21/04/1996                                    *
 *-----------------------------------------------------------------------*/
static int do_keybd(OBJECT *tree, int objc)
{
	int dialog, len, index, key_short, pos;
	char *ed_text;
	unsigned char dum;
	OBJECT *ptr_objc;

	dialog = form_keybd(tree, objc, objc, Sys->key, &(Sys->new_objc), &(Sys->key));
	if (dialog)
	{
		if (Sys->key == 0)
		{
			if (Sys->new_objc != 0)
			{
				ptr_objc = &tree[Sys->new_objc];
				Sys->new_pos = (int) strlen((ptr_objc->ob_spec.tedinfo)->te_ptext);
			}
			else
				Sys->new_pos = 0;
		}
		else
		{
			if (objc)
			{
				pos = Sys->new_pos;
				
				ptr_objc = &tree[objc];
				ed_text = (ptr_objc->ob_spec.tedinfo)->te_ptext;
				len = (int) strlen(ed_text);
				switch (Sys->key)
				{
					case 0x7300 :		/* Control <- : Curseur en debut de Champ */
						pos = 0;
						Sys->key = 0;
						break;
					case 0x7400 :		/* Control -> : Curseur en fin de Champ */
						pos = len;
						Sys->key = 0;
						break;
					case 0x4b34 :		/* SHIFT <- : Saute un mot	*/
						while (pos)
						{
							pos--;
							if (ed_text[pos] == ' ')
								break;
						}
						Sys->key = 0;
						break;
					case 0x4d36 :		/* SHIFT -> : Saute un mot	*/
						while (pos < len)
						{
							pos++;
							if (ed_text[pos] == ' ')
								break;
						}
						if (pos < len)
							pos++;
						Sys->key = 0;
						break;
				}
				Sys->new_pos = pos;
			}
			if (Sys->key != 0 && Sys->kbd == K_ALT)
			{	/* Raccourcis claviers	*/
				key_short = stdkey(&dum);
				index = 1;
				do
				{
					ptr_objc = &tree[index]; /* pointe sur l'objet a traiter */
					ed_text = 0;
					if (((ptr_objc->ob_state&DISABLED)==0) && ((ptr_objc->ob_type & 0x200) != 0))
					{ /* si l'objet n'est pas desactive	*/
						switch (ptr_objc->ob_type & 0xff)
						{
							case G_BUTTON :
								ed_text = ptr_objc->ob_spec.free_string;
								break;
							case G_USERDEF :
								ed_text = (char *)((ptr_objc->ob_spec.userblk)->ub_parm);
						}
						if (ed_text && (ed_text = strchr(ed_text, '[')) != 0)
						{
							if (key_short == toupper(ed_text[1]))
							{ /* Simuler un clic sur l'objet et retour : */
								Sys->key = 0;
								Sys->objet = index;
								form_button(tree, index, 1, &(Sys->new_objc));
								evnt_timer(100,0);
								return -1;
							}
						}
					}
					index ++; /* Prepare l'objet suivant ... */
				/* ... sauf si l'objet actuel est le dernier : */
				} while((ptr_objc->ob_flags & LASTOB) == 0);
			}
		}
	}
	return dialog;
}

/*-----------------------------------------------------------------------*
 * Fonction de remplacement du Form_do du GEM.                           *
 *                                                                       *
 * Derniere modification : 17/05/1996                                    *
 *-----------------------------------------------------------------------*/
int EventMulti (void)
{
	static int xmouse = 0, ymouse = 0;
	int evnt;								/* Type d'vnement                            */
	int top, dummy;
	Wind *wind;							/* Pointeur pour element de liste de fenetre   */
	WindForm *ptr_dial;
		
	Sys->objet = ZERO;			/* Mise  zro avant de commencer              */

	while (TRUE) 						/* BOUCLE "SANS FIN"                           */
	{ /* Surveillance des vnements Clavier, Clic, Message et Timer       */
		evnt = evnt_multi ((MU_MESAG|MU_BUTTON|MU_KEYBD|MU_TIMER),
											 258, 3, 0,	/* au lieu de 2,1,1 pour gerer les deux boutons */
											 ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO,
											 buff, 500, 0,
											 &(Sys->mousex), &(Sys->mousey), &(Sys->mousek),
											 &(Sys->kbd), &(Sys->key), &(Sys->clik));

/*-----------------------------------------------------------------------*
 * Gestion des evenements Timer.                                         *
 *-----------------------------------------------------------------------*/
		if (evnt & MU_TIMER)
		{
			int mx, my;
			
			graf_mkstate (&mx, &my, &dummy, &dummy);
  		if (xmouse == mx && ymouse == my)
  		{
				wind_get (ZERO, WF_TOP, &top, &dummy, &dummy, &dummy);
				wind = TopListe(top);

				if (wind != WIND_NULL && wind->type == WTYPFORM && NOT wind->iconified)
				{
					ptr_dial = wind->cont.dialog;
					Sys->AdrObjet = ptr_dial->adr_form;
					Sys->objet = objc_find (Sys->AdrObjet, ROOT, MAX_DEPTH, Sys->mousex, Sys->mousey);
					AfficheAide (wind, Sys->objet);
				}
			}
			else
			{
  			xmouse = mx;
 				ymouse = my;
			}
		}
	
/*-----------------------------------------------------------------------*
 * Gestion des evenements clavier.                                       *
 *-----------------------------------------------------------------------*/
		if (evnt & MU_KEYBD)			
			gere_clavier();

/*-----------------------------------------------------------------------*
 * Gestion des evenements Message                                        *
 *-----------------------------------------------------------------------*/
 		if ((evnt & MU_MESAG) && buff[0] == MN_SELECTED && AdrMenu != (OBJECT *)NULL)
		{	/* Appel a la fonction de gestion du menu */
			int opt = buff[3];
			(*Sys->menu)(buff[4]);
			menu_tnormal(AdrMenu, opt, 1);
		}
		else if (evnt & MU_MESAG)										 /* Si vnement message */
		{
			/* Recupere fenetre qui a recu le message */
			wind = TopListe(buff[3]);

			if (wind != WIND_NULL)
			{
				CurWindow = wind->numObj;
				switch (wind->type)
				{
					case WTYPFORM :
						WindFormDo(wind, evnt);
						break;
					case WTYPTEXT :
						WindTextDo(wind, evnt);
						break;
					case WTYPUSER :
						WindUserDo (wind, evnt);
						break;
				}			
			}
    }
/*-----------------------------------------------------------------------*
 * Gestion des evenements Bouton                                         *
 *-----------------------------------------------------------------------*/

		if (evnt & MU_BUTTON)
		{
			if (Sys->mousek == 2 && Sys->popMenu != BLANK)
				pop_up (BLANK, BLANK, Sys->popMenu);
			else
				gere_boutons();
		}

		return evnt;
	}
}

/*-----------------------------------------------------------------------*
 * Deselection d'un objet d'un arbre donne                               *
 *                                                                       *
 * arbre	 : Numero de l'arbre d'objets                                  *
 * numObjc : Numero de l'objet                                           *
 *-----------------------------------------------------------------------*/
void ObjcUnselect(int arbre, int numObjc)
{
	Wind *wind;
	WindForm *ptr_form;
	
	/* On recupere les info sur l'arbre d'objet */
	wind = ObjListe(arbre);
	if (wind != WIND_NULL)
	{
		ptr_form = wind->cont.dialog;
		objc_change(ptr_form->adr_form, numObjc, 0, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos, 0, TRUE);
	}
}

/*-----------------------------------------------------------------------*
 * Initialise l'objet <objet> de l'arbre <arbre> avec <valeur>           *
 *-----------------------------------------------------------------------*/
void SetValeur (int arbre, int objet, char *valeur)
{
	Wind *wind;
	WindForm *ptr_dial;
	
	wind = ObjListe(arbre);
	if (wind != WIND_NULL)
	{
		ptr_dial = wind->cont.dialog;
		set_text(ptr_dial->adr_form, objet, valeur);
	}
}

/*-----------------------------------------------------------------------*
 * Retourne la valeur de l'objet <objet> de l'arbre <arbre>              *
 *-----------------------------------------------------------------------*/
char *GetValeur (int arbre, int objet)
{
	Wind *wind;
	WindForm *ptr_dial;
	
	wind = ObjListe(arbre);
	if (wind != WIND_NULL)
	{
		ptr_dial = wind->cont.dialog;
		return get_text(ptr_dial->adr_form, objet);
	}
	else
		return (char *)NULL;
}

/*-----------------------------------------------------------------------*
 * Renvoie les coordonnes d'une fentre                                 *
 *-----------------------------------------------------------------------*/
void GetCoord (int numObj, GRECT *coord)
{
	Wind *wind;
	
	wind = ObjListe(numObj);
	if (wind != WIND_NULL)
	{
		coord->g_x = wind->Xpos;
		coord->g_y = wind->Ypos;
		coord->g_w = wind->Wpos;
		coord->g_h = wind->Hpos;
	}
	else
		coord = (GRECT *)NULL;
}

/*-----------------------------------------------------------------------*
 * Retourne le handle associ  une fentre quel que soit son type.      *
 *-----------------------------------------------------------------------*/
void GetWorkXYWH (int numObj, GRECT *coord)
{
	Wind *wind;
	
	wind = ObjListe(numObj);
	if (wind != WIND_NULL && wind->handle != BLANK)
	{
		wind_get(wind->handle, WF_WORKXYWH, &(coord->g_x), &(coord->g_y), &(coord->g_w), &(coord->g_h));
		if (wind->adr_wmenu != (OBJECT *)NULL)
		{
			coord->g_y += wind->adr_wmenu[BARTITLE].ob_height + 1;
			coord->g_h -= wind->adr_wmenu[BARTITLE].ob_height + 1;
		}
		if (wind->adr_wtoolbar != (OBJECT *)NULL)
		{
			coord->g_y += wind->adr_wtoolbar[ROOT].ob_height + 2;
			coord->g_h -= wind->adr_wtoolbar[ROOT].ob_height + 2;
		}
		if (wind->adr_wmenu != (OBJECT *)NULL && wind->adr_wtoolbar != (OBJECT *)NULL && global[1] == 1)
		{
			coord->g_y++;
			coord->g_h--;
		}
		else if (wind->adr_wtoolbar != (OBJECT *)NULL && global[1] > 1)
		{
			coord->g_y -= 2;
			coord->g_h += 2;
		}
	}
	else
		coord = (GRECT *)NULL;
}

/*-----------------------------------------------------------------------*
 * Retourne un pointeur sur la variable OBJECT associe  <arbre>        *
 *-----------------------------------------------------------------------*/
OBJECT *GetObject (int arbre)
{
	Wind *wind;
	WindForm *ptr_dial;
	
	wind = ObjListe(arbre);
	if (wind != WIND_NULL)
	{
	 	ptr_dial = wind->cont.dialog;
		return ptr_dial->adr_form;
	}
	else
		return (OBJECT *)NULL;

}

/*-----------------------------------------------------------------------*
 * Retourne le handle associ  une fentre quel que soit son type.      *
 *-----------------------------------------------------------------------*/
int GetHandle (int objet)
{
	Wind *wind;
	
	wind = ObjListe(objet);
	if (wind != WIND_NULL)
		return wind->handle;
	else
		return BLANK;

}

/*-----------------------------------------------------------------------*
 * Retourne le numero de l'objet EXIT qui vient d'etre selectionne       *
 *-----------------------------------------------------------------------*/
int GetObjet(void)
{
	return Sys->objet;
}

/*-----------------------------------------------------------------------*
 * Efface le contenu d'un champ d'un arbre d'objet                       *
 *-----------------------------------------------------------------------*/
void EffaceChamp (int arbre, int objet)
{
	Wind *wind;
	WindForm *ptr_dial;
	
	wind = ObjListe(arbre);
	if (wind != WIND_NULL)
	{
		ptr_dial = wind->cont.dialog;
		set_text(ptr_dial->adr_form, objet, "");
		objc_edit(ptr_dial->adr_form, objet, 0, ptr_dial->edit_pos, ED_END, &ptr_dial->edit_pos);
		objc_draw (ptr_dial->adr_form, objet, MAX_DEPTH,
							 ptr_dial->adr_form[objet].ob_x, ptr_dial->adr_form[objet].ob_y,	
							 ptr_dial->adr_form[objet].ob_width, ptr_dial->adr_form[objet].ob_height);
		objc_edit(ptr_dial->adr_form, objet, 0, 0, ED_INIT, &ptr_dial->edit_pos);
	}
}

/*-----------------------------------------------------------------------*
 * Gestion des evenements boutons                                        *
 *                                                                       *
 * Derniere modification : 17/05/1996                                    *
 *-----------------------------------------------------------------------*/
static void gere_boutons(void)
{
	int top, obflags, obstate, dummy, i, j, edit;
	Wind *wind;
	WindForm *ptr_dial;

	if (wind_find (Sys->mousex, Sys->mousey))
	{	/* Chercher fentre de 1er plan */
		wind_get (ZERO, WF_TOP, &top, &dummy, &dummy, &dummy);
		wind = TopListe(top);

		if (wind != WIND_NULL)
			CurWindow = wind->numObj;

		if (wind != WIND_NULL && wind->type == WTYPFORM && NOT wind->iconified)
		{
			ptr_dial = wind->cont.dialog;
			Sys->AdrObjet = ptr_dial->adr_form;
		}
		if (wind != WIND_NULL && NOT wind->iconified)
		{
			if (wind->adr_wmenu != (OBJECT *)NULL)
			{ /* a-t'on cliqu sur le menu en fentre */
		    Sys->objet = objc_find (wind->adr_wmenu, BARTITLE, MAX_DEPTH, Sys->mousex, Sys->mousey);
		 	  if (wind->adr_wmenu[Sys->objet].ob_type == G_TITLE)  /* Si clic sur un titre */
				{
					menu_wind (wind, Sys->objet);   /* On gre le menu en fentre */
					return;
				}
			}
			if (wind->adr_wtoolbar != (OBJECT *)NULL)
			{ /* a-t'on cliqu sur la ToolBar */
		    Sys->objet = objc_find (wind->adr_wtoolbar, ROOT, MAX_DEPTH, Sys->mousex, Sys->mousey);
		 	  if (Sys->objet > 0)  /* Si clic sur un objet du toolbar */
				{
					objc_change(wind->adr_wtoolbar, Sys->objet, 0, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos, 1, TRUE);
					(*wind->wtoolbar)(Sys->objet);
/*					objc_change(wind->adr_wtoolbar, Sys->objet, 0, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos, 0, TRUE);*/
					return;
				}
			}
			if (wind->type == WTYPUSER)
				WindUserDo (wind, MU_BUTTON);

			if (wind->type != WTYPFORM)
				return;
		}
	}
	else
		Sys->AdrObjet = AdrDesk;

	Sys->objet = objc_find (Sys->AdrObjet, ROOT, MAX_DEPTH, Sys->mousex, Sys->mousey); 

	if (Sys->objet > ZERO) 							/* Si on a cliqu sur un objet */
	{
		obflags = (Sys->AdrObjet)[Sys->objet].ob_flags;
		obstate = (Sys->AdrObjet)[Sys->objet].ob_state;

		if (NOT (obstate & DISABLED))		 /* Si l'objet n'est pas dsactiv */
		{
			int popup;

			if (obflags & EDITABLE)
			{ /* Desactiver curseur */
   	    objc_edit (Sys->AdrObjet, ptr_dial->edit_objc, 0, ptr_dial->edit_pos, EDEND, &(ptr_dial->edit_pos));
				/* Reactiver curseur */
 		  	objc_edit (Sys->AdrObjet, Sys->objet, 0, Sys->pos, EDINIT, &(Sys->pos));

				if (Sys->AdrObjet != AdrDesk)
				{
					ptr_dial->edit_objc	= Sys->objet;
					ptr_dial->edit_pos	= Sys->pos;
				}
			}

			if ((obflags & SELECTABLE) &&	(NOT (obflags & RBUTTON)))
			{	/* Si slectable simple, inverser l'etat de l'objet */
					(Sys->AdrObjet)[Sys->objet].ob_state ^= SELECTED; 

					objc_draw (Sys->AdrObjet, Sys->objet, MAX_DEPTH, 
									  (Sys->AdrObjet)->ob_x, (Sys->AdrObjet)->ob_y,
										(Sys->AdrObjet)->ob_width, (Sys->AdrObjet)->ob_height);

					evnt_timer(100,0);
				/* Appel  la fonction de gestion de la boite de dialogue */
				if (obflags & TOUCHEXIT || obflags & EXIT)
					(*ptr_dial->fonct)(MU_BUTTON);
			}
			else
			{
				if (NOT (obflags & TOUCHEXIT))	 /* Si ce n'est pas un TOUCHEXIT */
				{
					while (Sys->mousek)					 /* Attendre bouton souris relach */
						graf_mkstate (&dummy, &dummy, &(Sys->mousek), &dummy);
				}
			}

			if ((obflags & SELECTABLE) &&	(obflags & RBUTTON) && (NOT (obstate & SELECTED)))
			{	/* Si radio-bouton */
				j = Sys->objet;
				(Sys->AdrObjet)[Sys->objet].ob_state |= SELECTED;
	
				objc_draw (Sys->AdrObjet, Sys->objet, MAX_DEPTH,
									(Sys->AdrObjet)->ob_x, (Sys->AdrObjet)->ob_y, 
									(Sys->AdrObjet)->ob_width, (Sys->AdrObjet)->ob_height);

				i = parent (Sys->AdrObjet, j);			 /* Chercher le pre       */
				j = (Sys->AdrObjet)[i].ob_head; 		 /* Partir du 1 enfant... */
				i = (Sys->AdrObjet)[i].ob_tail; 		 /* jusqu'au dernier.      */
				do
				{
					if (((Sys->AdrObjet)[j].ob_flags & RBUTTON) && (j != Sys->objet) &&
							((Sys->AdrObjet)[j].ob_state & SELECTED))
					{ /* Les mettre en normal si RBUTTON sauf l'objet cliqu. */
						(Sys->AdrObjet)[j].ob_state &= ~SELECTED;
    
						objc_draw (Sys->AdrObjet, j, MAX_DEPTH, 
											(Sys->AdrObjet)->ob_x, (Sys->AdrObjet)->ob_y,
											(Sys->AdrObjet)->ob_width, (Sys->AdrObjet)->ob_height);
					}
					j = (Sys->AdrObjet)[j].ob_next; 				/* Au suivant...     */
				} while ((j <= i) && (j > (Sys->AdrObjet)[i].ob_next));
			}
			if (popup = IsPopup(wind, Sys->objet))
			{
				if (Sys->mousex < (Sys->AdrObjet[Sys->objet]).ob_x + (Sys->AdrObjet[ROOT]).ob_x + (Sys->AdrObjet[Sys->objet]).ob_width - 16)
					pop_up (wind->numObj, Sys->objet, popup);
				else
					PopupNextValeur (wind->numObj, Sys->objet, popup);
			}
		}
	}
}

/*-----------------------------------------------------------------------*
 * Gestion des evenements clavier                                        *
 *                                                                       *
 * Derniere modification : 17/05/1996                                    *
 *-----------------------------------------------------------------------*/
static void gere_clavier(void)
{
	int evnt = MU_KEYBD, i;
	char ctr = 0, option[50];
	unsigned char touc;
	int top, dummy;
	Wind *wind;
	WindForm *ptr_dial;
	int cur_pos, cur_objc, dialog = TRUE;

	/* On regarde s'il ne s'agit pas d'un evenement special */
	EvntSpe (&evnt);

	/* Recupere  l'etat des touches speciales */
	Sys->kbd = (int)Kbshift (BLANK);
	/* Annuler bit CapsLock           */
	Sys->kbd &= ~0x10;								 	 
	if ((Sys->kbd == K_RSHIFT) || (Sys->kbd == K_LSHIFT))
		ctr = 0x01;					 				 /* Car. reprsentant la touche spciale */
	else if (Sys->kbd == K_CTRL)
		ctr = 0x05E;
	else if (Sys->kbd == K_ALT)
		ctr = 0x07;
	else
		ctr = ZERO;

	wind_get (ZERO, WF_TOP, &top, &dummy, &dummy, &dummy);

	wind = TopListe(top);
  
 	if (wind != WIND_NULL)
	{
		CurWindow = wind->numObj;

		/* Si fenetre iconifiee, on oublie l'evenement */
		if (wind->iconified)
			return;

		/* Traitement des vnements spciaux */
		if (evnt != MU_KEYBD)
		{
			switch (wind->type)
			{
				case WTYPTEXT :
					WindTextDo(wind, evnt);
					break;
				case WTYPUSER :
					WindUserDo (wind, evnt);
					break;
			}
			if (wind->type != WTYPFORM)
				return;
		}
		if (wind->type == WTYPFORM)
		{
			ptr_dial			= wind->cont.dialog;
			Sys->AdrObjet = ptr_dial->adr_form;
			Sys->objet		= ptr_dial->edit_objc;
			Sys->new_objc	= Sys->objet;
			Sys->pos			= ptr_dial->edit_pos;
			Sys->new_pos	= Sys->pos;
		}
		else if (wind->type == WTYPUSER)
		{	/* Envoi touche spciale et code SCAN + ASCII */
			WindUserDo (wind, evnt);

			return;
		}
		else	
			return;
	}
	else
	{
		stdkey (&touc); 										/* Recherche code Ascii        */
		i = ZERO;
		do																	/* Pour chaque objet du menu   */
		{
			if (AdrMenu[i].ob_type == G_STRING)				/* Si c'est une option */
			{
				strcpy (option, AdrMenu[i].ob_spec.free_string);		/* La lire */
				trim (option);														/* Virer les espaces */
				if ((*(option + strlen (option) - 1) == touc) && (*(option + strlen (option) - 2) == ctr))
				{ /* Si le caractere et la touche speciale correspondent */
					if (NOT (AdrMenu[i].ob_state & DISABLED))			 /* Si actif */
					{	/* Generer message de selection d'une option du menu */
						EnvoiMessage(MN_SELECTED, m_title(AdrMenu, i), i);
					}
				}
			}
		} while (NOT (AdrMenu[i++].ob_flags & LASTOB));
		return;
	}

	if ((Sys->key == RETURN) || (Sys->key == ENTER)) 
	{	/* Si <Return> ou <Enter>, chercher bouton DEFAULT s'il y en a */
		i = ZERO;
		do
		{
			if (Sys->AdrObjet[i].ob_flags & DEFAULT)
			{
				form_button(Sys->AdrObjet, i, 1, &(Sys->new_objc));
				evnt_timer(100,0);
				Sys->objet = i;
				(*ptr_dial->fonct)(MU_BUTTON);
				return;
			}
		} while (NOT (Sys->AdrObjet[i++].ob_flags & LASTOB)); 
	}

	/* Interprete et traite l'evenement clavier */
	dialog = do_keybd(Sys->AdrObjet, Sys->objet);
	if (Sys->key)
	{
		objc_edit(Sys->AdrObjet, Sys->objet, Sys->key, Sys->pos, EDCHAR, &Sys->pos);
		Sys->new_objc = Sys->objet;
		Sys->new_pos = Sys->pos;
	}

	/* Repositionner le curseur */
	if (dialog > 0) 
	{
		if (Sys->new_objc > 0 && Sys->new_objc != Sys->objet || Sys->new_pos != Sys->pos)
		{
			objc_edit(Sys->AdrObjet, Sys->objet, 0, Sys->pos, EDEND, &Sys->pos);
			Sys->pos = Sys->new_pos;
			objc_edit(Sys->AdrObjet, Sys->new_objc, 0, Sys->pos, EDEND, &Sys->pos);
		}

		/* On sauve les parametres dans l'objet WindForm */
		ptr_dial->edit_objc = Sys->new_objc;
		ptr_dial->edit_pos = Sys->pos;
	}

	/* Traiter l'eventuel raccourcis clavier */
	if (dialog == -1)
	{
		(*ptr_dial->fonct)(MU_BUTTON);
		return;				
	}
}

static void EvntSpe (int *evnt)
{
	/* On definit s'il s'agit ou non d'un evenement special */

  if (Sys->key == HELP)
		*evnt = EV_HELP;
	else if (Sys->key == UNDO)
		*evnt = EV_UNDO;
	else if (Sys->key == ESC)
		*evnt = EV_ESC;
	else if (Sys->key == HOME)
		*evnt = EV_HOME;
	else if (Sys->key == SH_HOME)
		*evnt = EV_SHHOME;
	else if (Sys->key == ARUP)
		*evnt = EV_ARUP;
	else if (Sys->key == ARDN)
		*evnt = EV_ARDN;
	else if (Sys->key == ARLF)
		*evnt = EV_ARLF;
	else if (Sys->key == ARRT)
		*evnt = EV_ARRT;
	else if (Sys->key == SH_ARUP)
		*evnt = EV_SHARUP;
	else if (Sys->key == SH_ARDN)
		*evnt = EV_SHARDN;
	else if (Sys->key == SH_ARLF)
		*evnt = EV_SHARLF;
	else if (Sys->key == SH_ARRT)
		*evnt = EV_SHARRT;
}

/**************************-=< Fin du module >=-**************************/
