/*************************************************************************
 *  GemHelp.C : Fonctions de gestion de l'aide en ligne.                 *
 *************************************************************************/

#include "WindGem.h"
#include "winproto.h"
#include <xgemfast.h>
#include <vaproto.h>

/*-=< Inclusion des descriptions des objets UserDefs. >=-----------------*/
#include "user.h"

/* Calcul de la position en X de l'objet */
static int CoefX (OBJECT *form, int objet)
{
	register int pere;
	
	if (objet > 0)
	{
		pere = parent (form, objet);
		return form[objet].ob_x + CoefX(form, pere);
	}
	else
		return form[ROOT].ob_x;
}

/* Calcul de la position en Y de l'objet */
static int CoefY (OBJECT *form, int objet)
{
	register int pere;
	
	if (objet > 0)
	{
		pere = parent (form, objet);
		return form[objet].ob_y + CoefY(form, pere);
	}
	else
		return form[ROOT].ob_y;
}

/* Affichage d'un message d'aide */
void AfficheAide (Wind *wind, int objet)
{
	int x, y, w, h, xm, ym, dummy, xmouse, ymouse, i = 0, j = 0, num = 0, maxlen = 0;
	WindForm *ptr_dial	= wind->cont.dialog;
	MFDB image;
	AIDE *aide;
	char text[3][41];
	
	if (objet > 0)
	{
		aide = ptr_dial->aide;

		while  (aide && aide->numObj != objet)
			aide = aide->suiv;
			
		if (aide != (AIDE *)NULL)
		{		
			text[0][0] = '\0';
			text[1][0] = '\0';
			text[2][0] = '\0';

			while (aide->txt[i] != '\0' && num <= 2)
			{
				if (aide->txt[i] == '|')
				{
					text[num++][j] = '\0';
					if (j > maxlen)
						maxlen = j;
					j = 0;
				}
				else
					text[num][j++] = aide->txt[i];

				i++;
			}
			if (num <= 2)
				text[num][j++] = '\0';
			else
				num--;
				
			if (Sys->Yres < 400)
			{
				Sys->AdrAide[HLPTXT1].ob_y = 8;
				Sys->AdrAide[HLPTXT2].ob_y = 16;
				Sys->AdrAide[HLPTXT3].ob_y = 24;
			}
			if (Sys->Nplane < 4)
				Sys->AdrAide[ROOT].ob_spec.obspec.fillpattern = 0;
			
			set_text (Sys->AdrAide, HLPTXT1, text[0]);
			set_text (Sys->AdrAide, HLPTXT2, text[1]);
			set_text (Sys->AdrAide, HLPTXT3, text[2]);

			(Sys->AdrAide)->ob_x = CoefX(ptr_dial->adr_form, objet);
			(Sys->AdrAide)->ob_y = CoefY(ptr_dial->adr_form, objet);
			(Sys->AdrAide)->ob_width = (maxlen + 1) * 6;
			(Sys->AdrAide)->ob_height = (num + 1) * 12;

			if ((Sys->AdrAide)->ob_x + (Sys->AdrAide)->ob_width > Sys->Xdesk + Sys->Wdesk - 5)
				(Sys->AdrAide)->ob_x = Sys->Wdesk + Sys->Xdesk - (Sys->AdrAide)->ob_width - 5;
			if ((Sys->AdrAide)->ob_x < Sys->Xdesk + 5)
				(Sys->AdrAide)->ob_x = Sys->Xdesk + 5;
			if ((Sys->AdrAide)->ob_y + (Sys->AdrAide)->ob_height > Sys->Ydesk + Sys->Hdesk - 5)
				(Sys->AdrAide)->ob_y = Sys->Hdesk + Sys->Ydesk - (Sys->AdrAide)->ob_height - 5;
			if ((Sys->AdrAide)->ob_y < Sys->Ydesk + 5)
				(Sys->AdrAide)->ob_y = Sys->Ydesk + 5;
			
			x = (Sys->AdrAide)->ob_x;
			y = (Sys->AdrAide)->ob_y;
			w = (Sys->AdrAide)->ob_width;
			h = (Sys->AdrAide)->ob_height;

			get_bkgr (x, y, w, h, &image);	/* Copier l'image de fond */
			objc_draw (Sys->AdrAide, ROOT, MAX_DEPTH, x, y, w, h);
  	
			/* Sauver coordonnes de la souris */
			v_hide_c (Sys->VdiHandle);											/* Virer la souris */
			graf_mkstate (&xmouse, &ymouse, &dummy, &dummy);
			do	/* BOUCLE PRINCIPALE DE GESTION DU POP-UP */
			{
				graf_mkstate (&xm, &ym, &dummy, &dummy);		
			} while (xm == xmouse && ym == ymouse);
			put_bkgr (x, y, w, h, &image);	/* Restaurer l'image de fond */
			v_show_c (Sys->VdiHandle, TRUE);								/* Remet la souris */
    }
	}
}

/* Ajout d'un message d'aide */
void AjouteAide (int arbre, int objet, char *txt)
{
	Wind *wind;
	WindForm *ptr_dial;
	AIDE *nouvelle;
	AIDE *pos;
	
	wind = ObjListe(arbre);
	if (wind != WIND_NULL)
	{
		ptr_dial = wind->cont.dialog;
		nouvelle = (AIDE *)malloc(sizeof(AIDE));
		if (nouvelle)
		{
			nouvelle->numObj = objet;
			nouvelle->txt = (char *) malloc(strlen(txt)+1);
			if (nouvelle->txt)
			{
				strcpy (nouvelle->txt, txt);
				nouvelle->suiv = (AIDE *)NULL;
				pos = ptr_dial->aide;
				if (pos == (AIDE *)NULL)
					ptr_dial->aide = nouvelle;
				else
				{
					while (pos->suiv != (AIDE *)NULL)
						pos = pos->suiv;

					pos->suiv = nouvelle;
				}
			}
			else
			  free(nouvelle);
		}		
	}
}

void StGuide(char *fichierHyp, char *node)
{
    int msg[8], i;
    char HelpString[100];

    if ((i=appl_find("ST-GUIDE"))>=0)
    {
        msg[0] = VA_START;
        msg[1] = global[2];
        msg[2] = 0;
        sprintf(HelpString, "%s%s %s", AppPath, fichierHyp, node);
        *(char **)&msg[3] = HelpString;
        msg[5] = 0;
        msg[6] = 0;
        msg[7] = 0;
        appl_write(i, 16, msg);
    }
}

/**************************-=< Fin du module >=-**************************/
