/*************************************************************************
 * Gestion des menus en fentres                                         *
 *************************************************************************/

#include "WindGem.h"
#include "winproto.h"

/* Fonctions prives  GemMenu.C */
static void wmenu_tnormal (Wind *wind, int title, int flag);
static int boite (Wind *wind, int ob);

/*-----------------------------------------------------------------------*
 * Ajoute un menu dans une fentre quelconque avec affichage ventuel.   *
 *-----------------------------------------------------------------------*/
void AjouteMenu (int numObj, int menu, int mode, void (*wmenu)(int opt))
{
	Wind *wind;
	OBJECT *win_menu;
	
	wind = ObjListe(numObj);

	if (wind != WIND_NULL && menu > 0 && wind->adr_wmenu == (OBJECT *)NULL)
	{
		/* Rcupre l'adresse de l'objet menu */
		rsrc_gaddr (R_TREE, menu, &win_menu);		/* Demander adresse menu   */
		/* Fonction de gestion du menu */
		if (wind->adr_wmenu = copy_tree(win_menu));
		{
			wind->wmenu = wmenu;
  
	    /* Pas de trame, cadre 1 pixel vers l'extrieur */
 		  wind->adr_wmenu[BARMENU].ob_spec.index = 0xFF1101L;

			if (wind->type == WTYPFORM)
				wind->Hpos += wind->adr_wmenu[BARTITLE].ob_height;

			RecaleWind(wind);

			if (mode == REDRAW && wind->handle != BLANK)
				wind_set(wind->handle, WF_CURRXYWH, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
    }
	}
}

/*-----------------------------------------------------------------------*
 * Enlve un menu dans une fentre quelconque avec affichage ventuel.   *
 *-----------------------------------------------------------------------*/
void EnleveMenu (int numObj, int mode)
{
	Wind *wind;
	
	wind = ObjListe(numObj);

	if (wind != WIND_NULL && wind->adr_wmenu != (OBJECT *)NULL)
	{
		if (wind->type == WTYPFORM)
			wind->Hpos -= wind->adr_wmenu[BARTITLE].ob_height;

		free(wind->adr_wmenu);
		wind->adr_wmenu = (OBJECT *)NULL;
		wind->wmenu = (void *)NULL;

		RecaleWind (wind);
		
		if (mode == REDRAW)
		{
			wind_set(wind->handle, WF_CURRXYWH, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
			EnvoiRedraw(wind->handle, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
		}
	}
}

/*-----------------------------------------------------------------------*
 * Check ou d-check une option du menu.                                 *
 *-----------------------------------------------------------------------*/
void wmenu_icheck (int arbre, int obj, int etat)
{
	Wind *wind;
	
	wind = ObjListe(arbre);
	if (wind != WIND_NULL && wind->adr_wmenu != (OBJECT *)NULL)
		menu_icheck (wind->adr_wmenu, obj, etat);

}

static int mx, my, mk;
/*-----------------------------------------------------------------------*
 * inverse un titre de menu en fentre.                                  *
 *-----------------------------------------------------------------------*/
static void wmenu_tnormal (Wind *wind, int title, int flag)
{
	int x, y;
	int xw, yw, ww, hw;

  wind_get (wind->handle, WF_WORKXYWH, &xw, &yw, &ww, &hw);
  if (! flag)
  	(wind->adr_wmenu)[title].ob_state |= SELECTED;
  else
  	(wind->adr_wmenu)[title].ob_state &= ~SELECTED;
  objc_offset ((wind->adr_wmenu), title, &x, &y);

	objc_draw (wind->adr_wmenu, BARMENU, MAX_DEPTH, x, y, 
						 min(ww - (wind->adr_wmenu)[title].ob_x - 16, (wind->adr_wmenu)[title].ob_width),
						 (wind->adr_wmenu)[title].ob_height);
}

/*-----------------------------------------------------------------------*
 * Bote correspondant  un titre.                                       *
 *-----------------------------------------------------------------------*/
static int boite (Wind *wind, int ob)
{
	register int b, i;

  b= (wind->adr_wmenu)->ob_tail;        /* Fond des botes */
  b= (wind->adr_wmenu)[b].ob_head;      /* 1 bote */
  for (i = 3 ; i < ob ; i++)
	 	b= (wind->adr_wmenu)[b].ob_next;		/* Bote suivante */

  return b;
}

/*-----------------------------------------------------------------------*
 * Gestion du menu en fentre.                                           *
 *-----------------------------------------------------------------------*/
void menu_wind (Wind *wind, int ob)
{
	int xw, yw, ww, hw, etat;
	int x, y, w, h, dummy, bmenu;
	int obj, old_obj = -1, tit, evnt, mess[8], sortie = 0;
  MFDB img;

  wind_update (BEG_MCTRL);            /* Bloquer menu principal */
  wind_get (wind->handle, WF_WORKXYWH, &xw, &yw, &ww, &hw);

  while (Sys->mousek) /* Attente relacher bouton souris */
		graf_mkstate (&dummy, &dummy, &(Sys->mousek), &dummy);

  /* Slectionner titre */
  wmenu_tnormal (wind, ob, 0); 

  /* Chercher bote de menu correspondante */
  bmenu = boite (wind, ob);

	/* Largeur et hauteur de la bote */
  w = (wind->adr_wmenu)[bmenu].ob_width;
  h = (wind->adr_wmenu)[bmenu].ob_height;

  /* Replacer la bote sous le titre */
  (wind->adr_wmenu)[bmenu].ob_x = (wind->adr_wmenu)[ob].ob_x + 16;
  (wind->adr_wmenu)[bmenu].ob_y = 0;
  objc_offset ((wind->adr_wmenu), bmenu, &x, &y);

  /* Corriger la position si on sort du bureau */
  if (x + w > Sys->Xdesk + Sys->Wdesk - 5)
  {
    (wind->adr_wmenu)[bmenu].ob_x -= ((x + w) - (Sys->Xdesk + Sys->Wdesk) + 5);
  	objc_offset ((wind->adr_wmenu), bmenu, &x, &y);
  }
  if (y + h > Sys->Ydesk + Sys->Hdesk - 5)
  {
    (wind->adr_wmenu)[bmenu].ob_y -= ((y + h) - (Sys->Ydesk + Sys->Hdesk) + 5);
  	objc_offset ((wind->adr_wmenu), bmenu, &x, &y);
  }
  /* Copier l'image du fond */
  get_bkgr (x, y, w, h, &img);
  objc_draw ((wind->adr_wmenu), bmenu, MAX_DEPTH, x - 3, y - 3, w + 6, h + 6);
	tit = ob;

	do  /* BOUCLE D'ATTENTE */
  {
  	evnt = evnt_multi (MU_BUTTON | MU_TIMER,
                       1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                       mess, 10, 0, &mx, &my, &mk, &dummy, &dummy, &dummy);

    if (evnt & MU_BUTTON)	/* Si on clique */
    {
    	/* Virer le menu droul */
    	put_bkgr (x, y, w, h, &img);

      /* Attend que le bouton de la souris soit relch */
      while (mk)
	    	graf_mkstate (&dummy, &dummy, &mk, &dummy);

      /* On peut sortir */
      sortie = 1;
    }
    else if (evnt == MU_TIMER)	/* S'il ne s'est "rien" pass */
    {
			/* Position actuelle de la sourie */
	    graf_mkstate (&mx, &my, &dummy, &dummy);

			/* Chercher objet point dans le menu */
      obj = objc_find ((wind->adr_wmenu), bmenu, MAX_DEPTH, mx, my);
      if (obj == -1)	/* S'il n'y en a pas */
      {	/* Chercher titre point dans la barre */
        obj = objc_find ((wind->adr_wmenu), BARTITLE, MAX_DEPTH, mx, my);
      }

			/* Si on est sur un titre et dans la fentre */
      if (((wind->adr_wmenu)[obj].ob_type == G_TITLE) && (mx < (xw + ww)))
      {
      	if (old_obj != -1) /* S'il on tait avant sur une option */
        {	/* La dslectionner */
        	etat = (wind->adr_wmenu)[old_obj].ob_state & ~SELECTED; 
          objc_change ((wind->adr_wmenu), old_obj, 0, x, y, w, h, etat, 1);
        }
        if (obj != tit)	/* Si on a chang de titre */
        {
	      	put_bkgr (x, y, w, h, &img);				    /* Effacer l'ancien menu */
          wmenu_tnormal (wind, tit, 1);   				/* Dslectionner l'ancien */
          tit = obj;                  				    /* Enregistrer nouveau titre courant */
          wmenu_tnormal (wind, tit, 0);   				/* Slectionner titre */
          bmenu = boite (wind, tit);      				/* Menu correspondant */
          w = (wind->adr_wmenu)[bmenu].ob_width;  /* Largeur du menu */
          h = (wind->adr_wmenu)[bmenu].ob_height; /* Hauteur du menu */
          (wind->adr_wmenu)[bmenu].ob_x = (wind->adr_wmenu)[tit].ob_x + 16;  /* Le positionner sous son titre */
          (wind->adr_wmenu)[bmenu].ob_y = 0;
          objc_offset ((wind->adr_wmenu), bmenu, &x, &y);
          if (x + w > Sys->Xdesk + Sys->Wdesk - 5)	/* Correction s'il sort du bureau */
          {
  	      	(wind->adr_wmenu)[bmenu].ob_x -= ((x + w) - (Sys->Xdesk + Sys->Wdesk) + 5);
            objc_offset ((wind->adr_wmenu), bmenu, &x, &y);
          }
          if (y + h > Sys->Ydesk + Sys->Hdesk - 5)
          {
    	    	(wind->adr_wmenu)[bmenu].ob_y -= ((y + h) - (Sys->Ydesk + Sys->Hdesk) + 5);
            objc_offset ((wind->adr_wmenu), bmenu, &x, &y);
          }
          get_bkgr (x, y, w, h, &img);
          objc_draw ((wind->adr_wmenu), bmenu, MAX_DEPTH, x - 3, y - 3, w + 6, h + 6);
        }
        old_obj = -1;			                      /* Annuler objet courant */
      }
      /* Si on est sur une option */
      else if ((wind->adr_wmenu)[obj].ob_type == G_STRING)
      {
      	if (old_obj != obj)	/* Si objet diffrent de l'ancien */
        {
        	if ((old_obj != -1) && (! ((wind->adr_wmenu)[old_obj].ob_state & DISABLED)))
          { /* S'il y avait un objet courant non inactif */
          	/* Le dslectionner */
          	etat = (wind->adr_wmenu)[old_obj].ob_state & ~SELECTED;
            objc_change ((wind->adr_wmenu), old_obj, 0, x, y, w, h, etat, 1);
          }
          if ((obj > -1) && (! ((wind->adr_wmenu)[obj].ob_state & DISABLED)))
          { /* Si le nouvel objet n'est pas inactif */
          	/* Le slectionner */
          	etat = (wind->adr_wmenu)[obj].ob_state | SELECTED;
            objc_change ((wind->adr_wmenu), obj, 0, x, y, w, h, etat, 1);
          }
          /* Enregistrer option courante */
          old_obj = obj;
        }
      }
		}
  } while (! sortie); /* Tourner jusqu' un clic */

	wmenu_tnormal (wind, tit, 1);
  if ((obj != -1) && (! ((wind->adr_wmenu)[obj].ob_state & DISABLED)))
  {	/* Si une option non inactive a t clique */
  	/* Dslectionner l'option en mmoire */
		(*wind->wmenu)(obj);
  }
  else
  {
  	if (obj == -1) /* si clic en dehors du menu */
	  	(wind->adr_wmenu)[old_obj].ob_state &= ~SELECTED;
	}		
	
  /* Dbloquer menu normal */
  wind_update (END_MCTRL);

}

/*************************************************************************/
/*-----------------------------------------------------------------------*
 * Ajoute un ToolBar dans une fentre quelconque avec affichage ventuel.*
 *-----------------------------------------------------------------------*/
void AjouteToolBar (int numObj, int toolbar, int mode, void (*wtoolbar)(int opt))
{
	Wind *wind;
	OBJECT *win_toolbar;
	
	wind = ObjListe(numObj);

	if (wind != WIND_NULL && toolbar > 0 && wind->adr_wtoolbar == (OBJECT *)NULL)
	{
		/* Rcupre l'adresse de l'objet toolbar */
		rsrc_gaddr (R_TREE, toolbar, &win_toolbar);
		/* Fonction de gestion du menu */
		if (wind->adr_wtoolbar = copy_tree(win_toolbar));
		{
			wind->wtoolbar = wtoolbar;
  
			/* Modifier attributs racine ToolBar */
			wind->adr_wtoolbar->ob_state &= ~OUTLINED;				/* Pas Outline */
			wind->adr_wtoolbar->ob_spec.obspec.framesize = 1;	/* Cadre : 1 vers l'extrieur */
			wind->adr_wtoolbar->ob_spec.obspec.textmode = 1;	/* Objet racine opaque */
			wind->Hpos += wind->adr_wtoolbar[ROOT].ob_height;

			RecaleWind(wind);

			if (mode == REDRAW && wind->handle != BLANK)
				wind_set(wind->handle, WF_CURRXYWH, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
    }
	}
}

/*-----------------------------------------------------------------------*
 * Enlve un ToolBar dans une fentre quelconque avec affichage ventuel.*
 *-----------------------------------------------------------------------*/
void EnleveToolBar (int numObj, int mode)
{
	Wind *wind;
	
	wind = ObjListe(numObj);

	if (wind != WIND_NULL && wind->adr_wtoolbar != (OBJECT *)NULL)
	{
		if (wind->type == WTYPFORM)
			wind->Hpos -= wind->adr_wtoolbar[ROOT].ob_height;

		free(wind->adr_wtoolbar);
		wind->adr_wtoolbar = (OBJECT *)NULL;
		wind->wtoolbar = (void *)NULL;

		RecaleWind (wind);

		if (mode == REDRAW)
		{
			wind_set(wind->handle, WF_CURRXYWH, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
			EnvoiRedraw(wind->handle, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
		}
	}
}

/*-----------------------------------------------------------------------*
 * Cette fonction permet de repositionner les objets Menu et Toolbar qui *
 * peuvent se trouver dans une fentre Wind.                             *
 *-----------------------------------------------------------------------*/
void RecaleWind (Wind *wind)
{
	int wx, wy, ww, wh;
	WindForm *ptr_obj;
	
	if (wind->type == WTYPFORM)
	{
		ptr_obj = wind->cont.dialog;
		wind_calc(WC_WORK, FW_ATTRIB, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos, &wx, &wy, &ww, &wh);
		ptr_obj->adr_form->ob_y = wy + ptr_obj->offset;
	}
	else
		wind_calc(WC_WORK, TW_ATTRIB, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos, &wx, &wy, &ww, &wh);

	if (wind->adr_wmenu != (OBJECT *)NULL)
	{
		wind->adr_wmenu->ob_x = wx;
		wind->adr_wmenu->ob_y = wy;
		if (wind->type == WTYPFORM)
		{
			ptr_obj->adr_form->ob_y += wind->adr_wmenu[BARTITLE].ob_height + 2;
			wind->adr_wmenu->ob_y += ptr_obj->offset;
		}
	}
	if (wind->adr_wtoolbar != (OBJECT *)NULL)
	{
		if (wind->type == WTYPFORM)
			ptr_obj->adr_form->ob_y += wind->adr_wtoolbar->ob_height + 2;
		wind->adr_wtoolbar->ob_x = wx;
		wind->adr_wtoolbar->ob_y = wy;
		wind->adr_wtoolbar->ob_width = ww;		/* NEW */

		if (wind->adr_wmenu != (OBJECT *)NULL)
		{
			wind->adr_wtoolbar->ob_y += wind->adr_wmenu[BARTITLE].ob_height + 1;
			if (wind->type == WTYPFORM || global[1] == 1)
				wind->adr_wtoolbar->ob_y ++;
		}
		else if (wind->type == WTYPFORM)
			ptr_obj->adr_form->ob_y -= 2;
	}
	if (wind->type == WTYPFORM && wind->adr_wmenu != (OBJECT *)NULL && wind->adr_wtoolbar != (OBJECT *)NULL)
		ptr_obj->adr_form->ob_y -= 2;
	if (wind->type == WTYPFORM && wind->adr_wmenu != (OBJECT *)NULL && wind->adr_wtoolbar == (OBJECT *)NULL && global[1] == 1)
		ptr_obj->adr_form->ob_y++;
		
}

/*-----------------------------------------------------------------------*
 * Deselection d'un objet d'une ToolBar                                  *
 *                                                                       *
 * arbre	 : Numero de l'arbre d'objets                                  *
 * numObjc : Numero de l'objet                                           *
 *-----------------------------------------------------------------------*/
void ToolBarUnselect(int arbre, int numObjc, int mode)
{
	Wind *wind;
	
	/* On recupere les info sur l'arbre d'objet */
	wind = ObjListe(arbre);
	if (wind != WIND_NULL && wind->adr_wtoolbar != (OBJECT *)NULL)
		objc_change(wind->adr_wtoolbar, numObjc, 0, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos, 0, mode);

}
/*-----------------------------------------------------------------------*
 * Selection d'un objet d'une ToolBar                                    *
 *                                                                       *
 * arbre	 : Numero de l'arbre d'objets                                  *
 * numObjc : Numero de l'objet                                           *
 *-----------------------------------------------------------------------*/
void ToolBarSelect(int arbre, int numObjc, int mode)
{
	Wind *wind;
	
	/* On recupere les info sur l'arbre d'objet */
	wind = ObjListe(arbre);
	if (wind != WIND_NULL && wind->adr_wtoolbar != (OBJECT *)NULL)
		objc_change(wind->adr_wtoolbar, numObjc, 0, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos, 1, mode);

}
/**************************-=< Fin du module >=-**************************/
