/*************************************************************************
 *  GemUtil.C : Fonctions utilitaires pour WindForm.                     *
 *************************************************************************/

#include "WindGem.h"
#include "winproto.h"

/*-=< Section de declaration des fonctions privees >=--------------------*/
static int  get_popup (OBJECT *adr, int button, int pu);
static void set_popup (OBJECT *adr, int button, int option, int pu);

/*-----------------------------------------------------------------------*/
static int get_popup (OBJECT *adr, int button, int pu)
/*-----------------------------------------------------------------------*
 * Chercher correspondance entre le texte d'un bouton et un formulaire   *
 * pop-up.                                                               *
 *-----------------------------------------------------------------------*/
{
	int i = 1;
	char bouton[MAX_LEN], option[MAX_LEN];
	OBJECT *adrpu;

	if (! ((adr[button].ob_type >> 8) & POPUP_B))	/* Si pas pop-up */
		return FALSE;																/* Retourner 0 */

	rsrc_gaddr (R_TREE, pu, &adrpu);						/* Adresse formulaire pop-up */

	strcpy (bouton, get_text (adr, button));		/* Lire le texte du bouton */
	trim (bouton);															/* Virer les espaces au dbut et  la fin */
	do	/* Dbut de boucle : pour chaque objet du formulaire pop-up */
	{
		if (adrpu[i].ob_flags & SELECTABLE)				/* Si c'est un  SELECTABLE */
		{
			strcpy (option, get_text (adrpu, i));		/* Lire le texte de l'option */
			trim (option);													/* Virer les espaces au dbut et  la fin */
			if (strcmp (bouton, option) == 0)				/* Si correspondance */
				return i;															/* retourner le n de l'option */
		}
	} while (! (adrpu[i++].ob_flags & LASTOB));	/* Fin de boucle : dernier objet */
	return FALSE;																/* Si pas occurence, retourner 0 */
}

/*-----------------------------------------------------------------------*/
static void set_popup (OBJECT *adr, int button, int option, int pu)
/*-----------------------------------------------------------------------*
 * Faire correspondre le texte d'un bouton pop-up avec celui d'une option*
 *-----------------------------------------------------------------------*/
{
	char texte[MAX_LEN];
	OBJECT *adrpu;

	if (! ((adr[button].ob_type >> 8) & POPUP_B))	/* Si pas pop-up */
		return;																			/* Ressortir */

	rsrc_gaddr (R_TREE, pu, &adrpu);						/* Adresse formulaire pop-up */

	if ((adr[button].ob_type >> 8) & POPUP_B)		/* Si c'est bien un G_BUTTON */
	{
		strcpy (texte, get_text(adrpu, option));	/* Lire le texte de l'option */
		trim (texte);															/* Virer les espaces de dbut et de fin */
		set_text (adr, button, texte);						/* Copier le texte dans le bouton */
	}
}

/*-----------------------------------------------------------------------*/
void pop_up (int arbre, int obj, int pu)
/*-----------------------------------------------------------------------*
 * Gestion d'un formulaire pop-up                                        *
 *                                                                       *
 * Si arbre = BLANK, pu est le popup appel par clic droit de la souris  *
 *-----------------------------------------------------------------------*/
{
	OBJECT *adr_pu, *adr;
	int x, y, w, h, dummy, old_ob = -1, ob = 0, b[8], xm, ym, km,
			evnt, sortie = FALSE, etat, old = 0;
	MFDB image;
	Wind *wind;

	rsrc_gaddr (R_TREE, pu, &adr_pu);	/* Adresse formulaire pop-up */

	if (arbre != BLANK)
	{
		wind = ObjListe(arbre);
		adr = wind->cont.dialog->adr_form;
		objc_offset (adr, obj, &x, &y);		/* Position bouton cliqu */
		y += (adr[obj].ob_height);				/* Se placer juste dessous par dfaut */
	}
	else
	{
		x = Sys->mousex;
		y = Sys->mousey;
	}

	adr_pu->ob_x = x;									/* Positionner le */
	adr_pu->ob_y = y;									/* formulaire pop_up. */
	w = adr_pu->ob_width + 1;					/* Prendre ses */
	h = adr_pu->ob_height + 1;				/* dimensions. */

	if (arbre != BLANK)
		old = get_popup (adr, obj, pu);		/* Chercher correspondance */
	else
		old = 0;
	
	if (old)	/* Si le texte du bouton correspond dj  une option du pop-up */
	{	/* On fait concider les positions de l'option et du bouton */
		x = adr_pu->ob_x = x - adr_pu[old].ob_x;
		y = adr_pu->ob_y = y - adr_pu[old].ob_y - adr[obj].ob_height;
		adr_pu[old].ob_state |= CHECKED;	/* On "Checke" l'option */
	}

	if (x + w > Sys->Xdesk + Sys->Wdesk - 5)		/* Si on sort du bureau, dcaler le pop-up */
		x = adr_pu->ob_x = Sys->Wdesk + Sys->Xdesk - w - 5;	/* avec une marge de 5 pixels */
	if (x < Sys->Xdesk + 5)
		x = adr_pu->ob_x = Sys->Xdesk + 5;
	if (y + h > Sys->Ydesk + Sys->Hdesk - 5)
		y = adr_pu->ob_y = Sys->Hdesk + Sys->Ydesk - h - 5;
	if (y < Sys->Ydesk + 5)
		y = adr_pu->ob_y = Sys->Ydesk + 5;

	get_bkgr (x, y, w, h, &image);	/* Copier l'image de fond */
	objc_draw (adr_pu, ROOT, MAX_DEPTH, x - 3, y - 3, w + 6, h + 6);	/* Dessiner le pop-up */

	if (Sys->lastMode != WMODAL)	/* Si la fenetre n'est pas modale */
		wind_update(3);
	do	/* BOUCLE PRINCIPALE DE GESTION DU POP-UP */
	{
		evnt = evnt_multi (MU_BUTTON | MU_TIMER,	/* Seuls les clic et le timer nous intressent */
											 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
											 b, 10, 0, &xm, &ym, &km, &dummy, &dummy, &dummy);
		if (evnt & MU_BUTTON)					/* Si vnement de clic souris */
		{
			while (km)	/* On attend que le bouton de la souris soit relch */
				graf_mkstate (&dummy, &dummy, &km, &dummy);
			sortie = TRUE;	/* On peut sortir, puisqu'on a cliqu */
		}
		else if (evnt == MU_TIMER)	/* Si vnement Timer */
		{
			graf_mkstate (&xm, &ym, &dummy, &dummy);	/* Demander coordonnes de la souris */

			/* Demander l'option de pop-up  cette position */
			ob = objc_find (adr_pu, ROOT, MAX_DEPTH, xm, ym);
			if (old_ob != ob && (adr_pu[ob].ob_flags & SELECTABLE))	/* Si option diffrente de la prcdente */
			{
				if ((old_ob != -1) && (! (adr_pu[old_ob].ob_state & DISABLED)))
				{	/* On dslectionne l'ancienne */
					etat = adr_pu[old_ob].ob_state & ~SELECTED;
					objc_change (adr_pu, old_ob, 0, x, y, w, h, etat, TRUE);
				}
				if ((ob > ROOT) && (! (adr_pu[ob].ob_state & DISABLED)) && (adr_pu[ob].ob_flags & SELECTABLE))
				{	/* Si la nouvelle option existe (on n'est pas sorti du pop-up)
						 et si elle n'est pas DISABLED */
					etat = adr_pu[ob].ob_state | SELECTED;			/* On la slectionne */
					objc_change (adr_pu, ob, 0, x, y, w, h, etat, TRUE);
				}
				old_ob = ob;	/* L'option courante devient l'ancienne option */
			}
		}
	} while (sortie == FALSE);	/* Fin de boucle : tant qu'on n'a pas cliqu */
	if (Sys->lastMode != WMODAL)	/* Si la fenetre n'est pas modale */
		wind_update(2);

	put_bkgr (x, y, w, h, &image);	/* Restaurer l'image de fond */
	adr_pu[old].ob_state &= ~CHECKED;	/* D-checker l'option de dpart */

	if ((ob > 0) && (! (adr_pu[ob].ob_state & DISABLED)) && (adr_pu[ob].ob_flags & SELECTABLE))
	{	/* Si l'option existe (on n'est pas sorti du pop-up) et si elle n'est pas DISABLED */
		etat = adr_pu[ob].ob_state &= ~SELECTED;				/* La dslectionner */
		objc_change (adr_pu, ob, 0, x, y, w, h, etat, FALSE);
		if (arbre != BLANK)
			set_popup (adr, obj, ob, pu);			/* Copier son texte dans le bouton */
		else /* Traiter l'option du popup */
			(*Sys->popup)(ob);
	}
	if (arbre != BLANK)
	{
		ObjcUnselect (arbre, obj);
		objc_draw (adr, obj, MAX_DEPTH,
							 adr[ROOT].ob_x, adr[ROOT].ob_y,
							 adr[ROOT].ob_width, adr[ROOT].ob_height);
	}
		
}

/*-----------------------------------------------------------------------*
 * Fonction d'initialisation du popup menu appel lors de l'appui sur le *
 * bouton droit.                                                         *
 *                                                                       *
 * numObj 	: Numro de l'objet pour popup                               *
 * gerePopup: Fonction de gestion du popup menu                          *
 *-----------------------------------------------------------------------*/
void PopMenu(int numObj, void (*gerePopup)(int option))
{
	if (numObj > 0 && gerePopup != (void *)NULL)
	{
		Sys->popMenu = numObj;
		Sys->popup = gerePopup;
	}
 }

/*-----------------------------------------------------------------------*
 * Fonction permettant d'associer un popup  un objet d'un formulaire.   *
 *                                                                       *
 * arbre	: Numro de l'objet pour popup                                 *
 * objet	: Fonction de gestion du popup menu                            *
 * popup	: Arbre d'objet Popup                                          *
 *-----------------------------------------------------------------------*/
void AjoutePopup (int arbre, int objet, int ArbrePopup)
{
	Wind *wind;
	POPUP *popup, *NewPopup;
	WindForm *ptr_dial;
	
	if (arbre > 0 && objet > 0 && popup > 0)
	{
		wind = ObjListe(arbre);
		if (wind != WIND_NULL)
		{
			ptr_dial = wind->cont.dialog;
			
			if (NewPopup = (POPUP *)malloc(sizeof(POPUP)));
			{
				NewPopup->objet = objet;
				NewPopup->popup = ArbrePopup;
				NewPopup->suiv  = (POPUP *)NULL;
			}			

			popup = ptr_dial->popup;
			if (popup == (POPUP *)NULL)
				ptr_dial->popup = NewPopup;
			else
			{			
				while (popup->suiv != (POPUP *)NULL)
					popup = popup->suiv;
				popup->suiv = NewPopup;
			}
		}
	}
}

int IsPopup (Wind *wind, int objet)
{
	POPUP *popup;
	WindForm *ptr_dial;
	int ret = 0;
	
	ptr_dial = wind->cont.dialog;
	popup = ptr_dial->popup;
	while (popup != (POPUP *)NULL && popup->objet != objet)
		popup = popup->suiv;
	if (popup != (POPUP *)NULL)
		ret = popup->popup;
		
	return ret;
}

/*-----------------------------------------------------------------------*/
void PopupNextValeur (int arbre, int obj, int popup)
/*-----------------------------------------------------------------------*
 * Chercher la valeur suivante dans un popup menu.                       *
 *-----------------------------------------------------------------------*/
{
	int i = 1, bon_obj, old_obj;
	OBJECT *adrpu, *adr;
	Wind *wind;

	wind = ObjListe(arbre);
	adr = wind->cont.dialog->adr_form;

	rsrc_gaddr (R_TREE, popup, &adrpu);				/* Adresse formulaire pop-up */

	old_obj = get_popup (adr, obj, popup);			/* Chercher correspondance */
	if (old_obj > 0)
	{
		if (adrpu[old_obj].ob_flags & LASTOB)
			i = 1;
		else
			i = old_obj + 1;
			
		/* On cherche l'objet slectionnable suivant */
		do
		{
			if ((adrpu[i].ob_flags & SELECTABLE) && ! (adrpu[i].ob_state & DISABLED))
				break;
			i++;
		}	while (! (adrpu[i].ob_flags & LASTOB));

		if ((adrpu[i].ob_flags & SELECTABLE) && ! (adrpu[i].ob_state & DISABLED))
			bon_obj = i;															/* on le choisit         */
		else																				/* sinon                 */
			bon_obj = old_obj;
	}
	else /* si rien de dj slectionn */
	{
		i = 1;

		/* On recherche depuis le dbut */
		do
		{
			if ((adrpu[i].ob_flags & SELECTABLE) && ! (adrpu[i].ob_state & DISABLED))
				break;
			i++;
		}	while (! (adrpu[i].ob_flags & LASTOB));

		if ((adrpu[i].ob_flags & SELECTABLE) && ! (adrpu[i].ob_state & DISABLED))
			bon_obj = i;														/* on le choisit           */		
		else 
			bon_obj = -1;														/* sinon tout DISABLE      */
	}
	if (bon_obj != -1)
		set_popup (adr, obj, bon_obj, popup);			/* Affiche l'option        */

	ObjcUnselect (arbre, obj);
	objc_draw (adr, obj, MAX_DEPTH,
						 adr[ROOT].ob_x, adr[ROOT].ob_y,
						 adr[ROOT].ob_width, adr[ROOT].ob_height);
}

/**************************-=< Fin du module >=-**************************/
