/*************************************************************************
 *  GemSlid.C : Fonctions de gestion des Objets Slider.                  *
 *************************************************************************/

#include "WindGem.h"
#include "winproto.h"
#include <xgemfast.h>

/*-=< Inclusion des descriptions des objets UserDefs. >=-----------------*/
#include "user.h"

static MFDB fond;

void SetSlider (int mode, int echelle, int position, char *text)
/*-----------------------------------------------------------------------*
 * Fonction d'initialisation et de gestion d'un objet Slider             *
 * mode		  : SLIDINI - Initilisation et affichage initial               *
 *            SLIDAFF - Modification de l'affichage                      *
 *         	  SLIDEND - Dtruire l'objet Slider                          *
 * echelle  : Valeur maximale du Slider                                  *
 * position : Position courante.                                         *
 *-----------------------------------------------------------------------*/
{
	static int x = 0, y = 0, w = 0, h = 0;
	static int scale = 0;
	char txt[5];

	v_hide_c (Sys->VdiHandle);											/* Virer la souris */
	switch (mode)
	{
		case SLIDINI :
			scale = echelle;
			form_center(Sys->AdrSlider, &x, &y, &w, &h);
			get_bkgr (x, y, w, h, &fond);
			(Sys->AdrSlider)[SLIDBAR].ob_width = 0;

			if (Sys->Xres < 640)
				(Sys->AdrSlider)[SLIDBAR].ob_x = 1;
			if (Sys->Yres < 400)
				(Sys->AdrSlider)[SLIDBAR].ob_height = 6;

			set_text (Sys->AdrSlider, SLIDTXT, text);
			sprintf(txt,"%d\%",0);
			set_text (Sys->AdrSlider, SLIDPOS, txt);
			objc_draw (Sys->AdrSlider, ROOT, MAX_DEPTH, x, y, w, h);
			break;

		case SLIDAFF :
			(Sys->AdrSlider)[SLIDBAR].ob_width = position * (Sys->AdrSlider)[SLIDBOX].ob_width / scale;
			sprintf(txt,"%d\%",(int)(position * 100 / scale));
			set_text (Sys->AdrSlider, SLIDPOS, txt);
			objc_draw (Sys->AdrSlider, SLIDBAR, MAX_DEPTH, x, y, w, h);
			objc_draw (Sys->AdrSlider, SLIDPOS, MAX_DEPTH, x, y, w, h);
			break;

		case SLIDEND :
			put_bkgr (x, y, w, h, &fond);
			break;
	}
	v_show_c (Sys->VdiHandle, TRUE);								/* Remet la souris */
				
}

/**************************-=< Fin du module >=-**************************/
