/*************************************************************************
 *  GemForm.C : Fonctions de gestion des formulaires en fenetre.         *
 *************************************************************************/

#include <unistd.h>
#include <atari.h>
#include "WindGem.h"
#include "winproto.h"

/*-=< Inclusion des descriptions des objets UserDefs. >=-----------------*/
#include "user.c"

/*-=< Section de declaration des fonctions privees >=--------------------*/
static void coordonnees (void);
static void GetSysInfo (void);

OBJECT *AdrDesk;							/* Adresse du bureau                       */
OBJECT *AdrMenu;							/* Adresse du menu                         */
int buff[8];									/* Buffer evenement                        */
System *Sys;									/* Variable Systeme                        */
DTA dtabuffer;								/* Tampon DTA                              */
Wind LstFen[NBWIND];					/* Liste des fenetres (60 fenetres max.)   */
int VdiHandle;								/* Handle VDI                              */
int AppId;										/* ID Application                          */
char AppPath[128];						/* Chemin de l'application                 */
MachineInfo Ordi;							/* Information systme                     */
int CurWindow;								/* Numro de l'objet WindGem courant       */

/*************************************************************************
 * Fonctions de gestion de l'application.                                *
 *************************************************************************/

/*-----------------------------------------------------------------------*
 * Fonction qui fixe les coordonnes des objets USerDefs.                *
 *-----------------------------------------------------------------------*/
static void coordonnees (void)
{
	register int i, j;

	for (i = 0 ; i < rs_nb_tree ; i++) /* Pour chaque arbre du RSC intgr,*/
	{
		j = 0;													 /* et chaque objet,                 */
		do
		{	/* Tant qu'on n'est pas au dernier objet */
			rsrc_obfix (rs_trindex[i], j); /* Adapter coordonnes              */
		} while (! (rs_trindex[i][j++].ob_flags & LASTOB));
	}	
	Sys->AdrUser = rs_trindex[0];
	Sys->AdrIcone = rs_trindex[1];
	Sys->AdrAide = rs_trindex[2];
	Sys->AdrSlider = rs_trindex[3];
}

/*-----------------------------------------------------------------------*
 * Fonction d'initialisation de l'application.                           *
 *                                                                       *
 * fic_rsc	: Fichier .rsc de l'application                              *
 * desk			: numero de l'objet pour bureau                              *
 * gereDesk : fonction de gestion du bureau                              *
 * menu			: numero de l'objet MENU                                     *
 * gereMenu	: fonction de gestion du menu                                *
 *-----------------------------------------------------------------------*/
void AppInit(char *fic_rsc, int desk, void (*gereDesk)(int event), int menu, void (*gereMenu)(int event))
{
	int i, attributes[12];
	
	Sys = (System *)malloc(sizeof(System));

	Sys->AppId = appl_init();
	AppId = Sys->AppId;

	for (i = 1 ; i < 9 ; _GemParBlk.intin[i++] = 1);
	_GemParBlk.intin[0] = Getrez() + 2;			 /* on rcupre la rsolution  */
	_GemParBlk.intin[9] = 0;								 /* Couleur de Remplissage = 0 */
	_GemParBlk.intin[10]= 2;								 /* des coordonnes            */

	Sys->VdiHandle = graf_handle(&(Sys->Wchar), &(Sys->Hchar), &(Sys->Wcell), &(Sys->Hcell));
	
	Sys->Hchar++;					 /* +1 pour eviter que les lignes ne se touchent */
	/* Ouverture station de travail virtuelle */
	v_opnvwk (_GemParBlk.intin, &(Sys->VdiHandle), _GemParBlk.intout);
	VdiHandle = Sys->VdiHandle;

	GetSysInfo();									/* Rcupration des informations systme */

	if (_GemParBlk.intout[13] < 16)
	{ /* Etablissement des couleurs 3D */
		Sys->color_3d1 = WHITE;														  /* color index 0 */
		Sys->color_3d2 = BLACK;	                            /* color index 1 */
	}
	else
	{
		Sys->color_3d1 = LWHITE;	                          /* color index 8 */
		Sys->color_3d2 = LBLACK;	                          /* color index 9 */
	}
	
	/* Coordonnes du bureau */
	wind_get (0, WF_WORKXYWH, &(Sys->Xdesk), &(Sys->Ydesk), &(Sys->Wdesk), &(Sys->Hdesk));

	Sys->Xres = _GemParBlk.intout[0];			/* Resolution en X du bureau     */
	Sys->Yres = _GemParBlk.intout[1];			/* Resolution en Y du bureau     */

	vq_extnd (Sys->VdiHandle, TRUE, _GemParBlk.intout);
	Sys->Nplane = _GemParBlk.intout[4];		/* Nombre de plans de couleurs   */
	Sys->lastImg = 1000;									/* Der. num. pour fenetre image  */
	Sys->lastTxt = 4000;									/* Der. num. pour fenetre texte  */
	Sys->lastUsr = 7000;									/* Der. num. pour fenetre user   */

	vqt_attributes(Sys->VdiHandle, attributes);
	/* Ligne de base des caractres + 1 pour viter que la premire ligne 
	de texte ne touche le haut de la fentre. */
	Sys->baseline = 1 + attributes[7]; 		

	if (NOT rsrc_load(fic_rsc))
	{
		char mes[60];

		sprintf(mes,"[2][| Le Fichier Ressource |    %s    | n'a pu tre trouv.][ Quitter ]",fic_rsc);
		form_alert(1,mes);
	  wind_set (0, WF_NEWDESK, 0, 0); 					/* Rendre le bureau        */
		v_clsvwk(Sys->VdiHandle);									/* Efface l'ecran          */
		free (Sys);
		appl_exit();															/* Fermer application      */
	}
	else
	{
		/* Init. des 60 fenetres */
		for (i=0; i<NBWIND; i++)
		{
			LstFen[i].handle	= BLANK;
			LstFen[i].numObj	= BLANK;
			LstFen[i].type		= WTYPNONE;
			LstFen[i].mode		= WNORM;
			LstFen[i].attrib  = ZERO;
			LstFen[i].w_title	= (char *)NULL;
			LstFen[i].iconified = FALSE;
			LstFen[i].adr_wmenu = (OBJECT *)NULL;
			LstFen[i].wmenu 	= (void *)NULL;
			LstFen[i].adr_wtoolbar = (OBJECT *)NULL;
			LstFen[i].wtoolbar 	= (void *)NULL;
		}

		/* Mise en place du Bureau *******************************************/
		LstFen[0].type		= WTYPDESK;
		LstFen[0].handle	= 0;
		
		/* Si bureau , le creer en tant que fenetre 0 */
		if (desk != BLANK)
		{
			rsrc_gaddr (0, desk, &AdrDesk);			/* Demander adresse bureau */
  		AdrDesk->ob_x = Sys->Xdesk;		     	/* Mettre le bureau aux    */
		  AdrDesk->ob_y = Sys->Ydesk;		   		/* bonnes dimensions.      */
		  AdrDesk->ob_width = Sys->Wdesk;
	  	AdrDesk->ob_height = Sys->Hdesk;
	  	wind_set (0, WF_NEWDESK, AdrDesk, 0);/* Fixer le nouveau bureau */
																							/* et l'afficher.          */
		  form_dial (FMD_FINISH, 0, 0, 0, 0, Sys->Xdesk, Sys->Ydesk, Sys->Wdesk, Sys->Hdesk); 
			LstFen[0].numObj	= desk;
			Sys->gereDesk	= gereDesk;
		}
		else
			AdrDesk  = (OBJECT *)NULL;

		/* Mise en place du Menu *********************************************/
		if (menu != BLANK)
		{
			rsrc_gaddr (0, menu, &AdrMenu);					/* Demander adresse menu   */
		  menu_bar (AdrMenu, 1);  		    				/* Afficher le menu        */
			Sys->menu = gereMenu;
		}
		else
			AdrMenu  = (OBJECT *)NULL;

		Sys->AdrObjet = (OBJECT *)NULL;				/* Objet pour gestion interne  */
		Sys->objet	= ZERO;										/* idem */
		Sys->pos		= ZERO;										/* idem */

		/* Popup lors de l'appui sur bouton droit */
		Sys->popMenu = BLANK;
		Sys->popup = (void *)NULL;
	}
	getcwd(AppPath, 128);								/* Rcupration du chemin du prog. */

	Fsetdta (&dtabuffer);											 /* Fixer adresse tampon DTA */

	coordonnees();									 /* Mise en place des boutons userdefs */

	CurWindow = 0;
	graf_mouse(ARROW, 0);

}

/*-----------------------------------------------------------------------*
 * Fermeture de l'application                                            *
 *-----------------------------------------------------------------------*/
void AppExit(void)
{
	register int i;

	/* Destruction de toutes les fenetres */
	for (i=1; i<NBWIND; i++)
		if (LstFen[i].type != WTYPNONE)
			WindDelete(LstFen[i].numObj);

	if (AdrMenu != (OBJECT *)NULL)
	  menu_bar (AdrMenu, 0); 			 				      /* Virer la barre de menu  */

	if (AdrDesk != (OBJECT *)NULL)
	  wind_set (0, WF_NEWDESK, 0, 0); 						/* Rendre le bureau        */

	rsrc_free();																/* Liberer espace RSC      */
	v_clsvwk(Sys->VdiHandle);										/* Efface l'ecran          */
	free (Sys);
	appl_exit();																/* Fermer application      */
}

static void GetSysInfo (void)
{
	long cookie;
	
  /*
   *	Par dfaut Atari ST Franais
   */  
  Ordi.Processor	= M68000;
  Ordi.Machine		= ST;
  Ordi.Switch			= FALSE;
  Ordi.Fdc				= FALSE;
  Ordi.Keyboard		= KEYB_F;
  Ordi.Language		= LG_F;
  Ordi.Shifter		= SHIFTER_ST;
  Ordi.Sound			= PSG;
  Ordi.Fpu				= NO_FPU;
  Ordi.Separator	= '/';
  Ordi.Time 			= TIME_12;
  Ordi.Date				= DATE_MJA;
  /*
   *	Try to get the true value from the Cookie Jar System
   */
  if(Getcookie('_CPU',&cookie))		/* Copy all cookies */
    Ordi.Processor	= (int)(cookie & 0xFFFF);
  if(Getcookie('_MCH',&cookie))
    Ordi.Machine		= cookie;
  if(Getcookie('_SWI',&cookie))
    Ordi.Switch		= (int)(cookie & 0x00FF);
  if(Getcookie('_FDC',&cookie))
    Ordi.Fdc				= cookie;
  if(Getcookie('_AKP',&cookie))
  {
    Ordi.Keyboard = (int)(cookie & 0x00FF);
    Ordi.Language = (int)((cookie & 0xFF00) >> 8);
  }
  if(Getcookie('_VDO',&cookie))
    Ordi.Shifter	= cookie;
  if(Getcookie('_SND',&cookie))
    Ordi.Sound		= loword(cookie);
  if(Getcookie('_FPU',&cookie))
    Ordi.Fpu 		= hiword(cookie);
  if(Getcookie('_IDT',&cookie))
  {
    Ordi.Separator	= (int) (cookie & 0x00FF);
    Ordi.Date 			= (int)((cookie & 0x0F00) >> 8);
    Ordi.Time 			= (int)((cookie & 0xF000) >> 12);
  }

  Ordi.TosVersion		= _tos;
  Ordi.GemdosVersion = Sversion();
  Ordi.AesVersion		= gl_apversion; 
  if(Getcookie('MiNT',&cookie))								/* Mot faible = version */
    Ordi.MultiTosVersion = loword(cookie);
  else																				/* MultiTos no found */
    Ordi.MultiTosVersion = FALSE;
	if (Getcookie('MagX', &cookie))
	{
		if (cookie)
			Ordi.Magic = TRUE;
		else
			Ordi.Magic = FALSE;
	}
}

/*************************************************************************
 * Ajoute un nouvel objet Wind dans la liste des fenetres.               *
 *                                                                       *
 * Validation            : 24/04/1996                                    *
 *************************************************************************/
void AjouteListe(int type, int attrib, int numObj, int mode, char *title, GRECT pos, void *ptr_var)
{
	int ind = 1;

	while (ind < NBWIND && LstFen[ind].type != WTYPNONE) ind++;
	
	LstFen[ind].type		= type;
	LstFen[ind].numObj	= numObj;
	LstFen[ind].mode		= mode;
	LstFen[ind].attrib	= attrib;
	LstFen[ind].Xpos		= pos.g_x;
	LstFen[ind].Ypos		= pos.g_y;
	LstFen[ind].Wpos		= pos.g_w;
	LstFen[ind].Hpos		= pos.g_h;
	LstFen[ind].w_title	= (char *)malloc(strlen(title)+1);
	strcpy(LstFen[ind].w_title, title);
	LstFen[ind].adr_wmenu	= (OBJECT *)NULL;
	LstFen[ind].wmenu		= (void *)NULL;
	LstFen[ind].adr_wtoolbar = (OBJECT *)NULL;
	LstFen[ind].wtoolbar	= (void *)NULL;

	if (type == WTYPFORM)
		LstFen[ind].cont.dialog	= (WindForm *)ptr_var;
	else if (type == WTYPGRAP)
		LstFen[ind].cont.image	= (WindGraph *)ptr_var;
	else if (type == WTYPTEXT)
		LstFen[ind].cont.text		= (WindText *)ptr_var;
	else
		LstFen[ind].cont.user		= (WindUser *)ptr_var;

}

/*-----------------------------------------------------------------------*
 * Retourne l'objet Wind associe a l'objet <numObj>, NULL sinon          *
 *-----------------------------------------------------------------------*/
Wind *ObjListe(int numObj)
{
	register int i = 1;

	while (i < NBWIND)
	{
		if (LstFen[i].numObj == numObj)
			return &LstFen[i];
		i++;
	}
	return WIND_NULL;
}

/*-----------------------------------------------------------------------*
 * Retourne l'objet de handle <handle> donne, NULL sinon                 *
 *-----------------------------------------------------------------------*/
Wind *TopListe(int handle)
{
	register int i = 1;

	while (i < NBWIND)
	{
		if (LstFen[i].handle == handle)
			return &LstFen[i];
		i++;
	}
	return WIND_NULL;
}


/**************************-=< Fin du module >=-**************************/
