/*************************************************************************
 * GemText.C - Module de gestion des fenetres Textes.                    *
 *************************************************************************/

#include "WindGem.h"
#include "winproto.h"
#include <xgemfast.h>
#include <stdio.h>

/* Fonctions prives internes  GemText.C */
static void sim_redraw (Wind *wind, int x, int y, int w, int h);
static void WindTextRedraw (Wind *wind);
static void WindTextFulled (Wind *wind);
static void WindTextArrow (Wind *wind);
static void WindTextHSlider (Wind *wind);
static void WindTextVSlider (Wind *wind);
static void WindTextSized (Wind *wind);

int WindTextInit (char *file, GRECT *Fpos, char *title)
{
	int fh, nlines = ZERO, i, maxi = ZERO;
	long taille;
	char *zone, *ptr;
	GRECT pos;
	WindText *ptr_txt = (WindText *)malloc(sizeof(WindText));

	if (Fpos != NULL)
	{
		pos.g_x = Fpos->g_x;
		pos.g_y = Fpos->g_y;
		pos.g_w = Fpos->g_w;
		pos.g_h = Fpos->g_h;
	}
	else
	{
		pos.g_x = 50;
		pos.g_y = 50;
		pos.g_w = 200;
		pos.g_h = 100;
	}
	if (file)
	{
		taille = exist (file, ZERO);					 /* Prendre la taille du fichier */
		if (taille && ptr_txt)								 /* S'il existe et memoire dispo */
		{
			zone = (char *)lalloc (taille);			/* Rserver mmoire */
			if (zone)														/* Si mmoire dispo */
			{
				fh = (int)Fopen (file, FO_READ);	/* Ouvrir fichier */
				Fread (fh, taille, zone);					/* Charger en mmoire */
				Fclose (fh);											/* Fermer fichier */
				ptr = zone;
				do
				{
					if (*ptr == '\r')								/* Remplacer fins de lignes par '\0' */
					{
						*ptr = '\0';
						nlines++;											/* Compter les lignes */
						ptr++;
					}
					ptr++;
				} while (ptr < zone + taille);
	
				/* Mmoire pointeurs sur les lignes */
				ptr_txt->lignes = (char **)malloc (nlines * sizeof (char **));
				ptr = zone;												/* Partir du dbut */
				for (i = ZERO ; i < nlines ; i++)	/* Pour chaque ligne */
				{
					ptr_txt->lignes[i] = ptr;	/* Pointer dessus */
					maxi = max (maxi, (int)strlen (ptr));	/* Ligne la plus longue */
					ptr += (strlen (ptr) + 2);			/* Ligne suivante */
				}
				ptr_txt->nbrel = nlines;						/* Enregistrer nbre de lignes */
				ptr_txt->nbrec = maxi;							/* Enregistrer nbre colonnes  */
				ptr_txt->lin = 0;
				ptr_txt->col = 0;
			}
			ptr_txt->type = TYP_TEXT_AUTO;
		}
		else
		{
			ptr_txt->lignes = (char **)NULL;
			ptr_txt->nbrel = 0;									/* Enregistrer nbre de lignes */
			ptr_txt->nbrec = 0;									/* Enregistrer nbre colonnes  */
			ptr_txt->lin = 0;
			ptr_txt->col = 0;
			ptr_txt->type = TYP_TEXT_USER;
		}
	}
	if (title)
		AjouteListe (WTYPTEXT, TW_ATTRIB, Sys->lastTxt, WNORM, title, pos, (void *)ptr_txt);
	else
		AjouteListe (WTYPTEXT, TW_ATTRIB, Sys->lastTxt, WNORM, file, pos, (void *)ptr_txt);
	Sys->lastTxt++;
	return (Sys->lastTxt - 1);
}

int GetWindText (int numTxt, char **ligne[], int *nbcol)
{
	Wind *wind;
	int nblig = 0;
	WindText *ptr_txt;
	
	wind = ObjListe(numTxt);
	if (wind != WIND_NULL && wind->type == WTYPTEXT)
	{
		ptr_txt = wind->cont.text;
		*ligne = ptr_txt->lignes;
		nblig = ptr_txt->nbrel;
		*nbcol = ptr_txt->nbrec;
	}

	return nblig;
}

void SetWindText (int numTxt, int nblig, int nbcol, char **ligne)
{
	Wind *wind;
	WindText *ptr_txt;
	
	wind = ObjListe(numTxt);
	if (wind != WIND_NULL && wind->type == WTYPTEXT)
	{
		ptr_txt = wind->cont.text;
		ptr_txt->lignes = ligne;
		ptr_txt->nbrel = nblig;
		ptr_txt->nbrec = nbcol;
		sim_redraw (wind, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
	}
}

void WindTextDo(Wind *wind, int evnt)
{
	GRECT coord;
	WindText *ptr_txt = wind->cont.text;
	int xw, yw, ww, hw, hauteur_page;

	GetWorkXYWH (wind->numObj, &coord);
	xw = coord.g_x;
	yw = coord.g_y;
	ww = coord.g_w;
	hw = coord.g_h;	
	if ((evnt > 0) && (evnt & MU_MESAG)) 					/* SI EVENEMENT DE MESSAGE */
	{
		switch(buff[0])
		{
		case WM_REDRAW :
			WindTextRedraw (wind);
			break;
		
		case WM_TOPPED :
			wind_set (wind->handle, WF_TOP);		/* Mettre la fentre au 1 plan */
			break;
		
		case WM_CLOSED :
			WindDelete(wind->numObj);
			break;
			
		case WM_FULLED :
			WindTextFulled (wind);
			break;

		case WM_ARROWED :
			WindTextArrow (wind);
     	break;
    	
		case WM_HSLID :
			WindTextHSlider (wind);
			break;
			
		case WM_VSLID :
			WindTextVSlider (wind);
			break;
			
		case WM_SIZED :
			WindTextSized (wind);
			break;
			
		case WM_MOVED :
			/* Nouvelles coordonnes : */
			wind_set (wind->handle, WF_CURRXYWH, buff[4], buff[5], buff[6], buff[7]);
			if (wind->iconified == FALSE)
			{
				wind->Xpos = buff[4];
				wind->Ypos = buff[5];
				ptr_txt->full = 0;					/* Annuler le flag de pleine ouverture */

				RecaleWind (wind);
			}
			break;

		case WM_ICONIFY :
			graf_shrinkbox(buff[4], buff[5], buff[6], buff[7], wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
			wind_set(buff[3], WF_ICONIFY, buff[4], buff[5], buff[6], buff[7]);
			wind->iconified = TRUE;
			break;
				
		case WM_UNICONIFY :
			graf_growbox( wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos, buff[4], buff[5], buff[6], buff[7]);
			wind_set(buff[3], WF_UNICONIFY, buff[4], buff[5], buff[6], buff[7]);
			wind->iconified = FALSE;
			break;
		}
	}
	else if (evnt > 0)
		return;

	switch (evnt)
	{
		case EV_HELP :	/* Help */
			form_alert(1,"[1][(shft) / : (pg)-lig haut/bas|(shft) / : (pg)-lig droite/gauche|(shft) Home : (fin)-dbut de texte|Esc : fermeture][Ok]");
			break;
			
		case EV_ESC :		/* Escape */
			EnvoiMessage(WM_CLOSED, wind->handle, ZERO);
			break;

		case EV_ARLF :	/* gauche */
			buff[4] = WA_LFLINE;
			WindTextArrow(wind);
			break;

		case EV_ARRT :	/* droite */
			buff[4] = WA_RTLINE;
			WindTextArrow(wind);
			break;

		case EV_ARUP :	/* Haute  */
			buff[4] = WA_UPLINE;
			WindTextArrow (wind);
			break;

		case EV_ARDN :	/* Basse  */
			buff[4] = WA_DNLINE;
			WindTextArrow (wind);
			break;

		case EV_SHARLF :	/*  gauche */
			buff[4] = WA_LFPAGE;
			WindTextArrow(wind);
			break;

		case EV_SHARRT :	/*  droite */
			buff[4] = WA_RTPAGE;
			WindTextArrow(wind);
			break;

		case EV_SHARUP :	/*  Haute  */
			buff[4] = WA_UPPAGE;
			WindTextArrow(wind);
			break;

		case EV_SHARDN :	/*  Basse  */
			buff[4] = WA_DNPAGE;
			WindTextArrow(wind);
			break;

		case EV_HOME :	/* HOME */
			if (ptr_txt->lin > 0)
			{
				ptr_txt->lin = 0;
				sim_redraw (wind, xw, yw, ww, hw);	/* Raffichage */
				WindTextSliders (wind); 				/* Actualiser les sliders */
			}
			break;
			
		case EV_SHHOME :	/*  HOME */
			if (ptr_txt->lin < ptr_txt->nbrel - (hw / Sys->Hchar))
			{
				ptr_txt->lin = ptr_txt->nbrel - (hw / Sys->Hchar);
				sim_redraw (wind, xw, yw, ww, hw);	/* Raffichage */
				WindTextSliders (wind); 				/* Actualiser les sliders */
			}
			break;
	}
}

static void sim_redraw (Wind *wind, int x, int y, int w, int h)
{
	buff[3] = wind->handle;
	buff[4] = x;
	buff[5] = y;
	buff[6] = w;
	buff[7] = h;
	WindTextRedraw (wind);
}

static void WindTextRedraw (Wind *wind)
{	/* Gestion des redraws */
	GRECT r, rd, coord;
	int i, y_base, nbre;
	int xo, yo, wo, ho, xy[4];
	WindText *ptr_txt = wind->cont.text;
	char chaine[256];
	
	rd.g_x = buff[4];	/* Coordonnes rectangle  redessiner */
	rd.g_y = buff[5];
	rd.g_w = buff[6];
	rd.g_h = buff[7];

	if (wind->iconified == TRUE)
	{
		DrawIcone (wind->handle, &rd);
	}
	else
	{
		GetWorkXYWH (wind->numObj, &coord);

		xo = coord.g_x;
		yo = coord.g_y;
		wo = coord.g_w;
		ho = coord.g_h;

		nbre = ho / Sys->Hchar;

		v_hide_c (Sys->VdiHandle);	/* Virer la souris */
		wind_update (BEG_UPDATE); 	/* Bloquer les fonctions de la souris */

		/* Demande les coord. et dimensions du 1 rectangle de la liste */
		wind_get (wind->handle, WF_FIRSTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);

		while (r.g_w && r.g_h)			/* Tant qu'il y a largeur ou hauteur... */
		{
			set_clip (1, &r); 	/* Clipping ON */
			if (rc_intersect (&rd, &r)) /* Si intersection des 2 zones */
			{
				if (wind->adr_wmenu != (OBJECT *)NULL)
				{ /* On commence par afficher la barre de menu */
	        objc_draw (wind->adr_wmenu, BARMENU, MAX_DEPTH, r.g_x, r.g_y, r.g_w, r.g_h);
  			}
				if (wind->adr_wtoolbar != (OBJECT *)NULL)
				{ /* On affiche la ToolBar */
	        objc_draw (wind->adr_wtoolbar, ROOT, MAX_DEPTH, r.g_x, r.g_y, r.g_w, r.g_h);
  			}
				/* -- */
				y_base = yo + Sys->baseline;

        xy[0] = xo;                        /* Prparer effacement fentre */
        xy[1] = yo;
        xy[2] = xo + wo - 1;
        xy[3] = yo + ho - 1;

        vsf_color(Sys->VdiHandle, WHITE);
				vr_recfl(Sys->VdiHandle, xy);
				vswr_mode(Sys->VdiHandle, MD_TRANS);
				i = ptr_txt->lin;
				while (i < min(nbre+ptr_txt->lin+1,ptr_txt->nbrel))
				{
					strcopy(chaine, ptr_txt->lignes[i], ptr_txt->col, strlen(ptr_txt->lignes[i]));
					v_gtext(Sys->VdiHandle, xo + 1, y_base, chaine);
					y_base += Sys->Hchar;
					i++;
				}
				vswr_mode(Sys->VdiHandle, MD_REPLACE);
				/* -- */
			}
			/* Rectangle suivant */
			set_clip (0, &r); 	/* Clipping OFF */
			wind_get (wind->handle, WF_NEXTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
		}
		wind_update (END_UPDATE); 	/* Dbloquer les fonctions de la souris */
		v_show_c (Sys->VdiHandle, 1); 			/* Rappeler la souris */
	}
}

static void WindTextFulled (Wind *wind)
{
	int x, y, w, h;
	WindText *ptr_txt = wind->cont.text;

	if (ptr_txt->full)
	{
		wind_get (wind->handle, WF_PREVXYWH, &x, &y, &w, &h); 	 /* Coord. prcd. */
		wind_set (wind->handle, WF_CURRXYWH, x, y, w, h); 		 /* Nouvelles coord. */
		ptr_txt->full = FALSE;
	}
	else
	{
		wind_set (wind->handle, WF_CURRXYWH, Sys->Xdesk, Sys->Ydesk, Sys->Wdesk, Sys->Hdesk);
		ptr_txt->full = TRUE;
	}
	wind_get (wind->handle, WF_CURRXYWH, &wind->Xpos, &wind->Ypos, &wind->Wpos, &wind->Hpos);
	WindTextSliders (wind);

	RecaleWind(wind);
}

static void WindTextArrow (Wind *wind)
{
	GRECT coord;
	int xw, yw, ww, hw, decal, pxy[8], hauteur_page, largeur_page;
	WindText *ptr_txt = wind->cont.text;

	GetWorkXYWH (wind->numObj, &coord);
	xw = coord.g_x;
	yw = coord.g_y;
	ww = coord.g_w;
	hw = coord.g_h;
	hauteur_page = hw / Sys->Hchar;
	largeur_page = ww / Sys->Wchar;
	switch (buff[4])
	{
	case WA_UPPAGE :				/* Page vers le haut */
		if (ptr_txt->lin > 0)
		{
			ptr_txt->lin = max (ptr_txt->lin - hauteur_page, 0);
			sim_redraw (wind, xw, yw, ww, hw);	/* Raffichage */
			WindTextSliders (wind); 				/* Actualiser les sliders */
		}
		break;
	case WA_DNPAGE :				/* Page vers le bas */
		if ((ptr_txt->lin + hauteur_page) < ptr_txt->nbrel)
		{
			ptr_txt->lin = min (ptr_txt->lin + hauteur_page, ptr_txt->nbrel - hauteur_page);
			sim_redraw (wind, xw, yw, ww, hw);	/* Raffichage */
			WindTextSliders (wind); 				/* Actualiser les sliders */
		}
		break;
	case WA_UPLINE :				/* Ligne vers le haut */
		if (ptr_txt->lin > 0)
		{
			ptr_txt->lin--;
			sim_redraw (wind, xw, yw, ww, hw);	/* Raffichage */
			WindTextSliders (wind); 				/* Actualiser les sliders */
		}
		break;
	case WA_DNLINE :				/* Ligne vers le bas */
		if ((ptr_txt->lin + hauteur_page) < ptr_txt->nbrel)
		{
			ptr_txt->lin++;
			sim_redraw (wind, xw, yw, ww, hw);	/* Raffichage */
			WindTextSliders (wind); 				/* Actualiser les sliders */
		}
		break;
	case WA_LFPAGE :				/* Page vers la gauche */
    if (ptr_txt->col > 0)
		{
			ptr_txt->col = max (ptr_txt->col - largeur_page, 0);
			sim_redraw (wind, xw, yw, ww, hw);	/* Raffichage */
			WindTextSliders (wind); 				/* Actualiser les sliders */
		}
		break;
		
	case WA_RTPAGE :				/* Page vers la droite */
 		if ((ptr_txt->col + largeur_page) < ptr_txt->nbrec)
		{
			ptr_txt->col = min (ptr_txt->col + largeur_page, ptr_txt->nbrec - largeur_page);
			sim_redraw (wind, xw, yw, ww, hw);	/* Raffichage */
			WindTextSliders (wind); 				/* Actualiser les sliders */
		}
		break;
		
	case WA_LFLINE :				/* Ligne vers la gauche */
		if (ptr_txt->col > 0)
		{
			ptr_txt->col--;
			sim_redraw (wind, xw, yw, ww, hw);	/* Raffichage */
			WindTextSliders (wind); 				/* Actualiser les sliders */
		}
		break;
		
	case WA_RTLINE :				/* Ligne vers la droite */
		if ((ptr_txt->col + largeur_page) < ptr_txt->nbrec)
		{
			ptr_txt->col++;
			sim_redraw (wind, xw, yw, ww, hw);	/* Raffichage */
			WindTextSliders (wind); 				/* Actualiser les sliders */
		}
		break;
	}
}

static void WindTextSized (Wind *wind)
{
	WindText *ptr_txt = wind->cont.text;
	int x, y, w, h;
	
	wind_set(wind->handle, WF_CURRXYWH, buff[4], buff[5], buff[6], buff[7]);
	ptr_txt->full = 0;							/* Annuler le flag de pleine ouverture */
	WindTextSliders (wind);							 /* Tailles et positions sliders */
	/* Enregistrer les coordonnes */
	wind_get(wind->handle, WF_CURRXYWH, &wind->Xpos, &wind->Ypos, &wind->Wpos, &wind->Hpos);

	wind_get(wind->handle, WF_WORKXYWH, &x, &y, &w, &h);
	if (wind->adr_wtoolbar != (OBJECT *)NULL)
		wind->adr_wtoolbar->ob_width = w;

	/* Sans cette ligne, le raffichage n'est pas correcte... */
/*	sim_redraw(wind, wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);*/
}

static void WindTextHSlider (Wind *wind)
{
	GRECT coord;
	int slide, xw, yw, ww, hw, largeur_page;
	WindText *ptr_txt = wind->cont.text;

	GetWorkXYWH (wind->numObj, &coord);
	xw = coord.g_x;
	yw = coord.g_y;
	ww = coord.g_w;
	hw = coord.g_h;

	slide = buff[4];
	largeur_page = ww / Sys->Wchar;					/* Hauteur en lignes de texte */
	ptr_txt->col = (int)((long)slide * (ptr_txt->nbrec - largeur_page) / 1000);
	wind_set(wind->handle, WF_HSLIDE, slide);
	sim_redraw(wind, xw, yw, ww, hw);
}

static void WindTextVSlider (	Wind *wind)
{
	GRECT coord;
	int slide, xw, yw, ww, hw, hauteur_page;
	WindText *ptr_txt = wind->cont.text;

	GetWorkXYWH (wind->numObj, &coord);
	xw = coord.g_x;
	yw = coord.g_y;
	ww = coord.g_w;
	hw = coord.g_h;

	slide = buff[4];
	hauteur_page = hw / Sys->Hchar;					/* Hauteur en lignes de texte */
	ptr_txt->lin = (int)((long)slide * (ptr_txt->nbrel - hauteur_page) / 1000);
	wind_set(wind->handle, WF_VSLIDE, slide);
	sim_redraw(wind, xw, yw, ww, hw);
}

void WindTextSliders (Wind *wind)
{
	GRECT coord;
	int xw, yw, ww, hw, hauteur_page, largeur_page;
	WindText *ptr_txt = wind->cont.text;
	
	GetWorkXYWH (wind->numObj, &coord);
	xw = coord.g_x;
	yw = coord.g_y;
	ww = coord.g_w;
	hw = coord.g_h;

	hauteur_page = hw / Sys->Hchar;
	largeur_page = ww / Sys->Wchar;
	
	/* Taille slider vertical */
	wind_set(wind->handle, WF_VSLSIZE, (int)((1000L * hauteur_page) / ptr_txt->nbrel));
	ptr_txt->lin = min(ptr_txt->lin, ptr_txt->nbrel - hauteur_page);
	if (ptr_txt->lin < 0)
		ptr_txt->lin = 0;

	/* Taille slider horizontal */
	wind_set(wind->handle, WF_HSLSIZE, (int)((1000L * largeur_page) / ptr_txt->nbrec));
	ptr_txt->col = min(ptr_txt->col, ptr_txt->nbrec - largeur_page);
	if (ptr_txt->col < 0)
		ptr_txt->col = 0;

	/* Position slider vertical */
	wind_set(wind->handle, WF_VSLIDE, (int)((1000L * ptr_txt->lin)
			/ (ptr_txt->nbrel - hauteur_page)));
			
	/* Position slider horizontal */
	wind_set(wind->handle, WF_HSLIDE, (int)((1000L * ptr_txt->col)
			/ (ptr_txt->nbrec - largeur_page)));
			
}

/**************************-=< Fin du module >=-**************************/
