/*************************************************************************
 * Gestion des fentres utilisateur                                      *
 *************************************************************************/

#include "WindGem.h"
#include "winproto.h"
#include <xgemfast.h>

/*-----------------------------------------------------------------------*
 * Initialisation des fenetres utilisateurs.                             *
 *                                                                       *
 * attrib     : Attributs de la fentre                                  *
 * pos        : coordonnes et dimensions de dpart de la fentre        *
 * title			: Titre de la fentre                                      *
 * init       : Fonction  appeler lors de l'initialisation              *
 * exit       : Fonction  appeler  la destruction de la fentre        *
 * message    : Fonction de traitement des vnements "Message"          *
 * clavier    : Fonction de gestion des vnements "Clavier"             *
 * souris     : Fonction de gestion des vnements "Souris"              *
 * var				: Pointeur sur une structure contenant des variables user  *
 *                                                                       *
 * Derniere modification : 28/08/1996                                    *
 *-----------------------------------------------------------------------*/
int WindUserInit (int attrib, GRECT pos, char *title, void (*init)(), void (*exit)(), void (*message)(int evnt), void (*clavier)(int kbd, int key), void (*souris)(int x, int y, int k, int nb), void *var)
{
	WindUser *ptr_user = (WindUser *)malloc(sizeof(WindUser));

	ptr_user->init		= init;
	ptr_user->exit		= exit;
	ptr_user->message = message;
	ptr_user->clavier	= clavier;
	ptr_user->souris	=	souris;
	ptr_user->var			= var;

	AjouteListe (WTYPUSER, attrib, Sys->lastUsr, WNORM, title, pos, (void *)ptr_user);
	Sys->lastUsr++;
	
	return (Sys->lastUsr - 1);
}

/*-----------------------------------------------------------------------*
 * Renvoie un pointeur sur la struc. var. d'une fentre "utilisateur"    *
 *-----------------------------------------------------------------------*/
void *GetVar (int numObj)
{
	void *var;
	Wind *wind;
	WindUser *ptr_user;
	
	wind = ObjListe(numObj);
	if (wind != WIND_NULL && wind->type == WTYPUSER)
	{
		ptr_user = wind->cont.user;
		var = ptr_user->var;
	}
	else
		var = (void *)NULL;

	return var;
}

/*-----------------------------------------------------------------------*
 * Fonction de gestion des formulaires en fenetre                        *
 *                                                                       *
 * wind 	: objet Wind a traiter                                         *
 * event  : evenement a traiter                                          *
 *                                                                       *
 * Derniere modification : 21/04/1996                                    *
 *-----------------------------------------------------------------------*/
void WindUserDo(Wind *wind, int evnt)
{
	GRECT r, rd, coord;
	int wx, wy, ww, wh;
	WindUser *ptr_user = wind->cont.user;
	int EnvoiUser = FALSE;
	
	if (evnt > 0)
	{
		if (evnt & MU_MESAG)
		{
			switch(buff[0])
			{
				case WM_REDRAW :
					rd.g_x = buff[4]; rd.g_y = buff[5];
					rd.g_w = buff[6]; rd.g_h = buff[7];
					if (wind->iconified == TRUE)
						DrawIcone (wind->handle, &rd);
					else
					{
						wind_update(BEG_UPDATE);
						if (wind->adr_wmenu != (OBJECT *)NULL || wind->adr_wtoolbar != (OBJECT *)NULL)
						{
							wind_get(wind->handle, WF_FIRSTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
							while (r.g_w && r.g_h)
							{
    	  	  		/* Rafficher la barre de menu */
								if (wind->adr_wmenu != (OBJECT *)NULL)
	      			  	objc_draw (wind->adr_wmenu, BARMENU, MAX_DEPTH, r.g_x, r.g_y, r.g_w, r.g_h);
								if (wind->adr_wtoolbar != (OBJECT *)NULL)
	      			  	objc_draw (wind->adr_wtoolbar, ROOT, MAX_DEPTH, r.g_x, r.g_y, r.g_w, r.g_h);

								wind_get(wind->handle, WF_NEXTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
							}
							/* Renvoi de la zone relle utilisable */
							GetWorkXYWH (wind->numObj, &coord);
							rc_intersect (&rd, &coord);
							buff[5] = coord.g_y;
							buff[7] = coord.g_h;
						}
						wind_update(END_UPDATE);
						EnvoiUser = TRUE;
					}
					break;

				case WM_TOPPED :
					wind_set(wind->handle, WF_TOP);
					break;
    	
				case WM_CLOSED : 
					if (ptr_user->exit)
						(*ptr_user->exit)();
					WindClose(wind->numObj);
					break;
      	
				case WM_MOVED :
					wind_set(wind->handle, WF_CURRXYWH, buff[4], buff[5], buff[6], buff[7]);
					if (wind->iconified == FALSE)
					{
						wind->Xpos = buff[4];
						wind->Ypos = buff[5];

						RecaleWind(wind);
					}
					EnvoiUser = TRUE;
					break;
				
				case WM_SIZED :
					wind_set(wind->handle, WF_CURRXYWH, buff[4], buff[5], buff[6], buff[7]);
					/* Annuler le flag de pleine ouverture */
					ptr_user->full = FALSE;	

					/* Enregistrer les coordonnes */
					wind_get(wind->handle, WF_CURRXYWH, &wind->Xpos, &wind->Ypos, &wind->Wpos, &wind->Hpos);
					wind_get(wind->handle, WF_WORKXYWH, &wx, &wy, &ww, &wh);
					if (wind->adr_wtoolbar != (OBJECT *)NULL)
						wind->adr_wtoolbar->ob_width = ww;

					EnvoiUser = TRUE;
					break;
					
				case WM_FULLED :
					if (ptr_user->full)
					{
						/* Coord. prcd. */
						wind_get (wind->handle, WF_PREVXYWH, &wx, &wy, &ww, &wh);
						/* Nouvelles coord. */
						wind_set (wind->handle, WF_CURRXYWH, wx, wy, ww, wh); 		 
						ptr_user->full = FALSE;
					}
					else
					{
						wind_set (wind->handle, WF_CURRXYWH, Sys->Xdesk, Sys->Ydesk, Sys->Wdesk, Sys->Hdesk);
						ptr_user->full = TRUE;
					}
					wind_get (wind->handle, WF_CURRXYWH, &wind->Xpos, &wind->Ypos, &wind->Wpos, &wind->Hpos);
					RecaleWind(wind);
					EnvoiUser = TRUE;
					break;

				case WM_ICONIFY :
					graf_shrinkbox(buff[4], buff[5], buff[6], buff[7], wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos);
					wind_set(wind->handle, WF_ICONIFY, buff[4], buff[5], buff[6], buff[7]);
					wind->iconified = TRUE;
					break;
				
				case WM_UNICONIFY :
					graf_growbox(wind->Xpos, wind->Ypos, wind->Wpos, wind->Hpos, buff[4], buff[5], buff[6], buff[7]);
					wind_set(wind->handle, WF_UNICONIFY, buff[4], buff[5], buff[6], buff[7]);
					wind->iconified = FALSE;
					break;

			case WM_ARROWED :
  		case WM_HSLID :
			case WM_VSLID :
					break;
			}
			if (ptr_user->message && EnvoiUser)
				(*ptr_user->message)(evnt, buff);
		}
		else if (evnt == MU_BUTTON)
		{
			if (ptr_user->souris)
				(*ptr_user->souris)(Sys->mousex, Sys->mousey, Sys->mousek, Sys->clik);
		}
		else if (evnt == MU_KEYBD)
		{
			if (ptr_user->clavier)
				(*ptr_user->clavier)(Sys->kbd, Sys->key);
		}
	}
	else
	{ /* Touches spciales */
		if (ptr_user->message)
			(*ptr_user->message)(evnt, buff);
	}
}

/*************************************************************************/
