/*************************************************************************
 * Module contenant les fonctions utilitaires des autres modules         *
 *************************************************************************/
#include "WindGem.h"
#include "winproto.h"
#include "user.h"

/*************************************************************************
 * Duplication d'un arbre d'objets.                                      *
 *                                                                       *
 * Reprise d'EGEM220.                                                    *
 *************************************************************************/
OBJECT *copy_tree(OBJECT *tree)
{
	OBJECT *new;
	TEDINFO *nted;
	register OBJECT *obj=tree;
	register TEDINFO *ted;
	register char *d,*s;
	register long size=0,strsize=0;
	register	int i;

	for (;;)
	{
		size += sizeof(OBJECT);
		switch ((unsigned char) obj->ob_type)
		{
		case G_TEXT:
		case G_FTEXT:
		case G_BOXTEXT:
		case G_FBOXTEXT:
			ted = obj->ob_spec.tedinfo;
			strsize += sizeof(TEDINFO);
			strsize += ted->te_txtlen*2+ted->te_tmplen+3+1;
			strsize &= ~1;
			break;
		case G_STRING:
		case G_TITLE:
		case G_BUTTON:
			strsize += strlen(obj->ob_spec.free_string)+1+1;
			strsize &= ~1;
			break;
		}
		if (obj->ob_flags & LASTOB)
			break;
		obj++;
	}

	if ((new=(OBJECT *) calloc(1,size+strsize))!=NULL)
		for (memcpy(obj=new,tree,size),nted=(TEDINFO *) (((char *) new)+size);;)
		{
			switch ((unsigned char) obj->ob_type)
			{
			case G_TEXT:
			case G_FTEXT:
			case G_BOXTEXT:
			case G_FBOXTEXT:
				ted = obj->ob_spec.tedinfo;
				obj->ob_spec.tedinfo = nted;
				*nted = *ted;
				nted->te_ptext = d = (char *) &nted[1];
				for (s=ted->te_ptext,i=ted->te_txtlen;--i>=0;*d++=*s++);
				nted->te_ptmplt = d;
				for (s=ted->te_ptmplt,i=ted->te_tmplen;--i>=0;*d++=*s++);
				nted->te_pvalid = d;
				for (s=ted->te_pvalid,i=ted->te_txtlen;--i>=0;*d++=*s++);
				nted = (TEDINFO *) ((long) (d+1) & ~1);
				break;
			case G_STRING:
			case G_TITLE:
			case G_BUTTON:
				obj->ob_spec.free_string = d = strcpy((char *) nted,obj->ob_spec.free_string);
				nted = (TEDINFO *) ((long) (d+strlen(d)+1+1) & ~1);
			}
			if (obj->ob_flags & LASTOB)
				break;
			obj++;
		}
	return (new);
}

/*-----------------------------------------------------------------------*
 * Affichage d'un icone dans une fenetre iconifiee                       *
 *-----------------------------------------------------------------------*/
void DrawIcone (int handle, GRECT *zone)
{
	int xw, yw, ww, hw, pxy[4];

	/* Coordonnes zone de travail : */
	wind_get (handle, WF_WORKXYWH, &xw, &yw, &ww, &hw);
	pxy[0] = xw;                						/* Prparer effacement fentre */
	pxy[1] = yw;
	pxy[2] = xw + ww - 1;
	pxy[3] = yw + hw - 1;
	vswr_mode (Sys->VdiHandle, MD_REPLACE); /* Dessin en mode Remplacement */
	vsf_color (Sys->VdiHandle, 0);          /* Couleur blanche */
	v_bar (Sys->VdiHandle, pxy);       			/* "Vider" la fentre */

	(Sys->AdrIcone)->ob_x = xw;
	(Sys->AdrIcone)->ob_y = yw;

	objc_draw (Sys->AdrIcone, ICONE, 1, xw, yw, ww, hw);
}

/*-----------------------------------------------------------------------*
 * Capture d'un fond.                                                    *
 *-----------------------------------------------------------------------*/
void get_bkgr (int of_x, int of_y, int of_w, int of_h, MFDB *img)
{
	int pxy[8];
	size_t taille;
	MFDB ecr={0};

	of_x -= 3;										/* Prvoir une marge de scurit autour  */
	of_y -= 3;										/* de la zone, pour le cas o on aurait  */
	of_w += 5;										/* besoin de sauvegarder le fond d'un    */
	of_h += 5;										/* formulaire avec un attribut OUTLINED. */

	/* Taille tampon de copie fond */
	taille = ((((size_t)(of_w / 16) + 1) * 2 * (size_t)Sys->Nplane) * (size_t)of_h) + 256;

	img->fd_addr = (FDADDR)malloc (taille);							/* Rserver tampon */
	img->fd_w = of_w;		                      /* Remplir la structure MFDB */
	img->fd_h = of_h;
	img->fd_wdwidth = (of_w / 16) + ((of_w % 16) != 0);
	img->fd_stand = 1;
	img->fd_nplanes = Sys->Nplane;

	pxy[0] = of_x;																	 /* Remplir la tableau */
	pxy[1] = of_y;
	pxy[2] = pxy[0] + of_w - 1;
	pxy[3] = pxy[1] + of_h - 1;
	pxy[4] = 0;
	pxy[5] = 0;
	pxy[6] = of_w - 1;
	pxy[7] = of_h - 1;
	v_hide_c (Sys->VdiHandle);													/* Virer la souris */
	vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, &ecr, img);	/* Copier l'image  */
	v_show_c (Sys->VdiHandle, TRUE);										/* Remet la souris */
}

/*-----------------------------------------------------------------------*
 * Reaffichage d'un fond.                                                *
 *-----------------------------------------------------------------------*/
void put_bkgr (int of_x, int of_y, int of_w, int of_h, MFDB *img)
{
	int pxy[8];
	MFDB ecr={0};

	of_x -= 3;										/* Prvoir une marge de scurit autour  */
	of_y -= 3;										/* de la zone, pour le cas o on aurait  */
	of_w += 5;										/* besoin de sauvegarder le fond d'un    */
	of_h += 5;										/* formulaire avec un attribut OUTLINED. */

	pxy[0] = 0;										/* Remplir le tableau                    */
	pxy[1] = 0;
	pxy[2] = of_w - 1;
	pxy[3] = of_h - 1;
	pxy[4] = of_x;
	pxy[5] = of_y;
	pxy[6] = pxy[4] + pxy[2] - 1;
	pxy[7] = pxy[5] + pxy[3] - 1;
	v_hide_c (Sys->VdiHandle);		                      /* Cache la souris */
	vro_cpyfm (Sys->VdiHandle, S_ONLY, pxy, img, &ecr);	/* Copier l'image  */
	v_show_c (Sys->VdiHandle, TRUE);	                  /* Remet la souris */
	free (img->fd_addr);                             /* Libre la mmoire */
}

/*-----------------------------------------------------------------------*
 * Affichage d'une boite d'alerte                                        *
 *-----------------------------------------------------------------------*/
void FormAlerte(int index)
{
	char **alert;
	rsrc_gaddr(R_FRSTR, index, &alert);	 /* Adresse ptr sur ptr sur chaine */
	form_alert(1, *alert);
}

/*-----------------------------------------------------------------------*
 * Recherche de l'objet pere d'un objet                                  *
 *-----------------------------------------------------------------------*/
int parent (OBJECT *adr, int object)
{
	register int i;

  i = object;			             												/* Partir de cet objet */
  do
  {
    i = adr[i].ob_next;													 /* Passer au suivant... */
  } while (i > object);                      /* Jusqu'a revenir au pere. */

  return i;                                         /* Retourner le pere */
}

/*-----------------------------------------------------------------------*
 * Recuperer numero d'item menu                                          *
 *-----------------------------------------------------------------------*/
int m_title (OBJECT *adresse, int option)
{
	register menu = 1, k = 2;
	int pere, titre;

  pere = parent (adresse, option);
  while (adresse[(k++) + 1].ob_type != G_BOX) ; 		/* Chercher 1 G_BOX */

  while (k != pere)
  {
    k = adresse[k].ob_next;     					/* Chercher menu correspondant */
    menu++;                     					/* Les compter                 */
  }

  k = 3;
  do
  {
    titre = k++;        									/* L'affecter                  */
  } while ((k - 3) != menu);

  return titre;
}

/*-----------------------------------------------------------------------*
 * Fonction de mise en place d'un Clipping.                              *
 *-----------------------------------------------------------------------*/
void set_clip (int clip_flag, GRECT *area)
{ /* Active ou dsactive le clipping d'une zone */
	int pxy[4];

	pxy[0] = area->g_x;
	pxy[1] = area->g_y;
	pxy[2] = area->g_w + area->g_x - 1;
	pxy[3] = area->g_h + area->g_y - 1;
	vs_clip (Sys->VdiHandle, clip_flag, pxy);
}

/*-----------------------------------------------------------------------*
 * Simulation d'un message.                                              *
 *-----------------------------------------------------------------------*/
void EnvoiMessage(int type, int handle, int message)
{
	buff[0] = type;
	buff[1] = Sys->AppId;
	buff[2] = 0;
	buff[3] = handle;
	buff[4] = message;
	buff[5] = 0;
	buff[6] = 0;
	buff[7] = 0;

 	appl_write (Sys->AppId, 16, buff);  					 /* Envoi du message */
}

void EnvoiRedraw(int handle, int x, int y, int w, int h)
{
	buff[0] = WM_REDRAW;
	buff[1] = Sys->AppId;
	buff[2] = 0;
	buff[3] = handle;
	buff[4] = x;
	buff[5] = y;
	buff[6] = w;
	buff[7] = h;

 	appl_write (Sys->AppId, 16, buff);  					 /* Envoi du message */
}
/*-----------------------------------------------------------------------*
 * Gestion de la frappe d'une touche au clavier                          *
 *-----------------------------------------------------------------------*/
int stdkey (unsigned char *k)
{
	KEYTAB *kt;

	kt = Keytbl((void *)-1, (void *)-1, (void *)-1);
	*k = toupper (kt->shift[(char)((Sys->key) >> 8)]);

	return toupper (kt->shift[(char)((Sys->key) >> 8)]);
}

/*-----------------------------------------------------------------------*
 * Suppression des espaces en debut et fin de chaine <str>               *
 *-----------------------------------------------------------------------*/
char *trim (char *str)
{
	register char *s;
	register int i = 0;
	char chaine[MAX_LEN];

  while (*(str + i) == ' ')
    i++;
  strcpy (chaine, (str + i));

  s = chaine + strlen (chaine) - 1;
  for( ; (*s == ' ') && (s >= chaine) ; *s-- = 0);
  strcpy (str, chaine);

  return str;
}

/*-----------------------------------------------------------------------*/
char *strnpcpy(char *dest, char *start, char *stop)
/*-----------------------------------------------------------------------*
 * Fonction de bibliotheque : Copie dans "dest" la portion de chaine a   *
 * partir du pointeur "start", jusqu'au caractere place juste avant le   *
 * pointeur "stop". "start" et "stop" doivent obligatoirement pointer    *
 * dans la meme chaine. Dans tous les cas "dest" est terminee par le     *
 * caractere de fin de chaine '\0'.                                      *
 *-----------------------------------------------------------------------*/
{
	char *ptr_dest = dest;

	while (start < stop && (*(ptr_dest)++ = *(start++)) != 0);
	*ptr_dest = '\0';

	return dest;
}

char *get_text (OBJECT *adr, int object)
{
	int type;
	char *retour = "";

	type = adr[object].ob_type & 0xFF;	/* Lire le type de l'objet  */
																			/* en virant le type etendu */

	/* Si ob_spec dsigne le texte */
	if ((type == G_STRING) || (type == G_BUTTON))
		retour = (adr[object].ob_spec.free_string);
	/* Si ob_spec dsigne une structure TEDINFO */
	else if ((type == G_TEXT) || (type == G_BOXTEXT) || (type == G_FTEXT) || (type == G_FBOXTEXT))
		retour = (adr[object].ob_spec.tedinfo->te_ptext);
	else if (type == G_USERDEF)
		retour = ((char *)(adr[object].ob_spec.userblk->ub_parm));

	return retour;	/* Retourner pointeur sur la chane */
}

void set_text (OBJECT *adr, int object, char *string)
{
	int type;

	type = adr[object].ob_type & 0xFF;	/* Lire le type de l'objet  */
																			/* en virant le type etendu */

	/* Si ob_spec dsigne le texte */
	if ((type == G_STRING) || (type == G_BUTTON))
		strcpy (adr[object].ob_spec.free_string, string);
	/* Si ob_spec dsigne une structure TEDINFO */
	else if ((type == G_TEXT) || (type == G_BOXTEXT) || (type == G_FTEXT) || (type == G_FBOXTEXT))
		strcpy (adr[object].ob_spec.tedinfo->te_ptext, string);
	else if (type == G_USERDEF)
		strcpy ((char *)(adr[object].ob_spec.userblk->ub_parm), string);
}

long exist (char *name, int att)
{
int re;

	re = Fsfirst (name, att);
	if ((re == -34) || (re == -33))		/* Si rien n'est trouv */
		return (FALSE);									/* retourner FALSE */
	else															/* Sinon */
	{
		if ((att & FA_SUBDIR) != FA_SUBDIR)	/* Si ce n'est pas un dossier */
			return dtabuffer.d_length;				/* Retourner la taille */
		else																/* Si c'est un dossier */
			return (TRUE);										/* Retourner TRUE */
	}
}

/* path () Cherche et retourne le chemin de l'application :			*/
char *path (char *chemin)
{
int drive;

	drive = Dgetdrv ();							/* Lecteur courant */
	chemin[0] = (char) (65 + drive);
	chemin[1] = ':';
	Dgetpath (&chemin[2], drive + 1);	/* Chemin lecteur courant */
	strcat (chemin, "\\");
	return chemin;
}

/* selector () Slecteur : 																			*/
int selector (char *chemin, char *ext, char *file, char *title)
{
char ch[120], fi[13];
int retour, i;

	strcpy (ch, chemin);
	strcat (ch, ext); 						/* Chemin et slection */
	strcpy (fi, file);
	if ((Sversion () >> 8) <= 20)
		fsel_input (ch, fi, &retour); 					/* Appel du slecteur */
	else
		fsel_exinput (ch, fi, &retour, title);	/* Appel du slecteur */
	if (retour)										/* Si pas ANNULER... */
	{
		for (i = (int)strlen (ch) ; ch[i] != '\\' ; ch[i--] = '\0') ;
		strcpy (chemin, ch);
		strcpy (file, fi);
	}
	return retour;
}

/* extension () Ajuste extension :																*/
void extension (char *filename, char *ext)
{ 							/* L'EXTENSION DOIT ETRE TRANSMISE AVEC LE POINT */
int t;

	t = (int)strlen (filename);								/* Longueur du nom de fichier */
	while (filename[t] != '.' && t > ZERO) 	/* Chercher le '.'  partir de la droite */
		t--;
	if (t > ZERO)										/* Si trouv, */
	{
		memcpy (filename + t, ext, 4); 			/* ajouter l'extention  partir de l */
		filename[t + 4] = '\0';
	}
	else														/* Sinon, */
		strcat (filename, ext);							/* l'ajouter  la fin */
}

/* litdate () Lit la date systme ou fichier et conv. chane :		*/
void litdate (char *dat, unsigned int fdate)
{
int d, a, m, j;
char ac[3], mc[3], jc[3];

	if (fdate == ZERO)
		d = Tgetdate ();
	else
		d = fdate;
	j = d & 0x1f;
	m = (d >> 5) & 0x0f;
	a = ((d >> 9) & 0x7f) + 80;

	itoa (j, jc, 10);
	if (strlen (jc) == 1)
	{
		jc[1] = jc[0];
		jc[0] = '0';
		jc[2] = '\0';
	}
	itoa (m, mc, 10);
	if (strlen (mc) == 1)
	{
		mc[1] = mc[0];
		mc[0] = '0';
		mc[2] = '\0';
	}
	itoa (a, ac, 10);
	if (strlen (ac) == 1)
	{
		ac[1] = ac[0];
		ac[0] = '0';
		ac[2] = '\0';
	}

	strcpy (dat, jc);
	strcat (dat, mc);
	strcat (dat, ac);
}

/* convdate () Convertir date chane en valeur :									*/
void convdate (char *date, unsigned int *fdate)
{
int j, m, a, new_date = ZERO;
char jc[3], mc[3], ac[3];

	jc[0] = date[0];
	jc[1] = date[1];
	jc[2] = '\0';

	mc[0] = date[2];
	mc[1] = date[3];
	mc[2] = '\0';

	ac[0] = date[4];
	ac[1] = date[5];
	ac[2] = '\0';

	j = atoi (jc);
	m = atoi (mc);
	a = atoi (ac) - 80;

	new_date |= j;
	new_date |= (m << 5);
	new_date |= (a << 9);

	*fdate = new_date;
}

/*
Ajoute <ch> avant <chaine>
*/
char *strinsert (char *chaine, char *ch)
{
	char temp[256];
	
	strcpy(temp, chaine);
	strcpy(chaine, ch);
	strcat(chaine, temp);
	
	return chaine;
}

/*
Complete une chaine de caractere par des <car> avant ou apres
suivant <sens> (1 ou -1)
*/
char *strcomplete (char *chaine, int lng, char car, int sens)
{
	int i, j = 0;
	char ch[256];
	
	i = lng - strlen(chaine);
	
	if (i > 0)
	{
		ch[i] = '\0';
		while (i > 0)
			ch[--i] = car;
	
		switch (sens)
		{
			case INS_AVANT :
				strinsert(chaine, ch);
				break;
			case INS_APRES :
				strcat(chaine, ch);
		}
	}

	return chaine;	
}

/*
Copy dans <res> de la sous-chaine commencant en position <deb>
et finissant par <fin> compris de la chaine <chaine>
*/
char *strcopy(char *res, char *chaine, int deb, int fin)
{
	int i = 0, l = strlen(chaine);

	if (deb < 0 || fin < 0 || fin < deb || deb > l || fin > l)
	{
		strcpy(res,"");
		return (char *)0;
	}

	while (deb <= fin && chaine[deb])
		res[i++] = chaine[deb++];

	res[i] = '\0';
	
	return res;	
}

/*-----------------------------------------------------------------------*
 * Fonction de remplissage d'un tableau.                                 *
 *-----------------------------------------------------------------------*/
void fill_tab (int *pxy, int n, ...)
{
	int i, val;
	va_list pa;

	va_start (pa, n);
	for (i = ZERO ; i < n ; i++)
	{
		val = va_arg (pa, int);
		*(pxy + i) = val;
	}
	va_end (pa);
}

void cre_fichier(char *chemin, char *fic, char *fichier)
{
	char *pos;

	pos = strrchr(chemin,'\\');
	strnpcpy(fichier, chemin, pos + 1);
	strcat(fichier, fic);	
}

void GetCharSize (int *Wchar, int *Hchar)
{
	*Wchar = Sys->Wchar;
	*Hchar = Sys->Hchar;
}

void GetDeskXYWH (int *Xdesk, int *Ydesk, int *Wdesk, int *Hdesk)
{
	*Xdesk = Sys->Xdesk;
	*Ydesk = Sys->Ydesk;
	*Wdesk = Sys->Wdesk;
	*Hdesk = Sys->Hdesk;
}

void GetVideoRes (int *Xres, int *Yres, int *Nplane)
{
	*Xres = Sys->Xres;
	*Yres = Sys->Yres;
	*Nplane = Sys->Nplane;
}
