/*************************************************************************
 * Test - (c) 1996 Philippe Castella                                     *
 * Programme de test de la librarie WindGem                              *
 *************************************************************************/

/*************************************************************************
 * Fichiers  inclure                                                    *
 *************************************************************************/
#include <WindGem.h>		/* Formulaires en fentre */
#include <xgemfast.h>
#include "audio.h"
#include "test.h"				/* Dfinition des objets  */
#include <macros.h>
#include <falcon30.h>

/*************************************************************************
 * Prototypes des fonctions du programme                                 *
 *************************************************************************/
void gereMenuWind(int opt);
void gereMenuText(int opt);
void gereMenu(int option);
void main(void);
void init_prog(void);

void informe(int evnt);
void form(int evnt);
void systeme(int evnt);
void form1(int evnt);

void UserInit (void);
void UserExit (void);
void UserMessage (int evnt, int buff[8]);
void UserClavier (int kbd, int key);
void UserSouris (int x, int y, int k, int nb);

extern System *Sys;
/*************************************************************************
 * Paramtres de l'application                                           *
 *************************************************************************/
int finProg = FALSE;
int ouvert = FALSE;
int user = 0;
int snd = TRUE;

char texte[50][30];
char **textUser;

struct samp_list *p;
struct samp_list *root;			  		/* root of list                        */

void gereMenuWind(int opt)
{
	form_alert(1,"[1][|Gestion d'un Menu en fentre !!|][Ok]");	
}

void gereMenuText(int opt)
{
	static int count = 0;
	int nblig, nbcol;
	char **texte, lig[20];
	
	switch (opt)
	{
		case MTFERME :
			WindDelete (CurWindow);
			break;
		case MTMODIF :
			nblig = GetWindText (CurWindow, &texte, &nbcol);
			sprintf(lig,"<< Change ligne %d >>", count);
			strcpy(texte[count], lig);
			count++;
			SetWindText (CurWindow, nblig, nbcol, texte);
			break;		
	}

}

void gereToolBar(int opt)
{
	form_alert(1,"[1][|Gestion d'une ToolBar en fentre !!|][Ok]");	
	ToolBarUnselect (CurWindow, opt, REDRAW);
}

void gerePopup (int option)
{
	switch (option)
	{
	case POP1 :
	case POP2 :
	case POP3 :
	case POP4 :
		form_alert(1,"[1][|Gestion d'un popup Menu par appui|sur la touche droite de la souris !!|][Ok]");
		break;
	}
}

void gereMenu (int option)
{
	char chemin[128], fname[13] = {0};
	int numTxt, numTxt1;
	GRECT Fpos;
	int i;
	MFDB fond;

	int wx, wy, ww, wh;
				
	switch (option)
	{
	case MSYST :
		WindOpen(SYSTEME);
		break;

	case MFORM :
		WindOpen(FORM);
		break;

	case MTEXTE :
		strcpy(chemin,"\\");
		if (selector (chemin, "*.*", fname, "Choisir un fichier texte"))
		{
			if (strcmp(fname,"") != 0)
			{
				Fpos.g_x = 100;
				Fpos.g_y = 100;
				Fpos.g_w = 400;
				Fpos.g_h = 300;
				strcat(chemin, fname);
				numTxt = WindTextInit (chemin, &Fpos, (char *)NULL);
/*				AjouteToolBar(numTxt, TOOLBAR, NODRAW, gereToolBar);*/
				AjouteMenu(numTxt, MENUTEXT, NODRAW, gereMenuText);
				WindOpen(numTxt);
			}
		}
		break;

	case MTEXTE1 :
		Fpos.g_x = 200;
		Fpos.g_y = 100;
		Fpos.g_w = 400;
		Fpos.g_h = 300;
		numTxt1 = WindTextInit ("", &Fpos, "Contenu gr par l'utilisateur");
		AjouteMenu(numTxt1, MENUTEXT, NODRAW, gereMenuText);
		WindOpen(numTxt1);
		SetWindText (numTxt1, 50, 19, textUser);
		break;
		
	case MUSER :
		WindOpen(user);		
		break;

	case MSLIDER :
		
		SetSlider(SLIDINI, 100, 0, "Essai du Slider");

		for (i=0;i < 100;i++)
			SetSlider(SLIDAFF, 0, i, "");
			
		SetSlider(SLIDEND, 0, 0, "");

		break;
		
	case MINFO :
		WindOpen(PROGINFO);
		break;

	case MQUITTER :
		finProg = TRUE;
		break;
	}
}

/*-----------------------------------------------------------------------*/
void main(void)
/*-----------------------------------------------------------------------*
 * Fonction principale                                                   *
 * - Initialisation,                                                     *
 * - Gestion des vnements,                                             *
 * - Fin du programme.                                                   *
 *-----------------------------------------------------------------------*/
{
	int i;
	textUser = (char **)malloc(50 * sizeof(char **));

	for (i = 0; i < 50; i++)
	{
		sprintf (texte[i], "Ligne de texte n%2d", i + 1);
    textUser[i] = texte[i];
  }

	init_prog();

	if (Ordi.Machine == FALCON30 && AudioInit() != SND_OK)
	{
		form_alert(1, "[1][Systme Audio dj verouill !!][Ok]");
		snd = FALSE;
	}

	AjouteSample(SMP_AVR, "COUCOU.AVR", "COUCOU");
	do
	{
		EventMulti();
	} while (NOT finProg);

	free (textUser);			/* Texte dfinit par l'utilisateur -> librer la */
												/* mmoire soi-mme !!!                          */
	if (snd && Ordi.Machine == FALCON30)
		AudioExit();

	AppExit();
	exit(0);
}

void init_prog(void)
{
	GRECT pos;
/*	int Xd, Yd, Wd, Hd, Xr, Yr, N, Wh, Hh;*/
	
	AppInit("Test.rsc", DESK, (void *)NULL, MENU, gereMenu);

/* Affichage de quelques info systme.
	GetCharSize (&Wh, &Hh);
	GetDeskXYWH (&Xd, &Yd, &Wd, &Hd);
	GetVideoRes (&Xr, &Yr, &N);
	sprintf (mes, "[1][Desk x=%d y=%d w=%d h=%d|Char w=%d h=%d|Res x=%d y=%d plans=%d][Ok]",Xd, Yd, Wd, Hd, Wh,Hh, Xr, Yr, N);
	form_alert(1,mes);
*/	
	WindFormInit(PROGINFO, WMODAL , 0, 0, "Informations"            , 0      , informe   );
	WindFormInit(FORM    , WNORM , 0, 0, "Crer une nouvelle fiche", STIT, form);
	AjoutePopup (FORM, SCAT, POPUP);

/*	AjouteMenu(FORM, WMENU, NODRAW, gereMenuWind);*/
	AjouteToolBar(FORM, TOOLBAR, NODRAW, gereToolBar);

	AjouteAide (FORM, SSAUV, "Bouton menu...|Permet d'ajouter ou d'enlever|dynamiquement un menu...");
	AjouteAide (FORM, SANNU, "Bouton d'annulation|Ferme la fiche sans sauvegarde|de son contenu...");
	AjouteAide (FORM, SCAT, "Bouton de popup|Permet de slectionner la catgorie|du livre...");
	AjouteAide (FORM, SAIDE, "Bouton HELP|Permet de faire appel  l'aide en ligne|enfin bientt...");

	WindFormInit(SYSTEME, WNORM , 0, 0, "Information Systme", 0, systeme);


	pos.g_x = 40;
	pos.g_y = 40;
	pos.g_w = 300;
	pos.g_h = 200;
/*	user = WindUserInit ((NAME|CLOSER|FULLER|MOVER|SMALLER|SIZER), pos, "Fentre User Defined", UserInit, UserExit, UserMessage, UserClavier, UserSouris, (void *)NULL);*/
	user = WindUserInit ((NAME|CLOSER|FULLER|MOVER|SMALLER|SIZER), pos, "Fentre User Defined", UserInit, (void *)NULL, UserMessage, (void *)NULL, UserSouris, (void *)NULL);

/*	AjouteMenu(user, WMENU, NODRAW, gereMenuWind);*/
	AjouteToolBar(user, TOOLBAR, NODRAW, gereToolBar);

	PopMenu(POPUPM, gerePopup);
}


/*-----------------------------------------------------------------------*
 * Routines de gestion du menu                                           *
 *-----------------------------------------------------------------------*/
void informe(int evnt)
{
	int choix;
	
	if (evnt & MU_BUTTON)
	{
		choix = GetObjet();
		if (choix > 0)
		{
			ObjcUnselect (PROGINFO, choix);
			if (snd && Ordi.Machine == FALCON30)
				PlaySample("COUCOU");
			WindClose(PROGINFO);
		}
	}
}

void form(int evnt)
{
	int choix;
	static int flag = FALSE;

	if (evnt == EV_OPEN)
	{
		form_alert(1,"[1][Fonction appelee  |l'ouverture de la fenetre][Ok]");
		ToolBarSelect (FORM, TBOPT2, NODRAW);
	}		
	if (evnt == EV_CLOSE)
	{
		form_alert(1,"[1][Fonction appelee  |la fermeture de la fenetre][Ok]");
		/* ATTENTION : ne pas fermer la fenetre */
	}		
	if (evnt & MU_BUTTON)
	{
		choix = GetObjet();

		if (choix == SSAUV)
		{
			if (! flag)
			{
				flag = TRUE;
				form_alert(1,"[1][Ajout d'un menu dynamiquement][Ok]");
				AjouteMenu(FORM, WMENU, REDRAW, gereMenuWind);
/*				AjouteToolBar(FORM, TOOLBAR, REDRAW, gereToolBar);*/
			}
			else
			{
				flag = FALSE;
				form_alert(1,"[1][Suppression d'un menu dynamiquement][Ok]");
				EnleveMenu(FORM, REDRAW);
/*				EnleveToolBar(FORM, REDRAW);*/
			}		
		}

		if (choix == SAIDE)
		{
			StGuide ("WindGem.Hyp", "StGuide");
		}

		if (choix == SANNU || choix == SSAUV || choix == SAIDE)
			ObjcUnselect (FORM, choix);

		if (choix == SANNU || choix == EV_CLOSE)
			WindClose(FORM);
	}
}

void systeme(int evnt)
{
	int choix;
	char txt[30];
	
	if (evnt == EV_OPEN)
	{
		switch (Ordi.Processor)
		{
			case M68000 :
				SetValeur (SYSTEME, SYSPROC, "68000");
				break;
			case M68010 :
				SetValeur (SYSTEME, SYSPROC, "68010");
				break;
			case M68020 :
				SetValeur (SYSTEME, SYSPROC, "68020");
				break;
			case M68030 :
				SetValeur (SYSTEME, SYSPROC, "68030");
				break;
		}
		if (Ordi.Machine == ST)
				SetValeur (SYSTEME, SYSMACH, "ST        ");
		else if (Ordi.Machine == STE)
				SetValeur (SYSTEME, SYSMACH, "STE       ");
		else if (Ordi.Machine == MSTE)
				SetValeur (SYSTEME, SYSMACH, "Mega STE  ");
		else if (Ordi.Machine == TT)
				SetValeur (SYSTEME, SYSMACH, "TT 030    ");
		else if (Ordi.Machine == FALCON30)
				SetValeur (SYSTEME, SYSMACH, "Falcon 030");
		else
				SetValeur (SYSTEME, SYSMACH, "Inconnue  ");

		switch (hibyte(hiword(Ordi.Fdc)))
		{
			case 0 :
				SetValeur(SYSTEME, SYSFDC, "DD");
				break;
			case 1 :
				SetValeur(SYSTEME, SYSFDC, "HD");
				break;
			case 2 :
				SetValeur(SYSTEME, SYSFDC, "ED");
				break;
		}

		switch (Ordi.Keyboard)
		{
			case KEYB_USA :
				SetValeur (SYSTEME, SYSCLAV, "USA     ");
				break;
			case KEYB_D :
				SetValeur (SYSTEME, SYSCLAV, "Allemand");
				break;				
			case KEYB_F :
				SetValeur (SYSTEME, SYSCLAV, "Franais");
				break;
			case KEYB_GB :
				SetValeur (SYSTEME, SYSCLAV, "Anglais ");
				break;
			case KEYB_SP :
				SetValeur (SYSTEME, SYSCLAV, "Espagnol");
				break;
			case KEYB_I :
				SetValeur (SYSTEME, SYSCLAV, "Italien ");
				break;
			case KEYB_CHD :
				SetValeur (SYSTEME, SYSCLAV, "Suisse D");
				break;
			case KEYB_CHF :
				SetValeur (SYSTEME, SYSCLAV, "Suisse F");
				break;
		}
		switch (Ordi.Language)
		{
			case LG_USA :
				SetValeur (SYSTEME, SYSLANG, "USA     ");
				break;
			case LG_D :
				SetValeur (SYSTEME, SYSLANG, "Allemand");
				break;				
			case LG_F :
				SetValeur (SYSTEME, SYSLANG, "Franais");
				break;
			case LG_GB :
				SetValeur (SYSTEME, SYSLANG, "Anglais ");
				break;
			case LG_SP :
				SetValeur (SYSTEME, SYSLANG, "Espagnol");
				break;
			case LG_I :
				SetValeur (SYSTEME, SYSLANG, "Italien ");
				break;
			case LG_CHD :
				SetValeur (SYSTEME, SYSLANG, "Suisse D");
				break;
			case LG_CHF :
				SetValeur (SYSTEME, SYSLANG, "Suisse F");
				break;
		}
		if (Ordi.Shifter == SHIFTER_ST)
			SetValeur(SYSTEME, SYSSHIF, "ST    ");
		else if (Ordi.Shifter == SHIFTER_STE)	
			SetValeur(SYSTEME, SYSSHIF, "STE   ");
		else if (Ordi.Shifter == SHIFTER_TT)
			SetValeur(SYSTEME, SYSSHIF, "TT    ");
		else if (Ordi.Shifter == VIDEL_FALCON)
			SetValeur(SYSTEME, SYSSHIF, "Falcon");
		else
			SetValeur(SYSTEME, SYSSHIF, "??????");

		strcpy(txt, "");
		if (Ordi.Sound & PSG)
			strcat(txt, "PSG ");
		if (Ordi.Sound & DSP)
			strcat(txt, "DSP ");
		if (Ordi.Sound & CODEC)
			strcat(txt, "CODEC ");
		if (Ordi.Sound & MATRICE)
			strcat(txt, "MATRICE ");

		strcomplete (txt, 24, ' ', INS_APRES);
		SetValeur (SYSTEME, SYSSND, txt);
		switch (Ordi.Fpu)
		{
			case NO_FPU :
				SetValeur (SYSTEME, SYSFPU, "Aucun       ");
				break;
			case SFP004 :
				SetValeur (SYSTEME, SYSFPU, "SFP004      ");
				break;
			case C68881_2 :
				SetValeur (SYSTEME, SYSFPU, "C68881_2    ");
				break;
			case C68881_2_SFP :
				SetValeur (SYSTEME, SYSFPU, "C68881_2_SFP");
				break;
			case C68881 :
				SetValeur (SYSTEME, SYSFPU, "C68881      ");
				break;
			case C68881_SFP :
				SetValeur (SYSTEME, SYSFPU, "C68881_SFP  ");
				break;
			case C68882 :
				SetValeur (SYSTEME, SYSFPU, "C68882      ");
				break;
			case C68882_SFP :
				SetValeur (SYSTEME, SYSFPU, "C68882_SFP  ");
				break;
			case C68040 :
				SetValeur (SYSTEME, SYSFPU, "C68040      ");
				break;
			case C68040_SFP :
				SetValeur (SYSTEME, SYSFPU, "C68040_SFP  ");
				break;
		}
		switch (Ordi.Date)
		{
			case DATE_MJA :
				SetValeur (SYSTEME, SYSDATE, "MJA");
				break;
			case DATE_JMA :
				SetValeur (SYSTEME, SYSDATE, "JMA");
				break;
			case DATE_AMJ :
				SetValeur (SYSTEME, SYSDATE, "AMJ");
				break;
			case DATE_AJM :
				SetValeur (SYSTEME, SYSDATE, "AJM");
				break;
		}
		sprintf(txt, "%c",Ordi.Separator);
		SetValeur(SYSTEME, SYSSEP, txt);

		if (Ordi.Time)
			SetValeur (SYSTEME, SYSTIME, "12");
		else
			SetValeur (SYSTEME, SYSTIME, "24");

		sprintf (txt, "%X", Ordi.TosVersion);
		SetValeur (SYSTEME, SYSTOS, txt);

		sprintf (txt, "%X%X", lobyte(Ordi.GemdosVersion), hibyte(Ordi.GemdosVersion));
		SetValeur (SYSTEME, SYSGEMD, txt);
		sprintf (txt, "%X", Ordi.AesVersion);
		SetValeur (SYSTEME, SYSAES, txt);
		if (Ordi.MultiTosVersion == 0)
			SetValeur (SYSTEME, SYSMINT, "Non");
		else
		{
			sprintf (txt, "%X", Ordi.MultiTosVersion);
			SetValeur (SYSTEME, SYSMINT, txt);
		}
		if (Ordi.Magic)
			SetValeur (SYSTEME, SYSMAG, "Oui");
		else
			SetValeur (SYSTEME, SYSMAG, "Non");
}
	
	if (evnt & MU_BUTTON)
	{
		choix = GetObjet();
		if (choix > 0)
		{
			ObjcUnselect (SYSTEME, choix);
			WindClose(SYSTEME);
		}
	}
}
/************************************************************************/
/* Fonctions de gestion de la fentre utilisteur                        */
/************************************************************************/
void UserInit (void)
{
		form_alert(1,"[1][User : Init][Ok]");
}

void UserExit (void)
{
		form_alert(1,"[1][User : Exit][Ok]");
}

void UserMessage (int evnt, int buff[8])
{
	GRECT rd, coord, r;
	int h, xy[4];

	h = GetHandle (user);
		
/*
	if (evnt == MU_MESAG)
		form_alert(1,"[1][User : Message][Ok]");
	else
		form_alert(1,"[1][User : Touche spciale][Ok]");
*/

	if (evnt == MU_MESAG)
	{
		switch(buff[0])
		{
			case WM_REDRAW :
				rd.g_x = buff[4]; rd.g_y = buff[5];
				rd.g_w = buff[6]; rd.g_h = buff[7];		
				GetWorkXYWH (user, &coord);

				v_hide_c (VdiHandle);	/* Virer la souris */
				wind_update (BEG_UPDATE); 	/* Bloquer les fonctions de la souris */

				/* Demande les coord. et dimensions du 1 rectangle de la liste */
				wind_get (buff[3], WF_FIRSTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);

				while (r.g_w && r.g_h)			/* Tant qu'il y a largeur ou hauteur... */
				{
					set_clip (1, &r); 	/* Clipping ON */
					if (rc_intersect (&rd, &r)) /* Si intersection des 2 zones */
					{
		  	    xy[0] = r.g_x;
    			  xy[1] = r.g_y;
		      	xy[2] = xy[0] + r.g_w - 1;
	  		    xy[3] = xy[1] + r.g_h - 1;

		  	    vsf_color(VdiHandle, BLACK);
						vr_recfl(VdiHandle, xy);
    	
					}
					/* Rectangle suivant */
					set_clip (0, &r); 	/* Clipping OFF */
					wind_get (buff[3], WF_NEXTXYWH, &r.g_x, &r.g_y, &r.g_w, &r.g_h);
				}
				wind_update(END_UPDATE);
				v_show_c (VdiHandle, 1); 			/* Rappeler la souris */

				break;

		}
	}	
}

void UserClavier (int kbd, int key)
{
		form_alert(1,"[1][User : Clavier][Ok]");
}

void UserSouris (int x, int y, int k, int nb)
{
	int pxy[4];
	GRECT r;
/*		form_alert(1,"[1][User : Souris][Ok]");*/

	GetWorkXYWH (user, &r);
	v_hide_c (VdiHandle);
	set_clip (1, &r); 	/* Clipping ON */
	/* Affichage d'un point sous le curseur de la souris */
  vsl_color (VdiHandle, WHITE);
	pxy[0] = x;
	pxy[1] = y;
	pxy[2] = x;
	pxy[3] = y;
  v_pline (VdiHandle, 2, pxy);
	set_clip (0, &r); 	/* Clipping OFF */
	v_show_c (VdiHandle,1);
	
}

/*----------------------------------------------------------------------*/
