/*************************************************************************
 * Fonctions de gestion des boutons UserDefs.                            *
 *                                                                       *
 * Dernire mise  jour : 29/02/1996                                     *
 *************************************************************************/

#include "WindGem.h"
#include "winproto.h"
#include "user.h"

#ifndef ACTIVATOR
#define ACTIVATOR			0x600
#endif
#define USR_INDICATOR	0x800
#define USR_ACTIVATOR	0x1800

/*-=< Section dclaration >=---------------------------------------------*/
static void coordonnees (void);
int cdecl under_button(PARMBLK *parmblock);
int cdecl check_button (PARMBLK *parmblock);
int cdecl popup_button (PARMBLK *parmblock);
static void set_objc(OBJECT *addr_obj, int cdecl (*code)(PARMBLK *parmblock));

/*-=< Gestion de l'affichage des boutons UserDefs >=---------------------*/

/*-----------------------------------------------------------------------*
 * Raccourcis clavier.                                                   *
 *-----------------------------------------------------------------------*/
int cdecl under_button(PARMBLK *parmblock)
{
	int flags, x, y, w, h;
	int test = 0, under_pos, tx, ty; 
	int back_color, lb_color, lh_color, txt_color = BLACK, xtype;
	int char_height, cell_height, dummy;
	int xy_clip[4], xy_bar[8], attributs[10];
	char chaine[60];
	char *string; 													 /* Pointeur texte pour BUTTON */
	char *key_short;
	char mes[60];

	xy_clip[0] = parmblock->pb_xc;
	xy_clip[1] = parmblock->pb_yc;
	xy_clip[2] = parmblock->pb_wc + xy_clip[0] - 1;
	xy_clip[3] = parmblock->pb_hc + xy_clip[1] - 1;
	vs_clip(Sys->VdiHandle, TRUE, xy_clip);

	flags = parmblock->pb_tree[parmblock->pb_obj].ob_flags;
	xtype = parmblock->pb_tree[parmblock->pb_obj].ob_type >> 8;
	string = (char *) parmblock->pb_parm;

	x = parmblock->pb_x;
	y = parmblock->pb_y;
	w = parmblock->pb_w;
	h = parmblock->pb_h;

	vqt_attributes(Sys->VdiHandle, attributs);
	if (xtype == SMALL_B)
		char_height = 4;	/* Petite fonte systeme. */
	else
		char_height = attributs[7];
	vst_height(Sys->VdiHandle, char_height, &dummy, &char_height, &dummy, &cell_height);

	/* CALCUL DU TEXTE */
	if ((key_short = strchr(string, '[')) != 0)
	{
		strnpcpy(chaine, string,key_short);
		vqt_extent(Sys->VdiHandle, chaine, xy_bar);
		under_pos = xy_bar[2];	 /* Position du souligne */
		key_short++;
		strcat(chaine,key_short);
	}
	else
		strcpy(chaine, string);

	vqt_extent(Sys->VdiHandle, chaine, xy_bar);
	tx = x + (w - xy_bar[2])/2;
	ty = y + (char_height + (h - cell_height)/2);

	if (xtype != SMALL_B)
	{
		x -= 3; y -= 3; w += 5; h += 5;
	}
	else
		ty++;
	if ((flags & USR_ACTIVATOR) != 0)
	{
		x -= 2; y -= 2; w += 4; h += 4;		                  /* Pour la 3 D ! */
	}
	xy_bar[0] = x; xy_bar[1] = y;
	xy_bar[2] = x + w; xy_bar[3] = y + h;
	
	vswr_mode(Sys->VdiHandle, MD_REPLACE);
	if ((parmblock->pb_currstate & OUTLINED) != 0)
	{
		vsf_color(Sys->VdiHandle, WHITE);		             /* Pour OUTLINED ...*/
		vsf_interior(Sys->VdiHandle, 1);
		v_bar(Sys->VdiHandle, xy_bar);		    /* ..dessin du fond de l'objet */
	}
	else
	{
		if (flags & DEFAULT)
			test++;			                            /* Un cadre pour "DEFAULT" */
		if (flags & EXIT)
			test++;			                            /* Un cadre pour "EXIT"    */
	}
	vsf_interior(Sys->VdiHandle ,0);
	vswr_mode(Sys->VdiHandle, MD_TRANS);

	vsf_color(Sys->VdiHandle, BLACK);		        /* Couleur des cadres	     */

	if ((parmblock->pb_currstate & OUTLINED) != 0 || test == 2)
	{
		v_bar(Sys->VdiHandle, xy_bar);		        /* Cadre Exterieur         */
		test--;
	}
	xy_bar[0] ++; xy_bar[1] ++;
	xy_bar[2] --; xy_bar[3] --;

	if (test > 0)
		v_bar(Sys->VdiHandle, xy_bar);		         /* Cadre Intermediaire    */
		xy_bar[0] ++;	xy_bar[1] ++;
		xy_bar[2] --;	xy_bar[3] --;

	if ((parmblock->pb_currstate & OUTLINED) == 0) /* Cadre Interieur      */
		v_bar(Sys->VdiHandle, xy_bar);
	xy_bar[0] ++;	xy_bar[1] ++;
	xy_bar[2] --;	xy_bar[3] --;

	flags &= USR_ACTIVATOR;
	if (flags)
	{
		back_color = Sys->color_3d1;
		if ((parmblock->pb_currstate & SELECTED) == 0)
		{
			lh_color = WHITE;
			lb_color = Sys->color_3d2;
			if (flags == USR_ACTIVATOR)
			{	/* ACTIVATOR et NORMAL */
				tx--; ty--;
			}
		}
		else
		{
			lh_color = BLACK;
			lb_color = WHITE;
			if (flags == USR_INDICATOR)
			{	/* INDICATOR et SELECTED */
				back_color = Sys->color_3d2;
				txt_color = WHITE;
				lb_color = Sys->color_3d1;
			}
		}
	}
	else if ((parmblock->pb_currstate & SELECTED) != 0)
	{
		txt_color = WHITE;
		back_color = BLACK;
	}
	else
	{
		back_color = WHITE;
	}
	vsf_interior(Sys->VdiHandle, 1);
	vsf_color(Sys->VdiHandle, back_color);
	v_bar(Sys->VdiHandle, xy_bar);	    /* Remplissage Interieur du bouton */

	if (flags)
	{
		xy_bar[0]++;
		xy_bar[4] = xy_bar[2];
		xy_bar[5] = xy_bar[1] +1;
		xy_bar[1] = xy_bar[3];
		vsl_color(Sys->VdiHandle, lb_color);
		v_pline(Sys->VdiHandle, 3, xy_bar);	  /* Trace ligne basse et droite */
		xy_bar[0]--; xy_bar[5]--;
		xy_bar[2] = xy_bar[0];
		xy_bar[3] = xy_bar[5];
		xy_bar[1]--;xy_bar[4]--;
		vsl_color(Sys->VdiHandle, lh_color);
		v_pline(Sys->VdiHandle, 3, xy_bar);	  /* Trace ligne gauche et haute */
	}
	vst_color(Sys->VdiHandle, txt_color);
	v_gtext(Sys->VdiHandle, tx, ty, chaine);
	if (/*(parmblock->pb_currstate & SELECTED) == 0 &&*/ key_short != 0)
	{
		vst_color(Sys->VdiHandle, RED);	          /* Couleur de soulignement */
		vst_effects(Sys->VdiHandle, 8);	          /* mode "Souligne"	       */
		v_gtext(Sys->VdiHandle, tx + under_pos, ty, " ");
		vst_effects(Sys->VdiHandle, 0);	          /* mode "Normal"           */
	}
	vswr_mode(Sys->VdiHandle, MD_REPLACE);
	vst_color(Sys->VdiHandle, BLACK);
	vst_height(Sys->VdiHandle, attributs[7], &dummy, &dummy, &dummy, &dummy);
	
/*	xy_clip[0] = parmblock->pb_xc;
	xy_clip[1] = parmblock->pb_yc;
	xy_clip[2] = parmblock->pb_wc + xy_clip[0] - 1;
	xy_clip[3] = parmblock->pb_hc + xy_clip[1] - 1;*/
	vs_clip(Sys->VdiHandle, FALSE, xy_clip);	
	
	return (parmblock->pb_currstate & DISABLED);
}

/*-----------------------------------------------------------------------*
 * Radio-boutons et Check-box.                                           *
 *-----------------------------------------------------------------------*/
int cdecl check_button (PARMBLK *parmblock)
{
	int tab[4], pxy[8], pox, poy, sel, dummy, obj, color[2];
	char *texte;
	MFDB nul = {0}, pic, msk;

	vst_font (Sys->VdiHandle, 1);
	fill_tab (tab, 4,	                                     /* Zone de clip */
							parmblock->pb_xc, parmblock->pb_yc,
							parmblock->pb_wc + parmblock->pb_xc - 1,
							parmblock->pb_hc + parmblock->pb_yc - 1);
	vs_clip (Sys->VdiHandle, TRUE, tab);	                      /* Clip ON */

	sel = parmblock->pb_currstate & SELECTED;

	if (parmblock->pb_tree[parmblock->pb_obj].ob_flags & RBUTTON)
		obj = sel ? RBS : RBN;
	else
		obj = sel ? BCS : BCN;

	pic.fd_addr = (void *) (Sys->AdrUser)[obj].ob_spec.iconblk->ib_pdata;
	msk.fd_addr = (void *) (Sys->AdrUser)[obj].ob_spec.iconblk->ib_pmask;
	pic.fd_w = msk.fd_w = 16;
	pic.fd_h = msk.fd_h = 16;
	pic.fd_wdwidth = msk.fd_wdwidth = 1;
	pic.fd_nplanes = msk.fd_nplanes = 1;
	pic.fd_stand = msk.fd_stand = ZERO;

	fill_tab (pxy, 8,
						ZERO, ZERO, pic.fd_w - 1, pic.fd_h - 1,
						parmblock->pb_x, parmblock->pb_y,
						parmblock->pb_x + pic.fd_w - 1,
						parmblock->pb_y + pic.fd_h - 1);

	color[0] = WHITE;
	color[1] = WHITE;
	vrt_cpyfm (Sys->VdiHandle, MD_TRANS, pxy, &msk, &nul, color);
	color[0] = BLACK;
	vrt_cpyfm (Sys->VdiHandle, MD_TRANS, pxy, &pic, &nul, color);

	texte = (char *)parmblock->pb_parm;	/* Rcuprer pointeur sur le texte */
	vst_color (Sys->VdiHandle, BLACK);
	vst_alignment (Sys->VdiHandle, 0, 5, &dummy, &dummy);
	vswr_mode (Sys->VdiHandle, MD_TRANS);		  /* Texte en mode transparent */
	vst_effects (Sys->VdiHandle, ZERO);		   /* Dsactiver tous les effets */
	pox = parmblock->pb_x + Sys->Hchar + Sys->Wchar;			/* Position en x */
	poy = parmblock->pb_y;								                /* et en y.      */
	if (Sys->Yres < 400)
		poy += 4;

	v_gtext (Sys->VdiHandle, pox, poy, texte);	          /* crire.       */
	vst_alignment (Sys->VdiHandle, 0, 0, &dummy, &dummy);	/* necessaire !! */
	vs_clip (Sys->VdiHandle, FALSE, tab);	                /* Clip OFF      */

	return (parmblock->pb_currstate & ~SELECTED);
}

/*-----------------------------------------------------------------------*
 * PopUp-boutons                                                         *
 *-----------------------------------------------------------------------*/
int cdecl popup_button (PARMBLK *parmblock)
{
	int tab[4], pxy[8], sel, dummy, obj, color[2], xy_bar[8];
	int flags, x, y, w, h, test = 0, tx, ty; 
	int back_color, lb_color, lh_color, txt_color = BLACK;
	char chaine[60];
	MFDB nul = {0}, pic, msk;

	vst_font (Sys->VdiHandle, 1);
	fill_tab (tab, 4,	                                     /* Zone de clip */
							parmblock->pb_xc, parmblock->pb_yc,
							parmblock->pb_wc + parmblock->pb_xc - 1,
							parmblock->pb_hc + parmblock->pb_yc - 1);
	vs_clip (Sys->VdiHandle, TRUE, tab);	                      /* Clip ON */

	sel = parmblock->pb_currstate & SELECTED;
	strcpy(chaine, (char *) parmblock->pb_parm);
	obj = sel ? CYCOFF : CYCON;

	/* Prparation affichage de l'icone */
	pic.fd_addr = (void *) (Sys->AdrUser)[obj].ob_spec.iconblk->ib_pdata;
	msk.fd_addr = (void *) (Sys->AdrUser)[obj].ob_spec.iconblk->ib_pmask;
	pic.fd_w = msk.fd_w = 16;
	pic.fd_h = msk.fd_h = 16;
	pic.fd_wdwidth = msk.fd_wdwidth = 1;
	pic.fd_nplanes = msk.fd_nplanes = 1;
	pic.fd_stand = msk.fd_stand = ZERO;

	/* Rcupre les attributs et les coordonnes de l'objet */
	flags = parmblock->pb_tree[parmblock->pb_obj].ob_flags;
	x = parmblock->pb_x;
	y = parmblock->pb_y;
	w = parmblock->pb_w;
	h = parmblock->pb_h;

	tx = x + 4;
	ty = y + Sys->Hchar - 3;

	if ((flags & USR_ACTIVATOR) != 0)
	{
		x -= 2; y -= 2; w += 4; h += 4;		                  /* Pour la 3 D ! */
	}
	xy_bar[0] = x; xy_bar[1] = y;
	xy_bar[2] = x + w - 17; xy_bar[3] = y + h - 1;

	if (flags & EXIT)
		test++;			   	                          /* Un cadre pour "EXIT"    */

	vsf_interior(Sys->VdiHandle ,0);
	vswr_mode(Sys->VdiHandle, MD_TRANS);
	vsf_color(Sys->VdiHandle, BLACK);		        /* Couleur des cadres	     */

	if (test > 0)
		v_bar(Sys->VdiHandle, xy_bar);		         /* Cadre Intermediaire    */
		xy_bar[0] ++;	xy_bar[1] ++;
		xy_bar[2] --;	xy_bar[3] --;

	xy_bar[0] ++;	xy_bar[1] ++;
	xy_bar[2] --;	xy_bar[3] --;

	flags &= USR_ACTIVATOR;
	if (flags)
	{
		back_color = Sys->color_3d1;
		if (! sel)
		{
			lh_color = WHITE;
			lb_color = Sys->color_3d2;
			if (flags == USR_ACTIVATOR)
			{	/* ACTIVATOR et NORMAL */
				tx--; ty--;
			}
		}
		else
		{
			lh_color = BLACK;
			lb_color = WHITE;
			if (flags == USR_INDICATOR)
			{	/* INDICATOR et SELECTED */
				back_color = Sys->color_3d2;
				txt_color = WHITE;
				lb_color = Sys->color_3d1;
			}
		}
	}
	else if (sel)
	{
		txt_color = WHITE;
		back_color = BLACK;
	}
	else
		back_color = WHITE;

	vsf_interior(Sys->VdiHandle, 1);
	vsf_color(Sys->VdiHandle, back_color);
	v_bar(Sys->VdiHandle, xy_bar);	    /* Remplissage Interieur du bouton */

	if (flags)
	{
		xy_bar[0]++;
		xy_bar[4] = xy_bar[2];
		xy_bar[5] = xy_bar[1] +1;
		xy_bar[1] = xy_bar[3];
		vsl_color(Sys->VdiHandle, lb_color);
		v_pline(Sys->VdiHandle, 3, xy_bar);	  /* Trace ligne basse et droite */
		xy_bar[0]--; xy_bar[5]--;
		xy_bar[2] = xy_bar[0];
		xy_bar[3] = xy_bar[5];
		xy_bar[1]--;xy_bar[4]--;
		vsl_color(Sys->VdiHandle, lh_color);
		v_pline(Sys->VdiHandle, 3, xy_bar);	  /* Trace ligne gauche et haute */
	}

	/* Affichage de l'icone */
	fill_tab (pxy, 8,
						ZERO, ZERO, pic.fd_w - 1, pic.fd_h - 1,
						parmblock->pb_x + parmblock->pb_w - 16, parmblock->pb_y,
						parmblock->pb_x + parmblock->pb_w - 16 + pic.fd_w - 1,
						parmblock->pb_y + pic.fd_h - 1);
						
	color[0] = WHITE;
	color[1] = WHITE;
	vrt_cpyfm (Sys->VdiHandle, MD_TRANS, pxy, &msk, &nul, color);
	color[0] = BLACK;
	vrt_cpyfm (Sys->VdiHandle, MD_TRANS, pxy, &pic, &nul, color);

	/* Affichage du texte */
	vst_color (Sys->VdiHandle, BLACK);
	vst_effects (Sys->VdiHandle, ZERO);
	if (Sys->Yres < 400)
		ty += 4;
	v_gtext (Sys->VdiHandle, tx, ty, chaine);
	vswr_mode(Sys->VdiHandle, MD_REPLACE);

	vs_clip (Sys->VdiHandle, FALSE, tab);

	return (parmblock->pb_currstate & ~SELECTED);
}

/*-=< Installation des boutons UserDefs >=-------------------------------*/

/*-----------------------------------------------------------------------*
 * Etablissement des boutons USERDEFS                                    *
 *-----------------------------------------------------------------------*/
void set_user(OBJECT *addr_tree)
{
	int index = 1;												             /* Objet Racine + 1 */
	OBJECT *addr_obj;

	do
	{
		addr_obj = &addr_tree[index];				 /* pointe sur l'objet a traiter */
		if ((addr_obj->ob_type & 0xff) == G_BUTTON)
		{
			switch (addr_obj->ob_type >> 8)
			{
				case POPUP_B :
					if (Sys->Yres < 400)
						addr_obj->ob_height += 8;
					addr_obj->ob_width += 16;
					set_objc(addr_obj, popup_button);
					break;
				case RADIO_B :
				case CHECK_B :
					if (Sys->Yres < 400)
						addr_obj->ob_height += 8;
					set_objc(addr_obj, check_button);
					break;
				case UNDER_B :
				case SMALL_B :
					set_objc(addr_obj, under_button);
					break;
			}
		}
		if (addr_obj->ob_flags & EDITABLE)
			strcpy((addr_obj->ob_spec.tedinfo)->te_ptext, "");
			
		index ++; 														/* prepare l'objet suivant ... */
																					/* ... sauf si dernier objet.  */
	} while((addr_obj->ob_flags & LASTOB) == 0);
}

/*-----------------------------------------------------------------------*
 * Gestion des objets USERDEFS                                           *
 *-----------------------------------------------------------------------*/
static void set_objc(OBJECT *addr_obj, int cdecl (*code)(PARMBLK *parmblock))
{
	int temp;
	register USERBLK *user;

	if ((user = (USERBLK *) malloc(sizeof(USERBLK))) != 0)
	{
		user->ub_code = code;
		addr_obj->ob_type = (addr_obj->ob_type & 0xff00) | G_USERDEF;
		user->ub_parm = (long) addr_obj->ob_spec.userblk;
		addr_obj->ob_spec.userblk = user;

/*-= Translation des flags 3D en ob_flags_11 et ob_flags_12. ===========-*/

		if ((temp = (addr_obj->ob_flags & ACTIVATOR)) != 0)
		{
			temp <<= 2;
			addr_obj->ob_flags = (addr_obj->ob_flags & ~ACTIVATOR) | temp;
		}
	}
}

/*-----------------------------------------------------------------------*/
