/************************************************************************
 *                                                                      *
 *  WindGem.H : Dfinitions utilises par les procdures WindGem.       *
 *                                                                      *
 ************************************************************************/

#ifndef __WINDGEM__
#define __WINDGEM__

/*-=< Section d'inclusion des fichiers d'entete necessaire >=------------*/
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <xgemfast.h>
#include <tosbind.h>
#include <atari.h>																				/* pour KEYTAB */
#include <malloc.h>
#include <macros.h>

/*************************************************************************
 * Definitions utiles.                                                   *
 *************************************************************************/
#define TRUE  	1
#define FALSE 	0
#define FAIL	 -1
#define MAX_LEN 256
#define NOT 		!
#define BLANK  -1
#define ZERO 		0

#define NODRAW  0							/* Pas de redessin du menu en fentre   */
#define REDRAW  1							/* Ordre de redessin du menu en fentre */

#define WNORM		0							/* Fenetre normale                         */
#define WMODAL	1							/* Fenetre modale                          */

#define SLIDINI 0							/* Initilisation du Slider                 */
#define SLIDAFF 1							/* Mise  jour                             */
#define SLIDEND 2							/* Fermeture du Slider                     */

/*************************************************************************
 * Structure systeme.                                                    *
 *************************************************************************/

typedef struct								/* Parametres systeme                      */
{
	int AppId;									/* Id application                          */
	int VdiHandle;							/* Handle Vdi                              */
	int mousex, mousey, mousek;	/* Informations souris                     */
	int key, kbd;								/* Gestion du clavier                      */
	int clik;										/* Clic souris                             */
	int color_3d1, color_3d2;		/* Couleur pour la 3D                      */
	int Wchar, Hchar;						/* Taille caractere                        */
	int Wcell, Hcell;						/* Taille boite contenant caractre        */
	OBJECT *AdrUser;						/* Objet contenant les objets Userdefs     */
	OBJECT *AdrIcone;						/* Objet contenant l'icones pour iconify   */
	OBJECT *AdrObjet;						/* Adresse objet courant                   */
	OBJECT *AdrAide;						/* Adresse objet aide en ligne             */
	OBJECT *AdrSlider;					/* Adresse objet Slider                    */
	int popMenu;								/* Numro de l'arbre d'objets pour popup   */
	void (*popup)(int event);		/* Fonction de gestion du popup menu       */
	int Xdesk,Ydesk,Wdesk,Hdesk;/* Coordonnees du bureau                   */
	void (*gereDesk)(int evnt);	/* fonction de gestion du bureau ou NULL   */
	int Xres, Yres;							/* Resolution de l'ecran                   */
	int Nplane;									/* Nombre de plans du bureau               */
	int baseline;								/* Premiere ligne de texte dans une fenetre*/
	int objet, pos;							/* Gestion des objets bloquants            */ 
	int new_objc, new_pos;			/* Nouvel objet, nouvelle position         */
	int lastMode;								/* Mode de la fenetre actuelle (MODAL ?!)  */
	int lastImg;								/* Dernier numero de fenetre graphique     */
	int lastTxt;								/* Dernier numero de fenetre texte		     */
	int lastUsr;								/* Dernier numero de fenetre utilisateur   */
	void (*menu)(int option);		/* Fonction de gestion du menu             */
	void (*desk)(int event);		/* Fonction de gestion du bureau           */
} System;

extern int VdiHandle;					/* Handle VDI pour l'utilisateur           */
extern int AppId;							/* ID application pour l'utilisateur       */
extern char AppPath[128];			/* Chemin de l'application                 */
extern int CurWindow;					/* Numro de l'objet WindGem courant       */

/*************************************************************************
 * Definition des touches.                                               *
 *************************************************************************/
#define HELP		0x6200
#define UNDO		0x6100
#define ARUP		0x4800
#define ARDN		0x5000
#define ARLF		0x4B00
#define ARRT		0x4D00
#define SH_ARUP 0x4838
#define SH_ARDN 0x5032
#define SH_ARLF 0x4B34
#define SH_ARRT 0x4D36
#define ESC			0x011B
#define RETURN	0x720D
#define ENTER		0x1C0D
#define HOME		0x4700
#define SH_HOME	0x4737

/*************************************************************************
 * Definition des nouveaux evenements Userdefs.                          *
 *************************************************************************/
#define EV_NO			 0		/* Pas d'evenement                               */
#define EV_OPEN		 8192	/* Ouverture Fenetre                             */
#define EV_CLOSE	-1		/* Fermeture Fenetre                             */
#define EV_HELP		-100	/* Touche Help                                   */
#define EV_UNDO		-101	/* Touche Undo                                   */
#define EV_ARUP		-102	/* Fleche Haut                                   */
#define EV_ARDN		-103	/* Fleche Bas                                    */
#define	EV_ARLF		-104	/* Fleche Gauche                                 */
#define EV_ARRT		-105	/* Fleche Droite                                 */
#define EV_SHARUP	-106	/*  Fleche Haut                                 */
#define EV_SHARDN	-107	/*  Fleche Bas                                  */
#define EV_SHARLF	-108	/*  Fleche Gauche                               */
#define EV_SHARRT	-109	/*  Fleche Droite                               */
#define EV_HOME		-110	/* Touche Home                                   */
#define EV_SHHOME	-111	/* Touche  Home                                 */
#define EV_ESC		-112	/* Touche Escape                                 */

/*************************************************************************
 * Messages d'erreurs.                                                                     *
 *************************************************************************/
#define WindOK				 0	/* Tout s'est bien passe                       */
#define WindErrNoRsc	-1	/* Fichier RSC manquant                        */

/*-----------------------------------------------------------------------*
 *-------------------- Dclaration des constantes -----------------------*
 * associes  la structure MachineInfo                                  *
 *-----------------------------------------------------------------------*/
typedef	struct
{
	int		Processor;				/* Processor type */
	long	Machine;					/* Machine type */
	int		Switch;						/* Mother board switch */
	long	Fdc;							/* Floppy Disk Controler */
	int		Keyboard;					/* Keyboard type */
	int		Language;					/* Current Language */
	long	Shifter;					/* Video circuit */
	int		Sound;						/* Sound System */
	int		Fpu;							/* Flotting Point Unit */
	int		Separator;				/* Date separator */
	int		Date;							/* date format */
	int		Time;							/* time format */
	/* Version extract from system's call */
	int		TosVersion;
	int		GemdosVersion;
	int		AesVersion; 
	/* Calculate from Cookie "MiNT" */
	int		MultiTosVersion;
	/* Prsence de Magic */
	int		Magic;
} MachineInfo;

extern MachineInfo Ordi;			/* Information systme                     */

#define	M68000		0x0000			/* Processeurs */
#define	M68010		0x000A
#define	M68020		0x0014
#define	M68030		0x001E

#define	ST				0x00000L		/* Machines */
#define	STE				0x10000L
#define	MSTE			0x10010L
#define	TT				0x20000L
#define	FALCON30	0x30000L

#define	KEYB_USA	0x0			/* Clavier */
#define	KEYB_D		0x1
#define	KEYB_F		0x2
#define	KEYB_GB		0x3
#define	KEYB_SP		0x4
#define	KEYB_I		0x5
#define	KEYB_CHD	0x7
#define	KEYB_CHF	0x8

#define	LG_USA		0x0			/* Langue */
#define	LG_D			0x1
#define	LG_F			0x2
#define	LG_GB			0x3
#define	LG_SP			0x4
#define	LG_I			0x5
#define	LG_CHD		0x7
#define	LG_CHF		0x8

#define	SHIFTER_ST		0x00000L		/* Circuit Video */
#define	SHIFTER_STE		0x10000L
#define	SHIFTER_TT		0x20000L
#define	VIDEL_FALCON	0x30000L

#define	MATRICE		0x08			/* Systeme sonore */
#define	DSP				0x04
#define	CODEC			0x02
#define	PSG				0x01

#define	NO_FPU				0			/* Copro. Math. */
#define	SFP004				1
#define	C68881_2			2
#define	C68881_2_SFP	3
#define	C68881				4
#define	C68881_SFP		5
#define	C68882				6
#define	C68882_SFP		7
#define	C68040				8
#define	C68040_SFP		9

#define	DATE_MJA	0			/* Format date */
#define	DATE_JMA	1
#define	DATE_AMJ	2
#define	DATE_AJM	3

#define	TIME_12		0			/* Format horaire */
#define	TIME_24		1

/*************************************************************************
 * Prototypes des Fonctions de Dialogue.                                 *
 *************************************************************************/

/*-=< Routines UserDefs >=-----------------------------------------------*/
void set_user(OBJECT *addr_tree);

/*-=< Gestion de l'application - GemSyst.c >=----------------------------*/
void AppInit(char *fic_rsc, int desk, void (*gereDesk)(int event), int menu, void (*gereMenu)(int event));
void AppExit(void);

/*-=< Gestion des formulaires - GemForm.c >=-----------------------------*/
void WindFormInit(int numObj, int mode, int inf_x, int inf_y, char *title, int edit, void (*fonct)(int evnt));
void WindOpen(int numObj);
void WindClose(int numObj);
void WindDelete(int numObj);
void ObjcUnselect(int arbre, int numObj);
void WindDraw(int arbre, int objet);
void SetValeur (int arbre, int objet, char *valeur);
char *GetValeur (int arbre, int objet);
void EffaceChamp (int arbre, int objet);
OBJECT *GetObject (int arbre);
void GetCoord (int numObj, GRECT *coord);
void GetWorkXYWH (int numObj, GRECT *coord);

/*-=< Diverses autres fonction de GemForm.c >=---------------------------*/
int GetHandle (int objet);
int GetObjet(void);
void *GetVar (int numObj);
int EventMulti (void);
int WindUserInit (int attrib, GRECT pos, char *title, void (*init)(), void (*exit)(), void (*message)(int evnt), void (*clavier)(int kbd, int key), void (*souris)(int x, int y, int k, int nb), void *var);

/*-=< Gestion des menus en fentre - GemMenu.c >=------------------------*/
void AjouteMenu (int numObj, int menu, int mode, void (*wmenu)(int opt));
void EnleveMenu (int numObj, int mode);
void wmenu_icheck (int arbre, int obj, int etat);
void AjouteToolBar (int numObj, int toolbar, int mode, void (*wtoolbar)(int opt));
void EnleveToolBar (int numObj, int mode);
void ToolBarUnselect(int arbre, int numObjc, int mode);
void ToolBarSelect(int arbre, int numObjc, int mode);

/*-=< Gestion de l'aide - GemHelp.c >=-----------------------------------*/
void AjouteAide (int arbre, int objet, char *txt);
void StGuide(char *fichierHyp, char *node);

/*-=< Gestion des Sliders - GemSlid.c >=---------------------------------*/
void SetSlider (int mode, int echelle, int position, char *text);

/*-=< Gestion des images - GemGrap.c >=----------------------------------*/
int WindGraphInit(MFDB *image, char *title, int x, int y, int w, int h, int nb_col, int max_x, int max_y);

/*-=< Gestion des popup - GemPopUp.c >=----------------------------------*/
void pop_up (int arbre, int obj, int pu);
void PopMenu(int numObj, void (*gerePopup)(int option));
void AjoutePopup (int arbre, int objet, int ArbrePopup);

/*-=< Gestion des textes - GemText.c >=----------------------------------*/
int WindTextInit (char *file, GRECT *Fpos, char *title);
int GetWindText (int numTxt, char **ligne[], int *nbcol);
void SetWindText (int numTxt, int nblig, int nbcol, char **ligne);

/*-=< Fonctions diverse : GemUtil.c >=-----------------------------------*/
#define INS_AVANT   -1
#define INS_APRES    1

void FormAlerte(int index);
void get_bkgr (int of_x, int of_y, int of_w, int of_h, MFDB *img);
void put_bkgr (int of_x, int of_y, int of_w, int of_h, MFDB *img);

OBJECT *copy_tree(OBJECT *tree);
int parent (OBJECT *adr, int object);
void set_clip (int clip_flag, GRECT *area);
void EnvoiMessage(int type, int handle, int message);
void EnvoiRedraw(int handle, int x, int y, int w, int h);
char *trim (char *str);
char *strnpcpy(char *dest, char *start, char *stop);
char *get_text (OBJECT *adr, int object);
void set_text (OBJECT *adr, int object, char *string);
long exist (char *name, int att);
char *path (char *chemin);
int selector (char *chemin, char *ext, char *file, char *title);
void extension (char *filename, char *ext);
void litdate (char *dat, unsigned int fdate);
void convdate (char *date, unsigned int *fdate);
char *strnpcpy(char *dest, char *start, char *stop);
char *strcomplete (char *chaine, int lng, char car, int sens);
char *strinsert (char *chaine, char *ch);
char *strcopy(char *res, char *chaine, int deb, int fin);
void cre_fichier(char *chemin, char *fic, char *fichier);
void GetCharSize (int *Wchar, int *Hchar);
void GetDeskXYWH (int *Xdesk, int *Ydesk, int *Wdesk, int *Hdesk);
void GetVideoRes (int *Xres, int *Yres, int *Nplane);

#endif

/*************************************************************************
 * Fin du module de declaration.                                         *
 *************************************************************************/
