/************************************************************************
 *                                                                      *
 *  WinProto.H : Dfinitions utilises par les procdures WindGem.       *
 *                                                                      *
 ************************************************************************/

#ifndef __WINPROTO__
#define __WINPROTO__

/*-=< Section d'inclusion des fichiers d'entete necessaire >=------------*/
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <xgemfast.h>
#include <tosbind.h>
#include <atari.h>																				/* pour KEYTAB */
#include <malloc.h>

/*************************************************************************
 * Types des fenetres.                                                   *
 *************************************************************************/
#define WTYPNONE -1						/* Pas de fenetre                          */
#define WTYPDESK 0						/* Type special pour la gestion            */
#define WTYPFORM 1						/* Fenetre de type WindForm                */
#define WTYPGRAP 2						/* Fenetre image                           */
#define WTYPTEXT 3						/* Fenetre texte                           */
#define WTYPUSER 4						/* Fenetre "User Defined"                  */

/*************************************************************************
 * Dfinition des structures utilises par WindGem.                      *
 *************************************************************************/
typedef struct aide 					/* Structure de l'aide pour les Boutons    */
{
	int	 numObj;								/* Numro de l'objet pour l'aide           */
	char *txt;									/* Texte de l'aide                         */
	struct aide *suiv;					/* Aide suivante                           */
} AIDE;

typedef struct popup					/* Structure pour objets popup             */
{
	int objet;									/* Objet auquel on associe le popup        */
	int popup;									/* Numro de l'arbre d'objet Popup         */
	struct popup *suiv;					/* Popup suivant                           */
} POPUP;

typedef struct								/* Fenetre formulaire                      */
{
	OBJECT	*adr_form;					/* adresse du formulaire                   */
	int			offset;							/* Dcalage x et y pour boite "OUTLINED".	 */
	int			edit;								/* 1er champ editable ou BLANK.            */
	int			edit_objc;					/* Objet ditable courant.                 */
	int			edit_pos;						/* Position courante du curseur d'dition. */
	AIDE	  *aide;							/* Liste des messages d'aide               */
	POPUP		*popup;							/* Liste des objets popup                  */
	void		(*fonct)(int evnt);	/* fonction de gestion de la fenetre ou \0 */
} WindForm;

typedef struct								/* Fenetre graphique                       */
{
	MFDB	*img;									/* Donnees image                           */
	int		nb_color;							/* Nombre de couleurs											 */
	int		full;									/* Flag pleine ouverture                   */
	int 	wtot;									/* Largeur maximale de l'image             */
	int		htot;									/* Hauteur maximale de l'image             */
	int		lin;									/* 1 ligne pour redraw                    */
	int 	col;									/* 1 colonne pour redraw                  */
} WindGraph;

typedef struct								/* Fenetre texte                           */
{
	int		type;									/* Type de la fentre : User ou Auto       */
	char	**lignes;							/* Contenu de la fentre                   */
	int		full;									/* Flag de pleine ouverture                */
	int		nbrel;								/* Nbre de lignes du texte                 */
	int		nbrec;								/* Nbre de colonnes du texte               */
	int		lin;									/* 1 ligne de texte                       */
	int		col;									/* 1 colonne de texte                     */
} WindText;

#define TYP_TEXT_AUTO 0				/* Le texte vient d'un fichier donn       */
#define TYP_TEXT_USER 1				/* Le texte est fourni par l'utilisateur   */

typedef struct								/* Fenetre Utilisateur                     */
{
	int full;										/* Flag pleine ouverture                   */
	void (*init)();							/* Fonction d'initilisation                */
	void (*exit)();							/* Fonction de terminaison                 */
															/* Fonction de redessin                    */
	void (*message)(int evnt, int buff[8]);
															/* Fonction de gestion du clavier          */
	void (*clavier)(int kbd, int key);
															/* Fonction de gestion de la souris        */
	void (*souris)(int x, int y, int k, int nb);
	void *var;									/* Permet  l'utilisateur de  stocker les  */
															/* var. dont il aura besoin (structure).   */
} WindUser;

typedef union cont						/* Definition du contenu d'une fenetre     */
{
	WindForm	*dialog;					/* Type boite de dialogue                  */
	WindGraph	*image;						/* Type fenetre image                      */
	WindText	*text;						/* Type fenetre texte                      */
	WindUser	*user;						/* Type fenetre utilisateur                */
} Cont;

typedef struct listeFen				/* Liste des fenetres                      */
{
	int		handle;								/* handle de la fenetre si ouverte         */
	int		numObj;								/* Numero de la fenetre                    */
	int 	type;									/* type de la fenetre                      */
	int		attrib;								/* Attributs de la fenetre                 */
	int		mode;									/* fenetre modale ou non                   */
	char	*w_title;							/* pointeur sur une chaine titre           */
	OBJECT *adr_wmenu;					/* Objet menu de la fentre ou NULL        */
	void	(*wmenu)(int opt);		/* Fonction de gestion du menu en fentre  */
	OBJECT *adr_wtoolbar;				/* Objet ToolBar de la fentre ou NULL     */
	void	(*wtoolbar)(int opt);	/* Fonction de gestion de la ToolBar       */
	int Xpos, Ypos, Wpos, Hpos;	/* Position courante											 */
	int		iconified;						/* Flag iconification                      */
	Cont 	cont;									/* Contenu de la fenetre                   */
} Wind;

#define BARMENU  1						/* Pour objets menu en fentre          */
#define BARTITLE 2

#define WINDFORM_NULL		(WindForm *)0
#define WINDGRAPH_NULL	(WindGraph *)0
#define WINDTEXT_NULL		(WindText *)0
#define WINDUSER_NULL		(WindUser *)0
#define WIND_NULL				(Wind *)0

#define FW_ATTRIB	(NAME|CLOSER|MOVER|SMALLER)
#define GW_ATTRIB (NAME|CLOSER|FULLER|MOVER|SMALLER|SIZER|UPARROW|DNARROW|VSLIDE|LFARROW|RTARROW|HSLIDE)
#define TW_ATTRIB (NAME|CLOSER|FULLER|MOVER|SMALLER|SIZER|UPARROW|DNARROW|VSLIDE|LFARROW|RTARROW|HSLIDE)

/*************************************************************************
 * Structure systeme.                                                    *
 *************************************************************************/
#define NBWIND	60						/* Nombre maximum de fenetres              */

/*************************************************************************
 * Valeur de definition des objets UserDefs.                             *
 *************************************************************************/
#define UNDER_B 18				/* Pour raccourcis clavier                     */
#define SMALL_B 22				/* Petite criture                             */
#define POPUP_B 24				/* Boutons PopUp                               */
#define RADIO_B 26				/* Radio-Boutons                               */
#define CHECK_B 28				/* Check-Box                                   */

/*************************************************************************
 * Dclaration des variables fournies par WindGem.                       *
 *************************************************************************/
extern OBJECT *AdrDesk;				/* Adresse du bureau                       */
extern OBJECT *AdrMenu;				/* Adresse du menu                         */
extern int buff[8];						/* Buffer evenement                        */
extern System *Sys;						/* Variable Systeme                        */
extern Wind LstFen[NBWIND];		/* Liste des fenetres (60 fenetres max.)   */
extern DTA dtabuffer;					/* Tampon DTA                              */

/*************************************************************************
 * Prototypes des Fonctions de Internes  WindGem.                       *
 *************************************************************************/
extern int IsPopup (Wind *wind, int objet);
void PopupNextValeur (int arbre, int obj, int popup);

extern void	RecaleWind(Wind *wind);
extern void AjouteListe(int type, int attrib, int numObj, int mode, char *title, GRECT pos, void *ptr_var);
extern Wind *ObjListe(int numObj);
extern Wind *TopListe(int handle);
extern void WindTextDo (Wind *wind, int evnt);
extern void WindTextSliders (Wind *wind);
extern void WindUserDo(Wind *wind, int evnt);
extern int stdkey (unsigned char *k);
extern int parent (OBJECT *adr, int object);
extern int m_title (OBJECT *adresse, int option);
extern void DrawIcone (int handle, GRECT *zone);
extern void AfficheAide (Wind *wind, int objet);
extern void menu_wind (Wind *wind, int ob);
extern void fill_tab (int *pxy, int n, ...);

#endif

/*************************************************************************
 * Fin du module de declaration.                                         *
 *************************************************************************/
