; ******************************************************************
;
; 	Programme de l'alarme de voiture par MicroControleur
;
;	Auteur	:	FAVARD Laurent
;	Fichier	:	ALARME.S
;	Date	:	3 Novembre 1993
;	Revision:	3 Mai 1994
;	Langage	:	Motorola 68705p3s
;	Assembleur:	Asm6805 ATARI ST
;	Version	:	1.2
;
;	Premier programme assembl sur Atari compatible ST avec
;	Asm6805.
; 
; ******************************************************************
;
;	Input Port A			Ouput Port B
;
;	P7 P6 P5 P4 P3 P2 P1 P0		P7 P6 P5 P4 P3 P2 P1 P0			
;	----------- -----------		-  -  -  Al Al Ok Scan Ok
;	  Rapides   Temporiss		 	 SR WR Clef
;
;

; Section Dfinition

Entree		equ	0			; Port en entre
Sortie		equ	$FF			; Port en sortie

Codekey		equ	$FA			; Code clef lectronique

Ok		equ	5			; Bits mode Ok (4+1)
Scan		equ	2			; Bits mode Surveillance

Al_Actif	equ	$1A			; Sortie Actives alarme
Al_Inactif	equ	0			; Sortie Repos
Sirene		equ	4			; Commande sirne
Warning		equ	3			; Commande warning

Rapide		equ	$F0			; MSB => Capteurs rapides
Repos		equ	0			; Aucun capteurs actifs

TimerOff	equ	$68			; Timer Arrt
TimerOn		equ	$70			; Timer en fonctionnement

Time7		equ	7
Time10		equ	10			; Temps en Secondes
Time12		equ	12
Time15		equ	15
Time20		equ	20
Time35		equ	35


; Section Programme

		TEXT
		
		Org	$100			; Dbut code en ROM

; Initialisation
		
Init:		lda	#Entree			; Port A,C en entre
		sta	DDRA			
		sta	DDRC

		lda	#Sortie			; Port B en sortie
		sta	DDRB
		lda	#Al_Inactif		; Valeur initiale
		sta	PortB			; du port B

		lda	#TimerOff		; Timer arrt
		sta	TCR

; Mode Attente: alarme inhibe par la clef
		
CleOk:		lda	#Ok			; Indiquer le mode
		sta	PortB			; Led Ok allume
		lda	PortC			; Lire le code
		cmp	#CodeKey		; Comparer
		beq	CleOk			; Code correct
		
; Quitter le mode Attente

		lda	#Time10			; Temporiser pour 10 Sec.
		sta	TDR	
		lda	#TimerOn		; Timer actif
		sta	TCR

Activation:	lda	TDR			; Lire valeur de TDR
		and	#$01			; Garder le bit 0
		sta	PortB			; switcher le bit OK
		brclr	7,TCR,Activation	; Temps non coul

		lda	#TimerOff		; Arrter le Timer
		sta	TCR		

; Faire clignoter les warnings pour signaler mode surveillance

		lda	#Time7			; Plus de clef: temporiser 7 Sec.
		sta	TDR	
		lda	#TimerOn		; Timer actif
		sta	TCR

		bset	Warning,PortB
Signaler:	brclr	7,TCR,Signaler		; Temps non coul

		lda	#TimerOff		; Arrter le Timer
		sta	TCR		
		bclr	Warning,PortB

; Mode Surveillance
		
		lda	#Scan			; Indiquer mode Surveillance
		sta	PortB			; Led Scan allume

Surveille:	lda	PortC			; Clef prsente ?
		cmp	#CodeKey
		beq	Extinction		; Oui

		lda	PortA			; Lire les capteurs
		cmp	#Repos			; Au repos ?
		bne	CapteurActif		; Non,...

		bra	Surveille		; Continuer surveillance

; Un capteur est actif
		
CapteurActif:	and	#Rapide			; Capteur actif, est ce un rapide
		cmp	#Repos
		bne	Declenche		; oui, dclencher immdiatement
		
		lda	#Time12			; non, temporiser
		sta	TDR
		lda	#TimerOn
		sta	TCR

; Capteur temporis activ: Attendre temporisation et vrifier
; en meme temps si un capteur rapide n'est pas dclench juste aprs

Decompte:	lda	TDR			; Lire valeur de TDR
		and	#$02			; Garder le bit 1
		sta	PortB			; switcher le bit Scan
		
		lda	PortA			; Lire capteurs
		and	#Rapide			; Si rapide actif
		cmp	#Repos
		bne	Contact			; dclencher immdiatement

		brclr	7,TCR,Decompte		; Temps non coul

Contact:	lda	#TimerOff
		sta	TCR
		
; Mode dclenchement alarme

Declenche:	lda	PortC			; Clef prsente
		cmp	#CodeKey
		beq	Extinction		; oui, Annuler...
		
		lda	#Al_Actif		; non, dclenchement
		sta	PortB
		
; Alarme active

		lda	#Time35			; Temporiser 35 Sec.
		sta	TDR
		lda	#TimerOn
		sta	TCR

Alhaut:		lda	PortC			; Annuler si clef prsente
		cmp	#CodeKey
		beq	Extinction		; Sinon vrifier Tempsbrclr	7,TCR,AlBas		; Temps non coul
		brclr	7,TCR,AlHaut		; Temps non coul

		lda	#TimerOff		; Timer art
		sta	TCR

; Alarme inactive
		
		bclr	Sirene,PortB		; Sirne inactive
		sta	PortB
		
		lda	#Time10			; Temporiser 10 Sec.
		sta	TDR
		lda	#TimerOn
		sta	TCR

AlBas:		lda	PortC			; Annuler si clef prsente
		cmp	#CodeKey
		beq	Extinction		; Sinon vrifier Temps
		brclr	7,TCR,AlBas		; Temps non coul

		lda	#TimerOff		; Timer art
		sta	TCR

; Redclencher


		jmp	Declenche		; Retour Mode Dclenchement

; Mode extinction
		
Extinction:	lda	#Al_Inactif		; Sorties relaches
		sta	PortB
		jmp	CleOk			; Retour Mode OK

; Section Data

		DATA

		Org	$784

MOR:		dcb	$A0			; Configure MOR register

		Org	$7FE
		
VectReset:	dcb	$01,$00			; Vecteur Reset
		
		END
						
		
				