* Umwandlungsroutinen  INTEGER <-> DOUBLE
GLOBL _wxcnv,_lxcnv,_xlcnv,_xucnv
XDEF  _wxcnv,_lxcnv,_xlcnv,_xucnv
;_uxcnv <-langsamer !
***************************************
* 		   INTEGER ZU DOUBLE		  *
* Input: D0 signed Integer      	  *
*        A0 Zeiger auf DOUBLE    	  *
* zerstrte Register: D0,D1,A0 (+6!)  *
* (fr Pure C angepat)				  *
* Genauigkeit: wie Double    		  *
* Speed: etwas  schneller (ca.15%) im *
*        Vergleich zum Original       *     
* Prinzip: Vergleiche FFP-Routinen    *
*    (auch gleiche Geschwindigkeit !) *
***************************************
_wxcnv:  ext.l   D0			   ;Vorzeichenerweiterung	
_lxcnv:  move.w  #$4000+29,D1  ;maximaler Exponent
         tst.l   D0            ;Integer null ?
         beq.s   XITORTN       ;Wenn dann gib Null zurck
         bpl.s   XITOPLS       ;Springe wenn positiver Integer
         move.w  #$C000+30,D1  ;Setze maximal negativen Exponenten
         neg.l   D0            ;Absolutwert
         bvs.s   XITORTI       ;Springe wenn maximaler negativer Wert
	     sub.b   #1,D1         ;fr dbmi
XITOPLS: cmp.l   #$00007FFF,D0 ;fr FAST-SHIFT auf 68000-er
         bhi.s   XITOLP        ;Leider nicht mglich
         swap.w  D0            ; D0 << 16
         sub.b   #16,D1        ;Korrektur da schon 16 mal geschoben
XITOLP:  add.l   D0,D0         ;Mantisse normalisieren
         dbmi    D1,XITOLP     ;LOOP bis normalisiert
XITORTI: move.w  D1,(A0)+
		 move.l  D0,(A0)+	   ;ohne Offset -> 8 Taktzyklen Gewinn		
		 clr.l   (A0)	       ;Wert kopieren 
		 rts
XITORTN:clr.w (A0)+  
		clr.l (A0)+		   ;ohne Offset -> 8 Taktzyklen Gewinn	
		clr.l (A0)		   ;Null zurck	
		rts                

***************************************
*  UNSIGNED INTEGER ZU DOUBLE		  *
* Input: D0 signed Integer      	  *
*        A0 Zeiger auf DOUBLE    	  *
* zerstrte Register: D0,D1,A0 (+6 !) *
* (fr Pure C angepat)				  *
* Genauigkeit:Exponent: wie Double    *
*             Mantisse: es wird nur   *
*             oberes Langwort berck- *
*             sichtigt (32 Bit ->ent- *
*             spricht ca. 10 Stellen) *
* Speed: im Durchschnitt langsamer !  *
* Prinzip: Vergleiche FFP-Routinen    *
*    (auch gleiche Geschwindigkeit !) *
***************************************
;_uxcnv: move.w  #$4000+30,D1  ;maximaler Exponent
         tst.l   D0            ;Integer null ?
         beq.s   XITORTN       ;Wenn dann gib Null zurck
         bmi.s   UXITORTI      ;Springe wenn schon normalisiert
	     subq.b  #1,D1         ;fr dbmi
		 cmp.l  #$00007FFF,D0  ;fr FAST-SHIFT 
         bhi.s   XITOLP        ;Leider nicht mglich
         swap.w  D0            ; D0 << 16
         sub.b   #16,D1        ;Korrektur da schon 16 mal geschoben
UXITOLP: add.l   D0,D0         ;Mantisse normalisieren
         dbmi    D1,UXITOLP    ;LOOP bis normalisiert
UXITORTI:move.w  D1,(A0)+
		 move.l  D0,(A0)+      ;ohne Offset -> 8 Taktzyklen Gewinn	
		 clr.l   (A0)	       ;Wert kopieren 
		 rts
***************************************
*  			DOUBLE -> INTEGER (long)  *
* Input:   A0 Zeiger auf DOUBLE    	  *
* Output:  D0						  *
* zerstrte Register: D1,A0 (+2 !)    *
* (fr Pure C angepat)				  *
* Genauigkeit: wie Double    		  *
* aber ebenfalls Anpassung bei Be-	  *
* reichsberschreitungen			  *
* Speed: 1.5 ... 2 mal schneller im   *
*         Vergleich zum Original      *     
* Prinzip: Vergleiche FFP-Routinen    *
*    (auch gleiche Geschwindigkeit !) *
***************************************
_xlcnv: move.w    (A0)+,D1       ;Vorzeichen + Exponent             8
        bmi.s     XFPIMI         ;Springe wenn negativ              8/10
        beq.s     XFPIRTN        ;ist wohl null                     8/10
        sub.w     #$3FFF,D1      ;EXPONENT-1 TO BINARY              8
        bmi.s     XFPIRTN        ;falls Double kleiner  eins   		8/10
        sub.w     #31,D1         ;? berlauf ?                      8
        bpl.s     XFPIOVP        ;Springe wenn zu gro              8/10
        neg.w     D1             ;fr SHIFT vorbereiten             4
        move.l   (A0),D0		 ;Mantisse laden					16
        lsr.l     D1,D0          ;zu  Integer	                    8-70
	    rts                      ;				                    16

XFPIRTN:clr.l D0				 ;Null zurck
		rts  

* negativer Wert
XFPIMI: sub.w   #$BFFF,D1     	 ;Exponent-1 und Vorzeichen weg		    8
        bmi.s    XFPIRTN         ;falls Double kleiner  eins            8/10
        sub.w     #31,D1         ;? berlauf ?                          8
        bpl.s     XFPICHM        ;Minusberlauf					        8/10
        neg.w     D1             ;fr SHIFT vorbereiten 	            4
        move.l   (A0),D0		 ;Mantisse laden						12
        lsr.l     D1,D0          ;zurechtshiften		                8-70
        neg.l     D0             ;... und negativ                       6
        rts                      ;						                16
 
* negativer Maximalwert
XFPICHM:clr.l    D0	             ;D0 lschen
        bset.l    #31,D0         ;maximal negativen Wert zurck
        rts                      

* positiver berlauf
XFPIOVP:moveq     #-1,D0         
        lsr.l     #1,D0          ;maximalen positiven Wert zurck
        rts                      

***************************************
*  	DOUBLE -> UNSIGNED INTEGER		  *
* Input:   A0 Zeiger auf DOUBLE    	  *
* Output:  D0						  *
* zerstrte Register: D1,A0 (+2 !)    *
* (fr Pure C angepat)				  *
* Genauigkeit: wie Double    		  *
* aber ebenfalls Anpassung bei Be-	  *
* reichsberschreitungen			  *
* Speed:  ~ 1.2  mal schneller im  	  *
*         Vergleich zum Original      *     
* Prinzip: Vergleiche FFP-Routinen    *
*    (auch gleiche Geschwindigkeit !) *
***************************************
_xucnv: move.w    (A0)+,D1       ;Vorzeichen + Exponent             8
        bmi.s     XFPIRTN        ;Null wenn negativ              	8/10
        beq.s     XFPIRTN        ;ist wohl null                     8/10
        sub.w     #$3FFE,D1      ;EXPONENT TO BINARY  	            8
        bmi.s     XFPIRTN        ;falls Double kleiner  eins   		8/10
        sub.w     #33,D1         ;? berlauf ?                      8
        bpl.s     UXFPIOVP       ;Springe wenn zu gro              8/10
        addq.w    #1,D1          ;Korrektur		                    8
        neg.w     D1             ;fr SHIFT vorbereiten             4
        move.l   (A0),D0		 ;Mantisse laden					16
        lsr.l     D1,D0          ;zu  Integer	                    8-70
	    rts                      ;				                    16

* positiver berlauf
UXFPIOVP:moveq     #-1,D0         
         rts                      
