/*
   DU_LIB v2
   Gem Window Management & Dialog Library For Lattice C
   1994, by Craig Graham.
   Based on the DU_LIBv1 Library for HiSoft Basic.

   --->Library Header File
*/

#ifndef __DU_LIB__
#define __DU_LIB__

#ifndef __USE_GNU
#include <aes.h>
#include <vdi.h>
#else
#include <aesbind.h>
#include <vdibind.h>
#endif

#include <xacc.h>

#define max_windows			50
#define max_dialogs			100

#define ob_sizeof			24

/* Winx stuff */
#define WF_RETURN			1
#define WF_WINX				22360
#define	WF_WINXCFG			22361
#define WF_OWNER			20
#define WF_BOTTOM			25
#define WM_BOTTOMED			33
/*CLA custom messages*/
#define WM_CUSTOM_REDRAW	100

#ifndef WF_BEVENT
#define WF_BEVENT 			24
#define WM_UNTOPPED 		30
#define WM_ONTOP 			31
#define AP_TERM 			50
#endif

#ifndef DESK
#define DESK				0
#endif

/*ICFS & AES 5 stuff */
#ifndef WF_ICONIFY 
#define WF_ICONIFY				26
#define WF_UNICONIFY			27
#define WF_UNICONIFYXYWH		28
#define WM_ICONIFY				34
#define WM_UNICONIFY			35
#define WM_ALLICONIFY			36
#define SMALLER					0x4000

/* Drag'n'Drop */
#define AP_DRAGDROP			63
#define	DD_OK				0
#define DD_NAK				1
#define DD_EXT				2
#define DD_LEN				3
#define DD_TRASH			4
#define DD_PRINTER			5
#define DD_CLIPBOARD		6
#define DD_TIMEOUT			4000		/* timeout in milliseconds */
#define DD_NUMEXTS			8
#define DD_EXTSIZE			32L
#define DD_NAMEMAX			128		/* max size of a drag&drop item name */
#define DD_HDRMAX			(8+DD_NAMEMAX)	/* max length of a drag&drop header */
#endif

/*Object flag masks*/
#define mask_none			0
#define mask_selectable		1
#define mask_default		2
#define mask_exit			4
#define mask_editable		8
#define mask_rbutton		16
#define mask_lastob			32
#define mask_touchexit		64
#define mask_hidetree		128
#define mask_indirect		256
/*Object state masks*/
#define mask_normal			0
#define mask_selected		1
#define mask_crossed		2
#define mask_checked		4
#define mask_disabled		8
#define mask_outlined		16
#define mask_shadowed		32

/*Scrollable List Widget constants*/
#define scroll_widget			0
#define scroll_drag_background	1
#define scroll_drag				2
#define scroll_text_area		3
#define scroll_up				4
#define scroll_down				5

/* Booleans */
#define TRUE	1
#define FALSE	0

typedef enum {
	wrm_scale,
	wrm_window,
	wrm_abs
} Dmode;

typedef enum{
	DIAL_NO_CLOSE,
	DIAL_ROLLUP,
	DIAL_FIXED,
	DIAL_WIDGET_BAR
} dialog_type;

typedef enum {
	wt_null,
	wt_drawing,
	wt_static_menu,
	wt_alert,
	wt_menu_bar,
	wt_cro,
	wt_dialog,
	wt_iconified_drawing
} Wtype;

typedef short event;

/* type for a callback function (pointer to a function) */
typedef short (*CallBack)(void);

/*details of a scrolling text list*/
typedef struct {
	char *(*texts);	/*list contents*/
	short current;	/*current highlighted option*/
	short number;	/*number of options in list*/
	short display;	/*number of lines to display*/
	short start;	/*base for currently displayed lines*/
} scroll_text;

/* list of events returned for objects in a dialog */
typedef struct ml {
	struct ml* next;			/*next in list*/
	short object;				/*object that this event is for*/
	event this_event;			/*event code (single click)*/
	event this_devent;			/*event code (double click)*/
	CallBack callback;			/*callback function for this object (single click)*/
	CallBack dcallback;			/*callback function for this object (double click)*/
	CallBack redraw;			/*custom redraw function for this object*/
	scroll_text stext;			/*scrolling list details (if applicable)*/
	short popup_form;			/*form for icon_popups containing other related icons*/
	short popup_icon_current;	/*current object number of icon to display*/
} Elist;

/* structure containing details of a window */
typedef struct {
	Dmode redraw_mode;
	Wtype window_type;
	short the_dialog;
} Wdetails;

typedef enum { c_arrow,c_cross,c_circle,c_smiley,c_mover,c_arc,c_pointer } mouse_shape;

extern short junk;
extern short messB[40];
extern short timeB[40];
extern short AESid;							/* Our AES id */
extern short x_handle;
extern Wdetails windows[max_windows];
extern Elist *event_value[max_dialogs];
extern mouse_shape wm_mouse_shape;
extern short wm_inv[512],wm_outv[200];
extern short menu; 							/*The menubar form number*/
extern short last_opened_window;			/*The handle of the last handle opened by activate_dialog*/
extern short d_parm;						/*Any parameter which has to be returned by a dialog (eg slider pos.)*/
extern short this_ob,this_dialog;			/*The current object handle when any callback routine is called*/
extern short udx,udy,udw,udh,icon_x,icon_y;
extern short cr_wind_handle;				/*Custom redraw - window containing object */
extern GRECT cr_clip;						/*Custom redraw object locations*/
extern GRECT cr_dclip;						/*Custom redraw object display clip rectangle*/
extern short cr_mx,cr_my;					/*Custom redraw/callback relative mouse location inside object*/
extern short scrn_x,scrn_y,scrn_w,scrn_h;	/*screen - dimensions*/
extern short scrn_planes;					/*screen - number of bitplanes*/
extern short wmi_total_buffering;
extern short scroll_selection;				/*index in text to string when a scroll text has been clicked on */
extern CallBack XaccTextHandler;			/*handler routine for Xacc2 text transfers*/
extern short click_count;					/*number of mouse click events from last evnt_multi()*/

/*
  =============================
   The DU_LIB Library Routines
  =============================
*/
  
/*DULIB.C*/
short enviroment_initialise(void);	/* setup the system prior to use */
short close_down();					/* Shutdown a program, closing all windows and removing the menu bar */
short install_menu(short m);			/* Install a GEM menu bar at the top of the screen */
event WaitEvent(void);				/* The Main event loop */

/*PROC_MSG.C*/
event process_message(short mb[]);						/* Process a GEM message */
int redraw_window(short wind_handle);

/*EVENTS.C*/
event Get_object_event(short dialog, short ob);				/*Get an event code for an object in a dialog (single click)*/
short Set_object_event(short dialog, short ob, event e);	/* Set an event code for an object (single click)*/
event Get_object_devent(short dialog, short ob);			/*Get an event code for an object in a dialog (double click)*/
short Set_object_devent(short dialog, short ob, event e);	/* Set an event code for an object (double click)*/
CallBack Get_object_callback(short dialog, short ob);		/* Get the address of a callback routine for an object (single click)*/
short Set_object_callback(short dialog, short ob, CallBack c);	/* Set the address of a callback routine for an object (single click)*/
CallBack Get_object_dcallback(short dialog, short ob);		/* Get the address of a callback routine for an object (double click)*/
short Set_object_dcallback(short dialog, short ob, CallBack c);	/* Set the address of a callback routine for an object (double click)*/
CallBack Get_object_redraw(short dialog, short ob);
short Set_object_redraw(short dialog, short ob, CallBack c);
short find_event(short dialog,short ob, Elist *ee[1]);		/* Find an object's callback/event entry */

/*WINDIAL.C*/
short set_window_title(short h, char *a);					/* Set the title of a window */
short activate_dialog(short dialog, char *n, dialog_type t);/* Activate a windowed dialog */
short display_dial(short wind_handle);						/* Display the dialog associated with window wind_handle */
short custom_display_dial(short wind_handle);				/* Display only the custom redraw objects associated with a window */
int intersection(short x1,short y1,short w1,short h1,short x2,short y2,short w2,short h2,short *x,short *y,short *w,short *h);
short close_dialog(short e_wind);							/* Close a dialog window */
short dialog_update(short d);								/* Update a dialog (if it is open)*/
short process_win_dial(short wh,short x,short y);
short Radio_b(OBJECT *t, short object);
short GetParent(OBJECT *t,short object);
short Get_ob_info(OBJECT *dialog,short ob,short *otype,short *oflags,short *ostate);
short set_dialog_text(short dialog, short object, char* t);	/* Sets a text object in a dialog to a given string*/
int redraw_custom(short wind_handle);
short custom_display_object(short wind_handle, short ob);	/* Display only a specified custom redraw object associated with a window */

/*MESSAGES.C*/
int update_window(short wind_handle);						/* Update a window by sending ourselves a wm_redraw message via GEM.*/
int custom_update_window(short wind_handle);				/* Update a window by sending a WM_CUSTOM_REDRAW message to only redraw custom objects */
int send_redraw(short sx, short sy,short sw,short sh);		/* Send redraw messages to all our windows for the area (sx,sy,sw,sh)*/
int I_send_message(short wind_handle, short msg);			/* Send ourselves a control message via GEM.*/
short Set_XaccTextHandler(CallBack c);						/* Set a callback routine to handle any Xacc2 ACC_TEXT messages */

/*POPUP.C*/
short form_popup(short dialog,short object, short n, short current, char* t[1]);	/*Form an <n> entry pop-up menu for <object> in <dialog>, and return a selection from it.*/

/*S_LIST.C*/
short Set_scroll_list(short dialog, short ob, short event, char *text_list[], short nt, short nd);
short Change_scroll_list(short dialog, short ob, char *text_list[], short nt);
short SelectFromScrollList(void);
short DisplayScrollList(void);
short Get_object_scroll(short dialog, short object, char *(*t[]), short *start, short *nt, short *nd, short *current);
short ScrollListDrag(void);
short ScrollListDown(void);
short ScrollListUp(void);

/*IPOPUP.C*/
void Set_icon_popup(short dialog, short object, short p_form);
short Get_icon_popup(short dialog, short object);
short do_icon_popup(void);
short display_p_icon(void);

#endif
