/*
  DU_LIB v2
  Gem Window Management & Dialog Library For Lattice C
  1994, by Craig Graham.
  
  Based on the DU_LIBv1 Library for HiSoft Basic.
*/

/*
  Popup Menu Handler
*/

#include "dulib.h"
#include <string.h>

/*Form an <n> entry pop-up menu for <object> in <dialog>, and return a selection from it.*/
short form_popup(short dialog,short object, short n, short current, char *t[])
{
	static OBJECT popup[25];
	static TEDINFO texts[20];
	OBJECT* l;
	OBJECT* lt;
	TEDINFO* ltb;
	short mb,a,max_w,f;
	GRECT oxywh;
	short rtn;
	
	do { graf_mkstate(&junk,&junk,&mb,&junk); } while (mb!=0);
	
	rsrc_gaddr(0,dialog,&l);
	objc_xywh(l,object,&oxywh);

	if (n==0)
	{
		rtn=0;
	} else {
		popup->ob_next=-1;					/*Create a popup menu structure*/
		popup->ob_head=1;
		popup->ob_tail=n+2;
		popup->ob_flags=0;
		popup->ob_state=mask_shadowed;
		popup->ob_type=G_BOX;
#ifdef __USE_GNU
		popup->ob_spec=(unsigned long)70128;
#else
		popup->ob_spec=(OBJECT*)70128;
#endif

		max_w=1;
		lt=popup; ltb=texts;
		
		for(f=0; f<(n+1); f++)
		{
			a=strlen(t[f]);
			if (a>max_w) { max_w=a; }
		}
	
		for(f=1;f<(n+1);f++)
		{
			lt++;
			lt->ob_next=f+1;
			lt->ob_head=-1;
			lt->ob_tail=-1;
			lt->ob_flags= mask_selectable | mask_exit | mask_touchexit | mask_rbutton;
			if (f==current)									/*Highlight the current selection*/
			{
				lt->ob_state=mask_selected;
				lt->ob_flags=mask_selectable | mask_exit | mask_touchexit | mask_rbutton | mask_default;
			} else {
				lt->ob_state=0;
			}
			lt->ob_type=G_TEXT;
			lt->ob_x=5;
			lt->ob_y=f*16+10;
			lt->ob_width=oxywh.g_w-10;
			lt->ob_height=16;
#ifdef __USE_GNU
			lt->ob_spec=(unsigned long)ltb;
#else
			lt->ob_spec=(OBJECT*)ltb;
#endif
			ltb->te_ptext=t[f];
			ltb->te_ptmplt=t[f];
			ltb->te_pvalid=t[f];
			ltb->te_font=3;
			ltb->te_just=0;
			ltb->te_color=4464;
			ltb->te_tmplen=ltb->te_txtlen=strlen(t[f])+1;
			ltb++;
		}

		lt++;
		lt->ob_type=G_BOX;
		lt->ob_next=0;
		lt->ob_head=n+2;
		lt->ob_tail=n+2;
		lt->ob_flags=0;
		lt->ob_state=0;
		lt->ob_type=G_BOX;
		lt->ob_x=0;
		lt->ob_y=0;
		lt->ob_width=oxywh.g_w;
		lt->ob_height=18;
#ifdef __USE_GNU
		lt->ob_spec=(unsigned long)70129;
#else
		lt->ob_spec=(OBJECT*)70129;
#endif

		lt++;
	
		lt->ob_next=n+1;			/*Current Selection Text*/
		lt->ob_head=-1;
		lt->ob_tail=-1;
		lt->ob_flags=0;
		lt->ob_state=0;
		lt->ob_type=G_TEXT;
		lt->ob_x=5;
		lt->ob_y=1;
		lt->ob_width=oxywh.g_w-10;
		lt->ob_height=16;
#ifdef __USE_GNU
		lt->ob_spec=(unsigned long)ltb;
#else
		lt->ob_spec=(OBJECT*)ltb;
#endif
		ltb->te_ptext=t[0];
		ltb->te_ptmplt=t[0];
		ltb->te_pvalid=t[0];
		ltb->te_font=3;
		ltb->te_just=0;
		ltb->te_color=4208;
		ltb->te_tmplen=ltb->te_txtlen=strlen(t[current])+1;

		if (oxywh.g_x+oxywh.g_w+5>scrn_x+scrn_w) { oxywh.g_x=scrn_x+scrn_w-oxywh.g_w-5; }
		if (oxywh.g_y+(n+1)*16+24>scrn_y+scrn_h) { oxywh.g_y=scrn_y+scrn_h-((n+1)*16+24); }
		if (oxywh.g_w<max_w*8+10) { oxywh.g_w=max_w*8+10; }

		popup->ob_x=oxywh.g_x;
		popup->ob_y=oxywh.g_y;
		popup->ob_width=oxywh.g_w;
		popup->ob_height=(n+1)*16+18;

		objc_draw(popup,0,5,oxywh.g_x,oxywh.g_y,oxywh.g_w+5,(n+1)*16+20);
		form_dial(FMD_START,0,0,0,0,oxywh.g_x,oxywh.g_y,oxywh.g_w+5,(n+1)*16+20);
		rtn=form_do(popup,0);
		form_dial(FMD_FINISH,0,0,0,0,oxywh.g_x,oxywh.g_y,oxywh.g_w+5,(n+1)*16+20);
	}
	return rtn;
}
