/*
   DU_LIB v2
   Gem Window Management & Dialog Library For Lattice C
   1994, by Craig Graham.
   Based on the DU_LIBv1 Library for HiSoft Basic.
*/

/*
	Scrolling List Support
	NOTE: Scrolling list objects MUST be cut-pasted from the library dialog.
	Major use is made of callback functions to implement the scrolling
	list widget.....
*/

#include "dulib.h"

/*
	Set a scrolling list initially.
	wait_event returns selection number in the global scroll_selection
*/
short Set_scroll_list(short dialog, short ob, short e, char *text_list[], short nt, short nd)
{
	OBJECT* l;
	OBJECT* lo;
	Elist *n;
	short f,ml,ln;
	
	n=(Elist*)0;

	ml=0;
	for (f=0; f<nt; f++)
	{
		ln=strlen(text_list[f]);
		if (ln>ml) ml=ln;
	}
	ml++;

	Set_object_callback(dialog, (short)(ob+scroll_up), &ScrollListUp);
	Set_object_callback(dialog, (short)(ob+scroll_down), &ScrollListDown);
	Set_object_callback(dialog, (short)(ob+scroll_drag), &ScrollListDrag);
	Set_object_callback(dialog, (short)(ob+scroll_text_area), &SelectFromScrollList);
	Set_object_redraw(dialog, (short)(ob+scroll_text_area), &DisplayScrollList);
	Set_object_event(dialog, (short)(ob+scroll_text_area), e);
	Set_object_event(dialog, ob, e);
	rsrc_gaddr(0,dialog,&l);
	lo=l+ob;
	lo->ob_height=nd*16+8;
	lo->ob_width=ml*8+21;
	lo=l+(ob+scroll_text_area);
	lo->ob_height=nd*16+6;
	lo->ob_width=ml*8;
	lo=l+(ob+scroll_drag_background);
	lo->ob_height=nd*16-33;
	lo=l+(ob+scroll_down);
	lo->ob_y=nd*16-11;

	if (find_event(dialog,ob,&n))
	{
		n->stext.texts=text_list;
		n->stext.number=nt;
		n->stext.display=nd;
		n->stext.current=0;
		n->stext.start=0;
		return 1;
	}else{
		form_alert(1,"[1][ ERROR: unable to create scroll list. ][ OOPS ]");
		return 0;
	}
}

/*
	Change a scrolling lists contents.
*/
short Change_scroll_list(short dialog, short ob, char *text_list[], short nt)
{
	OBJECT *l;
	Elist *n;
	short ln,ml,f;
	
	n=(Elist*)0;

	if (find_event(dialog,ob,&n))
	{
		n->stext.texts=text_list;
		n->stext.number=nt;
		n->stext.current=0;
		n->stext.start=0;
		
		rsrc_gaddr(0,dialog,&l);
		l=l+(ob+scroll_drag);
		l->ob_y=1;

		dialog_update(dialog);

		return 1;
	}else{
		form_alert(1,"[1][ ERROR: try to change scroll | text on non-event object. ][ OOPS ]");
		return 0;
	}
}

short SelectFromScrollList(void)
{
	OBJECT *l;
	short my,y,mb;
	short start,nd,nt,ne,s,sel;
	char *(*a);
	Elist *n;

	n=(Elist*)0;

	if (find_event(this_dialog,(short)(this_ob-scroll_text_area),&n))
	{
		if (Get_object_scroll(this_dialog,(short)(this_ob-scroll_text_area),&a,&start,&nt,&nd,&junk))
		{
			graf_mkstate(&junk,&my,&junk,&junk);
			y=my-cr_clip.g_y-10;

			sel=(y*nd)/(cr_clip.g_h-8);
			if (sel<0) sel=0;
	
			ne=start+nd;
			if (ne>nt) ne=nt;
	
			rsrc_gaddr(0,this_dialog,&l);
			Get_ob_info(l,this_ob,&junk,&junk,&s);
			graf_mouse(M_OFF,NULL);
			n->stext.current=sel+start;
		
			DisplayScrollList();

			do
			{
				graf_mkstate(&junk,&junk,&mb,&junk);
			} while (mb!=0);
			
			graf_mouse(M_ON,NULL);
			scroll_selection=sel+start;
			return n->this_event;
		}else{
			form_alert(1,"[1][ ERROR: cannot select scroll text. ][ OOPS ]");
			return 0;
		}
	}else{
		form_alert(1,"[1][ ERROR: cannot select scroll text. ][ OOPS ]");
		return 0;
	}
}

short ScrollListDrag(void)
{
	OBJECT *l;
	OBJECT *lo;
	Elist *obj;
	char *(*t);
	short bh,start,ostart,current,nt,nd,my,mb,y;
	float s;
	
	if (Get_object_scroll(this_dialog,(short)(this_ob-scroll_drag),&t,&start,&nt,&nd,&current))
	{
		find_event(this_dialog,(short)(this_ob-scroll_drag),&obj);

		rsrc_gaddr(0,this_dialog,&l);
		lo=l+(this_ob-scroll_drag+scroll_drag_background);

		bh=lo->ob_height;
		lo=l+this_ob;
		bh=bh-(lo->ob_height);
		
		if (nt>nd)
		{
			s=(float)(((float)(bh-2))/((float)(nt-nd)));
	
			this_ob=this_ob-scroll_drag+scroll_text_area;
#ifndef __USE_GNU
			objc_xywh(l,this_ob,&cr_clip);
#else
			objc_offset(l,this_ob,&x,&y);
			cr_clip.g_x=x;
			cr_clip.g_y=y;
			cr_clip.g_w=(l+this_ob)->ob_width;
			cr_clip.g_h=(l+this_ob)->ob_height;
#endif
			ostart=start;
			graf_mkstate(&junk,&my,&mb,&junk);
			my=my/s;
			for (; mb==1; graf_mkstate(&junk,&y,&mb,&junk))
			{
				y=y/s;
				if (my!=y)
				{
					start=start-(my-y);
					if (start<0) start=0;
					if ((start+nd)>nt) start=nt-nd;
					if (start!=ostart)
					{
						my=y;
						obj->stext.start=start;
						lo->ob_y=s*start+1;
						graf_mouse(M_OFF,NULL);
						objc_draw(l,this_ob,2,scrn_x,scrn_y,scrn_x+scrn_w,scrn_y+scrn_h);
						objc_draw(l,(short)(this_ob-scroll_text_area+scroll_drag_background),2,scrn_x,scrn_y,scrn_w,scrn_h);
						DisplayScrollList();
						graf_mouse(M_ON,NULL);
						ostart=start;
					}
				}
			}
			return 1;
		} else {
			return 0;
		}
	} else {
		return 0;
	}
}

short ScrollListUp(void)
{
	OBJECT *l;
	OBJECT *lo;
	Elist *obj;
	char *(*t);
	short bh,start,ostart,current,nt,nd,mb;
	float s;
	
	if (Get_object_scroll(this_dialog,(short)(this_ob-scroll_up),&t,&start,&nt,&nd,&current))
	{
		find_event(this_dialog,(short)(this_ob-scroll_up),&obj);

		rsrc_gaddr(0,this_dialog,&l);
		lo=l+(this_ob-scroll_up+scroll_drag_background);

		bh=lo->ob_height;
		lo=l+(this_ob-scroll_up+scroll_drag);
		bh=bh-(lo->ob_height);
		
		if (nt>nd)
		{
			s=(float)(((float)(bh-2))/((float)(nt-nd)));
	
			this_ob=this_ob-scroll_up+scroll_text_area;
#ifndef __USE_GNU
			objc_xywh(l,this_ob,&cr_clip);
#else
			objc_offset(l,this_ob,&x,&y);
			cr_clip.g_x=x;
			cr_clip.g_y=y;
			cr_clip.g_w=(l+this_ob)->ob_width;
			cr_clip.g_h=(l+this_ob)->ob_height;
#endif
			ostart=start;
			mb=1;
			for (; (mb==1); graf_mkstate(&junk,&junk,&mb,&junk))
			{
				if (start>0)
				{
					start=start-1;
					if (start!=ostart)
					{
						obj->stext.start=start;
						lo->ob_y=s*start+1;
						graf_mouse(M_OFF,NULL);
						objc_draw(l,this_ob,2,scrn_x,scrn_y,scrn_x+scrn_w,scrn_y+scrn_h);
						objc_draw(l,(short)(this_ob-scroll_text_area+scroll_drag_background),2,scrn_x,scrn_y,scrn_w,scrn_h);
						DisplayScrollList();
						graf_mouse(M_ON,NULL);
						ostart=start;
					}
				}
			}
			return 1;
		} else {
			return 0;
		}
	} else {
		return 0;
	}
}

short ScrollListDown(void)
{
	OBJECT *l;
	OBJECT *lo;
	Elist *obj;
	char *(*t);
	short bh,start,ostart,current,nt,nd,mb;
	float s;
	
	if (Get_object_scroll(this_dialog,(short)(this_ob-scroll_down),&t,&start,&nt,&nd,&current))
	{
		find_event(this_dialog,(short)(this_ob-scroll_down),&obj);

		rsrc_gaddr(0,this_dialog,&l);
		lo=l+(this_ob-scroll_down+scroll_drag_background);

		bh=lo->ob_height;
		lo=l+(this_ob-scroll_down+scroll_drag);
		bh=bh-(lo->ob_height);
		
		if (nt>nd)
		{
			s=(float)(((float)(bh-2))/((float)(nt-nd)));
	
			this_ob=this_ob-scroll_down+scroll_text_area;
#ifndef __USE_GNU
			objc_xywh(l,this_ob,&cr_clip);
#else
			objc_offset(l,this_ob,&x,&y);
			cr_clip.g_x=x;
			cr_clip.g_y=y;
			cr_clip.g_w=(l+this_ob)->ob_width;
			cr_clip.g_h=(l+this_ob)->ob_height;
#endif
			ostart=start;
			mb=1;
			for (; (mb==1); graf_mkstate(&junk,&junk,&mb,&junk))
			{
				if ((start+nd)<nt)
				{
					start=start+1;
					if (start!=ostart)
					{
						obj->stext.start=start;
						lo->ob_y=s*start+1;
						graf_mouse(M_OFF,NULL);
						objc_draw(l,this_ob,2,scrn_x,scrn_y,scrn_x+scrn_w,scrn_y+scrn_h);
						objc_draw(l,(short)(this_ob-scroll_text_area+scroll_drag_background),2,scrn_x,scrn_y,scrn_w,scrn_h);
						DisplayScrollList();
						graf_mouse(M_ON,NULL);
						ostart=start;
					}
				}
			}
			return 1;
		} else {
			return 0;
		}
	} else {
		return 0;
	}
}

short DisplayScrollList(void)
{
	char *(*dt);
	Elist *n;
	short tl,ne,start,nt,nd,current;

	n=(Elist*)0;

	if (find_event(this_dialog,this_ob,&n))
	{
		Get_object_scroll(this_dialog,(short)(this_ob-scroll_text_area),&dt,&start,&nt,&nd,&current);
		ne=start+nd;
		if (ne>nt) ne=nt;
		vst_color(x_handle,1); vst_point(x_handle,10,&junk,&junk,&junk,&junk);
		vst_rotation(x_handle,0); vst_alignment(x_handle,0,0,wm_inv,wm_outv);
		
		tl=cr_clip.g_y+18;
		
		for(ne=start; ne<start+nd; ne++)
		{
			if (ne==current)
			{
				vst_effects(x_handle,1);
				v_gtext(x_handle,cr_clip.g_x+5,tl,dt[ne]);
				vst_effects(x_handle,0);
			}else{
				v_gtext(x_handle,cr_clip.g_x+5,tl,dt[ne]);
			}
			tl=tl+16;
		}
		return 1;
	} else {
		return 0;
	}
}


short Get_object_scroll(short dialog, short ob, char *(*t[]), short *start, short *nt, short *nd, short *current)
{
	Elist *n;

	n=(Elist*)0;

	if (find_event(dialog,ob,&n))
	{
		if (n->stext.texts)
		{
			*start=n->stext.start;
			*nt=n->stext.number;
			*nd=n->stext.display;
			*current=n->stext.current;
			*t=n->stext.texts;
			return 1;
		} else {
			return 0;
		}
	} else {
		return 0;
	}
}
