/* XACC.H - Routinen zur Behandlung des XACC-Protokolls
            nach der Spezifikation vom 28. November 1992,
            erweitert um Mag!X 2.0 (ap_version == 0x399)
	(c) 1993 Harald Sommerfeldt @ KI im Maus-Netz
	E-Mail:  Harald_Sommerfeldt@ki.maus.de */

/*[13/9/94]
	English comments by Craig Graham
*/

/* XACC - Definitions */
#define ACC_ID		0x400
#define ACC_OPEN	0x401
#define ACC_CLOSE	0x402
#define ACC_ACC		0x403
#define ACC_EXIT	0x404
#define ACC_ACK		0x500
#define ACC_TEXT	0x501
#define ACC_KEY		0x502
#define ACC_META	0x503
#define ACC_IMG		0x504


#define MAX_XACC 20					/* Maximum number of Xacc compliant programs supported at once */

extern struct xaccs {				/* This structure contains a list available Xacc clients in the system */
	short	id;							/* ap_id */
	unsigned  groups;					/* XACC-Group-Wort */
	const char *name;					/* XACC-Name */
} xaccs[MAX_XACC];


/* bereitgestellte XACC - Routinen */
short	xacc_init( short menu_id, const char *name, short sizeofname, unsigned groups );
void	xacc_exit( void );
void	*xacc_malloc( long amount );
short	xacc_message( const short *msgbuf );
short	xacc_send( short dest_id, short message, void *addr, long length, short last );
short	xacc_ack( short dest_id, short ok );

/* shorterne XACC - Routinen, werden normalerweise nicht bentigt */
short	xacc_id( short dest_id, short message );
short	xacc_remid( short id, const short *msgbuf );
short	xacc_killid( short id );
short	xacc_cookie( long cookie, long *value );

