/*******************************************************************************
	"Easy Gem" library Copyright (c)1995 by		Christophe BOYANIQUE
																29 rue de la Rpublique
																37230 FONDETTES
																FRANCE
												FidoNet:		2:320/107.16
												NeST:			90:800/1.16
												AtariNet:	51:901/1.16
										*small* mail at:	cb@spia.freenix.fr
********************************************************************************
	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License, or any later version.
	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.
	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	675 Mass Ave, Cambridge, MA 02139, USA.
********************************************************************************

********************************************************************************
	TABULATION: 3 CARACTERES
*******************************************************************************/

#include		"EG_MAIN.H"

/*******************************************************************************
	This function can be called to handle GEM event
*******************************************************************************/
void _gereAes()
{
	int	flag=0;

	if	( (glb.aes.timer1==0) && (glb.aes.timer2==0) )	/*	This is to construct a correct*/
		glb.aes.timer1=1000;								/*	event mask:							*/
	if (glb.aes.flag&MU_M1)								/*	MESAG+BUTTON+KEYBD+TIMER are	*/
		flag|=MU_M1;									/*	always used !						*/
	if (glb.aes.flag&MU_M2)
		flag|=MU_M2;
	flag|=MU_MESAG|MU_BUTTON|MU_KEYBD|MU_TIMER;

	iglb.aes.evnt	=	evnt_multi	(	flag,0x102,3,0,
										glb.aes.f1,glb.aes.x1,glb.aes.y1,glb.aes.w1,glb.aes.h1,
										glb.aes.f2,glb.aes.x2,glb.aes.y2,glb.aes.w2,glb.aes.h2,
										iglb.aes.buf,glb.aes.timer1,glb.aes.timer2,
										&iglb.aes.mx,&iglb.aes.my,&iglb.aes.mk,&iglb.aes.kst,&iglb.aes.key,&iglb.aes.nmbClic
									);

	if (iglb.aes.evnt & MU_MESAG)	{	_handleEvntMesag();	iglb.aes.evnt&=~MU_MESAG;	}
	if (iglb.aes.evnt & MU_BUTTON){	_handleEvntButton();	iglb.aes.evnt&=~MU_BUTTON;	}
	if (iglb.aes.evnt & MU_KEYBD)	{	_handleEvntKeybd();	iglb.aes.evnt&=~MU_KEYBD;	}
	if (iglb.aes.evnt & MU_M1)		{	_handleEvntBox1();	iglb.aes.evnt&=~MU_M1;		}
	if (iglb.aes.evnt & MU_M2)		{	_handleEvntBox2();	iglb.aes.evnt&=~MU_M2;		}
	if (iglb.aes.evnt & MU_TIMER)	{	_handleEvntTimer();	iglb.aes.evnt&=~MU_TIMER;	}
}


/*******************************************************************************
	Handle keyboard events
*******************************************************************************/
void _handleEvntKeybd()
{
	int		child,type,bios,mask,i;
	int		ha,dum;
	OBJECT	*tree;
	char		*p;

	iglb.aes.std=_StdKey(iglb.aes.kst,iglb.aes.key);
	if (glb.aes.type!=0)
	{
		if ((iglb.aes.std&0xFF)==K_HELP)
		{
			iglb.aes.std=0;
			if (!iglb.aes.fmod)
				_Aide();
		}

		if (glb.aes.menu!=-1)
		{
			tree=glb.rsc.head.trindex[glb.aes.menu];
			child=0;
			do
			{
				child+=1;
				if ( iglb.aes.std!=0 && (child<10 || child>15) )
				{
					type=tree[child].ob_type>>8;
					if ( tree[child].ob_type-type==G_STRING && !(tree[child].ob_state&DISABLED) )
					{
						mask=0;
						if (type==0)
						{
							p=_obGetStr(tree,child);
							p+=strlen(p)-4L;
							for (i=0;i<3;i++,p++)
							{
								if (*p==1)
									mask|=KF_SHIFT;
								else if (*p==7)
									mask|=KF_ALT;
								else if (*p=='^')
									mask|=KF_CTRL;
								else if ( *p==9 || *p==13 || *p==27 || (*p>='A' && *p<='Z') )
									type=*p;
							}
						}
						else
						{
							if (tree[child].ob_state&0x2000)		mask+=KF_ALT;
							if (tree[child].ob_state&0x4000)		mask+=KF_CTRL;
							if (tree[child].ob_state&0x8000)		mask+=KF_SHIFT;
						}
						if (toupper(iglb.aes.std&0xFF)==type)
						{
							bios=iglb.aes.std & (KF_ALT|KF_CTRL|KF_SHIFT);
							if (bios&KF_RSH)
								bios|=KF_LSH;
							if (bios&KF_LSH)
								bios|=KF_RSH;
							if (bios==mask)
							{
								_gereMenu(0,child);
								iglb.aes.std=0;
							}
						}
					}
				}
			} while ( !(tree[child].ob_flags & LASTOB) );
		}
	}

	if (iglb.aes.std!=0)
	{
		wind_get(0,WF_TOP,&ha,&dum,&dum,&dum);
		i=_winFindWin(ha);
		if (i!=-1)
			if (W[i].smallflag==0)
				if (W[i].keybd!=0)
				{
					_makeform(i);
					(*W[i].keybd)(i,iglb.aes.std);
				}
	}
	if (iglb.aes.std!=0 && glb.func.gKey!=0 && glb.aes.flag&MU_KEYBD)
		(glb.func.gKey)(iglb.aes.std);
}


/*******************************************************************************
	Handle button event
*******************************************************************************/
void _handleEvntButton()
{
	int		ha,i;

	ha=wind_find(iglb.aes.mx,iglb.aes.my);

	if (ha==0)
	{
		if (glb.aes.type!=0)
			if (glb.aes.flag&MU_BUTTON)
				_clicDesk(iglb.aes.mx,iglb.aes.my,iglb.aes.mk,iglb.aes.nmbClic);
	}
	else
	{
		i=_winFindWin(ha);
		if (i!=-1)
			_clicWin(i,iglb.aes.mx,iglb.aes.my,iglb.aes.mk,iglb.aes.nmbClic);
	}
}


/*******************************************************************************
	Handle Box 1 event
*******************************************************************************/
void _handleEvntBox1()
{
	if (glb.func.gBox1!=0)
		(*glb.func.gBox1)();
}

/*******************************************************************************
	Handle Box 2 event
*******************************************************************************/
void _handleEvntBox2()
{
	if (glb.func.gBox2!=0)
		(*glb.func.gBox2)();
}


/*******************************************************************************
	Handle mesag event
*******************************************************************************/
void _handleEvntMesag()
{
	int		i;

	switch (iglb.aes.buf[0])
	{
		case	AC_OPEN:
			_AcOpen();
			break;
		case	AC_CLOSE:
			_AcClose();
			break;
		case	AP_TERM:
			glb.div.Exit=2;
			break;
		case	MN_SELECTED:
			_gereMenu(iglb.aes.buf[3],iglb.aes.buf[4]);
			break;
		case	WM_REDRAW:
			i=_winFindWin(iglb.aes.buf[3]);
			_redraw(i,iglb.aes.buf[4],iglb.aes.buf[5],iglb.aes.buf[6],iglb.aes.buf[7]);
			break;
		case	WM_TOPPED:
			i=_winFindWin(iglb.aes.buf[3]);
			if (iglb.aes.fmod && i!=iglb.aes.wmod)
				i=iglb.aes.wmod;
			_top(i);
			_ontop(i);
			break;
		case	WM_UNTOPPED:
			i=_winFindWin(iglb.aes.buf[3]);
			_untop(i);
			break;
		case	WM_ONTOP:
			i=_winFindWin(iglb.aes.buf[3]);
			_ontop(i);
			break;
		default:
			if ( glb.func.gMesag!=0 && glb.aes.flag&MU_MESAG )
				(*glb.func.gMesag)(iglb.aes.buf);
			break;
	}
}


/*******************************************************************************
	Handle timer event
*******************************************************************************/
void _handleEvntTimer()
{
	if ( (glb.func.gTimer!=0) && (glb.aes.flag&MU_TIMER) )
		(*glb.func.gTimer)();
}


/*******************************************************************************
	[Uns]install Menu bar
*******************************************************************************/
void _menuBar(int obj,int flag)
{
	if ( (glb.aes.type!=0) && (obj!=-1) )
	{
		if (obj&FLAGS15)
			menu_bar(iglb.rsc.head.trindex[obj&~FLAGS15],flag);
		else
			menu_bar(glb.rsc.head.trindex[obj],flag);
	}
}


/*******************************************************************************
	Handle menu event
*******************************************************************************/
void _gereMenu(int titre,int option)
{
	OBJECT		*tree;

	tree=glb.rsc.head.trindex[glb.aes.menu];
	if (glb.func.gMenu!=0)
		(*glb.func.gMenu)(option);
	if (titre!=0)
		menu_tnormal(tree,titre,1);
}


/*******************************************************************************
	Handle AC_OPEN mesag
*******************************************************************************/
void _AcOpen()
{
	int		t;
	window	win;

	_initDesk();
	if (!glb.div.AccOp)
		glb.div.AccOp=1;
	for (t=0;t<glb.opt.Win_Num;t++)
		if (W[t].handle==-2)
		{
			win=W[t];
			W[t].handle=-1;
			_winOpen(&win);
		}
	if (glb.func.gAcOpen!=0)
		(*glb.func.gAcOpen)();
}


/*******************************************************************************
	Handle AC_CLOSE event
*******************************************************************************/
void _AcClose()
{
	int		x;

	for (x=0;x<glb.opt.Win_Num;x++)
		if (W[x].handle>0)
		{
			wind_close(W[x].handle);
			wind_delete(W[x].handle);
			W[x].handle=-2;
		}
	if (glb.func.gAcClose!=0)
		(*glb.func.gAcClose)();
	_exitDesk();
	_clearAesBuffer();
}


/*******************************************************************************
	clic on desktop: not terminated... sorry... not begun !! 8-((
*******************************************************************************/
void _clicDesk(int mx,int my,int mk,int nmb)
{
	int	i=0,pop;
	int	x,y;

	if ( mk==-1 || glb.aes.desk==-1 )
		i=1;
	else
	{
		if ( objc_find(glb.rsc.head.trindex[glb.aes.desk],ROOT,MAX_DEPTH,mx,my)==ROOT )
			i=1;
		else if (glb.func.gClicD!=0)
			i=2;
	}
	if ( (i==1) && (nmb>1) )
	{
		x=mx-iglb.rsc.head.trindex[PLIB]->ob_width/2;
		y=my-iglb.rsc.head.trindex[PLIB]->ob_height/2;
		wind_update(BEG_MCTRL);
		pop=_popUp(iglb.rsc.head.trindex[PLIB],x,y);
		wind_update(END_MCTRL);
		switch	(pop)
		{
				case	PLIBINF:
					_winForm(FINF|FLAGS15,iglb.rsc.head.frstr[WINF],"EGlib","_INFO",-1,-1,WIC_INF,0);
					break;
				case	PLIBMEM:
					_myInitForm(FMEM,FMEMSYS);
					_myInitForm(FMEM,FMEMLEN);
					_myInitForm(FMEM,FMEMFRE);
					_winForm(FMEM|FLAGS15,iglb.rsc.head.frstr[WMEM],"EGlib","_MEMORY",-1,-1,WIC_MEM,0);
					break;
				case	PLIBFNT:
					_winForm(FFNT|FLAGS15,iglb.rsc.head.frstr[WFNT],"EGlib","_FONT",-1,-1,WIC_FNT,0);
					break;
				case	PLIBOPT:
					_winForm(FOPT|FLAGS15,iglb.rsc.head.frstr[WOPT],"EGlib","_OPTION",-1,-1,WIC_OPT,0);
					break;
				case	PLIBICN:
					_winForm(FICN|FLAGS15,iglb.rsc.head.frstr[WICN],"EGlib","_ICON",-1,-1,WIC_OPT,0);
					break;
				case	PLIBSYS:
					_winForm(FSYS|FLAGS15,iglb.rsc.head.frstr[WSYS],"EGlib","_SYSINFO",-1,-1,WIC_SYS,0);
					break;
				case	PLIBCNF:
					_saveINI();
					break;
				case	PLIBHLP:
					_Aide();
					break;
		}
	}
	else if (i==2)
		(*glb.func.gClicD)(mx,my,mk);
}


/*******************************************************************************
	Transform a scan+ascii code to standard code
*******************************************************************************/
int _StdKey(int shift,int key)
{
	KEYTAB	*kt;
	int		scan,asc;
	int		std=0;

	asc=key&0xFF;
	scan=key>>8;

	if ( (asc!=0) && (scan==0) && (shift==0) )			/*	case of TOS intern	*/
		std=asc;						/*	handling with ALT+ascii or TSR like ACCENT	*/
	else
	{
		if (shift&0x01)			std|=KF_RSH;
		if (shift&0x02)			std|=KF_LSH;
		if (shift&0x04)			std|=KF_CTRL;
		if (shift&0x08)			std|=KF_ALT;
		if (Kbshift(-1)&0x10)	std|=KF_CAPS;

		switch	(scan)
		{
			case	0x3b:		case	0x54:		std|=K_F1|KF_FUNC;		break;
			case	0x3c:		case	0x55:		std|=K_F2|KF_FUNC;		break;
			case	0x3d:		case	0x56:		std|=K_F3|KF_FUNC;		break;
			case	0x3e:		case	0x57:		std|=K_F4|KF_FUNC;		break;
			case	0x3f:		case	0x58:		std|=K_F5|KF_FUNC;		break;
			case	0x40:		case	0x59:		std|=K_F6|KF_FUNC;		break;
			case	0x41:		case	0x5A:		std|=K_F7|KF_FUNC;		break;
			case	0x42:		case	0x5B:		std|=K_F8|KF_FUNC;		break;
			case	0x43:		case	0x5C:		std|=K_F9|KF_FUNC;		break;
			case	0x44:		case	0x5D:		std|=K_F10|KF_FUNC;		break;
			case	0x62:		std|=K_HELP|KF_FUNC;							break;
			case	0x61:		std|=K_UNDO|KF_FUNC;							break;
			case	0x52:		std|=K_INS|KF_FUNC;							break;
			case	0x77:
			case	0x47:		std|=K_CLRHOME|KF_FUNC;						break;
			case	0x48:		std|=K_UP|KF_FUNC;							break;
			case	0x50:		std|=K_DOWN|KF_FUNC;							break;
			case	0x74:
			case	0x4D:		std|=K_RIGHT|KF_FUNC;						break;
			case	0x73:
			case	0x4B:		std|=K_LEFT|KF_FUNC;							break;
		}
		if ( ((scan>=0x63)&&(scan<=0x71)) || (scan==0x4A) || (scan==0x4E) || (scan==0x72) ) std|=KF_NUM;
		if ((std&0xFF)==0)
		{
			kt=Keytbl((void *)-1,(void *)-1,(void *)-1);
			if ( (std&KF_ALT) && (asc!=0) )
				std|=asc;
			else if (std&KF_SHIFT)
				std|=(int)(kt->shift[scan])&0xFF;
			else if (std&KF_CAPS)
				std|=(int)(kt->capslock[scan])&0xFF;
			else
				std|=(int)(kt->unshift[scan])&0xFF;
		}
		switch	(std&0xFF)
		{
			case	K_BS:
			case	K_TAB:
			case	K_RETURN:
			case	K_ESC:
				case	K_DEL:
				std|=KF_FUNC;
				break;
		}
	}
	return std;
}


/*******************************************************************************
	Clear the AES buffer
*******************************************************************************/
void _clearAesBuffer(void)
{
	int		buf[8];

	buf[0]=-1;
	buf[1]=glb.aes.id;
	buf[2]=0;
	buf[3]=0;
	buf[4]=0;
	buf[5]=0;
	buf[6]=0;
	buf[7]=0;
	appl_write(glb.aes.id,16,buf);
	do
	{
		evnt_mesag(iglb.aes.buf);
		if (iglb.aes.buf[0]!=-1)
			_handleEvntMesag();
	} while (iglb.aes.buf[0]!=-1);
}


/*******************************************************************************
	Change the mouse form
*******************************************************************************/
void _mousework()
{
	iglb.div.mouse+=1;
	if (iglb.div.mouse==8)
		iglb.div.mouse=0;
	graf_mouse(USER_DEF,&iglb.aes.s[iglb.div.mouse]);
}
