/*******************************************************************************
	"Easy Gem" library Copyright (c)1995 by		Christophe BOYANIQUE
																29 rue de la Rpublique
																37230 FONDETTES
																FRANCE
												FidoNet:		2:320/107.16
												NeST:			90:800/1.16
												AtariNet:	51:901/1.16
										*small* mail at:	cb@spia.freenix.fr
********************************************************************************
	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License, or any later version.
	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.
	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	675 Mass Ave, Cambridge, MA 02139, USA.
********************************************************************************

	All the init & exit functions

********************************************************************************
	TABULATION: 3 CARACTERES
*******************************************************************************/


#include		"EG_MAIN.H"

/*******************************************************************************
	Init Memory Manager
*******************************************************************************/
int _initMem()
{
	long		len,Max,sys;

	glb.opt.Win_Num+=8;							/*	intern lib windows		*/
	glb.opt.Mem_Num+=100;						/*	for color icon				*/
	glb.opt.Mem_Num+=glb.opt.Win_Num*2;		/*	for windows					*/

	len=glb.opt.Mem_Len;
	sys=_freeSys();
	Max=(long)Malloc(-1L);
	glb.opt.Mem_Len=0;

	if (Max>=100L*1024L)				/*	EGlib need at least 100 Kb !	*/
	{
		if (len<0)
		{
			if ( (-len>0) && (-len<100L) )
				glb.opt.Mem_Len=sys+(long)( (double)sys*(double)len/(double)100 );
			else
				glb.opt.Mem_Len=sys+len;
		}
		else
		{
			if ( (len>0) && (len<100L) )
				glb.opt.Mem_Len=(long)( (double)sys*(double)len/(double)100 );
			else
				glb.opt.Mem_Len=len;
		}
		Max=min(Max,sys);
		glb.opt.Mem_Len=max(100L*1024L,glb.opt.Mem_Len);
		glb.opt.Mem_Len=min(Max,glb.opt.Mem_Len);
		if ( _pAlloc(glb.opt.Mem_Num,glb.opt.Mem_Len) == OK_MEM )
			return TRUE;
	}
	strcpy(glb.div.log,"Alloc error: Memory manager\n");
	_reportLog();
	return FALSE;
}


/*******************************************************************************
	Init AES
*******************************************************************************/
void _initAes()
{
	iglb.aes.top	=	0;
	glb.aes.id		=	appl_init();
	glb.aes.ver		=	Gem_pb.global[0];
	glb.aes.multi	=	(Gem_pb.global[1]==-1) ? TRUE : FALSE;
	glb.div.AccOp	=	glb.aes.type;

	if (! ((glb.aes.type==1)&&(glb.aes.multi==FALSE)) )
		menu_register(glb.aes.id,glb.opt.Prog_Name);
	if (glb.aes.ver>=0x400)
		shel_write(9,1,0,0,0);				/*	for AES v4.0	*/

	if (glb.aes.icon==-1)
		glb.aes.icon=ICONE|FLAGS15;

	wind_get(0,WF_WORKXYWH,&glb.aes.xdesk,&glb.aes.ydesk,&glb.aes.wdesk,&glb.aes.hdesk);
	if (glb.func.iAes!=0)
		(*glb.func.iAes)();
}


/*******************************************************************************
	Init windows
*******************************************************************************/
int _initWin()
{
	int		i;

	if ( iglb.mem.max < iglb.mem.len+(long)glb.opt.Win_Num * (sizeof(window)+sizeof(iwindow)) )
	{
		strcpy(glb.div.log,"Alloc error: win struct\n");
		_reportLog();
		return FALSE;
	}
	W=(window *)iglb.mem.adr+iglb.mem.len;
	iW=(iwindow *)( (long)W+(long)glb.opt.Win_Num*sizeof(window) );
	iglb.mem.len+=(long)glb.opt.Win_Num * (sizeof(window)+sizeof(iwindow));

	for (i=0;i<glb.opt.Win_Num;i++)
	{
		W[i].id			=	-1;
		W[i].type		=	-1;
		W[i].handle		=	-1;
		W[i].xwind		=	-1;
		W[i].in			=	NO_MEMORY;
	}
	return TRUE;
}


/*******************************************************************************
	Init VDI
*******************************************************************************/
void _initVdi()
{
	typedef int		t_rgb[3];
	t_rgb				*col;
	long				len;
	int				i,work_in[11];

	glb.vdi.ha=graf_handle(&glb.vdi.wcell,&glb.vdi.hcell,&glb.vdi.wbox,&glb.vdi.hbox);
	for(i=0;i<10;work_in[i++]=1);
	work_in[0]=Getrez()+2;
	work_in[10]=2;
	v_opnvwk(work_in,&glb.vdi.ha,glb.vdi.out);		/*	opens a virtual workstation	*/
	vq_extnd(glb.vdi.ha,1,glb.vdi.extnd);
	if (glb.vdi.hcell<16)									/*	inits the glb.vdi.low flag !	*/
		glb.vdi.low=1;
	else
		glb.vdi.low=0;
	glb.vdi.xscr=0;
	glb.vdi.yscr=0;
	glb.vdi.wscr=glb.vdi.out[0];
	glb.vdi.hscr=glb.vdi.out[1];

	len=(long)glb.vdi.out[13]*(long)sizeof(t_rgb);
	if ( iglb.mem.max < iglb.mem.len+len )
		iglb.mem.pal=0;
	iglb.mem.pal=iglb.mem.adr+iglb.mem.len;
	col=(t_rgb *)iglb.mem.pal;
	iglb.mem.len+=len;
	for (i=0;i<glb.vdi.out[13];i++)
		vq_color(glb.vdi.ha,i,1,(int *)col[i]);

	if (glb.func.iVdi!=0)
		(*glb.func.iVdi)();
}


/*******************************************************************************
	Init GDOS Fonts
*******************************************************************************/
void _initFont()
{
	long		gdos,*lp;
	int		i;

	_mousework();
	gdos=vq_vgdos();
	glb.vdi.vgdos=0;
	glb.vdi.gdos=0;
	if (gdos==GDOS_NONE)
		glb.vdi.gdos=0;
	else if (gdos==GDOS_FNT)
		glb.vdi.gdos=2;
	else if (gdos==GDOS_FSM)
	{
		lp=(long *)_cookie('FSMC');
		if (lp==0)
			glb.vdi.gdos=0;
		else if (*lp=='_FSM')
		{
			glb.vdi.gdos=3;
			lp++;
			glb.vdi.vgdos=(int)((*lp)>>16);
		}
		else if (*lp=='_SPD')
		{
			glb.vdi.gdos=4;
			lp++;
			glb.vdi.vgdos=(int)((*lp)>>16);
		}
		else
			glb.vdi.gdos=5;
	}
	else
		glb.vdi.gdos=1;
	glb.opt.Gem_Dfont=1;
	glb.opt.Hlp_Dfont=1;
	glb.vdi.nfont=0;

	graf_mouse(USER_DEF,&iglb.aes.s[FSOUFNT]);
	if (glb.vdi.gdos)
		glb.vdi.nfont=vst_load_fonts(glb.vdi.ha,0);

	if ( iglb.mem.max < iglb.mem.len+(long)(2+glb.vdi.nfont)*sizeof(FONT) )
	{
		glb.vdi.nfont=0;
		glb.vdi.vgdos=0;
		glb.vdi.gdos=0;
		strcpy(glb.div.log,"Alloc error: font bloc\n");
		_reportLog();
		return;
	}
	glb.font=(FONT *)(iglb.mem.adr+iglb.mem.len);
	iglb.mem.len+=(long)(2+glb.vdi.nfont)*sizeof(FONT);
	if (glb.vdi.gdos)
		for (i=1;i<=glb.vdi.nfont;i++)
		{
			_mousework();
			glb.font[i].index=vqt_name(glb.vdi.ha,i,glb.font[i].name);
			if ( (glb.font[i].name[32]) && (!strncmp(glb.font[i].name,"Dutch 801 Bold",14)) && (glb.opt.Hlp_Dfont==1) )
				glb.opt.Hlp_Dfont=i;
			glb.opt.Use_Font_Gem=1;
		}
		else
			glb.opt.Use_Font_Gem=0;
	glb.opt.Gem_Ifont=glb.opt.Gem_Dfont;
	glb.opt.Hlp_Ifont=glb.opt.Hlp_Dfont;
	glb.opt.Gem_font=glb.opt.Gem_Dfont;
	glb.opt.Hlp_font=glb.opt.Hlp_Dfont;
	graf_mouse(ARROW,0);
}


/*******************************************************************************
	Init divers
*******************************************************************************/
void _initDiv()
{
	if (glb.func.iDiv!=0)
		(*glb.func.iDiv)();	/*	extern init		*/
}


/*******************************************************************************
	Init Signals
*******************************************************************************/
void _initSig()
{
	int		i;

	if (_cookie('MiNT')>0)
	{
		for (i=0;i<NSIG;i++)
			glb.div.sig[i]=(long)SIG_DFL;
		glb.div.sig[SIGHUP]	=	(long)_sigQUIT;
		glb.div.sig[SIGINT]	=	(long)_sigQUIT;
		glb.div.sig[SIGQUIT]	=	(long)_sigQUIT;
		glb.div.sig[SIGILL]	=	(long)_sigQUIT;
		glb.div.sig[SIGABRT]	=	(long)_sigQUIT;
		glb.div.sig[SIGPRIV]	=	(long)_sigQUIT;
		glb.div.sig[SIGBUS]	=	(long)_sigQUIT;
		glb.div.sig[SIGSEGV]	=	(long)_sigQUIT;
		glb.div.sig[SIGPIPE]	=	(long)_sigQUIT;
		glb.div.sig[SIGTERM]	=	(long)_sigQUIT;
		glb.div.sig[SIGXCPU]	=	(long)_sigQUIT;

		if (glb.func.iSig!=0)
			(*glb.func.iSig)();

		for (i=0;i<NSIG;i++)
			Psignal(i,glb.div.sig[i]);
	}
}


/*******************************************************************************
	Load & init EGlib & program RSC
*******************************************************************************/
int _initRsc()
{
	OBJECT	*tree;
	int		i,j,child;
	char		txt[40];

	sprintf(iglb.rsc.name,"%sEGLIB.RSC",iglb.div.RSC_Path);

	if (!_loadRSC(&iglb.rsc))
		return FALSE;

	tree=iglb.rsc.head.trindex[FMOUSE];
	for (i=1;i<=FSOUFNT;i++)
	{
		iglb.aes.s[i].mf_xhot		=	8;
		iglb.aes.s[i].mf_yhot		=	8;
		iglb.aes.s[i].mf_nplanes	=	1;
		iglb.aes.s[i].mf_fg		=	0;
		iglb.aes.s[i].mf_bg		=	1;

		for (j=0;j<16;j++)
		{
			iglb.aes.s[i].mf_mask[j]	=	tree[i].ob_spec.iconblk->ib_pmask[j];
			iglb.aes.s[i].mf_data[j]	=	tree[i].ob_spec.iconblk->ib_pdata[j];
		}
	}
	if (glb.vdi.low)
		iglb.aes.tree=iglb.rsc.head.trindex[LWIN];
	else
		iglb.aes.tree=iglb.rsc.head.trindex[HWIN];

	for (i=0;i<iglb.rsc.head.ntree;i++)
	{
		tree=iglb.rsc.head.trindex[i];
		child=-1;
		do
		{
			child+=1;
			_myInitForm(i,child);
		}	while ( !(tree[child].ob_flags & LASTOB) );
	}

	sprintf(txt,"%s (%s %s)",RELEASE,__DATE__,__TIME__);
	_obPutStr(iglb.rsc.head.trindex[FINF],FINFVER,txt);
	_obPutStr(iglb.rsc.head.trindex[FINF],FINFPT1,PATCH1);
	_obPutStr(iglb.rsc.head.trindex[FINF],FINFPT2,PATCH2);

	if (!_loadRSC(&glb.rsc))
		return FALSE;

	if (glb.func.iObRsc!=0)
		for (i=0;i<glb.rsc.head.ntree;i++)
		{
			tree=glb.rsc.head.trindex[i];
			child=-1;
			do
			{
				child+=1;
				(*glb.func.iObRsc)(i,child);
			}	while ( !(tree[child].ob_flags & LASTOB) );
		}
	return TRUE;
}


/*******************************************************************************
	Init Desk
*******************************************************************************/
void _initDesk()
{
	OBJECT		*tree;

	if ( (glb.aes.type!=0) && (glb.aes.desk!=-1) )
	{
		tree=glb.rsc.head.trindex[glb.aes.desk];
		tree->ob_x			=	glb.aes.xdesk;
		tree->ob_y			=	glb.aes.ydesk;
		tree->ob_width		=	glb.aes.wdesk;
		tree->ob_height	=	glb.aes.hdesk;

		if (glb.func.iDesk!=0)
			(*glb.func.iDesk)();

		wind_set(0,WF_NEWDESK,tree,0);
		form_dial(FMD_FINISH,0,0,0,0,glb.aes.xdesk,glb.aes.ydesk,glb.aes.wdesk,glb.aes.hdesk);
	}
}


/*******************************************************************************
	Exit Desktop
*******************************************************************************/
void _exitDesk()
{
	if ( (glb.aes.type!=0) && (glb.aes.desk!=-1) )
	{
		wind_set (0,WF_NEWDESK,0,0,0,0);
		form_dial(FMD_FINISH,0,0,0,0,glb.aes.xdesk,glb.aes.ydesk,glb.aes.wdesk,glb.aes.hdesk);
	}
}


/*******************************************************************************
	Exit the EGlib & program RSC files
*******************************************************************************/
void _exitRsc()
{
	int	i;

	for (i=0;i<glb.opt.Win_Num;i++)
		if (W[i].handle>0)
		{
			_closed(i);
			_clearAesBuffer();
		}
	_unloadRSC(&glb.rsc);
	_unloadRSC(&iglb.rsc);
}


/*******************************************************************************
	Some dummy exits
*******************************************************************************/
void _exitDiv()
{
	if (glb.func.eDiv!=0)
		(*glb.func.eDiv)();
}


/*******************************************************************************
	Exit GDOS Fonts
*******************************************************************************/
void _exitFont()
{
	if (glb.vdi.gdos)
		vst_unload_fonts(glb.vdi.ha,0);
}


/*******************************************************************************
	Exit VDI
*******************************************************************************/
void _exitVdi()
{
	if (glb.func.eVdi!=0)
		(*glb.func.eVdi)();
	_loadPal(glb.vdi.out[13]);
	v_clsvwk(glb.vdi.ha);
}


/*******************************************************************************
	Exit AES
*******************************************************************************/
void _exitAes()
{
	if (glb.func.eAes!=0)
		(*glb.func.eAes)();
	_clearAesBuffer();
	if (glb.div.Exit==2 && glb.aes.ver>=0x400)
		shel_write(10,SHUT_COMPLETED,0,0,0);
	appl_exit();
}


/*******************************************************************************
	Exit Memory Manager
*******************************************************************************/
void _exitMem()
{
	DTA	*dta;
	int	drvold=-1;
	char	path[FILENAME_MAX],file[FILENAME_MAX];

	sprintf(path,"%sEGLIB%03i.*",iglb.div.SWP_Path,glb.aes.id);
	if (path[1]==0x3A)
	{
		drvold=Dgetdrv();
		Dsetdrv((int)path[0]-65);
	}
	if (Fsfirst(path,FA_ARCHIVE)==0)
	{
		dta=Fgetdta();
		do
		{
			strcpy(file,iglb.div.SWP_Path);
			strcat(file,dta->d_fname);
			Fdelete(file);
		}	while (Fsnext()==0);
	}
	if (drvold!=-1)
		Dsetdrv(drvold);
	_pFree();
}
