/*******************************************************************************
	"Easy Gem" library Copyright (c)1995 by		Christophe BOYANIQUE
																29 rue de la Rpublique
																37230 FONDETTES
																FRANCE
												FidoNet:		2:320/107.16
												NeST:			90:800/1.16
												AtariNet:	51:901/1.16
										*small* mail at:	cb@spia.freenix.fr
********************************************************************************
	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License, or any later version.
	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.
	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	675 Mass Ave, Cambridge, MA 02139, USA.
********************************************************************************

	MAIN SOURCE.

********************************************************************************
	TABULATION: 3 CARACTERES
*******************************************************************************/

#include		"EG_MAIN.H"

/*******************************************************************************
	Intern variables of the lib
*******************************************************************************/
iGLB			iglb;							/*	main struct										*/
iwindow		*iW;							/*	internal win struct							*/


/*******************************************************************************
	Global variables
*******************************************************************************/
GLB			glb;							/*	main struct										*/
window		*W;							/*	win struct										*/
SLCT_STR		*slct=NULL;					/*	For use with Slectric (see GLB_FSEL)	*/


/*******************************************************************************
	main procedure of the lib
*******************************************************************************/
int _initEGlib(char *name,void cdecl (*lFileIni)())
{
	_parDefault(name);
	strcpy(glb.div.log,iglb.div.EG_Path);
	glb.div.log[strlen(iglb.div.EG_Path)-1L]='\0';
	if (!_fexist(glb.div.log,FA_SUBDIR))
	{
		printf("Can't find %s directory!\n",glb.div.log);
		Crawcin();
		return FALSE;
	}
	strcpy(glb.div.log,glb.opt.APP_Path);
	glb.div.log[strlen(glb.opt.APP_Path)-1L]='\0';
	if (!_fexist(glb.div.log,FA_SUBDIR))
	{
		printf("Can't find %s directory!\n",glb.div.log);
		Crawcin();
		return FALSE;
	}
	glb.func.lFileIni=lFileIni;
	_loadINI(0);
	if (glb.opt.Log_File)
	{
		_initReport();
		sprintf(glb.div.log,"EGlib %s\n",RELEASE);
		_reportLog();
	}
	return 1;
}

void _EGlib()
{
	int	i;

	sprintf(glb.div.log,"Program: %s\n",glb.opt.Prog_Name);
	_reportLog();
	glb.div.Exit=-1;
	/****************************************************************************
	Init Memory Manager
	****************************************************************************/
	if (!_initMem())
		return;

	/****************************************************************************
	Create a bloc which will contain:
		-	Windows struct
		-	GDOS Fonts array
		-	VDI Palette
	****************************************************************************/
	iglb.mem.max=mem.mfre-1L*1024L;
	iglb.mem.in=_mAlloc(iglb.mem.max,MB_NOMOVE,TRUE);
	if (iglb.mem.in==NO_MEMORY)
	{
		strcpy(glb.div.log,"Alloc error: main bloc\n");
		_reportLog();
		return;
	}
	iglb.mem.adr=mem.bloc[iglb.mem.in].adr;

	/****************************************************************************
	Init AES & windows
	****************************************************************************/
	_mousework();
	_initAes();
	if (!_initWin())
		goto exitWin;

	/****************************************************************************
	Init VDI
	****************************************************************************/
	_mousework();
	_initVdi();

	/****************************************************************************
	Init GDOS Fonts
	****************************************************************************/
	_mousework();
	_initFont();

	/****************************************************************************
	Decrease the len of EGlib memory bloc
	****************************************************************************/
	_mousework();
	_mDim(iglb.mem.in,iglb.mem.len,0);

	/****************************************************************************
	Call the external init
	****************************************************************************/
	_mousework();
	if (glb.func.init!=0)
		(*glb.func.init)();

	/****************************************************************************
	Some dummy inits
	****************************************************************************/
	_mousework();
	_initDiv();

	/****************************************************************************
	Init Signals
	****************************************************************************/
	_mousework();
	_initSig();

	/****************************************************************************
	Load & init the EGlib & program RSC files
	****************************************************************************/
	_mousework();
	if (!_initRsc())
		goto exitRsc;

	/****************************************************************************
	Init Desktop
	****************************************************************************/
	_initDesk();
	_mousework();

	/****************************************************************************
	Init the Menu bar
	****************************************************************************/
	_mousework();
	_menuBar(glb.aes.menu,1);

	/****************************************************************************
	Call the external last init
	****************************************************************************/
	if (glb.func.iLast!=0)
		(*glb.func.iLast)();

	if (glb.div.Exit==-1)
		glb.div.Exit=0;

	/****************************************************************************
	Read the INI file for the second time
	****************************************************************************/
	_mousework();
	_loadINI(1);

	/****************************************************************************
	Jump into the main AES event loop
	****************************************************************************/
	graf_mouse(ARROW,0);
	while (!glb.div.Exit)
	{
		_gereAes();
		if ( glb.div.Exit && glb.aes.type!=1 && !glb.aes.multi )
		{
			glb.div.Exit=0;								/*	if ACC: no exit !		*/
			for (i=0;i<glb.opt.Win_Num;i++)
				if (W[i].handle>0)
				{
					_closed(i);
					_clearAesBuffer();
				}
			if (glb.opt.Save_Config)
				_saveINI();
		}
	}

	/****************************************************************************
	Save the INI file
	****************************************************************************/
	_mousework();
	if (glb.opt.Save_Config)
		_saveINI();

	/****************************************************************************
	Call the external first exit
	****************************************************************************/
	_mousework();
	if (glb.func.eFirst!=0)
		(*glb.func.eFirst)();

	/****************************************************************************
	Exit the Menu bar
	****************************************************************************/
	_mousework();
	_menuBar(glb.aes.menu,FALSE);

	/****************************************************************************
	Exit Desktop
	****************************************************************************/
	_mousework();
	_exitDesk();

exitRsc:
	/****************************************************************************
	Exit the EGlib & program RSC files
	****************************************************************************/
	_mousework();
	_exitRsc();

	/****************************************************************************
	Some dummy exits
	****************************************************************************/
	_mousework();
	_exitDiv();

	/****************************************************************************
	Exit GDOS Fonts
	****************************************************************************/
	_mousework();
	_exitFont();

	/****************************************************************************
	Exit VDI
	****************************************************************************/
	_mousework();
	_exitVdi();

exitWin:
	/****************************************************************************
	Exit AES
	****************************************************************************/
	graf_mouse(ARROW,0);
	_exitAes();

	/****************************************************************************
	Exit Memory Manager
	****************************************************************************/
	_exitMem();
	if (glb.opt.Log_File)
		_exitReport();
	return;
}


/*******************************************************************************
	Calcul the intersect of two rect
*******************************************************************************/
int _rcIntersect(GRECT *p1,GRECT *p2)
{
	int		tx,ty,tw,th;

	if ( (p1->g_x==0) && (p1->g_y==0) && (p1->g_w==0) && (p1->g_h==0) )
	{
		tx=p2->g_x;
		ty=p2->g_y;
		tw=p2->g_w;
		th=p2->g_h;
	}
	else if ( (p2->g_x==0) && (p2->g_y==0) && (p2->g_w==0) && (p2->g_h==0) )
	{
		tx=p1->g_x;
		ty=p1->g_y;
		tw=p1->g_w;
		th=p1->g_h;
	}
	else
	{
		tw=min(p2->g_x+p2->g_w,p1->g_x+p1->g_w);
		th=min(p2->g_y+p2->g_h,p1->g_y+p1->g_h);
		tx=max(p2->g_x,p1->g_x);
		ty=max(p2->g_y,p1->g_y);
	}
	p2->g_x=tx;
	p2->g_y=ty;
	p2->g_w=tw-tx;
	p2->g_h=th-ty;
	return ((tw>tx) && (th>ty));
}


/*******************************************************************************
	Clip a rect area
*******************************************************************************/
void _setClip(int flag,GRECT *area)
{
	int		pxy[4];

	pxy[0]=area->g_x;
	pxy[1]=area->g_y;
	pxy[2]=area->g_w+area->g_x-1;
	pxy[3]=area->g_h+area->g_y-1;
	vs_clip (glb.vdi.ha,flag,pxy);
}


/*******************************************************************************
	Load a palette
*******************************************************************************/
void _loadPal(int n)
{
	typedef int		t_rgb[3];
	t_rgb				*col;
	int				i;

	if (iglb.mem.pal)
	{
		col=(t_rgb *)iglb.mem.pal;
		for (i=0;i<min(n,glb.vdi.out[13]);i++)
			vs_color(glb.vdi.ha,i,(int *)col[i]);
	}
}


/*******************************************************************************
	Return the number of word for val (VDI MFDB)
*******************************************************************************/
int _word(int val)
{
	if (val%16==0)
		return val/16;
	else
		return 1+val/16;
}


/*******************************************************************************
	This is to acces to the EGlib PopUp
*******************************************************************************/
void _EGlibPop()
{
	int	mx,my,dum;

	graf_mkstate(&mx,&my,&dum,&dum);
	_clicDesk(mx,my,-1,2);
}


/*******************************************************************************
	Handles QUIT signals
*******************************************************************************/
#pragma warn -par
void _sigQUIT(long ptr)
{
	glb.div.Exit=3;
}
#pragma warn +par


/*******************************************************************************
	This function writes in the LOG file of EGlib
*******************************************************************************/
void _reportLog()
{
	FILE			*ha;

	if (glb.opt.Log_File)
	{
		ha=fopen(glb.opt.LOG_File,"a+");
		if (ha)
		{
			fprintf(ha,"%s",glb.div.log);
			fclose(ha);
		}
	}
}

void _initReport()
{
	time_t		now;
	struct tm	*snow;
	char			txt[20];

	if (_fexist(glb.opt.LOG_File,0))
		Fdelete(glb.opt.LOG_File);
	time(&now);
	snow=localtime(&now);
	strftime(txt,20L,"%d/%m/%y %H:%M:%S",snow);
	sprintf(glb.div.log,"\n------------------- [%s] -------------------\n",txt);
	_reportLog();
}

void _exitReport()
{
	time_t		now;
	struct tm	*snow;
	char			txt[20];

	time(&now);
	snow=localtime(&now);
	strftime(txt,20L,"%d/%m/%y %H:%M:%S",snow);
	sprintf(glb.div.log,"------------------- [%s] -------------------\n",txt);
	_reportLog();
}
