/*******************************************************************************
	"Easy Gem" library Copyright (c)1995 by		Christophe BOYANIQUE
																29 rue de la Rpublique
																37230 FONDETTES
																FRANCE
												FidoNet:		2:320/107.16
												NeST:			90:800/1.16
												AtariNet:	51:901/1.16
										*small* mail at:	cb@spia.freenix.fr
********************************************************************************
	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License, or any later version.
	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.
	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	675 Mass Ave, Cambridge, MA 02139, USA.
********************************************************************************
	TABULATION: 3 CARACTERES
*******************************************************************************/


#ifndef	__EGLIB__
#define	__EGLIB__
/*******************************************************************************
	Release version & date; and modifications author
*******************************************************************************/
#define		RELEASE	"v1.22"
/*#define		RELEASE	"v1.23"*/
#define		PATCH1	"nobody"
#define		PATCH2	"(official release)"

#define	EGLIB_VERSION		0x0122

/*******************************************************************************
	Include files
*******************************************************************************/
#include		<stdio.h>
#include		<stdlib.h>
#include		<ctype.h>
#include		<aes.h>
#include		<vdi.h>
#include		<tos.h>
#include		<math.h>
#include		<string.h>
#include		<time.h>
#include		<MiNT.h>
#include		"C:\PRG\EGLIB.SYS\EGLIB122\FRENCH\EGLIB.H"


/*******************************************************************************
	STANDARD TYPE DEFINITIONS
*******************************************************************************/
#define		BYTE				signed char
#define		UBYTE				unsigned char
#define		WORD				signed int
#define		UWORD				unsigned int
#define		LONG				signed long
#define		ULONG				unsigned long
#define		uchar				unsigned char
#define		uint				unsigned int
#define		ulong				unsigned long
#define		udouble			unsigned double
#define		ufloat			unsigned float
#define		BOOLEAN			int
#define		FLOAT				float
#define		DOUBLE			double
#define		REG				register
#define		EXTERN			extern
#define		LOCAL				static
#define		statique			static
#define		MLOCAL			LOCAL
#define		GLOBAL
/*******************************************************************************
	MISCELLANEOUS DEFINITIONS
*******************************************************************************/
#ifndef TRUE
#define		FALSE				(BOOLEAN)0
#define		TRUE    			(BOOLEAN)1
#endif
/*******************************************************************************
*******************************************************************************/


/*******************************************************************************
	WINDOW DEFINES
*******************************************************************************/
#define	WIC_EXT	0
#define	WIC_DEF	-1
#define	WIC_INF	-2
#define	WIC_MEM	-3
#define	WIC_FNT	-4
#define	WIC_OPT	-5
#define	WIC_SYS	-6
#define	WIC_HLP	-7

#define	TW_FORM			0						/*	Window type: Form		(reserved)	*/
#define	TW_HELP			1						/*	Window type: Help		(reserved)	*/
#define	TW_IMG			2						/*	Window type: Image					*/

#define	wNAMEMAX			60							/*	Max window name					*/
#define	wSNAMEMAX		10							/*	max iconified window name		*/

#define	wMODAL			0x0001	/*	Window gadget: Modal window					*/
#define	wMOVE				0x0002	/*	Window gadget: Move window						*/
#define	wCLOSE			0x0004	/*	Window gadget: Close window					*/
#define	wMENU				0x0008	/*	Window gadget: PopUp menu on the window	*/
#define	wCYCLE			0x0010	/*	Window gadget: Cycle window					*/
#define	wICON				0x0020	/*	Window gadget: Iconifie window				*/
#define	wFULL				0x0040	/*	Window gadget: Full window						*/
#define	wVSLIDE			0x0080	/*	Window gadget: Vertical slider				*/
#define	wUARROW			0x0100	/*	Window gadget: Up arrow							*/
#define	wDARROW			0x0200	/*	Window gadget: Down arrow						*/
#define	wSIZE				0x0400	/*	Window gadget: Resize window					*/
#define	wRARROW			0x0800	/*	Window gadget: Right arrow						*/
#define	wLARROW			0x1000	/*	Window gadget: Left arrow						*/
#define	wHSLIDE			0x2000	/*	Window gadget: Horizontal slide				*/
#define	wXWORK16			0x4000	/*	Window gadget: Force xwork pos 16 multiple*/
#define	wSWAP				0x8000	/*	Window feature: swap into file when icon	*/


/*******************************************************************************
	RSC DEFINES
*******************************************************************************/
#define	USD_CROSS		0x0100				/*	STRING with a [checked] box		*/
#define	USD_ROUND		0x0200				/*	STRING with a radio button			*/
#define	USD_POPUP		0x0300				/*	PopUp menu BUTTON						*/
#define	USD_XPOPUP		0x0400				/*	Extended PopUp menu BUTTON			*/
#define	USD_FRAME		0x0500				/*	Frame with a title					*/
#define	USD_NUM			0x0600				/*	Number with arrow						*/
#define	USD_DNARROW		0xFD00				/*	USERDEF: down arrow					*/
#define	USD_UPARROW		0xFC00				/*	USERDEF: up arrow						*/
#define	USD_LFARROW		0xFB00				/*	USERDEF: left arrow					*/
#define	USD_RTARROW		0xFA00				/*	USERDEF: right arrow					*/
#define	USD_LQARROW		0xF900				/*	USERDEF: double left arrow			*/
#define	USD_RQARROW		0xF800				/*	USERDEF: double right arrow		*/

#define	ED_CLIP			0x0100				/*	Clip with _objcEdit()				*/


/*******************************************************************************
	HELP DEFINES
*******************************************************************************/
#define	HLP_TABUL		30
#define	HLP_DECPAR		20
#define	HLP_DECLINE		10
#define	PAR_MAX			200				/*	max number of paragraph					*/
#define	COUL_TRUE		11					/*	default color for existing file		*/
#define	COUL_FALSE		14					/*	default color for non existing file	*/
#define	MAX_HIST			10					/*	history lenght								*/
#define	MAX_LEN_HIST	20					/*	history text lenght						*/


/*******************************************************************************
	MiNT SIGNALS
*******************************************************************************/
#define	SIGNULL		0		/*	not really a signal					*/
#define	SIGHUP		1		/*	hangup signal							*/
#define	SIGINT		2		/*	sent by ^C								*/
#define	SIGQUIT		3		/*	quit signal								*/
#define	SIGILL		4		/*	illegal instruction					*/
#define	SIGTRAP		5		/*	trace trap								*/
#define	SIGABRT		6		/*	abort signal							*/
#define	SIGPRIV		7		/*	privilege violation					*/
#define	SIGFPE		8		/*	divide by zero							*/
#define	SIGKILL		9		/*	cannot be ignored						*/
#define	SIGBUS		10		/*	bus error								*/
#define	SIGSEGV		11		/*	illegal memory reference			*/
#define	SIGSYS		12		/*	bad argument to a system call		*/
#define	SIGPIPE		13		/*	broken pipe								*/
#define	SIGALRM		14		/*	alarm clock								*/
#define	SIGTERM		15		/*	software termination signal		*/
#define	SIGURG		16		/*	urgent condition on I/O channel	*/
#define	SIGSTOP		17		/*	stop signal not from terminal		*/
#define	SIGTSTP		18		/*	stop signal from terminal			*/
#define	SIGCONT		19		/*	continue stopped process			*/
#define	SIGCHLD		20		/*	child stopped or exited				*/
#define	SIGTTIN		21		/*	read by background process			*/
#define	SIGTTOU		22		/*	write by background process		*/
#define	SIGIO			23		/*	I/O possible on a descriptor		*/
#define	SIGXCPU		24		/*	CPU time exhausted					*/
#define	SIGXFSZ		25		/*	file size limited exceeded			*/
#define	SIGVTALRM	26		/*	virtual timer alarm					*/
#define	SIGPROF		27		/*	profiling timer expired				*/
#define	SIGWINCH		28		/*	window size changed					*/
#define	SIGUSR1		29		/*	ser signal 1							*/
#define	SIGUSR2		30		/*	user signal 2							*/

#define	NSIG			31		/*	number of signals recognized		*/
#define	SIG_DFL		0
#define	SIG_IGN		1


/*******************************************************************************
	KEYBOARD DEFINES
*******************************************************************************/
#define	K_NIL			0x00			/*	No Key				*/
#define	K_UP			0x01			/*	Cursor UP			*/
#define	K_DOWN		0x02			/*	cursor DOWN			*/
#define	K_RIGHT		0x03			/*	cursor RIGHT		*/
#define	K_LEFT		0x04			/*	cursor LEFT			*/
#define	K_BS			0x08			/*	BACKSPACE			*/
#define	K_TAB			0x09			/*	TAB					*/
#define	K_ENTER		0x0A			/*	ENTER					*/
#define	K_INS			0x0B			/*	INSERT				*/
#define	K_CLRHOME	0x0C			/*	CLR-HOME				*/
#define	K_RETURN		0x0D			/*	RETURN				*/
#define	K_HELP		0x0E			/*	HELP					*/
#define	K_UNDO		0x0F			/*	UNDO					*/
#define	K_F1			0x10			/*	Function Key #1	*/
#define	K_F2			0x11			/*	Function Key #2	*/
#define	K_F3			0x12			/*	Function Key #3	*/
#define	K_F4			0x13			/*	Function Key #4	*/
#define	K_F5			0x14			/*	Function Key #5	*/
#define	K_F6			0x15			/*	Function Key #6	*/
#define	K_F7			0x16			/*	Function Key #7	*/
#define	K_F8			0x17			/*	Function Key #8	*/
#define	K_F9			0x18			/*	Function Key #9	*/
#define	K_F10			0x19			/*	Function Key #10	*/
#define	K_ESC			0x1B			/*	ESCAPE				*/
#define	K_DEL			0x7F			/*	DELETE				*/

#define	KF_FUNC		0x4000		/*	Function flag		*/
#define	KF_NUM		0x2000		/*	Numeric pad			*/
#define	KF_CAPS		0x1000		/*	CapsLock				*/
#define	KF_ALT		0x0800		/*	Alternate			*/
#define	KF_CTRL		0x0400		/*	Control				*/
#define	KF_SHIFT		0x0300		/*	any Shift			*/
#define	KF_LSH		0x0200		/*	Left Shift			*/
#define	KF_RSH		0x0100		/*	Right Shift			*/


/*******************************************************************************
	MEMORY DEFINES
*******************************************************************************/
#define	MEM_NMB		10										/*	Number of Malloc blocs	*/

#define	MB_IGNORE	0										/*	free bloc					*/
#define	MB_NORM		1										/*	allocated bloc				*/
#define	MB_NOMOVE	2										/*	allocated bloc fixed		*/

#define	OK_MEM		0													/*	No error			*/
#define	NO_OS_MEM	-1													/*	No TOS memory	*/
#define	NO_MEMORY	-2													/*	No lib memory	*/
#define	SWP_MEMORY	-3													/*	Swapped memory	*/


/*******************************************************************************
	LANGUAGE DEFINES
*******************************************************************************/
#define	L_FRENCH		1
#define	L_ENGLISH	2
#define	L_DEUTSCH	4


/*******************************************************************************
	OTHER DEFINES
*******************************************************************************/
#define	max(A,B)			( (A) > (B) ? (A) : (B) )
#define	min(A,B)			( (A) < (B) ? (A) : (B) )
#define	LOG_MAX			256


/*******************************************************************************
	struct to retain RSC parameters for each window
*******************************************************************************/
typedef struct
{
	int	x;
	int	y;
	int	flags;
}	xy;
typedef struct
{
	int	x;
	int	y;
	int	w;
	int	h;
	int	flags;
}	wh;
typedef struct
{
	int	x,y,w,h;
	wh		_box;
	wh		_name;
	xy		_close;
	xy		_menu;
	xy		_cycle;
	xy		_icon;
	xy		_full;
	wh		_vslf;
	wh		_vslp;
	wh		_vsli;
	xy		_uarr;
	xy		_darr;
	xy		_size;
	xy		_rarr;
	xy		_larr;
	wh		_hslf;
	wh		_hslp;
	wh		_hsli;
}	_form;

/*******************************************************************************
	struct for GDOS font handling
*******************************************************************************/
typedef struct
{
	char		name[34];					/*	0..31: Name | 32: vectoriel flag		*/
	int		index;						/*	GDOS index									*/
}	FONT;


/*******************************************************************************
	struct for USERDEF objects
*******************************************************************************/
typedef struct
{
	int			type;
	USERBLK		blk;
	long			spec;
	uint			user1;
	uint			user2;
	uint			user3;
	uint			user4;
	long			userl;
}	UBLK;


/*******************************************************************************
	structs for memory handling
*******************************************************************************/
typedef struct
{
	long	adr;
	long	len;
	int	type;
}	BLOC;
typedef struct
{
	int	n;										/*	Max number of MBalloc	*/
	long	tfre;									/*	Total free lenght			*/
	long	tlen;									/*	Total lenght				*/
	long	mfre;									/*	Max free bloc				*/	
	long	Badr[MEM_NMB];						/*	Malloc adress				*/
	long	Blen[MEM_NMB];						/*	Malloc lenght				*/
	BLOC	*bloc;
}	MEM;


/*******************************************************************************

	Selectric support (The *best* fileselector replacement)

*******************************************************************************/
#define	CMD_FILES_OUT	0x01							/*	Return filelist				*/
#define	CFG_ONESTRING	0x02							/*	Return list in one string	*/
#define	CFG_FIRSTNEXT	0x08
typedef struct
{
	ulong		id;						/* Selectric ID (SLCT)		*/
	uint		version;					/* version (BCD-Format)		*/
	struct
	{
		unsigned 			:	8;		/*	reserved						*/
		unsigned pthsav	:	1;		/*	save GEMDOS paths			*/
		unsigned stdest	:	1;		/*	stay in destination path*/
		unsigned autloc	:	1;		/*	auto-locator				*/
		unsigned numsrt	:	1;		/*	numsort						*/
		unsigned lower		:	1;		/*	use lowercase letters	*/
		unsigned dclick	:	1;		/*	open folder on dclick	*/
		unsigned hidden	:	1;		/*	show hidden files			*/
		unsigned bypass	:	1;		/*	Selectric ON/OFF			*/
	}	config;
	int		sort;						/*	sort-mode (neg. = rev.)	*/
	int		num_ext;					/*	number of extensions		*/
	char		*(*ext)[];				/*	preset extensions			*/
	int		num_paths;				/*	number of paths			*/
	char		*(*paths)[];			/*	preset paths				*/
	int		comm;						/*	communication word		*/
	int		in_count;				/*	input counter				*/
	void		*in_ptr;					/*	input pointer				*/
	int		out_count;				/*	output counter				*/
	void		*out_ptr;				/*	output pointer				*/
	int cdecl	(*get_first)(DTA *dta,int attrib);
	int cdecl 	(*get_next)(DTA *dta);
	int cdecl	(*release_dir)(void);
}	SLCT_STR;


/*******************************************************************************
	RSC header and support struct
*******************************************************************************/
typedef struct
{
	long			nobs;
	long			ntree;
	long			nted;
	long			ncib;
	long			nib;
	long			nbb;
	long			nfstr;
	long			nfimg;
	OBJECT		*object;
	TEDINFO		*tedinfo;
	ICONBLK		*iconblk;
	BITBLK		*bitblk;
	CICON			*cicon;
	CICONBLK		*ciconblk;
	char			**frstr;
	BITBLK		**frimg;
	OBJECT		**trindex;
}	myRSHDR;

typedef struct
{
	char		name[FILENAME_MAX];			/*	RSC file name			*/
	myRSHDR	head;								/*	RSC Header				*/
	int		in;								/*	Index of Memory		*/
	long		adr;								/*	Adr of memory bloc	*/
	long		len;								/*	Len of memory bloc	*/
	long		max;								/*	Max len of bloc		*/
	UBLK		*ublk;							/*	userdef array			*/
	CICON		*cicon;							/*	color icon array		*/
}	RSC;


/*******************************************************************************
	This struct contains all the parameters of the lib
*******************************************************************************/
typedef struct
{
	struct
	{
	int		id;						/*	AES handle						*/
	int		ver;						/*	AES version						*/
	int		multi;					/*	multitask flag					*/
	int		type;						/*	application flag				*/
	int		xdesk;					/*	x dim of desk					*/
	int		ydesk;					/*	y dim of desk					*/
	int		wdesk;					/*	w dim of desk					*/
	int		hdesk;					/*	h dim of desk					*/
	int		menu;						/*	RSC tree for MENU				*/
	int		desk;						/*	RSC tree for DESK				*/
	int		ic_tree;					/*	Tree which contains icons	*/
	int		icon;						/*	APP Iconified window			*/
	int		flag;						/*	evnt_multi flag				*/
	int		f1,x1,y1,w1,h1;		/*	in/out rect 1					*/
	int		f2,x2,y2,w2,h2;		/*	in/out rect 2					*/
	int		timer1;					/*	timer low byte					*/
	int		timer2;					/*	timer high byte				*/
	}	aes;

	RSC		rsc;						/*	program RSC header			*/
	FONT		*font;					/*	Struct for GDOS fonts		*/

	struct
	{
	int		ha;						/*	VDI handle						*/
	int		out[57];					/*	VDI parameters					*/
	int		extnd[57];				/*	VDI parameters					*/
	int		xscr;						/*	x dim of screen				*/
	int		yscr;						/*	y dim of screen				*/
	int		wscr;						/*	w dim of screen				*/
	int		hscr;						/*	h dim of screen				*/
	int		wcell;					/*	text cellul width				*/
	int		hcell;					/*	text cellul height			*/
	int		wbox;						/*	box width						*/
	int		hbox;						/*	box height						*/
	int		gdos;						/*	flag GDOS						*/
	int		vgdos;					/*	Version of GDOS				*/
	int		nfont;					/*	Number of GDOS fonts			*/
	int		low;						/*	low rez flag					*/
	}	vdi;

	struct
	{
	void	cdecl	(*init)(void);						/*	General init	*/
	void	cdecl	(*iSig)(void);						/*	Signals init	*/
	void	cdecl	(*iAes)(void);						/*	AES init			*/
	void	cdecl	(*iVdi)(void);						/*	VDI init			*/
	void	cdecl	(*iDiv)(void);						/*	divers init		*/
	void	cdecl	(*iObRsc)(int tree,int obj);	/*	init RSC by obj*/
	void	cdecl	(*iDesk)(void);					/*	desk init		*/
	void	cdecl	(*iLast)(void);					/*	Last init		*/
	void	cdecl	(*eFirst)(void);					/*	First exit		*/
	void	cdecl	(*eDiv)(void);						/*	divers exit		*/
	void	cdecl	(*eVdi)(void);						/*	VDI exit			*/
	void	cdecl	(*eAes)(void);						/*	AES exit			*/
	void	cdecl (*wPop)(int i,int n);			/*	Window PopUp	*/
	void	cdecl	(*gMenu)(int opt);				/*	Menu Event		*/
	void	cdecl	(*gTimer)(void);					/*	Timer Event		*/
	void	cdecl	(*gBox1)(void);					/*	Box 1 Event		*/
	void	cdecl	(*gBox2)(void);					/*	Box 2 Event		*/
	void	cdecl	(*gKey)(int key);					/*	KeyBoard Event	*/
	void	cdecl	(*gMesag)(int buf[8]);			/*	Mesag Event		*/
	void	cdecl	(*gAcOpen)(void);					/*	AcOpen Event	*/
	void	cdecl	(*gAcClose)(void);				/*	AcClose Event	*/
	void	cdecl	(*gClicD)(int x,int y,int k);	/*	Desk Clic Event*/
	void	cdecl	(*gClicF)(int obj,int n,int nmb);/*	WinForm Clic*/
	void	cdecl (*lFileIni)(char *tit,char *buf,char *p);
	void	cdecl (*sFileIni)(void);				/*	INI saving		*/
	}	func;

	struct
	{
	int		Win_Num;						/*	Number of windows				*/
	int		Mem_Num;						/*	Number of memory blocs		*/
	long		Mem_Len;						/*	Len of allocated memory		*/
	long		Mem_Boot;					/*	Len of memory at init		*/
	int		Gem_font;					/*	Font in GEM						*/
	int		Gem_Dfont;					/*	Default GDOS font in GEM	*/
	int		Gem_Ifont;					/*	Intern GDOS font in GEM		*/
	int		Hlp_font;					/*	Font in help					*/
	int		Hlp_Dfont;					/*	Default GDOS font in help	*/
	int		Hlp_Ifont;					/*	Intern GDOS font in help	*/
	int		Hlp_Font_Size;				/*	Size of font in help			*/
	int		Hlp_Color_Text;			/*	Text color in help			*/
	int		Hlp_Color_Back;			/*	Background color in help	*/
	unsigned	Mouse_Form		:2;		/*	Form to mouse					*/
	unsigned	Flash_PopUp		:1;		/*	Flash the selected option	*/
	unsigned	Use_Font_Gem	:1;		/*	Use font in GEM				*/
	unsigned	Use_Font_Hlp	:1;		/*	Use font in HELP				*/
	unsigned	Log_File			:1;		/*	Make a Log file				*/
	unsigned	Save_Config		:1;		/*	Save config at exit			*/
	unsigned	Auto_Icon		:1;		/*	Auto align icon				*/
	unsigned	Big_Icon			:1;		/*	Use big icons					*/
	unsigned	Rev_Horiz		:1;		/*	Reverse horizontal			*/
	unsigned	Rev_Verti		:1;		/*	Reverse vertical				*/
	int		Language;					/*	Language							*/
	int		Av_Lang;						/*	Available languages			*/
	char		HLP_Path[FILENAME_MAX];	/*	Path to help files			*/
	char		HLP_File[14];				/*	Default help file				*/
	char		INI_File[FILENAME_MAX];	/*	File w/Path to EGLIB.INI	*/
	char		LOG_File[FILENAME_MAX];	/*	File w/Path to EGLIB.INI	*/
	char		APP_Path[FILENAME_MAX];	/*	Path to prg sys folder		*/
	char		Prog_Name[16];				/*	Program name					*/
	}	opt;

	struct
	{
	long		sig[NSIG];				/*	signal functions		*/
	char		path[FILENAME_MAX];	/*	current directory		*/
	int		AccOp;					/*	open ACC flag			*/
	int		Exit;						/*	exit flag				*/
	int		MCH;						/*	machine type			*/
	int		TOS;						/*	TOS version				*/
	long		*fsel;
	char		log[LOG_MAX];
	char		pname[FILENAME_MAX];
	char		pfname[FILENAME_MAX];
	char		fname[14];
	char		ext[14];
	char		tit[30];
	}	div;
}	GLB;

typedef struct
{
	struct
	{
	MFORM		s[14];					/*	mouse form				*/
	OBJECT	*tree;					/*	RSC window tree		*/
	int		top;						/*	TOPped window			*/
	int		x,y,w,h;
	int		buf[8];
	int		evnt;
	int		kst;
	int		key,std;
	int		mx,my,mk;
	int		nmbClic;
	int		Big_Icon;				/*	Use big icons			*/
	int		Old_Tree;
	int		Old_Icon;
	int		fmod;
	int		wmod;
	}	aes;

	struct
	{
	int		farb[256][32];
	ulong		farb2[32];
	int		pal[256][4];
	int		xpixel;
	}	icn;

	struct
	{
	char		Gem_font[34];					/*	Font in GEM						*/
	char		Gem_Dfont[34];					/*	Default GDOS font in GEM	*/
	char		Gem_Ifont[34];					/*	Intern GDOS font in GEM		*/
	char		Hlp_font[34];					/*	Font in help					*/
	char		Hlp_Dfont[34];					/*	Default GDOS font in help	*/
	char		Hlp_Ifont[34];					/*	Intern GDOS font in help	*/
	}	fnt;

	struct
	{
	char		*ad_text;
	int		*ad_taille;
	int		*ad_buf;
	int		adtext;
	int		adtaille;
	int		adfile;
	int		adbuf;
	long		taille;				/*	long du fichier			*/
	int		nb_par;				/*	nbre de paragraphes		*/
	int		nb_lig;				/*	nbre de lignes				*/
	int		start;				/*	premier affichage ?		*/
	char		hist[MAX_HIST+1][MAX_LEN_HIST+1];
	char		hist2[MAX_HIST+1][MAX_LEN_HIST+1];
	int		cu_hist;
	int		cp_hist;
	}	hlp;

	RSC		rsc;						/*	EGlib RSC header		*/

	struct
	{
	int		in;
	long		adr;						/*	This is only for		*/
	long		len;						/*	internal use by		*/
	long		max;						/*	EGlib !					*/
	long		pal;						/*	Pal buffer				*/
	}	mem;
	
	struct
	{
	char		EG_Path[FILENAME_MAX];	/*EGlib folder			*/
	char		HLP_Path[FILENAME_MAX];
	char		SWP_Path[FILENAME_MAX];	/*Path to TMP folder	*/
	char		RSC_Path[FILENAME_MAX];	/*	Path to RSC file	*/
	int		mouse;
	BASPAG	*OldPid;
	BASPAG	**Run;
	int		swap;
	}	div;
}	iGLB;


/*******************************************************************************
	window struct
*******************************************************************************/
typedef struct
{
	int		pos;
	int		obj;
	OBJECT	*tree;
}	WFORM;

typedef union
{
	WFORM	wf;								/*	Data for a Form window						*/
	void	*buf;								/*	Raw data											*/
	int	imem;								/*	Memory manager index							*/
}	WSTR;

typedef struct
{
	WSTR		str;
	int		in;							/*	Memory index (for swap file)				*/
	int		smallflag;					/*	SMALL flag										*/
	int		xslidpos,xslidlen;		/*	Position & lenght of X slider				*/
	int		yslidpos,yslidlen;		/*	Position & lenght of Y slider				*/
	int		x,y,w,h;						/*	dimension free for the user				*/
	int		handle;						/*	AES handle of the window					*/
	int		gadget;						/*	Gadgets											*/
	int		type;							/*	Type of window									*/
	int		id;							/*	Identification of window					*/
	int		xwind;						/*	X pos of the window							*/
	int		ywind;						/*	Y pos of the window							*/
	int		wwind;						/*	W pos of the window							*/
	int		hwind;						/*	H pos of the window							*/
	int		xfull;						/*	X full pos of the window					*/
	int		yfull;						/*	Y full pos of the window					*/
	int		wfull;						/*	W full pos of the window					*/
	int		hfull;						/*	H full pos of the window					*/
	int		xwork;						/*	X work pos of the window					*/
	int		ywork;						/*	Y work pos of the window					*/
	int		wwork;						/*	W work pos of the window					*/
	int		hwork;						/*	H work pos of the window					*/
	int		wmini;						/*	minimum width									*/
	int		hmini;						/*	minimum height									*/
	int		xsmall,xwsmall;			/*	X iconified pos								*/
	int		ysmall,ywsmall;			/*	Y iconified pos								*/
	int		wsmall,wwsmall;			/*	W iconified pos								*/
	int		hsmall,hwsmall;			/*	H iconified pos								*/
	int		popup;						/*	RSC tree index of PopUp Menu object		*/
	int		ic_tree;						/*	RSC tree number of ICONIFIED window		*/
	int		icon;							/*	RSC object index of ICONIFIED window	*/

	char		name[wNAMEMAX+2];			/*	Name of the window							*/
	char		sname[wSNAMEMAX+2];		/*	Name of the iconified window				*/
	char		help[14];					/*	Name of the help file						*/

	void	cdecl (*init)(int i);
	void	cdecl (*redraw)(int i,int x,int y,int w,int h);
	void	cdecl (*top)(int i);
	void	cdecl (*pop)(int i,int n);
	void	cdecl (*close)(int i);
	void	cdecl (*full)(int i);
	void	cdecl (*arrow)(int i,int type);
	void	cdecl (*hslid)(int i,int size);
	void	cdecl (*vslid)(int i,int size);
	void	cdecl (*size)(int i,int w,int h);
	void	cdecl (*move)(int i,int x,int y);
	void	cdecl (*untop)(int i);
	void	cdecl (*ontop)(int i);
	void	cdecl (*small)(int i);
	void	cdecl (*nsmall)(int i);
	void	cdecl (*clic)(int i,int x,int y,int k,int nb);
	void	cdecl (*keybd)(int i,int key);
}	window;

typedef struct								/*	This struct is *intern*	*/
{
	int		mxwsmall;					/*	real X work pos window	*/
	int		mywsmall;					/*	real Y work pos window	*/
	int		mwwsmall;					/*	real W work pos window	*/
	int		mhwsmall;					/*	real H work pos window	*/
	int		mxwork;						/*	real X work pos window	*/
	int		mywork;						/*	real Y work pos window	*/
	int		mwwork;						/*	real W work pos window	*/
	int		mhwork;						/*	real H work pos window	*/
	int		xold;							/*	reserved for Fuller		*/
	int		yold;							/*	reserved for Fuller		*/
	int		wold;							/*	reserved for Fuller		*/
	int		hold;							/*	reserved for Fuller		*/
	_form		params;						/*	reserved array				*/
}	iwindow;


/*******************************************************************************
	INTERN VARIABLES
*******************************************************************************/
extern	iGLB		iglb;					/*	global parameter struct						*/
extern	iwindow	*iW;					/*	intern window struct							*/


/*******************************************************************************
	GLOBAL VARIABLES
*******************************************************************************/
extern	GLB		glb;					/*	global parameter struct						*/
extern	window	*W;					/*	global window struct							*/
extern	MEM		mem;
extern	SLCT_STR	*slct;				/*	For use with Slectric (see GLB_FSEL)	*/


/*******************************************************************************
	FUNCTIONS: EGlib
*******************************************************************************/
int	_initEGlib		(char *name,void cdecl (*lFileIni)());
void	_EGlib			(void);
int	_rcIntersect	(GRECT *p1,GRECT *p2);
void	_setClip			(int flag,GRECT *area);
void	_loadPal			(int n);
int	_word				(int val);
void	_EGlibPop		(void);
void	_reportLog		(void);
void	_sigQUIT			(long sig);
void	_initReport		(void);
void	_exitReport		(void);

/*******************************************************************************
	FUNCTIONS: EG_AES
*******************************************************************************/
void	_menuBar					(int obj,int flag);
int	_StdKey					(int shift,int key);
void	_clearAesBuffer		(void);
void	_mousework				(void);
void	_gereAes					(void);
void	_handleEvntKeybd		(void);
void	_handleEvntButton		(void);
void	_handleEvntBox1		(void);
void	_handleEvntBox2		(void);
void	_handleEvntMesag		(void);
void	_handleEvntTimer		(void);
void	_gereMenu				(int titre,int option);
void	_AcOpen					(void);
void	_AcClose					(void);
void	_clicDesk				(int mx,int my,int mk,int nmb);


/*******************************************************************************
	FUNCTIONS: EG_CICN
*******************************************************************************/
int			_addCicon		(RSC *rsc,CICONBLK *cicnblk,OBJECT *obj,UBLK *obblk,CICON *cicon_table);
void			_fillFarbTbl	(void);
int			_testRez			(void);
int cdecl	_drawCicon		(PARMBLK *pb);

/*******************************************************************************
	FUNCTIONS: EG_FSEL
*******************************************************************************/
int	_fexist			(char *name,int type);
int	_fselect			(char *pfname,char *pname,char *fname,char *ext,char *title);
int	_slctCheck		(uint version);
int	_slctExtPath	(int ext_num,char *(*ext)[],int path_num,char *(*paths)[]);
int	_slctMoreNames	(int mode,int num,void *str);
int	_slctFirst		(DTA *mydta,int attr);
int	_slctNext		(DTA *mydta);
int	_slctRelease	(void);


/*******************************************************************************
	FUNCTIONS: EG_HELP
*******************************************************************************/
void	_initHelp	(void);
void	_Aide			(void);
int	_ouvreHelp	(char *name);


/*******************************************************************************
	FUNCTIONS: EG_INIT
*******************************************************************************/
int	_initMem					(void);
void	_initAes					(void);
int	_initWin					(void);
void	_initVdi					(void);
void	_initFont				(void);
void	_initDiv					(void);
void	_initSig					(void);
int	_initRsc					(void);
void	_initDesk				(void);
void	_exitDesk				(void);
void	_exitRsc					(void);
void	_exitDiv					(void);
void	_exitFont				(void);
void	_exitVdi					(void);
void	_exitAes					(void);
void	_exitMem					(void);


/*******************************************************************************
	FUNCTIONS: EG_MEM
*******************************************************************************/
int	_mAlloc		(long len,int type,int cls);
void	_mFree		(int index);
void	_mSpecFree	(long adr);
int	_mDim			(int index,long len,int cls);
void	*_Malloc		(long number);
int	_Mfree		(void *block);
int	_Mshrink		(int zero,void *block,long newsiz);
int	_pAlloc		(int n,long len);
void	_pFree		(void);
void	_pDim			(long len);
long	_freeSys		(void);


/*******************************************************************************
	FUNCTIONS: EG_POP
*******************************************************************************/
int	_formMenu	(OBJECT *tree,int obj,OBJECT *menu,int hJust,int vJust,int Video);
int	_popUp		(OBJECT *menu,int x,int y);
int	_formXmenu	(OBJECT *tree,int obj,char *tab,int nmb,int off,int len,int val);
void	_initPopUp	(OBJECT *tree,int obj,int popTree,int val);
void	_initXPopUp	(OBJECT *tree,int obj,char *tab,int nmb,int off,int len,int val);
int	_getPopUp	(OBJECT *tree,int obj);


/*******************************************************************************
	FUNCTIONS: EG_RSC
*******************************************************************************/
int	_loadRSC		(RSC *rsc);
void	_unloadRSC	(RSC *rsc);
void	_obPutStr	(OBJECT *tree,int objc,const char *str);
void	_putPath		(OBJECT *tree,int n,int len,char *name);
char	*_obGetStr	(OBJECT *tree,int objc);
int	_father		(OBJECT *tree,int child);
void	_coord		(OBJECT *tree,int obj,int larg,int *x,int *y,int *w,int *h);
void	_relocRSC	(RSC *rsc);
int	_initUserdef(RSC *rsc);
void	_initNum		(OBJECT *tree,int obj,uint vmin,uint vmax,uint inc,uint val);


/*******************************************************************************
	FUNCTIONS: EG_SYS
*******************************************************************************/
void	_parDefault	(char *name);
void	_loadINI		(int code);
void	_saveINI		(void);
void	_outINI		(char *txt);


/*******************************************************************************
	FUNCTIONS: EG_USRD
*******************************************************************************/
int cdecl	_drawString		(PARMBLK *pb);
int cdecl	_drawNiceLine	(PARMBLK *pb);
int cdecl	_draw3dButton	(PARMBLK *pb);
int cdecl	_drawBakButton	(PARMBLK *pb);
int cdecl	_drawButton		(PARMBLK *pb);
int cdecl	_drawText		(PARMBLK *pb);
int cdecl	_drawFText		(PARMBLK *pb);
int cdecl	_drawBoxText	(PARMBLK *pb);
int cdecl	_drawFBoxText	(PARMBLK *pb);
int cdecl	_drawBox			(PARMBLK *pb);
int cdecl	_drawCroixCarre(PARMBLK *pb);
int cdecl	_drawPopUp		(PARMBLK *pb);
int cdecl	_drawFrame		(PARMBLK *pb);


/*******************************************************************************
	FUNCTIONS: EG_WIN
*******************************************************************************/
void	_winAlign		(void);
int	_winOpen			(window *win);
void	_winClose		(int i);
void	_winVslid		(int i);
void	_winHslid		(int i);
void	_winSmall		(int i);
void	_winName			(int i,char *name,char *sname);
void	_winWsize		(int i,int w,int h);
void	_winSize			(int i,int w,int h);
void	_winMove			(int i,int x,int y);
void	_small			(int i);
void	_allsmall		(int i);
void	_unsmall			(int i);
void	_allunsmall		(int i);
void	_top				(int i);
void	_untop			(int i);
void	_ontop			(int i);
void	_closed			(int i);
void	_full				(int i);
void	_size				(int i,int w,int h);
void	_move				(int i,int x,int y);
void	_redraw			(int i,int x,int y,int w,int h);
void	_clicWin			(int i,int x,int y,int k,int nmb);
void	_redrawWindow	(int i);
void	_setWindow		(int i);
void	_makeform		(int i);
void	_maketop			(void);
int	_winFindWin		(int handle);
int	_winFindId		(int type,int id,int open);
void	_winRedraw		(int i,int x,int y,int w,int h);
void	_initModal		(void);
void	_exitModal		(void);
void	_winCalc			(int type,int kind,int x,int y,int w,int h,int *outx,int *outy,int *outw,int *outh);


/*******************************************************************************
	FUNCTIONS EG_WFRM
*******************************************************************************/
void	_winObdraw	(int i,OBJECT *tree,int obj, int dept, int x,int y,int w,int h);
int	_winForm		(int tree,char *name,char *sname,char *help,int popup,int ic_tree,int icon,int modal);
void	_whichEdit	(int i,int *obj,int *pos);
void	_setEdit		(int i,int obj,int pos);
int	_objcEdit	(OBJECT *tree,int obj,int kc,int *idx,int mode);
void	_myInitForm	(int obj,int n);


/*******************************************************************************
	EG_ASM
*******************************************************************************/
void	_cls						(long adr,long len);
long	_cookie					(long Cook);
long	_cookieJar				(void);
int	_vTOS						(void);
int	_AKP						(void);
int	_getBoot					(void);
long	_LONG						(long adr);
int	_CARD						(long adr);
char	_BYTE						(long adr);


/*******************************************************************************
	EG_MOVE
*******************************************************************************/
void	_bmove					(long a,long,long l);

#endif
