/*******************************************************************************
	"Easy Gem" library Copyright (c)1995 by		Christophe BOYANIQUE
																29 rue de la Rpublique
																37230 FONDETTES
																FRANCE
												FidoNet:		2:320/107.16
												NeST:			90:800/1.16
												AtariNet:	51:901/1.16
										*small* mail at:	cb@spia.freenix.fr
********************************************************************************
	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License, or any later version.
	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.
	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	675 Mass Ave, Cambridge, MA 02139, USA.
********************************************************************************

	SEVERAL USEFULL FUNCTIONS

********************************************************************************
	TABULATION: 3 CARACTERES
*******************************************************************************/


#include		"EG_MAIN.H"

/*******************************************************************************
	FUNCTIONS
*******************************************************************************/
static void	_parINI		(char *tit,char *buf,char *p);
static void	_parINIwin	(char *tit,char *buf,char *p,window *win);


/*******************************************************************************
	VARIABLES
*******************************************************************************/
static int	his1,his2;
static long	badr,blen,boff;


/*******************************************************************************
	This function inits the variables
*******************************************************************************/
void _parDefault(char *name)
{
	FILE	*ha;
	long	Cook;
	int	i,j;
	char	txt[FILENAME_MAX+2];

	_cls((long)&glb,sizeof(GLB));
	_cls((long)&iglb,sizeof(iGLB));

	glb.aes.type	=	_app;
	glb.aes.menu	=	-1;
	glb.aes.desk	=	-1;
	glb.aes.icon	=	-1;

	glb.opt.Win_Num			=	0;
	glb.opt.Mem_Num			=	0;
	glb.opt.Mem_Len			=	50L;
	glb.opt.Mem_Boot			=	50L;
	glb.opt.Gem_font			=	1;
	glb.opt.Gem_Dfont			=	1;
	glb.opt.Gem_Ifont			=	1;
	glb.opt.Hlp_font			=	1;
	glb.opt.Hlp_Dfont			=	1;
	glb.opt.Hlp_Ifont			=	1;
	glb.opt.Hlp_Font_Size	=	12-3*glb.vdi.low;
	glb.opt.Hlp_Color_Text	=	BLACK;
	glb.opt.Hlp_Color_Back	=	WHITE;
	glb.opt.Flash_PopUp		=	1;
	glb.opt.Use_Font_Gem		=	1;
	glb.opt.Use_Font_Hlp		=	1;
	glb.opt.Log_File			=	1;
	glb.opt.Save_Config		=	1;
	glb.opt.Mouse_Form		=	1;
	glb.opt.Auto_Icon			=	1;
	glb.opt.Rev_Horiz			=	0;
	glb.opt.Rev_Verti			=	0;
	glb.opt.Big_Icon			=	0;
	iglb.aes.Big_Icon			=	0;
	glb.aes.ic_tree			=	-1;
	glb.aes.icon				=	WIC_DEF;

	glb.opt.Language	=	0;
	glb.opt.Av_Lang	=	L_FRENCH|L_ENGLISH;
	i=_AKP();
	if (i>=0x7F)		/*	Soft loaded table: -> _AKP cookie	*/
		i=(int)( ( _cookie('_AKP') & 0xFF00L )>>8 );
	switch	(i)
	{
		case	2:
		case	7:
			if (glb.opt.Av_Lang&L_FRENCH)
				glb.opt.Language=L_FRENCH;
			break;
		case	1:
		case	8:
			if (glb.opt.Av_Lang&L_DEUTSCH)
				glb.opt.Language=L_DEUTSCH;
			break;
		default:
			if (glb.opt.Av_Lang&L_ENGLISH)
				glb.opt.Language=L_ENGLISH;
			break;
	}
	if (!glb.opt.Language)
	{
		if (glb.opt.Av_Lang&L_FRENCH)
			glb.opt.Language=L_FRENCH;
		else
		if (glb.opt.Av_Lang&L_ENGLISH)
			glb.opt.Language=L_ENGLISH;
		else
		if (glb.opt.Av_Lang&L_DEUTSCH)
			glb.opt.Language=L_DEUTSCH;
	}

	sprintf(iglb.div.EG_Path,"%c:\\EGLIB.INI",65+_getBoot());
	ha=fopen(iglb.div.EG_Path,"r");
	if (ha!=NULL)
	{
		fgets(txt,FILENAME_MAX+2,ha);
		while (strchr(txt,'\n')!=NULL)
			*strchr(txt,'\n')=0;
		fclose(ha);
	}
	strcat(txt,"EGLIB.SYS\\");
	sprintf(iglb.div.EG_Path,"%sEGLIB122\\",txt);
	sprintf(iglb.div.SWP_Path,"%s",txt);

	sprintf(glb.opt.APP_Path,"%s%s\\",txt,name);
	sprintf(glb.opt.INI_File,"%s%s.INI",glb.opt.APP_Path,name);
	sprintf(glb.opt.LOG_File,"%s%s.LOG",glb.opt.APP_Path,name);
	strcpy(iglb.div.RSC_Path,name);

	Dgetpath(glb.div.pname,0);
	if (glb.div.pname[1]!=':')
	{
		glb.div.path[0]=65+Dgetdrv();
		glb.div.path[1]=':';
		glb.div.path[2]=0;
		strcat(glb.div.path,glb.div.pname);
		strcat(glb.div.path,"\\");				/*	this is the working and real path	*/
	}

	Cook=_cookie('_MCH');
	glb.div.MCH	=	(int)(Cook>>16);						/*	machine type		*/
	switch (glb.div.MCH)										/*	0:	STF				*/
	{																/*	1:	STE				*/
		case	2:		glb.div.MCH=3;							/*	2:	MegaSTE			*/
						break;									/*	3:	TT					*/
		case	3:		glb.div.MCH=4;							/*	4:	Falcon030		*/
						break;									/*	5:	???				*/
		case	1:		if ( (int)(Cook&0xFF)==16 )
						glb.div.MCH=2;
						break;
		default:		glb.div.MCH=5;
						break;
	}

	glb.div.TOS=_vTOS();

	for (i=0;i<=MAX_HIST;i++)
		for (j=0;j<=MAX_LEN_HIST;j++)
		{
			iglb.hlp.hist[i][j]=0;
			iglb.hlp.hist2[i][j]=0;
		}
	iglb.hlp.cu_hist=iglb.hlp.cp_hist=0;
	iglb.hlp.adtext=NO_MEMORY;
	iglb.hlp.adtaille=NO_MEMORY;
	iglb.hlp.adfile=NO_MEMORY;
}


/*******************************************************************************
	This function reads the INI file containing EGlib configuration
*******************************************************************************/
void _loadINI(int code)
{
	window	win;
	FILE		*ha;
	int		eof;
	char		tit[256],buf[256],*p,*q;

	ha=fopen(glb.opt.INI_File,"r");

	his1=his2=0;
	if (ha)
	{
		do
		{
			if ( !fgets(tit,256,ha) )
				goto fileclose;
		}	while (tit[0]!='[');
		q=tit+strlen(tit)-1;
		*q=0;
		do
		{
			if (tit[0]=='[')
			{
				_cls((long)&win,sizeof(window));
				do
				{
					eof=!fgets(buf,256,ha);
					q=buf+strlen(buf)-1;
					*q=0;
					p=strchr(buf,'=');
					if (p)
					{
						*p++=0;
						if (code)
							_parINIwin(tit,buf,p,&win);
						else
						{
							_parINI(tit,buf,p);
							if (glb.func.lFileIni)
								(*glb.func.lFileIni)(tit,buf,p);
						}
					}
				}	while (p);
				if (eof)
					goto fileclose;
				strcpy(tit,buf);
				while (tit[0]!='[')
				{
					if ( !fgets(tit,256,ha) )
						goto fileclose;
				}
				q=tit+strlen(tit)-1;
				*q=0;
			}
		}	while (ha);
fileclose:
		fclose(ha);
	}
	iglb.aes.x=-1;

	if (glb.opt.Language==L_FRENCH)
		strcpy(tit,"FRENCH\\");
	else
	if (glb.opt.Language==L_ENGLISH)
		strcpy(tit,"ENGLISH\\");
	else
	if (glb.opt.Language==L_DEUTSCH)
		strcpy(tit,"DEUTSCH\\");
	sprintf(glb.opt.HLP_Path,"%s%sHELP\\",glb.opt.APP_Path,tit);
	sprintf(glb.rsc.name,"%s%s%s.RSC",glb.opt.APP_Path,tit,iglb.div.RSC_Path);
	sprintf(iglb.div.HLP_Path,"%s%sHELP\\",iglb.div.EG_Path,tit);
	sprintf(iglb.div.RSC_Path,"%s%s",iglb.div.EG_Path,tit);
}


/*******************************************************************************
	This function inits the variables
*******************************************************************************/
static void _parINI(char *tit,char *buf,char *p)
{
	if (!strcmp(tit,"[System]"))
	{
		if (!strcmp(buf,"Swap"))
		{
			strcpy(glb.div.log,p);
			glb.div.log[strlen(p)-1L]='\0';
			if (_fexist(glb.div.log,FA_SUBDIR))
				strcpy(iglb.div.SWP_Path,p);
		}
		else
		if (!strcmp(buf,"Language"))
			glb.opt.Language=atoi(p);
		else
		if (!strcmp(buf,"Av_Lang"))
			glb.opt.Av_Lang=atoi(p);
	}
	else
	if (!strcmp(tit,"[Options]"))
	{
		if (!strcmp(buf,"Use_Font_Gem"))
			glb.opt.Use_Font_Gem=atoi(p);
		else
		if (!strcmp(buf,"Use_Font_Hlp"))
			glb.opt.Use_Font_Hlp=atoi(p);
		else
		if (!strcmp(buf,"Hlp_Font_Size"))
			glb.opt.Hlp_Font_Size=atoi(p);
		else
		if (!strcmp(buf,"Hlp_Color_Text"))
			glb.opt.Hlp_Color_Text=atoi(p);
		else
		if (!strcmp(buf,"Hlp_Color_Back"))
			glb.opt.Hlp_Color_Back=atoi(p);
		else
		if (!strcmp(buf,"Flash_PopUp"))
			glb.opt.Flash_PopUp=atoi(p);
		else
		if (!strcmp(buf,"Log_File"))
			glb.opt.Log_File=atoi(p);
		else
		if (!strcmp(buf,"Save_Config"))
			glb.opt.Save_Config=atoi(p);
		else
		if (!strcmp(buf,"Mouse_Form"))
			glb.opt.Mouse_Form=atoi(p);
		else
		if (!strcmp(buf,"Auto_Icon"))
			glb.opt.Auto_Icon=atoi(p);
		else
		if (!strcmp(buf,"Big_Icon"))
			iglb.aes.Big_Icon=glb.opt.Big_Icon=atoi(p);
		else
		if (!strcmp(buf,"Rev_Horiz"))
			glb.opt.Rev_Horiz=atoi(p);
		else
		if (!strcmp(buf,"Rev_Verti"))
			glb.opt.Rev_Verti=atoi(p);
		else
		if (!strcmp(buf,"Memory"))
			glb.opt.Mem_Boot=glb.opt.Mem_Len=atol(p);
	}
	else
	if (!strcmp(tit,"[Help]"))
	{
		if (!strcmp(buf,"cu_hist"))
			iglb.hlp.cu_hist=atoi(p);
		else
		if (!strcmp(buf,"cp_hist"))
			iglb.hlp.cp_hist=atoi(p);
		else
		if (!strcmp(buf,"File"))
			strcpy(iglb.hlp.hist[his1++],p);
		else
		if (!strcmp(buf,"Title"))
			strcpy(iglb.hlp.hist2[his2++],p);
	}
}
static void _parINIwin(char *tit,char *buf,char *p,window *win)
{
	int	i;

	if (!strcmp(tit,"[Fonts]"))
	{
		if (!strcmp(buf,"Gem_font"))
		{
			strncpy(iglb.fnt.Gem_font,p,32L);
			if (glb.vdi.gdos)
				for (i=1;i<=glb.vdi.nfont;i++)
					if (!strncmp(glb.font[i].name,p,32L))
						glb.opt.Gem_font=i;
		}
		else
		if (!strcmp(buf,"Gem_Dfont"))
		{
			strncpy(iglb.fnt.Gem_Dfont,p,32L);
			if (glb.vdi.gdos)
				for (i=1;i<=glb.vdi.nfont;i++)
					if (!strncmp(glb.font[i].name,p,32L))
						glb.opt.Gem_Dfont=i;
		}
		else
		if (!strcmp(buf,"Gem_Ifont"))
		{
			strncpy(iglb.fnt.Gem_Ifont,p,32L);
			if (glb.vdi.gdos)
				for (i=1;i<=glb.vdi.nfont;i++)
					if (!strncmp(glb.font[i].name,p,32L))
						glb.opt.Gem_Ifont=i;
		}
		else
		if (!strcmp(buf,"Hlp_font"))
		{
			strncpy(iglb.fnt.Hlp_font,p,32L);
			if (glb.vdi.gdos)
				for (i=1;i<=glb.vdi.nfont;i++)
					if (!strncmp(glb.font[i].name,p,32L))
						glb.opt.Hlp_font=i;
		}
		else
		if (!strcmp(buf,"Hlp_Dfont"))
		{
			strncpy(iglb.fnt.Hlp_Dfont,p,32L);
			if (glb.vdi.gdos)
				for (i=1;i<=glb.vdi.nfont;i++)
					if (!strncmp(glb.font[i].name,p,32L))
						glb.opt.Hlp_Dfont=i;
		}
		else
		if (!strcmp(buf,"Hlp_Ifont"))
		{
			strncpy(iglb.fnt.Hlp_Ifont,p,32L);
			if (glb.vdi.gdos)
				for (i=1;i<=glb.vdi.nfont;i++)
					if (!strncmp(glb.font[i].name,p,32L))
						glb.opt.Hlp_Ifont=i;
		}
		_myInitForm(FOPT|FLAGS15,FOPTFNT);
		_myInitForm(FOPT|FLAGS15,FOPTHLP);
		_myInitForm(FFNT|FLAGS15,FFNTGPOP);
		_myInitForm(FFNT|FLAGS15,FFNTGNOM);
		_myInitForm(FFNT|FLAGS15,FFNTGTYP);
		_myInitForm(FFNT|FLAGS15,FFNTHPOP);
		_myInitForm(FFNT|FLAGS15,FFNTHNOM);
		_myInitForm(FFNT|FLAGS15,FFNTHTYP);
	}
	else
	if (!strcmp(tit,"[WinHelp]"))
	{
		if (!strcmp(buf,"File"))
			strcpy(win->name,p);
		else
		if (!strcmp(buf,"xwind"))
			iglb.aes.x=(int)((float)atoi(p)*(float)glb.aes.wdesk/(float)1000);
		else
		if (!strcmp(buf,"ywind"))
			iglb.aes.y=(int)((float)atoi(p)*(float)glb.aes.hdesk/(float)1000);
		else
		if (!strcmp(buf,"wwind"))
			iglb.aes.w=(int)((float)atoi(p)*(float)glb.aes.wdesk/(float)1000);
		else
		if (!strcmp(buf,"hwind"))
		{
			iglb.aes.h=(int)((float)atoi(p)*(float)glb.aes.hdesk/(float)1000);
			_Aide();
			_clearAesBuffer();
			i=_winFindId(TW_HELP,0,TRUE);
			if (i!=-1)
			{
				_ouvreHelp(win->name);
				_clearAesBuffer();
				W[i].y=0;
				_winRedraw(i,0,0,0,0);
				_clearAesBuffer();
			}
		}
	}
	else
	if (!strcmp(tit,"[WinForm]"))
	{
		if (!strcmp(buf,"Name"))
			strcpy(win->name,p);
		else
		if (!strcmp(buf,"SName"))
			strcpy(win->sname,p);
		else
		if (!strcmp(buf,"Help"))
			strcpy(win->help,p);
		else
		if (!strcmp(buf,"Tree"))
			win->id=atoi(p);
		else
		if (!strcmp(buf,"PopUp"))
			win->popup=atoi(p);
		else
		if (!strcmp(buf,"Icon"))
			win->icon=atoi(p);
		else
		if (!strcmp(buf,"Tree_Icon"))
			win->ic_tree=atoi(p);
		else
		if (!strcmp(buf,"xwind"))
			iglb.aes.x=(int)((float)atoi(p)*(float)glb.aes.wdesk/(float)1000);
		else
		if (!strcmp(buf,"ywind"))
			iglb.aes.y=(int)((float)atoi(p)*(float)glb.aes.hdesk/(float)1000);
		else
		if (!strcmp(buf,"wwind"))
			iglb.aes.w=atoi(p);
		else
		if (!strcmp(buf,"hwind"))
			iglb.aes.h=atoi(p);
		else
		if (!strcmp(buf,"Small"))
		{
			i=_winForm(win->id,win->name,win->sname,win->help,win->popup,win->ic_tree,win->icon,0);
			_clearAesBuffer();
			if (atoi(p))
				_winSmall(i);
		}
	}
}


/*******************************************************************************
	This function writes the INI file containing EGlib configuration
*******************************************************************************/
void _saveINI()
{
	char		txt[128];
	OBJECT	*tree;
	int		i,ha;

	blen=mem.mfre;
	ha=_mAlloc(mem.mfre,MB_NOMOVE,1);
	if (ha==NO_MEMORY)
		return;
	badr=mem.bloc[ha].adr;
	boff=0L;

	_outINI("[System]\n");
	sprintf(txt,"EGlib_Version=%s\n",RELEASE);
	_outINI(txt);
	sprintf(txt,"Prog_Name=%s\n",glb.opt.Prog_Name);
	_outINI(txt);
	sprintf(txt,"Swap=%s\n",iglb.div.SWP_Path);
	_outINI(txt);
	sprintf(txt,"Language=%i\n",glb.opt.Language);
	_outINI(txt);
	sprintf(txt,"Av_Lang=%i\n",glb.opt.Av_Lang);
	_outINI(txt);
	_outINI("\n");

	_outINI("[Options]\n");
	sprintf(txt,"Hlp_Font_Size=%i\n",glb.opt.Hlp_Font_Size);
	_outINI(txt);
	sprintf(txt,"Hlp_Color_Text=%i\n",glb.opt.Hlp_Color_Text);
	_outINI(txt);
	sprintf(txt,"Hlp_Color_Back=%i\n",glb.opt.Hlp_Color_Back);
	_outINI(txt);
	sprintf(txt,"Flash_PopUp=%i\n",glb.opt.Flash_PopUp);
	_outINI(txt);
	sprintf(txt,"Use_Font_Gem=%i\n",glb.opt.Use_Font_Gem);
	_outINI(txt);
	sprintf(txt,"Use_Font_Hlp=%i\n",glb.opt.Use_Font_Hlp);
	_outINI(txt);
	sprintf(txt,"Log_File=%i\n",glb.opt.Log_File);
	_outINI(txt);
	sprintf(txt,"Save_Config=%i\n",glb.opt.Save_Config);
	_outINI(txt);
	sprintf(txt,"Mouse_Form=%i\n",glb.opt.Mouse_Form);
	_outINI(txt);
	sprintf(txt,"Auto_Icon=%i\n",glb.opt.Auto_Icon);
	_outINI(txt);
	sprintf(txt,"Big_Icon=%i\n",glb.opt.Big_Icon);
	_outINI(txt);
	sprintf(txt,"Rev_Horiz=%i\n",glb.opt.Rev_Horiz);
	_outINI(txt);
	sprintf(txt,"Rev_Verti=%i\n",glb.opt.Rev_Verti);
	_outINI(txt);
	sprintf(txt,"Memory=%li\n",glb.opt.Mem_Boot);
	_outINI(txt);
	_outINI("\n");

	_outINI("[Fonts]\n");
	sprintf(txt,"Gem_font=%s\n",iglb.fnt.Gem_font);
	_outINI(txt);
	sprintf(txt,"Gem_Dfont=%s\n",iglb.fnt.Gem_Dfont);
	_outINI(txt);
	sprintf(txt,"Gem_Ifont=%s\n",iglb.fnt.Gem_Ifont);
	_outINI(txt);
	sprintf(txt,"Hlp_font=%s\n",iglb.fnt.Hlp_font);
	_outINI(txt);
	sprintf(txt,"Hlp_Dfont=%s\n",iglb.fnt.Hlp_Dfont);
	_outINI(txt);
	sprintf(txt,"Hlp_Ifont=%s\n",iglb.fnt.Hlp_Ifont);
	_outINI(txt);
	_outINI("\n");

	_outINI("[Help]\n");
	sprintf(txt,"cu_hist=%i\n",iglb.hlp.cu_hist);
	_outINI(txt);
	sprintf(txt,"cp_hist=%i\n",iglb.hlp.cp_hist);
	_outINI(txt);
	for (i=0;i<=MAX_HIST;i++)
	{
		sprintf(txt,"File=%s\n",iglb.hlp.hist[i]);
		_outINI(txt);
	}
	for (i=0;i<=MAX_HIST;i++)
	{
		sprintf(txt,"Title=%s\n",iglb.hlp.hist2[i]);
		_outINI(txt);
	}
	_outINI("\n");

	if (glb.func.sFileIni)
		(*glb.func.sFileIni)();

	i=_winFindId(TW_HELP,0,TRUE);
	if (i!=-1)
	{
		_outINI("[WinHelp]\n");
		sprintf(txt,"File=%s\n",iglb.hlp.hist[iglb.hlp.cu_hist-1]);
		_outINI(txt);
		sprintf(txt,"xwind=%i\n",(int)((float)W[i].xwind*(float)1000/(float)glb.aes.wdesk));
		_outINI(txt);
		sprintf(txt,"ywind=%i\n",(int)((float)W[i].ywind*(float)1000/(float)glb.aes.hdesk));
		_outINI(txt);
		sprintf(txt,"wwind=%i\n",(int)((float)W[i].wwind*(float)1000/(float)glb.aes.wdesk));
		_outINI(txt);
		sprintf(txt,"hwind=%i\n",(int)((float)W[i].hwind*(float)1000/(float)glb.aes.hdesk));
		_outINI(txt);
		_outINI("\n");
	}

	for (i=0;i<glb.opt.Win_Num;i++)
		if ( (W[i].type==TW_FORM) && (W[i].handle>0) )
		{
			if (W[i].id&FLAGS15)
				tree=iglb.rsc.head.trindex[W[i].id&~FLAGS15];
			else
				tree=glb.rsc.head.trindex[W[i].id];
			if ( !(tree->ob_state&STATE9) )
			{
				_outINI("[WinForm]\n");
				sprintf(txt,"Name=%s\n",W[i].name);
				_outINI(txt);
				sprintf(txt,"SName=%s\n",W[i].sname);
				_outINI(txt);
				sprintf(txt,"Help=%s\n",W[i].help);
				_outINI(txt);
				sprintf(txt,"Tree=%i\n",W[i].id);
				_outINI(txt);
				sprintf(txt,"PopUp=%i\n",W[i].popup);
				_outINI(txt);
				if (W[i].smallflag==2)
				{
					sprintf(txt,"Tree_Icon=%i\n",iglb.aes.Old_Tree);
					_outINI(txt);
					sprintf(txt,"Icon=%i\n",iglb.aes.Old_Icon);
					_outINI(txt);
				}
				else
				{
					sprintf(txt,"Tree_Icon=%i\n",W[i].ic_tree);
					_outINI(txt);
					sprintf(txt,"Icon=%i\n",W[i].icon);
					_outINI(txt);
				}
				sprintf(txt,"xwind=%i\n",(int)((float)W[i].xwind*(float)1000/(float)glb.aes.wdesk));
				_outINI(txt);
				sprintf(txt,"ywind=%i\n",(int)((float)W[i].ywind*(float)1000/(float)glb.aes.hdesk));
				_outINI(txt);
				sprintf(txt,"wwind=%i\n",(int)((float)W[i].wwind*(float)1000/(float)glb.aes.wdesk));
				_outINI(txt);
				sprintf(txt,"hwind=%i\n",(int)((float)W[i].hwind*(float)1000/(float)glb.aes.hdesk));
				_outINI(txt);
				sprintf(txt,"Small=%i\n",W[i].smallflag==1);
				_outINI(txt);
				_outINI("\n");
			}
		}

	ha=(int)Fcreate(glb.opt.INI_File,0);
	if (ha>=0)
	{
		Fwrite(ha,boff,(void *)badr);
		Fclose(ha);
	}
	_mSpecFree(badr);
}

void _outINI(char *txt)
{
	char	*p;

	if (boff+2L*strlen(txt)<blen)
	{
		p=(char *)(badr+boff);
		while (*txt!=0)
		{
			if (*txt=='\n')
			{
				*p++='\r';
				*p++='\n';
				boff+=2L;
			}
			else
			{
				*p++=*txt;
				boff+=1L;
			}
			txt++;
		}
	}
}
