/*******************************************************************************
	"Easy Gem" library Copyright (c)1995 by		Christophe BOYANIQUE
																29 rue de la Rpublique
																37230 FONDETTES
																FRANCE
												FidoNet:		2:320/107.16
												NeST:			90:800/1.16
												AtariNet:	51:901/1.16
										*small* mail at:	cb@spia.freenix.fr
********************************************************************************
	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License, or any later version.
	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.
	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	675 Mass Ave, Cambridge, MA 02139, USA.
********************************************************************************

	USERDEFS OBJECTS HANDLING

********************************************************************************
	TABULATION: 3 CARACTERES
*******************************************************************************/


#include		"EG_MAIN.H"

/*******************************************************************************
	VARIABLES
*******************************************************************************/
static	int		dummy,i,state,type,tour,tHaut,tLarg;
static	int		lattr[6],fattr[6],tattr[10],extent[8];
static	int		tab_clip[4],bar[4],pxy[12];
static	int		eff,ind,pnt,vect,x,y,color,fill,htext;
static	uchar		car[2],*p,*trait;
static	UBLK		*user;
static	GRECT		my1,my2;
static	PARMBLK	pb;
static	int	col[16]	=	{	BLACK,		WHITE,		LCYAN,		LMAGENTA,
										LYELLOW,		LRED,			LBLUE,		LGREEN,
										LBLACK,		LWHITE,		CYAN,			MAGENTA,
										YELLOW,		RED,			BLUE,			GREEN			};


/*******************************************************************************
	G_BOXTEXT
*******************************************************************************/
int cdecl _drawBoxText(PARMBLK *parm)
{
	int			my3d=0;
	TEDINFO		*ted;

	tLarg=0;
	vqt_attributes(glb.vdi.ha,tattr);
   vqf_attributes(glb.vdi.ha,fattr);
	state=parm->pb_tree[parm->pb_obj].ob_state;
	type=(parm->pb_tree[parm->pb_obj].ob_type)>>8;
	eff=TXT_NORMAL;
	if (state&STATE15) 	eff+=TXT_THICKENED;
	if (state&STATE14)	eff+=TXT_LIGHT;
	if (state&STATE13)	eff+=TXT_UNDERLINED;
	vst_effects(glb.vdi.ha,eff);
	vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);
   vql_attributes(glb.vdi.ha,lattr);
	user=(UBLK *)(parm->pb_parm);
	ted=(TEDINFO *)user->spec;
	vsf_perimeter(glb.vdi.ha,FALSE);
	vswr_mode(glb.vdi.ha,MD_REPLACE);										/*	Mode remplacement		*/

	my1.g_x=parm->pb_x;
	my1.g_y=parm->pb_y;
	my1.g_w=parm->pb_w;
	my1.g_h=parm->pb_h;
	if (state&DRAW3D)
	{
		my1.g_x-=2;
		my1.g_y-=2;
		my1.g_w+=4;
		my1.g_h+=4;
	}
	if (ted->te_thickness<0)
	{
		my1.g_x+=ted->te_thickness;
		my1.g_y+=ted->te_thickness;
		my1.g_w-=2*ted->te_thickness;
		my1.g_h-=2*ted->te_thickness;
	}
	else
	{
		my1.g_x+=1;
		my1.g_y+=1;
		my1.g_w-=2;
		my1.g_h-=2;
	}
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);

	vsl_type(glb.vdi.ha,SOLID);
	vsl_width(glb.vdi.ha,1);
	vsl_color(glb.vdi.ha,((ted->te_color)>>12)&0xF);		/*	Couleur Cadre	*/
	for (i=0;i<abs(ted->te_thickness);i++)
	{
		pxy[0]=my1.g_x;
		pxy[1]=my1.g_y;
		pxy[2]=my1.g_x+my1.g_w-1;
		pxy[3]=pxy[1];
		pxy[4]=pxy[2];
		pxy[5]=my1.g_y+my1.g_h-1;
		pxy[6]=pxy[0];
		pxy[7]=pxy[5];
		pxy[8]=pxy[0];
		pxy[9]=pxy[1];
		v_pline(glb.vdi.ha,5,pxy);
		my1.g_x+=1;
		my1.g_y+=1;
		my1.g_w-=2;
		my1.g_h-=2;
	}
	vs_clip(glb.vdi.ha,FALSE,tab_clip);

	if ( (state&WHITEBAK) && (state&OUTLINED) )
	{
		my3d=1;
		my1.g_x=parm->pb_x-4;
		my1.g_y=parm->pb_y-4;
		my1.g_w=parm->pb_w+8;
		my1.g_h=parm->pb_h+8;
		my2.g_x=parm->pb_xc;
		my2.g_y=parm->pb_yc;
		my2.g_w=parm->pb_wc;
		my2.g_h=parm->pb_hc;
		_rcIntersect(&my1,&my2);
		tab_clip[0]=my2.g_x;
		tab_clip[1]=my2.g_y;
		tab_clip[2]=tab_clip[0]+my2.g_w-1;
		tab_clip[3]=tab_clip[1]+my2.g_h-1;
		vs_clip(glb.vdi.ha,TRUE,tab_clip);
		for (i=0;i<3;i++)
		{
			my1.g_x+=1;
			my1.g_y+=1;
			my1.g_w-=2;
			my1.g_h-=2;
			pxy[0]=my1.g_x;
			pxy[1]=my1.g_y+my1.g_h-1;
			pxy[2]=pxy[0];
			pxy[3]=my1.g_y;
			pxy[4]=my1.g_x+my1.g_w-1;
			pxy[5]=pxy[3];
			if (parm->pb_currstate&SELECTED)
				vsl_color(glb.vdi.ha,LBLACK);
			else
				vsl_color(glb.vdi.ha,WHITE);
			v_pline(glb.vdi.ha,3,pxy);
			pxy[0]=my1.g_x;
			pxy[1]=my1.g_y+my1.g_h-1;
			pxy[2]=my1.g_x+my1.g_w-1;
			pxy[3]=pxy[1];
			pxy[4]=pxy[2];
			pxy[5]=my1.g_y;
			if (parm->pb_currstate&SELECTED)
				vsl_color(glb.vdi.ha,WHITE);
			else
				vsl_color(glb.vdi.ha,LBLACK);
			v_pline(glb.vdi.ha,3,pxy);
		}
		vs_clip(glb.vdi.ha,FALSE,tab_clip);
	}
	if (state&DRAW3D)
	{
		my3d=1;
		my1.g_x=parm->pb_x-2;
		my1.g_y=parm->pb_y-2;
		my1.g_w=parm->pb_w+4;
		my1.g_h=parm->pb_h+4;
		if (ted->te_thickness>0)
		{
			my1.g_x+=1+ted->te_thickness;
			my1.g_y+=1+ted->te_thickness;
			my1.g_w-=2+2*ted->te_thickness;
			my1.g_h-=2+2*ted->te_thickness;
		}
		my2.g_x=parm->pb_xc;
		my2.g_y=parm->pb_yc;
		my2.g_w=parm->pb_wc;
		my2.g_h=parm->pb_hc;
		_rcIntersect(&my1,&my2);
		tab_clip[0]=my2.g_x;
		tab_clip[1]=my2.g_y;
		tab_clip[2]=tab_clip[0]+my2.g_w-1;
		tab_clip[3]=tab_clip[1]+my2.g_h-1;
		vs_clip(glb.vdi.ha,TRUE,tab_clip);
		pxy[0]=my1.g_x;
		pxy[1]=my1.g_y+my1.g_h-1;
		pxy[2]=pxy[0];
		pxy[3]=my1.g_y;
		pxy[4]=my1.g_x+my1.g_w-1;
		pxy[5]=pxy[3];
		if (parm->pb_currstate&SELECTED)
			vsl_color(glb.vdi.ha,BLACK);
		else
			vsl_color(glb.vdi.ha,WHITE);
		v_pline(glb.vdi.ha,3,pxy);
		pxy[0]=my1.g_x;
		pxy[1]=my1.g_y+my1.g_h-1;
		pxy[2]=my1.g_x+my1.g_w-1;
		pxy[3]=pxy[1];
		pxy[4]=pxy[2];
		pxy[5]=my1.g_y;
		if (parm->pb_currstate&SELECTED)
			vsl_color(glb.vdi.ha,WHITE);
		else
			vsl_color(glb.vdi.ha,LBLACK);
		v_pline(glb.vdi.ha,3,pxy);
		vs_clip(glb.vdi.ha,FALSE,tab_clip);
	}

	if (state&DRAW3D)
	{
		my1.g_x=parm->pb_x-1;
		my1.g_y=parm->pb_y-1;
		my1.g_w=parm->pb_w+2;
		my1.g_h=parm->pb_h+2;
	}
	else
	{
		my1.g_x=parm->pb_x;
		my1.g_y=parm->pb_y;
		my1.g_w=parm->pb_w;
		my1.g_h=parm->pb_h;
	}
	if (ted->te_thickness>0)
	{
		my1.g_x+=1+ted->te_thickness;
		my1.g_y+=1+ted->te_thickness;
		my1.g_w-=2+2*ted->te_thickness;
		my1.g_h-=2+2*ted->te_thickness;
	}
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	if ( (parm->pb_currstate&SELECTED) && (!my3d) )
		vsf_color(glb.vdi.ha,col[(ted->te_color)&0xF]);	/*	Couleur de fond	*/
	else
		vsf_color(glb.vdi.ha,(ted->te_color)&0xF);			/*	Couleur de fond	*/
	fill=((ted->te_color)>>4)&0x7;							/*	Motif					*/
	if (fill==0)
	{
		vsf_interior(glb.vdi.ha,FIS_SOLID);
		vsf_style(glb.vdi.ha,0);
		if (parm->pb_currstate&SELECTED)
			vsf_color(glb.vdi.ha,col[WHITE]);					/*	Couleur BLANCHE	*/
		else
			vsf_color(glb.vdi.ha,WHITE);							/*	Couleur BLANCHE	*/
	}
	else if (fill==7)
	{
		vsf_interior(glb.vdi.ha,FIS_SOLID);
		vsf_style(glb.vdi.ha,0);
	}
	else
	{
		vsf_interior(glb.vdi.ha,FIS_PATTERN);
		vsf_style(glb.vdi.ha,fill);
	}
	bar[0]=my1.g_x;
	bar[1]=my1.g_y;
	bar[2]=my1.g_x+my1.g_w-1;
	bar[3]=my1.g_y+my1.g_h-1;
	v_bar(glb.vdi.ha,bar);

	if (type!=0)
		pnt=type;
	else if (ted->te_font==3)
		pnt=10-2*glb.vdi.low;
	else
		pnt=8-glb.vdi.low;
	if (state&STATE10)
		ind=glb.opt.Gem_Dfont;
	else if (state&STATE8)
		ind=glb.opt.Gem_Ifont;
	else if (state&STATE11)
		ind=glb.opt.Hlp_Ifont;
	else if (state&STATE9)
		ind=1;
	else
		ind=glb.opt.Gem_font;
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,glb.font[ind].index);
	vect=glb.font[ind].name[32];
	if (vect)
		vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
	else
		vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
	if ( (parm->pb_currstate&SELECTED) && (!my3d) )
		color=col[((ted->te_color)&0xF00)>>8];
	else
		color=((ted->te_color)&0xF00)>>8;
	vst_color(glb.vdi.ha,color);
	if (ted->te_color&0x80)
		vswr_mode(glb.vdi.ha,MD_REPLACE);		/*	Mode remplacement	*/
	else
		vswr_mode(glb.vdi.ha,MD_TRANS);			/*	Mode transparent	*/
	p=(uchar *)ted->te_ptext;
	trait=(uchar *)strchr(ted->te_ptext,0x5B);
	if ( (trait!=NULL) && (trait!=p) )
	{
		*trait=0;
		if (vect)
			vqt_f_extent(glb.vdi.ha,(char *)p,extent);
		else
			vqt_extent(glb.vdi.ha,(char *)p,extent);
		*trait='[';
		trait++;
		tLarg=extent[2]-extent[6];
	}
	else
		trait=(uchar *)ted->te_ptext;
	if (vect)
		vqt_f_extent(glb.vdi.ha,(char *)trait,extent);
	else
		vqt_extent(glb.vdi.ha,(char *)trait,extent);
	tLarg+=extent[2]-extent[6];

	x=parm->pb_x;
	y=parm->pb_y;
	y+=parm->pb_h/2;
	y-=(extent[7]-extent[1])/2 ;
	y+=htext;

	if ( (my3d) && (parm->pb_currstate&SELECTED) )
	{
		x+=1;
		y+=1;
	}

	switch (ted->te_just)
	{
		case	1:		x+=(parm->pb_w-tLarg);		break;
		case	2:		x+=(parm->pb_w-tLarg)/2;	break;
	}

	trait=(uchar *)strchr(ted->te_ptext,0x5B);
	if (trait!=NULL)
	{
		*trait=0;
		if (vect)
		{
			vqt_f_extent(glb.vdi.ha,(char *)p,extent);
			v_ftext(glb.vdi.ha,x,y,(char *)p);
		}
		else
		{
			vqt_extent(glb.vdi.ha,(char *)p,extent);
			v_gtext(glb.vdi.ha,x,y,(char *)p);
		}
		*trait='[';
		trait++;
		if (*trait!=0)
		{
			x+=extent[2]-extent[0];
			car[0]=*trait;
			car[1]=0;
			vst_color(glb.vdi.ha,RED);
			if (vect)
			{
				v_ftext(glb.vdi.ha,x,y,(char *)car);
				vqt_f_extent(glb.vdi.ha,(char *)car,extent);
			}
			else
			{
				v_gtext(glb.vdi.ha,x,y,(char *)car);
				vqt_extent(glb.vdi.ha,(char *)car,extent);
			}
			vst_color(glb.vdi.ha,color);
			trait++;
		}
		if (*trait!=0)
		{
			x+=extent[2]-extent[0];
			if (vect)
				v_ftext(glb.vdi.ha,x,y,(char *)trait);
			else
				v_gtext(glb.vdi.ha,x,y,(char *)trait);
		}
	}
	else
		if (vect)
			v_ftext(glb.vdi.ha,x,y,ted->te_ptext);
		else
			v_gtext(glb.vdi.ha,x,y,ted->te_ptext);
	vs_clip(glb.vdi.ha,FALSE,tab_clip);
	vsf_interior(glb.vdi.ha,fattr[2]);
	vsf_style(glb.vdi.ha,fattr[0]);
	vsf_perimeter(glb.vdi.ha,fattr[4]);
	vsl_type(glb.vdi.ha,lattr[0]);
	vsl_color(glb.vdi.ha,lattr[1]);
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,tattr[0]);
	if ( (state&WHITEBAK) && (state&OUTLINED) )
		return parm->pb_currstate&~(SELECTED|OUTLINED|WHITEBAK|DRAW3D);
	else
		return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	G_FBOXTEXT
*******************************************************************************/
int cdecl _drawFBoxText(PARMBLK *parm)
{
	int			my3d=0;
	TEDINFO		*ted;

	tLarg=0;
	vqt_attributes(glb.vdi.ha,tattr);
   vqf_attributes(glb.vdi.ha,fattr);
	state=parm->pb_tree[parm->pb_obj].ob_state;
	type=(parm->pb_tree[parm->pb_obj].ob_type)>>8;
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);
   vql_attributes(glb.vdi.ha,lattr);
	user=(UBLK *)(parm->pb_parm);
	ted=(TEDINFO *)user->spec;
	vsf_perimeter(glb.vdi.ha,FALSE);
	vswr_mode(glb.vdi.ha,MD_REPLACE);	/*	Mode remplacement		*/

	my1.g_x=parm->pb_x;
	my1.g_y=parm->pb_y;
	my1.g_w=parm->pb_w;
	my1.g_h=parm->pb_h;
	if (state&DRAW3D)
	{
		my1.g_x-=2;
		my1.g_y-=2;
		my1.g_w+=4;
		my1.g_h+=4;
	}
	if (ted->te_thickness<0)
	{
		my1.g_x+=ted->te_thickness;
		my1.g_y+=ted->te_thickness;
		my1.g_w-=2*ted->te_thickness;
		my1.g_h-=2*ted->te_thickness;
	}
	else
	{
		my1.g_x+=1;
		my1.g_y+=1;
		my1.g_w-=2;
		my1.g_h-=2;
	}
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);

	vsl_type(glb.vdi.ha,SOLID);
	vsl_width(glb.vdi.ha,1);
	vsl_color(glb.vdi.ha,((ted->te_color)>>12)&0xF);	/*	Couleur Cadre	*/
	for (i=0;i<abs(ted->te_thickness);i++)
	{
		pxy[0]=my1.g_x;
		pxy[1]=my1.g_y;
		pxy[2]=my1.g_x+my1.g_w-1;
		pxy[3]=pxy[1];
		pxy[4]=pxy[2];
		pxy[5]=my1.g_y+my1.g_h-1;
		pxy[6]=pxy[0];
		pxy[7]=pxy[5];
		pxy[8]=pxy[0];
		pxy[9]=pxy[1];
		v_pline(glb.vdi.ha,5,pxy);
		my1.g_x+=1;
		my1.g_y+=1;
		my1.g_w-=2;
		my1.g_h-=2;
	}
	vs_clip(glb.vdi.ha,FALSE,tab_clip);

	if ( (state&WHITEBAK) && (state&OUTLINED) )
	{
		my3d=1;
		my1.g_x=parm->pb_x-4;
		my1.g_y=parm->pb_y-4;
		my1.g_w=parm->pb_w+8;
		my1.g_h=parm->pb_h+8;
		my2.g_x=parm->pb_xc;
		my2.g_y=parm->pb_yc;
		my2.g_w=parm->pb_wc;
		my2.g_h=parm->pb_hc;
		_rcIntersect(&my1,&my2);
		tab_clip[0]=my2.g_x;
		tab_clip[1]=my2.g_y;
		tab_clip[2]=tab_clip[0]+my2.g_w-1;
		tab_clip[3]=tab_clip[1]+my2.g_h-1;
		vs_clip(glb.vdi.ha,TRUE,tab_clip);
		for (i=0;i<3;i++)
		{
			my1.g_x+=1;
			my1.g_y+=1;
			my1.g_w-=2;
			my1.g_h-=2;
			pxy[0]=my1.g_x;
			pxy[1]=my1.g_y+my1.g_h-1;
			pxy[2]=pxy[0];
			pxy[3]=my1.g_y;
			pxy[4]=my1.g_x+my1.g_w-1;
			pxy[5]=pxy[3];
			if (parm->pb_currstate&SELECTED)
				vsl_color(glb.vdi.ha,LBLACK);
			else
				vsl_color(glb.vdi.ha,WHITE);
			v_pline(glb.vdi.ha,3,pxy);
			pxy[0]=my1.g_x;
			pxy[1]=my1.g_y+my1.g_h-1;
			pxy[2]=my1.g_x+my1.g_w-1;
			pxy[3]=pxy[1];
			pxy[4]=pxy[2];
			pxy[5]=my1.g_y;
			if (parm->pb_currstate&SELECTED)
				vsl_color(glb.vdi.ha,WHITE);
			else
				vsl_color(glb.vdi.ha,LBLACK);
			v_pline(glb.vdi.ha,3,pxy);
		}
		vs_clip(glb.vdi.ha,FALSE,tab_clip);
	}
	if (state&DRAW3D)
	{
		my3d=1;
		my1.g_x=parm->pb_x-2;
		my1.g_y=parm->pb_y-2;
		my1.g_w=parm->pb_w+4;
		my1.g_h=parm->pb_h+4;
		if (ted->te_thickness>0)
		{
			my1.g_x+=1+ted->te_thickness;
			my1.g_y+=1+ted->te_thickness;
			my1.g_w-=2+2*ted->te_thickness;
			my1.g_h-=2+2*ted->te_thickness;
		}
		my2.g_x=parm->pb_xc;
		my2.g_y=parm->pb_yc;
		my2.g_w=parm->pb_wc;
		my2.g_h=parm->pb_hc;
		_rcIntersect(&my1,&my2);
		tab_clip[0]=my2.g_x;
		tab_clip[1]=my2.g_y;
		tab_clip[2]=tab_clip[0]+my2.g_w-1;
		tab_clip[3]=tab_clip[1]+my2.g_h-1;
		vs_clip(glb.vdi.ha,TRUE,tab_clip);
		pxy[0]=my1.g_x;
		pxy[1]=my1.g_y+my1.g_h-1;
		pxy[2]=pxy[0];
		pxy[3]=my1.g_y;
		pxy[4]=my1.g_x+my1.g_w-1;
		pxy[5]=pxy[3];
		if (parm->pb_currstate&SELECTED)
			vsl_color(glb.vdi.ha,BLACK);
		else
			vsl_color(glb.vdi.ha,WHITE);
		v_pline(glb.vdi.ha,3,pxy);
		pxy[0]=my1.g_x;
		pxy[1]=my1.g_y+my1.g_h-1;
		pxy[2]=my1.g_x+my1.g_w-1;
		pxy[3]=pxy[1];
		pxy[4]=pxy[2];
		pxy[5]=my1.g_y;
		if (parm->pb_currstate&SELECTED)
			vsl_color(glb.vdi.ha,WHITE);
		else
			vsl_color(glb.vdi.ha,LBLACK);
		v_pline(glb.vdi.ha,3,pxy);
		vs_clip(glb.vdi.ha,FALSE,tab_clip);
	}

	if (state&DRAW3D)
	{
		my1.g_x=parm->pb_x-1;
		my1.g_y=parm->pb_y-1;
		my1.g_w=parm->pb_w+2;
		my1.g_h=parm->pb_h+2;
	}
	else
	{
		my1.g_x=parm->pb_x;
		my1.g_y=parm->pb_y;
		my1.g_w=parm->pb_w;
		my1.g_h=parm->pb_h;
	}
	if (ted->te_thickness>0)
	{
		my1.g_x+=1+ted->te_thickness;
		my1.g_y+=1+ted->te_thickness;
		my1.g_w-=2+2*ted->te_thickness;
		my1.g_h-=2+2*ted->te_thickness;
	}
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	if ( (parm->pb_currstate&SELECTED) && (!my3d) )
		vsf_color(glb.vdi.ha,col[(ted->te_color)&0xF]);	/*	Couleur de fond	*/
	else
		vsf_color(glb.vdi.ha,(ted->te_color)&0xF);			/*	Couleur de fond	*/
	fill=((ted->te_color)>>4)&0x7;							/*	Motif					*/
	if (fill==0)
	{
		vsf_interior(glb.vdi.ha,FIS_SOLID);
		vsf_style(glb.vdi.ha,0);
		if (parm->pb_currstate&SELECTED)
			vsf_color(glb.vdi.ha,col[WHITE]);					/*	Couleur BLANCHE	*/
		else
			vsf_color(glb.vdi.ha,WHITE);							/*	Couleur BLANCHE	*/
	}
	else if (fill==7)
	{
		vsf_interior(glb.vdi.ha,FIS_SOLID);
		vsf_style(glb.vdi.ha,0);
	}
	else
	{
		vsf_interior(glb.vdi.ha,FIS_PATTERN);
		vsf_style(glb.vdi.ha,fill);
	}
	bar[0]=my1.g_x;
	bar[1]=my1.g_y;
	bar[2]=my1.g_x+my1.g_w-1;
	bar[3]=my1.g_y+my1.g_h-1;
	v_bar(glb.vdi.ha,bar);

	if (type!=0)
		pnt=type;
	else if (ted->te_font==3)
		pnt=10-2*glb.vdi.low;
	else
		pnt=8-glb.vdi.low;
	if (state&STATE10)
		ind=glb.opt.Gem_Dfont;
	else if (state&STATE8)
		ind=glb.opt.Gem_Ifont;
	else if (state&STATE11)
		ind=glb.opt.Hlp_Ifont;
	else if (state&STATE9)
		ind=1;
	else
		ind=glb.opt.Gem_font;
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,glb.font[ind].index);
	vect=glb.font[ind].name[32];
	if (vect)
		vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
	else
		vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
	if ( (parm->pb_currstate&SELECTED) && (!my3d) )
		color=col[((ted->te_color)&0xF00)>>8];
	else
		color=((ted->te_color)&0xF00)>>8;
	vst_color(glb.vdi.ha,color);
	if (ted->te_color&0x80)
		vswr_mode(glb.vdi.ha,MD_REPLACE);	/*	Mode remplacement	*/
	else
		vswr_mode(glb.vdi.ha,MD_TRANS);		/*	Mode transparent	*/

	vqt_extent(glb.vdi.ha,ted->te_ptext,extent);
	x=parm->pb_x;
	y=parm->pb_y;
	y+=parm->pb_h/2;
	y-=(extent[7]-extent[1])/2 ;
	y+=htext;

	p=(uchar *)ted->te_ptmplt;
	trait=(uchar *)ted->te_ptext;
	car[1]=0;
	while (*p!=0)
	{
		if (*p=='_')
		{
/*			if (*trait==0)
				car[0]='_';
			else*/ if (*trait<=' ')
				car[0]=' ';
			else
				car[0]=*trait;
			if (*trait!=0)
				trait++;
		}
		else
			car[0]=*p;
		if (vect)
		{
			vqt_f_extent(glb.vdi.ha,(char *)car,extent);
			v_ftext(glb.vdi.ha,x,y,(char *)car);
		}
		else
		{
			vqt_extent(glb.vdi.ha,(char *)car,extent);
			v_gtext(glb.vdi.ha,x,y,(char *)car);
		}
		x+=extent[2]-extent[6];
		p++;
	}
	vs_clip(glb.vdi.ha,FALSE,tab_clip);
	vsf_interior(glb.vdi.ha,fattr[2]);
	vsf_style(glb.vdi.ha,fattr[0]);
	vsf_perimeter(glb.vdi.ha,fattr[4]);
	vsl_type(glb.vdi.ha,lattr[0]);
	vsl_color(glb.vdi.ha,lattr[1]);
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,tattr[0]);
	if ( (state&WHITEBAK) && (state&OUTLINED) )
		return parm->pb_currstate&~(SELECTED|OUTLINED|WHITEBAK|DRAW3D);
	else
		return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	G_BOX, G_IBOX, G_BOXCHAR
*******************************************************************************/
int cdecl _drawBox(PARMBLK *parm)
{
	int			my3d=0;
	bfobspec		*info;

   vqf_attributes(glb.vdi.ha,fattr);
   vql_attributes(glb.vdi.ha,lattr);
	state=parm->pb_tree[parm->pb_obj].ob_state;
	type=(parm->pb_tree[parm->pb_obj].ob_type)>>8;
	user=(UBLK *)(parm->pb_parm);
	info=(bfobspec *)&user->spec;
	vsf_perimeter(glb.vdi.ha,FALSE);
	vswr_mode(glb.vdi.ha,MD_REPLACE);	/*	Mode remplacement	*/
	my1.g_x=parm->pb_x;
	my1.g_y=parm->pb_y;
	my1.g_w=parm->pb_w;
	my1.g_h=parm->pb_h;
	if (state&DRAW3D)
	{
		my1.g_x-=2;
		my1.g_y-=2;
		my1.g_w+=4;
		my1.g_h+=4;
	}
	if (info->framesize<0)
	{
		my1.g_x+=info->framesize;
		my1.g_y+=info->framesize;
		my1.g_w-=2*info->framesize;
		my1.g_h-=2*info->framesize;
	}
	else
	{
		my1.g_x+=1;
		my1.g_y+=1;
		my1.g_w-=2;
		my1.g_h-=2;
	}
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);

	vsl_type(glb.vdi.ha,SOLID);
	vsl_width(glb.vdi.ha,1);
	vsl_color(glb.vdi.ha,BLACK);
	for (i=0;i<abs(info->framesize);i++)
	{
		pxy[0]=my1.g_x;
		pxy[1]=my1.g_y;
		pxy[2]=my1.g_x+my1.g_w-1;
		pxy[3]=pxy[1];
		pxy[4]=pxy[2];
		pxy[5]=my1.g_y+my1.g_h-1;
		pxy[6]=pxy[0];
		pxy[7]=pxy[5];
		pxy[8]=pxy[0];
		pxy[9]=pxy[1];
		v_pline(glb.vdi.ha,5,pxy);
		my1.g_x+=1;
		my1.g_y+=1;
		my1.g_w-=2;
		my1.g_h-=2;
	}
	vs_clip(glb.vdi.ha,FALSE,tab_clip);

	if ( (state&WHITEBAK) && (state&OUTLINED) )
	{
		my3d=1;
		my1.g_x=parm->pb_x-4;
		my1.g_y=parm->pb_y-4;
		my1.g_w=parm->pb_w+8;
		my1.g_h=parm->pb_h+8;
		my2.g_x=parm->pb_xc;
		my2.g_y=parm->pb_yc;
		my2.g_w=parm->pb_wc;
		my2.g_h=parm->pb_hc;
		_rcIntersect(&my1,&my2);
		tab_clip[0]=my2.g_x;
		tab_clip[1]=my2.g_y;
		tab_clip[2]=tab_clip[0]+my2.g_w-1;
		tab_clip[3]=tab_clip[1]+my2.g_h-1;
		vs_clip(glb.vdi.ha,TRUE,tab_clip);
		for (i=0;i<3;i++)
		{
			my1.g_x+=1;
			my1.g_y+=1;
			my1.g_w-=2;
			my1.g_h-=2;
			pxy[0]=my1.g_x;
			pxy[1]=my1.g_y+my1.g_h-1;
			pxy[2]=pxy[0];
			pxy[3]=my1.g_y;
			pxy[4]=my1.g_x+my1.g_w-1;
			pxy[5]=pxy[3];
			if (parm->pb_currstate&SELECTED)
				vsl_color(glb.vdi.ha,LBLACK);
			else
				vsl_color(glb.vdi.ha,WHITE);
			v_pline(glb.vdi.ha,3,pxy);
			pxy[0]=my1.g_x;
			pxy[1]=my1.g_y+my1.g_h-1;
			pxy[2]=my1.g_x+my1.g_w-1;
			pxy[3]=pxy[1];
			pxy[4]=pxy[2];
			pxy[5]=my1.g_y;
			if (parm->pb_currstate&SELECTED)
				vsl_color(glb.vdi.ha,WHITE);
			else
				vsl_color(glb.vdi.ha,LBLACK);
			v_pline(glb.vdi.ha,3,pxy);
		}
		vs_clip(glb.vdi.ha,FALSE,tab_clip);
	}
	else if (state&DRAW3D)
	{
		my3d=1;
		my1.g_x=parm->pb_x-2;
		my1.g_y=parm->pb_y-2;
		my1.g_w=parm->pb_w+4;
		my1.g_h=parm->pb_h+4;
		if (info->framesize>0)
		{
			my1.g_x+=1+info->framesize;
			my1.g_y+=1+info->framesize;
			my1.g_w-=2+2*info->framesize;
			my1.g_h-=2+2*info->framesize;
		}
		my2.g_x=parm->pb_xc;
		my2.g_y=parm->pb_yc;
		my2.g_w=parm->pb_wc;
		my2.g_h=parm->pb_hc;
		_rcIntersect(&my1,&my2);
		tab_clip[0]=my2.g_x;
		tab_clip[1]=my2.g_y;
		tab_clip[2]=tab_clip[0]+my2.g_w-1;
		tab_clip[3]=tab_clip[1]+my2.g_h-1;
		vs_clip(glb.vdi.ha,TRUE,tab_clip);
		pxy[0]=my1.g_x;
		pxy[1]=my1.g_y+my1.g_h-1;
		pxy[2]=pxy[0];
		pxy[3]=my1.g_y;
		pxy[4]=my1.g_x+my1.g_w-1;
		pxy[5]=pxy[3];
		if (parm->pb_currstate&SELECTED)
			vsl_color(glb.vdi.ha,BLACK);
		else
			vsl_color(glb.vdi.ha,WHITE);
		v_pline(glb.vdi.ha,3,pxy);
		pxy[0]=my1.g_x;
		pxy[1]=my1.g_y+my1.g_h-1;
		pxy[2]=my1.g_x+my1.g_w-1;
		pxy[3]=pxy[1];
		pxy[4]=pxy[2];
		pxy[5]=my1.g_y;
		if (parm->pb_currstate&SELECTED)
			vsl_color(glb.vdi.ha,WHITE);
		else
			vsl_color(glb.vdi.ha,LBLACK);
		v_pline(glb.vdi.ha,3,pxy);
		vs_clip(glb.vdi.ha,FALSE,tab_clip);
	}

	if (user->type!=G_IBOX)
	{
		if (state&DRAW3D)
		{
			my1.g_x=parm->pb_x-1;
			my1.g_y=parm->pb_y-1;
			my1.g_w=parm->pb_w+2;
			my1.g_h=parm->pb_h+2;
		}
		else
		{
			my1.g_x=parm->pb_x;
			my1.g_y=parm->pb_y;
			my1.g_w=parm->pb_w;
			my1.g_h=parm->pb_h;
		}
		if (info->framesize>0)
		{
			my1.g_x+=1+info->framesize;
			my1.g_y+=1+info->framesize;
			my1.g_w-=2+2*info->framesize;
			my1.g_h-=2+2*info->framesize;
		}
		my2.g_x=parm->pb_xc;
		my2.g_y=parm->pb_yc;
		my2.g_w=parm->pb_wc;
		my2.g_h=parm->pb_hc;
		_rcIntersect(&my1,&my2);
		tab_clip[0]=my2.g_x;
		tab_clip[1]=my2.g_y;
		tab_clip[2]=tab_clip[0]+my2.g_w-1;
		tab_clip[3]=tab_clip[1]+my2.g_h-1;
		vs_clip(glb.vdi.ha,TRUE,tab_clip);
		if ( (parm->pb_currstate&SELECTED) && (!my3d) )
			vsf_color(glb.vdi.ha,col[info->interiorcol]);	/*	Couleur de fond	*/
		else
			vsf_color(glb.vdi.ha,info->interiorcol);			/*	Couleur de fond	*/
		fill=info->fillpattern;									/*	Motif					*/
		if (fill==0)
		{
			vsf_interior(glb.vdi.ha,FIS_SOLID);
			vsf_style(glb.vdi.ha,0);
			if (parm->pb_currstate&SELECTED)
				vsf_color(glb.vdi.ha,col[WHITE]);				/*	Couleur BLANCHE	*/
			else
				vsf_color(glb.vdi.ha,WHITE);						/*	Couleur BLANCHE	*/
		}
		else if (fill==7)
		{
			vsf_interior(glb.vdi.ha,FIS_SOLID);
			vsf_style(glb.vdi.ha,0);
		}
		else
		{
			vsf_interior(glb.vdi.ha,FIS_PATTERN);
			vsf_style(glb.vdi.ha,fill);
		}
		bar[0]=my1.g_x;
		bar[1]=my1.g_y;
		bar[2]=my1.g_x+my1.g_w-1;
		bar[3]=my1.g_y+my1.g_h-1;
		v_bar(glb.vdi.ha,bar);

		if (user->type==G_BOXCHAR)
		{
			car[0]=info->character;
			car[1]=0;
			eff=TXT_NORMAL;
			if (state&STATE15) 	eff+=TXT_THICKENED;
			if (state&STATE14)	eff+=TXT_LIGHT;
			if (state&STATE13)	eff+=TXT_UNDERLINED;
			vst_effects(glb.vdi.ha,eff);
			vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);

			if (type!=0)
				pnt=type;
			else
				pnt=10-2*glb.vdi.low;
			if (state&STATE10)
				ind=glb.opt.Gem_Dfont;
			else if (state&STATE8)
				ind=glb.opt.Gem_Ifont;
			else if (state&STATE11)
				ind=glb.opt.Hlp_Ifont;
			else if (state&STATE9)
				ind=1;
			else
				ind=glb.opt.Gem_font;
			if (glb.vdi.gdos)
				vst_font(glb.vdi.ha,glb.font[ind].index);
			vect=glb.font[ind].name[32];
			if (vect)
				vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
			else
				vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
			if ( (parm->pb_currstate&SELECTED) && (!my3d) )
				vst_color(glb.vdi.ha,col[info->textcol]);
			else
				vst_color(glb.vdi.ha,info->textcol);
			if (info->textmode)
				vswr_mode(glb.vdi.ha,MD_REPLACE);	/*	Mode remplacement	*/
			else
				vswr_mode(glb.vdi.ha,MD_TRANS);		/*	Mode transparent	*/

			if (vect)
				vqt_f_extent(glb.vdi.ha,(char *)car,extent);
			else
				vqt_extent(glb.vdi.ha,(char *)car,extent);
			tLarg=extent[2]-extent[6];

			x=parm->pb_x;
			y=parm->pb_y;
			y+=parm->pb_h/2;
			y-=(extent[7]-extent[1])/2 ;
			y+=htext;

			if ( (my3d) && (parm->pb_currstate&SELECTED) )
			{
				x+=1;
				y+=1;
			}
			x+=(parm->pb_w-tLarg)/2;

			if (vect)
				v_ftext(glb.vdi.ha,x,y,(char *)car);
			else
				v_gtext(glb.vdi.ha,x,y,(char *)car);
		}
		vs_clip(glb.vdi.ha,FALSE,tab_clip);
	}
	vsf_interior(glb.vdi.ha,fattr[2]);
	vsf_style(glb.vdi.ha,fattr[0]);
	vsf_perimeter(glb.vdi.ha,fattr[4]);
	vsl_type(glb.vdi.ha,lattr[0]);
	vsl_color(glb.vdi.ha,lattr[1]);

	if ( (state&WHITEBAK) && (state&OUTLINED) )
		return parm->pb_tree[parm->pb_obj].ob_state&~(SELECTED|OUTLINED|WHITEBAK|DRAW3D);
	else
		return parm->pb_tree[parm->pb_obj].ob_state&~(SELECTED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	G_BUTTON (3D)
*******************************************************************************/
int cdecl _draw3dButton(PARMBLK *parm)
{
	tLarg=0;
   vqt_attributes(glb.vdi.ha,tattr);
   vqf_attributes(glb.vdi.ha,fattr);
   vql_attributes(glb.vdi.ha,lattr);
	state=parm->pb_tree[parm->pb_obj].ob_state;
	type=(parm->pb_tree[parm->pb_obj].ob_type)>>8;
	eff=TXT_NORMAL;
	if (state&STATE15) 	eff+=TXT_THICKENED;
	if (state&STATE14)	eff+=TXT_LIGHT;
	vst_effects(glb.vdi.ha,eff);
	vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);
	user=(UBLK *)(parm->pb_parm);

	if (type!=0)
		pnt=type;
	else
		pnt=10-2*glb.vdi.low;
	if (state&STATE10)
		ind=glb.opt.Gem_Dfont;
	else if (state&STATE8)
		ind=glb.opt.Gem_Ifont;
	else if (state&STATE11)
		ind=glb.opt.Hlp_Ifont;
	else if (state&STATE9)
		ind=1;
	else
		ind=glb.opt.Gem_font;
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,glb.font[ind].index);
	vect=glb.font[ind].name[32];
	if (vect)
		vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
	else
	vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);

	tour=1;
	if (parm->pb_tree[parm->pb_obj].ob_flags&EXIT)		tour+=1;
	if (parm->pb_tree[parm->pb_obj].ob_flags&DEFAULT)	tour+=1;

	if (vect)
		vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
	else
		vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
	tHaut=extent[7]-extent[1]+4-parm->pb_h;
	if (tHaut>0)
		tHaut/=2;
	else
		tHaut=0;
	parm->pb_y-=tHaut;
	parm->pb_h+=2*tHaut;

	my1.g_x=parm->pb_x-tour;
	my1.g_y=parm->pb_y-tour;
	my1.g_w=parm->pb_w+2*tour;
	my1.g_h=parm->pb_h+2*tour;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	bar[0]=my1.g_x;
	bar[1]=my1.g_y;
	bar[2]=bar[0]+my1.g_w-1;
	bar[3]=bar[1]+my1.g_h-1;

	vswr_mode(glb.vdi.ha,MD_REPLACE);			/*	Mode remplacement		*/
	vsf_perimeter(glb.vdi.ha,TRUE);				/*	Primtre				*/
	vsf_interior(glb.vdi.ha,FIS_HOLLOW);		/*	Cadre vide				*/
	vsf_color(glb.vdi.ha,BLACK);					/*	Couleur: Noir			*/
	v_bar(glb.vdi.ha,bar);							/*	Trac du cadre noir	*/
	vsf_perimeter(glb.vdi.ha,FALSE);			/*	Pas de primtre		*/
	vsf_interior(glb.vdi.ha,FIS_SOLID);		/*	Intrieur plein		*/
	vsf_style(glb.vdi.ha,0);						/*	Cadre plein				*/
	vsf_color(glb.vdi.ha,LWHITE);				/*	Couleur: Gris clair	*/
	bar[0]+=1;
	bar[1]+=1;
	bar[2]-=1;
	bar[3]-=1;
	v_bar(glb.vdi.ha,bar);							/*	Trac du cadre	*/

	pxy[0]=bar[0];
	pxy[1]=bar[3];
	pxy[2]=bar[2];
	pxy[3]=bar[3];
	pxy[4]=bar[2];
	pxy[5]=bar[1];
	vsl_type(glb.vdi.ha,SOLID);
	vsl_width(glb.vdi.ha,1);
	if (parm->pb_currstate&SELECTED)
		vsl_color(glb.vdi.ha,WHITE);				/*	Couleur: Blanc	*/
	else
		vsl_color(glb.vdi.ha,LBLACK);			/*	Couleur: Gris fonc	*/
	for (i=0;i<tour;i++)
	{
		v_pline(glb.vdi.ha,3,pxy);				/*	Ligne	*/
		pxy[0]+=1;
		pxy[1]-=1;
		pxy[2]-=1;
		pxy[3]-=1;
		pxy[4]-=1;
		pxy[5]+=1;
	}
	pxy[0]=bar[0];
	pxy[1]=bar[3];
	pxy[2]=bar[0];
	pxy[3]=bar[1];
	pxy[4]=bar[2];
	pxy[5]=bar[1];
	if (parm->pb_currstate&SELECTED)
		vsl_color(glb.vdi.ha,LBLACK);	/*	Couleur: Gris fonc	*/
	else
		vsl_color(glb.vdi.ha,WHITE);		/*	Couleur: Blanc	*/
	for (i=0;i<tour;i++)
	{
		v_pline(glb.vdi.ha,3,pxy);		/*	Ligne	*/
		pxy[0]+=1;
		pxy[1]-=1;
		pxy[2]+=1;
		pxy[3]+=1;
		pxy[4]-=1;
		pxy[5]+=1;
	}
	vs_clip(glb.vdi.ha,FALSE,tab_clip);

	my1.g_x=parm->pb_x+1;
	my1.g_y=parm->pb_y+1;
	my1.g_w=parm->pb_w-2;
	my1.g_h=parm->pb_h-2;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	vswr_mode(glb.vdi.ha,MD_TRANS);

	trait=(uchar *)strchr((char *)user->spec,0x5B);
	if ( (trait!=NULL) && (trait!=(uchar *)user->spec) )
	{
		*trait=0;
		if (vect)
			vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
		else
			vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
		*trait='[';
		trait++;
		tLarg=extent[2]-extent[6];
	}
	else
		trait=(uchar *)user->spec;
	if (vect)
		vqt_f_extent(glb.vdi.ha,(char *)trait,extent);
	else
		vqt_extent(glb.vdi.ha,(char *)trait,extent);
	tLarg+=extent[2]-extent[6];

	y=parm->pb_y-1;
	y+=parm->pb_h/2;
	y-=(extent[7]-extent[1])/2 ;
	y+=htext;
	if (parm->pb_currstate&SELECTED)
		y+=1;
	for (i=0;i<2;i++)
	{
		if (i)
			vst_color(glb.vdi.ha,BLACK);
		else
			vst_color(glb.vdi.ha,WHITE);
		x=parm->pb_x-1;
		x+=(parm->pb_w-tLarg)/2;
		x+=i;
		if (parm->pb_currstate&SELECTED)
			x+=1;
		y+=i;

		trait=(uchar *)strchr((char *)user->spec,0x5B);
		if (trait!=NULL)
		{
			*trait=0;
			if (vect)
			{
				vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
				v_ftext(glb.vdi.ha,x,y,(char *)user->spec);
			}
			else
			{
				vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
				v_gtext(glb.vdi.ha,x,y,(char *)user->spec);
			}
			*trait='[';
			trait++;
			if (*trait!=0)
			{
				x+=extent[2]-extent[0];
				car[0]=*trait;
				car[1]=0;
				vst_effects(glb.vdi.ha,eff+TXT_UNDERLINED);
				if (vect)
				{
					v_ftext(glb.vdi.ha,x,y,(char *)car);
					vqt_f_extent(glb.vdi.ha,(char *)car,extent);
				}
				else
				{
					v_gtext(glb.vdi.ha,x,y,(char *)car);
					vqt_extent(glb.vdi.ha,(char *)car,extent);
				}
				vst_effects(glb.vdi.ha,eff);
				trait++;
			}
			if (*trait!=0)
			{
				x+=extent[2]-extent[0];
				if (vect)
					v_ftext(glb.vdi.ha,x,y,(char *)trait);
				else
					v_gtext(glb.vdi.ha,x,y,(char *)trait);
			}
		}
		else
			if (vect)
				v_ftext(glb.vdi.ha,x,y,(char *)user->spec);
			else
				v_gtext(glb.vdi.ha,x,y,(char *)user->spec);
	}

	vs_clip(glb.vdi.ha,FALSE,tab_clip);
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,tattr[0]);
	vsf_interior(glb.vdi.ha,fattr[2]);
	vsf_style(glb.vdi.ha,fattr[0]);
	vsf_perimeter(glb.vdi.ha,fattr[4]);
	vsl_type(glb.vdi.ha,lattr[0]);
	vsl_color(glb.vdi.ha,lattr[1]);
	return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}

/*******************************************************************************
	G_BUTTON (relief)
*******************************************************************************/
int cdecl _drawBakButton(PARMBLK *parm)
{
	tLarg=0;
   vqt_attributes(glb.vdi.ha,tattr);
   vqf_attributes(glb.vdi.ha,fattr);
   vql_attributes(glb.vdi.ha,lattr);
	state=parm->pb_tree[parm->pb_obj].ob_state;
	type=(parm->pb_tree[parm->pb_obj].ob_type)>>8;
	eff=TXT_NORMAL;
	if (state&STATE15) 	eff+=TXT_THICKENED;
	if (state&STATE14)	eff+=TXT_LIGHT;
	vst_effects(glb.vdi.ha,eff);
	vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);
	user=(UBLK *)(parm->pb_parm);

	if (type!=0)
		pnt=type;
	else
		pnt=10-2*glb.vdi.low;
	if (state&STATE10)
		ind=glb.opt.Gem_Dfont;
	else if (state&STATE8)
		ind=glb.opt.Gem_Ifont;
	else if (state&STATE11)
		ind=glb.opt.Hlp_Ifont;
	else if (state&STATE9)
		ind=1;
	else
		ind=glb.opt.Gem_font;
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,glb.font[ind].index);
	vect=glb.font[ind].name[32];
	if (vect)
		vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
	else
	vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);

	tour=1;
	if (parm->pb_tree[parm->pb_obj].ob_flags&EXIT)		tour+=1;
	if (parm->pb_tree[parm->pb_obj].ob_flags&DEFAULT)	tour+=1;
	if (vect)
		vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
	else
		vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
	tHaut=extent[7]-extent[1]+4-parm->pb_h;
	if (tHaut>0)
		tHaut/=2;
	else
		tHaut=0;
	parm->pb_y-=tHaut;
	parm->pb_h+=2*tHaut;

	my1.g_x=parm->pb_x-tour;
	my1.g_y=parm->pb_y-tour;
	my1.g_w=parm->pb_w+2*tour;
	my1.g_h=parm->pb_h+2*tour;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	bar[0]=my1.g_x;
	bar[1]=my1.g_y;
	bar[2]=bar[0]+my1.g_w-1;
	bar[3]=bar[1]+my1.g_h-1;

	vswr_mode(glb.vdi.ha,MD_REPLACE);		/*	Mode remplacement		*/
	vsf_perimeter(glb.vdi.ha,FALSE);		/*	Pas de primtre		*/
	vsf_interior(glb.vdi.ha,FIS_SOLID);	/*	Cadre plein				*/
	vsf_style(glb.vdi.ha,0);					/*	Cadre plein				*/
	vsf_color(glb.vdi.ha,BLACK);				/*	Couleur: Noir			*/
	v_bar(glb.vdi.ha,bar);						/*	Trac du cadre noir	*/

	if (parm->pb_currstate&SELECTED)
	{
		bar[0]=parm->pb_x;
		bar[1]=parm->pb_y;
		bar[2]=bar[0]+parm->pb_w-1;
		bar[3]=bar[1]+parm->pb_h-1;
		pxy[0]=bar[0]+1;
		pxy[1]=bar[3];
		pxy[2]=bar[2];
		pxy[3]=bar[3];
		pxy[4]=bar[2];
		pxy[5]=bar[1]+1;
		vsl_type(glb.vdi.ha,SOLID);
		vsl_width(glb.vdi.ha,1);
		if (glb.vdi.extnd[4]>=4)
		{
			vsf_color(glb.vdi.ha,LBLACK);	/*	Couleur: Gris fonc	*/
			v_bar(glb.vdi.ha,bar);				/*	Trac du cadre int.	*/
			vsl_color(glb.vdi.ha,LWHITE);	/*	Ligne: Gris clair		*/
			pxy[0]-=1;
			pxy[5]-=1;
		}
		else
			vsl_color(glb.vdi.ha,WHITE);		/*	Ligne: Blanc			*/
		v_pline(glb.vdi.ha,3,pxy);
		color=WHITE;							/*	Texte: Blanc			*/
	}
	else
	{
		if (glb.vdi.extnd[4]>=4)
			vsf_color(glb.vdi.ha,LWHITE);	/*	Couleur: Gris clair	*/
		else
			vsf_color(glb.vdi.ha,WHITE);		/*	Couleur: Blanc			*/
		bar[0]=parm->pb_x;
		bar[1]=parm->pb_y;
		bar[2]=bar[0]+parm->pb_w-1;
		bar[3]=bar[1]+parm->pb_h-1;
		v_bar(glb.vdi.ha,bar);					/*	Trac du cadre int.	*/
		vsl_color(glb.vdi.ha,WHITE);			/*	Ligne: Blanc			*/
		pxy[0]=bar[0];
		pxy[1]=bar[3]-1;
		pxy[2]=bar[0];
		pxy[3]=bar[1];
		pxy[4]=bar[2]-1;
		pxy[5]=bar[1];
		v_pline(glb.vdi.ha,3,pxy);
		if (glb.vdi.extnd[4]>=4)
			vsl_color(glb.vdi.ha,LBLACK);	/*	Ligne: Gris fonc		*/
		else
			vsl_color(glb.vdi.ha,BLACK);		/*	Ligne: Gris fonc		*/
		pxy[0]=bar[0]+1;
		pxy[1]=bar[3];
		pxy[2]=bar[2];
		pxy[3]=bar[3];
		pxy[4]=bar[2];
		pxy[5]=bar[1]+1;
		v_pline(glb.vdi.ha,3,pxy);
		color=BLACK;							/*	Texte: Noir				*/
	}
	vst_color(glb.vdi.ha,color);
	vs_clip(glb.vdi.ha,FALSE,tab_clip);

	my1.g_x=parm->pb_x+1;
	my1.g_y=parm->pb_y+1;
	my1.g_w=parm->pb_w-2;
	my1.g_h=parm->pb_h-2;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	vswr_mode(glb.vdi.ha,MD_TRANS);		/*	Mode transparent	*/

	trait=(uchar *)strchr((char *)user->spec,0x5B);
	if ( (trait!=NULL) && (trait!=(uchar *)user->spec) )
	{
		*trait=0;
		if (vect)
			vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
		else
			vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
		*trait='[';
		trait++;
		tLarg=extent[2]-extent[6];
	}
	else
		trait=(uchar *)user->spec;
	if (vect)
		vqt_f_extent(glb.vdi.ha,(char *)trait,extent);
	else
		vqt_extent(glb.vdi.ha,(char *)trait,extent);
	tLarg+=extent[2]-extent[6];

	x=parm->pb_x;
	x+=(parm->pb_w-tLarg)/2;
	y=parm->pb_y;
	y+=parm->pb_h/2;
	y-=(extent[7]-extent[1])/2 ;
	y+=htext;

	trait=(uchar *)strchr((char *)user->spec,0x5B);
	if (trait!=NULL)
	{
		*trait=0;
		if (vect)
		{
			vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
			v_ftext(glb.vdi.ha,x,y,(char *)user->spec);
		}
		else
		{
			vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
			v_gtext(glb.vdi.ha,x,y,(char *)user->spec);
		}
		*trait='[';
		trait++;
		if (*trait!=0)
		{
			x+=extent[2]-extent[0];
			car[0]=*trait;
			car[1]=0;
			vst_effects(glb.vdi.ha,eff+TXT_UNDERLINED);
			if (vect)
			{
				v_ftext(glb.vdi.ha,x,y,(char *)car);
				vqt_f_extent(glb.vdi.ha,(char *)car,extent);
			}
			else
			{
				v_gtext(glb.vdi.ha,x,y,(char *)car);
				vqt_extent(glb.vdi.ha,(char *)car,extent);
			}
			vst_effects(glb.vdi.ha,eff);
			trait++;
		}
		if (*trait!=0)
		{
			x+=extent[2]-extent[0];
			if (vect)
				v_ftext(glb.vdi.ha,x,y,(char *)trait);
			else
				v_gtext(glb.vdi.ha,x,y,(char *)trait);
		}
	}
	else
		if (vect)
			v_ftext(glb.vdi.ha,x,y,(char *)user->spec);
		else
			v_gtext(glb.vdi.ha,x,y,(char *)user->spec);

	vs_clip(glb.vdi.ha,FALSE,tab_clip);
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,tattr[0]);
	vsf_interior(glb.vdi.ha,fattr[2]);
	vsf_style(glb.vdi.ha,fattr[0]);
	vsf_perimeter(glb.vdi.ha,fattr[4]);
	vsl_type(glb.vdi.ha,lattr[0]);
	vsl_color(glb.vdi.ha,lattr[1]);
	return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	G_BUTTON
*******************************************************************************/
int cdecl _drawButton(PARMBLK *parm)
{
	tLarg=0;
   vqt_attributes(glb.vdi.ha,tattr);
   vqf_attributes(glb.vdi.ha,fattr);
	state=parm->pb_tree[parm->pb_obj].ob_state;
	type=(parm->pb_tree[parm->pb_obj].ob_type)>>8;
	eff=TXT_NORMAL;
	if (state&STATE15) 	eff+=TXT_THICKENED;
	if (state&STATE14)	eff+=TXT_LIGHT;
	if (state&STATE13)	eff+=TXT_UNDERLINED;
	vst_effects(glb.vdi.ha,eff);
	vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);
	user=(UBLK *)(parm->pb_parm);

	if (type!=0)
		pnt=type;
	else
		pnt=10-2*glb.vdi.low;
	if (state&STATE10)
		ind=glb.opt.Gem_Dfont;
	else if (state&STATE8)
		ind=glb.opt.Gem_Ifont;
	else if (state&STATE11)
		ind=glb.opt.Hlp_Ifont;
	else if (state&STATE9)
		ind=1;
	else
		ind=glb.opt.Gem_font;
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,glb.font[ind].index);
	vect=glb.font[ind].name[32];
	if (vect)
		vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
	else
		vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);

	tour=1;
	if (parm->pb_tree[parm->pb_obj].ob_flags&EXIT)		tour+=1;
	if (parm->pb_tree[parm->pb_obj].ob_flags&DEFAULT)	tour+=1;
	if (vect)
		vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
	else
		vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
	tHaut=extent[7]-extent[1]+4-parm->pb_h;
	if (tHaut>0)
		tHaut/=2;
	else
		tHaut=0;
	parm->pb_y-=tHaut;
	parm->pb_h+=2*tHaut;

	my1.g_x=parm->pb_x-tour;
	my1.g_y=parm->pb_y-tour;
	my1.g_w=parm->pb_w+2*tour;
	my1.g_h=parm->pb_h+2*tour;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	bar[0]=my1.g_x;
	bar[1]=my1.g_y;
	bar[2]=bar[0]+my1.g_w-1;
	bar[3]=bar[1]+my1.g_h-1;

	vswr_mode(glb.vdi.ha,MD_REPLACE);		/*	Mode remplacement		*/
	vsf_perimeter(glb.vdi.ha,FALSE);		/*	Pas de primtre		*/
	vsf_interior(glb.vdi.ha,FIS_SOLID);	/*	Cadre plein				*/
	vsf_style(glb.vdi.ha,0);					/*	Cadre plein				*/
	vsf_color(glb.vdi.ha,BLACK);				/*	Couleur: Noir			*/
	v_bar(glb.vdi.ha,bar);						/*	Trac du cadre noir	*/

	if (parm->pb_currstate&SELECTED)
		color=WHITE;							/*	Texte: Blanc			*/
	else
	{
		color=BLACK;							/*	Texte: Noir				*/
		bar[0]=parm->pb_x;
		bar[1]=parm->pb_y;
		bar[2]=bar[0]+parm->pb_w-1;
		bar[3]=bar[1]+parm->pb_h-1;
		vsf_color(glb.vdi.ha,WHITE);			/*	Couleur: Blanc			*/
		v_bar(glb.vdi.ha,bar);					/*	Trac du cadre int.	*/
	}
	vst_color(glb.vdi.ha,color);
	vs_clip(glb.vdi.ha,FALSE,tab_clip);

	my1.g_x=parm->pb_x+1;
	my1.g_y=parm->pb_y+1;
	my1.g_w=parm->pb_w-2;
	my1.g_h=parm->pb_h-2;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	vswr_mode(glb.vdi.ha,MD_TRANS);		/*	Mode transparent	*/

	trait=(uchar *)strchr((char *)user->spec,0x5B);
	if ( (trait!=NULL) && (trait!=(uchar *)user->spec) )
	{
		*trait=0;
		if (vect)
			vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
		else
			vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
		*trait='[';
		trait++;
		tLarg=extent[2]-extent[6];
	}
	else
		trait=(uchar *)user->spec;
	if (vect)
		vqt_f_extent(glb.vdi.ha,(char *)trait,extent);
	else
		vqt_extent(glb.vdi.ha,(char *)trait,extent);
	tLarg+=extent[2]-extent[6];

	x=parm->pb_x;
	x+=(parm->pb_w-tLarg)/2;
	y=parm->pb_y;
	y+=parm->pb_h/2;
	y-=(extent[7]-extent[1])/2 ;
	y+=htext;

	trait=(uchar *)strchr((char *)user->spec,0x5B);
	if (trait!=NULL)
	{
		*trait=0;
		if (vect)
		{
			vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
			v_ftext(glb.vdi.ha,x,y,(char *)user->spec);
		}
		else
		{
			vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
			v_gtext(glb.vdi.ha,x,y,(char *)user->spec);
		}
		*trait='[';
		trait++;
		if (*trait!=0)
		{
			x+=extent[2]-extent[0];
			car[0]=*trait;
			car[1]=0;
			vst_effects(glb.vdi.ha,eff+TXT_UNDERLINED);
			if (vect)
			{
				v_ftext(glb.vdi.ha,x,y,(char *)car);
				vqt_f_extent(glb.vdi.ha,(char *)car,extent);
			}
			else
			{
				v_gtext(glb.vdi.ha,x,y,(char *)car);
				vqt_extent(glb.vdi.ha,(char *)car,extent);
			}
			vst_effects(glb.vdi.ha,eff);
			trait++;
		}
		if (*trait!=0)
		{
			x+=extent[2]-extent[0];
			if (vect)
				v_ftext(glb.vdi.ha,x,y,(char *)trait);
			else
				v_gtext(glb.vdi.ha,x,y,(char *)trait);
		}
	}
	else
		if (vect)
			v_ftext(glb.vdi.ha,x,y,(char *)user->spec);
		else
			v_gtext(glb.vdi.ha,x,y,(char *)user->spec);

	vs_clip(glb.vdi.ha,FALSE,tab_clip);
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,tattr[0]);
	vsf_interior(glb.vdi.ha,fattr[2]);
	vsf_style(glb.vdi.ha,fattr[0]);
	vsf_perimeter(glb.vdi.ha,fattr[4]);
	return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	G_STRING
*******************************************************************************/
int cdecl _drawString(PARMBLK *parm)
{
	tLarg=0;
   vqt_attributes(glb.vdi.ha,tattr);
   vqf_attributes(glb.vdi.ha,fattr);
	state=parm->pb_tree[parm->pb_obj].ob_state;
	type=(parm->pb_tree[parm->pb_obj].ob_type)>>8;
	eff=TXT_NORMAL;
	if (state&STATE15) 	eff+=TXT_THICKENED;
	if (state&STATE14)	eff+=TXT_LIGHT;
	if (state&STATE13)	eff+=TXT_UNDERLINED;
	vst_effects(glb.vdi.ha,eff);
	vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);
	user=(UBLK *)(parm->pb_parm);

	if (type!=0)
		pnt=type;
	else
		pnt=10-2*glb.vdi.low;
	if (state&STATE10)
		ind=glb.opt.Gem_Dfont;
	else if (state&STATE8)
		ind=glb.opt.Gem_Ifont;
	else if (state&STATE11)
		ind=glb.opt.Hlp_Ifont;
	else if (state&STATE9)
		ind=1;
	else
		ind=glb.opt.Gem_font;
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,glb.font[ind].index);
	vect=glb.font[ind].name[32];
	if (vect)
		vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
	else
		vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);

	my1.g_x=parm->pb_x;
	my1.g_y=parm->pb_y;
	my1.g_w=parm->pb_w;
	my1.g_h=parm->pb_h;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	bar[0]=my1.g_x;
	bar[1]=my1.g_y;
	bar[2]=bar[0]+my1.g_w-1;
	bar[3]=bar[1]+my1.g_h-1;

	vswr_mode(glb.vdi.ha,MD_REPLACE);		/*	Mode remplacement		*/
	vsf_perimeter(glb.vdi.ha,FALSE);		/*	Pas de primtre		*/
	vsf_interior(glb.vdi.ha,FIS_SOLID);	/*	Cadre plein				*/
	vsf_style(glb.vdi.ha,0);					/*	Cadre plein				*/

	if (parm->pb_currstate&SELECTED)
	{
		if (parm->pb_tree[parm->pb_obj].ob_state&WHITEBAK)
			vsf_color(glb.vdi.ha,LBLACK);	/*	Couleur: Gris fonc	*/
		else
			vsf_color(glb.vdi.ha,BLACK);		/*	Couleur: Noir			*/
		color=WHITE;							/*	Texte: Blanc			*/
	}
	else
	{
		if (parm->pb_tree[parm->pb_obj].ob_state&WHITEBAK)
			vsf_color(glb.vdi.ha,LWHITE);	/*	Couleur: Gris clair	*/
		else
			vsf_color(glb.vdi.ha,WHITE);		/*	Couleur: Blanc			*/
		color=BLACK;							/*	Texte: Noir				*/
	}
	vst_color(glb.vdi.ha,color);
	v_bar(glb.vdi.ha,bar);						/*	Trac du cadre noir	*/

	vswr_mode(glb.vdi.ha,MD_TRANS);			/*	Mode transparent		*/
	trait=(uchar *)strchr((char *)user->spec,0x5B);
	if ( (trait!=NULL) && (trait!=(uchar *)user->spec) )
	{
		*trait=0;
		if (vect)
			vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
		else
			vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
		*trait='[';
		trait++;
		tLarg=extent[2]-extent[6];
	}
	else
		trait=(uchar *)user->spec;
	if (vect)
		vqt_f_extent(glb.vdi.ha,(char *)trait,extent);
	else
		vqt_extent(glb.vdi.ha,(char *)trait,extent);
	tLarg+=extent[2]-extent[6];

	x=parm->pb_x;
	y=parm->pb_y;
	y+=parm->pb_h/2;
	y-=(extent[7]-extent[1])/2 ;
	y+=htext;

	trait=(uchar *)strchr((char *)user->spec,0x5B);
	if (trait!=NULL)
	{
		*trait=0;
		if (vect)
		{
			vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
			v_ftext(glb.vdi.ha,x,y,(char *)user->spec);
		}
		else
		{
			vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
			v_gtext(glb.vdi.ha,x,y,(char *)user->spec);
		}
		*trait='[';
		trait++;
		if (*trait!=0)
		{
			x+=extent[2]-extent[0];
			car[0]=*trait;
			car[1]=0;
			vst_effects(glb.vdi.ha,eff+TXT_UNDERLINED);
			if (vect)
			{
				v_ftext(glb.vdi.ha,x,y,(char *)car);
				vqt_f_extent(glb.vdi.ha,(char *)car,extent);
			}
			else
			{
				v_gtext(glb.vdi.ha,x,y,(char *)car);
				vqt_extent(glb.vdi.ha,(char *)car,extent);
			}
			vst_effects(glb.vdi.ha,eff);
			trait++;
		}
		if (*trait!=0)
		{
			x+=extent[2]-extent[0];
			if (vect)
				v_ftext(glb.vdi.ha,x,y,(char *)trait);
			else
				v_gtext(glb.vdi.ha,x,y,(char *)trait);
		}
	}
	else
		if (vect)
			v_ftext(glb.vdi.ha,x,y,(char *)user->spec);
		else
			v_gtext(glb.vdi.ha,x,y,(char *)user->spec);

	vs_clip(glb.vdi.ha,FALSE,tab_clip);
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,tattr[0]);
	vsf_interior(glb.vdi.ha,fattr[2]);
	vsf_style(glb.vdi.ha,fattr[0]);
	vsf_perimeter(glb.vdi.ha,fattr[4]);
	return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	G_LINE in popup menu
*******************************************************************************/
int cdecl _drawNiceLine(PARMBLK *parm)
{
   vqf_attributes(glb.vdi.ha,fattr);
	vql_attributes(glb.vdi.ha,lattr);
	my1.g_x=parm->pb_x;
	my1.g_y=parm->pb_y;
	my1.g_w=parm->pb_w;
	my1.g_h=parm->pb_h;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	bar[0]=my1.g_x;
	bar[1]=my1.g_y;
	bar[2]=bar[0]+my1.g_w-1;
	bar[3]=bar[1]+my1.g_h-1;

	vswr_mode(glb.vdi.ha,MD_REPLACE);		/*	Mode remplacement		*/
	vsf_perimeter(glb.vdi.ha,FALSE);		/*	Pas de primtre		*/
	vsf_interior(glb.vdi.ha,FIS_SOLID);	/*	Cadre plein				*/
	vsf_style(glb.vdi.ha,0);					/*	Cadre plein				*/

	if (parm->pb_currstate&SELECTED)
	{
		if (parm->pb_tree[parm->pb_obj].ob_state&WHITEBAK)
			vsf_color(glb.vdi.ha,LBLACK);	/*	Couleur: Gris fonc	*/
		else
			vsf_color(glb.vdi.ha,BLACK);		/*	Couleur: Noir			*/
		vsl_color(glb.vdi.ha,WHITE);
	}
	else
	{
		if (parm->pb_tree[parm->pb_obj].ob_state&WHITEBAK)
			vsf_color(glb.vdi.ha,LWHITE);	/*	Couleur: Gris clair	*/
		else
			vsf_color(glb.vdi.ha,WHITE);		/*	Couleur: Blanc			*/
		vsl_color(glb.vdi.ha,BLACK);
	}
	v_bar(glb.vdi.ha,bar);						/*	Trac du cadre noir	*/

	vsl_type(glb.vdi.ha,USERLINE);
	vsl_width(glb.vdi.ha,1);
	vsl_udsty(glb.vdi.ha,(int)0x5555);
	x=parm->pb_x;
	y=parm->pb_y+parm->pb_h/2;
	bar[0]=x;
	bar[1]=y;
	bar[2]=x+parm->pb_w;
	bar[3]=y;
	v_pline(glb.vdi.ha,2,bar);
	bar[1]+=1;
	bar[3]+=1;
	vsl_udsty(glb.vdi.ha,(int)0xAAAA);
	v_pline(glb.vdi.ha,2,bar);

	vs_clip(glb.vdi.ha,FALSE,tab_clip);
	vsl_type(glb.vdi.ha,lattr[0]);
	vsl_color(glb.vdi.ha,lattr[1]);
	vsf_interior(glb.vdi.ha,fattr[2]);
	vsf_style(glb.vdi.ha,fattr[0]);
	vsf_perimeter(glb.vdi.ha,fattr[4]);
	return parm->pb_currstate&~(SELECTED|DISABLED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	G_TEXT
*******************************************************************************/
int cdecl _drawText(PARMBLK *parm)
{
	TEDINFO		*ted;

	tLarg=0;
	my1.g_x=parm->pb_x;
	my1.g_y=parm->pb_y;
	my1.g_w=parm->pb_w;
	my1.g_h=parm->pb_h;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	if (_rcIntersect(&my1,&my2))
	{
		tab_clip[0]=my2.g_x;
		tab_clip[1]=my2.g_y;
		tab_clip[2]=tab_clip[0]+my2.g_w-1;
		tab_clip[3]=tab_clip[1]+my2.g_h-1;
		vs_clip(glb.vdi.ha,TRUE,tab_clip);

	   vqt_attributes(glb.vdi.ha,tattr);
	   vqf_attributes(glb.vdi.ha,fattr);
		state=parm->pb_tree[parm->pb_obj].ob_state;
		type=(parm->pb_tree[parm->pb_obj].ob_type)>>8;
		eff=TXT_NORMAL;
		if (state&STATE15) 	eff+=TXT_THICKENED;
		if (state&STATE14)	eff+=TXT_LIGHT;
		if (state&STATE13)	eff+=TXT_UNDERLINED;
		vst_effects(glb.vdi.ha,eff);
		vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);
		user=(UBLK *)(parm->pb_parm);
		ted=(TEDINFO *)user->spec;
		if (ted!=NULL)
		{
			if (type!=0)
				pnt=type;
			else if (ted->te_font==3)
				pnt=10-2*glb.vdi.low;
			else
				pnt=8-glb.vdi.low;
			if (state&STATE10)
				ind=glb.opt.Gem_Dfont;
			else if (state&STATE8)
				ind=glb.opt.Gem_Ifont;
			else if (state&STATE11)
				ind=glb.opt.Hlp_Ifont;
			else if (state&STATE9)
				ind=1;
			else
				ind=glb.opt.Gem_font;
			if (glb.vdi.gdos)
				vst_font(glb.vdi.ha,glb.font[ind].index);
			vect=glb.font[ind].name[32];
			if (vect)
				vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
			else
				vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);

			vswr_mode(glb.vdi.ha,MD_REPLACE);
			if (ted->te_color&0x80)		/* Mode Opaque ? */
			{
				if (parm->pb_tree[parm->pb_obj].ob_state&WHITEBAK)
				{
					if (state&SELECTED)
						vsf_color(glb.vdi.ha,LBLACK);
					else
						vsf_color(glb.vdi.ha,LWHITE);
				}
				else
				{
					if (state&SELECTED)
						vsf_color(glb.vdi.ha,col[(ted->te_color)&0xF]);	/*	Couleur de fond		*/
					else
						vsf_color(glb.vdi.ha,(ted->te_color)&0xF);			/*	Couleur de fond		*/
				}
				vsf_interior(glb.vdi.ha,FIS_SOLID);	/*	Cadre plein				*/
				vsf_style(glb.vdi.ha,0);					/*	Pattern vide			*/
				vsf_perimeter(glb.vdi.ha,FALSE);		/*	Pas de Primtre		*/
				bar[0]	=	parm->pb_x;
				bar[1]	=	parm->pb_y;
				bar[2]	=	parm->pb_x+parm->pb_w-1;
				bar[3]	=	parm->pb_y+parm->pb_h-1;
				v_bar(glb.vdi.ha,bar);						/*	Trac du cadre			*/
			}

			if (state&SELECTED)
				color=col[((ted->te_color)&0xF00)>>8];
			else
				color=((ted->te_color)&0xF00)>>8;
			vst_color(glb.vdi.ha,color);
			vswr_mode(glb.vdi.ha,MD_TRANS);
			p=(uchar *)ted->te_ptext;
			trait=(uchar *)strchr(ted->te_ptext,0x5B);
			if ( (trait!=NULL) && (trait!=p) )
			{
				*trait=0;
				if (vect)
					vqt_f_extent(glb.vdi.ha,(char *)p,extent);
				else
					vqt_extent(glb.vdi.ha,(char *)p,extent);
				*trait='[';
				trait++;
				tLarg=extent[2]-extent[6];
			}
			else
				trait=(uchar *)ted->te_ptext;
			if (vect)
				vqt_f_extent(glb.vdi.ha,(char *)trait,extent);
			else
				vqt_extent(glb.vdi.ha,(char *)trait,extent);
			tLarg+=extent[2]-extent[6];

			x=parm->pb_x;
			y=parm->pb_y;
			y+=parm->pb_h/2;
			y-=(extent[7]-extent[1])/2 ;
			y+=htext;

			switch (ted->te_just)
			{
				case	1:		x+=(parm->pb_w-tLarg);		break;
				case	2:		x+=(parm->pb_w-tLarg)/2;	break;
			}

			trait=(uchar *)strchr(ted->te_ptext,0x5B);
			if (trait!=NULL)
			{
				*trait=0;
				if (vect)
				{
					vqt_f_extent(glb.vdi.ha,(char *)p,extent);
					v_ftext(glb.vdi.ha,x,y,(char *)p);
				}
				else
				{
					vqt_extent(glb.vdi.ha,(char *)p,extent);
					v_gtext(glb.vdi.ha,x,y,(char *)p);
				}
				*trait='[';
				trait++;
				if (*trait!=0)
				{
					x+=extent[2]-extent[0];
					car[0]=*trait;
					car[1]=0;
					vst_color(glb.vdi.ha,RED);
					if (vect)
					{
						v_ftext(glb.vdi.ha,x,y,(char *)car);
						vqt_f_extent(glb.vdi.ha,(char *)car,extent);
					}
					else
					{
						v_gtext(glb.vdi.ha,x,y,(char *)car);
						vqt_extent(glb.vdi.ha,(char *)car,extent);
					}
					vst_color(glb.vdi.ha,color);
					trait++;
				}
				if (*trait!=0)
				{
					x+=extent[2]-extent[0];
					if (vect)
						v_ftext(glb.vdi.ha,x,y,(char *)trait);
					else
						v_gtext(glb.vdi.ha,x,y,(char *)trait);
				}
			}
			else
			if (vect)
				v_ftext(glb.vdi.ha,x,y,ted->te_ptext);
			else
				v_gtext(glb.vdi.ha,x,y,ted->te_ptext);
		}
		vst_effects(glb.vdi.ha,TXT_NORMAL);
		vswr_mode(glb.vdi.ha,tattr[5]);
  		vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
		if (glb.vdi.gdos)
			vst_font(glb.vdi.ha,tattr[0]);
		vst_color(glb.vdi.ha,tattr[1]);
		vsf_interior(glb.vdi.ha,fattr[2]);
		vsf_style(glb.vdi.ha,fattr[0]);
		vsf_perimeter(glb.vdi.ha,fattr[4]);
		vs_clip(glb.vdi.ha,FALSE,tab_clip);
	}
	return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	G_FTEXT
*******************************************************************************/
int cdecl _drawFText(PARMBLK *parm)
{
	TEDINFO		*ted;

	tLarg=0;
	my1.g_x=parm->pb_x;
	my1.g_y=parm->pb_y;
	my1.g_w=parm->pb_w;
	my1.g_h=parm->pb_h;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	if (_rcIntersect(&my1,&my2))
	{
		tab_clip[0]=my2.g_x;
		tab_clip[1]=my2.g_y;
		tab_clip[2]=tab_clip[0]+my2.g_w-1;
		tab_clip[3]=tab_clip[1]+my2.g_h-1;
		vs_clip(glb.vdi.ha,TRUE,tab_clip);

	   vqt_attributes(glb.vdi.ha,tattr);
	   vqf_attributes(glb.vdi.ha,fattr);
		state=parm->pb_tree[parm->pb_obj].ob_state;
		type=(parm->pb_tree[parm->pb_obj].ob_type)>>8;
		vst_effects(glb.vdi.ha,TXT_NORMAL);
		vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);
		user=(UBLK *)(parm->pb_parm);
		ted=(TEDINFO *)user->spec;
		if (ted!=NULL)
		{
			if (type!=0)
				pnt=type;
			else if (ted->te_font==3)
				pnt=10-2*glb.vdi.low;
			else
				pnt=8-glb.vdi.low;
			if (state&STATE10)
				ind=glb.opt.Gem_Dfont;
			else if (state&STATE8)
				ind=glb.opt.Gem_Ifont;
			else if (state&STATE11)
				ind=glb.opt.Hlp_Ifont;
			else if (state&STATE9)
				ind=1;
			else
				ind=glb.opt.Gem_font;
			if (glb.vdi.gdos)
				vst_font(glb.vdi.ha,glb.font[ind].index);
			vect=glb.font[ind].name[32];
			if (vect)
				vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
			else
				vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);

			vswr_mode(glb.vdi.ha,MD_REPLACE);
			if (parm->pb_tree[parm->pb_obj].ob_state&WHITEBAK)
			{
				if (state&SELECTED)
					vsf_color(glb.vdi.ha,LBLACK);
				else
					vsf_color(glb.vdi.ha,LWHITE);
			}
			else
			{
				if (state&SELECTED)
					vsf_color(glb.vdi.ha,col[(ted->te_color)&0xF]);	/*	Couleur de fond		*/
				else
					vsf_color(glb.vdi.ha,(ted->te_color)&0xF);			/*	Couleur de fond		*/
			}
			vsf_interior(glb.vdi.ha,FIS_SOLID);							/*	Cadre plein				*/
			vsf_style(glb.vdi.ha,0);											/*	Pattern vide			*/
			vsf_perimeter(glb.vdi.ha,FALSE);								/*	Pas de Primtre		*/
			bar[0]	=	parm->pb_x;
			bar[1]	=	parm->pb_y;
			bar[2]	=	parm->pb_x+parm->pb_w-1;
			bar[3]	=	parm->pb_y+parm->pb_h-1;
			v_bar(glb.vdi.ha,bar);												/*	Trac du cadre			*/

			if (state&SELECTED)
				color=col[((ted->te_color)&0xF00)>>8];
			else
				color=((ted->te_color)&0xF00)>>8;
			vst_color(glb.vdi.ha,color);
			vswr_mode(glb.vdi.ha,MD_TRANS);

			if (vect)
				vqt_f_extent(glb.vdi.ha,ted->te_ptext,extent);
			else
				vqt_extent(glb.vdi.ha,ted->te_ptext,extent);

			x=parm->pb_x;
			y=parm->pb_y;
			y+=parm->pb_h/2;
			y-=(extent[7]-extent[1])/2 ;
			y+=htext;

			p=(uchar *)ted->te_ptmplt;
			trait=(uchar *)ted->te_ptext;
			car[1]=0;
			while (*p!=0)
			{
				if (*p=='_')
				{
					if (*trait==0)
						car[0]='_';
					else if (*trait<=' ')
						car[0]=' ';
					else
						car[0]=*trait;
					if (*trait!=0)
						trait++;
				}
				else
					car[0]=*p;
				if (vect)
				{
					vqt_f_extent(glb.vdi.ha,(char *)car,extent);
					v_ftext(glb.vdi.ha,x,y,(char *)car);
				}
				else
				{
					vqt_extent(glb.vdi.ha,(char *)car,extent);
					v_gtext(glb.vdi.ha,x,y,(char *)car);
				}
				x+=extent[2]-extent[6];
				p++;
			}
		}
		vswr_mode(glb.vdi.ha,tattr[5]);
  		vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
		if (glb.vdi.gdos)
			vst_font(glb.vdi.ha,tattr[0]);
		vst_color(glb.vdi.ha,tattr[1]);
		vsf_interior(glb.vdi.ha,fattr[2]);
		vsf_style(glb.vdi.ha,fattr[0]);
		vsf_perimeter(glb.vdi.ha,fattr[4]);
		vs_clip(glb.vdi.ha,FALSE,tab_clip);
	}
	return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	Cross & Radio G_BUTTON
*******************************************************************************/
int cdecl _drawCroixCarre(PARMBLK *parm)
{
	tLarg=0;

	pb.pb_tree			=	iglb.rsc.head.trindex[FUSER];
	if ( ((parm->pb_tree[parm->pb_obj].ob_type)&0xFF00) == USD_CROSS )
		pb.pb_obj		=	FUSDCAR+glb.vdi.low;
	else if ( ((parm->pb_tree[parm->pb_obj].ob_type)&0xFF00) == USD_ROUND )
		pb.pb_obj		=	FUSDCIR+glb.vdi.low;
	else
		pb.pb_obj		=	FUSDLAR+glb.vdi.low;
	pb.pb_prevstate	=	pb.pb_tree[pb.pb_obj].ob_state;
	if ( ((parm->pb_tree[parm->pb_obj].ob_type)&0xFF00) == USD_NUM )
		pb.pb_currstate=	pb.pb_tree[pb.pb_obj].ob_state;
	else
		pb.pb_currstate=	parm->pb_tree[parm->pb_obj].ob_state;
	pb.pb_w				=	pb.pb_tree[pb.pb_obj].ob_width;
	pb.pb_h				=	pb.pb_tree[pb.pb_obj].ob_height;
	pb.pb_x				=	parm->pb_x;
	pb.pb_y				=	parm->pb_y+(parm->pb_h-pb.pb_h)/2;
	pb.pb_xc				=	parm->pb_xc;
	pb.pb_yc				=	parm->pb_yc;
	pb.pb_wc				=	parm->pb_wc;
	pb.pb_hc				=	parm->pb_hc;
	pb.pb_parm			=	pb.pb_tree[pb.pb_obj].ob_spec.userblk->ub_parm;

   vqt_attributes(glb.vdi.ha,tattr);
   vqf_attributes(glb.vdi.ha,fattr);
	eff=TXT_NORMAL;
	vst_effects(glb.vdi.ha,eff);
	user=(UBLK *)(parm->pb_parm);
	state=parm->pb_tree[parm->pb_obj].ob_state;

	pnt=10-2*glb.vdi.low;
	if (state&STATE10)
		ind=glb.opt.Gem_Dfont;
	else if (state&STATE8)
		ind=glb.opt.Gem_Ifont;
	else if (state&STATE11)
		ind=glb.opt.Hlp_Ifont;
	else if (state&STATE9)
		ind=1;
	else
		ind=glb.opt.Gem_font;

	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,glb.font[ind].index);
	vect=glb.font[ind].name[32];
	if (vect)
		vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
	else
		vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);

	my1.g_x=parm->pb_x;
	my1.g_y=parm->pb_y;
	my1.g_w=parm->pb_w;
	my1.g_h=parm->pb_h;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	bar[0]=my1.g_x;
	bar[1]=my1.g_y;
	bar[2]=bar[0]+my1.g_w-1;
	bar[3]=bar[1]+my1.g_h-1;

	vswr_mode(glb.vdi.ha,MD_REPLACE);						/*	Mode remplacement		*/
	vsf_perimeter(glb.vdi.ha,FALSE);							/*	Pas de primtre		*/
	vsf_interior(glb.vdi.ha,FIS_SOLID);						/*	Cadre plein				*/
	vsf_style(glb.vdi.ha,0);									/*	Cadre plein				*/

	if (parm->pb_tree[parm->pb_obj].ob_state&DRAW3D)
		vsf_color(glb.vdi.ha,LWHITE);							/*	Couleur: Gris clair	*/
	else
		vsf_color(glb.vdi.ha,WHITE);							/*	Couleur: Blanc			*/
	color=BLACK;													/*	Texte: Noir				*/
	vst_color(glb.vdi.ha,color);
	v_bar(glb.vdi.ha,bar);										/*	Trac du cadre noir	*/

	vswr_mode(glb.vdi.ha,MD_TRANS);							/*	Mode transparent		*/
	trait=(uchar *)strchr((char *)user->spec,0x5B);
	if ( (trait!=NULL) && (trait!=(uchar *)user->spec) )
	{
		*trait=0;
		if (vect)
			vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
		else
			vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
		*trait='[';
		trait++;
		tLarg=extent[2]-extent[6];
	}
	else
		trait=(uchar *)user->spec;
	if (vect)
		vqt_f_extent(glb.vdi.ha,(char *)trait,extent);
	else
		vqt_extent(glb.vdi.ha,(char *)trait,extent);
	tLarg+=extent[2]-extent[6];

	if ( ((parm->pb_tree[parm->pb_obj].ob_type)&0xFF00) == USD_NUM )
	{
		vst_alignment(glb.vdi.ha,ALI_CENTER,ALI_BASE,&dummy,&dummy);
		x=parm->pb_x+parm->pb_w/2;
	}
	else
	{
		vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);
		x=parm->pb_x+1.5*pb.pb_w;
	}
	y=parm->pb_y;
	y+=parm->pb_h/2;
	y-=(extent[7]-extent[1])/2 ;
	y+=htext;

	trait=(uchar *)strchr((char *)user->spec,0x5B);
	if (trait!=NULL)
	{
		*trait=0;
		if (vect)
		{
			vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
			v_ftext(glb.vdi.ha,x,y,(char *)user->spec);
		}
		else
		{
			vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
			v_gtext(glb.vdi.ha,x,y,(char *)user->spec);
		}
		*trait='[';
		trait++;
		if (*trait!=0)
		{
			x+=extent[2]-extent[0];
			car[0]=*trait;
			car[1]=0;
			vst_effects(glb.vdi.ha,eff+TXT_UNDERLINED);
			if (vect)
			{
				v_ftext(glb.vdi.ha,x,y,(char *)car);
				vqt_f_extent(glb.vdi.ha,(char *)car,extent);
			}
			else
			{
				v_gtext(glb.vdi.ha,x,y,(char *)car);
				vqt_extent(glb.vdi.ha,(char *)car,extent);
			}
			vst_effects(glb.vdi.ha,eff);
			trait++;
		}
		if (*trait!=0)
		{
			x+=extent[2]-extent[0];
			if (vect)
				v_ftext(glb.vdi.ha,x,y,(char *)trait);
			else
				v_gtext(glb.vdi.ha,x,y,(char *)trait);
		}
	}
	else
		if (vect)
			v_ftext(glb.vdi.ha,x,y,(char *)user->spec);
		else
			v_gtext(glb.vdi.ha,x,y,(char *)user->spec);

	vs_clip(glb.vdi.ha,FALSE,tab_clip);
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,tattr[0]);
	vsf_interior(glb.vdi.ha,fattr[2]);
	vsf_style(glb.vdi.ha,fattr[0]);
	vsf_perimeter(glb.vdi.ha,fattr[4]);
	_drawCicon(&pb);
	if ( ((parm->pb_tree[parm->pb_obj].ob_type)&0xFF00) == USD_NUM )
	{
		pb.pb_tree		=	iglb.rsc.head.trindex[FUSER];
		pb.pb_obj		=	FUSDRAR+glb.vdi.low;
		pb.pb_prevstate=	pb.pb_tree[pb.pb_obj].ob_state;
		pb.pb_currstate=	pb.pb_tree[pb.pb_obj].ob_state;
		pb.pb_w			=	pb.pb_tree[pb.pb_obj].ob_width;
		pb.pb_h			=	pb.pb_tree[pb.pb_obj].ob_height;
		pb.pb_x			=	parm->pb_x+parm->pb_w-pb.pb_w;
		pb.pb_y			=	parm->pb_y+(parm->pb_h-pb.pb_h)/2;
		pb.pb_xc			=	parm->pb_xc;
		pb.pb_yc			=	parm->pb_yc;
		pb.pb_wc			=	parm->pb_wc;
		pb.pb_hc			=	parm->pb_hc;
		pb.pb_parm		=	pb.pb_tree[pb.pb_obj].ob_spec.userblk->ub_parm;
		_drawCicon(&pb);
	}
	return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	PopUp G_BUTTON
*******************************************************************************/
int cdecl _drawPopUp(PARMBLK *parm)
{
	tLarg=0;
	pb.pb_tree			=	iglb.rsc.head.trindex[FUSER];
	pb.pb_obj			=	FUSDPOP+glb.vdi.low;
	pb.pb_prevstate	=	pb.pb_tree[pb.pb_obj].ob_state;
	pb.pb_currstate	=	parm->pb_tree[parm->pb_obj].ob_state;
	pb.pb_w				=	pb.pb_tree[pb.pb_obj].ob_width;
	pb.pb_h				=	pb.pb_tree[pb.pb_obj].ob_height;
	pb.pb_x				=	parm->pb_x+parm->pb_w-pb.pb_w;
	pb.pb_y				=	parm->pb_y+(parm->pb_h-pb.pb_h)/2;
	pb.pb_xc				=	parm->pb_xc;
	pb.pb_yc				=	parm->pb_yc;
	pb.pb_wc				=	parm->pb_wc;
	pb.pb_hc				=	parm->pb_hc;
	pb.pb_parm			=	pb.pb_tree[pb.pb_obj].ob_spec.userblk->ub_parm;

   vqt_attributes(glb.vdi.ha,tattr);
   vqf_attributes(glb.vdi.ha,fattr);
   vql_attributes(glb.vdi.ha,lattr);
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dummy,&dummy);
	user=(UBLK *)(parm->pb_parm);
	state=parm->pb_tree[parm->pb_obj].ob_state;

	pnt=10-2*glb.vdi.low;
	if (state&STATE10)
		ind=glb.opt.Gem_Dfont;
	else if (state&STATE8)
		ind=glb.opt.Gem_Ifont;
	else if (state&STATE11)
		ind=glb.opt.Hlp_Ifont;
	else if (state&STATE9)
		ind=1;
	else
		ind=glb.opt.Gem_font;
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,glb.font[ind].index);
	vect=glb.font[ind].name[32];
	if (vect)
	{
		vst_arbpt(glb.vdi.ha,10-2*glb.vdi.low,&dummy,&htext,&dummy,&dummy);
		vqt_f_extent(glb.vdi.ha,(char *)user->spec,extent);
	}
	else
	{
		vst_point(glb.vdi.ha,10-2*glb.vdi.low,&dummy,&htext,&dummy,&dummy);
		vqt_extent(glb.vdi.ha,(char *)user->spec,extent);
	}
	tHaut=extent[7]-extent[1]+4-parm->pb_h;
	if (tHaut>0)
		tHaut/=2;
	else
		tHaut=0;
	parm->pb_y-=tHaut;
	parm->pb_h+=2*tHaut;

	my1.g_x=parm->pb_x;
	my1.g_y=parm->pb_y;
	my1.g_w=parm->pb_w;
	my1.g_h=parm->pb_h;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	pxy[0]=my1.g_x;
	pxy[1]=my1.g_y;
	pxy[2]=pxy[0]+my1.g_w-1;
	pxy[3]=pxy[1]+my1.g_h-1;

	vswr_mode(glb.vdi.ha,MD_REPLACE);			/*	Mode remplacement		*/
	vsf_perimeter(glb.vdi.ha,TRUE);				/*	Primtre				*/
	vsf_interior(glb.vdi.ha,FIS_SOLID);		/*	Cadre plein				*/
	if ((parm->pb_tree[parm->pb_obj].ob_state)&DRAW3D)
		vsf_color(glb.vdi.ha,LWHITE);			/*	Couleur: Gris			*/
	else
		vsf_color(glb.vdi.ha,WHITE);				/*	Couleur: Blanc			*/
	v_bar(glb.vdi.ha,pxy);							/*	Trac du cadre			*/

	pxy[0]=my1.g_x;
	pxy[1]=my1.g_y+my1.g_h-3;
	pxy[2]=pxy[0];
	pxy[3]=my1.g_y;
	pxy[4]=my1.g_x+my1.g_w-3;
	pxy[5]=pxy[3];
	vsl_type(glb.vdi.ha,SOLID);
	vsl_width(glb.vdi.ha,1);
	if ((parm->pb_tree[parm->pb_obj].ob_state)&DRAW3D)
		vsl_color(glb.vdi.ha,WHITE);				/*	Couleur: Blanc			*/
	else
		vsl_color(glb.vdi.ha,BLACK);				/*	Couleur: Noir			*/
	v_pline(glb.vdi.ha,3,pxy);					/*	Ligne						*/

	pxy[0]=my1.g_x+1;
	pxy[1]=my1.g_y+my1.g_h-2;
	pxy[2]=my1.g_x+my1.g_w-2;
	pxy[3]=pxy[1];
	pxy[4]=pxy[2];
	pxy[5]=my1.g_y+1;
	if ((parm->pb_tree[parm->pb_obj].ob_state)&DRAW3D)
		vsl_color(glb.vdi.ha,LBLACK);			/*	Couleur: Gris fonc	*/
	else
		vsl_color(glb.vdi.ha,BLACK);				/*	Couleur: Noir			*/
	v_pline(glb.vdi.ha,3,pxy);					/*	Ligne						*/

	pxy[0]+=1;
	pxy[1]+=1;
	pxy[2]+=1;
	pxy[3]+=1;
	pxy[4]+=1;
	pxy[5]+=1;
	vsl_color(glb.vdi.ha,BLACK);					/*	Couleur: Noir			*/
	v_pline(glb.vdi.ha,3,pxy);					/*	Ligne						*/
	vs_clip(glb.vdi.ha,FALSE,tab_clip);

	my1.g_x=parm->pb_x+2;
	my1.g_y=parm->pb_y+1;
	my1.g_w=parm->pb_w-2-pb.pb_w;
	my1.g_h=parm->pb_h-3;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);
	vswr_mode(glb.vdi.ha,MD_TRANS);				/*	Mode transparent		*/
	p=(uchar *)user->spec;
	while (*p==32)
		p++;
	if (vect)
		vqt_f_extent(glb.vdi.ha,(char *)p,extent);
	else
		vqt_extent(glb.vdi.ha,(char *)p,extent);
	tLarg+=extent[2]-extent[6];

	y=parm->pb_y-1;
	y+=parm->pb_h/2;
	y-=(extent[7]-extent[1])/2 ;
	y+=htext;
	for (i=0;i<2;i++)
	{
		if (i)
			vst_color(glb.vdi.ha,BLACK);
		else
			vst_color(glb.vdi.ha,WHITE);
		x=parm->pb_x+pb.pb_w/2+i;
		y+=i;

		if (vect)
			v_ftext(glb.vdi.ha,x,y,(char *)p);
		else
			v_gtext(glb.vdi.ha,x,y,(char *)p);
	}
	vs_clip(glb.vdi.ha,FALSE,tab_clip);
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,tattr[0]);
	vsf_interior(glb.vdi.ha,fattr[2]);
	vsf_style(glb.vdi.ha,fattr[0]);
	vsf_perimeter(glb.vdi.ha,fattr[4]);
	vsl_type(glb.vdi.ha,lattr[0]);
	vsl_color(glb.vdi.ha,lattr[1]);
	_drawCicon(&pb);
	return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}


/*******************************************************************************
	G_BOXTEXT (Frame)
*******************************************************************************/
int cdecl _drawFrame(PARMBLK *parm)
{
	TEDINFO		*ted;

   vql_attributes(glb.vdi.ha,lattr);
	state=parm->pb_tree[parm->pb_obj].ob_state;
	type=(parm->pb_tree[parm->pb_obj].ob_type)>>8;
	user=(UBLK *)(parm->pb_parm);
	ted=(TEDINFO *)user->spec;
	x=parm->pb_x;
	y=parm->pb_y;

	my1.g_x=parm->pb_x;
	my1.g_y=parm->pb_y;
	my1.g_w=parm->pb_w;
	my1.g_h=parm->pb_h;
	my2.g_x=parm->pb_xc;
	my2.g_y=parm->pb_yc;
	my2.g_w=parm->pb_wc;
	my2.g_h=parm->pb_hc;
	_rcIntersect(&my1,&my2);
	tab_clip[0]=my2.g_x;
	tab_clip[1]=my2.g_y;
	tab_clip[2]=tab_clip[0]+my2.g_w-1;
	tab_clip[3]=tab_clip[1]+my2.g_h-1;
	vs_clip(glb.vdi.ha,TRUE,tab_clip);

	if (strlen(ted->te_ptext))
	{
		vqt_attributes(glb.vdi.ha,tattr);
		eff=TXT_NORMAL;
		if (state&STATE15)
			eff+=TXT_THICKENED;
		if (state&STATE14)
			eff+=TXT_LIGHT;
		if (state&STATE13)
			eff+=TXT_UNDERLINED;
		vst_effects(glb.vdi.ha,eff);
		if (ted->te_font==3)
			pnt=10-2*glb.vdi.low;
		else
			pnt=8-glb.vdi.low;
		if (state&STATE10)
			ind=glb.opt.Gem_Dfont;
		else if (state&STATE8)
			ind=glb.opt.Gem_Ifont;
		else if (state&STATE11)
			ind=glb.opt.Hlp_Ifont;
		else if (state&STATE9)
			ind=1;
		else
			ind=glb.opt.Gem_font;
		if (glb.vdi.gdos)
			vst_font(glb.vdi.ha,glb.font[ind].index);
		vect=glb.font[ind].name[32];
		if (vect)
			vst_arbpt(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
		else
			vst_point(glb.vdi.ha,pnt,&dummy,&htext,&dummy,&dummy);
		if (parm->pb_currstate&SELECTED)
			color=col[((ted->te_color)&0xF00)>>8];
		else
			color=((ted->te_color)&0xF00)>>8;
		vst_color(glb.vdi.ha,color);
		vswr_mode(glb.vdi.ha,MD_TRANS);
		vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_TOP,&dummy,&dummy);
		if (vect)
			vqt_f_extent(glb.vdi.ha,ted->te_ptext,extent);
		else
			vqt_extent(glb.vdi.ha,ted->te_ptext,extent);
		tLarg=min(extent[2]-extent[6],parm->pb_w);
		tHaut=(extent[5]-extent[1])/2;
		switch (ted->te_just)
		{
			case	0:		x+=8;								break;
			case	1:		x+=parm->pb_w-tLarg-8;		break;
			case	2:		x+=(parm->pb_w-tLarg)/2;	break;
		}
		if (vect)
			v_ftext(glb.vdi.ha,x,y,ted->te_ptext);
		else
			v_gtext(glb.vdi.ha,x,y,ted->te_ptext);
	}
	else
	{
		tHaut=0;
		tLarg=0;
	}

	vsl_type(glb.vdi.ha,SOLID);
	vsl_width(glb.vdi.ha,1);
	vsl_color(glb.vdi.ha,BLACK);
	vswr_mode(glb.vdi.ha,MD_REPLACE);
	pxy[0]=x+tLarg-1;
	pxy[1]=my1.g_y+tHaut;
	pxy[2]=my1.g_x+my1.g_w-1;
	pxy[3]=my1.g_y+tHaut;
	pxy[4]=my1.g_x+my1.g_w-1;
	pxy[5]=my1.g_y+my1.g_h-1;
	pxy[6]=my1.g_x;
	pxy[7]=my1.g_y+my1.g_h-1;
	pxy[8]=my1.g_x;
	pxy[9]=my1.g_y+tHaut;
	pxy[10]=x-1;
	pxy[11]=my1.g_y+tHaut;
	v_pline(glb.vdi.ha,6,pxy);
	vsl_color(glb.vdi.ha,LBLACK);
	pxy[0]=my1.g_x+1;
	pxy[1]=my1.g_y+my1.g_h-2;
	pxy[2]=my1.g_x+my1.g_w-2;
	pxy[3]=my1.g_y+my1.g_h-2;
	pxy[4]=my1.g_x+my1.g_w-2;
	pxy[5]=my1.g_y+1+tHaut;
	v_pline(glb.vdi.ha,3,pxy);
	vsl_color(glb.vdi.ha,WHITE);
	pxy[0]=my1.g_x+1;
	pxy[1]=my1.g_y+my1.g_h-3;
	pxy[2]=my1.g_x+1;
	pxy[3]=my1.g_y+1+tHaut;
	pxy[4]=x-1;
	pxy[5]=my1.g_y+1+tHaut;
	v_pline(glb.vdi.ha,3,pxy);
	pxy[0]=x+tLarg-1;
	pxy[1]=my1.g_y+1+tHaut;
	pxy[2]=my1.g_x+my1.g_w-3;
	pxy[3]=my1.g_y+1+tHaut;
	v_pline(glb.vdi.ha,2,pxy);

	vs_clip(glb.vdi.ha,FALSE,tab_clip);
	vsl_type(glb.vdi.ha,lattr[0]);
	vsl_color(glb.vdi.ha,lattr[1]);
	if (strlen(ted->te_ptext))
	{
		vst_effects(glb.vdi.ha,TXT_NORMAL);
		vst_alignment (glb.vdi.ha,tattr[3],tattr[4],&dummy,&dummy);
		if (glb.vdi.gdos)
			vst_font(glb.vdi.ha,tattr[0]);
	}
	if ( (state&WHITEBAK) && (state&OUTLINED) )
		return parm->pb_currstate&~(SELECTED|OUTLINED|WHITEBAK|DRAW3D);
	else
		return parm->pb_currstate&~(SELECTED|WHITEBAK|DRAW3D);
}
