/*******************************************************************************
	"Easy Gem" library Copyright (c)1995 by		Christophe BOYANIQUE
																29 rue de la Rpublique
																37230 FONDETTES
																FRANCE
												FidoNet:		2:320/107.16
												NeST:			90:800/1.16
												AtariNet:	51:901/1.16
										*small* mail at:	cb@spia.freenix.fr
********************************************************************************
	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License, or any later version.
	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.
	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	675 Mass Ave, Cambridge, MA 02139, USA.
********************************************************************************

	FORMULAR WINDOWS HANDLING

********************************************************************************
	TABULATION: 3 CARACTERES
*******************************************************************************/


#include		"EG_MAIN.H"

/*******************************************************************************
	FUNCTIONS
*******************************************************************************/
static	void			_myInitFonte	(int n);
static	void			_myInitSysteme	(int n);
static	void			_myInitOptions	(int n);
static	void			_myInitIcone	(int n);
static	void			_myInitMemoire	(int n);
static	void			_myClic			(int obj,int n,int nmb);
static	void			_myClicInfo		(int n,int nmb);
static	void			_myClicFonte	(int n,int nmb);
static	void			_myClicOptions	(int n,int nmb);
static	void			_myClicIcone	(int n,int nmb);
static	void			_myClicMemoire	(int n,int nmb);
static	void	cdecl	_keybdForm		(int i,int key);
static	void	cdecl	_moveForm		(int i,int x,int y);
static	void	cdecl	_clicForm		(int i,int mx,int my,int mk,int nmb);
static	void	cdecl	_redrawForm		(int i,int x,int y,int w,int h);
static	void	cdecl	_myCloseForm	(int i);
static	void	cdecl	_closeForm		(int i);


/*******************************************************************************
	uninits a Wform window: free memory
*******************************************************************************/
void cdecl _closeForm(int i)
{
	W[i].in=NO_MEMORY;
}


/*******************************************************************************
	Handle keyboard events for WForm window
*******************************************************************************/
void cdecl _keybdForm(int i,int key)
{
	int			child,type;
	int			j,k;
	int			x,y;
	UBLK			*user;
	TEDINFO		*ted;
	uchar			*p,*q,*trait;

	if (i!=-1)
	{
		child=0;
		do
		{
			child+=1;
			if (iglb.aes.std)
			{
				type=W[i].str.wf.tree[child].ob_type;
				if ( !(W[i].str.wf.tree[child].ob_state&DISABLED) )
				{
					if ( (W[i].str.wf.tree[child].ob_flags&DEFAULT) && ( ((key&0xFF)==K_RETURN) ))
					{
						objc_offset(W[i].str.wf.tree,child,&x,&y);
						_clicForm(i,x,y,-1,1);
						iglb.aes.std=0;
					}
					else
					{
						p=NULL;
						switch	(type&0xFF)
						{
							case	G_BUTTON:
							case	G_STRING:
								p=(uchar *)W[i].str.wf.tree[child].ob_spec.free_string;
								break;
							case	G_TEXT:
							case	G_FTEXT:
							case	G_BOXTEXT:
							case	G_FBOXTEXT:
								p=(uchar *)W[i].str.wf.tree[child].ob_spec.tedinfo->te_ptext;
								break;
							case	G_USERDEF:
								user=(UBLK *)(W[i].str.wf.tree[child].ob_spec.userblk->ub_parm);
								switch	(user->type)
								{
									case	G_BUTTON:
									case	G_STRING:
										p=(uchar *)user->spec;
										break;
									case	G_TEXT:
									case	G_FTEXT:
									case	G_BOXTEXT:
									case	G_FBOXTEXT:
									p=(uchar *)((TEDINFO *)user->spec)->te_ptext;
										break;
								}
								break;
						}
						if (p!=NULL)
						{
							trait=(uchar *)strchr((char *)p,0x5B);
							if (trait!=NULL)
							{
								trait++;
								if (*trait!=0)
								{
									if ( toupper(key&0xFF)==toupper(*trait) )
									{
										if ( (W[i].str.wf.obj==-1) || (key&KF_ALT) )
										{
											objc_offset(W[i].str.wf.tree,child,&x,&y);
											_clicForm(i,x,y,-1,1);
											iglb.aes.std=0;
										}
									}
								}
							}
						}
					}
				}
			}
		} while ( (!(W[i].str.wf.tree[child].ob_flags&LASTOB)) && iglb.aes.std );
		key=iglb.aes.std;
		if ( W[i].str.wf.obj!=-1 && iglb.aes.std )
		{
			if ( W[i].str.wf.tree[W[i].str.wf.obj].ob_flags&EDITABLE && !(W[i].str.wf.tree[W[i].str.wf.obj].ob_state&DISABLED) )
			{
				user=(UBLK *)W[i].str.wf.tree[W[i].str.wf.obj].ob_spec.userblk->ub_parm;
				ted=(TEDINFO *)user->spec;
				if (key&KF_FUNC)
				{
					switch	(key&0xFF)
					{
						case	K_ESC:
							if (strlen(ted->te_ptext))
							{
								ted->te_ptext[0]=0;
								W[i].str.wf.pos=0;
								objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
								_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
							}
							iglb.aes.std=0;
							break;
						case	K_BS:
							if ( (W[i].str.wf.pos>0) && (strlen(ted->te_ptext)) )
							{
								p=(uchar *)ted->te_ptext;
								p+=W[i].str.wf.pos-1;
								*p=0;
								p+=1;
								while (*p!=0)
								{
									strncat(ted->te_ptext,(char *)p,1);
									p+=1;
								}
								W[i].str.wf.pos-=1;
								objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
								_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
							}
							iglb.aes.std=0;
							break;
						case	K_DEL:
							if ( (W[i].str.wf.pos<strlen(ted->te_ptext)) && (strlen(ted->te_ptext)) )
							{
								p=(uchar *)ted->te_ptext;
								p+=W[i].str.wf.pos;
								*p=0;
								p+=1;
								while (*p!=0)
								{
									strncat(ted->te_ptext,(char *)p,1);
									p+=1;
								}
								objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
								_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
							}
							iglb.aes.std=0;
							break;
						case	K_LEFT:
							if (W[i].str.wf.pos)
							{
								if (key&KF_SHIFT)
									W[i].str.wf.pos=0;
								else if (key&KF_CTRL)
								{
									trait=(uchar *)((long)_obGetStr(W[i].str.wf.tree,W[i].str.wf.obj)+(long)W[i].str.wf.pos);
									p=q=(uchar *)_obGetStr(W[i].str.wf.tree,W[i].str.wf.obj);
									while ( (long)p < (long) trait )
									{
										q=p;
										if (*p!=' ')
											while ( (*p!=0) && (*p!=' ') )
												p++;
										while ( (*p!=0) && (*p==' ') )
											p++;
									}
									W[i].str.wf.pos+=(int)( (long)q - (long)_obGetStr(W[i].str.wf.tree,W[i].str.wf.obj)-(long)W[i].str.wf.pos );
								}
								else
									W[i].str.wf.pos-=1;
								objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
								_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
							}
							iglb.aes.std=0;
							break;
						case	K_RIGHT:
							if ( (W[i].str.wf.pos<strlen(ted->te_ptext)) && (strlen(ted->te_ptext)) )
							{
								if (key&KF_SHIFT)
									W[i].str.wf.pos=(int)strlen(_obGetStr(W[i].str.wf.tree,W[i].str.wf.obj));
								else if (key&KF_CTRL)
								{
									p=(uchar *)((long)_obGetStr(W[i].str.wf.tree,W[i].str.wf.obj)+(long)W[i].str.wf.pos);
									if (*p!=' ')
										while ( (*p!=0) && (*p!=' ') )
											p++;
									while ( (*p!=0) && (*p==' ') )
										p++;
									W[i].str.wf.pos+=(int)( (long)p-(long)_obGetStr(W[i].str.wf.tree,W[i].str.wf.obj)-(long)W[i].str.wf.pos );
								}
								else
									W[i].str.wf.pos+=1;
								objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
								_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
							}
							iglb.aes.std=0;
							break;
						case	K_UP:
							k=W[i].str.wf.obj;
							j=W[i].str.wf.obj;
							do
							{
								if ((W[i].str.wf.tree[k].ob_type&0xFF)==G_USERDEF)
								{
									x=((UBLK *)W[i].str.wf.tree[k].ob_spec.userblk->ub_parm)->type;
									if ( (x==G_FTEXT || x==G_FBOXTEXT) && W[i].str.wf.tree[k].ob_flags&EDITABLE && !(W[i].str.wf.tree[k].ob_state&DISABLED) )
										j=k;
								}
								if (W[i].str.wf.tree[k].ob_flags&LASTOB)
									k=ROOT;
								else
									k++;
							}
							while (k!=W[i].str.wf.obj);
							if (j!=W[i].str.wf.obj)
							{
								objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
								W[i].str.wf.obj=j;
								user=(UBLK *)W[i].str.wf.tree[W[i].str.wf.obj].ob_spec.userblk->ub_parm;
								ted=(TEDINFO *)user->spec;
								W[i].str.wf.pos=(int)strlen(ted->te_ptext);
								_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
								iglb.aes.std=0;
							}
							break;
						case	K_TAB:
						case	K_DOWN:
						case	K_RETURN:
							if ( (key&0xFF) == K_RETURN )
							{
								if (W[i].id&FLAGS15)
									_myClic(W[i].id,W[i].str.wf.obj,0);
								else if (glb.func.gClicF!=0)
									(*glb.func.gClicF)(W[i].id,W[i].str.wf.obj,0);
							}
							k=W[i].str.wf.obj;
							j=-1;
							do
							{
								if (W[i].str.wf.tree[k].ob_flags&LASTOB)
									k=ROOT;
								else
									k++;
								if ((W[i].str.wf.tree[k].ob_type&0xFF)==G_USERDEF)
								{
									x=((UBLK *)W[i].str.wf.tree[k].ob_spec.userblk->ub_parm)->type;
									if ( (x==G_FTEXT || x==G_FBOXTEXT) && W[i].str.wf.tree[k].ob_flags&EDITABLE && !(W[i].str.wf.tree[k].ob_state&DISABLED) )
										j=k;
								}
							}
							while (j==-1);
							if (j!=W[i].str.wf.obj)
							{
								objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
								W[i].str.wf.obj=j;
								user=(UBLK *)W[i].str.wf.tree[W[i].str.wf.obj].ob_spec.userblk->ub_parm;
								ted=(TEDINFO *)user->spec;
								W[i].str.wf.pos=(int)strlen(ted->te_ptext);
								_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
								iglb.aes.std=0;
							}
							break;
					}
				}
				else if ((key&0xFF)>31)
				{
					_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,key&0xFF,&W[i].str.wf.pos,ED_CLIP|ED_CHAR);
					objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
					_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
				}
			}
			else
			{
				k=W[i].str.wf.obj;
				j=-1;
				do
				{
					if (W[i].str.wf.tree[k].ob_flags&LASTOB)
						k=ROOT;
					else
						k++;
					if ((W[i].str.wf.tree[k].ob_type&0xFF)==G_USERDEF)
					{
						x=((UBLK *)W[i].str.wf.tree[k].ob_spec.userblk->ub_parm)->type;
						if ( (x==G_FTEXT || x==G_FBOXTEXT) && W[i].str.wf.tree[k].ob_flags&EDITABLE && !(W[i].str.wf.tree[k].ob_state&DISABLED) )
							j=k;
					}
				}	while (j==-1 && k!=W[i].str.wf.obj);
				if (j!=W[i].str.wf.obj)
				{
					objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
					W[i].str.wf.obj=j;
					user=(UBLK *)W[i].str.wf.tree[W[i].str.wf.obj].ob_spec.userblk->ub_parm;
					ted=(TEDINFO *)user->spec;
						W[i].str.wf.pos=(int)strlen(ted->te_ptext);
					_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
				}
				else
				{
					objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
					W[i].str.wf.obj=-1;
					W[i].str.wf.pos=-1;
				}
			}
		}
	}
}


/*******************************************************************************
	Redraws a Form in a window
*******************************************************************************/
void cdecl _redrawForm(int i,int x,int y,int w,int h)
{
	GRECT		obj,clip;

	if (i!=-1)
	{
		W[i].str.wf.tree->ob_x=W[i].xwork;
		W[i].str.wf.tree->ob_y=W[i].ywork;
		objc_draw(W[i].str.wf.tree,ROOT,MAX_DEPTH,x,y,w,h);
		if (W[i].str.wf.obj!=-1)
		{
			_coord(W[i].str.wf.tree,W[i].str.wf.obj,FALSE,&obj.g_x,&obj.g_y,&obj.g_w,&obj.g_h);
			clip.g_x=x;
			clip.g_y=y;
			clip.g_w=w;
			clip.g_h=h;
			if (_rcIntersect(&obj,&clip))
			{
				_setClip(TRUE,&clip);
				_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_INIT);
				_setClip(FALSE,&clip);
			}
		}
	}
}


/*******************************************************************************
	Move a WForm window
*******************************************************************************/
#pragma warn -par
void cdecl _moveForm(int i,int x,int y)
{

	if (i!=-1)
	{
		W[i].str.wf.tree->ob_x=W[i].xwork;
		W[i].str.wf.tree->ob_y=W[i].ywork;
	}
}
#pragma warn +par


/*******************************************************************************
	Handles button events on a WForm window
*******************************************************************************/
#pragma warn -par
void cdecl _clicForm(int i,int x,int y,int k,int nmb)
{
	uint			c,d;
	int			n,pop,rpop,mx=0,my=0,mk,sel,sel1,sel2,a,b;
	int			flags,state;
	int			top;
	int			obx,oby,obw,obh,dum;
	uchar			*p;
	OBJECT		*obj;
	UBLK			*user=NULL;

	if (k==-1)
		mk=0;
	else
		mk=k;

	if (i!=-1)
	{
		W[i].str.wf.tree->ob_x=W[i].xwork;
		W[i].str.wf.tree->ob_y=W[i].ywork;		
		n=objc_find(W[i].str.wf.tree,ROOT,MAX_DEPTH,x,y);
		if (n!=-1)
		{
			flags=W[i].str.wf.tree[n].ob_flags;
			state=W[i].str.wf.tree[n].ob_state;
			if ((W[i].str.wf.tree[n].ob_type&0xFF)==G_USERDEF)
				user=(UBLK *)(W[i].str.wf.tree[n].ob_spec.userblk->ub_parm);

			/*	Cas d'un POP UP MENU	*/
			if ( (W[i].str.wf.tree[n].ob_type&0xFF00)==USD_POPUP && !(state&DISABLED) )
			{
				pop	=	user->user1;
				rpop	=	user->user4;
				if ( (k!=-1) && (pop!=-1) )
				{
					W[i].str.wf.tree[n].ob_state|=SELECTED;
					wind_update(BEG_MCTRL);
					_coord(W[i].str.wf.tree,n,TRUE,&obx,&oby,&obw,&obh);
					_winObdraw(i,W[i].str.wf.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					if (pop&FLAGS15)
						rpop=_formMenu(W[i].str.wf.tree,n,iglb.rsc.head.trindex[pop-FLAGS15],1,-rpop,0)-1;
					else
						rpop=_formMenu(W[i].str.wf.tree,n,glb.rsc.head.trindex[pop],1,-rpop,0)-1;
					W[i].str.wf.tree[n].ob_state&=~SELECTED;
					_coord(W[i].str.wf.tree,n,TRUE,&obx,&oby,&obw,&obh);
					_winObdraw(i,W[i].str.wf.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					wind_update(END_MCTRL);
					if (rpop!=-2)
					{
						user->user4=rpop;
						if (pop&FLAGS15)
							obj=iglb.rsc.head.trindex[pop-FLAGS15];
						else
							obj=glb.rsc.head.trindex[pop];
						p=(uchar *)_obGetStr(obj,rpop+1);
						if (!(W[i].str.wf.tree[n].ob_state&STATE8))
							_obPutStr(W[i].str.wf.tree,n,(char *)p);
						if (W[i].id&FLAGS15)
							_myClic(W[i].id,n,nmb);
						else if (glb.func.gClicF!=0)
							(*glb.func.gClicF)(W[i].id,n,nmb);
					}
					wind_update(BEG_UPDATE);
					graf_mouse(M_OFF,0);
					W[i].str.wf.tree[n].ob_state&=~SELECTED;
					_coord(W[i].str.wf.tree,n,TRUE,&obx,&oby,&obw,&obh);
					_winObdraw(i,W[i].str.wf.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					graf_mouse(M_ON,0);
					wind_update(END_UPDATE);
				}
			}

			/*	Cas d'un EXTENDED POP UP MENU	*/
			else if ( (W[i].str.wf.tree[n].ob_type&0xFF00)==USD_XPOPUP && !(state&DISABLED) )
			{
				rpop=user->user4;
				if (k!=-1 && pop!=-1)
				{
					W[i].str.wf.tree[n].ob_state|=SELECTED;
					wind_update(BEG_MCTRL);
					_coord(W[i].str.wf.tree,n,TRUE,&obx,&oby,&obw,&obh);
					_winObdraw(i,W[i].str.wf.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					if (pop&FLAGS15)
						rpop=_formXmenu(W[i].str.wf.tree,n,(char *)user->userl,user->user1,user->user2,user->user3,user->user4);
					else
						rpop=_formXmenu(W[i].str.wf.tree,n,(char *)user->userl,user->user1,user->user2,user->user3,user->user4);
					W[i].str.wf.tree[n].ob_state&=~SELECTED;
					_coord(W[i].str.wf.tree,n,TRUE,&obx,&oby,&obw,&obh);
					_winObdraw(i,W[i].str.wf.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					wind_update(END_MCTRL);
					if (rpop!=-1)
					{
						user->user4=rpop;
						p=(uchar *)((long)user->userl+(long)rpop*(long)(user->user2+user->user3)+user->user3);
						pop=(int)*p;
						*p=0;
						if (!(W[i].str.wf.tree[n].ob_state&STATE8))
							_obPutStr(W[i].str.wf.tree,n,(char *)(user->userl+(long)rpop*(long)(user->user2+user->user3)));
						*p=(char)pop;
						if (W[i].id&FLAGS15)
							_myClic(W[i].id,n,nmb);
						else if (glb.func.gClicF!=0)
							(*glb.func.gClicF)(W[i].id,n,nmb);
					}
					wind_update(BEG_UPDATE);
					graf_mouse(M_OFF,0);
					W[i].str.wf.tree[n].ob_state&=~SELECTED;
					_coord(W[i].str.wf.tree,n,TRUE,&obx,&oby,&obw,&obh);
					_winObdraw(i,W[i].str.wf.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					graf_mouse(M_ON,0);
					wind_update(END_UPDATE);
				}
			}

			/*	Cas d'un EDITABLE	*/
			else if (flags&EDITABLE && !(state&DISABLED))
			{
				wind_get(0,WF_TOP,&top);
				if (top==W[i].handle)
				{
					wind_update(BEG_MCTRL);
					graf_mouse(M_OFF,0);
					a=W[i].str.wf.obj;
					if (W[i].str.wf.obj!=n)
						W[i].str.wf.pos=(int)strlen(((TEDINFO *)user->spec)->te_ptext);
					W[i].str.wf.obj=n;
					_coord(W[i].str.wf.tree,a,FALSE,&obx,&oby,&obw,&obh);
					_winObdraw(i,W[i].str.wf.tree,a,MAX_DEPTH,obx,oby,obw,obh);
					_coord(W[i].str.wf.tree,W[i].str.wf.obj,FALSE,&obx,&oby,&obw,&obh);
					a=_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
					b=0;
					graf_mkstate(&x,&y,&k,&dum);
					if (a>x)
					{
						while (k && a>x && a!=b)
						{
							b=a;
							W[i].str.wf.pos=max(0,W[i].str.wf.pos-1);
							a=_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
							graf_mkstate(&x,&y,&k,&dum);
						}
					}
					else
					{
						while (k && a<x && a!=b)
						{
							b=a;
							W[i].str.wf.pos=min((int)strlen(((TEDINFO *)user->spec)->te_ptext),W[i].str.wf.pos+1);
							a=_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
							graf_mkstate(&x,&y,&k,&dum);
						}
					}
					_winObdraw(i,W[i].str.wf.tree,W[i].str.wf.obj,MAX_DEPTH,obx,oby,obw,obh);
					do
						graf_mkstate(&dum,&dum,&k,&dum);
					while (k);
					graf_mouse(M_ON,0);
					wind_update(END_MCTRL);
				}
			}

			/*	Cas d'un bouton SELECTABLE et NON RADIO BUTTON	*/
			else if (flags&SELECTABLE && !(state&DISABLED) && !(flags&RBUTTON))
			{
				sel1=W[i].str.wf.tree[n].ob_state;
				W[i].str.wf.tree[n].ob_state^=SELECTED;
				sel2=W[i].str.wf.tree[n].ob_state;
				graf_mouse(M_OFF,0);
				wind_update(BEG_UPDATE);
				_coord(W[i].str.wf.tree,n,TRUE,&obx,&oby,&obw,&obh);
				_winObdraw(i,W[i].str.wf.tree,n,MAX_DEPTH,obx,oby,obw,obh);
				wind_update(END_UPDATE);
				graf_mouse(M_ON,0);
				if (mk>0)
					graf_mkstate(&mx,&my,&mk,&dum);
				while (mk>0)
				{
					sel=W[i].str.wf.tree[n].ob_state;
					graf_mkstate(&mx,&my,&mk,&dum);
					if (objc_find(W[i].str.wf.tree,ROOT,MAX_DEPTH,mx,my)==n)
						sel=sel2;
					else
						sel=sel1;
					if (W[i].str.wf.tree[n].ob_state!=sel)
					{
						W[i].str.wf.tree[n].ob_state=sel;
						_coord(W[i].str.wf.tree,n,TRUE,&obx,&oby,&obw,&obh);
						graf_mouse(M_OFF,0);
						wind_update(BEG_UPDATE);
						_winObdraw(i,W[i].str.wf.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						wind_update(END_UPDATE);
						graf_mouse(M_ON,0);
					}
				}
				if (W[i].id&FLAGS15)
					_myClic(W[i].id,n,nmb);
				else if (glb.func.gClicF!=0)
					(*glb.func.gClicF)(W[i].id,n,nmb);
			}

			/*	Cas d'un bouton SELECTABLE et RADIO BUTTON	*/
			else if ( (flags&(SELECTABLE|RBUTTON)) && !(state&DISABLED) )
			{
				while (mk>0)
					graf_mkstate(&dum,&dum,&mk,&dum);
				a=_father(W[i].str.wf.tree,n);
				b=W[i].str.wf.tree[a].ob_head;
				a=W[i].str.wf.tree[a].ob_tail;
				do
				{
					if (W[i].str.wf.tree[b].ob_flags&RBUTTON && b!=n && W[i].str.wf.tree[b].ob_state&SELECTED)
					{
						W[i].str.wf.tree[b].ob_state&=~SELECTED;
						_coord(W[i].str.wf.tree,b,TRUE,&obx,&oby,&obw,&obh);
						graf_mouse(M_OFF,0);
						wind_update(BEG_UPDATE);
						_winObdraw(i,W[i].str.wf.tree,b,MAX_DEPTH,obx,oby,obw,obh);
						wind_update(END_UPDATE);
						graf_mouse(M_ON,0);
					}
					b=W[i].str.wf.tree[b].ob_next;
				} while (b<=a && b>W[i].str.wf.tree[a].ob_next);

				if (!(W[i].str.wf.tree[n].ob_state&SELECTED))
				{
					W[i].str.wf.tree[n].ob_state^=SELECTED;
					_coord(W[i].str.wf.tree,n,TRUE,&obx,&oby,&obw,&obh);
					graf_mouse(M_OFF,0);
					wind_update(BEG_UPDATE);
					_winObdraw(i,W[i].str.wf.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					wind_update(END_UPDATE);
					graf_mouse(M_ON,0);
				}
				if (W[i].id&FLAGS15)
					_myClic(W[i].id,n,nmb);
				else if (glb.func.gClicF!=0)
					(*glb.func.gClicF)(W[i].id,n,nmb);
			}

			/*	Cas d'un bouton TOUCHEXIT	*/
			else if (flags&TOUCHEXIT && !(flags&SELECTABLE))
			{
				do
				{
					obj=W[i].str.wf.tree;
					graf_mkstate(&mx,&my,&mk,&dum);
					if ( (obj[n].ob_type&0xFF00) == USD_NUM )
					{
						if (mk==2)
							d=max(10,(user->user2-user->user1)/500U);
						else
							d=user->user3;
						c=user->user4;
						_coord(obj,n,FALSE,&obx,&oby,&obw,&obh);
						if (mx<=obx+iglb.rsc.head.trindex[FUSER][FUSDLAR].ob_width)
						{
							if (user->user4>=user->user1+d)
								c=user->user4-d;
							else
								c=user->user1;
						}
						if (mx>=obx+obw-iglb.rsc.head.trindex[FUSER][FUSDRAR].ob_width)
						{
							if (user->user4<=user->user2-d)
								c=user->user4+d;
							else
								c=user->user2;
						}
						if (c!=user->user4)
						{
							user->user4=c;
							c=1;
							sprintf((char *)(user->spec),"%u",user->user4);
							graf_mouse(M_OFF,0);
							wind_update(BEG_UPDATE);
							_winObdraw(i,obj,n,MAX_DEPTH,obx,oby,obw,obh);
							wind_update(END_UPDATE);
							graf_mouse(M_ON,0);
						}
						else
							c=0;
					}
					else
						c=1;
					if (c)
					{
						if (W[i].id&FLAGS15)
							_myClic(W[i].id,n,nmb);
						else if (glb.func.gClicF)
							(*glb.func.gClicF)(W[i].id,n,nmb);
						switch (mk)
						{
							case	2:
							case	3:
								evnt_timer(75,0);
								break;
							case	1:
								evnt_timer(40,0);
								break;
						}
					}
				}	while (mk>0 && objc_find(W[i].str.wf.tree,ROOT,MAX_DEPTH,mx,my)==n);
			}

			if (flags&EXIT && W[i].str.wf.tree[n].ob_state&SELECTED)
			{
				W[i].str.wf.tree[n].ob_state^=SELECTED;
				_closed(i);
			}
		}
	}
}
#pragma warn +par


/*******************************************************************************
	Redraw an object in a WForm
*******************************************************************************/
void _winObdraw(int i,OBJECT *tree,int obj, int dept, int x,int y,int w,int h)
{
	GRECT		rd,r;
	int		ha=W[i].handle;

	if (i!=-1)
	if (W[i].type==TW_FORM)
	{
		rd.g_x=x;
		rd.g_y=y;
		rd.g_w=w;
		rd.g_h=h;

		wind_get(ha,WF_FIRSTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
		while (r.g_w && r.g_h)
		{
			if (_rcIntersect(&rd,&r))
			{
				if ( ((tree[obj].ob_type&0xFF)==G_CICON) || ( ((tree[obj].ob_type&0xFF)==G_USERDEF) &&
					((UBLK *)tree[obj].ob_spec.userblk->ub_parm)->type==G_CICON) )
					objc_draw(tree,ROOT,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
				else
					objc_draw(tree,obj,dept,r.g_x,r.g_y,r.g_w,r.g_h);

				if (W[i].str.wf.obj!=-1)
				{
					_setClip(TRUE,&r);
					_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_INIT);
					_setClip(FALSE,&r);
				}
			}
			wind_get(ha,WF_NEXTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
		}
	}
}


/*******************************************************************************
	objc_edit clone: draw the | on an EDITABLE or handle key
*******************************************************************************/
int _objcEdit(OBJECT *tree,int obj,int kc,int *idx,int mode)
{
	UBLK		*user;
	TEDINFO	*ted;
	GRECT		clip;
	uchar		*p,*q,*r,car[2];
	int		X,ret=0,dum,state,type,pnt,vect,ind,extent[8],pxy[4],lattr[6],tattr[10],x,y,w,h;

	_coord(tree,obj,FALSE,&clip.g_x,&clip.g_y,&clip.g_w,&clip.g_h);
	_coord(tree,obj,FALSE,&x,&y,&w,&h);
   vql_attributes(glb.vdi.ha,lattr);
	vsl_type(glb.vdi.ha,SOLID);
	vsl_width(glb.vdi.ha,1);
	vsl_color(glb.vdi.ha,BLACK);
   vqt_attributes(glb.vdi.ha,tattr);
	vswr_mode(glb.vdi.ha,MD_REPLACE);
	state=tree[obj].ob_state;
	type=tree[obj].ob_type>>8;
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment(glb.vdi.ha,ALI_LEFT,ALI_BASE,&dum,&dum);
	user=(UBLK *)tree[obj].ob_spec.userblk->ub_parm;
	ted=(TEDINFO *)user->spec;
	if (ted->te_font==3)
		pnt=10-2*glb.vdi.low;
	else
		pnt=8-glb.vdi.low;
	if (state&STATE10)
	{
		ind=glb.opt.Gem_Dfont;
		if (type!=0)		pnt=type;
		if (pnt<12)			pnt=10-glb.vdi.low;
		else if (pnt<18)	pnt=12;
		else if (pnt<24)	pnt=18;
		else if (pnt<36)	pnt=24;
		else if (pnt<48)	pnt=36;
		else if (pnt<72)	pnt=48;
		else if (pnt<96)	pnt=72;
		else					pnt=96;
	}
	else if (state&STATE8)
	{
		ind=glb.opt.Gem_Ifont;
		if (type!=0)		pnt=type;
		if (pnt<12)			pnt=10-glb.vdi.low;
		else if (pnt<18)	pnt=12;
		else if (pnt<24)	pnt=18;
		else if (pnt<36)	pnt=24;
		else if (pnt<48)	pnt=36;
		else if (pnt<72)	pnt=48;
		else if (pnt<96)	pnt=72;
		else					pnt=96;
	}
	else if (state&STATE11)
	{
		ind=glb.opt.Hlp_Ifont;
		if (type!=0)		pnt=type;
		if (pnt<12)			pnt=10-glb.vdi.low;
		else if (pnt<18)	pnt=12;
		else if (pnt<24)	pnt=18;
		else if (pnt<36)	pnt=24;
		else if (pnt<48)	pnt=36;
		else if (pnt<72)	pnt=48;
		else if (pnt<96)	pnt=72;
		else					pnt=96;
	}
	else if (state&STATE9)
		ind=1;
	else
		ind=glb.opt.Gem_font;
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,glb.font[ind].index);
	vect=glb.font[ind].name[32];
	if (vect)
		vst_arbpt(glb.vdi.ha,pnt,&dum,&dum,&dum,&dum);
	else
		vst_point(glb.vdi.ha,pnt,&dum,&dum,&dum,&dum);
	car[1]=0;

	if (mode&ED_CLIP)
		_setClip(TRUE,&clip);

	switch	(mode&0xFF)
	{
		case	ED_INIT:
			p=(uchar *)ted->te_ptmplt;
			q=(uchar *)ted->te_ptext;
			*idx=min(*idx,(int)strlen((char *)q));
			w=0;
			do
			{
				if (*p=='_')
				{
					if (w==*idx)
					{
						pxy[0]=x;
						pxy[1]=y;
						pxy[2]=x;
						pxy[3]=y+h-1;
						v_pline(glb.vdi.ha,2,pxy);
						pxy[0]+=1;
						pxy[2]+=1;
						v_pline(glb.vdi.ha,2,pxy);
						ret=x;
					}
					if (*q==0)
						car[0]='_';
					else
						car[0]=*q;
					q++;
					w++;
				}
				else
					car[0]=*p;
				if (vect)
					vqt_f_extent(glb.vdi.ha,(char *)car,extent);
				else
					vqt_extent(glb.vdi.ha,(char *)car,extent);
				x+=extent[2]-extent[6];
				if (*p=='_')
					X=x;
				p++;
				if (*p==0)
					dum=1;
			}
			while ( (*p!=0) && (!ret) );
			if ( (!ret) && (w==*idx) )
			{
				pxy[0]=X;
				pxy[1]=y;
				pxy[2]=X;
				pxy[3]=y+h-1;
				v_pline(glb.vdi.ha,2,pxy);
				pxy[0]+=1;
				pxy[2]+=1;
				v_pline(glb.vdi.ha,2,pxy);
				ret=X;
			}
			break;
		case	ED_CHAR:
			dum=0;
			if ( strlen(ted->te_ptext) == ted->te_txtlen-1 )
				*idx-=1;
			switch	(ted->te_pvalid[*idx])
			{
				case	'9':
					if ( (kc>='0') && (kc<='9') )
						dum=1;
					break;
				case	'A':
					if ( (kc==' ') ||( (kc>='A') && (kc<='Z') ))
						dum=1;
					break;
				case	'a':
					if ( (kc==' ') || ((kc>='A')&&(kc<='Z')) || ((kc>='a')&&(kc<='z')) )
						dum=1;
					break;
				case	'N':
					if ( (kc==' ') || ((kc>='A')&&(kc<='Z')) || ((kc>='0')&&(kc<='9')) )
						dum=1;
					break;
				case	'n':
					if ( (kc==' ') || ((kc>='A')&&(kc<='Z')) || ((kc>='a')&&(kc<='z')) || ((kc>='0')&&(kc<='9')) )
						dum=1;
					break;
				case	'F':
					kc=toupper(kc);
					if ( (kc==' ') || ((kc>='0')&&(kc<='9')) || ((kc>='A')&&(kc<='Z'))
						|| (kc=='_') || (kc=='?') || (kc=='*') || (kc=='.') )
							dum=1;
					break;
				case	'f':
					kc=toupper(kc);
					if ( (kc==' ') || ((kc>='0')&&(kc<='9')) || ((kc>='A')&&(kc<='Z')) || (kc=='_') || (kc=='.') )
							dum=1;
					break;
				case	'P':
					kc=toupper(kc);
					if ( (kc==' ') || ((kc>='0')&&(kc<='9')) || ((kc>='A')&&(kc<='Z'))
						|| (kc=='_') || (kc=='?') || (kc=='*') || (kc=='\\') || (kc=='/') || (kc=='.') )
							dum=1;
					break;
				case	'p':
					kc=toupper(kc);
					if ( (kc==' ') || ((kc>='0')&&(kc<='9')) || ((kc>='A')&&(kc<='Z'))
						|| (kc=='_') || (kc=='\\') || (kc=='/') || (kc=='.') )
							dum=1;
					break;
				case	'X':
					dum=1;
			}
			if ( strlen(ted->te_ptext) == ted->te_txtlen-1 )
				if (dum)
					ted->te_ptext[ted->te_txtlen-2]=0;
				else
					*idx+=1;
			if (kc=='.')
			{
				p=(uchar *)ted->te_ptmplt;
				q=(uchar *)ted->te_ptext;
				w=0;
				do
				{
					if (*p=='_')
					{
						q++;
						w++;
					}
					p++;
				}	while ( (*p!=0) && (w<*idx) );
				r=(uchar *)strchr((char *)p,'.');
				if (r!=NULL)
				{
					ret=1;
					do
					{
						if (*p=='_')
						{
							*q++=' ';
							*q=0;
							w++;
							(*idx)+=1;
						}
						p++;
					}	while ( (*p!=0) && (p!=r) );
				}
			}

			if ( (dum) && (!ret) )
			{
				p=(uchar *)ted->te_ptext;
				p+=*idx;
				q=(uchar *)ted->te_ptext;
				q+=strlen((char *)q)+1;
				r=(uchar *)ted->te_ptext;
				r+=strlen((char *)r);
				while (p<q)
				{
					*q=*r;
					q--;
					r--;
				}
				*q=kc&0xFF;
				*idx+=1;
			}
			break;
	}

	if (mode&ED_CLIP)
		_setClip(FALSE,&clip);

	vswr_mode(glb.vdi.ha,tattr[5]);
	vsl_type(glb.vdi.ha,lattr[0]);
	vsl_color(glb.vdi.ha,lattr[1]);
	vst_effects(glb.vdi.ha,TXT_NORMAL);
	vst_alignment(glb.vdi.ha,tattr[3],tattr[4],&dum,&dum);
	if (glb.vdi.gdos)
		vst_font(glb.vdi.ha,tattr[0]);
	return ret;
}


/*******************************************************************************
*******************************************************************************/
int _winForm(int tree,char *name,char *sname,char *help,int popup,int ic_tree,int icon,int modal)
{
	int			x,y,w,h,i=-1;
	OBJECT		*adr;
	char			buf[sizeof(window)];
	window		*win;
	int			obj=-1;
	int			dum,edt=-1;

	win=(window *)buf;

	if (tree&FLAGS15)
		adr=iglb.rsc.head.trindex[tree&~FLAGS15];
	else
		adr=glb.rsc.head.trindex[tree];

	strcpy(win->name,name);
	strcpy(win->sname,sname);
	strcpy(win->help,help);

	win->gadget=modal*wMODAL+wMOVE+wCLOSE+wCYCLE+wICON;

	for (dum=0;dum<glb.opt.Win_Num;dum++)
		if (W[dum].type==TW_FORM && W[dum].id==tree)
		{
			i=dum;
			dum=glb.opt.Win_Num;
		}

	if (iglb.aes.x!=-1)
	{
		x=iglb.aes.x;
		y=iglb.aes.y;
		w=iglb.aes.w;
		h=iglb.aes.h;
	}
	else if (!glb.opt.Mouse_Form)
		form_center(adr,&x,&y,&w,&h);
	else
	{
		if ( (i==-1) || (glb.opt.Mouse_Form==2) )
		{
			graf_mkstate(&x,&y,&dum,&dum);
			w=adr->ob_width;
			h=adr->ob_height;
			x-=w/2;
			x=max(glb.aes.xdesk,x);
			x=min(glb.aes.xdesk+glb.aes.wdesk-w,x);
			y-=h/2;
			y=max(glb.aes.ydesk,y);
			y=min(glb.aes.ydesk+glb.aes.hdesk-h,y);
		}
		else
		{
			x=W[i].xwork;
			y=W[i].ywork;
			w=W[i].wwork;
			h=W[i].hwork;
		}
	}
	win->xwind=-1;
	win->xwork=win->xfull=x;
	win->ywork=win->yfull=y;
	win->wwork=win->wfull=adr->ob_width;
	win->hwork=win->hfull=adr->ob_height;

	win->popup		=	popup;
	win->icon		=	icon;
	win->ic_tree	=	ic_tree;
	win->type		=	TW_FORM;
	win->id			=	tree;

	win->top			=	0;
	win->full		=	0;
	win->arrow		=	0;
	win->hslid		=	0;
	win->vslid		=	0;
	win->size		=	0;
	win->ontop		=	0;
	win->small		=	0;
	win->nsmall		=	0;
	win->init		=	0;
	win->redraw		=	_redrawForm;
	win->keybd		=	_keybdForm;
	win->move		=	_moveForm;
	win->clic		=	_clicForm;
	win->close		=	_closeForm;
	win->untop		=	0;

	if (tree&FLAGS15)
		win->pop=0;
	else
		win->pop=glb.func.wPop;

	if (popup!=-1)
		win->gadget+=wMENU;

	i=_winOpen(win);
	if (i!=-1)
	{
		W[i].str.wf.pos=0;
		W[i].str.wf.obj=-1;
		W[i].str.wf.tree=adr;
		do
		{
			obj+=1;
			if ( (edt==-1) && (adr[obj].ob_flags&EDITABLE) && ((adr[obj].ob_type&0xFF)==G_USERDEF) )
			{
				dum=((UBLK *)adr[obj].ob_spec.userblk->ub_parm)->type;
				if ( (dum==G_FTEXT) || (dum==G_FBOXTEXT) )
					edt=obj;
			}
		}	while (!(adr[obj].ob_flags&LASTOB));
		W[i].str.wf.obj		=	edt;
		if (W[i].str.wf.obj!=-1)
			W[i].str.wf.pos=(int)strlen(_obGetStr(adr,W[i].str.wf.obj));
	}
	return i;
}


/*******************************************************************************
	Init lib windows
*******************************************************************************/
void _myInitForm(int obj,int n)
{
	switch	(obj&~FLAGS15)
	{
		case	FFNT:		_myInitFonte(n);		break;
		case	FOPT:		_myInitOptions(n);	break;
		case	FICN:		_myInitIcone(n);		break;
		case	FMEM:		_myInitMemoire(n);	break;
		case	FSYS:		_myInitSysteme(n);	break;
	}
}
static void _myInitFonte(int n)
{
	OBJECT	*tree=iglb.rsc.head.trindex[FFNT];
	char		txt[4];

	switch	(n)
	{
		case	FFNTGPOP:
			if ( (glb.vdi.gdos) && (glb.vdi.nfont>1) )
				_initXPopUp(tree,n,glb.font[1].name,glb.vdi.nfont,4,32,glb.opt.Gem_Ifont-1);
			else
			{
				tree[n].ob_state|=DISABLED;
				_obPutStr(tree,n,"System Font");
			}
			break;
		case	FFNTGTYP:
			tree[n].ob_flags|=HIDETREE;
			if ( (glb.vdi.gdos) && (glb.vdi.nfont>1) )
				if (glb.font[glb.opt.Gem_Ifont].name[32])
					tree[n].ob_flags&=~HIDETREE;
			break;
		case	FFNTGNOM:
			if ( (!glb.vdi.gdos) || (glb.vdi.nfont<=1) )
				tree[n].ob_state|=DISABLED;
			((TEDINFO*)((UBLK *)tree[n].ob_spec.userblk->ub_parm)->spec)->te_font=3;
			break;
		case	FFNTHPOP:
			if ( (glb.vdi.gdos) && (glb.vdi.nfont>1) )
				_initXPopUp(tree,n,glb.font[1].name,glb.vdi.nfont,4,32,glb.opt.Hlp_Ifont-1);
			else
			{
				tree[n].ob_state|=DISABLED;
				_obPutStr(tree,n,"System Font");
			}
			break;
		case	FFNTHTYP:
			tree[n].ob_flags|=HIDETREE;
			if ( (glb.vdi.gdos) && (glb.vdi.nfont>1) )
				if (glb.font[glb.opt.Hlp_Ifont].name[32])
					tree[n].ob_flags&=~HIDETREE;
			break;
		case	FFNTHNOM:
			if ( (!glb.vdi.gdos) || (glb.vdi.nfont<=1) )
				tree[n].ob_state|=DISABLED;
			((TEDINFO*)((UBLK *)tree[n].ob_spec.userblk->ub_parm)->spec)->te_font=3;
			break;
		case	FFNTCTXT:
			_initPopUp(tree,n,PCOUL|FLAGS15,glb.opt.Hlp_Color_Text);
			break;
		case	FFNTCFON:
			_initPopUp(tree,n,PCOUL|FLAGS15,glb.opt.Hlp_Color_Back);
			break;
		case	FFNTHSIZ:
			sprintf(txt,"%i",glb.opt.Hlp_Font_Size);
			_obPutStr(tree,n,txt);
			break;
	}
}
static void _myInitOptions(int n)
{
	OBJECT	*tree=iglb.rsc.head.trindex[FOPT];

	switch	(n)
	{
		case	FOPTFNT:
			if (glb.vdi.gdos)
			{
				if (glb.opt.Use_Font_Gem)
				{
					tree[n].ob_state|=SELECTED;
					glb.opt.Gem_font=glb.opt.Gem_Dfont;
					glb.opt.Gem_Ifont=glb.opt.Gem_Dfont;
				}
				else
					tree[n].ob_state&=~SELECTED;
			}
			else
			{
				tree[n].ob_state|=DISABLED;
				glb.opt.Gem_Ifont=1;
				glb.opt.Gem_font=1;
			}
			break;
		case	FOPTHLP:
			if (glb.vdi.gdos)
			{
				if (glb.opt.Use_Font_Hlp)
					tree[n].ob_state|=SELECTED;
				else
					tree[n].ob_state&=~SELECTED;
			}
			else
			{
				tree[n].ob_state|=DISABLED;
				glb.opt.Hlp_Ifont=1;
				glb.opt.Hlp_font=1;
			}
			break;
		case	FOPTPOP:
			if (glb.opt.Flash_PopUp)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FOPTLOG:
			if (glb.opt.Log_File)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FOPTSAV:
			if (glb.opt.Save_Config)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FOPTFRM1:
			if (glb.opt.Mouse_Form==0)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FOPTFRM2:
			if (glb.opt.Mouse_Form==1)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FOPTFRM3:
			if (glb.opt.Mouse_Form==2)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FOPTFR:
			if (glb.opt.Av_Lang&L_FRENCH)
			{
				if (glb.opt.Language==L_FRENCH)
					tree[n].ob_state|=SELECTED;
				else
					tree[n].ob_state&=~SELECTED;
			}
			else
				tree[n].ob_state|=DISABLED;
			break;
		case	FOPTEN:
			if (glb.opt.Av_Lang&L_ENGLISH)
			{
				if (glb.opt.Language==L_ENGLISH)
					tree[n].ob_state|=SELECTED;
				else
					tree[n].ob_state&=~SELECTED;
			}
			else
				tree[n].ob_state|=DISABLED;
			break;
		case	FOPTDE:
			if (glb.opt.Av_Lang&L_DEUTSCH)
			{
				if (glb.opt.Language==L_DEUTSCH)
					tree[n].ob_state|=SELECTED;
				else
					tree[n].ob_state&=~SELECTED;
			}
			else
				tree[n].ob_state|=DISABLED;
			break;
	}
}
static void _myInitIcone(int n)
{
	OBJECT	*tree=iglb.rsc.head.trindex[FICN];

	switch	(n)
	{
		case	FICNOTO:
			if (glb.opt.Auto_Icon)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FICNBIG:
			if (glb.opt.Big_Icon)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FICNG:
			if (!glb.opt.Rev_Verti)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FICND:
			if (glb.opt.Rev_Verti)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FICNH:
			if (!glb.opt.Rev_Horiz)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FICNB:
			if (glb.opt.Rev_Horiz)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FICNSWP:
			_putPath(tree,n,34,iglb.div.SWP_Path);
			break;
	}
}
static void _myInitMemoire(int n)
{
	OBJECT	*tree=iglb.rsc.head.trindex[FMEM];
	int		i;
	long		m;
	char		txt[10];

	switch	(n)
	{
		case	FMEMSYS:
			m=_freeSys()/1024L;
			sprintf(txt,"%6li K",m);
			_obPutStr(tree,n,txt);
			break;
		case	FMEMLEN:
			m=0;
			for (i=0;i<MEM_NMB;i++)
				m+=mem.Blen[i];
			m/=1024L;
			sprintf(txt,"%li",m);
			_obPutStr(tree,n,txt);
			break;
		case	FMEMFRE:
			m=0;
			for (i=0;i<mem.n;i++)
				if (mem.bloc[i].type!=MB_IGNORE) m+=mem.bloc[i].len;
			m/=1024L;
			sprintf(txt,"%6li K",m);
			_obPutStr(tree,n,txt);
			break;
		case	FMEM1:
			if (glb.opt.Mem_Boot<0)
				tree[n].ob_state|=SELECTED;
			else
				tree[n].ob_state&=~SELECTED;
			break;
		case	FMEM2:
			if (glb.opt.Mem_Boot<0)
				tree[n].ob_state&=~SELECTED;
			else
				tree[n].ob_state|=SELECTED;
			break;
		case	FMEMN:
			if (glb.opt.Mem_Boot>0 && glb.opt.Mem_Boot<100)
				sprintf(txt,"%li%%",glb.opt.Mem_Boot);
			else
				sprintf(txt,"%lik",labs(glb.opt.Mem_Boot));
			_obPutStr(tree,n,txt);
			break;
	}
}
static void _myInitSysteme(int n)
{
	OBJECT	*tree=iglb.rsc.head.trindex[FSYS];
	char		txt[30];
	long		adr;
	int		dum;

	switch	(n)
	{
		case	FSYSMCH:
			switch	(glb.div.MCH)
			{
				case	0:		_obPutStr(tree,n,"ST");				break;
				case	1:		_obPutStr(tree,n,"STE");			break;
				case	2:		_obPutStr(tree,n,"MegaSTE");		break;
				case	3:		_obPutStr(tree,n,"TT");				break;
				case	4:		_obPutStr(tree,n,"Falcon030");	break;
				default:		_obPutStr(tree,n,"???");			break;
			}
			break;
		case	FSYSPROC:
			sprintf(txt,"%li",68000L+_cookie('_CPU'));
			switch	((int)_cookie('_FPU'))
			{
				case	1:		strcat(txt,"/SFP004");				break;
				case	2:		strcat(txt,"/6888?");				break;
				case	3:		strcat(txt,"/6888?/SFP004");		break;
				case	4:		strcat(txt,"/68881");				break;
				case	5:		strcat(txt,"/68881/SFP004");		break;
				case	6:		strcat(txt,"/68882");				break;
				case	7:		strcat(txt,"/68882/SFP004");		break;
				case	8:		strcat(txt,"/68040");				break;
				case	9:		strcat(txt,"/68040/SFP004");		break;
			}
			_obPutStr(tree,n,txt);
			break;
		case	FSYSREZ:
			if (glb.vdi.extnd[5])
				sprintf(txt,"%lix%lix%lic",(long)(1+glb.vdi.wscr),(long)(1+glb.vdi.hscr),1L<<min(24,glb.vdi.extnd[4]));
			else
				sprintf(txt,"%lix%li TRUE COLOR",(long)(1+glb.vdi.wscr),(long)(1+glb.vdi.hscr));
			_obPutStr(tree,n,txt);
			break;
		case	FSYSTOS:
			sprintf(txt,"%x.%02x",glb.div.TOS>>8,glb.div.TOS&0xFF);
			_obPutStr(tree,n,txt);
			break;
		case	FSYSGDOS:
			switch	(glb.vdi.gdos)
			{
				case	0:		strcpy(txt,iglb.rsc.head.frstr[NON]);	break;
				case	1:		strcpy(txt,iglb.rsc.head.frstr[OUI]);	break;
				case	2:		strcpy(txt,"Font");		break;
				case	3:		strcpy(txt,"FSM");		break;
				case	4:		strcpy(txt,"Speedo");	break;
				default:		strcpy(txt,"???");		break;
			}
			_obPutStr(tree,n,txt);
			break;
		case	FSYSAES:
			sprintf(txt,"%x.%02x",glb.aes.ver>>8,glb.aes.ver&0xFF);
			_obPutStr(tree,n,txt);
			break;
		case	FSYSMINT:
			dum=(int)_cookie('MiNT');
			if (dum==0)
				strcpy(txt,iglb.rsc.head.frstr[NON]);
			else
				sprintf(txt,"%x.%02i",dum>>8,dum&0xFF);
			_obPutStr(tree,n,txt);
			break;
		case	FSYSNVDI:
			adr=_cookie('NVDI');
			if (adr)
				sprintf(txt,"%x.%02x" ,_CARD(adr)>>8,_CARD(adr)&0xFF);
			else
				strcpy(txt,iglb.rsc.head.frstr[NON]);
			_obPutStr(tree,n,txt);
			break;
		case	FSYSLET:
			adr=_cookie('LTMF');
			if (adr)
				sprintf(txt,"%x.%02x" ,_CARD(adr)>>8,_CARD(adr)&0xFF);
			else
				strcpy(txt,iglb.rsc.head.frstr[NON]);
			_obPutStr(tree,n,txt);
			break;
	}
}


/*******************************************************************************
	Handles lib windows clic
*******************************************************************************/
#pragma warn -par
static void _myClic(int obj,int n,int nmb)
{
	switch	(obj&~FLAGS15)
	{
		case	FFNT:		_myClicFonte(n,nmb);		break;
		case	FOPT:		_myClicOptions(n,nmb);	break;
		case	FICN:		_myClicIcone(n,nmb);		break;
		case	FMEM:		_myClicMemoire(n,nmb);	break;
	}
}
static void _myClicFonte(int n,int nmb)
{
	OBJECT	*tree;
	int		i;
	int		obx,oby,obw,obh;

	tree=iglb.rsc.head.trindex[FFNT];
	switch	(n)
	{
		case	FFNTCTXT:
			i=_getPopUp(tree,n);
			if (i!=glb.opt.Hlp_Color_Text)
			{
				glb.opt.Hlp_Color_Text=i;
				i=_winFindId(TW_HELP,0,TRUE);
				_redraw(i,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
			}
			break;
		case	FFNTCFON:
			i=_getPopUp(tree,n);
			if (i!=glb.opt.Hlp_Color_Back)
			{
				glb.opt.Hlp_Color_Back=i;
				i=_winFindId(TW_HELP,0,TRUE);
				_redraw(i,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
			}
			break;

		case	FFNTGPOP:
			i=_getPopUp(tree,n)+1;
			if (i!=glb.opt.Gem_Ifont)
			{
				glb.opt.Gem_Ifont=i;
				strncpy(iglb.fnt.Gem_Ifont,glb.font[i].name,32L);
				tree[FFNTGTYP].ob_flags|=HIDETREE;
				if ( (glb.vdi.gdos) && (glb.vdi.nfont>1) )
					if (glb.font[glb.opt.Gem_Ifont].name[32])
						tree[FFNTGTYP].ob_flags&=~HIDETREE;
				i=_winFindId(TW_FORM,FFNT|FLAGS15,TRUE);
				wind_update(BEG_UPDATE);
				_coord(tree,FFNTGNOM,TRUE,&obx,&oby,&obw,&obh);
				_winObdraw(i,tree,FFNTGNOM,MAX_DEPTH,obx,oby,obw,obh);
				_coord(tree,FFNTGTYP,TRUE,&obx,&oby,&obw,&obh);
				_winObdraw(i,tree,ROOT,MAX_DEPTH,obx,oby,obw,obh);
				wind_update(END_UPDATE);
			}
			break;
		case	FFNTGNOM:
			wind_update(BEG_UPDATE);
			_coord(tree,n,TRUE,&obx,&oby,&obw,&obh);
			_winObdraw(_winFindId(TW_FORM,FFNT|FLAGS15,TRUE),tree,n,MAX_DEPTH,obx,oby,obw,obh);
			wind_update(END_UPDATE);
			tree[n].ob_state&=~SELECTED;
			if (glb.opt.Use_Font_Gem)
			{
				glb.opt.Gem_font=glb.opt.Gem_Ifont;
				strncpy(iglb.fnt.Gem_font,glb.font[glb.opt.Gem_Ifont].name,32L);
			}
			glb.opt.Gem_Dfont=glb.opt.Gem_Ifont;
			strncpy(iglb.fnt.Gem_Dfont,glb.font[glb.opt.Gem_Ifont].name,32L);
				for (i=0;i<glb.opt.Win_Num;i++)
					if (W[i].handle>0)
						_redraw(i,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
			break;
		case	FFNTHPOP:
			i=_getPopUp(tree,n)+1;
			if (i!=glb.opt.Hlp_Ifont)
			{
				glb.opt.Hlp_Ifont=i;
				strncpy(iglb.fnt.Hlp_Ifont,glb.font[i].name,32L);
				tree[FFNTHTYP].ob_flags|=HIDETREE;
				if ( (glb.vdi.gdos) && (glb.vdi.nfont>1) )
					if (glb.font[glb.opt.Hlp_Ifont].name[32])
						tree[FFNTHTYP].ob_flags&=~HIDETREE;
				i=_winFindId(TW_FORM,FFNT|FLAGS15,TRUE);
				wind_update(BEG_UPDATE);
				_coord(tree,FFNTHNOM,TRUE,&obx,&oby,&obw,&obh);
				_winObdraw(i,tree,FFNTHNOM,MAX_DEPTH,obx,oby,obw,obh);
				_coord(tree,FFNTHTYP,TRUE,&obx,&oby,&obw,&obh);
				_winObdraw(i,tree,ROOT,MAX_DEPTH,obx,oby,obw,obh);
				wind_update(END_UPDATE);
			}
			break;
		case	FFNTHNOM:
			if (glb.opt.Use_Font_Gem)
			{
				glb.opt.Hlp_font=glb.opt.Hlp_Ifont;
				strncpy(iglb.fnt.Hlp_font,glb.font[glb.opt.Hlp_Ifont].name,32L);
			}
			glb.opt.Hlp_Dfont=glb.opt.Hlp_Ifont;
			strncpy(iglb.fnt.Hlp_Dfont,glb.font[glb.opt.Hlp_Ifont].name,32L);
			i=_winFindId(TW_HELP,0,TRUE);
			if (i!=-1)
			{
				_initHelp();
				_redraw(i,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
			}
			tree[n].ob_state&=~SELECTED;
			wind_update(BEG_UPDATE);
			_coord(tree,n,TRUE,&obx,&oby,&obw,&obh);
			_winObdraw(_winFindId(TW_FORM,FFNT|FLAGS15,TRUE),tree,n,MAX_DEPTH,obx,oby,obw,obh);
			wind_update(END_UPDATE);
			break;
		case	FFNTHSET:
			i=atoi(_obGetStr(tree,FFNTHSIZ));
			if (i>0 && i!=glb.opt.Hlp_Font_Size)
			{
				glb.opt.Hlp_Font_Size=i;
				_initHelp();
				i=_winFindId(TW_HELP,0,TRUE);
				_redraw(_winFindId(TW_HELP,0,TRUE),W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
			}
			tree[n].ob_state&=~SELECTED;
			wind_update(BEG_UPDATE);
			_coord(tree,n,TRUE,&obx,&oby,&obw,&obh);
			_winObdraw(_winFindId(TW_FORM,FFNT|FLAGS15,TRUE),tree,n,MAX_DEPTH,obx,oby,obw,obh);
			wind_update(END_UPDATE);
			break;
	}
}
static void _myClicOptions(int n,int nmb)
{
	OBJECT	*tree;
	int		i;

	tree=iglb.rsc.head.trindex[FOPT];
	switch	(n)
	{
		case	FOPTPOP:
			glb.opt.Flash_PopUp=tree[n].ob_state&SELECTED;
			break;
		case	FOPTFNT:
			if (tree[n].ob_state&SELECTED)
			{
				glb.opt.Use_Font_Gem=1;
				glb.opt.Gem_font=glb.opt.Gem_Dfont;
			}
			else
			{
				glb.opt.Use_Font_Gem=0;
				glb.opt.Gem_font=1;
			}
			for (i=0;i<glb.opt.Win_Num;i++)
				if (W[i].handle>0)
					_redraw(i,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
			break;
		case	FOPTHLP:
			if (tree[n].ob_state&SELECTED)
			{
				glb.opt.Use_Font_Hlp=1;
				glb.opt.Hlp_font=glb.opt.Hlp_Dfont;
			}
			else
			{
				glb.opt.Use_Font_Hlp=0;
				glb.opt.Hlp_font=1;
			}
			i=_winFindId(TW_HELP,0,TRUE);
			_redraw(_winFindId(TW_HELP,0,TRUE),W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
			break;
		case	FOPTLOG:
			glb.opt.Log_File=tree[n].ob_state&SELECTED;
			break;
		case	FOPTSAV:
			glb.opt.Save_Config=tree[n].ob_state&SELECTED;
			break;
		case	FOPTFRM1:
			if (tree[n].ob_state&SELECTED)
				glb.opt.Mouse_Form=0;
			break;
		case	FOPTFRM2:
			if (tree[n].ob_state&SELECTED)
				glb.opt.Mouse_Form=1;
			break;
		case	FOPTFRM3:
			if (tree[n].ob_state&SELECTED)
				glb.opt.Mouse_Form=2;
			break;
		case	FOPTFR:
			if (glb.opt.Language!=L_FRENCH)
				glb.opt.Language=L_FRENCH;
			break;
		case	FOPTEN:
			if (glb.opt.Language!=L_ENGLISH)
				glb.opt.Language=L_ENGLISH;
			break;
		case	FOPTDE:
			if (glb.opt.Language!=L_DEUTSCH)
				glb.opt.Language=L_DEUTSCH;
			break;
	}
}
static void _myClicIcone(int n,int nmb)
{
	OBJECT	*tree;
	int		obx,oby,obw,obh;

	tree=iglb.rsc.head.trindex[FICN];
	switch	(n)
	{
		case	FICNOTO:
			glb.opt.Auto_Icon=tree[n].ob_state&SELECTED;
			_winAlign();
			break;
		case	FICNBIG:
			glb.opt.Big_Icon=tree[n].ob_state&SELECTED;
			_winAlign();
			break;
		case	FICNG:
			glb.opt.Rev_Verti=!tree[n].ob_state&SELECTED;
			_winAlign();
			break;
		case	FICND:
			glb.opt.Rev_Verti=tree[n].ob_state&SELECTED;
			_winAlign();
			break;
		case	FICNH:
			glb.opt.Rev_Horiz=!tree[n].ob_state&SELECTED;
			_winAlign();
			break;
		case	FICNB:
			glb.opt.Rev_Horiz=tree[n].ob_state&SELECTED;
			_winAlign();
			break;
		case	FICNSWP:
			if (tree[n].ob_state&SELECTED)
			{
				strcpy(glb.div.pname,"");
				strcpy(glb.div.fname,"");
				strcpy(glb.div.pfname,iglb.div.SWP_Path);
				strcpy(glb.div.tit,iglb.rsc.head.frstr[FSELSWP]);
				wind_update(BEG_MCTRL);
				if (_fselect(glb.div.pfname,glb.div.pname,glb.div.fname,glb.div.ext,glb.div.tit))
				{
					strcpy(iglb.div.SWP_Path,glb.div.pname);
					strcat(iglb.div.SWP_Path,"\\");
				}
				_putPath(tree,n,34,iglb.div.SWP_Path);
				tree[n].ob_state&=~SELECTED;
				wind_update(END_MCTRL);
				_coord(tree,n,TRUE,&obx,&oby,&obw,&obh);
				_winRedraw(_winFindId(TW_FORM,FICN|FLAGS15,TRUE),obx,oby,obw,obh);
			}
			break;
	}
}
static void _myClicMemoire(int n,int nmb)
{
	OBJECT	*tree;
	long		len;
	int		obx,oby,obw,obh,dum;
	char		*p;

	tree=iglb.rsc.head.trindex[FMEM];
	switch	(n)
	{
		case	FMEMMOD:
		case	FMEMMIN:
		case	FMEMMAX:
			if (tree[n].ob_state&SELECTED)
			{
				tree[n].ob_state&=~SELECTED;
				wind_update(BEG_UPDATE);
				len=atol(_obGetStr(tree,FMEMLEN));
				len*=1024L;
				if (n==FMEMMOD)
					_pDim(len);
				else if (n==FMEMMIN)
					_pDim(0L);
				else
					_pDim(-1L);
				_myInitForm(FMEM,FMEMSYS);
				_myInitForm(FMEM,FMEMLEN);
				_myInitForm(FMEM,FMEMFRE);
				dum=_winFindId(TW_FORM,FMEM|FLAGS15,TRUE);
				if (dum!=-1)
				{
					if (W[dum].str.wf.obj==FMEMLEN)
						W[dum].str.wf.pos=(int)strlen(_obGetStr(tree,W[dum].str.wf.obj));
					_coord(tree,FMEMSYS,FALSE,&obx,&oby,&obw,&obh);
					_winObdraw(dum,tree,FMEMSYS,0,obx,oby,obw,obh);
					_coord(tree,FMEMLEN,FALSE,&obx,&oby,&obw,&obh);
					_winObdraw(dum,tree,FMEMLEN,0,obx,oby,obw,obh);
					_coord(tree,FMEMFRE,FALSE,&obx,&oby,&obw,&obh);
					_winObdraw(dum,tree,FMEMFRE,0,obx,oby,obw,obh);
					_coord(tree,n,TRUE,&obx,&oby,&obw,&obh);
					_winObdraw(dum,tree,n,0,obx,oby,obw,obh);
				}
				wind_update(END_UPDATE);
			}
			break;
		case	FMEMOK:
			len=atol(_obGetStr(tree,FMEMN));
			p=strchr(_obGetStr(tree,FMEMN),'%');
			if (p && len<100L )
			{
				if (tree[FMEM1].ob_state&SELECTED)
					glb.opt.Mem_Boot=100L-len;
				else
					glb.opt.Mem_Boot=len;
			}
			else if (len>=100 && !p)
			{
				if (tree[FMEM1].ob_state&SELECTED)
					glb.opt.Mem_Boot=-len*1024L;
				else
					glb.opt.Mem_Boot=len*1024L;
			}
			tree[n].ob_state&=~SELECTED;
			wind_update(BEG_MCTRL);
			_myInitForm(FMEM,FMEM1);
			_myInitForm(FMEM,FMEM2);
			_myInitForm(FMEM,FMEMN);
			_coord(tree,ROOT,FALSE,&obx,&oby,&obw,&obh);
			_winObdraw(_winFindId(TW_FORM,FMEM|FLAGS15,TRUE),tree,n,0,obx,oby,obw,obh);
			_winObdraw(_winFindId(TW_FORM,FMEM|FLAGS15,TRUE),tree,FMEM1,0,obx,oby,obw,obh);
			_winObdraw(_winFindId(TW_FORM,FMEM|FLAGS15,TRUE),tree,FMEM2,0,obx,oby,obw,obh);
			_winObdraw(_winFindId(TW_FORM,FMEM|FLAGS15,TRUE),tree,FMEMN,0,obx,oby,obw,obh);
			wind_update(END_MCTRL);
			break;
	}
}
#pragma warn +par


/*******************************************************************************
	This function returns the object number & cursor pos in EDITABLE obj
*******************************************************************************/
void _whichEdit(int i,int *obj,int *pos)
{
	*obj=*pos=-1;
	if (i!=-1)
		if (W[i].type==TW_FORM)
		{
			*pos=W[i].str.wf.pos;
			*obj=W[i].str.wf.obj;
		}
}

void _setEdit(int i,int obj,int pos)
{
	int		type;

	if (i!=-1)
		if (W[i].type==TW_FORM)
		{
			type=((UBLK *)W[i].str.wf.tree[obj].ob_spec.userblk->ub_parm)->type;
			if ( W[i].str.wf.obj!=obj || W[i].str.wf.pos!=pos )
				if ( (type==G_FTEXT || type==G_FBOXTEXT) && W[i].str.wf.tree[obj].ob_flags&EDITABLE && !(W[i].str.wf.tree[obj].ob_state&DISABLED) )
				{
					objc_draw(W[i].str.wf.tree,W[i].str.wf.obj,0,W[i].str.wf.tree->ob_x,W[i].str.wf.tree->ob_y,W[i].str.wf.tree->ob_width,W[i].str.wf.tree->ob_height);
					W[i].str.wf.obj=obj;
					W[i].str.wf.pos=min(pos,(int)strlen(((TEDINFO *)((UBLK *)W[i].str.wf.tree[W[i].str.wf.obj].ob_spec.userblk->ub_parm)->spec)->te_ptext));
					_objcEdit(W[i].str.wf.tree,W[i].str.wf.obj,0,&W[i].str.wf.pos,ED_CLIP|ED_INIT);
				}
		}
}
