/*******************************************************************************
	"Easy Gem" library Copyright (c)1995 by		Christophe BOYANIQUE
																29 rue de la Rpublique
																37230 FONDETTES
																FRANCE
												FidoNet:		2:320/107.16
												NeST:			90:800/1.16
												AtariNet:	51:901/1.16
										*small* mail at:	cb@spia.freenix.fr
********************************************************************************
	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License, or any later version.
	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.
	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	675 Mass Ave, Cambridge, MA 02139, USA.
********************************************************************************

********************************************************************************
	TABULATION: 3 CARACTERES
*******************************************************************************/

#include		"EG_MAIN.H"

/*******************************************************************************
	This function is used to open a window
*******************************************************************************/
int _winOpen(window *win)
{
	int		top,dum;
	int		x=-1;
	int		handle=-1;
	int		i;
	int		X,Y,WW,HH;
	int		nH=0,nD=0,nB=0,isB=0,isD=0;

	for (i=0;i<glb.opt.Win_Num;i++)
		if (W[i].smallflag==2)							/*	Application iconified ?		*/
			_allunsmall(i);								/*	Open all windows				*/
	/****************************************************************************
		Each window contains a 'type' (for example form) and an 'id' (the tree
		number for example)
	****************************************************************************/

	/****************************************************************************
		1st step: is there a closed window with same type/id ?
	****************************************************************************/
	for (i=0;i<glb.opt.Win_Num;i++)
		if ( W[i].type==win->type && W[i].id==win->id )
		{
			x=i;
			i=glb.opt.Win_Num;
		}

	if (x==-1)
	{
		/*************************************************************************
			Here, there is not a previously closed window.
			We must search a free handle to create a new one, and as possible
			one with xwind=1
		*************************************************************************/
		for (i=0;i<glb.opt.Win_Num;i++)
		{
			if ( W[i].handle<0 && W[i].xwind==-1 )
			{
				x=i;
				i=glb.opt.Win_Num;
			}
			if (x==-1)
				/*******************************************************************
					There is no free handle with xwind=1, so we take the first one
					and force xwind to -1
				*******************************************************************/
				if ( W[i].handle<0 && W[i].xwind!=-1 )
				{
					x=i;
					W[x].xwind=-1;
					i=glb.opt.Win_Num;
				}
		}
	}

	if (x!=-1)
	{
		/*************************************************************************
			if handle=-1 then create the window, else top it !
		*************************************************************************/
		if (W[x].handle>0)
		{
			wind_get(0,WF_TOP,&top);
			if ( top!=W[x].handle || W[x].smallflag==1 )
			{
				if (W[x].smallflag==1)
					_unsmall(x);
				_top(x);
				_ontop(x);
			}
			handle=W[x].handle;
		}
		else
		{
			strncpy(W[x].name,win->name,wNAMEMAX);
			strncpy(W[x].sname,win->sname,wSNAMEMAX);
			strncpy(W[x].help,win->help,14);
			W[x].gadget=win->gadget;
			if (W[x].gadget&wMODAL)
				W[x].gadget&=~wCYCLE;
			W[x].smallflag=0;
			W[x].type=win->type;
			W[x].id=win->id;
			W[x].xslidlen=100;
			W[x].xslidpos=0;
			W[x].yslidlen=100;
			W[x].yslidpos=0;
			_obPutStr(iglb.aes.tree,FWINAME,W[x].name);

			WW=16;
			HH=16/(1+glb.vdi.low);
			iglb.aes.tree[FWINCLS].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINPOP].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINCYC].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINICO].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINFUL].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINVSF].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINVSP].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINUAR].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINDAR].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINSIZ].ob_state&=~DISABLED;
			iglb.aes.tree[FWINSIZ].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINRAR].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINLAR].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINHSF].ob_flags&=~HIDETREE;
			iglb.aes.tree[FWINHSP].ob_flags&=~HIDETREE;

			if (!(W[x].gadget & wCLOSE))	iglb.aes.tree[FWINCLS].ob_flags|=HIDETREE;	else	{	nH++;	}
			if (!(W[x].gadget & wMENU))	iglb.aes.tree[FWINPOP].ob_flags|=HIDETREE;	else	{	nH++;	}
			if (!(W[x].gadget & wCYCLE))	iglb.aes.tree[FWINCYC].ob_flags|=HIDETREE;	else	{	nH++;	}
			if (!(W[x].gadget & wICON))	iglb.aes.tree[FWINICO].ob_flags|=HIDETREE;	else	{	nH++;	}
			if (!(W[x].gadget & wFULL))	iglb.aes.tree[FWINFUL].ob_flags|=HIDETREE;	else	{	nH++;	}
			if (!(W[x].gadget & wUARROW))	iglb.aes.tree[FWINUAR].ob_flags|=HIDETREE;	else	{	nD++;	isD=1;	}
			if (!(W[x].gadget & wDARROW))	iglb.aes.tree[FWINDAR].ob_flags|=HIDETREE;	else	{	nD++;	isD=1;	}
			if (!(W[x].gadget & wRARROW))	iglb.aes.tree[FWINRAR].ob_flags|=HIDETREE;	else	{	nB++;	isB=1;	}
			if (!(W[x].gadget & wLARROW))	iglb.aes.tree[FWINLAR].ob_flags|=HIDETREE;	else	{	nB++;	isB=1;	}

			if (W[x].gadget & wVSLIDE)
				isD=1;
			else
			{
				iglb.aes.tree[FWINVSP].ob_flags|=HIDETREE;
				if (!isD)
					iglb.aes.tree[FWINVSF].ob_flags|=HIDETREE;
			}
			if (W[x].gadget & wHSLIDE)
				isB=1;
			else
			{
				iglb.aes.tree[FWINHSP].ob_flags|=HIDETREE;
				if (!isB)
					iglb.aes.tree[FWINHSF].ob_flags|=HIDETREE;
			}
			if (W[x].gadget & wSIZE)
			{
				if ( !isD && !isB )
				{
					isD=1;
					iglb.aes.tree[FWINVSF].ob_flags&=~HIDETREE;
				}
			}
			else
			{
				if ( isB || isD )
					iglb.aes.tree[FWINSIZ].ob_state|=DISABLED;
				else
					iglb.aes.tree[FWINSIZ].ob_flags|=HIDETREE;
			}

			W[x].xwork=win->xwork;
			W[x].ywork=win->ywork;
			W[x].wwork=win->wwork;
			W[x].hwork=win->hwork;
			W[x].xwind=win->xwind;
			W[x].ywind=win->ywind;
			W[x].wwind=win->wwind;
			W[x].hwind=win->hwind;
			W[x].xfull=win->xfull;
			W[x].yfull=win->yfull;
			W[x].wfull=win->wfull;
			W[x].hfull=win->hfull;

			if ( win->xwork != -1 )
			{
				iW[x].mwwork=W[x].wfull+isD*(1+WW);
				iW[x].mhwork=W[x].hfull+(1+isB)*(1+HH);
				iW[x].mxwork=W[x].xfull;
				iW[x].mywork=W[x].yfull-1-HH;
				wind_calc(WC_BORDER,0,iW[x].mxwork,iW[x].mywork,iW[x].mwwork,iW[x].mhwork,
					&W[x].xfull,&W[x].yfull,&W[x].wfull,&W[x].hfull);
				W[x].wfull=min( W[x].wfull , glb.aes.wdesk );
				W[x].hfull=min( W[x].hfull , glb.aes.hdesk );
				W[x].xfull=max( W[x].xfull , glb.aes.xdesk );
				W[x].yfull=max( W[x].yfull , glb.aes.ydesk );
				W[x].xfull=min( W[x].xfull , glb.aes.xdesk+glb.aes.wdesk-W[x].wfull );
				W[x].yfull=min( W[x].yfull , glb.aes.ydesk+glb.aes.hdesk-W[x].hfull );
			}
			else
			{
				W[x].wfull=min( W[x].wfull , glb.aes.wdesk );
				W[x].hfull=min( W[x].hfull , glb.aes.hdesk );
				W[x].xfull=max( W[x].xfull , glb.aes.xdesk );
				W[x].yfull=max( W[x].yfull , glb.aes.ydesk );
				W[x].xfull=min( W[x].xfull , glb.aes.xdesk+glb.aes.wdesk-W[x].wfull );
				W[x].yfull=min( W[x].yfull , glb.aes.ydesk+glb.aes.hdesk-W[x].hfull );

				W[x].wwind=min( W[x].wwind , glb.aes.wdesk );
				W[x].hwind=min( W[x].hwind , glb.aes.hdesk );
				W[x].xwind=max( W[x].xwind , glb.aes.xdesk );
				W[x].ywind=max( W[x].ywind , glb.aes.ydesk );
				W[x].xwind=min( W[x].xwind , glb.aes.xdesk+glb.aes.wdesk-W[x].wwind );
				W[x].ywind=min( W[x].ywind , glb.aes.ydesk+glb.aes.hdesk-W[x].hwind );
			}

			if (win->xwork!=-1)
			{
				iW[x].mwwork=W[x].wwork+isD*(1+WW);
				iW[x].mhwork=W[x].hwork+(1+isB)*(1+HH);
				iW[x].mxwork=W[x].xwork;
				iW[x].mywork=W[x].ywork-1-HH;
				wind_calc(WC_BORDER,0,iW[x].mxwork,iW[x].mywork,iW[x].mwwork,iW[x].mhwork,
					&W[x].xwind,&W[x].ywind,&W[x].wwind,&W[x].hwind);
			}
			else
			{
				wind_calc(WC_BORDER,0,W[x].xwind,W[x].ywind,W[x].wwind,W[x].hwind,
					&iW[x].mxwork,&iW[x].mywork,&iW[x].mwwork,&iW[x].mhwork);
				W[x].wwork=iW[x].mwwork-isD*(1+WW);
				W[x].hwork=iW[x].mhwork-(1+isB)*(1+HH);
				W[x].xwork=iW[x].mxwork;
				W[x].ywork=iW[x].mywork+1+HH;
			}

			if	(W[x].wwind>W[x].wfull)
			{
				W[x].wwind=W[x].wfull;
				wind_calc(WC_WORK,0,W[x].xwind,W[x].ywind,W[x].wwind,W[x].hwind,
					&iW[x].mxwork,&iW[x].mywork,&iW[x].mwwork,&iW[x].mhwork);
				W[x].hwork	=	iW[x].mhwork-(1+isB)*(1+HH);
			}
			if	(W[x].hwind>W[x].hfull)
			{
				W[x].hwind=W[x].hfull;
				wind_calc(WC_WORK,0,W[x].xwind,W[x].ywind,W[x].wwind,W[x].hwind,
					&iW[x].mxwork,&iW[x].mywork,&iW[x].mwwork,&iW[x].mhwork);
				W[x].wwork	=	iW[x].mwwork-isD*(1+WW);
			}
			if ( (W[x].xwind+W[x].wwind>W[x].xfull+W[x].wfull-1) || (W[x].xwind<W[x].xfull+1)
					|| (W[x].ywind+W[x].hwind>W[x].yfull+W[x].hfull-1) || (W[x].ywind<W[x].yfull+1) )
			{
				W[x].xwind=min(W[x].xwind,W[x].xfull+W[x].wfull);
				W[x].ywind=min(W[x].ywind,W[x].yfull+W[x].hfull);
				W[x].xwind=max(W[x].xwind,W[x].xfull);
				W[x].ywind=max(W[x].ywind,W[x].yfull);
				wind_calc(WC_WORK,0,W[x].xwind,W[x].ywind,W[x].wwind,W[x].hwind,
					&iW[x].mxwork,&iW[x].mywork,&iW[x].mwwork,&iW[x].mhwork);
			}

			if ( iW[x].mxwork%16 && W[x].gadget&wXWORK16 )
			{
				dum=16-iW[x].mxwork%16;
				W[x].xwork+=dum;
				W[x].xwind+=dum;
				iW[x].mxwork+=dum;
			}

			if (W[x].gadget & wCLOSE)		iglb.aes.tree[FWINCLS].ob_x=0;
			iglb.aes.tree[FWINAME].ob_width=iW[x].mwwork-nH*WW-2;
			iglb.aes.tree[FWINAME].ob_height=HH-2;
			iglb.aes.tree[FWINAME].ob_state|=SELECTED;
			if (W[x].gadget & wCLOSE)		iglb.aes.tree[FWINAME].ob_x=WW+1;
			else									iglb.aes.tree[FWINAME].ob_x=1;
			iglb.aes.tree[FWINAME].ob_y=1;

			X=iW[x].mwwork-WW;
			if (W[x].gadget & wFULL)		{	iglb.aes.tree[FWINFUL].ob_x=X;		X-=WW;	}
			if (W[x].gadget & wMENU)		{	iglb.aes.tree[FWINPOP].ob_x=X;		X-=WW;	}
			if (W[x].gadget & wICON)		{	iglb.aes.tree[FWINICO].ob_x=X;		X-=WW;	}
			if (W[x].gadget & wCYCLE)		{	iglb.aes.tree[FWINCYC].ob_x=X;		X-=WW;	}

			iglb.aes.tree[FWINUAR].ob_x	=	iW[x].mwwork-WW;
			iglb.aes.tree[FWINDAR].ob_x	=	iW[x].mwwork-WW;
			iglb.aes.tree[FWINSIZ].ob_x	=	iW[x].mwwork-WW;

			Y=iW[x].mhwork-HH;
			iglb.aes.tree[FWINSIZ].ob_y=Y;	Y-=HH;
			if (W[x].gadget & wDARROW)		{	iglb.aes.tree[FWINDAR].ob_y=Y;	Y-=HH;	}
			if	(W[x].gadget & wUARROW)		{	iglb.aes.tree[FWINUAR].ob_y=Y;	Y-=HH;	}

			iglb.aes.tree[FWINVSF].ob_x		=	iW[x].mwwork-WW;
			iglb.aes.tree[FWINVSF].ob_y		=	HH+1;
			iglb.aes.tree[FWINVSF].ob_height	=	iW[x].mhwork-(1+nD)*HH-1;
			iglb.aes.tree[FWINVSF].ob_width	=	WW;
			iglb.aes.tree[FWINVSP].ob_x		=	0;
			iglb.aes.tree[FWINVSP].ob_width	=	WW;

			iglb.aes.tree[FWINHSF].ob_x		=	0;
			iglb.aes.tree[FWINHSF].ob_y		=	iW[x].mhwork-HH;
			iglb.aes.tree[FWINHSF].ob_width	=	iW[x].mwwork-nB*WW;
			iglb.aes.tree[FWINHSF].ob_height	=	HH;
			iglb.aes.tree[FWINHSP].ob_y		=	0;
			iglb.aes.tree[FWINHSP].ob_height	=	HH;

			iglb.aes.tree[FWINLAR].ob_y=iglb.aes.tree[FWINHSF].ob_y;
			iglb.aes.tree[FWINRAR].ob_y=iglb.aes.tree[FWINHSF].ob_y;
			iglb.aes.tree[FWINSIZ].ob_y=iglb.aes.tree[FWINHSF].ob_y;

			X=iW[x].mwwork-WW;
			iglb.aes.tree[FWINSIZ].ob_x=X;	X-=WW;
			if (W[x].gadget & wRARROW)		{	iglb.aes.tree[FWINRAR].ob_x=X;	X-=WW;	}
			if (W[x].gadget & wLARROW)		{	iglb.aes.tree[FWINLAR].ob_x=X;	X-=WW;	}

			W[x].xslidlen=100;
			W[x].yslidlen=100;
			W[x].xslidpos=0;
			W[x].yslidpos=0;

			iglb.aes.tree->ob_width=iW[x].mwwork;
			iglb.aes.tree->ob_height=iW[x].mhwork;

			iW[x].xold	=	W[x].xwind;
			iW[x].yold	=	W[x].ywind;
			iW[x].wold	=	W[x].wwind;
			iW[x].hold	=	W[x].hwind;
			handle=wind_create(0,W[x].xfull,W[x].yfull,W[x].wfull,W[x].hfull);
			if (handle>0)
			{
				W[x].handle						=	handle;
				iW[x].params.x					=	0;
				iW[x].params.y					=	HH;
				iW[x].params.w					=	isD*WW;
				iW[x].params.h					=	isB*HH;
				iW[x].params._box.x			=	iglb.aes.tree->ob_x;
				iW[x].params._box.y			=	iglb.aes.tree->ob_y;
				iW[x].params._box.w			=	iglb.aes.tree->ob_width;
				iW[x].params._box.h			=	iglb.aes.tree->ob_height;
				iW[x].params._box.flags		=	iglb.aes.tree->ob_flags;
				iW[x].params._name.x			=	iglb.aes.tree[FWINAME].ob_x;
				iW[x].params._name.y			=	iglb.aes.tree[FWINAME].ob_y;
				iW[x].params._name.w			=	iglb.aes.tree[FWINAME].ob_width;
				iW[x].params._name.h			=	iglb.aes.tree[FWINAME].ob_height;
				iW[x].params._name.flags	=	iglb.aes.tree[FWINAME].ob_flags;
				iW[x].params._close.x		=	iglb.aes.tree[FWINCLS].ob_x;
				iW[x].params._close.y		=	iglb.aes.tree[FWINCLS].ob_y;
				iW[x].params._close.flags	=	iglb.aes.tree[FWINCLS].ob_flags;
				iW[x].params._menu.x			=	iglb.aes.tree[FWINPOP].ob_x;
				iW[x].params._menu.y			=	iglb.aes.tree[FWINPOP].ob_y;
				iW[x].params._menu.flags	=	iglb.aes.tree[FWINPOP].ob_flags;
				iW[x].params._cycle.x		=	iglb.aes.tree[FWINCYC].ob_x;
				iW[x].params._cycle.y		=	iglb.aes.tree[FWINCYC].ob_y;
				iW[x].params._cycle.flags	=	iglb.aes.tree[FWINCYC].ob_flags;
				iW[x].params._icon.x			=	iglb.aes.tree[FWINICO].ob_x;
				iW[x].params._icon.y			=	iglb.aes.tree[FWINICO].ob_y;
				iW[x].params._icon.flags	=	iglb.aes.tree[FWINICO].ob_flags;
				iW[x].params._full.x			=	iglb.aes.tree[FWINFUL].ob_x;
				iW[x].params._full.y			=	iglb.aes.tree[FWINFUL].ob_y;
				iW[x].params._full.flags	=	iglb.aes.tree[FWINFUL].ob_flags;
				iW[x].params._vslf.x			=	iglb.aes.tree[FWINVSF].ob_x;
				iW[x].params._vslf.y			=	iglb.aes.tree[FWINVSF].ob_y;
				iW[x].params._vslf.w			=	iglb.aes.tree[FWINVSF].ob_width;
				iW[x].params._vslf.h			=	iglb.aes.tree[FWINVSF].ob_height;
				iW[x].params._vslf.flags	=	iglb.aes.tree[FWINVSF].ob_flags;
				iW[x].params._vslp.x			=	iglb.aes.tree[FWINVSP].ob_x;
				iW[x].params._vslp.y			=	iglb.aes.tree[FWINVSP].ob_y;
				iW[x].params._vslp.w			=	iglb.aes.tree[FWINVSP].ob_width;
				iW[x].params._vslp.h			=	iglb.aes.tree[FWINVSP].ob_height;
				iW[x].params._vslp.flags	=	iglb.aes.tree[FWINVSP].ob_flags;
				iW[x].params._vsli.x			=	iglb.aes.tree[FWINVSI].ob_x;
				iW[x].params._vsli.y			=	iglb.aes.tree[FWINVSI].ob_y;
				iW[x].params._vsli.w			=	iglb.aes.tree[FWINVSI].ob_width;
				iW[x].params._vsli.h			=	iglb.aes.tree[FWINVSI].ob_height;
				iW[x].params._vsli.flags	=	iglb.aes.tree[FWINVSI].ob_flags;
				iW[x].params._uarr.x			=	iglb.aes.tree[FWINUAR].ob_x;
				iW[x].params._uarr.y			=	iglb.aes.tree[FWINUAR].ob_y;
				iW[x].params._uarr.flags	=	iglb.aes.tree[FWINUAR].ob_flags;
				iW[x].params._darr.x			=	iglb.aes.tree[FWINDAR].ob_x;
				iW[x].params._darr.y			=	iglb.aes.tree[FWINDAR].ob_y;
				iW[x].params._darr.flags	=	iglb.aes.tree[FWINDAR].ob_flags;
				iW[x].params._size.x			=	iglb.aes.tree[FWINSIZ].ob_x;
				iW[x].params._size.y			=	iglb.aes.tree[FWINSIZ].ob_y;
				iW[x].params._size.flags	=	iglb.aes.tree[FWINSIZ].ob_flags;
				iW[x].params._rarr.x			=	iglb.aes.tree[FWINRAR].ob_x;
				iW[x].params._rarr.y			=	iglb.aes.tree[FWINRAR].ob_y;
				iW[x].params._rarr.flags	=	iglb.aes.tree[FWINRAR].ob_flags;
				iW[x].params._larr.x			=	iglb.aes.tree[FWINLAR].ob_x;
				iW[x].params._larr.y			=	iglb.aes.tree[FWINLAR].ob_y;
				iW[x].params._larr.flags	=	iglb.aes.tree[FWINLAR].ob_flags;
				iW[x].params._hslf.x			=	iglb.aes.tree[FWINHSF].ob_x;
				iW[x].params._hslf.y			=	iglb.aes.tree[FWINHSF].ob_y;
				iW[x].params._hslf.w			=	iglb.aes.tree[FWINHSF].ob_width;
				iW[x].params._hslf.h			=	iglb.aes.tree[FWINHSF].ob_height;
				iW[x].params._hslf.flags	=	iglb.aes.tree[FWINHSF].ob_flags;
				iW[x].params._hslp.x			=	iglb.aes.tree[FWINHSP].ob_x;
				iW[x].params._hslp.y			=	iglb.aes.tree[FWINHSP].ob_y;
				iW[x].params._hslp.w			=	iglb.aes.tree[FWINHSP].ob_width;
				iW[x].params._hslp.h			=	iglb.aes.tree[FWINHSP].ob_height;
				iW[x].params._hslp.flags	=	iglb.aes.tree[FWINHSP].ob_flags;
				iW[x].params._hsli.x			=	iglb.aes.tree[FWINHSI].ob_x;
				iW[x].params._hsli.y			=	iglb.aes.tree[FWINHSI].ob_y;
				iW[x].params._hsli.w			=	iglb.aes.tree[FWINHSI].ob_width;
				iW[x].params._hsli.h			=	iglb.aes.tree[FWINHSI].ob_height;
				iW[x].params._hsli.flags	=	iglb.aes.tree[FWINHSI].ob_flags;

				W[x].wmini		=	(max(nH,nB)+2)*WW;
				W[x].hmini		=	(4+isD*2+nD)*HH;
				W[x].redraw		=	win->redraw;	/*	Pointeur routine redraw			*/
				W[x].pop			=	win->pop;		/*	Pointeur routine popup			*/
				W[x].top			=	win->top;		/*	Pointeur routine top				*/
				W[x].close		=	win->close;		/*	Pointeur routine close			*/
				W[x].full		=	win->full;		/*	Pointeur routine full			*/
				W[x].arrow		=	win->arrow;		/*	Pointeur routine arrow			*/
				W[x].hslid		=	win->hslid;		/*	Pointeur routine h slider		*/
				W[x].vslid		=	win->vslid;		/*	Pointeur routine v slider		*/
				W[x].size		=	win->size;		/*	Pointeur routine size			*/
				W[x].move		=	win->move;		/*	Pointeur routine move			*/
				W[x].untop		=	win->untop;		/*	Pointeur routine untop			*/
				W[x].ontop		=	win->ontop;		/*	Pointeur routine ontop			*/
				W[x].small		=	win->small;		/*	Pointeur routine small			*/
				W[x].nsmall		=	win->nsmall;	/*	Pointeur routine unsmall		*/
				W[x].clic		=	win->clic;		/*	Pointeur routine de clic		*/
				W[x].keybd		=	win->keybd;		/*	Pointeur routine de clavier	*/
				W[x].init		=	win->init;		/*	Pointeur routine d'init			*/
				W[x].in			=	win->in;
				W[x].popup		=	win->popup;

				if (win->ic_tree==-1)
					switch	(win->icon)
					{
						case	WIC_EXT:
							W[x].ic_tree=-1;
							W[x].icon=0;
							break;
						case	WIC_INF:
							W[x].icon=ICNINF;
							W[x].ic_tree=ICONE|FLAGS15;
							break;
						case	WIC_MEM:
							W[x].icon=ICNMEM;
							W[x].ic_tree=ICONE|FLAGS15;
							break;
						case	WIC_FNT:
							W[x].icon=ICNFNT;
							W[x].ic_tree=ICONE|FLAGS15;
							break;
						case	WIC_OPT:
							W[x].icon=ICNOPT;
							W[x].ic_tree=ICONE|FLAGS15;
							break;
						case	WIC_SYS:
							W[x].icon=ICNSYS;
							W[x].ic_tree=ICONE|FLAGS15;
							break;
						case	WIC_HLP:
							W[x].icon=ICNHLP;
							W[x].ic_tree=ICONE|FLAGS15;
							break;
						case	WIC_DEF:
						default:
							W[x].icon=ICNDEF;
							W[x].ic_tree=ICONE|FLAGS15;
							break;
					}
				else
				{
					W[x].ic_tree	=	win->ic_tree;
					W[x].icon		=	win->icon;
				}
				wind_set(W[x].handle,WF_BEVENT,1,0,0,0);
				wind_update(BEG_MCTRL);
				if (W[x].gadget&wMODAL)
				{
					iglb.aes.fmod=1;
					iglb.aes.wmod=x;
					_initModal();
				}
				wind_open(W[x].handle,W[x].xwind,W[x].ywind,W[x].wwind,W[x].hwind);
				wind_get(W[x].handle,WF_WORKXYWH,&iW[x].mxwork,&iW[x].mywork,&iW[x].mwwork,&iW[x].mhwork);
				W[x].xwork=iW[x].mxwork+iW[x].params.x;
				W[x].ywork=iW[x].mywork+iW[x].params.y+1;
				_setWindow(x);
				if (W[x].init!=0)
					(*W[x].init)(x);
				wind_update(END_MCTRL);
			}
			else
				form_alert(1,iglb.rsc.head.frstr[NOWIN]);
		}
	}
	else
		form_alert(1,iglb.rsc.head.frstr[NOWIN]);
	return x;
}


/*******************************************************************************
	This functions simply close a window !
*******************************************************************************/
void _winClose(int i)
{
	if (i!=-1)
		_closed(i);
}


/*******************************************************************************
	Set the Vertical slider pos & len
*******************************************************************************/
void _winVslid(int i)
{
	GRECT		rd,r;
	int		lattr[6],pxy[4];
	int		WW,HH,nD=0;

	if (i!=-1)
	{
		WW=16;
		HH=16/(1+glb.vdi.low);

		if (W[i].gadget & wUARROW)	nD++;
		if (W[i].gadget & wDARROW)	nD++;
		if (W[i].gadget & wSIZE)	nD++;

		iglb.aes.tree[FWINVSF].ob_x		=	iW[i].mwwork-WW;
		iglb.aes.tree[FWINVSF].ob_y		=	HH+1;
		iglb.aes.tree[FWINVSF].ob_height	=	iW[i].mhwork-(1+nD)*HH-1;
		iglb.aes.tree[FWINVSF].ob_width	=	WW;
		iglb.aes.tree[FWINVSP].ob_x		=	0;
		iglb.aes.tree[FWINVSP].ob_width	=	WW;

		iglb.aes.tree[FWINVSF].ob_flags	=	iW[i].params._vslf.flags;
		iglb.aes.tree[FWINVSP].ob_flags	=	iW[i].params._vslp.flags;
		iglb.aes.tree[FWINVSI].ob_flags	=	iW[i].params._vsli.flags;

		iglb.aes.tree[FWINVSP].ob_height	=	(int)((double)iglb.aes.tree[FWINVSF].ob_height*(double)W[i].yslidlen/1000.0);
		iglb.aes.tree[FWINVSP].ob_height	=	max(iglb.aes.tree[FWINVSI].ob_height,iglb.aes.tree[FWINVSP].ob_height);
		iglb.aes.tree[FWINVSP].ob_height	=	min(iglb.aes.tree[FWINVSF].ob_height,iglb.aes.tree[FWINVSP].ob_height);
		iglb.aes.tree[FWINVSP].ob_y		=	(int)((double)(iglb.aes.tree[FWINVSF].ob_height-iglb.aes.tree[FWINVSP].ob_height)*(double)W[i].yslidpos/1000.0);
		iglb.aes.tree[FWINVSP].ob_y		=	max(0,iglb.aes.tree[FWINVSP].ob_y);
		iglb.aes.tree[FWINVSP].ob_y		=	min(iglb.aes.tree[FWINVSF].ob_height-iglb.aes.tree[FWINVSP].ob_height,iglb.aes.tree[FWINVSP].ob_y);
		iglb.aes.tree[FWINVSI].ob_y		=	(iglb.aes.tree[FWINVSP].ob_height-iglb.aes.tree[FWINVSI].ob_height)/2;
		iglb.aes.tree[FWINVSI].ob_y		=	max(0,iglb.aes.tree[FWINVSI].ob_y);

		iW[i].params._vslf.x	=	iglb.aes.tree[FWINVSF].ob_x;
		iW[i].params._vslf.y	=	iglb.aes.tree[FWINVSF].ob_y;
		iW[i].params._vslf.w	=	iglb.aes.tree[FWINVSF].ob_width;
		iW[i].params._vslf.h	=	iglb.aes.tree[FWINVSF].ob_height;
		iW[i].params._vslp.x	=	iglb.aes.tree[FWINVSP].ob_x;
		iW[i].params._vslp.y	=	iglb.aes.tree[FWINVSP].ob_y;
		iW[i].params._vslp.w	=	iglb.aes.tree[FWINVSP].ob_width;
		iW[i].params._vslp.h	=	iglb.aes.tree[FWINVSP].ob_height;
		iW[i].params._vsli.x	=	iglb.aes.tree[FWINVSI].ob_x;
		iW[i].params._vsli.y	=	iglb.aes.tree[FWINVSI].ob_y;
		iW[i].params._vsli.w	=	iglb.aes.tree[FWINVSI].ob_width;
		iW[i].params._vsli.h	=	iglb.aes.tree[FWINVSI].ob_height;

		rd.g_x=W[i].xwind;
		rd.g_y=W[i].ywind;
		rd.g_w=W[i].wwind;
		rd.g_h=W[i].hwind;

		wind_get(W[i].handle,WF_FIRSTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
		while (r.g_w && r.g_h)
		{
			if (_rcIntersect(&rd,&r))
			{
				objc_draw(iglb.aes.tree,FWINVSF,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
				_setClip(TRUE,&r);
				vql_attributes(glb.vdi.ha,lattr);
				vsl_color(glb.vdi.ha,1);
				vsl_type(glb.vdi.ha,SOLID);
				vsl_width(glb.vdi.ha,1);
				pxy[0]=iW[i].mxwork+iW[i].params.x;
				pxy[1]=iW[i].mywork+iW[i].params.y;
				pxy[2]=iW[i].mxwork+iW[i].mwwork;
				pxy[3]=pxy[1];
				v_pline(glb.vdi.ha,2,pxy);
				if (iW[i].params.w)
				{
					pxy[0]=iW[i].mxwork+iW[i].mwwork-iW[i].params.w-1;
					pxy[1]=iW[i].mywork+iW[i].params.y;
					pxy[2]=pxy[0];
					pxy[3]=iW[i].mywork+iW[i].mhwork-iW[i].params.h-1;
					v_pline(glb.vdi.ha,2,pxy);
				}
				vsl_type(glb.vdi.ha,lattr[0]);
				vsl_color(glb.vdi.ha,lattr[1]);
				_setClip(FALSE,&r);
			}
			wind_get(W[i].handle,WF_NEXTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
		}
	}
}


/*******************************************************************************
	Set the Horinzontal slider pos & len
*******************************************************************************/
void _winHslid(int i)
{
	GRECT		rd,r;
	int		lattr[6],pxy[4];
	int		WW,HH,nB=0;

	if (i!=-1)
	{
		WW=16;
		HH=16/(1+glb.vdi.low);

		if (W[i].gadget & wRARROW)	nB++;
		if (W[i].gadget & wLARROW)	nB++;
		if (W[i].gadget & wSIZE)	nB++;

		iglb.aes.tree[FWINHSF].ob_x		=	0;
		iglb.aes.tree[FWINHSF].ob_y		=	iW[i].mhwork-HH;
		iglb.aes.tree[FWINHSF].ob_width	=	iW[i].mwwork-nB*WW;
		iglb.aes.tree[FWINHSF].ob_height	=	HH;
		iglb.aes.tree[FWINHSP].ob_y		=	0;
		iglb.aes.tree[FWINHSP].ob_height	=	HH;

		iglb.aes.tree[FWINHSF].ob_flags	=	iW[i].params._hslf.flags;
		iglb.aes.tree[FWINHSP].ob_flags	=	iW[i].params._hslp.flags;
		iglb.aes.tree[FWINHSI].ob_flags	=	iW[i].params._hsli.flags;

		iglb.aes.tree[FWINHSP].ob_width	=	(int)((double)iglb.aes.tree[FWINHSF].ob_width*(double)W[i].xslidlen/1000.0);
		iglb.aes.tree[FWINHSP].ob_width	=	max(iglb.aes.tree[FWINHSI].ob_width,iglb.aes.tree[FWINHSP].ob_width);
		iglb.aes.tree[FWINHSP].ob_width	=	min(iglb.aes.tree[FWINHSF].ob_width,iglb.aes.tree[FWINHSP].ob_width);
		iglb.aes.tree[FWINHSP].ob_x		=	(int)((double)(iglb.aes.tree[FWINHSF].ob_width-iglb.aes.tree[FWINHSP].ob_width)*(double)W[i].xslidpos/1000.0);
		iglb.aes.tree[FWINHSP].ob_x		=	max(0,iglb.aes.tree[FWINHSP].ob_x);
		iglb.aes.tree[FWINHSP].ob_x		=	min(iglb.aes.tree[FWINHSF].ob_width-iglb.aes.tree[FWINHSP].ob_width,iglb.aes.tree[FWINHSP].ob_x);
		iglb.aes.tree[FWINHSI].ob_x		=	(iglb.aes.tree[FWINHSP].ob_width-iglb.aes.tree[FWINHSI].ob_width)/2;
		iglb.aes.tree[FWINHSI].ob_x		=	max(0,iglb.aes.tree[FWINHSI].ob_x);

		iW[i].params._hslf.x	=	iglb.aes.tree[FWINHSF].ob_x;
		iW[i].params._hslf.y	=	iglb.aes.tree[FWINHSF].ob_y;
		iW[i].params._hslf.w	=	iglb.aes.tree[FWINHSF].ob_width;
		iW[i].params._hslf.h	=	iglb.aes.tree[FWINHSF].ob_height;
		iW[i].params._hslp.x	=	iglb.aes.tree[FWINHSP].ob_x;
		iW[i].params._hslp.y	=	iglb.aes.tree[FWINHSP].ob_y;
		iW[i].params._hslp.w	=	iglb.aes.tree[FWINHSP].ob_width;
		iW[i].params._hslp.h	=	iglb.aes.tree[FWINHSP].ob_height;
		iW[i].params._hsli.x	=	iglb.aes.tree[FWINHSI].ob_x;
		iW[i].params._hsli.y	=	iglb.aes.tree[FWINHSI].ob_y;
		iW[i].params._hsli.w	=	iglb.aes.tree[FWINHSI].ob_width;
		iW[i].params._hsli.h	=	iglb.aes.tree[FWINHSI].ob_height;

		rd.g_x=W[i].xwind;
		rd.g_y=W[i].ywind;
		rd.g_w=W[i].wwind;
		rd.g_h=W[i].hwind;

		wind_get(W[i].handle,WF_FIRSTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
		while (r.g_w && r.g_h)
		{
			if (_rcIntersect(&rd,&r))
			{
				objc_draw(iglb.aes.tree,FWINHSF,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
				_setClip(TRUE,&r);
				vql_attributes(glb.vdi.ha,lattr);
				vsl_color(glb.vdi.ha,1);
				vsl_type(glb.vdi.ha,SOLID);
				vsl_width(glb.vdi.ha,1);
				pxy[0]=iW[i].mxwork+iW[i].params.x;
				pxy[1]=iW[i].mywork+iW[i].params.y;
				pxy[2]=iW[i].mxwork+iW[i].mwwork;
				pxy[3]=pxy[1];
				v_pline(glb.vdi.ha,2,pxy);
				if (iW[i].params.h)
				{
					pxy[0]=iW[i].mxwork+iW[i].params.x;
					pxy[1]=iW[i].mywork+iW[i].mhwork-iW[i].params.h-1;
					pxy[2]=iW[i].mxwork+iW[i].mwwork;
					pxy[3]=pxy[1];
					v_pline(glb.vdi.ha,2,pxy);
				}
				vsl_type(glb.vdi.ha,lattr[0]);
				vsl_color(glb.vdi.ha,lattr[1]);
				_setClip(FALSE,&r);
			}
			wind_get(W[i].handle,WF_NEXTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
		}
	}
}


/*******************************************************************************
	Change window title
*******************************************************************************/
void _winSmall(int i)
{
	_small(i);
}


/*******************************************************************************
	Change window title
*******************************************************************************/
void _winName(int i,char *name,char *sname)
{
	if (i!=-1)
	{
		strncpy(W[i].name,name,wNAMEMAX);
		strncpy(W[i].sname,sname,wSNAMEMAX);
		_redrawWindow(i);
	}
}


/*******************************************************************************
	Change window *WORK* size
*******************************************************************************/
void _winWsize(int i,int w,int h)
{
	int		nH=0,nD=0,nB=0,isD=0,isB=0;
	int		WW,HH,dum;
	int		wwork,hwork;

	if (i!=-1)
	{
		_makeform(i);
		W[i].wwork=w;
		W[i].hwork=h;
		WW=16;
		HH=16/(1+glb.vdi.low);
		if (W[i].gadget & wCLOSE)	{	nH++;		}
		if (W[i].gadget & wMENU)	{	nH++;		}
		if (W[i].gadget & wCYCLE)	{	nH++;		}
		if (W[i].gadget & wICON)	{	nH++;		}
		if (W[i].gadget & wFULL)	{	nH++;		}
		if (W[i].gadget & wVSLIDE)	{	isD=1;	}
		if (W[i].gadget & wUARROW)	{	nD++;	isD=1;	}
		if (W[i].gadget & wDARROW)	{	nD++;	isD=1;	}
		if (W[i].gadget & wRARROW)	{	nB++;	isB=1;	}
		if (W[i].gadget & wLARROW)	{	nB++;	isB=1;	}
		if (W[i].gadget & wHSLIDE)	{	isB=1;	}
		if (W[i].gadget & wSIZE)	{	isD=1; isB=1; nD++; nB++;	}
		wwork=w+isD*(1+WW);
		hwork=h+(1+isB)*(1+HH);
		wind_calc(WC_BORDER,0,iW[i].mxwork,iW[i].mywork,wwork,hwork,&dum,&dum,&W[i].wwind,&W[i].hwind);
		wind_set(W[i].handle,WF_CURRXYWH,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
		wind_get(W[i].handle,WF_WORKXYWH,&iW[i].mxwork,&iW[i].mywork,&iW[i].mwwork,&iW[i].mhwork);
		_setWindow(i);
	}
}


/*******************************************************************************
	Change window size
*******************************************************************************/
void _winSize(int i,int w,int h)
{
	wind_update(BEG_MCTRL);
	_makeform(i);
	_size(i,w,h);
	wind_update(END_MCTRL);
}


/*******************************************************************************
	Change window position
*******************************************************************************/
void _winMove(int i,int x,int y)
{
	if (W[i].gadget&wMOVE)
	{
		wind_update(BEG_MCTRL);
		_makeform(i);
		_move(i,x,y);
		wind_update(END_MCTRL);
	}
}


/*******************************************************************************
	Handle iconification event
*******************************************************************************/
void _small(int i)
{
	OBJECT	*tree;
	int		x,y,w,h,ha;
	int		ok,dum;
	char		file[FILENAME_MAX];

	if (i!=-1)
	{
		ha=W[i].handle;
		wind_get(ha,WF_WORKXYWH,&x,&y,&w,&h);
		if (iglb.aes.Big_Icon)
			tree=iglb.rsc.head.trindex[BICN];
		else
			tree=iglb.rsc.head.trindex[LICN];
		tree->ob_x=x+(w-tree->ob_width)/2;
		tree->ob_y=y+(h-tree->ob_height)/2;
		wind_calc(WC_BORDER,0,tree->ob_x,tree->ob_y,tree->ob_width,tree->ob_height,&x,&y,&w,&h);
		W[i].wwsmall=tree->ob_width;
		W[i].hwsmall=tree->ob_height;
		W[i].xsmall=x;
		W[i].ysmall=y;
		W[i].wsmall=w;
		W[i].hsmall=h;
		W[i].smallflag=1;
		wind_set(ha,WF_CURRXYWH,W[i].xsmall,W[i].ysmall,W[i].wsmall,W[i].hsmall);
		wind_get(ha,WF_WORKXYWH,&W[i].xwsmall,&W[i].ywsmall,&W[i].wwsmall,&W[i].hwsmall);
		wind_get(ha,WF_WORKXYWH,&iW[i].mxwsmall,&iW[i].mywsmall,&iW[i].mwwsmall,&iW[i].mhwsmall);
		if (W[i].xwsmall%16 && W[i].gadget&wXWORK16)
		{
			dum=16-W[i].xwsmall%16;
			W[i].xwsmall+=dum;
			W[i].xsmall+=dum;
			iW[i].mxwsmall+=dum;
			wind_set(ha,WF_CURRXYWH,W[i].xsmall,W[i].ysmall,W[i].wsmall,W[i].hsmall);
		}
		tree[1].ob_height=16/(1+glb.vdi.low)-1;
		W[i].ywsmall+=tree[1].ob_height+1;
		W[i].hwsmall-=tree[1].ob_height+1;
		if (W[i].small!=0)
			(*W[i].small)(i);
		_mousework();
		if (W[i].gadget&wSWAP && mem.bloc[W[i].in].type!=MB_NOMOVE)
		{
			sprintf(glb.div.log,"Swap   Win #%i (%08li) (EGLIB%03i.%03i) ... ",i,mem.bloc[W[i].in].len,glb.aes.id,i);
			_reportLog();
			ok=TRUE;
			sprintf(file,"%sEGLIB%03i.%03i",iglb.div.SWP_Path,glb.aes.id,i);
			ha=(int)Fcreate(file,0);
			if (ha>0)
			{
				if ( Fwrite(ha,mem.bloc[W[i].in].len,(void *)mem.bloc[W[i].in].adr) != mem.bloc[W[i].in].len )
				{
					Fclose(ha);
					ok=FALSE;
				}
				else
					ok=!Fclose(ha);
			}
			else
				ok=FALSE;
			if (ok)
			{
				sprintf(glb.div.log,"ok!\n");
				_reportLog();
				_mFree(W[i].in);
				W[i].in=SWP_MEMORY;
			}
			else
			{
				sprintf(glb.div.log,"error!\n");
				_reportLog();
				Fdelete(file);
			}
		}
		graf_mouse(ARROW,0);
		_winRedraw(i,0,0,0,0);
		_winAlign();
	}
}
void _allsmall(int i)
{
	OBJECT	*tree;
	int		j,ha,x,y,w,h,ok;
	char		file[FILENAME_MAX];

	if (i!=-1)
	{
		ok=TRUE;
		for (j=0;j<glb.opt.Win_Num && ok;j++)
			if (W[j].handle>0)
			{
				_mousework();
				if (W[j].gadget&wSWAP && mem.bloc[W[j].in].type!=MB_NOMOVE && !W[j].smallflag)
				{
					sprintf(glb.div.log,"Swap   Win #%i (%08li) (EGLIB%03i.%03i) ... ",j,mem.bloc[W[j].in].len,glb.aes.id,j);
					_reportLog();
					sprintf(file,"%sEGLIB%03i.%03i",iglb.div.SWP_Path,glb.aes.id,j);
					ha=(int)Fcreate(file,0);
					if (ha>0)
					{
						if ( Fwrite(ha,mem.bloc[W[j].in].len,(void *)mem.bloc[W[j].in].adr) != mem.bloc[W[j].in].len )
						{
							Fclose(ha);
							ok=FALSE;
						}
						else
							ok=!Fclose(ha);
					}
					else
						ok=FALSE;
					if (ok)
					{
						sprintf(glb.div.log,"ok!\n");
						_reportLog();
					}
					else
					{
						sprintf(glb.div.log,"error!\n");
						_reportLog();
						Fdelete(file);
					}
				}
				graf_mouse(ARROW,0);
			}
		for (j=0;j<glb.opt.Win_Num && ok;j++)
			if (W[j].handle>0)
			{
				if (W[j].smallflag)
				{
					if (ok)
					{
						wind_close(W[j].handle);
						wind_delete(W[j].handle);
						W[j].handle=-2;
						W[j].smallflag=0;
					}
				}
				else
				{
					if (ok)
					{
						if (W[j].small!=0)
							(*W[j].small)(j);
						if (W[j].gadget&wSWAP && mem.bloc[W[j].in].type!=MB_NOMOVE)
						{
							_mFree(W[j].in);
							W[j].in=SWP_MEMORY;
						}
						if (j!=i)
						{
							wind_close(W[j].handle);
							wind_delete(W[j].handle);
							W[j].handle=-2;
							_clearAesBuffer();
						}
					}
					else
						Fdelete(file);
				}
			}
		if (ok)
		{
			ha=W[i].handle;
			if (iglb.aes.Big_Icon)
				tree=iglb.rsc.head.trindex[BICN];
			else
				tree=iglb.rsc.head.trindex[LICN];
			iglb.aes.Old_Tree=W[i].ic_tree;
			iglb.aes.Old_Icon=W[i].icon;
			if (glb.aes.ic_tree==-1)
				switch	(glb.aes.icon)
				{
					case	WIC_EXT:
						W[i].ic_tree=-1;
						W[i].icon=0;
						break;
					case	WIC_INF:
						W[i].icon=ICNINF;
						W[i].ic_tree=ICONE|FLAGS15;
						break;
					case	WIC_MEM:
						W[i].icon=ICNMEM;
						W[i].ic_tree=ICONE|FLAGS15;
						break;
					case	WIC_FNT:
						W[i].icon=ICNFNT;
						W[i].ic_tree=ICONE|FLAGS15;
						break;
					case	WIC_OPT:
						W[i].icon=ICNOPT;
						W[i].ic_tree=ICONE|FLAGS15;
						break;
					case	WIC_SYS:
						W[i].icon=ICNSYS;
						W[i].ic_tree=ICONE|FLAGS15;
						break;
					case	WIC_HLP:
						W[i].icon=ICNHLP;
						W[i].ic_tree=ICONE|FLAGS15;
						break;
					case	WIC_DEF:
					default:
						W[i].icon=ICNDEF;
						W[i].ic_tree=ICONE|FLAGS15;
						break;
				}
			else
			{
				W[i].ic_tree	=	glb.aes.ic_tree;
				W[i].icon		=	glb.aes.icon;
			}
			wind_get(ha,WF_WORKXYWH,&x,&y,&w,&h);
			tree->ob_x=x+(w-tree->ob_width)/2;
			tree->ob_y=y+(h-tree->ob_height)/2;
			wind_calc(WC_BORDER,0,tree->ob_x,tree->ob_y,tree->ob_width,tree->ob_height,&x,&y,&w,&h);


			if (!glb.opt.Rev_Verti)
			{
				if (!glb.opt.Rev_Horiz)
				{
					W[i].xsmall=glb.aes.xdesk;
					W[i].ysmall=glb.aes.ydesk;
				}
				else
				{
					W[i].xsmall=glb.aes.xdesk;
					W[i].ysmall=glb.aes.ydesk+glb.aes.hdesk-h;
				}
			}
			else
			{
				if (!glb.opt.Rev_Horiz)
				{
					W[i].xsmall=glb.aes.xdesk+glb.aes.wdesk-w;
					W[i].ysmall=glb.aes.ydesk;
				}
				else
				{
					W[i].xsmall=glb.aes.xdesk+glb.aes.wdesk-w;
					W[i].ysmall=glb.aes.ydesk+glb.aes.hdesk-h;
				}
			}
			W[i].wsmall=w;
			W[i].hsmall=h;
			wind_set(ha,WF_CURRXYWH,W[i].xsmall,W[i].ysmall,W[i].wsmall,W[i].hsmall);
			wind_get(ha,WF_WORKXYWH,&W[i].xwsmall,&W[i].ywsmall,&W[i].wwsmall,&W[i].hwsmall);
			wind_get(ha,WF_WORKXYWH,&iW[i].mxwsmall,&iW[i].mywsmall,&iW[i].mwwsmall,&iW[i].mhwsmall);
			tree[1].ob_height=16/(1+glb.vdi.low)-1;
			W[i].ywsmall+=tree[1].ob_height+1;
			W[i].hwsmall-=tree[1].ob_height-1;
			W[i].smallflag=2;
			_winRedraw(i,0,0,0,0);
		}
	}
}
void _unsmall(int i)
{
	long	len;
	int	in,ok,ha;
	char	file[FILENAME_MAX];

	if (i!=-1)
		if (W[i].smallflag==1)
		{
			ok=TRUE;
			_mousework();
			if ( W[i].gadget&wSWAP && W[i].in==SWP_MEMORY )
			{
				sprintf(file,"%sEGLIB%03i.%03i",iglb.div.SWP_Path,glb.aes.id,i);
				ha=(int)Fopen(file,FO_READ);
				if (ha>0)
				{
					len=Fseek(0L,ha,2);
					sprintf(glb.div.log,"UnSwap Win #%i (%08li) (EGLIB%03i.%03i) ... ",i,len,glb.aes.id,i);
					_reportLog();
					Fseek(0L,ha,0);
					in=_mAlloc(len,MB_NORM,0);
					if (in!=NO_MEMORY)
					{
						if ( Fread(ha,len,(void *)mem.bloc[in].adr) != len )
							ok=FALSE;
					}
					else
						ok=FALSE;
					ok=!Fclose(ha) && in!=NO_MEMORY;
				}
				else
					ok=FALSE;
				if (ok)
				{
					sprintf(glb.div.log,"ok!\n");
					_reportLog();
					W[i].in=in;
					Fdelete(file);
				}
				else
				{
					sprintf(glb.div.log,"error!\n");
					_reportLog();
				}
			}
			graf_mouse(ARROW,0);
			if (ok)
			{
				W[i].smallflag=0;
				if (W[i].nsmall!=0)
					(*W[i].nsmall)(i);
				wind_set(W[i].handle,WF_CURRXYWH,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
				_winRedraw(i,0,0,0,0);
				_clearAesBuffer();
				_winAlign();
			}
		}
}
void _allunsmall(int i)
{
	window	win;
	long		len;
	int		j,in,ha,ok;
	char		file[FILENAME_MAX];

	if (i!=-1)
	{
		ok=TRUE;
		for (j=0;j<glb.opt.Win_Num;j++)
		{
			_mousework();
			if ( W[j].gadget&wSWAP && W[j].in==SWP_MEMORY )
			{
				sprintf(file,"%sEGLIB%03i.%03i",iglb.div.SWP_Path,glb.aes.id,j);
				ha=(int)Fopen(file,FO_READ);
				if (ha>0)
				{
					len=Fseek(0L,ha,2);
					sprintf(glb.div.log,"UnSwap Win #%i (%08li) (EGLIB%03i.%03i) ... ",j,len,glb.aes.id,j);
					_reportLog();
					Fseek(0L,ha,0);
					in=_mAlloc(len,MB_NORM,0);
					if (in!=NO_MEMORY)
					{
						if ( Fread(ha,len,(void *)mem.bloc[in].adr) != len )
							ok=FALSE;
					}
					else
						ok=FALSE;
					ok=!Fclose(ha) && in!=NO_MEMORY;
				}
				else
					ok=FALSE;
				if (ok)
					W[j].in=in;
			}
			graf_mouse(ARROW,0);
		}

		if (ok)
		{
			for (j=0;j<glb.opt.Win_Num;j++)
			{
				graf_mouse(BUSYBEE,0);
				if ( W[j].gadget&wSWAP && W[j].in==SWP_MEMORY )
				{
					sprintf(file,"%sEGLIB%03i.%03i",iglb.div.SWP_Path,glb.aes.id,j);
					Fdelete(file);
				}
				graf_mouse(ARROW,0);
				if (W[j].handle==-2 && j!=i)
				{
					if (W[j].nsmall!=0)
						(*W[j].nsmall)(j);
					win=W[j];
					W[j].handle=-1;
					_winOpen(&win);
					_clearAesBuffer();
				}
				else if (j==i)
				{
					W[i].ic_tree=iglb.aes.Old_Tree;
					W[i].icon=iglb.aes.Old_Icon;
					W[i].smallflag=0;
					if (W[i].nsmall!=0)
						(*W[i].nsmall)(i);
					wind_set(W[i].handle,WF_CURRXYWH,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
					_winRedraw(i,0,0,0,0);
				}
			}
			if (iglb.aes.fmod)
				_top(iglb.aes.wmod);
		}
	}
}


/*******************************************************************************
	Handle top events
*******************************************************************************/
void _top(int i)
{
	if (i!=-1)
	{
		wind_set(W[i].handle,WF_TOP);
		if (W[i].top!=0)
			(*W[i].top)(i);
	}
}
void _untop(int i)
{
	if (i!=-1)
	{
		_maketop();
		if (W[i].untop!=0)
			(*W[i].untop)(i);
	}
}
void _ontop(int i)
{
	if (i!=-1)
	{
		_maketop();
		if (W[i].ontop!=0)
			(*W[i].ontop)(i);
	}
}


/*******************************************************************************
	Handle closed event
*******************************************************************************/
void _closed(int i)
{
	int	ha;

	if (i!=-1)
	{
		ha=W[i].handle;
		wind_close(ha);
		wind_delete(ha);
		W[i].handle=-1;
		if (W[i].close!=0)
			(*W[i].close)(i);
		if (W[i].smallflag==1)
		{
			sprintf(glb.div.log,"%sEGLIB%03i.%03i",iglb.div.SWP_Path,glb.aes.id,i);
			Fdelete(glb.div.log);
		}
		wind_update(BEG_MCTRL);
		if (W[i].gadget&wMODAL)
		{
			iglb.aes.fmod=0;
			iglb.aes.wmod=-1;
			_exitModal();
		}
		wind_update(END_MCTRL);
	}
}


/*******************************************************************************
	Handle fulled event
*******************************************************************************/
void _full(int i)
{
	int		dum,ha;

	if (i!=-1)
	{
		ha=W[i].handle;
		if ( W[i].wwind>=W[i].wfull && W[i].hwind>=W[i].hfull )
		{
			W[i].xfull=W[i].xwind;
			W[i].yfull=W[i].ywind;
			W[i].xwind=iW[i].xold;
			W[i].ywind=iW[i].yold;
			W[i].wwind=min(iW[i].wold,W[i].wfull);
			W[i].hwind=min(iW[i].hold,W[i].hfull);
		}
		else
		{
			iW[i].xold	=	W[i].xwind;
			iW[i].yold	=	W[i].ywind;
			iW[i].wold	=	W[i].wwind;
			iW[i].hold	=	W[i].hwind;
			W[i].xwind	=	W[i].xfull;
			W[i].ywind	=	W[i].yfull;
			W[i].wwind	=	W[i].wfull;
			W[i].hwind	=	W[i].hfull;
		}
		wind_calc(WC_WORK,0,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind,&iW[i].mxwork,&iW[i].mywork,&iW[i].mwwork,&iW[i].mhwork);
		if ( (iW[i].xold-W[i].xwind)%16 && W[i].gadget&wXWORK16 )
		{
			dum=16-iW[i].mxwork%16;
			W[i].xwind+=dum;
			iW[i].mxwork+=dum;
		}
		wind_set(ha,WF_CURRXYWH,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
		wind_get(ha,WF_WORKXYWH,&iW[i].mxwork,&iW[i].mywork,&iW[i].mwwork,&iW[i].mhwork);
		_setWindow(i);
		if (W[i].full!=0)
			(*W[i].full)(i);
	}
}


/*******************************************************************************
	Handle sized event
*******************************************************************************/
void _size(int i,int w,int h)
{
	int		ha,nW,nH;

	if (i!=-1)
	{
		ha=W[i].handle;
		nW=w;
		nH=h;
		if ( (W[i].wwind!=nW) || (W[i].hwind!=nH) )
		{
			W[i].wwind=min(nW,W[i].wfull);
			W[i].hwind=min(nH,W[i].hfull);
			wind_set(ha,WF_CURRXYWH,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
			wind_get(ha,WF_WORKXYWH,&iW[i].mxwork,&iW[i].mywork,&iW[i].mwwork,&iW[i].mhwork);
			_setWindow(i);
			if (W[i].size!=0)
				(*W[i].size)(i,w,h);
		}
	}
}


/*******************************************************************************
	Handle moved event
*******************************************************************************/
void _move(int i,int xx,int yy)
{
	OBJECT	*tree;
	int		ha,dum,oldx,x,y,w,h;

	if (i!=-1)
	{
		ha=W[i].handle;
		wind_get(ha,WF_CURRXYWH,&x,&y,&w,&h);
		x=xx;
		y=yy;

		x=max(glb.aes.xdesk,x);
		y=max(glb.aes.ydesk,y);

		if (W[i].smallflag)
		{
			if (iglb.aes.Big_Icon)
				tree=iglb.rsc.head.trindex[BICN];
			else
				tree=iglb.rsc.head.trindex[LICN];
			tree->ob_x=iW[i].mxwsmall;
			tree->ob_y=iW[i].mywsmall;
			W[i].xsmall=xx;
			W[i].ysmall=yy;
			W[i].wsmall=w;
			W[i].hsmall=h;
			wind_set(ha,WF_CURRXYWH,W[i].xsmall,W[i].ysmall,W[i].wsmall,W[i].hsmall);
			wind_get(ha,WF_WORKXYWH,&W[i].xwsmall,&W[i].ywsmall,&W[i].wwsmall,&W[i].hwsmall);
			wind_get(ha,WF_WORKXYWH,&iW[i].mxwsmall,&iW[i].mywsmall,&iW[i].mwwsmall,&iW[i].mhwsmall);
			tree[1].ob_height=16/(1+glb.vdi.low)-1;
			W[i].ywsmall+=tree[1].ob_height+1;
			W[i].hwsmall-=tree[1].ob_height-2;
			if (W[i].xwsmall%16 && W[i].gadget&wXWORK16)
			{
				dum=16-W[i].xwsmall%16;
				W[i].xwsmall+=dum;
				W[i].xsmall+=dum;
				iW[i].mxwsmall+=dum;
			}
			wind_set(ha,WF_CURRXYWH,W[i].xsmall,W[i].ysmall,W[i].wsmall,W[i].hsmall);
		}
		else
		{
			oldx=W[i].xwind;
			W[i].xwind=x;
			W[i].ywind=y;

			wind_calc(WC_WORK,0,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind,&iW[i].mxwork,&iW[i].mywork,&iW[i].mwwork,&iW[i].mhwork);
			if ( (oldx-x)%16 && W[i].gadget&wXWORK16 )
			{
				dum=16-iW[i].mxwork%16;
				W[i].xwind+=dum;
				iW[i].mxwork+=dum;
			}
			wind_set(ha,WF_CURRXYWH,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind);
			wind_get(ha,WF_WORKXYWH,&iW[i].mxwork,&iW[i].mywork,&iW[i].mwwork,&iW[i].mhwork);
			W[i].xwork=iW[i].mxwork+iW[i].params.x;
			W[i].ywork=iW[i].mywork+iW[i].params.y+1;
			if ( W[i].move!=0 && (oldx!=W[i].xwind || yy!=y) )
				(*W[i].move)(i,W[i].xwind,W[i].ywind);
		}
	}
}


/*******************************************************************************
	Handle redraw event
*******************************************************************************/
void _redraw(int i,int x,int y,int w,int h)
{
	OBJECT	*tree;
	GRECT		r,rd,my;
	int		ha,lattr[6],pxy[8];

	if (i!=-1)
	if (W[i].handle>0)
	{
		ha=W[i].handle;
		w=min(w,1+glb.vdi.out[0]-x);
		h=min(h,1+glb.vdi.out[1]-y);
		rd.g_x=x;
		rd.g_y=y;
		rd.g_w=w;
		rd.g_h=h;

		graf_mouse(M_OFF,0);
		wind_update(BEG_UPDATE);
		_makeform(i);

		wind_get(ha,WF_FIRSTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
		while (r.g_w && r.g_h)
		{
			if (_rcIntersect(&rd,&r))
			{
				if (W[i].smallflag)
				{
					if (iglb.aes.Big_Icon)
						tree=iglb.rsc.head.trindex[BICN];
					else
						tree=iglb.rsc.head.trindex[LICN];
					tree->ob_x=iW[i].mxwsmall;
					tree->ob_y=iW[i].mywsmall;
					objc_draw(tree,ROOT,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					if (W[i].ic_tree!=-1)
					{
						if (W[i].ic_tree&FLAGS15)
							tree=iglb.rsc.head.trindex[W[i].ic_tree&~FLAGS15];
						else
							tree=glb.rsc.head.trindex[W[i].ic_tree];
						tree[W[i].icon].ob_x=0;
						tree[W[i].icon].ob_y=0;
						tree[W[i].icon].ob_state&=~SELECTED;
						tree->ob_x=W[i].xwsmall+(W[i].wwsmall-tree[W[i].icon].ob_width)/2;
						tree->ob_y=W[i].ywsmall+(W[i].hwsmall-tree[W[i].icon].ob_height)/2;
						objc_draw(tree,W[i].icon,0,r.g_x,r.g_y,r.g_w,r.g_h);
					}
					my.g_x=W[i].xwsmall;
					my.g_y=W[i].ywsmall;
					my.g_w=W[i].wwsmall;
					my.g_h=W[i].hwsmall;
					if (_rcIntersect(&r,&my))
						if (!W[i].icon && W[i].smallflag==1 && W[i].redraw)
							(*W[i].redraw)(i,my.g_x,my.g_y,my.g_w,my.g_h);
				}
				else
				{
					objc_draw(iglb.aes.tree,FWINAME,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINCLS,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINPOP,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINCYC,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINICO,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINFUL,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINVSF,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINUAR,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINDAR,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINHSF,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINLAR,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINRAR,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINSIZ,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);

					_setClip(TRUE,&r);
					vql_attributes(glb.vdi.ha,lattr);
					vsl_color(glb.vdi.ha,1);
					vsl_type(glb.vdi.ha,SOLID);
					vsl_width(glb.vdi.ha,1);

					pxy[0]=iW[i].mxwork+iW[i].params.x;
					pxy[1]=iW[i].mywork+iW[i].params.y;
					pxy[2]=iW[i].mxwork+iW[i].mwwork;
					pxy[3]=pxy[1];
					v_pline(glb.vdi.ha,2,pxy);
					if (iW[i].params.w)
					{
						pxy[0]=iW[i].mxwork+iW[i].mwwork-iW[i].params.w-1;
						pxy[1]=iW[i].mywork+iW[i].params.y;
						pxy[2]=pxy[0];
						pxy[3]=iW[i].mywork+iW[i].mhwork-iW[i].params.h-1;
						v_pline(glb.vdi.ha,2,pxy);
					}
					if (iW[i].params.h)
					{
						pxy[0]=iW[i].mxwork+iW[i].params.x;
						pxy[1]=iW[i].mywork+iW[i].mhwork-iW[i].params.h-1;
						pxy[2]=iW[i].mxwork+iW[i].mwwork;
						pxy[3]=pxy[1];
						v_pline(glb.vdi.ha,2,pxy);
					}
					vsl_type(glb.vdi.ha,lattr[0]);
					vsl_color(glb.vdi.ha,lattr[1]);
					_setClip(FALSE,&r);

					my.g_x=W[i].xwork;
					my.g_y=W[i].ywork;
					my.g_w=W[i].wwork;
					my.g_h=W[i].hwork;
					if (_rcIntersect(&r,&my))
						if (W[i].redraw!=0)
							(*W[i].redraw)(i,my.g_x,my.g_y,my.g_w,my.g_h);
				}
			}
			wind_get(ha,WF_NEXTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
		}
		wind_update(END_UPDATE);
		graf_mouse(M_ON,0);
	}
}


/*******************************************************************************
	Handle clic on window
*******************************************************************************/
void _clicWin(int i,int x,int y,int k,int nmb)
{
	GRECT		r,rd;
	OBJECT	*tree;
	int		ok=0;
	int		dep,top,t,ha;
	int		n,mx=0,my=0,mk=k,sel,sel1,sel2;
	int		obx,oby,obw,obh,dum;
	int		bx,by,bw,bh;
	int		sx,sy;
	int		fx,fy;
	int		px,py;
	int		pop,rpop;
	int		dec;

	if (i!=-1)
	{
		ha=W[i].handle;
		wind_update(BEG_MCTRL);
		_makeform(i);
		wind_get(0,WF_TOP,&top);
		if (W[i].smallflag)
		{
			if (iglb.aes.Big_Icon)
				tree=iglb.rsc.head.trindex[BICN];
			else
				tree=iglb.rsc.head.trindex[LICN];
			tree->ob_x=iW[i].mxwsmall;
			tree->ob_y=iW[i].mywsmall;
			n=objc_find(tree,ROOT,MAX_DEPTH,iglb.aes.mx,iglb.aes.my);
			switch (n)
			{
				case	1:
					graf_mkstate(&dum,&dum,&mk,&dum);
					if (W[i].gadget&wMOVE && mk)
					{
						bx=W[i].xsmall;
						by=W[i].ysmall;
						bw=W[i].wsmall;
						bh=W[i].hsmall;
						graf_mouse(FLAT_HAND,0);
						graf_dragbox(bw,bh,bx,by,glb.aes.xdesk+1,glb.aes.ydesk+1,glb.aes.wdesk-2,glb.aes.hdesk-2,&bx,&by);
						graf_mouse(ARROW,0);
						_move(i,bx,by);
					}
					else if (!iglb.aes.fmod)
					{
						wind_update(BEG_UPDATE);
						wind_get(0,WF_TOP,&top);
						if (top!=ha)
						{
							_top(i);
							_ontop(i);
						}
						wind_update(END_UPDATE);
					}
					ok=1;
					break;
				default:
					if (nmb==2)
						if (!iglb.aes.fmod || (iglb.aes.wmod==i))
						{
							if (W[i].ic_tree!=-1)
							{
								wind_update(BEG_UPDATE);
								graf_mouse(M_OFF,0);
								rd.g_x=W[i].xwsmall;
								rd.g_y=W[i].ywsmall;
								rd.g_w=W[i].wwsmall;
								rd.g_h=W[i].hwsmall;
								wind_get(W[i].handle,WF_FIRSTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
								while (r.g_w && r.g_h)
								{
									if (_rcIntersect(&rd,&r))
									{
										if (iglb.aes.Big_Icon)
											tree=iglb.rsc.head.trindex[BICN];
										else
											tree=iglb.rsc.head.trindex[LICN];
										objc_draw(tree,ROOT,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
										if (W[i].ic_tree!=-1)
										{
											if (W[i].ic_tree&FLAGS15)
												tree=iglb.rsc.head.trindex[W[i].ic_tree&~FLAGS15];
											else
												tree=glb.rsc.head.trindex[W[i].ic_tree];
											tree[W[i].icon].ob_x=0;
											tree[W[i].icon].ob_y=0;
											tree[W[i].icon].ob_state|=SELECTED;
											tree->ob_x=W[i].xwsmall+(W[i].wwsmall-tree[W[i].icon].ob_width)/2;
											tree->ob_y=W[i].ywsmall+(W[i].hwsmall-tree[W[i].icon].ob_height)/2;
											objc_draw(tree,W[i].icon,0,r.g_x,r.g_y,r.g_w,r.g_h);
										}
									}
									wind_get(ha,WF_NEXTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
								}
								wind_update(END_UPDATE);
								graf_mouse(M_ON,0);
							}
							if (W[i].smallflag==1)
								_unsmall(i);
							else
								_allunsmall(i);
						}
					ok=1;
					break;
			}
		}
		else
		{
			n=objc_find(iglb.aes.tree,ROOT,MAX_DEPTH,x,y);
			switch (n)
			{
				case FWINCLS:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						sel1=iglb.aes.tree[n].ob_state;
						iglb.aes.tree[n].ob_state^=SELECTED;
						sel2=iglb.aes.tree[n].ob_state;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						graf_mouse(M_OFF,0);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						graf_mouse(M_ON,0);
						while (mk>0)
						{
							sel=iglb.aes.tree[n].ob_state;
							graf_mkstate(&mx,&my,&mk,&dum);
							if (objc_find(iglb.aes.tree,ROOT,MAX_DEPTH,mx,my)==n)
								sel=sel2;
							else
								sel=sel1;
							if (iglb.aes.tree[n].ob_state!=sel)
							{
								iglb.aes.tree[n].ob_state=sel;
								graf_mouse(M_OFF,0);
								_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
								if (top!=ha)
									_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
								else
									objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
								graf_mouse(M_ON,0);
							}
						}
						if (iglb.aes.tree[n].ob_state&SELECTED)
						{
							iglb.aes.tree[n].ob_state^=SELECTED;
							_closed(i);
						}
					}
					ok=1;
					break;
				case FWINFUL:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						sel1=iglb.aes.tree[n].ob_state;
						iglb.aes.tree[n].ob_state^=SELECTED;
						sel2=iglb.aes.tree[n].ob_state;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						while (mk>0)
						{
							sel=iglb.aes.tree[n].ob_state;
							graf_mkstate(&mx,&my,&mk,&dum);
							if (objc_find(iglb.aes.tree,ROOT,MAX_DEPTH,mx,my)==n)
								sel=sel2;
							else
								sel=sel1;
							if (iglb.aes.tree[n].ob_state!=sel)
							{
								iglb.aes.tree[n].ob_state=sel;
								graf_mouse(M_OFF,0);
								if (top!=ha)
									_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
								else
									objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
								graf_mouse(M_ON,0);
							}
						}
						if (iglb.aes.tree[n].ob_state&SELECTED)
						{
							iglb.aes.tree[n].ob_state^=SELECTED;
							if (top!=ha)
								_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							else
								objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							_full(i);
						}
					}
					ok=1;
					break;
				case FWINAME:
					graf_mkstate(&dum,&dum,&mk,&dum);
					if (W[i].gadget&wMOVE && mk)
					{
						wind_get(ha,WF_CURRXYWH,&bx,&by,&bw,&bh);
						graf_mouse(FLAT_HAND,0);
						graf_dragbox(bw,bh,bx,by,glb.aes.xdesk,glb.aes.ydesk,glb.aes.wdesk+bw,glb.aes.hdesk+bh,&bx,&by);
						graf_mouse(ARROW,0);
						_move(i,bx,by);
					}
					else if (!iglb.aes.fmod)
					{
						wind_update(BEG_UPDATE);
						wind_get(0,WF_TOP,&top);
						if (top!=ha)
						{
							_top(i);
							_ontop(i);
						}
						wind_update(END_UPDATE);
					}
					ok=1;
					break;
				case FWINSIZ:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
						if (W[i].gadget&wSIZE)
						{
							iglb.aes.tree[n].ob_state|=SELECTED;
							_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
							if (top!=ha)
								_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							else
								objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							wind_get(ha,WF_CURRXYWH,&bx,&by,&bw,&bh);
							graf_mouse(USER_DEF,&iglb.aes.s[FSOUSIZ]);
							graf_rubberbox(bx,by,W[i].wmini,W[i].hmini,&bw,&bh);
							graf_mouse(ARROW,0);
							bw=min(bw,W[i].wfull);
							bh=min(bh,W[i].hfull);
							iglb.aes.tree[n].ob_state&=~SELECTED;
							_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
							if (top!=ha)
								_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							else
								objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							if (W[i].wwind!=bw || W[i].hwind!=bh)
								_size(i,bw,bh);
						}
					ok=1;
					break;
				case	FWINUAR:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						iglb.aes.tree[n].ob_state|=SELECTED;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						do
						{
							graf_mkstate(&dum,&dum,&mk,&dum);
							if (W[i].yslidlen!=1000 && W[i].yslidpos>0 && W[i].arrow!=0)
							{
								(*W[i].arrow)(i,WA_UPLINE);
								_clearAesBuffer();
							}
						}	while (mk);
						iglb.aes.tree[n].ob_state&=~SELECTED;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					}
					ok=1;
					break;
				case	FWINDAR:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						iglb.aes.tree[n].ob_state|=SELECTED;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						do
						{
							graf_mkstate(&dum,&dum,&mk,&dum);
							if (W[i].yslidlen!=1000 && W[i].yslidpos<1000 && W[i].arrow!=0)
							{
								(*W[i].arrow)(i,WA_DNLINE);
								_clearAesBuffer();
							}
						}	while (mk);
						iglb.aes.tree[n].ob_state&=~SELECTED;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					}
					ok=1;
					break;
				case	FWINVSF:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						_coord(iglb.aes.tree,FWINVSP,FALSE,&obx,&oby,&obw,&obh);
						objc_offset(iglb.aes.tree,FWINVSP,&sx,&sy);
						graf_mouse(M_OFF,0);
						if (W[i].arrow!=0)
						{
							if (y<sy)
								(*W[i].arrow)(i,WA_UPPAGE);
							else
							(*W[i].arrow)(i,WA_DNPAGE);
						}
						graf_mouse(M_ON,0);
					}
					ok=1;
					break;
				case	FWINVSP:
				case	FWINVSI:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						objc_offset(iglb.aes.tree,FWINVSP,&px,&py);
						objc_offset(iglb.aes.tree,FWINVSF,&fx,&fy);
						graf_mkstate(&mx,&my,&mk,&dum);
						dec=py-my;
						graf_mouse(M_OFF,0);
						do
						{
							graf_mkstate(&mx,&my,&mk,&dum);
							dum=my-fy+dec;
							dum=max(0,dum);
							dum=min(iglb.aes.tree[FWINVSF].ob_height-iglb.aes.tree[FWINVSP].ob_height,dum);
							if (dum!=iglb.aes.tree[FWINVSP].ob_y)
							{
								iglb.aes.tree[FWINVSP].ob_y=dum;
								_coord(iglb.aes.tree,FWINVSF,FALSE,&obx,&oby,&obw,&obh);
								obx+=1; obw-=2;
								if (top!=ha)
									_winObdraw(i,iglb.aes.tree,FWINVSF,MAX_DEPTH,obx,oby,obw,obh);
								else
									objc_draw(iglb.aes.tree,FWINVSF,MAX_DEPTH,obx,oby,obw,obh);
								W[i].yslidpos=(double)iglb.aes.tree[FWINVSP].ob_y*1000.0/(double)(iglb.aes.tree[FWINVSF].ob_height-iglb.aes.tree[FWINVSP].ob_height);
								_winVslid(i);
								if ( (k!=2) && (W[i].vslid!=0) )
									(*W[i].vslid)(i,W[i].yslidpos);
								_clearAesBuffer();
							}
						}	while (mk);
						if (k==2)
							(*W[i].vslid)(i,W[i].yslidpos);
						graf_mouse(M_ON,0);
					}
					ok=1;
					break;
				case	FWINLAR:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						iglb.aes.tree[n].ob_state|=SELECTED;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						do
						{
							graf_mkstate(&dum,&dum,&mk,&dum);
							if (W[i].xslidlen!=1000 && W[i].xslidpos>0 && W[i].arrow!=0)
							{
								(*W[i].arrow)(i,WA_LFLINE);
								_clearAesBuffer();
							}
						}	while (mk);
						iglb.aes.tree[n].ob_state&=~SELECTED;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					}
					ok=1;
					break;
				case	FWINRAR:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						iglb.aes.tree[n].ob_state|=SELECTED;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						do
						{
							graf_mkstate(&dum,&dum,&mk,&dum);
							if (W[i].xslidlen!=1000 && W[i].xslidpos<1000 && W[i].arrow!=0)
							{
								(*W[i].arrow)(i,WA_RTLINE);
								_clearAesBuffer();
							}
						}	while (mk);
						iglb.aes.tree[n].ob_state&=~SELECTED;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
					}
					ok=1;
					break;
				case	FWINHSF:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						objc_offset(iglb.aes.tree,FWINHSP,&sx,&sy);
						graf_mouse(M_OFF,0);
						if (W[i].arrow!=0)
						{
							if (x<sx)
								(*W[i].arrow)(i,WA_LFPAGE);
							else
								(*W[i].arrow)(i,WA_RTPAGE);
						}
						graf_mouse(M_ON,0);
					}
					ok=1;
					break;
				case	FWINHSP:
				case	FWINHSI:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						objc_offset(iglb.aes.tree,FWINHSP,&px,&py);
						objc_offset(iglb.aes.tree,FWINHSF,&fx,&fy);
						graf_mkstate(&mx,&my,&mk,&dum);
						dec=px-mx;
						graf_mouse(M_OFF,0);
						do
						{
							graf_mkstate(&mx,&my,&mk,&dum);
							dum=mx-fx+dec;
							dum=max(0,dum);
							dum=min(iglb.aes.tree[FWINHSF].ob_width-iglb.aes.tree[FWINHSP].ob_width,dum);
							if (dum!=iglb.aes.tree[FWINHSP].ob_x)
							{
								iglb.aes.tree[FWINHSP].ob_x=dum;
								_coord(iglb.aes.tree,FWINHSF,FALSE,&obx,&oby,&obw,&obh);
								obx+=1; obw-=2;
								if (top!=ha)
									_winObdraw(i,iglb.aes.tree,FWINHSF,MAX_DEPTH,obx,oby,obw,obh);
								else
									objc_draw(iglb.aes.tree,FWINHSF,MAX_DEPTH,obx,oby,obw,obh);
								W[i].xslidpos=(double)iglb.aes.tree[FWINHSP].ob_x*1000.0/(double)(iglb.aes.tree[FWINHSF].ob_width-iglb.aes.tree[FWINHSP].ob_width);
								_winHslid(i);
								if ( (k!=2) && (W[i].hslid!=0) )
									(*W[i].hslid)(i,W[i].xslidpos);
								_clearAesBuffer();
							}
						}	while (mk);
						if (k==2)
							(*W[i].hslid)(i,W[i].xslidpos);
						graf_mouse(M_ON,0);
					}
					ok=1;
					break;
				case	FWINCYC:
					if (!iglb.aes.fmod)
					{
						sel1=iglb.aes.tree[n].ob_state;
						iglb.aes.tree[n].ob_state^=SELECTED;
						sel2=iglb.aes.tree[n].ob_state;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						while (mk>0)
						{
							sel=iglb.aes.tree[n].ob_state;
							graf_mkstate(&mx,&my,&mk,&dum);
							if (objc_find(iglb.aes.tree,ROOT,MAX_DEPTH,mx,my)==n)
								sel=sel2;
							else
								sel=sel1;
							if (iglb.aes.tree[n].ob_state!=sel)
							{
								iglb.aes.tree[n].ob_state=sel;
								graf_mouse(M_OFF,0);
								if (top!=ha)
									_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
								else
									objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
								graf_mouse(M_ON,0);
							}
						}
						if (iglb.aes.tree[n].ob_state&SELECTED)
						{
							iglb.aes.tree[n].ob_state^=SELECTED;
							if (top!=ha)
								_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							else
								objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							if (_winFindWin(top)!=-1)
								dep=_winFindWin(top);
							else
								dep=i;
							t=dep;
							do
							{
								t+=1;
								if (t>=glb.opt.Win_Num) t=0;
								if (W[t].handle>0)
								{
									if (W[t].handle!=top)
									{
										_top(t);
										_ontop(t);
									}
									t=dep;
								}
							}	while (t!=dep);
						}
					}
					ok=1;
					break;
				case	FWINICO:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						sel1=iglb.aes.tree[n].ob_state;
						iglb.aes.tree[n].ob_state^=SELECTED;
						sel2=iglb.aes.tree[n].ob_state;
						_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
						if (top!=ha)
							_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						else
							objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
						while (mk>0)
						{
							sel=iglb.aes.tree[n].ob_state;
							graf_mkstate(&mx,&my,&mk,&dum);
							if (objc_find(iglb.aes.tree,ROOT,MAX_DEPTH,mx,my)==n) sel=sel2; else sel=sel1;
							if (iglb.aes.tree[n].ob_state!=sel)
							{
								iglb.aes.tree[n].ob_state=sel;
								graf_mouse(M_OFF,0);
								if (top!=ha)
									_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
								else
									objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
								graf_mouse(M_ON,0);
							}
						}
						if (iglb.aes.tree[n].ob_state&SELECTED)
						{
							iglb.aes.tree[n].ob_state^=SELECTED;
							if (top!=ha)
								_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							else
								objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							if (iglb.aes.kst&0x04 && !iglb.aes.fmod)
								_allsmall(i);
							else
								_small(i);
						}
					}
					ok=1;
					break;
				case FWINPOP:
					if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					{
						pop=W[i].popup;
						if (pop!=-1)
						{
							iglb.aes.tree[n].ob_state|=SELECTED;
							_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
							if (top!=ha)
								_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							else
								objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							if (pop&FLAGS15)	rpop=_formMenu(iglb.aes.tree,n,iglb.rsc.head.trindex[pop-FLAGS15],-1,1,0)-1;
							else					rpop=_formMenu(iglb.aes.tree,n,glb.rsc.head.trindex[pop],-1,1,0)-1;
							iglb.aes.tree[n].ob_state&=~SELECTED;
							_coord(iglb.aes.tree,n,FALSE,&obx,&oby,&obw,&obh);
							if (top!=ha)
								_winObdraw(i,iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							else
								objc_draw(iglb.aes.tree,n,MAX_DEPTH,obx,oby,obw,obh);
							if (rpop!=-2)
								if (W[i].pop!=0) (*W[i].pop)(i,rpop);
						}
					}
					ok=1;
					break;
			}
		}
		wind_update(END_MCTRL);
		if (ok==0)
		{
			if (k==2)
			{
				do
				{
					graf_mkstate(&dum,&dum,&mk,&dum);
				}	while (mk);
				if (!iglb.aes.fmod || iglb.aes.wmod==i)
				{
					_top(i);
					_ontop(i);
				}
			}
			else if (W[i].smallflag==0 && W[i].clic!=0 && glb.aes.flag&MU_BUTTON)
				if (!iglb.aes.fmod || (iglb.aes.fmod && i==iglb.aes.wmod))
					(*W[i].clic)(i,x,y,k,nmb);
		}
	}
}


/*******************************************************************************
	redraw the window gadgets
*******************************************************************************/
void _redrawWindow(int i)
{
	GRECT		rd,r;
	int		ha,lattr[6],pxy[4];

	if (i!=-1)
		if (!W[i].smallflag)
		{
			ha=W[i].handle;
			rd.g_x=W[i].xwind;
			rd.g_y=W[i].ywind;
			rd.g_w=W[i].wwind;
			rd.g_h=W[i].hwind;

			_makeform(i);
			wind_get(ha,WF_FIRSTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
			while (r.g_w && r.g_h)
			{
				if (_rcIntersect(&rd,&r))
				{
					objc_draw(iglb.aes.tree,FWINAME,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINCLS,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINPOP,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINCYC,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINICO,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINFUL,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINVSF,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINUAR,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINDAR,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINHSF,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINLAR,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINRAR,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					objc_draw(iglb.aes.tree,FWINSIZ,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
					_setClip(TRUE,&r);
					vql_attributes(glb.vdi.ha,lattr);
					vsl_color(glb.vdi.ha,1);
					vsl_type(glb.vdi.ha,SOLID);
					vsl_width(glb.vdi.ha,1);
					pxy[0]=iW[i].mxwork+iW[i].params.x;
					pxy[1]=iW[i].mywork+iW[i].params.y;
					pxy[2]=iW[i].mxwork+iW[i].mwwork;
					pxy[3]=pxy[1];
					v_pline(glb.vdi.ha,2,pxy);
					if (iW[i].params.w)
					{
						pxy[0]=iW[i].mxwork+iW[i].mwwork-iW[i].params.w-1;
						pxy[1]=iW[i].mywork+iW[i].params.y;
						pxy[2]=pxy[0];
						pxy[3]=iW[i].mywork+iW[i].mhwork-iW[i].params.h-1;
						v_pline(glb.vdi.ha,2,pxy);
					}
					if (iW[i].params.h)
					{
						pxy[0]=iW[i].mxwork+iW[i].params.x;
						pxy[1]=iW[i].mywork+iW[i].mhwork-iW[i].params.h-1;
						pxy[2]=iW[i].mxwork+iW[i].mwwork;
						pxy[3]=pxy[1];
						v_pline(glb.vdi.ha,2,pxy);
					}
					vsl_type(glb.vdi.ha,lattr[0]);
					vsl_color(glb.vdi.ha,lattr[1]);
					_setClip(FALSE,&r);
				}
				wind_get(ha,WF_NEXTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
			}
		}
}


/*******************************************************************************
	This function adapts the RSC tree to a window
*******************************************************************************/
void _setWindow(int i)
{
	int		X,Y,WW,HH;
	int		nH=0,nD=0,nB=0,isB=0,isD=0;

	if (i!=-1)
	{
		WW=16;
		HH=16/(1+glb.vdi.low);

		if (W[i].gadget & wCLOSE)	{	nH++;	}
		if (W[i].gadget & wMENU)	{	nH++;	}
		if (W[i].gadget & wCYCLE)	{	nH++;	}
		if (W[i].gadget & wICON)	{	nH++;	}
		if (W[i].gadget & wFULL)	{	nH++;	}
		if (W[i].gadget & wUARROW)	{	nD++;	isD=1;	}
		if (W[i].gadget & wDARROW)	{	nD++;	isD=1;	}
		if (W[i].gadget & wRARROW)	{	nB++;	isB=1;	}
		if (W[i].gadget & wLARROW)	{	nB++;	isB=1;	}

		if (W[i].gadget & wVSLIDE)
			isD=1;
		else
		{
			iglb.aes.tree[FWINVSP].ob_flags|=HIDETREE;
			if (!isD)
				iglb.aes.tree[FWINVSF].ob_flags|=HIDETREE;
		}
		if (W[i].gadget & wHSLIDE)
			isB=1;
		else
		{
			iglb.aes.tree[FWINHSP].ob_flags|=HIDETREE;
			if (!isB)
				iglb.aes.tree[FWINHSF].ob_flags|=HIDETREE;
		}
		if (W[i].gadget & wSIZE)
		{
			if ( !isD && !isB )
			{
				isD=1;
				iglb.aes.tree[FWINVSF].ob_flags&=~HIDETREE;
			}
		}
		else
		{
			if ( isB || isD )
				iglb.aes.tree[FWINSIZ].ob_state|=DISABLED;
			else
				iglb.aes.tree[FWINSIZ].ob_flags|=HIDETREE;
		}

		wind_calc(WC_WORK,0,W[i].xwind,W[i].ywind,W[i].wwind,W[i].hwind,
			&iW[i].mxwork,&iW[i].mywork,&iW[i].mwwork,&iW[i].mhwork);

		W[i].wwork	=	iW[i].mwwork-isD*(1+WW);
		W[i].hwork	=	iW[i].mhwork-(1+isB)*(1+HH);

		if (W[i].gadget & wCLOSE)		iglb.aes.tree[FWINCLS].ob_x=0;
		iglb.aes.tree[FWINAME].ob_width=iW[i].mwwork-nH*WW-2;
		iglb.aes.tree[FWINAME].ob_height=HH-2;
		iglb.aes.tree[FWINAME].ob_state|=SELECTED;
		if (W[i].gadget & wCLOSE)		iglb.aes.tree[FWINAME].ob_x=WW+1;
		else									iglb.aes.tree[FWINAME].ob_x=1;
		iglb.aes.tree[FWINAME].ob_y=1;
		X=iW[i].mwwork-WW;
		if (W[i].gadget & wFULL)		{	iglb.aes.tree[FWINFUL].ob_x=X;		X-=WW;	}
		if (W[i].gadget & wMENU)		{	iglb.aes.tree[FWINPOP].ob_x=X;		X-=WW;	}
		if (W[i].gadget & wICON)		{	iglb.aes.tree[FWINICO].ob_x=X;		X-=WW;	}
		if (W[i].gadget & wCYCLE)		{	iglb.aes.tree[FWINCYC].ob_x=X;		X-=WW;	}

		iglb.aes.tree[FWINUAR].ob_x	=	iW[i].mwwork-WW;
		iglb.aes.tree[FWINDAR].ob_x	=	iW[i].mwwork-WW;
		iglb.aes.tree[FWINSIZ].ob_x	=	iW[i].mwwork-WW;

		Y=iW[i].mhwork-HH;
		iglb.aes.tree[FWINSIZ].ob_y=Y;	Y-=HH;
		if (W[i].gadget & wDARROW)		{	iglb.aes.tree[FWINDAR].ob_y=Y;	Y-=HH;	}
		if	(W[i].gadget & wUARROW)		{	iglb.aes.tree[FWINUAR].ob_y=Y;	Y-=HH;	}

		iglb.aes.tree[FWINVSF].ob_x		=	iW[i].mwwork-WW;
		iglb.aes.tree[FWINVSF].ob_y		=	HH+1;
		iglb.aes.tree[FWINVSF].ob_height	=	iW[i].mhwork-(1+nD)*HH-1;
		iglb.aes.tree[FWINVSF].ob_width	=	WW;
		iglb.aes.tree[FWINVSP].ob_x		=	0;
		iglb.aes.tree[FWINVSP].ob_width	=	WW;

		iglb.aes.tree[FWINHSF].ob_x		=	0;
		iglb.aes.tree[FWINHSF].ob_y		=	iW[i].mhwork-HH;
		iglb.aes.tree[FWINHSF].ob_width	=	iW[i].mwwork-nB*WW;
		iglb.aes.tree[FWINHSF].ob_height	=	HH;
		iglb.aes.tree[FWINHSP].ob_y		=	0;
		iglb.aes.tree[FWINHSP].ob_height	=	HH;

		iglb.aes.tree[FWINLAR].ob_y=iglb.aes.tree[FWINHSF].ob_y;
		iglb.aes.tree[FWINRAR].ob_y=iglb.aes.tree[FWINHSF].ob_y;
		iglb.aes.tree[FWINSIZ].ob_y=iglb.aes.tree[FWINHSF].ob_y;

		X=iW[i].mwwork-WW;
		iglb.aes.tree[FWINSIZ].ob_x=X;	X-=WW;
		if (W[i].gadget & wRARROW)		{	iglb.aes.tree[FWINRAR].ob_x=X;	X-=WW;	}
		if (W[i].gadget & wLARROW)		{	iglb.aes.tree[FWINLAR].ob_x=X;	X-=WW;	}

		iglb.aes.tree->ob_width=iW[i].mwwork;
		iglb.aes.tree->ob_height=iW[i].mhwork;

		iglb.aes.tree[FWINHSP].ob_width	=	(int)((double)iglb.aes.tree[FWINHSF].ob_width*(double)W[i].xslidlen/1000.0);
		iglb.aes.tree[FWINHSP].ob_width	=	max(iglb.aes.tree[FWINHSI].ob_width,iglb.aes.tree[FWINHSP].ob_width);
		iglb.aes.tree[FWINHSP].ob_width	=	min(iglb.aes.tree[FWINHSF].ob_width,iglb.aes.tree[FWINHSP].ob_width);
		iglb.aes.tree[FWINHSP].ob_x		=	(int)((double)(iglb.aes.tree[FWINHSF].ob_width-iglb.aes.tree[FWINHSP].ob_width)*(double)W[i].xslidpos/1000.0);
		iglb.aes.tree[FWINHSP].ob_x		=	max(0,iglb.aes.tree[FWINHSP].ob_x);
		iglb.aes.tree[FWINHSP].ob_x		=	min(iglb.aes.tree[FWINHSF].ob_width-iglb.aes.tree[FWINHSP].ob_width,iglb.aes.tree[FWINHSP].ob_x);
		iglb.aes.tree[FWINHSI].ob_x		=	(iglb.aes.tree[FWINHSP].ob_width-iglb.aes.tree[FWINHSI].ob_width)/2;
		iglb.aes.tree[FWINHSI].ob_x		=	max(0,iglb.aes.tree[FWINHSI].ob_x);

		iglb.aes.tree[FWINVSP].ob_height	=	(int)((double)iglb.aes.tree[FWINVSF].ob_height*(double)W[i].yslidlen/1000.0);
		iglb.aes.tree[FWINVSP].ob_height	=	max(iglb.aes.tree[FWINVSI].ob_height,iglb.aes.tree[FWINVSP].ob_height);
		iglb.aes.tree[FWINVSP].ob_height	=	min(iglb.aes.tree[FWINVSF].ob_height,iglb.aes.tree[FWINVSP].ob_height);
		iglb.aes.tree[FWINVSP].ob_y		=	(int)((double)(iglb.aes.tree[FWINVSF].ob_height-iglb.aes.tree[FWINVSP].ob_height)*(double)W[i].yslidpos/1000.0);
		iglb.aes.tree[FWINVSP].ob_y		=	max(0,iglb.aes.tree[FWINVSP].ob_y);
		iglb.aes.tree[FWINVSP].ob_y		=	min(iglb.aes.tree[FWINVSF].ob_height-iglb.aes.tree[FWINVSP].ob_height,iglb.aes.tree[FWINVSP].ob_y);
		iglb.aes.tree[FWINVSI].ob_y		=	(iglb.aes.tree[FWINVSP].ob_height-iglb.aes.tree[FWINVSI].ob_height)/2;
		iglb.aes.tree[FWINVSI].ob_y		=	max(0,iglb.aes.tree[FWINVSI].ob_y);

		iW[i].params.x		=	0;
		iW[i].params.y		=	HH;
		iW[i].params.w		=	isD*WW;
		iW[i].params.h		=	isB*HH;
		iW[i].params._box.x			=	iglb.aes.tree->ob_x;
		iW[i].params._box.y			=	iglb.aes.tree->ob_y;
		iW[i].params._box.w			=	iglb.aes.tree->ob_width;
		iW[i].params._box.h			=	iglb.aes.tree->ob_height;
		iW[i].params._box.flags		=	iglb.aes.tree->ob_flags;
		iW[i].params._name.x			=	iglb.aes.tree[FWINAME].ob_x;
		iW[i].params._name.y			=	iglb.aes.tree[FWINAME].ob_y;
		iW[i].params._name.w			=	iglb.aes.tree[FWINAME].ob_width;
		iW[i].params._name.h			=	iglb.aes.tree[FWINAME].ob_height;
		iW[i].params._name.flags	=	iglb.aes.tree[FWINAME].ob_flags;
		iW[i].params._close.x		=	iglb.aes.tree[FWINCLS].ob_x;
		iW[i].params._close.y		=	iglb.aes.tree[FWINCLS].ob_y;
		iW[i].params._close.flags	=	iglb.aes.tree[FWINCLS].ob_flags;
		iW[i].params._menu.x			=	iglb.aes.tree[FWINPOP].ob_x;
		iW[i].params._menu.y			=	iglb.aes.tree[FWINPOP].ob_y;
		iW[i].params._menu.flags	=	iglb.aes.tree[FWINPOP].ob_flags;
		iW[i].params._cycle.x		=	iglb.aes.tree[FWINCYC].ob_x;
		iW[i].params._cycle.y		=	iglb.aes.tree[FWINCYC].ob_y;
		iW[i].params._cycle.flags	=	iglb.aes.tree[FWINCYC].ob_flags;
		iW[i].params._icon.x			=	iglb.aes.tree[FWINICO].ob_x;
		iW[i].params._icon.y			=	iglb.aes.tree[FWINICO].ob_y;
		iW[i].params._icon.flags	=	iglb.aes.tree[FWINICO].ob_flags;
		iW[i].params._full.x			=	iglb.aes.tree[FWINFUL].ob_x;
		iW[i].params._full.y			=	iglb.aes.tree[FWINFUL].ob_y;
		iW[i].params._full.flags	=	iglb.aes.tree[FWINFUL].ob_flags;
		iW[i].params._vslf.x			=	iglb.aes.tree[FWINVSF].ob_x;
		iW[i].params._vslf.y			=	iglb.aes.tree[FWINVSF].ob_y;
		iW[i].params._vslf.w			=	iglb.aes.tree[FWINVSF].ob_width;
		iW[i].params._vslf.h			=	iglb.aes.tree[FWINVSF].ob_height;
		iW[i].params._vslf.flags	=	iglb.aes.tree[FWINVSF].ob_flags;
		iW[i].params._vslp.x			=	iglb.aes.tree[FWINVSP].ob_x;
		iW[i].params._vslp.y			=	iglb.aes.tree[FWINVSP].ob_y;
		iW[i].params._vslp.w			=	iglb.aes.tree[FWINVSP].ob_width;
		iW[i].params._vslp.h			=	iglb.aes.tree[FWINVSP].ob_height;
		iW[i].params._vslp.flags	=	iglb.aes.tree[FWINVSP].ob_flags;
		iW[i].params._vsli.x			=	iglb.aes.tree[FWINVSI].ob_x;
		iW[i].params._vsli.y			=	iglb.aes.tree[FWINVSI].ob_y;
		iW[i].params._vsli.w			=	iglb.aes.tree[FWINVSI].ob_width;
		iW[i].params._vsli.h			=	iglb.aes.tree[FWINVSI].ob_height;
		iW[i].params._vsli.flags	=	iglb.aes.tree[FWINVSI].ob_flags;
		iW[i].params._uarr.x			=	iglb.aes.tree[FWINUAR].ob_x;
		iW[i].params._uarr.y			=	iglb.aes.tree[FWINUAR].ob_y;
		iW[i].params._uarr.flags	=	iglb.aes.tree[FWINUAR].ob_flags;
		iW[i].params._darr.x			=	iglb.aes.tree[FWINDAR].ob_x;
		iW[i].params._darr.y			=	iglb.aes.tree[FWINDAR].ob_y;
		iW[i].params._darr.flags	=	iglb.aes.tree[FWINDAR].ob_flags;
		iW[i].params._size.x			=	iglb.aes.tree[FWINSIZ].ob_x;
		iW[i].params._size.y			=	iglb.aes.tree[FWINSIZ].ob_y;
		iW[i].params._size.flags	=	iglb.aes.tree[FWINSIZ].ob_flags;
		iW[i].params._rarr.x			=	iglb.aes.tree[FWINRAR].ob_x;
		iW[i].params._rarr.y			=	iglb.aes.tree[FWINRAR].ob_y;
		iW[i].params._rarr.flags	=	iglb.aes.tree[FWINRAR].ob_flags;
		iW[i].params._larr.x			=	iglb.aes.tree[FWINLAR].ob_x;
		iW[i].params._larr.y			=	iglb.aes.tree[FWINLAR].ob_y;
		iW[i].params._larr.flags	=	iglb.aes.tree[FWINLAR].ob_flags;
		iW[i].params._hslf.x			=	iglb.aes.tree[FWINHSF].ob_x;
		iW[i].params._hslf.y			=	iglb.aes.tree[FWINHSF].ob_y;
		iW[i].params._hslf.w			=	iglb.aes.tree[FWINHSF].ob_width;
		iW[i].params._hslf.h			=	iglb.aes.tree[FWINHSF].ob_height;
		iW[i].params._hslf.flags	=	iglb.aes.tree[FWINHSF].ob_flags;
		iW[i].params._hslp.x			=	iglb.aes.tree[FWINHSP].ob_x;
		iW[i].params._hslp.y			=	iglb.aes.tree[FWINHSP].ob_y;
		iW[i].params._hslp.w			=	iglb.aes.tree[FWINHSP].ob_width;
		iW[i].params._hslp.h			=	iglb.aes.tree[FWINHSP].ob_height;
		iW[i].params._hslp.flags	=	iglb.aes.tree[FWINHSP].ob_flags;
		iW[i].params._hsli.x			=	iglb.aes.tree[FWINHSI].ob_x;
		iW[i].params._hsli.y			=	iglb.aes.tree[FWINHSI].ob_y;
		iW[i].params._hsli.w			=	iglb.aes.tree[FWINHSI].ob_width;
		iW[i].params._hsli.h			=	iglb.aes.tree[FWINHSI].ob_height;
		iW[i].params._hsli.flags	=	iglb.aes.tree[FWINHSI].ob_flags;

		W[i].xwork=iW[i].mxwork+iW[i].params.x;
		W[i].ywork=iW[i].mywork+iW[i].params.y+1;
		_redrawWindow(i);
	}
}


/*******************************************************************************
	Adapts the RSC tree to the window parameters
*******************************************************************************/
void _makeform(int i)
{
	int		ha;
	OBJECT	*tree;

	if (i!=-1)
	{
		ha=W[i].handle;
		_maketop();
		if (W[i].smallflag==0)
		{
			iglb.aes.tree->ob_x=iW[i].mxwork;
			iglb.aes.tree->ob_y=iW[i].mywork;
			_obPutStr(iglb.aes.tree,FWINAME,W[i].name);
			iglb.aes.tree->ob_width				=	iW[i].params._box.w;
			iglb.aes.tree->ob_height			=	iW[i].params._box.h;
			iglb.aes.tree->ob_flags				=	iW[i].params._box.flags;
			iglb.aes.tree[FWINAME].ob_x		=	iW[i].params._name.x;
			iglb.aes.tree[FWINAME].ob_y		=	iW[i].params._name.y;
			iglb.aes.tree[FWINAME].ob_width	=	iW[i].params._name.w;
			iglb.aes.tree[FWINAME].ob_height	=	iW[i].params._name.h;
			iglb.aes.tree[FWINAME].ob_flags	=	iW[i].params._name.flags;
			iglb.aes.tree[FWINCLS].ob_x		=	iW[i].params._close.x;
			iglb.aes.tree[FWINCLS].ob_y		=	iW[i].params._close.y;
			iglb.aes.tree[FWINCLS].ob_flags	=	iW[i].params._close.flags;
			iglb.aes.tree[FWINPOP].ob_x		=	iW[i].params._menu.x;
			iglb.aes.tree[FWINPOP].ob_y		=	iW[i].params._menu.y;
			iglb.aes.tree[FWINPOP].ob_flags	=	iW[i].params._menu.flags;
			iglb.aes.tree[FWINCYC].ob_x		=	iW[i].params._cycle.x;
			iglb.aes.tree[FWINCYC].ob_y		=	iW[i].params._cycle.y;
			iglb.aes.tree[FWINCYC].ob_flags	=	iW[i].params._cycle.flags;
			iglb.aes.tree[FWINICO].ob_x		=	iW[i].params._icon.x;
			iglb.aes.tree[FWINICO].ob_y		=	iW[i].params._icon.y;
			iglb.aes.tree[FWINICO].ob_flags	=	iW[i].params._icon.flags;
			iglb.aes.tree[FWINFUL].ob_x		=	iW[i].params._full.x;
			iglb.aes.tree[FWINFUL].ob_y		=	iW[i].params._full.y;
			iglb.aes.tree[FWINFUL].ob_flags	=	iW[i].params._full.flags;
			iglb.aes.tree[FWINVSF].ob_x		=	iW[i].params._vslf.x;
			iglb.aes.tree[FWINVSF].ob_y		=	iW[i].params._vslf.y;
			iglb.aes.tree[FWINVSF].ob_width	=	iW[i].params._vslf.w;
			iglb.aes.tree[FWINVSF].ob_height	=	iW[i].params._vslf.h;
			iglb.aes.tree[FWINVSF].ob_flags	=	iW[i].params._vslf.flags;
			iglb.aes.tree[FWINVSP].ob_x		=	iW[i].params._vslp.x;
			iglb.aes.tree[FWINVSP].ob_y		=	iW[i].params._vslp.y;
			iglb.aes.tree[FWINVSP].ob_width	=	iW[i].params._vslp.w;
			iglb.aes.tree[FWINVSP].ob_height	=	iW[i].params._vslp.h;
			iglb.aes.tree[FWINVSP].ob_flags	=	iW[i].params._vslp.flags;
			iglb.aes.tree[FWINVSI].ob_x		=	iW[i].params._vsli.x;
			iglb.aes.tree[FWINVSI].ob_y		=	iW[i].params._vsli.y;
			iglb.aes.tree[FWINVSI].ob_width	=	iW[i].params._vsli.w;
			iglb.aes.tree[FWINVSI].ob_height	=	iW[i].params._vsli.h;
			iglb.aes.tree[FWINVSI].ob_flags	=	iW[i].params._vsli.flags;
			iglb.aes.tree[FWINUAR].ob_x		=	iW[i].params._uarr.x;
			iglb.aes.tree[FWINUAR].ob_y		=	iW[i].params._uarr.y;
			iglb.aes.tree[FWINUAR].ob_flags	=	iW[i].params._uarr.flags;
			iglb.aes.tree[FWINDAR].ob_x		=	iW[i].params._darr.x;
			iglb.aes.tree[FWINDAR].ob_y		=	iW[i].params._darr.y;
			iglb.aes.tree[FWINDAR].ob_flags	=	iW[i].params._darr.flags;
			iglb.aes.tree[FWINSIZ].ob_x		=	iW[i].params._size.x;
			iglb.aes.tree[FWINSIZ].ob_y		=	iW[i].params._size.y;
			iglb.aes.tree[FWINSIZ].ob_flags	=	iW[i].params._size.flags;
			iglb.aes.tree[FWINRAR].ob_x		=	iW[i].params._rarr.x;
			iglb.aes.tree[FWINRAR].ob_y		=	iW[i].params._rarr.y;
			iglb.aes.tree[FWINRAR].ob_flags	=	iW[i].params._rarr.flags;
			iglb.aes.tree[FWINLAR].ob_x		=	iW[i].params._larr.x;
			iglb.aes.tree[FWINLAR].ob_y		=	iW[i].params._larr.y;
			iglb.aes.tree[FWINLAR].ob_flags	=	iW[i].params._larr.flags;
			iglb.aes.tree[FWINHSF].ob_x		=	iW[i].params._hslf.x;
			iglb.aes.tree[FWINHSF].ob_y		=	iW[i].params._hslf.y;
			iglb.aes.tree[FWINHSF].ob_width	=	iW[i].params._hslf.w;
			iglb.aes.tree[FWINHSF].ob_height	=	iW[i].params._hslf.h;
			iglb.aes.tree[FWINHSF].ob_flags	=	iW[i].params._hslf.flags;
			iglb.aes.tree[FWINHSP].ob_x		=	iW[i].params._hslp.x;
			iglb.aes.tree[FWINHSP].ob_y		=	iW[i].params._hslp.y;
			iglb.aes.tree[FWINHSP].ob_width	=	iW[i].params._hslp.w;
			iglb.aes.tree[FWINHSP].ob_height	=	iW[i].params._hslp.h;
			iglb.aes.tree[FWINHSP].ob_flags	=	iW[i].params._hslp.flags;
			iglb.aes.tree[FWINHSI].ob_x		=	iW[i].params._hsli.x;
			iglb.aes.tree[FWINHSI].ob_y		=	iW[i].params._hsli.y;
			iglb.aes.tree[FWINHSI].ob_width	=	iW[i].params._hsli.w;
			iglb.aes.tree[FWINHSI].ob_height	=	iW[i].params._hsli.h;
			iglb.aes.tree[FWINHSI].ob_flags	=	iW[i].params._hsli.flags;
			if (iglb.aes.top==ha)
				iglb.aes.tree[FWINAME].ob_state|=SELECTED;
			else
				iglb.aes.tree[FWINAME].ob_state&=~SELECTED;
		}
		else
		{
			if (iglb.aes.Big_Icon)
				tree=iglb.rsc.head.trindex[BICN];
			else
				tree=iglb.rsc.head.trindex[LICN];
			tree->ob_x=iW[i].mxwsmall;
			tree->ob_y=iW[i].mywsmall;
			if (W[i].smallflag==1)
				_obPutStr(tree,1,W[i].sname);
			else
				_obPutStr(tree,1,glb.opt.Prog_Name);
			if (iglb.aes.top==W[i].handle)
				tree[1].ob_state|=SELECTED;
			else
				tree[1].ob_state&=~SELECTED;
		}
	}
}


/*******************************************************************************
	Draw the 'top' bar of the windows
*******************************************************************************/
void _maketop()
{
	OBJECT	*tree;
	GRECT		r,rd;
	int		n,i;
	int		top;

	wind_get(0,WF_TOP,&top);
	if (top!=iglb.aes.top)
		for (i=0;i<glb.opt.Win_Num;i++)
		{
			if ( W[i].handle>0 && ( W[i].handle==iglb.aes.top || W[i].handle==top ) )
			{
				if (W[i].smallflag==0)
				{
					tree=iglb.aes.tree;
					tree->ob_x=iW[i].mxwork;
					tree->ob_y=iW[i].mywork;
					_obPutStr(tree,FWINAME,W[i].name);
					if (top==W[i].handle)
						tree[FWINAME].ob_state|=SELECTED;
					else
						tree[FWINAME].ob_state&=~SELECTED;
					tree->ob_width				=	iW[i].params._box.w;
					tree->ob_height			=	iW[i].params._box.h;
					tree[FWINAME].ob_x		=	iW[i].params._name.x;
					tree[FWINAME].ob_y		=	iW[i].params._name.y;
					tree[FWINAME].ob_width	=	iW[i].params._name.w;
					tree[FWINAME].ob_height	=	iW[i].params._name.h;
					n=FWINAME;
				}
				else
				{
					if (iglb.aes.Big_Icon)
						tree=iglb.rsc.head.trindex[BICN];
					else
						tree=iglb.rsc.head.trindex[LICN];
					tree->ob_x=iW[i].mxwsmall;
					tree->ob_y=iW[i].mywsmall;
					_obPutStr(tree,1,W[i].sname);
					if (top==W[i].handle)
						tree[1].ob_state|=SELECTED;
					else
						tree[1].ob_state&=~SELECTED;
					n=1;
				}
			graf_mouse(M_OFF,0);
			wind_update(BEG_UPDATE);
			_coord(tree,n,TRUE,&rd.g_x,&rd.g_y,&rd.g_w,&rd.g_h);
			wind_get(W[i].handle,WF_FIRSTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
			while (r.g_w && r.g_h)
			{
				if (_rcIntersect(&rd,&r))
					objc_draw(tree,n,MAX_DEPTH,r.g_x,r.g_y,r.g_w,r.g_h);
				wind_get(W[i].handle,WF_NEXTXYWH,&r.g_x,&r.g_y,&r.g_w,&r.g_h);
			}
			wind_update(END_UPDATE);
			graf_mouse(M_ON,0);
		}
	}
	iglb.aes.top=top;
}


/*******************************************************************************
*******************************************************************************/
int	_winFindWin(int handle)
{
	int		i,num=-1;

	for (i=0;i<glb.opt.Win_Num;i++)
		if (W[i].handle==handle) num=i;
	return num;
}


/*******************************************************************************
*******************************************************************************/
int	_winFindId(int type,int id,int open)
{
	int		j;

	for (j=0;j<glb.opt.Win_Num;j++)
		if ( W[j].id==id && W[j].type==type )
			if ( !open || (open && W[j].handle>0) )
				return j;
	return -1;
}


/*******************************************************************************
*******************************************************************************/
void	_winRedraw(i,x,y,w,h)
{
	int		buf[8];

	buf[0]=WM_REDRAW;
	buf[1]=glb.aes.id;
	buf[2]=0;
	buf[3]=W[i].handle;
	if (x==0)
	{
		buf[4]=glb.aes.xdesk;
		buf[5]=glb.aes.ydesk;
		buf[6]=glb.aes.wdesk;
		buf[7]=glb.aes.hdesk;
	}
	else
	{
		buf[4]=x;
		buf[5]=y;
		buf[6]=w;
		buf[7]=h;
	}
	appl_write(glb.aes.id,16,buf);
}


/*******************************************************************************
*******************************************************************************/
void _winAlign(void)
{
	int	i,x,y,w=0,h=0,n=0;

	if (glb.opt.Auto_Icon)
	{
		for (i=0;i<glb.opt.Win_Num;i++)
			if (W[i].smallflag==1)
			{
				w=max(w,W[i].wsmall);
				h=max(h,W[i].hsmall);
				n+=1;
			}
		if (n)
		{
			if (!glb.opt.Rev_Verti)
			{
				if (!glb.opt.Rev_Horiz)
				{
					x=glb.aes.xdesk;
					y=glb.aes.ydesk;
					for (i=0;i<glb.opt.Win_Num;i++)
						if (W[i].smallflag==1)
						{
							if (W[i].xsmall!=x || W[i].ysmall!=y)
							{
								_move(i,x,y);
								_clearAesBuffer();
							}
							y+=h;
							if (y+h>glb.aes.ydesk+glb.aes.hdesk)
							{
								x=min(glb.aes.xdesk+glb.aes.wdesk-w,x+w);
								y=glb.aes.ydesk;
							}
						}
				}
				else
				{
					x=glb.aes.xdesk;
					y=glb.aes.ydesk+glb.aes.hdesk-h;
					for (i=0;i<glb.opt.Win_Num;i++)
						if (W[i].smallflag==1)
						{
							if (W[i].xsmall!=x || W[i].ysmall!=y)
							{
								_move(i,x,y);
								_clearAesBuffer();
							}
							y-=h;
							if (y<glb.aes.ydesk)
							{
								x=min(glb.aes.xdesk+glb.aes.wdesk-w,x+w);
								y=glb.aes.ydesk+glb.aes.hdesk-h;
							}
						}
				}
			}
			else
			{
				if (!glb.opt.Rev_Horiz)
				{
					x=glb.aes.xdesk+glb.aes.wdesk-w;
					y=glb.aes.ydesk;
					for (i=0;i<glb.opt.Win_Num;i++)
						if (W[i].smallflag==1)
						{
							if (W[i].xsmall!=x || W[i].ysmall!=y)
							{
								_move(i,x,y);
								_clearAesBuffer();
							}
							y+=h;
							if (y+h>glb.aes.ydesk+glb.aes.hdesk)
							{
								x=max(glb.aes.xdesk,x-w);
								y=glb.aes.ydesk;
							}
						}
				}
				else
				{
					x=glb.aes.xdesk+glb.aes.wdesk-w;
					y=glb.aes.ydesk+glb.aes.hdesk-h;
					for (i=0;i<glb.opt.Win_Num;i++)
						if (W[i].smallflag==1)
						{
							if (W[i].xsmall!=x || W[i].ysmall!=y)
							{
								_move(i,x,y);
								_clearAesBuffer();
							}
							y-=h;
							if (y<glb.aes.ydesk)
							{
								x=max(glb.aes.xdesk,x-w);
								y=glb.aes.ydesk+glb.aes.hdesk-h;
							}
						}
				}
			}
		}
	}
}


/*******************************************************************************
*******************************************************************************/
void _initModal()
{
	OBJECT	*tree;
	int		n,f=0;

	if (glb.aes.menu!=-1)
	{
		tree=glb.rsc.head.trindex[glb.aes.menu];
		n=-1;
		do
		{
			n+=1;
			if ((tree[n].ob_type&0xFF)==G_STRING && !(tree[n].ob_state&DISABLED) && f!=1)
				tree[n].ob_state|=DISABLED|STATE8;
			if (f==0 && tree[n].ob_type==G_STRING)
				f=1;
			if (f==1 && tree[n].ob_type==G_BOX)
				f=2;
		}	while (!(tree[n].ob_flags&LASTOB));
		_menuBar(glb.aes.menu,0);
		_menuBar(glb.aes.menu,1);
	}
}


/*******************************************************************************
*******************************************************************************/
void _exitModal()
{
	OBJECT	*tree;
	int		n;

	if (glb.aes.menu!=-1)
	{
		tree=glb.rsc.head.trindex[glb.aes.menu];
		n=-1;
		do
		{
			n+=1;
			if ((tree[n].ob_type&0xFF)==G_STRING && tree[n].ob_state&STATE8)
				tree[n].ob_state&=~(DISABLED|STATE8);
		}	while (!(tree[n].ob_flags&LASTOB));
		_menuBar(glb.aes.menu,0);
		_menuBar(glb.aes.menu,1);
	}
}


/*******************************************************************************
	Calculate work or win size with win or work size
*******************************************************************************/
void _winCalc(int type,int kind,int x,int y,int w,int h,int *outx,int *outy,int *outw,int *outh)
{
	int		WW,HH;
	int		nH=0,nD=0,nB=0,isB=0,isD=0;

	WW=16;
	HH=16/(1+glb.vdi.low);

	if (kind & wCLOSE)	{	nH++;	}
	if (kind & wMENU)		{	nH++;	}
	if (kind & wCYCLE)	{	nH++;	}
	if (kind & wICON)		{	nH++;	}
	if (kind & wFULL)		{	nH++;	}
	if (kind & wUARROW)	{	nD++;	isD=1;	}
	if (kind & wDARROW)	{	nD++;	isD=1;	}
	if (kind & wRARROW)	{	nB++;	isB=1;	}
	if (kind & wLARROW)	{	nB++;	isB=1;	}
	if (kind & wVSLIDE)
		isD=1;
	if (kind & wHSLIDE)
		isB=1;
	if (kind & wSIZE)
		if ( !isD && !isB )
			isD=1;

	if (type==WC_BORDER)
		wind_calc(WC_BORDER,0,x,y-HH-1,w+isD*(1+WW),h+(1+isB)*(1+HH),outx,outy,outw,outh);
	else if (type==WC_WORK)
	{
		wind_calc(WC_WORK,0,x,y,w,h,outx,outy,outw,outh);
		*outy+=HH+1;
		*outw-=isD*(1+WW);
		*outh-=(1+isB)*(1+HH);
	}
}
