/*****************************************************************
 * flread.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * flread.c: 
 *
 * CONTENTS
 *	read_bitmap (image, rfname)
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:17:56 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/flread.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 26-Aug-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.96) mlm@cs.cmu.edu
 *
 * 28-Nov-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <string.h>
# include "fbm.h"

# define GIF_MAGC	'G'	/* GIF format (CompuServe) */

long read_bitmap (image, fname)
FBM *image;
char *fname;
{ long peekch, result = 0;
  FILE *rfile;
  char magic[32], mlen = 0;

  /* Open the file if name given, otherwise assume stdin */
  if (fname == NULL || *fname == '\0' || !strcmp (fname, "-"))
  { rfile = stdin; }
  else
  { if ((rfile = fopen (fname, "rb")) == NULL)
    { perror (fname);  return (0); }
  }

  /* Guess image type by reading the first character */
  peekch = fgetc (rfile);
  
  magic[0] = peekch;
  mlen = 1;

  /* Dispatch on the magic character */
  switch ((int)peekch)
  { 
    case GIF_MAGC:	result = read_gif (image, rfile, magic, mlen); break;
    case EOF:		fprintf (stderr, "Empty file"); break;
    default:		fprintf (stderr, "Unknown magic char %03o\n", peekch);
  }
  
  fclose (rfile);
  
  return (result);
}
