/* fpfli.h */

/******
  Copyright (C) 1993 by Klaus Ehrenfried. 

  Permission to use, copy, modify, and distribute this software
  is hereby granted, provided that the above copyright notice appears 
  in all copies and that the software is available to all free of charge. 
  The author disclaims all warranties with regard to this software, 
  including all implied warranties of merchant-ability and fitness. 
  The code is simply distributed as it is.
*******/
#define UBYTE unsigned char
#define SHORT short
#define USHORT unsigned short
#define LONG long
#define ULONG unsigned long

#define FLI_MAX_X  1280
#define FLI_MAX_Y  1024
#define FLI_MAX_COLORS 256
#define FLI_MAX_FRAMES 4000
#define FLI_FILE_OLD_MAGIC 0xaf11	/* File header old Magic */
#define FLI_FILE_MAGIC 0xaf12		/* File header Magic */
#define FLI_FRAME_MAGIC 0xf1fa		/* Frame Magic */

#define FLI_FILE_HEADER_SIZE 128
#define FLI_FRAME_HEADER_SIZE 16

/* types of chunk in a fli_frame */
#define FLI_256_COLOR 4
#define FLI_DELTA 7
#define FLI_64_COLOR 11
#define FLI_LC	12
#define FLI_BLACK 13
#define FLI_BRUN 15
#define FLI_COPY 16

#define IOM_SBYTE  1
#define IOM_UBYTE  2
#define IOM_SWORD  3
#define IOM_UWORD  4
#define IOM_LONG  5

#define MAP_FIRST_FRAME 1
#define MAP_NEXT_FRAME 2
#define MAP_CLOSE_LOOP 3


/* #define BORDER_COLOR 0xFF */

/* external variables */

extern UBYTE *big_buffer;
extern UBYTE *pixel_chunk_buffer;
extern UBYTE color_chunk_buffer[3 * FLI_MAX_COLORS + 10];
extern long fli_width, fli_height, fli_size, fli_speed;
extern long border_color, double_buffer;
extern long Xorigin, Yorigin, Xorigin_flag, Yorigin_flag;
extern LONG map_color[FLI_MAX_COLORS], map_color_flag;
extern FILE *input, *output;
extern long old_format_flag;

/* prototypes */

long exitialise(long);

long get_image(char *fname, UBYTE *data, LONG color[], long without_data);

long make_fli();

long fli_write_frame(UBYTE *prepre_pixel,
	UBYTE *pre_pixel,
	UBYTE *curr_pixel,
	LONG curr_color[],
	long first_flag);

void add_bytes(UBYTE record[], long *ipos, long value, long mode);

long make_color_chunk(LONG color[], long first_flag);

long make_brun_chunk(UBYTE *image);

long make_delta_chunk(unsigned char *preprevious,
	unsigned char *previous,
	unsigned char *current);

long make_lc_chunk(unsigned char *preprevious,
	unsigned char *previous,
	unsigned char *current);

long get_next_line(FILE *input, char buff[], long len);
