/****************************************************************
 * fppmain.c
 ****************************************************************/

/******
  Copyright (C) 1993 by Klaus Ehrenfried. 

  Permission to use, copy, modify, and distribute this software
  is hereby granted, provided that the above copyright notice appears 
  in all copies and that the software is available to all free of charge. 
  The author disclaims all warranties with regard to this software, 
  including all implied warranties of merchant-ability and fitness. 
  The code is simply distributed as it is.
*******/

#include <stdio.h>
#include <stdlib.h>
#include <ext.h>
#include "fpfli.h"
/* external variables */

UBYTE *big_buffer;
UBYTE *pixel_chunk_buffer;
UBYTE color_chunk_buffer[3 * FLI_MAX_COLORS + 10];
long fli_width, fli_height, fli_size, fli_speed;
long border_color, double_buffer;
long Xorigin, Yorigin, Xorigin_flag, Yorigin_flag;
LONG map_color[FLI_MAX_COLORS], map_color_flag;
FILE *input, *output;
long old_format_flag;

static long fli_file_created;
static char *fliname;

/****************************************************************
 * print_usage
 ****************************************************************/

static long print_usage()
{
  fprintf(stderr,"Usage:\n");
  fprintf(stderr,"  fbm2fli [options] list-file fli-file\n");
  fprintf(stderr,"Valid options are:\n");
  fprintf(stderr,"  -b<color>    Define border color (default = 0)\n");
  fprintf(stderr,"  -D           Enable double buffer mode\n");
  fprintf(stderr,"  -m<file>     Use the color table from this file\n");
  fprintf(stderr,"  -O           Generate old format FLI\n");
  fprintf(stderr,"  -ox<x>       Set x position - no automatic adjustment\n");
  fprintf(stderr,"  -oy<y>       Set y position - no automatic adjustment\n");
  fprintf(stderr,"  -rx<width>   Horizontal resolution\n");
  fprintf(stderr,"  -ry<height>  Vertical resolution\n");
  fprintf(stderr,"  -s<speed>    Default animation speed\n");

  return(1);
}

/****************************************************************
 * exitialise
 ****************************************************************/

long exitialise(long error_flag)
{
    if (big_buffer != NULL) free(big_buffer);
    if (pixel_chunk_buffer != NULL) free(pixel_chunk_buffer);

    if (output != NULL) fclose(output);
    if (input != NULL) fclose(input);

    if (error_flag != 0)
    {
	if (fli_file_created == 1)
	{
	    fprintf(stderr,"Remove fli-file %s\n",fliname);
	    (void) remove(fliname);
	}
	fprintf(stderr,"abnormal termination\n");
    }
    return(1);
}

/****************************************************************
 * main
 ****************************************************************/

void
main (int argc, char *argv[])
{
  FILE *fopen();
  char *listfile, *ppa, *map_file;
  struct stat statbuf;
  char abuff[10];
  long error_flag, answer_flag, big_size, max_chunk_size;
  long x_resolution, y_resolution, s_speed;
  long i, itest;

  listfile=NULL;
  fliname=NULL;
  map_file=NULL;
  input=0;
  output=0;

  fli_file_created=0;

  big_buffer=NULL;
  pixel_chunk_buffer=NULL;

  error_flag=0;

  Xorigin=0;
  Xorigin_flag=0;
  Yorigin=0;
  Yorigin_flag=0;

  x_resolution=-1;
  y_resolution=-1;
  s_speed=-1;

  border_color=0;
  map_color_flag=0;
  double_buffer=0;
  old_format_flag=0;

  for (i=1; i < argc; i++)
    {
      ppa=argv[i];	
      if (ppa[0] == '-')
	{
	  switch (ppa[1])
	    {
	    case 'b':
	      border_color = atoi(&ppa[2]);
	      break;
	    case 'D':
	      double_buffer=1;
	      break;
	    case 'm':
	      map_file = &ppa[2];
	      map_color_flag=1;
	      break;
	    case 'O':
	      old_format_flag=1;
	      break;
	    case 'o':
	      if (ppa[2] == 'x')
		{
		  Xorigin = atoi(&ppa[3]);
		  Xorigin_flag = 1;
		}
	      else if (ppa[2] == 'y')
		{
		  Yorigin = atoi(&ppa[3]);
		  Yorigin_flag = 1;
		}
	      else
		goto invalid_option;
	      break;
	    case 'r':
	      if (ppa[2] == 'x')
		x_resolution = atoi(&ppa[3]);
	      else if (ppa[2] == 'y')
		y_resolution = atoi(&ppa[3]);
	      else
		goto invalid_option;
	      break;
	    case 's':
	      s_speed = atoi(&ppa[2]);
	      break;
	    invalid_option:
	    default:
	      fprintf(stderr,"Invalid option: %s\n",ppa);
	      exit(1);
	    }
	}
    }

    for (i=1; i < argc; i++)
      {
	ppa=argv[i];	
	if (ppa[0] != '-')
	  {
	    if (listfile == NULL)
	      {
		listfile=argv[i];
	      }
	    else if (fliname == NULL)
	      {
		fliname=argv[i];
	      }
	    else
	      {
		print_usage();
		exit(1);
	      }
	  }
      }

    if ((listfile == NULL) || (fliname == NULL))
      {
	print_usage();
	exit(1);
      }

    if (old_format_flag == 1)
      {
	fli_width=320;
	fli_height=200;
	fli_speed=5;
      }
    else
      {
	fli_width=640;
	fli_height=480;
	fli_speed=72;
      }

    if (x_resolution >= 10)
      {
	fli_width=x_resolution;
	if ((fli_width % 2) == 1) fli_width++;
	if (fli_width > FLI_MAX_X) fli_width=FLI_MAX_X;
      }

    if (y_resolution >= 10)
      {
	fli_height=y_resolution;
	if (fli_height > FLI_MAX_Y) fli_height=FLI_MAX_Y;
      }

    fli_size = fli_width * fli_height;

    if (s_speed >= 0)
      fli_speed = s_speed;

    if (map_color_flag == 1)
    {
	fprintf(stdout,"Take color table from file %s\n",map_file);
	get_image(map_file, (UBYTE *)0, map_color, 1);
    }

    if ((input = fopen(listfile, "r")) == NULL)
    {
        fprintf(stderr,"Error opening list-file %s\n",listfile);
	exit(1);
    }

    if (stat(fliname, &statbuf) == 0)
    {
        fprintf(stderr,"%s already exists\n",fliname);
	answer_flag=0;
	while (answer_flag == 0)
	{
	    fprintf(stdout," overwrite %s (y/n) ",fliname);
	    fflush(stdout);
	    if ((itest=get_next_line(stdin, abuff, 2)) == 1)
	    {
		if ((abuff[0] == 'y') || (abuff[0] == 'Y'))
		    answer_flag=1;
		else if ((abuff[0] == 'n') || (abuff[0] == 'N'))
		    answer_flag=2;
	    }
	    /* printf(" %ld :: %ld %ld %ld %ld\n",
		itest, abuff[0], abuff[1], abuff[2], abuff[3]); */
	}
	if (answer_flag != 1)
	{
	    exitialise(1);
	    exit(1);
	}
    }

    if ((output = fopen(fliname, "wb")) == NULL)
    {
        fprintf(stderr,"Error opening fli-file %s\n",fliname);
	exitialise(1);
	exit(1);
    }
    fli_file_created = 1;

    if (border_color > 0x00FF) border_color=0x00FF;
    if (border_color < 0x0000) border_color=0x0000;

    fprintf(stdout,"Resolution: %ldx%ld\n",fli_width,fli_height);
    fprintf(stdout,"Origin:     %ldx%ld\n",Yorigin,Xorigin);
    fprintf(stdout,"Speed:      %ld\n",fli_speed);

    max_chunk_size=fli_height*(2*fli_width+10)+1024;

    pixel_chunk_buffer = malloc(max_chunk_size);
    if (pixel_chunk_buffer == NULL)
    {
        fprintf(stderr,"Error: cannot allocate %ld bytes\n",max_chunk_size);
	exitialise(1);
	exit(1);
    }

    big_size = 5 * fli_size;
    big_buffer = malloc(big_size);
    if (big_buffer == NULL)
    {
        fprintf(stderr,"Error: cannot allocate %ld bytes\n",big_size);
	exitialise(1);
	exit(1);
    }

    make_fli();

    exitialise(0);
    exit(0);
}
