program FileLister; {$X+}
										{ Idee aus TP/Win-ObjectWindows (Sybex) }

uses

	Dos,OProcs,OTypes,Objects;

type

	NameExtStr = string[12];
	PFileList  = ^TFileList;

	TFileList = object(TStrCollection)
		constructor Init(Path: PathStr; Attr: byte; SubDirs: boolean);
		function First: string; virtual;
		function Next: string; virtual;
		procedure PrintAll; virtual;
		private
		Counter: integer
	end;


{ *** Object TFILELIST *** }

constructor TFileList.Init(Path: PathStr; Attr: byte; SubDirs: boolean);

	procedure BuildList(Path: PathStr);
		var Search: SearchRec;
		    Dir   : DirStr;
		    Name  : NameStr;
		    Ext   : ExtStr;

		function ValidDir: boolean;

			begin
				ValidDir:=(Search.Name<>'.') and
									(Search.Name<>'..') and
									(Search.Attr=Directory)
			end;

		begin
			Attr:=Attr and AnyFile;
			FSplit(FExpand(Path),Dir,Name,Ext);
			Dos.FindFirst(Path,Attr,Search);
			while DosError=0 do
				begin
					Insert(ChrNew(Dir+Search.Name));
					FindNext(Search)
				end;
			if SubDirs then
				begin
					Dos.FindFirst(Dir+'*.*',Directory,Search);
					while DosError=0 do
						begin
							if ValidDir then BuildList(Dir+Search.Name+'\'+Name+Ext);
							FindNext(Search)
						end
				end
		end;

	begin
		if not(TStringCollection.Init(100,10)) then fail;
		BuildList(Path);
		Counter:=0
	end;


function TFileList.First: string;

	begin
		Counter:=0;
		First:=Next
	end;


function TFileList.Next: string;

	begin
		if Counter>=Count then Next:=''
		else
			begin
				if At(Counter)=nil then Next:=''
				else
					Next:=PString(At(Counter))^;
				inc(Counter)
			end
	end;


procedure TFileList.PrintAll;

	procedure Print(p: PChar);

		begin
			writeln(p)
		end;

	begin
		ForEach(@Print)
	end;

{ *** TFILELIST *** }


	var FileList: PFileList;
	    i       : longint;


begin
	clrscr;
	FileList:=new(PFileList,Init('C:\*.*',ReadOnly,true));
	if FileList<>nil then
		begin
			FileList^.PrintAll;
			writeln;
			writeln(FileList^.Count,' Dateien');
			dispose(FileList,Done)
		end;
	readkey
end.